// FrotzCE.h : main header file for the FROTZCE application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

#define FROTZCEAPP ((CFrotzCEApp *) AfxGetApp())

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp:
// See FrotzCE.cpp for the implementation of this class
//

class CFrotzCEApp : public CWinApp
{
private:
	CWinThread*
		// Thread pointer for Z machine thread
		m_pcZThread;

public:
	BOOL
		// Flag to indicate if OS interface is initialised
		m_bInitialised;

	BOOL
		// Flag to indicate if Z machine is running
		m_bZmachineRunning;

	int
		// Font height and width to use as default
		m_nFontHeight,
		m_nFontWidth;

	int
		// Default style to use
		m_nDefaultStyle;

	BOOL
		// Flag to indicate if text style support should be enabled
		m_bUseStyles;

	BOOL
		// Flag to indicate if colour support should be enabled
		m_bUseColours;

	BOOL
		// Flag to indicate if euro chars should be remapped
		m_bUseEuroChars;

	BOOL
		// Flag to indicate if game should run with "Tandy" bit set
		m_bTandy;

	CString
		// Default directory to open files in
		m_strDefaultDir;

	char
		// Current story file name
		m_achStoryFile[256];

public:
	CFrotzCEApp(LPCTSTR lpszAppName, LPCTSTR lpszHelpName);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFrotzCEApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation
	void 
		// Start Z machine thread
		StartZMachine( LPVOID pParam=NULL );

	//{{AFX_MSG(CFrotzCEApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpen( ); 
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
