#include <windows.h>
#include <stdio.h>

#include "pix2gif.h"


//FILE *Data = NULL;
BYTE *Img = NULL;
typedef struct {
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[16];
} BITMAPINFO16;
BITMAPINFO16 bmi;
char sInfo[1024];

short curImage = 0;
unsigned char numImages;
pdirectory_t *directory = NULL;
FILE *fp = NULL;

void imgLoad (const char *fileName);
void write_bmp (image_t *Img, int n);

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[ ] = "PixView";

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */
    OPENFILENAME ofn;
    char szFilter[128];
    char szFileName[256];
    int Cnt;

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default color as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "PixView - Use PgUp and PgDn to browse...",       /* Title Text */
           WS_EX_TOPMOST | WS_SYSMENU | WS_MINIMIZEBOX, // Window style
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           320,                 /* The programs width */
           240,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    MoveWindow (hwnd,
        GetDeviceCaps (GetDC (hwnd), HORZRES) / 2 - 160,
        GetDeviceCaps (GetDC (hwnd), VERTRES) / 2 - 120,
        320,
        240,
        TRUE);

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nFunsterStil);

    // Default info text
    sprintf (sInfo, "No image loaded");

    //*** Load a graphics file ***
    strcpy (szFilter, "Z-Picture files (*.MG1, *.EG1)|*.MG1;*.EG1|All files (*.*)|*.*|\0");
    for (Cnt = 0; Cnt < strlen (szFilter); ++Cnt)
        if (szFilter[Cnt] == '|')
            szFilter[Cnt] = 0;
    memset (szFileName, 0, 256);
    memset (&ofn, 0, sizeof (OPENFILENAME));
    ofn.lStructSize = sizeof (OPENFILENAME);
    ofn.hwndOwner = hwnd;
    ofn.hInstance = hThisInstance;
    ofn.lpstrFilter = szFilter;
    ofn.lpstrFile = szFileName;
    ofn.nMaxFile = 256;
    ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
    

    if (GetOpenFileName (&ofn))
    {
        imgLoad (szFileName);
        process_image (fp, &directory[curImage]);

        /* Run the message loop. It will run until GetMessage() returns 0 */
        while (GetMessage (&messages, NULL, 0, 0))
        {
            /* Translate virtual-key messages into character messages */
            TranslateMessage(&messages);
            /* Send message to WindowProcedure */
            DispatchMessage(&messages);
        }
    }
    else
    {
        char Msg[128], szError[128];
        FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM,
            NULL,
            GetLastError (),
            0,
            szError,
            128,
            NULL);
        sprintf (Msg, "Error #%d", GetLastError ());

        MessageBox (hwnd, szError, Msg, MB_APPLMODAL | MB_ICONSTOP);
    }

    if (directory)
        free (directory);
    if (Img)
        free (Img);
    if (fp)
        fclose (fp);

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}



void write_bmp (image_t *imgData, int n)
{
    long Cnt;
    int X, Y;
    DWORD numBytes;
    DWORD rowLen = imgData->width;

    // Adjust image physical size
    while (rowLen % 8)
        rowLen++;
    numBytes = (rowLen * imgData->height) / 2;

    // Set bitmap info properly
    bmi.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth = imgData->width;
    bmi.bmiHeader.biHeight = imgData->height;
    bmi.bmiHeader.biPlanes = 1;
    bmi.bmiHeader.biBitCount = 4;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biSizeImage = numBytes;
    bmi.bmiHeader.biXPelsPerMeter = 2834;
    bmi.bmiHeader.biYPelsPerMeter = 2834;
    bmi.bmiHeader.biClrUsed = 16;
    bmi.bmiHeader.biClrImportant = 0;

    // Display some info
    sprintf (sInfo, "Image %d is %dx%d, %dbpp",
        n,
        bmi.bmiHeader.biWidth,
        bmi.bmiHeader.biHeight,
        bmi.bmiHeader.biBitCount);

    // Store palette info
    for (Cnt = 0; Cnt < 16; ++Cnt)
    {
        bmi.bmiColors[Cnt].rgbBlue = imgData->colourmap[Cnt][BLUE];
        bmi.bmiColors[Cnt].rgbRed = imgData->colourmap[Cnt][RED];
        bmi.bmiColors[Cnt].rgbGreen = imgData->colourmap[Cnt][GREEN];
        bmi.bmiColors[Cnt].rgbReserved = 0;
    }

    // (Re)allocate image data memory
    if (Img)
        free (Img);
    Img = (BYTE*)malloc (numBytes);

    Cnt = 0;
    // Store pix image data into bitmap image data in the correct order
    for (Y = imgData->height - 1; Y >= 0; --Y)
    {
        for (X = 0; X < rowLen; ++X)
        {
            unsigned char Pix = 0;
            if (X < imgData->width)
                Pix = (imgData->image[(Y * imgData->width) + X] << 4);
            ++X;
            if (X < imgData->width)
                Pix |= (imgData->image[(Y * imgData->width) + X] & 0x0F);

            Img[Cnt++] = Pix;
        }
    }
}



void imgLoad (const char *fileName)
{
    int Cnt;
    //FILE *fp;
    header_t header;
    //pdirectory_t *directory;

    if ((fp = fopen (fileName, "rb")) == NULL)
    {
        char Msg[256];
        sprintf ("Could not load image file \"%s\".", fileName);
        MessageBox (GetActiveWindow (), Msg, "Error",
            MB_APPLMODAL | MB_ICONSTOP);
    	return;
    }
    
    fread (&header.part, 1, 1, fp);
    fread (&header.flags, 1, 1, fp);
    fread (&header.unknown1, 2, 1, fp);
    fread (&header.images, 2, 1, fp);
    fread (&header.unknown2, 2, 1, fp);
    fread (&header.dir_size, 1, 1, fp);
    fread (&header.unknown3, 1, 1, fp);
    fread (&header.checksum, 2, 1, fp);
    fread (&header.unknown4, 2, 1, fp);
    fread (&header.version, 2, 1, fp);

    //sprintf (sInfo, "File contains %d images. Version %d, Checksum = %x",
    //    header.images, header.version, header.checksum);

    if ((directory = (pdirectory_t *) calloc ((size_t) header.images,
            sizeof (pdirectory_t))) == NULL)
    {
        MessageBox (GetActiveWindow (), "Out of memory.", "Error",
            MB_APPLMODAL | MB_ICONSTOP);
        fclose (fp);
        return;
    }

    numImages = header.images;

    for (Cnt = 0; (unsigned int) Cnt < (unsigned int) header.images; Cnt++)
    {
        fread (&directory[Cnt].image_number, 2, 1, fp);
        fread (&directory[Cnt].image_width, 2, 1, fp);
    	fread (&directory[Cnt].image_height, 2, 1, fp);
    	fread (&directory[Cnt].image_flags, 2, 1, fp);
    	directory[Cnt].image_data_addr = (unsigned long) fgetc (fp) << 16;
    	directory[Cnt].image_data_addr += (unsigned long) fgetc (fp) << 8;
    	directory[Cnt].image_data_addr += (unsigned long) fgetc (fp);
	    if ((unsigned int) header.dir_size == 14)
        {
            directory[Cnt].image_cm_addr = (unsigned long) fgetc (fp) << 16;
	        directory[Cnt].image_cm_addr += (unsigned long) fgetc (fp) << 8;
	        directory[Cnt].image_cm_addr += (unsigned long) fgetc (fp);
	    }
        else
        {
            directory[Cnt].image_cm_addr = 0;
	        (void) fgetc (fp);
        }
    }

	//process_image (fp, &directory[0]);

/*
    if (directory)
        free (directory);
    if (fp)
        fclose (fp);
*/
}



/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    PAINTSTRUCT ps;
    HDC hdc;

    switch (message)                  /* handle the messages */
    {
        case WM_PAINT:
            hdc = BeginPaint (hwnd, &ps);

            if (Img)
            //if (StretchDIBits (hdc, 0, 0, 320, 200, 0, 0, 320, 200,
            //    Img, (BITMAPINFO*)&bmi, DIB_RGB_COLORS, SRCCOPY) == GDI_ERROR)
            if (SetDIBitsToDevice (hdc,
                0, 0,   // X and Y of dest rect topleft corner
                bmi.bmiHeader.biWidth,  // Src rectangle width and height
                bmi.bmiHeader.biHeight,
                0, 0, // X and Y of src rect bottomleft corner
                0, bmi.bmiHeader.biHeight, // First scanline and total scanlines
                Img, (BITMAPINFO*)&bmi, DIB_RGB_COLORS) == GDI_ERROR)
                {
                    char Msg[32];
                    sprintf (Msg, "Error #%d", GetLastError ());
                    MessageBox (hwnd, "Could not open file.", Msg, MB_ICONSTOP);
                    SendMessage (hwnd, WM_DESTROY, 0, 0);
                }

            TextOut (hdc, 0, ps.rcPaint.bottom - 16, sInfo, strlen (sInfo));

            EndPaint (hwnd, &ps);
            break;

        case WM_KEYUP:
            switch ((int)wParam)
            {
                case 0x21:  // PgUp
                    MessageBeep (MB_OK);
                    if (--curImage >= 0)
                        if (directory[curImage].image_data_addr)
                            process_image (fp, &directory[curImage]);
                    // Update view
                    {
                        RECT rc;
                        GetClientRect (hwnd, &rc);
                        InvalidateRect (hwnd, &rc, TRUE);
                    }
                    //PostMessage (hwnd, WM_PAINT, 0, 0);
                    return TRUE;

                case 0x22:  // PgDn
                    MessageBeep (MB_OK);
                    if (++curImage < numImages)
                        if (directory[curImage].image_data_addr)
                            process_image (fp, &directory[curImage]);
                    // Update view
                    {
                        RECT rc;
                        GetClientRect (hwnd, &rc);
                        InvalidateRect (hwnd, &rc, TRUE);
                    }
                    //PostMessage (hwnd, WM_PAINT, 0, 0);
                    return TRUE;
            }
            break;

        case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;

        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}
