/*
	FrosOS_Text.cpp: OS dependant functions called by the Z-Machine.
	Copyright (C) 2005 Fabio Concas

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/



#include "StdAfx.h"

#include "Frostz.h"



extern "C" {
#include "FROTZ/Frotz.h"



extern char euro_substitute[];



//****************************************************************************
// os_set_colour
//****************************************************************************
void os_set_colour (int fg, int bg) 
{
	Application.SetTextColour (fg, bg);
}



//****************************************************************************
// os_font_data
//****************************************************************************
int  	os_font_data (int n, int *height, int *width)
{
	/*** DEBUG ***
	if (n != TEXT_FONT)
	{
		unsigned short wMsg[64];
		wsprintf (wMsg, L"Font Data Req.: %d (%dx%d)", n, *width, *height);
		MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
		Application.GoFullScreen ();
	}
	/*************/

	if (n == GRAPHICS_FONT)
	{
		//@@@ *height = 11;
		//@@@ *width = 4;
		return TRUE;
	}
	else if (n == TEXT_FONT)
	{
		//*height = Application.FontHeight;
		//*width = Application.FontWidth;

		return TRUE;
	}

	return FALSE;
}



//****************************************************************************
// os_cursor_off
//	Turn off cursor
//****************************************************************************
void os_cursor_off (void) 
{
	Application.SetCursorState( false );
}



//****************************************************************************
// os_cursor_on
//	Turn on cursor
//****************************************************************************
void os_cursor_on (void)
{
	Application.SetCursorState( true );
}



//****************************************************************************
// os_set_cursor
//	Set the cursor position
//****************************************************************************
void os_set_cursor (int y, int x) 
{
	Application.SetCursorPos (--y, --x);
}
//****************************************************************************



//****************************************************************************
// os_more_prompt
//****************************************************************************
void os_more_prompt (void) 
{
	int nRow, nCol;

	// Save cursor position
	Application.GetCursorPos (&nRow, &nCol);

	// Hide cursor
	os_cursor_off ();

	// Display prompt
	os_set_text_style (REVERSE_STYLE);
	os_display_string ((unsigned char *)"[MORE]");
	os_set_text_style (NORMAL_STYLE);
	os_read_key ( 0 );

	// Show cursor
	os_cursor_on ();

	// Remove prompt
	Application.SetCursorPos (nRow, nCol);
	os_display_string ((unsigned char *)"      ");
	Application.SetCursorPos (nRow, nCol);
}



//****************************************************************************
// os_display_char
//****************************************************************************
void os_display_char (unsigned char c)
{
	/*European char?
    if (Application.UseEuroChars && c >= EURO_MIN && c <= EURO_MAX)
	{
		int c1 = euro_substitute[2 * (c - EURO_MIN)];
		int c2 = euro_substitute[2 * (c - EURO_MIN) + 1];

	    os_display_char (c1);

	    if (c2 != ' ') c = c2;
	    else return;
	}
	*/

	// Display char and update screen
	Application.DisplayChar ((char) c);
}



//****************************************************************************
// os_set_font
//	Set the font for text output. The interpreter takes care not to
//	choose fonts which aren't supported by the interface.
//****************************************************************************
void 	os_set_font (int font)
{
	/*** DEBUG ***
	unsigned short wMsg[32];
	wsprintf (wMsg, L"Font Req.: %d", font);
	MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
	//Application.GoFullScreen ();
	/*************/
	Application.SetTextFont (font);
}
//****************************************************************************



//****************************************************************************
// os_set_text_style
//	Set the text style
//****************************************************************************
void	os_set_text_style (int style) 
{
	Application.SetTextStyle (style);
}
//****************************************************************************



//****************************************************************************
// os_display_string
//	Display string
//****************************************************************************
void os_display_string (const unsigned char *s)
{
	Application.DisplayString ((char*)s);
}
//****************************************************************************



//****************************************************************************
// os_char_width
//****************************************************************************
int os_char_width (unsigned char c)
{
	// Gap between sentences?
    if (c == 9)	return 2;
	// Paragraph indentation?
    else if (c == 11) return 3;
	/* European char?
    else if (Application.UseEuroChars && c >= EURO_MIN && c <= EURO_MAX)
		return (euro_substitute[2 * (c - EURO_MIN) + 1] == ' ') ? 1 : 2;
	*/
    else return 1;
}
//****************************************************************************



//****************************************************************************
// os_string_width
//****************************************************************************
int os_string_width (const unsigned char *s)
{
int width;

	// Process string
    for (width = 0; *s; s++) 
	{
		if (*s != ZC_NEW_FONT && *s != ZC_NEW_STYLE)
		{
			// Get width of character
			width += os_char_width ((unsigned char) *s);
		}
		else s++;
    }

    return width;
}
//****************************************************************************

}	// extern "C"
