// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//77
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

/*
	0 	All attributes off
	1 	Bold
	2 	Faint (not widely supported)
	3 	Italic (not widely supported)
	4 	Underlined (not widely supported)
	5 	Blink
	6 	Rapid blink (MS-DOS ANSI.SYS)
	7 	Reverse video
	8 	Concealed (Not widely supported)
	9 	Crossed out (Not widely supported)
	22 	Normal intensity - not bold and not faint
	24 	Not underlined
	30 	Black foreground
	31 	Red foreground
	32 	Green foreground
	33 	Yellow foreground
	34 	Blue foreground
	35 	Magenta foreground
	36 	Cyan foreground
	37 	White foreground
	39 	Default foreground
	40 	Black background
	41 	Red background
	42 	Green background
	43 	Yellow background
	44 	Blue background
	45 	Magenta background
	46 	Cyan background
	47 	White background
	48 	Subscript (nonstandard)
	49 	Default background (or superscript - nonstandard)
*/


#include <ctype.h>
#include <PA9.h>

#include "frotz.h"

#include "main.h"
#include "draw.h"


// ----------------------------------------------------------------------------
// externals
// ----------------------------------------------------------------------------

extern void*		memcpy(void *dest, const void *src, size_t n);
extern void 		SetFatalMessage( char* _x );
extern bool 		GetGameDataFromName( char* _name, void** _dataPtr, int*  _dataSize );

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

#define 			NB_FILES_MAX			16

// ----------------------------------------------------------------------------
// global variables
// ----------------------------------------------------------------------------

char 				gStatusChars[80] 		= "";
int					nStatusChars			= 0;
bool				trapStatusChars			= false;


char 				gMainChars[1024] 		= "";
int					nMainChars				= 0;
bool				trapMainChars			= true;


int 				errorY 					= 20;
int 				cursorPositionX 		= 0;
int 				cursorPositionY 		= 0;


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ZFILES management
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

ZFILE					FPS[NB_FILES_MAX];
unsigned char*		FILES[NB_FILES_MAX];
unsigned char*		FILEPOINTER[NB_FILES_MAX];
unsigned char*		FILEEOF[NB_FILES_MAX];
int						FILELENGTH[NB_FILES_MAX];
int						NBOPENFILES;

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------


ZFILE* OPEN_FILE( char*_ptr, int size, int *_size )
{
	FILES[NBOPENFILES] 			= FILEPOINTER[NBOPENFILES] 	= (void*)_ptr;
	FILELENGTH[NBOPENFILES] 	= size;
	FILEEOF[NBOPENFILES]		= FILES[NBOPENFILES] + FILELENGTH[NBOPENFILES];
	FPS[NBOPENFILES]			= NBOPENFILES;
	*_size = size;
	NBOPENFILES ++;
	return &(FPS[NBOPENFILES-1]);
}

ZFILE* os_path_open( char* _name, char* y, int *_storysize )
{
	void*	data;
	int		dataSize;
	
	if ( GetGameDataFromName( _name, &data, &dataSize ) )
	{
		return OPEN_FILE( data,	dataSize, _storysize );	
	}

	return NULL; 
}

char ZFGETC( ZFILE* stream )
{
	if ( FILEPOINTER[*stream] == FILEEOF[*stream] )
	{
		return EOF;
	}
	char c = *(FILEPOINTER[*stream]);
	FILEPOINTER[*stream] ++;
	return c;
}

char ZFPUTC( ZFILE* stream, char _c )
{
	if ( FILEPOINTER[*stream] == FILEEOF[*stream] )
	{
		return EOF;
	}
	*(FILEPOINTER[*stream]) = _c;
	FILEPOINTER[*stream]++;
	return _c;
}

int	ZFSEEK(ZFILE* stream, long offset, int whence)
{
	switch(whence)
	{
	case SEEK_SET :
		FILEPOINTER[*stream] = FILES[*stream] + offset;
		break;
	case SEEK_CUR :
		FILEPOINTER[*stream] = FILEPOINTER[*stream] + offset;
		break;
	case SEEK_END : 
		FILEPOINTER[*stream] = FILEPOINTER[*stream] + FILELENGTH[*stream] - 1 - offset;
		break;
	}
	return 0;
}

long ZFTELL( ZFILE* stream )
{
	return (long)(FILEPOINTER[*stream]) - (long)(FILES[*stream]);
}

int ZFCLOSE ( ZFILE *stream )
{
	FILEPOINTER[*stream] = FILES[*stream];
	return 0;
}

void ZREWIND( ZFILE* stream )
{
	FILEPOINTER[*stream] = FILES[*stream];
}

int ZFERROR( ZFILE *stream )
{
	return 0;
}

int ZFEOF( ZFILE* stream )
{
	return ((long)FILEPOINTER[*stream]) == (long)(FILES[*stream]);
}

int ZUNGETC( int x, ZFILE* stream )
{
	return EOF;
}

size_t ZFREAD(void *ptr, size_t size, size_t nmemb, ZFILE* stream)
{
	int	nbbytes = size*nmemb;
	memcpy( (unsigned char*)ptr, (unsigned char*)(FILEPOINTER[*stream]), nbbytes );
	FILEPOINTER[*stream] += nbbytes;
	return nbbytes;
}

size_t ZFWRITE(const  void  *ptr,  size_t  size,  size_t  nmemb,  ZFILE* stream)
{
	os_fatal ( "FWRITE : not implemented" );
	return 0;
}


/*

int ZFGETPOS(ZFILE* stream, fpos_t *pos)
{
	*pos = (long)(FILEPOINTER[*stream]) - (long)(FILES[*stream]);
	return 0;
}

int ZFSETPOS(ZFILE* stream, fpos_t *pos)
{
	ZFSEEK(stream, *pos, SEEK_SET);
	return 0;
}
*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// end of ZFILES management
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------



// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// characters trapping
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// TRAP STATUS CHARS
// ----------------------------------------------------------------------------



void StartTrapStatusChars( void )
{
	trapStatusChars				= true;
	nStatusChars 				= 0;
	gStatusChars[nStatusChars]	= 0;
}

void StopTrapStatusChars( void )
{
	trapStatusChars				= false;
}

void TrapStatusChar( char _c )
{
	if ( (_c == ' ') && ( (nStatusChars==0) || ((nStatusChars>0) && gStatusChars[nStatusChars] == ' ' )) )
		return;

	if ( nStatusChars >= 79 )
		return;

	gStatusChars[nStatusChars] = _c;
	nStatusChars 				++;
	gStatusChars[nStatusChars] = '\0';
}

// ----------------------------------------------------------------------------
// TRAP MESSAGE CHARS
// ----------------------------------------------------------------------------

void StartTrapMainChars( void )
{
	trapMainChars				= true;
	nMainChars 					= 0;
	gMainChars[nMainChars]		= 0;
}

void StopTrapMainChars( void )
{
	trapMainChars				= false;
}

void TrapMainChar( char _c )
{
	if ( (_c == ' ') && ( (nMainChars==0) || ((nMainChars>0) && gMainChars[nMainChars] == ' ' )) )
		return;
		
	if ( nMainChars >= 999 )
	{
		nMainChars --;
		int i;
		for( i=0; i<nMainChars; i++ )
		{
			gMainChars[i] = gMainChars[i+1];  
		}
	}

	gMainChars[nMainChars] = _c;
	nMainChars 				++;
	gMainChars[nMainChars] = '\0';
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// end of characters trapping
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------

void os_fatal (const char * _x )
{
	PRINT_STRING( 1, (char*)_x, 104, errorY, 32, 7, 100); if (errorY<172) errorY += 8;
	SetFatalMessage( (char*)_x );
}

// ----------------------------------------------------------------------------

void os_beep (int x)
{
}

// ----------------------------------------------------------------------------

int os_buffer_screen (int x )
{
WAIT_MSG( "os_buffer_screen %d", x );
	return 0;
}

// ----------------------------------------------------------------------------

int os_char_width (zchar z)
{
	if ( GetFixedFont() || (h_flags & FIXED_FONT_FLAG) )
		return CHAR_WIDTH;

	switch( z )
	{
		case 'i' : 
		case 'l' : 
		case '\'': return 2;

		case ' ' : 
		case '.' : 
		case ',' : 
		case '(' : 
		case ')' : 
		case '[' : 
		case ']' : 
		case 'f' : 
		case 't' : 
		case 'j' : 
		case 'I' : 
		//case 'J' : 
		case 'L' : return 4;
		
		//case '\t' : return 16;
	}

	return CHAR_WIDTH;
}

// ----------------------------------------------------------------------------

int os_check_unicode (int x, zword y)
{
	return 0;
}

// ----------------------------------------------------------------------------
/*
static char trapped[80];
bool Trap( zchar c, char* str)
{
	static int trappos = 0;
	if  (c == ' ' ) { trappos = 0; }
	else			{ 
		trapped[trappos] = c; trappos ++ ; trapped[trappos] = '\0';
		if ( !strcmp( trapped, str ) ) return true;
	}
	return false;
}
*/
// ----------------------------------------------------------------------------

void os_display_char (zchar c)
{

	// start DS patch : trap the output characters, for data save or completion
	if ( cursorPositionY == 1 )
	{
		if ( cursorPositionX == 1 )
		{
			StartTrapStatusChars();
		}
	}
	else
	{
		StopTrapStatusChars();
	}

	if ( trapStatusChars )
	{
		//TrapStatusChar( isalnum(c) ? c : ' ' );
		TrapStatusChar( c );
	}
	else if ( trapMainChars )
	{
		TrapMainChar( isalnum(c) ? c : ' ' );
	}
	// end of DS patch :
	if ( c == '\n' || c=='\r' || c=='\t' ) 
		return;

	PRINT_CHAR( 1, c, HMARGIN+(cursorPositionX), cursorPositionY );

	cursorPositionX += os_char_width(c);
}

// ----------------------------------------------------------------------------

void os_display_string (const zchar *s)
{
	zchar c;

	//DBG_MSG3( "os_display_string %s (%dx%d)", s, cursorPositionX, cursorPositionY );

	while ((c = *s) != 0)
	{
		if(c == ZC_NEW_FONT)
		{
			s++;
			os_set_font(*s);
		}
		else if(c == ZC_NEW_STYLE)
		{
			s++;
			os_set_text_style(*s);
		}
		else
			os_display_char(c);
		s ++;
	}

	//os_set_text_style( 0 );
}


// ----------------------------------------------------------------------------

void os_draw_picture (int x, int y, int z)
{
	WAIT_MSG3( "os_draw_picture NON IMPLEMENTE %d (%dx%d)", z, x, y );
}

// ----------------------------------------------------------------------------

void os_erase_area (int x, int y, int z, int w)
{
	DRAW_RECT( 1, y+HMARGIN, x, w+HMARGIN, z, DEFAULT_TEXT_BG_COLOR );
}

// ----------------------------------------------------------------------------

int os_font_data (int font, int *height, int *width)
{
    *height = CHAR_HEIGHT;
    *width 	= CHAR_WIDTH;

    /* Not every font is available in every mode */

    if (font == TEXT_FONT)
		return TRUE;
    if (font == FIXED_WIDTH_FONT)
		return TRUE;
    if (font == GRAPHICS_FONT )
		return TRUE;

    /* Unavailable font */

    return FALSE;
}


// ----------------------------------------------------------------------------

void os_reset_screen (void)
{
//WAIT_MSG( "os_reset_screen %d", 0);
	FILL_SCREEN		( TOP_SCREEN, TOP_BACKGROUND_COLORID );
}

// ----------------------------------------------------------------------------

void os_restart_game (int x)
{
	FILL_SCREEN		( TOP_SCREEN, TOP_BACKGROUND_COLORID );
}

// ----------------------------------------------------------------------------

void os_init_screen (void )

{
	h_interpreter_number 	= h_version == 6 ? INTERP_MSDOS : INTERP_DEC_20;
	h_interpreter_version 	= 'F';

	// init inputs
	
	h_config |= (CONFIG_COLOUR|CONFIG_PROPORTIONAL|CONFIG_BOLDFACE);

	if ((h_version >= V4))
	   h_config |= CONFIG_TIMEDINPUT;
   
	if (h_version >= V5)
	   h_flags &= ~(MOUSE_FLAG | MENU_FLAG);
	
	// init output
   
	h_font_width 		= CHAR_WIDTH;
	h_font_height 		= CHAR_HEIGHT;
	h_screen_cols 		= NUM_COLS;
	h_screen_rows 		= NUM_ROWS;
	h_screen_width 		= (h_screen_cols*CHAR_WIDTH);
	h_screen_height 	= (h_screen_rows*CHAR_HEIGHT);

	FILL_SCREEN( TOP_SCREEN, DEFAULT_TEXT_BG_COLOR );
}

// ----------------------------------------------------------------------------

void os_menu(int x, int y, const zword *z)
{
	WAIT_MSG3( "os_menu %d %d %d", x,y, (int)z );
}

// ----------------------------------------------------------------------------

void os_more_prompt (void)
{
	DRAW_RECT		( 1, 0, 184, 255, 191, 29 );
	PRINT_STRING	( 1, "MORE...", HMARGIN, 183, 0, 25, 240 );
	Wait();
	DRAW_RECT		( 1, 0, 184, 255, 191, DEFAULT_TEXT_BG_COLOR );
	//os_read_key 	( 0, 0 );
}


// ----------------------------------------------------------------------------

int os_picture_data(int num, int *height, int *width)
{
	*height 	= 0;
	*width 		= 0;
	return 0;
}

// ----------------------------------------------------------------------------

void os_process_arguments (int x, char *y[])
{
	WAIT_MSG2( "os_process_arguments %d %s", x, *y );
}

// ----------------------------------------------------------------------------

int	os_random_seed (void)
{ 
	int rndvale = PA_RTC.Minutes*60 + PA_RTC.Seconds + PA_RTC.Hour*3600 + PA_RTC.Day*3600*24+PA_RTC.Month*3600*24*30;
	return rndvale;
}

// ----------------------------------------------------------------------------

int os_read_file_name (char *x, const char *y, int z)
{
	return 0;
}

// ----------------------------------------------------------------------------

zchar os_read_key ( int timeout, int show_cursor )
{
	return ProcessInputChar	( timeout  );
}

// ----------------------------------------------------------------------------

zchar os_read_line (int max, zchar *buf, int timeout, int width, int continued)
{
	if ( ProcessInputString( (char*)buf, timeout ) < 0 )
	{
	}

	os_display_string ( buf );

	return ZC_RETURN;
}

// ----------------------------------------------------------------------------

zword os_read_mouse (void)
{
	return 0;
}

// ----------------------------------------------------------------------------

void os_scroll_area( int x, int y, int z, int w, int v )
{
	int nblinesscrolled = NUM_ROWS*CHAR_HEIGHT;			// nombre de lignes ecran a scroller
	int nbbytesperline	= 256;
	int	_screen			= 1;
	int	i;

	if ( cursorPositionX > 1 && cursorPositionY > 1 )
	{
		DRAW_PROMPT( 1, cursorPositionX+HMARGIN, cursorPositionY, 6, 0 );
	}

	for( i=CHAR_HEIGHT+1; i<nblinesscrolled-CHAR_HEIGHT+1; i++ )
	{
		memcpy( (void*)(PA_DrawBg[_screen]+((i+VMARGIN)*128)), (void*)(PA_DrawBg[_screen]+(((i+VMARGIN)+CHAR_HEIGHT)*128)), nbbytesperline );
	}

	//WAIT_MSG( "%d", 1 );
	//DRAW_RECT( _screen, 0, nblinesscrolled, 255, nblinesscrolled+CHAR_HEIGHT, DEFAULT_TEXT_BG_COLOR );
	//DRAW_RECT( _screen, 0, nblinesscrolled+CHAR_HEIGHT, 255, 191, 32 );
	DRAW_RECT( _screen, 0, nblinesscrolled-CHAR_HEIGHT+1, 255, 191, DEFAULT_TEXT_BG_COLOR );
	
	TrapMainChar( ' ' );
}

// ----------------------------------------------------------------------------

void os_scrollback_char (zword x)
{
	WAIT_MSG( "os_scrollback_char NON IMPLEMENTE %d", x);
}

// ----------------------------------------------------------------------------

void os_scrollback_erase (int x)
{
	WAIT_MSG( "os_scrollback_erase NON IMPLEMENTE %d", x );
}

// ----------------------------------------------------------------------------

void os_set_cursor( int row, int col )
{
	cursorPositionX = col;
	cursorPositionY = row;
	if ( cursorPositionX > 1 && cursorPositionY > 1 )
	{
		DRAW_PROMPT( 1, cursorPositionX+HMARGIN, cursorPositionY, 6, 1 );
	}
}

// ----------------------------------------------------------------------------

void os_set_colour( int fg, int bg )
{
	if(fg == 0)
		fg = TEXT_WHITE_COLORID;
	else
		fg = FROTZ_COLORS_BASE + fg;
	if( bg == 0)
		bg = DEFAULT_TEXT_BG_COLOR;
	else
		bg = FROTZ_COLORS_BASE + bg ;
		
	SetTextBGColor	( bg );
	SetTextColor	( fg );

	//DBG_MSG2( "SET COLOR fg %d - bg %d", fg, bg )
}

// ----------------------------------------------------------------------------

void os_set_text_style (int x)
{
	int	inverse		= (x&REVERSE_STYLE)?true:false;
	int	bold		= (x&BOLDFACE_STYLE)?true:false;
//	int	emphasis	= (x&EMPHASIS_STYLE)?true:false;
	int	fixed		= (x&FIXED_WIDTH_STYLE)?true:false;

	SetTextStyle( inverse, bold, fixed );

	//WAIT_MSG3( "STYLE I%d B%d F%d", inverse, bold, fixed )
}

// ----------------------------------------------------------------------------

void os_set_font ( int x )
{
	os_set_text_style( 0 );
	//WAIT_MSG( "SET FONT f %d ", x );
}

// ----------------------------------------------------------------------------

int os_string_width (const zchar *s)
{
	int rc = 0;

	while( *s )
	{
		if(*s != ZC_NEW_FONT && *s != ZC_NEW_STYLE)
			rc += os_char_width(*s);
		else
			s++;
		s++;
	}
	return rc;
}


// ----------------------------------------------------------------------------

int os_from_true_colour (zword x)
{
	return 0;
}
// ----------------------------------------------------------------------------

int os_peek_colour (void)
{
	return 0;
}

// ----------------------------------------------------------------------------

zword os_to_true_colour (int x)
{ 
	return 0;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

int	os_wrap_window (int x)
{
	WAIT_MSG( "windowed games not implemented %d", x );
	return 0;
}

// ----------------------------------------------------------------------------

void os_window_height (int x, int y)
{
	SetFatalMessage( "windowed games not implemented" );
}

// ----------------------------------------------------------------------------

void os_start_sample (int x, int y, int z)
{
	WAIT_MSG( "os_start_sample : not implemented %d", z );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

void os_stop_sample (void)
{ 
	WAIT_MSG( "os_stop_sample : not implemented %d", 0 );
}
// ----------------------------------------------------------------------------

void os_prepare_sample (int x)
{
	WAIT_MSG( "os_prepare_sample : not implemented %d", x );
}

// ----------------------------------------------------------------------------

void os_finish_with_sample (void)
{
	WAIT_MSG( "os_finish_with_sample : not implemented %d", 0 );
}

// ----------------------------------------------------------------------------

void __os_tick (void)
{
	WAIT_MSG( "os_tick : not implemented %d", 0 );
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------


