!--------------------------------------------------!
!                                                  !
! ZORKGRUE.H - The infamous grue and               !
!              "What is a grue?"                   !
!                                                  !
! Library file by Joe Merical (python_q@email.com) !
! Last modified: 6/11/02                           !
!                                                  !
! See Zork.html for more information               !
!                                                  !
!--------------------------------------------------!


System_file;

! MakeGrue()
! Must be called in Initialise

[ MakeGrue;

! Set the description for the dark to the one used in Zork
	thedark.description = "It is pitch black. You are likely to be
		eaten by a grue.";

! Changes the dark's name to that of the real location
   thedark.short_name = DarkShortName;

];


! Function for changing the dark's name

[ DarkShortName; print (name) real_location; rtrue; ];


! Functions for being killed by the grue

[ GrueCantGo;
	deadflag = 1;
	"Oh, no! You have walked into the slavering fangs of a lurking grue!";
];

[ GrueRoom;
	deadflag = 1;
	"Oh, no! A lurking grue slithered into the room and devoured you!";
];

! The "grue" itself
Object grue thedark
	with react_before [ i j;
		Go:	i = noun.door_dir;
			if (real_location provides i) {
				j = real_location.i();
				if (j ofclass String) { GrueCantGo(); rtrue; }
				if (j ofclass Object) {
					if (OffersLight(j)) rfalse;
					else { GrueRoom(); rtrue; }
				}
				else { GrueCantGo(); rtrue; }
			}
			else { GrueCantGo(); rtrue; }
	],
	has concealed;


IFNDEF NO_WHAT_IS;

! Questions

! "What is a grue?" and "What is a zorkmid?"

! Called by the verb "What"
[ QuerySub; meta=true; noun.description(); return; ];

! Sets the scope of the verb "What"
[ QueryTopic;
	switch (scope_stage) {
	1: rfalse;
	2: ScopeWithin(questions);rtrue;
	3: "The answers elude you at the moment.";
	}
];


! Any object that's a child of question is in scope for
! the "What" verb

Object questions;

Object -> "Grue"
   with name 'grue' 'grue?',
		description "The grue is a sinister, lurking presence in the dark places of the
			earth. Its favorite diet is adventurers, but its insatiable appetite is
			tempered by its fear of light. No grue has ever been seen by the light of day,
			and few have survived its fearsome jaws to tell the tale.";

Object -> "Zorkmid"
   with name 'zorkmid' 'zorkmid?',
		description "The zorkmid is the unit of currency of the Great Underground Empire.";


! The "what" verb
! "What is" with a non-question object will examine that object

Verb 'what'
	* 'is'/'was' noun -> Examine
	* 'is'/'was' scope=QueryTopic -> Query;

ENDIF;
