! 3Reach.h -- an implementation of "reach zones"
! for the Triform Library.
!
! Using this extension you can code your Containers
! to disallow interacting with objects outside of
! them by defining a (reachable) property. Give this
! property to either Rooms or Containers.
!
! This property must be a routine. If it returns false
! the item is treated as untouchable. Note that the
! message it generates is suitable for both PCs
! and NPCs.
!
! Although this is a very barebones approach compared
! to Marnie Parker's implementation, it's also quite
! flexible.
!
! Include between 3Parser and 3Verblib.

Replace Objectisuntouchable;

Property reachable;

[ ObjectIsUntouchable item person flag1 flag2 flag3 ancestor i j k z;

    if (person == 0) person = actor;

    ! Determine if there's any barrier preventing the player from moving
    ! things to "item".  Return false if no barrier; otherwise print a
    ! suitable message and return true.
    ! If flag1 is set, do not print any message.
    ! If flag2 is set, also apply ##Take restrictions.
    ! If flag3 is set, implicit ##Open actions will be generated,
    !  though not if flag1 is also.

    ! First, is the item reachable?

    z = parent(person);
    if (item ~= person or z && IndirectlyContains(person, item) == 0 &&
	  z provides reachable && z.reachable(item) == false) {
	if (flag1 || (actor ~= player && action_mode == 0 or 4)) rtrue;

	print_ret (The) item, " ", (IsntorArent) item, " in reach from where ",
	(Heorshe) person, " ", (IsorAre) person, ".";
    }

    ! The compass can't be acted upon, except that putting something
    ! "on the floor" is allowed.

    if (item in compass) {
	if (item == d_obj && action == ##PutOn) rfalse;
	if (flag1) rtrue; return L__M(##Miscellany, 68);
	}

    if (item.visibility_ceiling ~= person.visibility_ceiling) {
	i = item;
	while (parent(i)) i = parent(i);
	if (IndirectlyContains(actor, item) || RoomWithFloater(actor.location, i)) ;
	else rtrue;
	}

    ancestor = CommonAncestor(person, item);

    ! If the item has been added to scope by something, it's first necessary
    ! for that something to be touchable.

    if (ancestor == 0) {
        ancestor = item;
        while (ancestor && (i = ObjectScopedBySomething(ancestor)) == 0)
            ancestor = parent(ancestor);
        if (i ~= 0) {
            if (ObjectIsUntouchable(i, person, flag1, flag2)) { failed_action = 1; return; }
            ! An item immediately added to scope
        }
    }
    else

    ! First, a barrier between the person and the ancestor.  The person
    ! can only be in a sequence of enterable objects, and only closed
    ! containers make a barrier.

    if (person ~= ancestor) {
        i = parent(person);
        while (i ~= ancestor) {
            if (IndirectlyContains(i, person) == 1 && i has closed)
		{ if (flag1) { failed_action = 1; rtrue; }
		  if (flag3) CheckBeforeImplicit(i, ##Open, ##Miscellany, 65, i, ##Go, 10);
                  if (failed_action) L__M(##Take, 9, i);
            }
            i = parent(i);
        }
    }

	i = CommonAncestor(person, item);

	if (i ofclass Container && (IndirectlyContains(i, person) == 4 && IndirectlyContains(i, item) == 2) ||
		(IndirectlyContains(i, person) == 2 && IndirectlyContains(i, item) == 4))
		{ failed_action = 1; if (flag1) rtrue; return L__M(##Touch, 4, i); }

    ! Second, a barrier between the item and the ancestor.  The item can
    ! be carried by someone, part of a piece of machinery, in or on top
    ! of something and so on.

    if (item ~= ancestor) {
        i = parent(item); j = item;
        while (i ~= ancestor) {
            if (flag2 && ~~i ofclass Container) {
                if (i has animate) {
                    failed_action = 1; if (flag1) rtrue;
                    return L__M(##Take, 6, i);
                }
#Ifdef COMPLEXCLOTHING;
       if (i ofclass Wearable && i.covered_by ~= 0) {
	    failed_action = 1; if (flag1) rtrue;
	    return L__M(##Disrobe, 4, i);
	}
#Endif; ! Complex clothing
            } ! ##Take restrictions
            else { k = parent(i);
#Ifdef COMPLEXCLOTHING;
		if (k ofclass Wearable && k.covered_by) {
		    failed_action = 1; if (flag1) rtrue;
		    return L__M(##Disrobe, 4, k);
		}
#Endif; ! Complex clothing
            if (i has closed && j.insideofparent) {
		if (flag1) { failed_action = 1; rtrue; }
		if (flag3) CheckBeforeImplicit(i, ##Open, ##Miscellany, 65, i, ##Go, 10);
            if (failed_action) return L__M(##Take, 9, i);
		}
            }
            j = i;
            i = parent(i);
        }
    }

#Ifdef COMPLEXCLOTHING;
! Finally, an item of clothing could be covered by something else.

  if (item ofclass Wearable && item.covered_by && action ~= ##Wear or ##Disrobe)
	{ failed_action = 1; if (flag1) rtrue; return L__M(##Disrobe, 4, noun.covered_by); }
#Endif;

  rfalse;
];