!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORTextFormatting [Z, GLULX]
! Simple file containing various useful print rules.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep (Glulx-only) :	ORInfGlk
! AutoDep (other) :			none
!--------------------------------------------------------------------------------------
! Print Rules defined in this module:
! italics		- print in emphasised
! strong		- print in bold font
! highlight		- print in reverse font (header)
! ig			- ignore, print absolutely nothing
! arraystring	- prints out the contents of a character array 
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORTextFormatting";					!Constant USE_ORTextFormatting; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORTextFormatting; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2001.08.13	Initial Creation (not really, but this was the earliest date found 
!				without searching my code archives)
! 2002.02.10	Added GLULX support (WORDSIZE)
! 2002.02.12	Modified GLULX support (text formating)
! 2002.02.13	Modified GLULX support (arraystring print rule) Also modified code 
!				template
! 2002.02.20	Checked for declaration of ORStyleRvrsMonospace module, rather than the 
!				style_rvrsmonospace value (since both module implement code in the replace 
!				section)
! 2002.02.26	Fit to new template.
!--------------------------------------------------------------------------------------
#ifdef USE_ORTextFormatting;message "          Processing library extension ORTextFormatting...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
	#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifdef TARGET_GLULX;
		#ifndef USE_ORInfGlk; Constant USE_ORInfGlk; message "          ****Forcing inclusion of ORInfGlk****"; #include "ORInfGlk"; #endif; 
	#endif;
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORTextFormatting_DONEREPLACE; constant ORTextFormatting_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	!put in the replace section in order to be earlier than anyone else
	system_file;
	[ig o; o=null;]; 
	[set_italics; #ifdef TARGET_GLULX; glk_set_style(style_emphasized);  #ifnot;  style underline; #endif;];
	[set_normal; #ifdef TARGET_GLULX; glk_set_style(style_normal);  #ifnot;  style roman; #endif;];
	[set_strong; #ifdef TARGET_GLULX; glk_set_style(style_alert);  #ifnot;  style bold; #endif;];
	[set_hilight v;  v=0;
		#ifdef TARGET_GLULX; 
			#ifdef USE_ORStyleRvrsMonospace; 
				v=style_rvrsmonospace; 
			#ifnot; 
				v=style_header; 
			#endif;
			glk_set_style(v);  
		#ifnot;  
			style reverse; 
		#endif;
	];

	[italics o;	
		set_italics();
		print (string) o;
		set_normal();
	];
	[strong o; 
		set_strong();
		print (string) o;
		set_normal();
	];
	[highlight o; 
		set_hilight();
		print (string) o;
		set_normal();
	];
	[arraystring o i;	
		for(i=0:i<(o-->0):i++) 
			print (char) o->(i+WORDSIZE); 
	]; 
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORTextFormatting_DONEMESSAGE; constant ORTextFormatting_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORTextFormatting requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORTextFormatting_DONECODE;constant ORTextFormatting_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORTextFormatting_DONEGRAMMAR; constant ORTextFormatting_DONEGRAMMAR; #ifdef ORTextFormatting_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
