!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.02.24 ORObjectInitialise [Z, GLULX]
! Used to have object set themselves up rather than depending upon code that would 
! otherwise have to be placed in the initialise() routine. 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	none
!--------------------------------------------------------------------------------------
! With this module, all objects that provide a property name 'object_initialise' will
! have it run prior to the game's initialize() routine running.
! Printing from within the objectloop is ill advised since it does not work under 
! GLULX.
!   -----------------------------------------------------------------------------------
! ORLibDev: Note, that this module is not useful as a library extension alone.  By 
!     itself it provides no new functionality for the IF developer. Instead it provides
!     a basis for other module to be built upon and will primarily be useful to those 
!     who are developing ORLibrary entrys of their own.
!   -----------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORObjectInitialise";					!Constant USE_ORObjectInitialise; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORObjectInitialise; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.01.01	Initial Creation (not really, but this the earliest date I could find 
!				without searching my code archive)
! 2002.02.11	added Glulx support
! 2002.02.13	added a potential second call for Glulx modules
! 2002.02.26	Fit to new template
! 2003.02.26	Added new debug code. Define ORLIB_DEBUG so print the name of each 
!				object as it is initialised.
!--------------------------------------------------------------------------------------
#ifdef USE_ORObjectInitialise;message "          Processing library extension ORObjectInitialise...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!---sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORObjectInitialise_DONEREPLACE; constant ORObjectInitialise_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	Property additive object_initialise;
	replace main;
#ifdef TARGET_GLULX;
	replace GGInitialise;
#endif;
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORObjectInitialise_DONEMESSAGE; constant ORObjectInitialise_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORObjectInitialise requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORObjectInitialise_DONECODE;constant ORObjectInitialise_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	[ Main o; 
		objectloop(o provides object_initialise && o.object_initialise~=0) {
#ifdef DEBUG;
	#ifdef ORLIB_DEBUG;
			print "^Initializing object ",(object)o,":";
	#endif;
#endif;
			o.object_initialise();
		}
		InformLibrary.play(); 
	];
#ifdef TARGET_GLULX;
	!--unlike the ZMachine, the objectloop calling object_initialize from main is problematic, since
	!--GGRecoverObjects() destroys Glux objects and recreates them (such as window text styles)  
	!--Therefore, GLULX modules can give themselves the "general" attribute to be called again later
	[ GGInitialise res o;
		@gestalt 4 2 res; ! Test if this interpreter has Glk.
		if (res == 0) {
		! Without Glk, we're entirely screwed.
		quit;
		}
		! Set the VM's I/O system to be Glk.
		@setiosys 2 0;

		! First, we must go through all the Glk objects that exist, and see
		! if we created any of them. One might think this strange, since the
		! program has just started running, but remember that the player might 
		! have just typed "restart".
		GGRecoverObjects();
	
		!--ORLIB... object_initialization routine...(for initialization that cannot be done before GGRecoverObjects)
		objectloop(o provides object_initialise && o.object_initialise~=0 && o has general) o.object_initialise();
		
		res = InitGlkWindow(0);
		if (res ~= 0)
			return;

		! Now, gg_mainwin and gg_storywin might already be set. If not, set them.

		if (gg_mainwin == 0) {
			! Open the story window.
			res = InitGlkWindow(GG_MAINWIN_ROCK);
			if (res == 0)
				gg_mainwin = glk($0023, 0, 0, 0, 3, GG_MAINWIN_ROCK); ! window_open
			if (gg_mainwin == 0) {
				! If we can't even open one window, there's no point in going on.
				quit;
			}
		}
		else {
			! There was already a story window. We should erase it.
			glk($002A, gg_mainwin); ! window_clear
		}

		if (gg_statuswin == 0) {
			res = InitGlkWindow(GG_STATUSWIN_ROCK);
			if (res == 0) {
				gg_statuswin_cursize = gg_statuswin_size;
				gg_statuswin = glk($0023, gg_mainwin, $12, gg_statuswin_cursize, 
					4, GG_STATUSWIN_ROCK); ! window_open
			}
		}
		! It's possible that the status window couldn't be opened, in which case
		! gg_statuswin is now zero. We must allow for that later on.

		glk($002F, gg_mainwin); ! set_window

		InitGlkWindow(1);
	];
#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORObjectInitialise_DONEGRAMMAR; constant ORObjectInitialise_DONEGRAMMAR; #ifdef ORObjectInitialise_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
