!--------------------------------------------------------------------------------------
! Aqua.h
! originally written as WaterElement.h 	
! Version 0.95b, May 26 2002 by Emily Short
!
! Corrected by Al Golden to remove a compiler error in Inform 6.30
! on 12/30/2005
!
! Four (4) Objects moved from this file to the MODIFIED Sploosh.inf
! The water
! The wine
! The sponge
! The leaky container
!
! Models divisible liquids, mixtures, absorbent materials
!
!	Modifications suggested by Sean Barrett, Alex Watson
!
!
!
!	Verbs: 
!		New: Douse, SqueezeInto
!		Replaced: Pour, Fill, EmptyT, Drink
!	
!	Features:
!		Liquids can be divided, creating new subliquids
!		Mixtures remember what their components are and maintain a mostly-accurate
!			record of their makeup by percentage.  (Some loss of accuracy is 
!			inevitable due to the integer-only restrictions of Inform.) 
!		Liquids can be poured from one container to another, with appropriate amounts
!			ending in each container
!		Liquids may be drunk; amount drunk is slightly randomized so that measurement
!			puzzles remain valid 
!		Objects with the "floater" attribute can float
!
!	Resource cost: 
!		4 attributes (floater, floating, wet, pickflag)
!
!	Setup:
!		Include "WaterElement" after Parser but before Verblib
!
!		Use the lightly-hacked version of parserm.h included with this package;
!			this allows for intelligent liquid disambiguation.  (You can also 
!			find the changes I made to the parser by searching for HACK 
!			(all caps) and extracting the relevant changes for yourself.)
!
!		Call Water_Init(); in the Initialise routine
!
!		After including Grammar, add this line:
!
!   Extend 'squeeze' * noun 'into'/'in'/'on'/'onto'/'over' noun -> SqueezeInto;
!
!		Make all your locations of a class "Room", so spills on the floor
!			will also be correctly handled.
!
!	Entry Points:
!		BadContainer:
!			If you wish, you may define a routine "BadContainer", which must 
!			appear before you include WaterElement.  BadContainer should take 
!			a noun as an argument and then either return false or print a reason 
!			why you cannot pour something into that container.
!
!	Bug fixes:
! 		If you start getting messages that there are not enough liquid objects
!		to perform the mixtures in your game, raise the numbers after 
!		Class Liquid (currently 25) and Class MixedLiquid (currently 17).
!		Take note that by doing so, you're adding objects to the game, which will
!		take storage space.
!
!		To help determine how many of these you're likely to need, you can
!		use the verb CONTAINERS any time you have compiled in DEBUG mode.  
!		CONTAINERS will tell you how many liquid-capable containers there are in
!		the game.  You should have at least this many liquid objects available
!		to the player.
!
!--------------------------------------------------------------------------------------
 
Attribute wet;
Attribute floater;
Attribute floating;
 
Replace DrinkSub;
Replace PourSub;
Replace FillSub;
Replace EmptyTSub;

!	This copies one object's properties over to a second object.  It 
!	should not actually be necessary, but for some reason Inform's native 
!	ability to do this seemed to be broken.  Grr, arrgh, etc.  
[ PropertySet e i; 
	PropertyCopy(e, i, spec_name); 
	PropertyCopy(e, i, mixtaste); 
	PropertyCopy(e, i, mix_in_container); PropertyCopy(e, i, deploy);
	PropertyCopy(e, i, daemon); 
	PropertyCopy(e, i, short_name); PropertyCopy(e, i, parse_name); 
	PropertyCopy(e, i, describe); PropertyCopy(e, i, description);
	PropertyCopy(e, i, before); PropertyCopy(e, i, after);
	PropertyCopy(e, i, react_before); PropertyCopy(e, i, react_after);
	PropertyCopy(e, i, list_together); PropertyCopy(e, i, plural);
	PropertyCopy(e, i, size);  PropertyCopy(e, i, source); 
#ifdef PIECES;
	PropertyCopy(e, i, edge);
#endif;
	if (e provides name && i provides name) ArrayCopy(e, i, name);
	if (e provides article && i provides article) ArrayCopy(e, i, article);   
	if (e has edible) give i edible;
	give i general;
];
[ PropertyCopy e i pro;
	if (e provides pro && i provides pro) i.pro = e.pro;
];

#ifndef WORDSIZE;
Constant WORDSIZE = 2;
#endif;


[ ArrayCopy orig copy prop  a b  k l   i m;
	if ((~~(orig provides prop)) || (~~(copy provides prop))) rfalse;
    k=orig.&prop; l=(orig.#prop)/WORDSIZE;
    a=copy.&prop; b=(copy.#prop)/WORDSIZE;
	if (l > b) 
	{	i = b; } 
	else i = l;
	for (m=0:m<i:m++)
	{	a-->m = k-->m;
	}	
	rfalse;
];


!	Initialization routine that makes sure all the liquids know what their
!	"source" liquid is.
[ Water_Init obj;
	objectloop(obj ofclass Liquid)
	{	if (obj provides source && obj.source == 0)
			obj.source = obj; 
		if (obj provides daemon && obj notin nothing or liquid or mixedliquid) 
			StartDaemon(obj);
	}
];

[ FindCapacity x cap obj;
!	print "finding capacity of ", (the) x, "^";
	if (x provides leak_cap) cap = x.leak_cap();
	else 
	{	cap = Volumizer(x) * 10;
	}
!	print "stage 1: ", cap, "^";
	if (cap == 0) cap = 100; 
	
!	print "stage 2: ", cap, "^";
	
	if (children(x) ~= 0)
		{	objectloop(obj in x) 
			{ 
				if (~~(obj ofclass liquid))
				{	if (obj provides size) cap = cap-(obj.size*100);
					else cap = cap - 100; 
!					print "minus ", (the) obj, ": ", cap, "^";
				}
				else 
				{
!					print "finding ", (the) obj, " number to be: ", obj.number, "^";
					cap = cap-obj.number; 
!					print "minus ", (the) obj, ": ", cap, "^";
				} 
			}
		}
	 
	return cap;
];
[ Volumizer x y  i exp vol;
	if (y == 0) y = size;
	if (~~(x provides y)) 
	{
		return 1;
	}
	if (x.y == 0) return 0; 
	else exp = 3;
	vol = 1;
	for (::)
	{	i++;
		vol = vol*x.y;
		if (i == exp) 
		{	 
			return vol;
		}
	}
];



[ IsAWordIn w obj prop   k l m;
	k=obj.&prop; l=(obj.#prop)/WORDSIZE;
	for (m=0:m<l:m++)
	if (w==k-->m) rtrue;
	rfalse;
];


!-------------------------------------------------------------------------
! Two classes: LIQUID and MIXEDLIQUID
!-------------------------------------------------------------------------


Class Liquid (25),
	with  
!	density 500, mass 0, 
	description [;
		if (child(self)~=0)
		{	print "A mixture of "; WriteListFrom(child(self), ENGLISH_BIT); "."; }
	],
	daemon [ x obj l1 l2;
		if (self hasnt wet) 
		{	StopDaemon(self);
			rfalse;
		}
		
		if (self in nothing || self.source == 0)
		{
			StopDaemon(self);
			self.evaporate();
			rfalse;
		}
		
		if (self in location)
		{
			objectloop(x in location && x ofclass liquid)
			{	
				if (l1 == 0) l1 = x;
				else 
					if (l2 == 0) l2 = x;
			}
			
			if (l1 && l2)
			{
				if (l1.source == l2.source)
				{	! print "Sources match; destroying x^"; Pause();
					l1.number = l1.number + l2.number;
					if (l2 ofclass MixedLiquid) MixedLiquid.destroy(l2);
					else liquid.destroy(l2);
				}
				else 
				{	
						! print "MIXING ", (name) l1, " and ", (name) x, "^";
					!	Pause();
					Mix(l1, l2); 
				}
			}
		}
		
		x = parent(self);
 
		if (x == 0 || (x ofclass Room && (~~x provides water_leak))) 
		{	StopDaemon(self); rfalse;
		}
		if (~~(x ofclass Room)) 
		{	 
			objectloop(obj in x)
			{	if (obj has floater && obj hasnt floating && self has wet)
				{	give obj floating;
					if (TestScope(obj))
					{
						print "^", (The) obj," bobs to the surface of ", (the) self, ".^";
					}
				}
				if (obj has floating && obj hasnt floater && self has wet)
				{	give obj ~floating;
					if (TestScope(obj))
					{
						print "^", (The) obj;
						print " sinks.^"; 
					}
				}
			} 
		}

		if (x provides water_leak)
		{	x.water_leak(self, 1);
		}  
	],
	create
	[;	give self general; 
	], 
	article [ ;
		if (parent(self) ofclass Room) 
		{	if (self has wet) print "a puddle of";
			else print "a pile of";
		}
		else switch(self.number)
		{	0 to 40: print "not very much";
			41 to 100: print "some";
			101 to 501: print "a great deal of";
			default: print "a body of";
		}
	],
	invent [ x y cap;
		if (inventory_stage ~= 2) rfalse;
		x = parent(self);
		if (x == 0) rfalse;
		if (x hasnt container) rfalse;
		y = FindCapacity(x);
		cap = Volumizer(x)*10; if (cap == 0) cap = 100;
		
		switch(y)
		{
			0: print " (which";
					if (self.number < 41) print " nonetheless";
				print " fills ", (the) x, " to the brim)";
			1 to 20: print " (which leaves a little room in ", (the) x, ")";
			100 to 10000:
				print " (which ";
					if (self.number > 101) print "nonetheless";
				print " leaves a fair amount of room in ", (the) x, ")";
			default:
				if (cap/y == 2) 
				{	print " (which leaves ", (the) x, " about half full)";
					rtrue;
				}
				if (cap/y == 4)
				{
					print " (which leaves ", (the) x, " about a quarter full)";
					rtrue;
				}
				if ((4*cap)/y == 3)
				{
					print " (which leaves ", (the) x, " about three-quarters full)";
					rtrue;
				}
				print " (which leaves some room in ", (the) x, ")";
		}
		rtrue;
	],
	name "drink", 
	short_name [ x;
		x = parent(self);
		if (self provides spec_name)
			print (string) self.spec_name;
#ifdef disamb;
		if (disamb)
		{
			if (x has container) print " in ", (the) x; 
			if (x ofclass Room) print " on the ground"; 
		}
#endif;
		rtrue;
	], 
	spec_name "some liquid",
	source nothing, 
	percentage 100,
	number 150,
	parse_name [ i j w x flag flag2 z;
		x = parent(self);
		if (self.source ~= 0) z = self.source; else z = self;
		for (::)
		{	
			j = 0; w = NextWord();
			if ((w == 'a' or 'puddle' or 'of' or 'on' or 'the' or 'ground') 
				&& parent(self) ofclass Room)
			{	j = 1;
			}
			if (w == 'not' or 'very' or 'much' && self.number < 41) 
			{	j = 1;
			}
			if (w == 'some' && self.number > 40 && self.number < 101) 
			{	j = 1;
			}
			if (w == 'a' or 'great' or 'deal' or 'of' && self.number > 100 && self.number < 502) 
			{	j = 1;
			}
			if (w == 'a' or 'body' or 'of' && self.number > 501) 
			{	j = 1;
			}
			if (IsAWordIn(w,z,name)) 
			{	j = 1;
			} 
			if ((w == 'in' or 'from') && flag == 0) 
			{	j = 1; flag = 1;
			}
			if (flag && (IsAWordIn(w,x,name) || w=='the')) 
			{	j = 1;
				flag2 = 1;
			}  
			if (j~=0)  i++; 
			else 
			{	if (flag && flag2==0) i--; wn--;
				return i;
			}
		}
	],  
	react_before [ x; 	
		taste: if (noun == self && parent(self) == location && self has edible)
			print "You dip a finger in ", (the) self, ".  ";
		take: if (IndirectlyContains(noun, self) && self notin noun 
			&& parent(self) has open)
			{	"You might spill ", (the) self, ".";
			}
		emptyt:  
			if (noun ~= parent(self)) rfalse;
			x = parent(self);
			if (children(x) > 1) "That's likely to be a messy operation.  Better to 
				remove the solid objects and then pour the liquid."; 
			<FillFrom second noun>;
			if (child(noun) ~= 0) "Something remains in ", (the) noun, "."; rtrue;	
		insert:
			if (second ~= self) rfalse;
			x = parent(self);
			<<Insert noun x>>;  
	], 
	react_after [ x obj;
		take, remove: 
			if (self hasnt wet) rfalse;
			if (noun has floater && noun has floating)
			{	
				x = parent(noun);
				objectloop(obj in x)
				{	if (obj ofclass Liquid) rfalse;
				}
				give noun ~floating;
			}
		insert:
			x = parent(noun);
			if (x ~= parent(self)) rfalse;
			if (noun ofclass Liquid) rfalse;
			if (self hasnt wet) 
			{
				print "You put ", (the) noun, " into ", (the) x, ".^";
				rtrue;
			}
			print "You put ", (the) noun, " into ", (the) x, ".  ";
			if (x has floater) 
			{	give x floating; 
				print (The) noun, " bobs on the surface of ",
					(the) self, ".  ";
			} 
			
			if (~~(noun ofclass absorbent)) keep_silent = true; 
			<douse noun second>;
			keep_silent = false;
		!	if (noun ofclass absorbent) 
				rtrue; 
		!	rfalse;
	],
	before [  x  component nextcomp nextcomp2;
		touch: if (ObjectIsUntouchable(self)) rtrue; 
			if (self hasnt wet)
			{	"You push at ", (the) self, "; the powder shifts under 
				your fingers.";
			}
			"You wet your fingers in ", (the) self, ", and then
				shake them dry.  Nothing particularly odd there.";
		taste: if (self hasnt edible) "That doesn't seem like a very 
			pleasant idea.";!	Describe the taste by finding the strongest component and then
			!		the next-strongest.  There is a trivial default, of course,
			!			but also some others.
			
			x = 0; 
			if (children(self)~=0)
			{ 	objectloop(component in self)
				{	
			!		print (name) component, " ";
					if (component.percentage > x) 
					{	x = component.percentage; 
						if (nextcomp) nextcomp2 = nextcomp;
						nextcomp = component;
			!			print "is nextcomp^";
					}
					else 
					{	if (nextcomp2 == 0 || component.percentage > nextcomp2.percentage)
						{	nextcomp2 = component;	
			!				print "is nextcomp2^";
						}
			!			else
			!				print "is nothing^";
					}
				} 
				if (nextcomp2 provides source) nextcomp2 = nextcomp2.source;
				if (nextcomp provides source) nextcomp = nextcomp.source;
				
				if (nextcomp ~= 0) 
				{	if (nextcomp provides mixtaste)
					{	
						x = nextcomp.mixtaste(nextcomp2); 
						if (x) rtrue;
					}
					if (nextcomp2 && nextcomp2 provides mixtaste)
						x = nextcomp2.mixtaste(nextcomp); 
					if (x) rtrue; 
					print "There is an identifiable flavor of ", 
						(name) nextcomp; 
					if (nextcomp2) print " and ", (name) nextcomp2;
						print ".^"; 
					rtrue;
				} 
			} 
			rfalse;
			
		drink, pour: if (self in location) "From the ground?";
		take, remove: print "You can't just pick up a ";
			if (self has wet) print "liquid"; else print "powder";
			" in your bare hands."; 
		thrownat: "That would be likely to make a mess.";
		insert: if (Liquid.remaining() < 1 && 
				self.number > FindCapacity(second))
				{
					"You've already got so many full containers and liquids
					lying around
					that if you're not careful you will be appointed court
					alchemist.";
				}
	],
	after [ x cont;
		drink: 	
			if (~~(self provides number)) "It's not suitable for drinking.";
			if (self hasnt wet) "It's not something you can drink.";
			cont = parent(self);
			x = 10+(random(10));
			self.number = self.number - x;
			if (self.number < 0) self.number = 0; 
			print "You ";
			if (cont has static || cont has scenery)
				print "dip your hand in and ";
			else
			{	if (random(2)==1 && x > 16 && cont in player)
				{
					print "tip back ", (the) cont, " and ";
				}
			}
			print "take a ";
			switch(x) 
			{	0 to 12: print "small sip";
				13 to 17: print "sip";
				18 to 20: print "long draft";
			}
			print " of ", (the) self;
			switch(self.number) 
			{ 	0: print ", finishing it off";
				1 to 11: print ", leaving only enough for another sip";
				12 to 21: print ", leaving only another sip or two";
				22 to 40: print ", leaving only another few sips";
				41 to 400: print ", leaving a considerable quantity behind";
				default: ;	!	There's so much left it's not worth commenting on
			}
			print ".  ";
			
			<Taste self>; 
			
			if (random(2)==1 && (cont has static || cont has scenery))
			{	print "^You shake the remaining
					droplets from your hand, before they can run down your
					arm into your cuffs.^";
			}
			
			if (self.number == 0)
			{	self.evaporate();
			}
			rtrue; 
		insert: 
			return self.deploy(noun, self.number, 1); 
		drop:
			"You pour ", (the) self, " out onto the ground.";
	],
	deploy [ new quant flag  cont component nextcomp cap x;
		!	Determine whether there is room in the new vessel.
			cont = parent(self);
			if (new == cont) 
			{	if (keep_silent == 0)
					"That would be redundant.";
				rtrue;
			}
	
		!	Check the capacity of the new container
			.Checking; 
		
			cap = FindCapacity(new);
			if (new ofclass Room) cap = 10000;
			
			if (cap < 1 && flag) 
			{	if (keep_silent == 0)
				{	print (The) new; " is already full.";
				}
				else
				{	if (cont has container && cont has open)
					{	cont = parent(cont);
						jump Checking;
					}
				}
			}
			
			if (cont hasnt container) rtrue;

			!	If the whole of the liquid will fit in the new vessel, just pour 
			!	it all in.  Otherwise, create a subcomponent, x.

			if (keep_silent == 0)
				if (TestScope(self)) print "You put some ", (name) self, " in ", (the) new;   
				
			if (flag == 0 || quant < cap) cap = quant;
			
			if (cap < 0) cap = 0;
			
			if (cap >= self.number)
			{	
		!		print "Announcing complete transfer^"; Pause();
				
				move self to new;  
				
				if (keep_silent == 0 && TestScope(self))
				{
					print ", exhausting the supply";
					if (cont has container) print " in ", (the) cont, "."; else print ".";
					if (self.number == cap) print "  This fills ", (the) new, " to the brim.";
					else 
					{	if (~~(new provides water_leak))
							print "  There is still some room remaining in ", (the) new, ".";
					}
				}
			}
			else 
			{	
		!		print "Creating new liquid for partial transfer^"; 
				
				x = Liquid.create();
				if (self hasnt wet) give x ~wet;
				if (x == nothing) 
					"Haven't you got enough full containers lying around?";
				move x to new; give x ~concealed ~static ~scenery general;
				PropertySet(self, x);  
				StartDaemon(x);
				give x general;
				 
				x.number = cap; 
				if (keep_silent == 0 && TestScope(self)) 
					print ".  This fills ", (the) new, " to the brim.";
		!		print self.number;
				self.number = self.number - cap;
		!		print self.number;
				if (child(self) ~= 0)
				{	
		!			print "Transferring old components from a mix^"; Pause();
					objectloop(component in self && component ofclass Liquid)
					{	nextcomp = Liquid.create();
						if (nextcomp == 0)  
							"***Mixed Liquid Transfer error!***";
						give nextcomp general;
						liquid.copy(nextcomp, component);
						PropertySet(component, nextcomp);
						StartDaemon(liquid);
						nextcomp.source = component.source;
						nextcomp.percentage = component.percentage;
						move nextcomp to x;
					}
				}
			}  
			if (x==0) x = self;
			
			!	Call routine to mingle liquid with its new brethren and sistren
			if (self.mix_in_container(x, new)) rtrue;
			
			if (keep_silent == 0) print "^"; 
			rtrue; 
	],
	mix_in_container [ x container obj nextcomp;
		!	Now determine what happens to the other things in the container.
		!	If it's liquid, mix with it; if it's not, flag it 'wet'.
			if (children(container) > 1) 
			{	
		!		print "Dampening objects in the new container^"; Pause();
					objectloop(obj in container)
				{	if (obj ofclass liquid) nextcomp = obj;
					else 
					{	if (self has wet)
						{	
							if (x has floater && x hasnt floating && self has wet) 
							{	give x floating; 
								if (TestScope(x) && keep_silent == 0)
									print (The) x, " bobs on the surface of ",
										(the) self, ".  ";
							}
							if (x has floating && x hasnt floater && self has wet)
							{	give x ~floating;
							}
							GetWet(obj, x); 
						}
					}
				} 
				if (nextcomp == 0 && self has wet && keep_silent == 0 && TestScope(x)) 
					"  This operation soaks the other contents \
						of ", (the) container, "^";
			}
			
			if (container provides water_leak)
			{	if (container.water_leak(x)) rtrue;
			}
			
			if (sibling(x) ~= 0) 
			{	obj = sibling(x);
				while(~~(obj ofclass Liquid))
				{	obj = sibling(obj);
					if (obj == 0) 
					{	if (keep_silent == 0) print "^"; 
						rtrue;	
					}
				}
				if (TestScope(x) && keep_silent == 0)
					print "  ", (The) x, " mixes with what was already there.";
				if (x.source == obj.source)
				{	! print "Sources match; destroying x^"; Pause();
					obj.number = obj.number + x.number;
					if (x ofclass MixedLiquid) MixedLiquid.destroy(x);
					else liquid.destroy(x);
				}
				else 
				{	
					! print "MIXING ", (name) obj, " and ", (name) x, "^";
				!	Pause();
					Mix(obj, x); 
				}
			}
	],
!	destroy [ x;
!		StopDaemon(self);
!		objectloop(x hasnt concealed && x in self)
!		{	remove x;
!		}
!	],
	evaporate 
	[ flag x obj;	
		StopDaemon(self);
		if (flag == 0)
		{
			x = parent(self); 
			objectloop(obj in x)
			{	if (x has floating) give x ~floating;
			}
		} 
		objectloop(obj in self && obj has general)
		{
			if (obj ofclass Liquid && obj has general)
			{	obj.evaporate(1);
			}
		}
		if (self has general) 
		{	if (self ofclass MixedLiquid) MixedLiquid.destroy(self);
			else Liquid.destroy(self);
!			print "After destruction ", (the) self, " is in ", (the) parent(self), ".^";
		}
	],
	has wet;  
Class MixedLiquid(17),
	class Liquid,
	with 
	article  [;
		print "a mixture of";
	],
	parse_name [ i j w m flag; 
		for (::)
		{	
			j = 0; w = NextWord();
			if (w == 'mixture') 
			{	j = 1; flag = 1;
			} 
			if (w == 'of') 
			{	j = 1;
			}  
			objectloop(m in self && m provides name)
			{
				if (IsAWordIn(w, m, name)) j = 1;
				if (m provides source && m.source provides name)
				{	if (IsAWordIn(w, m.source, name))
						j = 1;
				}
			}  
			if (j~=0)  i++; else return i*flag;
		}
	], 
	short_name [ x i z;
		i = children(self);
		objectloop(x in self) 
		{	print (name) x; z++;
			if (z == i-1) 
			{	if (i==2) print " and ";
				else print ", and ";
			}
			else 
			{	if (z==i) rtrue;
				if (i<3) print " ";
				else print ", ";
			} 
		} 
	],
	description [;
		print "A mixture of ";
		WriteListFrom(child(self), ENGLISH_BIT);
		print ".";
		if (self hasnt edible) "  It doesn't look appetizing.";
		new_line;
	];
	
Class Leaky,
	with
	drip 5,
	describe_leak [ liq;
		new_line;
		if (liq.number > self.drip) print "Some of ", (the) liq;
		else print (The) liq;
		print " leaks out of ", (the) self, ".^";
	],
	water_leak [ liq flag par x;
		if (flag==0) rfalse;
		if (liq==0) rfalse; 
		
		par = parent(self);
		if (par == player) par = location;
		
		if ((~~(par ofclass Room)) && FindCapacity(par)==0) rfalse;
		
		if (TestScope(self))
		{	
			self.describe_leak(liq);
		}
		
		if (liq provides deploy && par && (par has container || par ofclass Room))
		{
			keep_silent = 1;
	 	    liq.deploy(par, self.drip);		!	(Generates new liquid, mixes, etc.)
	 	    keep_silent = 0;
	 	}
		else
		{
			liq.number = liq.number-self.drip; 
		}
		
		if (liq notin self || liq.number < 1)
		{
			objectloop(x in self)
			{	if (x has floating) 
				{	
					give x ~floating;
					if (TestScope(x) && keep_silent == 0)
					{	
						print "^", (The) x, " settles back to a dry surface.^";
					}
				}
			}
		}
		
		if (liq.number < 1) 
		{	
			liq.evaporate();
		}
	],
	has container;
	

Class Absorbent, 
	with absorb 50,  
	source 0,
	invent [;
		if (inventory_stage == 2) 
		{	if (self has wet) 
			{
				print " (sodden)";
			}
		}
	], 
	before [ x y cap;
		squeeze: 
			if (objectisUntouchable(self)) rtrue; 
			if (self has wet)
			{	give self ~wet; 
			}
			if (self.source)
			{
				print "You wring out ", (the) self, ", causing it to drip ";
				if (self.source) print (name) self.source;
				if (child(self))
				{
					move child(self) to location;
				}
				else
				{
					x = MakeLiquidCopy(self.source, self.absorb, location);
				}
				if (parent(self) ~= location or player)
				{	y = parent(self);
					GetWet(y); 
					self.source = 0;
					" all over ", (the) y, ".";
				}
				self.source = 0;
				" all over the place.";
			} 
		squeezeinto:
			if (objectisUntouchable(self)) rtrue; 
			if (second has container && second hasnt open)
			{	"", (The) second, " ", (IsOrAre) second, " not open.";
			}
			if (self hasnt wet) "There's nothing in ", (the) self, " to wring.";
			give self ~wet; 
			if (keep_silent == 0)
			{	print "You wring out ", (the) self, ", causing it to drip ";
				if (self.source) print (name) self.source;
				if (second has container) print " into ", (the) second;
				print ".^";
			} 
				 
				if (self.source in self)
				{
					if (self.source provides deploy && second has container)
					{	keep_silent = 1;
						self.source.deploy(second, self.source.number);
						keep_silent = 0;
					}
					else GetWet(second,self.source);
				}
				else
				{	
					x = MakeLiquidCopy(self.source, self.absorb, second);
					cap = FindCapacity(second);
					if (x.number > cap && (~~(second provides water_leak)))
					{	x.number = cap;
						print "Some of it overflows a bit.  ";
					}
					self.source = 0;
					if (x.mix_in_container(x, second)) rtrue; 
				}
				self.source = 0;
				rtrue; 
		taste:
			if (objectisUntouchable(self)) rtrue;
			if (self.source) 
			{	if (self.source hasnt edible)
				{	"That doesn't sound like a very pleasant idea given that ",
					(the) self, " is full of ", (the) self.source, ".";
				}
				print (CThatOrThose) self;
				" tastes vaguely of ", (name) self.source, ".";
			}
		smell:
			if (self.source && self.source ~= water) 
			{	print (CThatOrThose) self;
				" smells a bit like ", (name) self.source, ".";
			}
	];

!-------------------------------------------------------------------------
! A couple of needed ROUTINES
!-------------------------------------------------------------------------
	
[ MakeLiquidCopy source quant cont  x;
	x = Liquid.create();
	if (x == nothing) 
		"Haven't you got enough full containers lying around?";
	move x to cont; give x ~concealed ~static ~scenery;
	PropertySet(source, x);  
	StartDaemon(x); 
	x.number = quant;
	return x;
];
	
Attribute pickflag;
[ Mix old new component nextcomp mixture ;
	mixture = MixedLiquid.create(); 
	if (mixture == nothing) "**** Mixing Error! ****";
!	liquid.copy(mixture, new); 
!	PropertySet(mixture, new);

	give mixture general;
	if (old hasnt edible || new hasnt edible) give mixture ~edible;
	else give mixture edible; 
	if (old hasnt wet && new hasnt wet) give mixture ~wet;
	move mixture to parent(old);
	mixture.number = old.number + new.number; 
	
	if (mixture.number == 0) mixture.number = 1;
	
	old.percentage = (100*old.number)/mixture.number; 
	if (old.percentage > 100) old.percentage = 100;
	new.percentage = (100*new.number)/mixture.number; 
	if (new.percentage > 100) new.percentage = 100;
	  
!	If the liquids being mixed are themselves mixed liquids, move the components of these
!	to their new 'home'.
	MixMover(old, mixture); MixMover(new, mixture);

!	Recalculate the percentages for all the components taking into account their new situation
	objectloop(component in mixture)
	{
		objectloop(nextcomp in mixture && 
				nextcomp ~= component && nextcomp.source ~= nextcomp) 
		{	if (nextcomp.source == component.source && component hasnt pickflag)
				{	component.percentage = 
						component.percentage + nextcomp.percentage; 
					give nextcomp pickflag;
				}
		}
	} 
	
	objectloop(nextcomp has pickflag)
	{	
		if (nextcomp has general)
		{	if (nextcomp ofclass MixedLiquid) MixedLiquid.destroy(nextcomp);
			else if (nextcomp ofclass Liquid) Liquid.destroy(nextcomp); 
		}
		else 
		{	print "", (The) nextcomp, " hasnt general^";
			remove nextcomp;
		}
		give nextcomp ~pickflag;
	} 
		
	mixture.source = mixture;  
	mixture.percentage = 100; 
	StartDaemon(mixture);
	  
];

[ MixMover old mixture component;
	if (child(old) == 0) move old to mixture;
	else 
	{	while (child(old) ~= 0)
		{	component = child(old);
			component.percentage = (component.percentage*old.percentage)/100;
			move component to mixture; 
		}
		old.evaporate();
	}  
]; 
!-------------------------------------------------------------------------
! New and replacement VERBS
!-------------------------------------------------------------------------


Verb 'douse' 'wet' 'soak' 'dampen' 'moisten' 'dip'
						* noun 'with'/'in' noun ->	Douse;

[ GetWet obj liq  ev flag;

	if (obj has wet) rfalse; if (liq hasnt wet) rfalse; 
	if (obj provides absorb) ev = obj.absorb; else ev = 5; 
	if (obj ofclass absorbent)
	{
		if (liq ofclass liquid && liq has wet) 
			{	if (liq provides source) obj.source = liq.source;
				else obj.source = liq; 
			}
	}
	if (liq.number < (ev + 1)) 
	{	flag = 1;
	}
	else liq.number = liq.number - ev;
	give obj wet;  
	return flag;
];

[ DouseSub i flag x cont; 
	x = parent(second);
	if (noun == d_obj && x && x has container)
	{
		<<empty x>>;
	}
	if (keep_silent == 0)
	{	if (~~(second ofclass liquid) || second hasnt wet) 
		{	if (children(second))
			{	objectloop(i in second)
				{	if (i ofclass liquid && second has wet)
					<<Douse noun i>>;
				}
			}
			if (second has wet)
			{	<<Rub noun second>>;
			}
			"Try dousing ", (the) noun, " with something wet.";
		}
		if (ObjectIsUntouchable(second)) rtrue;
		if (second hasnt wet) "", (The) second, " is not wet.";
		if (ObjectIsUntouchable(noun)) rtrue;
		
		if (noun ofclass liquid)
		{	cont = parent(noun);
			if (cont has container)
			{	<<Fill cont second>>;
			}
			else
			{
				move second to location;
				print "You pour ", (the) second, " into ", (the) noun,
					", where they mix.^";
				Mix(second, noun);
				rtrue;
			}
		}
		
		if (noun has wet) "", (The) noun, " ", (IsOrAre) noun, " already nicely soaked.";
	}
	
	flag = GetWet(noun, second);
	
	if (AfterRoutines()==1) 
	{	if (flag) second.evaporate();
		rtrue;  
	}
	else 
	{	
		if (keep_silent) rtrue;
		if (flag) 
		{	print "You exhaust ", (the) second;
			if (noun ofclass absorbent && noun hasnt container
				&& noun hasnt supporter) move second to noun;
			else second.evaporate(); 
		}
		else print "You consume some of ", (the) second;
		print " in moistening ", (the) noun, "."; 
		new_line; rtrue;
	}
	if (flag) 
	{
		if (noun ofclass absorbent && noun hasnt container
			&& noun hasnt supporter) move second to noun;
		else second.evaporate(); 
	}
];
 
[ DrinkSub;
	if (ObjectIsUntouchable(noun)) return;
	if (noun in location) "Drinking from puddles is not your style.";
	if (~~(noun ofclass liquid)) "That isn't something you can drink.";
	if (noun hasnt edible) "You don't think that it is likely to agree with you.";
	if (AfterRoutines()==1) rtrue;
	"Glug, glug!";
];

[ FillFromSub i;
	if (noun == player) "What a bizarre idea!";
	if (noun hasnt container) { 	print (The) noun; " is not a container.";}
	i = child(second);
	if (i == 0) {	print (The) second; " is empty.";};
	if (~~(i ofclass liquid)) { <emptyT second noun >; rtrue;};
	<Fill noun i>;
];

[ FillSub obj;
	if (noun == player) 
	{	if (keep_silent) rtrue;
		"Getting a bit peckish, are you?";
	}
	if (second == 0) 
	{	if (keep_silent) rtrue;
		"You'll have to specify what you want to fill it with.";
	}
	
		obj = parent(second);
	if (obj == noun) "That would be a bit redundant.";
	if (keep_silent == 0 && noun notin player && obj notin player)
	{	if (noun hasnt static && noun hasnt scenery)
		{	print "(first taking ", (the) noun, ")^";
			<take noun>;
			if (noun notin player) new_line; 
		}
		if (noun notin player) 
		{	 
			if (obj hasnt static && obj hasnt scenery)
			{	print "(taking ", (the) obj, ")^";
				<take obj>;
			}
			if (obj notin player)
				rtrue;
		}
		new_line;
	}
	if (keep_silent == 0 && IndirectlyContains(player, noun) && noun notin player)
	{	print "(first taking ", (the) noun, ")^";
		<take noun>;
		if (noun notin player) rtrue;
		new_line;
	}
	if (second in location && second ofclass Liquid)
	{	"From the ground?  That seems difficult to achieve.";
	}
	if (ObjectIsUntouchable(noun, keep_silent) || ObjectIsUntouchable(second, keep_silent)) return; 
	if (noun ofclass liquid) 
	{	obj = parent(noun); <Fill obj second>; rtrue;
	}
	if (noun hasnt container)
	{	if (keep_silent) rtrue;
		print (The) noun; " is not something you can fill.";
	}  
	
#ifdef BadContainer;
	if (BadContainer(noun))
	{	rtrue; 
	}
#endif;
	
	if (noun hasnt open) 
	{	if (keep_silent) rtrue;
		print (The) noun; " is closed.";
	}
	if (second in noun)
	{	if (keep_silent) rtrue;
		"That would be a trifle redundant.";
	}
!	objectloop(obj in noun)
!	{	if (~~(obj ofclass liquid)) "You would only get ", (the) obj, " wet.";
!	} 

	
	action=##Insert;
      if (RunRoutines(second,before)~=0) { action=##Fill; rtrue; }
      
	action=##Receive;
			if (RunRoutines(noun,before)~=0) { action =##Fill; rtrue;}
	 
	if (~~(second ofclass Liquid))
	{	<<Insert second noun>>;
	}
	if (AfterRoutines()==1) rtrue; 
	 
	action=##Insert;
      if (RunRoutines(second,after)~=0) { action=##Fill; rtrue; }
	action=##Receive;
			if (RunRoutines(noun,after)~=0) {action =##Fill; rtrue;}
	 
	if (keep_silent) rtrue;
	L__M(##Fill,1,noun);
]; 
 

Verb 'pour' 'dump' * noun 'into'/'in' noun -> Pour
		* noun 'on'/'onto'/'over' noun -> Douse reverse
		* 'out' container	-> Empty
		* container 'out'	-> Empty;
[ PourSub x; 
	if (~~(noun ofclass liquid)) 
	{ 	
		if (noun has container)
		{
			if (noun hasnt open)
			{	"", (The) noun, " ", (IsOrAre) noun, " closed.";
			}
			objectloop(x in noun)
			{	if (x ofclass liquid)
				{	<<Pour x second>>;
				}
			}
			"", (The) noun, " ", (IsOrAre) noun, " empty.";
		}
		print (The) noun; " ", (IsOrAre) noun, " not susceptible to pouring.";
	}
	<Fill second noun>;
	AfterRoutines();
	rtrue;
]; 

Verb 'mix' * noun -> Mix
	* noun 'with' noun -> Mix;
[ MixSub; "[ You may POUR a substance into a container or FILL a \
	container with a substance.  It's no use trying to mix things \
	in midair.]";
];


[ SqueezeIntoSub;
	if (second has container && second hasnt open) 
		"", (The) second, " is closed.";
	<<squeeze noun>>;
];


[ EmptyTSub i j k flag;
  if (noun == second) return L__M(##EmptyT,4);
  if (ObjectIsUntouchable(noun)) return;
  
	objectloop(i in noun)
	{	if (i ofclass Liquid) j++;
  		else k++;
	}
	if (j && k)
	{	"You'd be better off removing the solid objects and the 
  		liquid ones separately; that way you won't make such a mess.";
  	}
	if (j == 1)
	{	
		j = child(noun);
		if (second ~= d_obj)
			<<Pour j second>>;
	}
	else
	{	if (j > 1) 
		{	"[BUG] Liquid handling error";
		}
	}
	i = 0; j=0; k=0;
  
  if (noun hasnt container) return L__M(##EmptyT,1,noun);
  if (noun hasnt open) return L__M(##EmptyT,2,noun);
  if (second~=d_obj)
  {   if (second hasnt supporter)
      {   if (second hasnt container) return L__M(##EmptyT,1,second);
          if (second hasnt open) return L__M(##EmptyT,2,second);
      }
  }
  i=child(noun); k = children(noun);
  if (i==0) return L__M(##EmptyT,3,noun);
  while (i~=0)
  {   j=sibling(i);
      flag = 0;
      if (ObjectIsUntouchable(noun)) flag = 1;
      if (noun hasnt container) flag = 1;
      if (noun hasnt open) flag = 1;
      if (second~=d_obj)
      {   if (second hasnt supporter)
          {   if (second hasnt container) flag = 1;
              if (second hasnt open) flag = 1;
          }
      }
      if (k-- == 0) flag = 1;
      if (flag) break;
      if (keep_silent == 0) print (name) i, ": ";
      <Transfer i second>;
      i=j;
  }
];

#ifdef DEBUG;
Verb 'containers' * -> Containers;
[ ContainersSub x i;
	objectloop(x)
	{	keep_silent = true;
		if (x has container)
		{	
#ifdef BadContainer;
			if (BadContainer(x)==0)
			{
#endif;
			keep_silent = false;
			if (x hasnt open && x hasnt openable)
			{	;
			}
			else
			{	print (name) x, "; ";
				i++;
			}

#ifdef BadContainer;
			}
#endif;
		}
	}
			keep_silent = false;
	print "^", i; " liquid-capable containers in the game.";
];
#endif;


