/*
 * Seen.t
 *
 * This unit provides a replacement score_and_rank function which gives the
 * percentage of rooms and items you have seen.
 *
 * To use it, simply add a #include line for this unit into your game and
 * it will automatically be called when you finish a game or explicitly type
 * the 'SCORE' command.
 *
 * The old score_and_rank from WorldClass has been copied into a new function
 * old_score_and_rank(), which the new score_and_rank calls. Should you wish
 * modify the scoring display (such as adding in a ranking system), you
 * should replace old_score_and_rank(), rather than score_and_rank()
 *
 * This module has been built to work with WorldClass.
 * Copyright (C) 1994 by Paul Gilbert
 *
 * Usage of this module or of code/therein requires that you give mention to
 * the usage of my module within your code.
 */

old_score_and_rank: function
{
	// print current score and (optionally) the implied rank.
	// this default is pretty lame.

	"In a total of "; say(global.turns);
	" turns, you have achieved a score of "; say(global.score);
	" points out of a possible "; say(global.maxscore); ".\n";
}

replace score_and_rank: function
   {
   local o, seen, tot;

   old_score_and_rank();

   "\bYou have seen ";

   tot := 0; seen := 0;
   for (o := firstobj(); o <> nil; o := nextobj(o))
     {
     if ( isclass(o, Item) )
       {
       tot += 1;
       if ( o.isknownto( Me )) seen += 1;
       else { "*"; }
       }
     }
   say(seen*100/tot);
   "% of the items, and ";

   tot := 0; seen := 0;
   for (o := firstobj(); o <> nil; o := nextobj(o))
     {
     if ( isclass(o, Room) and not isclass(o, Nestedroom) and
	  not ( o = Walls or o = Ceiling )
	)
       // Only total up rooms, not nestedrooms.
       {
       tot += 1;
       if ( o.isknownto( Me )) seen += 1;
       }
     }
   say(seen*100/tot);
   "% of the game locations.\n";
   }
;
