/*
 * SAMPLE.T
 * Complete source of the example mini-adventure presented in Chapter 1 of  
 * the WorldClass Authors Manual. This closely matches the sample
 * mini-adventure presented in the TADS manual, with some improvements.
 */

#include <world.t>      /* read in the WorldClass system */

path: Outside           /* Note the use of Outside rather than Room */
   sdesc = "Outside cave"
   ldesc = "You're standing in the bright sunlight just outside
	of a large, dark and foreboding cave to the north, into which the
        north/south path enters."
   goNorth = cave       /* Note that go<direction> is used now */
verGoSouth(actor) = { "Adventure beckons; you have no wish to leave."; }
;

cave: Room                      /* Note that the Room class is capitalised */
   sdesc = "Cave"
   ldesc = "You're inside a dark and musty cave.  Sunlight
	pours in from a passage to the south. "
   goSouth = path
;

Me: Player      /* Create a player controlled actor */
   location = path      /* Give it an inital loaction */
   locationtype = 'in'  /* the player will be "in" the path room */
   position = 'standing'        /* the player will be standing */
;

pedestal: Fixture, Surface
   noun = 'pedestal'
   heredesc = { "A pedestal stands in the center of the cave."; }
   sdesc = "pedestal"
   ldesc = "A large bone-white pedestal rests in the cave center.
	It provides no clues as to it's original purpose."
   location = cave
;

goldSkull: Item
   noun = 'skull' 'head'
   adjective = 'gold'
   sdesc = "skull"
   ldesc = "The skull is of the purest gold, and sparkles in that
	special way that only gold sparkles like."
   location = pedestal
   locationtype = 'on'
;

modify Item
   weight = 3
;

modify pedestal
    movingout(obj, actor, loctypes) =
      {
      if (self.contentsweight(actor, ['on']) - obj.weight < 3)
	{
        "\bAs %you% <<XtakeVerb.desc(global.lastactor)>> the
         <<obj.subjsdesc>>, a volley of arrows is shot from the walls!
         %You% ";
        if (actor.isplural) "try"; else "tries";
	" to dodge the arrows, but they take %you% by surpise!";
	die();
	}
      pass movingout;
      }
;

smallRock: Item
   sdesc = "small rock"
   ldesc = "It's a rock; sedimentary to be precise. It's
	smooth and rounded as if it has been been
	in a river for a long period of time."
   noun = 'rock'
   adjective = 'small'
   location = cave
;

bones: Sensor, Fixture
   sdesc = "bones"
   ldesc = "A large jumbled pile of bones, the remains of
      some poor adventuer no doubt, lie bleaching in the
      sun."
   heredesc = { "A large pile of bones lie bleaching in the sun."; }
   isplural = true
   noun = 'bones' 'skeleton'
   location = path
;

skeleton: Actor
   sdesc = "skeleton"
   ldesc = "A large skeleton, minus a skull, stands before you,
      arm outstretched and waiting, as if for you to give it
      something."
  noun = 'skeleton'
  actordesc = { self.ldesc; }
;

modify path
  enter(actor) =
      {
      if ( bones.cansee (goldSkull, goldSkull.locationtype, true) and bones.location <> nil )
	{
	 P(); I();
	"As %you% arrive";
        if (not actor.isplural) "s";
        ", the bones suddenly start jiggling with increasing speed until they
        suddenly rise and form themselves into a skeleton, which is
        conspicuously missing it's skull."; P();
	bones.movein(nil);
	skeleton.movein(path);
	}
      pass enter;
      }
  leave(actor) =
    {
    if ( goldSkull.isin(actor) )
      {
      "As %you% leave";
      if (not actor.isplural) "s";
      ", the skeleton crumbles back into a pile of bones."; P();
      bones.movein(path);
      skeleton.movein(nil);
      }
    }
;

modify skeleton
   ioGiveto(actor, dobj) =
      {
      if (dobj = goldSkull)
	{
	"The skeleton accepts your gift of the skull, and after
	attaching it in some manner to it's neck, strides off
	into the sunset.";
	skeleton.movein( nil );
	goldSkull.movein( nil );
	}
      }
;
