/*
 * Autosave.t
 *
 * This provides the full implementation of an autosave function.
 *
 * To use this unit, simply add a #include line into your program. Autosaving
 * is by default turned off, and can be turned on and off by way of the
 * "autosave on" or "autosave off" commands. The turns between saves is by
 * default 40, but this can be adjusted via the "autosave xx" command, where
 * xx is the turns between saves the player desires. Typing "autosave" on it's
 * own will also print the above information to the player.
 *
 * This module has been built to work with WorldClass.
 * Copyright (C) 1994 by Paul Gilbert
 *
 * Usage of this module or of code/therein requires that you give mention to
 * the usage of my module within your code.
 */

modify global
  autosavefile = nil
  autosavestatus = nil
  turnsbetweensaves = 40
;

autosave: function(parm)
  {
  local savefile;

  if (global.turns - global.lastsave > global.turnsbetweensaves)
    {
    if ( global.autosavefile = nil )
      {
      "\n";
      savefile := askfile('Filename for autosave game');
      if (savefile = nil or savefile = '')
        "Failed.";
      else if (save(savefile))
        "Save failed. ";
      else
        {
        "Saved.";
        global.autosavefile := savefile;
        global.lastsave := global.turns;
        }
      "\b";
      }
    else
      {
      if (save(global.autosavefile))
        "\b*** Warning : Autosave operation failed ***\b";
      global.lastsave := global.turns;
      }
    }
  }
AutosaveonVerb: Systemverb, Soloverb
  verb = 'autosave on'
  sdesc = "autosave on"
  soloaction(actor) =
    {
    if ( global.autosavestatus )
      "\b*** Autosave is already on ***\n";
    else
      {
      "\b*** Autosave is now on. Game will be saved every ";
      say( global.turnsbetweensaves ); " turns ***\n";
      global.lastsave := global.turns;
      global.autosavestatus := true;
      setdaemon(autosave, nil);
      }
    abort;
    }
;

AutosaveoffVerb: Systemverb, Soloverb
  verb = 'autosave off'
  sdesc = "autosave off"
  soloaction(actor) =
    {
    if ( global.autosavestatus )
      {
      "\b*** Autosave is now turned off ***\n";
      remfuse(autosave, nil);
      }
    else
      "\b*** Autosave is already turned off ***\n";
    abort;
    }
;

AutosaveVerb: Systemverb
  verb = 'autosave'
  sdesc = "autosave"
  doAction = 'Autosave'
  action(actor) =
    {
    "\bAutosave is currently "<< global.autosavestatus ? "on" : "off" >>
     \ and set to save every "; say (global.turnsbetweensaves); " turns.\b";
    "Use 'autosave on' or 'autosave off' to turn the autosave function on
     or off, and use 'autosave' followed by a value to set the turns between
     autosaves.\nDuring the first autosave you will be prompted for a
     filename, which will be subsequently used.\n";
    abort;
    }
;

modify Number
  verDoAutosave( actor ) = {}
  doAutosave( actor ) =
    {
    if ( value > 1 )
      {
      global.turnsbetweensaves := value;
      "\b*** Autosave is set to every "; say(value); " turns  ***\n";
      }
    else
      "\b*** Autosave value is too low ***\n";
    abort;
    }
;
