/*******************************************************************
 *******************************************************************
 * Verbs for acting like a dog
 *******************************************************************
 */


modify sitVerb
    action (actor) =
    {
	    stayVerb.action(actor);
    }
;

compoundWord 'continue' 'watching' 'continuewatching';

stayVerb: deepverb
	verb = 'stay' 'watch' 'continuewatching'
	action (actor) = 
	{
	"You sit in place, in a dignified fashion. \n";
	actor.location.stay;
	}
;

wanderVerb: deepverb
	verb = 'wander' 'wander around' 'wander around aimlessly'
	action (actor) = 
	{
		if (actor.location.infenway)
		{
			if (actor.location = fenway_5)
  		{
  			actor.travelTo(fenway_18);
  		}
  		else
  		{
  			actor.travelTo(fenway_5);
  		}
  	}
	}
;

modify againVerb
	verb = 'continue' 
;

compoundWord 'do' 'nothing' 'donothing';

nothingVerb: deepverb
	verb = 'donothing'
	sdesc = "%do% nothing"
	action(actor) =
	{
	    "%You% %do% nothing.";
	    if (actor.location = juggler.location
		and juggler.performance_sequence > 0)
		"It's an uncomfortably long pause, and everyone is
		 staring at you. The pressure is mounting. After a few
		 more tantalizing moments, the 
		 juggler repeats his question.
		  <P><<actor.location.ldesc>>";
	    actor.location.repeat_q := true;
	    actor.location.donothing := true;
	}
;


hesitateVerb: deepverb
    verb = 'hesitate'
    sdesc = "hestitate"
    action (actor) =
    {
	" You hesitate for a moment...\n ";
    }	
;
    
compoundWord 'knock' 'off' 'knockoff';

modify attackVerb
    verb = 'knockoff'
    doAction = 'Attack'
;

modify knockVerb
    ioAction(offPrep) = 'KnockOff'
;

biteVerb: deepverb
	verb = 'bite' 'scratch' 'claw'
	sdesc = 'bite'
	doAction = 'Attack'
;


peeVerb: deepverb
    verb = 'pee' 'piss' 'mark'
    'pee on' 'piss on' 'mark on'
    sdesc = "mark"
    action(actor) =
    {
	"Depite your schooling, you mark this as your territory.";
	actor.location.marked := true;
	incscore(-1);
    }
    doAction='PeeOn'
;
    

barkVerb: deepverb
	verb = 'bark' 'roof' 'woof' 'arf' 'ruff'
	sdesc = "bark"
	action(actor) = { 
		"Ruf!\n";
		if (actor.location.verDoBark(actor))
		    actor.location.doBark(actor);
		}
	doAction = 'Bark'
;

growlVerb: deepverb
	verb = 'growl' 'growl at'
	sdesc = "growl at"
	action(actor) = {
	    if (actor.location = tourists.location)
	    {
		tourists.doGrowl(actor);
		exit;
	    }
	}
	doAction = 'Growl'
;

compoundWord 'roll' 'over' 'rollover';

rollVerb: deepverb
	verb = 'roll' 'rollover'
	sdesc = "roll over"
	action(actor) =
		{ "%You% roll over, like master trained you, getting plenty of dirt in your fur in the process.";}
;

howlVerb: deepverb
	verb = 'howl'
	sdesc = "howl"
	action(actor) = 
		{ "Aroooooo! aROOOOOOOO!\n";}
;

wagVerb: deepverb
	verb = 'wag'
	sdesc = "wag"
	action(actor) = 
		{ "You wag your tail happily.";}
	doAction = 'Wag'
;

tail: fixeditem
	noun = 'tail'
	adjective = 'my'
	location = Me
	sdesc = "%Your% tail"
	ldesc = "%Your% tail"
	verDoWag(actor) = {}
	doWag(actor) = {"You wag your tail happily";}
;

drool: fixeditem
	noun = 'drool' 'spit' 'puddle'
	location = nil
	sdesc = "a puddle of drool."
	ldesc = "A puddle of drool. You must have left your mouth hanging open earlier."
;

droolVerb: deepverb
	verb = 'drool'
	action(actor) = 
	{
		"You open your mouth and let your tounge hang out.\n
		soon a puddle of drool has collected at your feet.";
		drool.moveInto(actor.location);
	}
;

temptVerb: deepverb
    verb = 'tempt'
    sdesc = "tempt"
    action(actor) = {"Tempt who?\n ";}
    doAction = 'Tempt'
;

fate: decoration
    location = Me
    noun = 'fate'
    sdesc = "Fate"
    ldesc = "A supernatural force that determines your destiny. It is
	     best not to tempt fate"
    verDoTempt(actor) = {}
    doTempt(actor) =
    {
	"Congratulations. You have defied authority, and made your own
	 decision despite the pressure of others. We respect both
    courage and strong will. In general, you are highly encouraged to
    continue choosing  your own path. ";
	if (actor.location = fanual_hall
	    and juggler.performance_sequence > 0)
	    {
		" Do not be discouraged by the
		 following events. 
		 <P>\n
		 An old lady noticing that your are sneaking out, decides to
		 give you a gentle scolding. She takes her umbrella
		 and bashes you over the head, hitting you again and
		 again, until the next thing you know you wake up in...
		 <P>\n
		 CLICK HERE TO FIND OUT\n";
		morePrompt();
		juggler.performance_sequence := 0;
		Me.travelTo(infirmary);
		unnotify(fanual_hall,&lose_patience);
		unnotify(fanual_hall,&impatient);
		fanual_hall.exit_attempt := nil;
	    }
    }
;

eyes: decoration
    noun = 'eye' 'eyes'
    verDoOpen(actor) = {}
    doOpen (actor) =
    {
	"You open your eyes and see..\n
	 <<actor.location.lookAround(true)>>";
    }
;

modify eatVerb
	verb = 'swallow'
;

modify inspectVerb
  verb = 'contemplate'
;


compoundWord 'high' 'tail' 'hightail';
compoundWord 'run' 'away' 'runaway';
compoundWord 'slink' 'away' 'slinkaway';

modify outVerb
    verb = 'hightail' 'slink' 'slinkaway' 'run' 'runaway'
;


useVerb: deepverb
	verb = 'use'
	doAction='Use'
;


modify takeVerb
	verb = 'catch'
;

/*******************************************************************
 *******************************************************************
 * Verbs for game control
 *******************************************************************
 */

helpVerb: deepverb
	verb = 'intro' 'introduction' 'help' 'hint'
	sdesc = 'help'
	action (actor) =
	{
	   "This is a slice of life/ treasure hunt text adventure.
	    the object of the game is to retrieve THE STICK.
	    the other object of the game is to explore the MIT campus
	    as it was described by Jeff Breidenbach in 1994.\n
	    One function of the original game was to demonstrate the 
	    capabilities of the, then new, world wide web.
	    Ironically, you are playing a version that has been ported to TADS 
	    by John Huebner (john@john.huebner.name).
	    \n
	    for information on changing game options type <b>gameverbs</b>\n
	    for a list of verbs a dog can use type <b>dogverbs</b>\n
	    for a list of miscelaneous verbs specific to this game type
	    <b>miscverbs</b>";
       }
;

dogVerb: deepverb
    verb = 'dogverbs'
    sdesc = "list canine verbs"
    action (actor) =
    {
	  "Verbs specific to playing a dog in this game:\n
	<ul>
	   \t<li>bark</li>\n
	   \t<li>do nothing</li>\n
	   \t<li>drool</li>\n
	   \t<li><b>examine</b> the sun: gives the aproximate time of day</li>\n	   
	   \t<li><b>growl at</b> someone</li>\n
	   \t<li>howl</li>\n
	   \t<li>roll over</li>\n
	   \t<li>run</li>\n
	   \t<li>smell</li>\n
	   \t<li>stay</li>\n
	   \t<li>wag your tail</li>\n
	   And, of course, \n
	   \t<li> <h1> FETCH</h1> </li>\n";
      }
;

	   
miscVerb: deepverb
    verb = 'miscverbs'
    sdesc = "list miscelaneous verbs"
    action (actor) =
    {
	  "Verbs specific to playing this game:\n
	   
	   \t<li><b>check out</b> something</li>\n
	   \t<li>commit Hari Kari</li>\n
	   \t<li>get mad</li>\n
	   \t<li>help</li>\n
	   \t<li>high tail it</li>\n
	   \t<li>wimper</li>\n
	   \t<li>shake it off</li>\n
	   \t<li>sink into depression</li>\n
	   \t<li>use</li>\n
	   \t<li>wallow in self pity</li>\n
	   </ul>
	   Also, when in a subway station you can just type the name of the station that you would like to go to. 
	   ";
}
;

gameVerb: deepverb
    verb = 'gameverbs' 'cheat'
    sdesc = "list verbs that change game preferences"
    action (actor) =
    {
	  "(Many of these could be considered 'cheating', I will leave that
	   moral judgement up to you)\n
	   Verbs that change game preferences:\n 
	   \t<li><b>realtime</b>: time in the game is the same as time in the real world.<i>(default)</i></li>\n
	   \t<li><b>accellerated</b>: each turn takes 15 minutes.</li>\n
	   \t<li><b>teleport</b>: you can teleport to any train station, even if there is no train present and you are not standing in a train station.</li>\n
	   \t<li><b>noteleoport</b>: only board trains from stations, if a train is present.<i>(default)</i></li>\n
	   \t<li><b>linear</b>: you must solve the puzzles in the intended order.<i>(default)</i></li>\n
	   \t<li><b>non-linear</b>: you may solve the puzzles in any order</li>\n
	   \t<li><b>setlevel</b>: in linear mode, tell the game that some puzzles have already been solved.</li>\n
	   \t<li><b>time</b>: report the game time in hours and minutes on a 24 hour clock.</li>\n
	   </ul>\n ";
}
;

timeVerb: deepverb
	verb = 'time'
	sdesc = "time"
	action (actor) = {
	        local hourstr, minutestr;
		hourstr := cvtstr(hour());
		if (minute() < 10)
		    minutestr := '0' + cvtstr(minute());
		else
		    minutestr := cvtstr(minute());
		if (global.realtime)
			"You are playing in 'realtime' mode.\n"; 
		else 
			"You are playing in 'accellerated' mode.\n";
		"It is approximately <<hourstr>>";
		":<<minutestr>> hours.\n";
	}
;


realtimeVerb: deepverb
	verb = 'realtime'
	sdesc = "realtime"
	action (actor) = {global.realtime := true;}
;
accelleratedVerb: deepverb
	verb = 'accellerated'
	sdesc = "accellerated"
	action (actor) = {global.realtime := nil;}
;

teleportVerb: deepverb
    verb = 'teleport'
    sdesc = 'cheat by teleporting'
    action(actor) = {"You can now cheat by teleporting to
		      any train station without a train.\n
		      \n
		       You could also try 'set level' to
		      cheat on your progress through the puzzles.\n";
		      global.teleport := true;
		 }
;

compoundWord 'play' 'fair' 'playfair';
compoundWord 'don\'t' 'cheat' 'dontcheat';
    
noteleportVerb: deepverb
    verb = 'noteleport'
    sdesc = 'only board trains from stations'
    action (actor) = {"You can now only board trains from the proper
		       train station.\n";
		      global.teleport := nil;
		  }
;

compoundWord 'set' 'level' 'setlevel';
    
setlevelVerb: deepverb
    verb = 'setlevel'
    sdesc = "set the level of your progress"
    action (actor) = {
	local level;
	"Enter the desired level:";
	level := cvtnum(input());
	if (global.linear)
	    setlevel(level);
    }
;

linearVerb: deepverb
    verb = 'linear'
    sdesc = "make the puzzles in the game linear"
    action (actor) =
    {
	global.linear := true;
	setlevel(global.game_level);
	locker_stick.real := nil;
	"The puzzles in the game are now linear.\n
	 You will need to solve the first puzzle before
	 attempting the second puzzle.\n
	 You have currently solved <<global.game_level - 1>> puzzles.\n ";
    }
;


levelon: function (level)
{
    switch (level)
    {
      case 0: /* commons */
	start_stick.moveInto(startroom);
	break;
      case 1: /* firehouse */
	rubbish_stick.moveInto(rubbish);
	break;
      case 2: /* airport */
	terrorist_stick.moveInto(baggage_with_stick);
	break;
      case 3: /* chinatown */
	break;
      case 4: /* quincy market */
	juggler.performance_sequence := 0;
	juggler.moveInto(fanual_hall);
	jugglers_hat.moveInto(nil);
	jugglers_bag.moveInto(nil);
	fanual_hall.repeat_q := nil;
	fanual_hall.donothing := nil;
	fanual_hall.donothing := nil;
	unnotify(fanual_hall,&lose_patience);
	unnotify(fanual_hall,&impatience);

	break;
      case 5:/* chinatown ninjas */
	medallion.moveInto(Me);
	break;
      case 6: /* south station */
	break;
      case 7: /* fake */
	break;
      case 8: /* fenway */
	break;
      case 9: /* finale */
	break;
    }	      
}

leveloff: function (level)
{
    switch (level)
    {
      case 0: /* commons */
	start_stick.moveInto(nil);
	break;
      case 1: /* firehouse */
	rubbish_stick.moveInto(nil);
	break;
      case 2: /* airport */
	terrorist_stick.moveInto(nil);
	break;
      case 3: /* chinatown */
	break;
      case 4: /* quincy market */
	juggler.performance_sequence := 0;
	juggler.moveInto(nil);
	jugglers_hat.moveInto(nil);
	jugglers_bag.moveInto(nil);
	break;
      case 5:/* chinatown ninjas */
	medallion.moveInto(nil);
	break;
      case 6: /* south station */
	break;
      case 7: /* fake */
	break;
      case 8: /* fenway */
	break;
      case 9: /* finale */
	break;
    }	      
}

setlevel: function (level)
{
    local i;
    global.game_level := level;
    for (i:=0; i <= 9; i++)
    {
	if (i <> level)
	{
	    leveloff(i);
	}
    }
    levelon(level);
}

nonlinearVerb: deepverb
    verb = 'nonlinear' 'non-linear'
    sdesc = "make the puzzles in the game non-linear"
    action (actor) =
    {
	local level;
	global.linear := nil;
	for (level :=1; level <= 9; level++)
	    levelon(level);
	locker_stick.real :=true;
	"The puzzles in the game are now non-linear.\n
	 You can solve them in any order,
	 If you wish to go back to playing linearly, type 'linear'.";
    }
;

smellVerb: deepverb
	verb = 'smell' 'sniff'
	call_count = 0
	action(actor) = {	
		if (actor.location.smell = nil  )
		{
		     "It smells like <<actor.location.sdesc>>. ";
		}
		else
		{
			say (actor.location.smell );
		}
	}
	doAction = 'Smell'
;

replace sleepVerb: deepverb
	verb = 'sleep' 'doze' 'doze off'
	action (actor) = 
	{
		incturn(8);
		"You sleep for a good two hours. ";
		if (actor.location.infenway)
		{
			"When you wake up, all refreshed, you
       notice that it is the same inning. This game is going on forever.
       You can either
       <UL>\n
       <LI> <b>Continue</b> watching the game.\n
       <LI> <b>Doze</b> off again\n
       <LI> Check out the <b>beer and hot dogs</b>\n
       <LI> <b>Wander</b> around aimlessly\n
       </UL>";
     }
     "\n ";
	}
;

modify thing
  verDoSmell(actor) = {}
  doSmell( actor ) =
  {
    "It smells like <<self.adesc>>. ";
    if (self.marked)
	"You have marked this spot.";
  }
;

settingsVerb: deepverb
    verb = 'settings'
    action(actor) = {
	"level = <<global.game_level>>\n";
	"linear = <<global.linear?'yes':'no'>>\n";
	"teleport = <<global.teleport?'on':'off'>>\n";
	"fetch attempt = <<cvtstr(Me.fetch_attempt)>>";
    }
;
compoundWord 'check' 'out' 'checkout';

checkoutVerb: deepverb
    verb = 'checkout'
    doAction = 'Inspect'
;

replace numObj: basicNumObj
    verDoPush(actor) = 
    {
    	if (actor.location.buttons = nil)
    	{ "I don't know what you are trying to press"; }
    }
    doPush(actor) =
    {
	actor.location.buttons.doPush(actor);
    }
    doSynonym('Push') = 'Touch' 'Type'
;

