red_line: room
	sdesc = "Red Line on the T"
	ldesc = "The conductor shouts: This train make stops at
<ul>\n
<li> <b>Hahvard</b></li>\n
<li> <b>Central Square</b> </li>\n
<li> <b>Kendall (MIT)</b></li>\n
<li> <b>Park Street </b> (Change to green line)</li>\n
<li> <b>South Station</b></li>\n
</ul>\n
<p>(To ride to a stop, type the name of the station)</p>
<PRE>
\n
\n
</PRE>

 <P> An extremely detailed <b>subway map</b> adorns the wall</p>"
;

trainVerb: deepverb
    sdesc = "ride to <<destination.sdesc>> station."
    verAction (actor) =
    {
     local i, max;
     max := length(self.origins);
     for (i := 1; i <= max; i++)
     {
	 if (origins[i] = actor.location)
	 {
	     return true;
	 }
     }
     "You need to be on a <<origins[1].sdesc>> subway car to get
      to <<self.sdesc>>.\n ";
     return global.teleport;
    }
    rideTo(actor,dest) = 
    {
    	"<p>You get on the subway train and ride to the
	 <<dest.sdesc>> stop. </p>\n";
	actor.travelTo( dest );
    }
    action (actor) =
    {
	if (self.verAction(actor))
	    self.rideTo(actor,destination);
	else
	    "You cannot get there from here.\n ";
    }
;  

compoundWord 'hahvard' 'square' 'hahvardsquare';
compoundWord 'harvard' 'square' 'harvardsquare';

harvardVerb: trainVerb
    verb = 'harvard' 'hahvard' 'harvardsquare' 'hahvardsquare'
    destination = harvard_square
    origins =[red_line]
;

compoundWord 'central' 'square' 'centralsquare';

centralSquareVerb: trainVerb
    verb = 'centralsquare'
    origins =[red_line] 
    destination = central_square
;


compoundWord 'kendall' 'square' 'kendallsquare';

KendallVerb: trainVerb
    verb = 'kendall' 'mit' 'kendallsquare'
    destination = kendall_t
    origins =[red_line]
;


compoundWord 'kendal' 'square' 'kendalsquare';

KendalVerb: deepverb
    verb = 'kendal' 'kendalsquare'
    action(actor) =
    {
	"<p>Kendal<b>l</b> has two 'l's!<p>\n";
    }
;

compoundWord 'park'  'street'  'parkstreet';

ParkStreetVerb: trainVerb
    verb = 'parkstreet'
    sdesc = "ride to Park Street station."
    destination = nil
    verAction(actor) =
    {
     if ( actor.location = green_line )
     {
	 destination := red_line;
     }
     else
     {
	 destination := green_line;
     }
     pass verAction;
    }
    origins =[red_line green_line]
;

compoundWord 'south' 'station' 'southstation';

SouthStationVerb: trainVerb
    verb = 'southstation'
    origins =[red_line]
    destination = south_station
;

green_line: room
	sdesc = "Green Line on the T"
	ldesc = " The conductor shouts: This train make stops at
<ul> 
<li> <b>Riverside</b>\n
<LI> <b>Hard Rock Cafe</b>\n
<LI> <b>Fenway Park</b>\n
<li> <b>Chinatown</b>\n
<li> <b>Quincy</b>\n
<li> <b>Park Street</b> (Change to red line)\n
<li> <b>Govt Center</b> (Change to blue line)\n
</ul>\n

<p>(To ride to a stop, type the name of the station)</p>
<PRE>
\n
\n
</PRE>

 <P> An extremely detailed <b>subway map</b> adorns the wall</p>"
;


RiversideVerb: trainVerb
    verb = 'riverside'
    origins =[ green_line ] 
    destination = riverside
;


compoundWord 'hard' 'rock' 'hardrock';
compoundWord 'hardrock' 'cafe' 'hardrockcafe';

HardRockCafeVerb: trainVerb
    verb = 'hardrock' 'hardrockcafe'
    origins =[green_line]
    destination = hardrock
;

compoundWord 'fenway' 'park' 'fenwaypark';

FenwayParkVerb: trainVerb
    verb = 'fenwaypark'
    origins =[green_line]
    destination = fenway
;

ChinatownVerb: trainVerb
    verb = 'chinatown'
    origins =[green_line]
    destination = chinatown
;

compoundWord 'quincy' 'market' 'quincymarket';

QuincyVerb: trainVerb
    verb = 'quincy' 'quincymarket'
    origins =[green_line]
    destination = quincy_market
;


blue_line: room
	sdesc = "Blue Line on the T"
	ldesc = " The conductor shouts: This train make stops at
<ul> \n
<li> <b>Wonderland</b>\n
<li> <b>Revere Beach</b>\n
<li> <b>Airport</b>\n
<li> <b>Government Center </b>(Change to green line)\n
</ul>\n
<p>(To ride to a stop, type the name of the station)</p>
<PRE>
\n
\n
</PRE>

 <P> An extremely detailed <b>subway map</b> adorns the wall</p>"
;

;

class subway_map: fixeditem, readable
	noun = 'map'
	adjective = 'subway'
	sdesc = "subway map"
	ldesc = "<img src='artwork/mbta.png'>"
;


red_subway_map: subway_map
    location = red_line
;

green_subway_map:  subway_map
    location = green_line 
;

blue_subway_map: subway_map
    location = blue_line 
;


WonderlandVerb: trainVerb
	verb = 'wonderland'
	action(actor) =
	{
		"<p><I>This particular car is not continuing all the way
		 to Wonderland.</I></p>";
		self.rideTo( actor, blue_line );
	}
	origins = [ blue_line ]
;


compoundWord 'revere' 'beach' 'reverebeach';

RevereVerb: trainVerb
    verb = 'reverebeach'
    origins =[ blue_line ]
    destination = revere
;

compoundWord 'logan' 'airport' 'loganairport';

AirportVerb: trainVerb
    verb = 'logan' 'airport' 'loganairport'
    origins = [ blue_line ]
    destination = logan
;

compoundWord 'red' 'line' 'redline';

redLineVerb: trainVerb
    verb = 'redline' 'red'
    action(actor) =
    {
	if (actor.location = green_line or global.teleport)
	{
	    "<p>You climb down the stairs at Park Street station
	     to get to the red line </p>";
	    actor.travelTo( red_line );
	}
	else
	{
	    "<p>You need to get to Park Street to get on the green line. \n";
	}
    }
;

compoundWord 'blue' 'line' 'blueline';

blueLineVerb: trainVerb
    verb = 'blueline' 'blue'
    action(actor) =
    {
	if (actor.location = green_line or global.teleport)
	{
	    "<p>You cross Government Center station to get to the
	     blue line </p>";
	    actor.travelTo( blue_line );
	}
	else
	{
	    "<p>How?</p>";
	}
    }
;


compoundWord 'green' 'line' 'greenline';

greenLineVerb: trainVerb
    verb = 'greenline' 'green'
    action(actor) = {
	if (actor.location = blue_line or global.teleport)
	{
	    "<p>You cross Government Center station to get to the green line </p>";
	    actor.travelTo( green_line );
	}
	else if (actor.location = red_line)
	{
	    "<p>You climb up the stairs at Park Street station to get to the green line </p>";
	    actor.travelTo( green_line );
	}
	else
	{
	    "<p>How?</p>";
	}
    }
;

compoundWord 'government' 'center' 'governmentcenter';
compoundWord 'govt' 'center' 'govtcenter';

GovtCenterVerb: trainVerb
    verb = 'govtcenter' 'governmentcenter'
    destination = nil
    verAction(actor) =
    {
     if ( actor.location = green_line )
     {
	 destination := blue_line;
     }
     else
     {
	 destination := green_line;
     }
     pass verAction;
    }
    origins = [blue_line green_line]
;


GovtVerb: deepverb
    verb = 'govt'
    action(actor) = {
	"TADS really doesn't like it when you use punctuation in
	 words like 'govt.', so just leave the punctuation out.";
    }
;

kendall_t: room
    sdesc = "Kendall Sq. T Station"
    ldesc = {
	"<p>Here there is a bunch of grimy tile walls, and a few
	 benches for people to sit and wait for the train ";
	if (!time_frequent(1))
	    " (which isn't here yet) ";
	"</p>
	 <p>There is a <b>sign</b> here, bidding bad omens for canines. A <b>lever</b> is attached to the wall.<p>
	 
	 You can go <b>west</b> or ";
	if (time_frequent(0))
	    "<b>in</b> the train.";
	else
	    "<b>wait</b> for the train.";
    }
    status =
    {
	if (time_frequent(0))
	    "A train arrives in the station, and passengers start
	     to get <b>in</b> and out.<p>\n ";
	else
	    "Still no train here";
	
    }
    west = {
	unnotify(kendall_t,&status);
	return art_deco;
    }
    in = {
	if (time_frequent(0))
	{
	    unnotify(kendall_t,&status);
	    return red_line;
	}
	else
	{
	    "There is no train to get into. Please wait for the
	     next train to arrive.<p>\n ";
	    return nil;
	}
    }
;

dog_sign: fixeditem, readable
    location = kendall_t
    noun = 'sign'
    adjective = 'dog'
    sdesc = "sign"
    ldesc = "The sign says:<p><h1> NO DOGS ALLOWED</h1></P> <P><p>Luckily, they seem to be a little lax in enforcement.</p>"
    readdesc = "The sign says:<p><h1> NO DOGS ALLOWED</h1></P> <P><p>Luckily, they seem to be a little lax in enforcement.</p>"
    
;

musical_lever: fixeditem
    location = kendall_t
    noun = 'lever'
    adjective = 'musical'
    sdesc = "lever"
    ldesc = "This lever seems to be connected to some suspected pipes by pulleys and wires"
    verDoPull( actor ) = { return true; }
    doPull( actor ) =
    {
	"As you swing the lever back and forth (with your mouth, of course), a set of hammers plays <i>tones</i>
	 on a set of suspended pipes - it's really kind of impressive.";
	incscore(5);
    }
    verDoPush( actor ) = { return true; }
    doPush( actor ) = 
    {
	"As you swing the lever back and forth (with your mouth, of course), a set of hammers plays <i>tones</i>
	 on a set of suspended pipes - it's really kind of impressive.";
    }
;


riverside: room
    sdesc = "Riverside"
    ldesc = "<p>You are at the urban boundary, where city turns to suburb. It's a very dull transition.</p>
	     <P>You can get back <b>in</b> the trolly car.</p>"
    in = green_line
;

hardrock: room
    sdesc = "Hard Rock Cafe"
    ldesc = "<p>The music is pumping, the <b>line</b> is long, and the waitresses are beautiful.</p>
	     <P>You can get back <b>in</b> the trolly car.</p>"
    in = green_line
;

hardrock_line: fixeditem
    location = hardrock
    noun = 'line'
    adjective = 'long'
    sdesc = "long line"
    ldesc = "There are two constants in life - a long line at the Hard Rock Cafe and death. Taxes are just highly probable. "
;


revere: room
    sdesc="Revere Beach"
    ldesc ="<p>This is a nice quiet place to relax, right? You stretch out on the beach and doze for an indeterminate amount of time.</p>
	    <p>You can get back <b>in</b> the subway car</p>"
    in = blue_line;
;

#include "quincy.t"
#include "fenway.t"
#include "chinatown.t"
#include "harvard.t"
#include "logan.t"
#include "south_station.t"
