
stud_center: room
    sdesc = "Student Center"
    ldesc = "There are some stairs here.
	      <P> A huge pile of <b>fliers</b> are laying about.
	     There is also
	     a <b>trash can</b> here.<p>
	     You can go
	     <b>up</b>
	     or
	     <b>out</b>
	     <P> <img src='artwork/jab13.png'><P>"
    up = lobdell
    out = grassy_area
    south = grassy_area
;

fliers: fixeditem
    noun = 'flier' 'fliers' 'pile' 'pamphlet'
    adjective = 'pile' 'of'
    sdesc = "a pile of fliers"
    ldesc = 
    {
			"Everything seems to be ";
      	if(time_group1())
      	    "leftist";
      	else
      	    "rightist";
      	" propaganda.<br>\n";
    }
    location = stud_center
;

lobdell: room
    sdesc = "Slobdel Dining"
    ldesc = {"<STRONG> Home of Campus Food. </STRONG>  <P> There is an
	     inspirational <b>inscription</b> above the door,";
		 if (munchies.location = self)
		     "and some <b>munchies</b> are lying about.<p>";
	     "You may travel
	     <b>up</b>
	     or
	     <b>down</b>";
	 }
    up = athena
    down = stud_center
;

inscription: fixeditem, readable
    noun = 'inscription'
    adjective = 'inspirational' 'gilded' 'gold'
    sdesc = "an inspirational <b>inscription</b> above the door"
    ldesc = "Golden, hand carved letters welcome visitors <P>
	     <UL>
	     <I>Abandon All Hope Ye Who Enter Here</I></UL>\n"
    location = lobdell
;

munchies: item
    noun = 'munchies' 'food' 'taco' 'tacos'
    adjective = 'soggy' 'looking'
    sdesc = "munchies"
    ldesc = "The collection of soggy looking tacos gives off a not so
	     tantalizing aroma."
    location = lobdell
    verDoEat(actor) = {}
    doEat(actor) = {
	"The collection of soggy looking tacos gives off a not so
	 tantalizing aroma, but you eat one anyway; after all, it
	 <I>is</I> food.<p>
	 Delicious.\n";
	self.moveInto(nil);
    }
;

athena: room
    sdesc = "Athena Cluster"
    ldesc = "<b>Computers</b> here. A <b>poster</b> adorns the wall.<p>
    You can go
    <b>down</b>"
    down = lobdell
;

computers: fixeditem
    noun = 'computers' 'terminals' 'workstations' 'computer'
    'terminal' 'workstation'
    adjective = 'athena'
    location = athena
    sdesc = "Workstation"
    ldesc = "You grab a terminal. You are welcome to use MIT's main
	     computer system, provided you have an account.<p>\n
	     A friendly window invites you to <b>log in</b><p>\n
	     <hr><p>\n
	     <h3>Please note:</h3>\n
	     For those without accounts, breaking into the athena
	     system is not part of the game, and is also generally
	     frowned upon."
    verDoLogin (actor)= {}
    doLogin (actor) = {
	"athena.dialup.mit.edu: Unencrypted connection
	 refused. Goodbye.";
    }
;

compoundWord 'log' 'in' 'login';

loginVerb: deepverb
    verb = 'login'
    action(actor) =
    {
	if (Me.location = athena)
	    "athena.dialup.mit.edu: Unencrypted connection
	     refused. Goodbye.";
	else
	    "Log in to <b>WHAT?</b>";
    }
    doAction = 'Login'
;

multivac_poster: fixeditem, readable
    noun = 'poster'
    adjective = 'multivac'
    sdesc = "poster"
    location = athena
    ldesc = "<H2>The sign reads\:</H2>
	     <HR>
    <B>Analog\:</B><I> something that resembles something else;
    parallel</I>
    <HR> <P> A mind consists of neurons, tied together through an
    immensely complicated network. The pathways and structures are
    twisted, furled and collectively intelligent. <P>

    Isaac Asimov predicted Multivac. <P>

    AC stands for analog computer.
    Welcome to the Internet.
    No food or drinks in the cluster, please."
;
pierce_boat_house: room
;

lobby_7: room
    sdesc = "Lobby 7"
    ldesc = "The high domed ceiling gives the feeling of a cathedral.
	     <p>
	     A <b>campus map</b> and a <b>trash bin</b> adorn the room. <P>
	     You can travel <b>outside</b> or <b>east</b> down the hall."
    out = mass_ave_77
    west = mass_ave_77
    east = infinite_corridor
;

campus_map: fixeditem
    noun = 'map'
    adjective = 'campus'
    sdesc = "Campus Map"
    ldesc = "<h1>Map of MIT</h1>
	     <img src='added_images/mitmap.png'>"
    location = lobby_7
	     
;

class trashbin_class: fixeditem, container
    noun = 'can' 'bin'
    adjective = 'trash' 'garbage'
    sdesc = "Trash can"
    ldesc = { local n;
	"The can is half full with the usual odds and ends. There seems
	     to be some shredded papers in here - you can vaguely make out
	     some words. \"Hillary Clinton\" and \"Whitewater\" catch your
	     eye, but since dogs are above politics, you don't give the
	     matter a second thought. There is also a copy of yesterday's
	     <b>newspaper</b> lying about.";
	    if (length(self.contents) = 0)
	    {
		n := new newspaper;
		n.win := time_group1();
		n.moveInto(self);
	    }
	  }
;

class newspaper: readable
    noun = 'newspaper' 'paper'
    adjective = 'yesterday\'s' 'news'
    sdesc = "newspaper"
    isEquivalent = true
    ldesc = {
	"This is yesterday's newspaper. It is worthless, out of date, not
	 current, displaced, and obsolete. Who cares that the Red Sox";
	if (self.win)
	    " won ";
	else
	    " lost ";
	"again?";
    }
    readdesc = self.ldesc
;

lobby_7_trashbin: trashbin_class
    location = lobby_7
;
stud_center_trashbin: trashbin_class
    location = stud_center
;
    

infinite_corridor: room
    sdesc = "Infinite Corridor"
    ldesc = "The hallway feels longer every time you walk it. <p>
	     <p>
	     You can travel
	     <b>east</b> or <b>west</b>"
    west = lobby_7
    east = lobby_10
;

lobby_10: room
    sdesc = "Lobby 10"
    ldesc = "A granite WWII memorial dominates the area.
	     <p>
	     You can travel
	     <b>west</b> or <b>east</b> or go outside to the <b>south</b> "
    east = infinite_corridor_2
    west = infinite_corridor
    south = killian_court
;

infinite_corridor_2: room
    sdesc = "Infinite Corridor"
    ldesc = "The hallway feels longer every time you walk it. <p>
	     <p>
	     You can travel
	     <b>east</b> or <b>west</b>"
    east = green_building
    west = lobby_10
;

skyscraper: fixeditem
    noun = 'scraper' 'skyscraper' 'building'
    adjective = 'sky'
    sdesc = "skyscraper"
    ldesc = {
	"Upon closer inspection, you note that this 22 story building has
	 two vertical slits sliding all the way up. Each slit is
    about three feet deep and three feet wide - it looks like a notch,
    or in mountain climbers jargon, a chimney. <P>\n";
    if (time_rare())
	 "To your immense surprise, you see that some fool without ropes is
    busily working his way up the building - and is around the 14th
    floor or so.";
	"<p><img src='artwork/jab1.png'><p>\n";
    }
		
;

green_building: room
    sdesc = "The Green Building"
    ldesc = "A <b>skyscraper</b> towers before you.<p>\n
	     You can go
	     <b>east</b> or <b>west</b>"
    west = infinite_corridor_2
    east = art_deco
;

media_lab: room
    sdesc = "MIT Media Lab"
    ldesc = "There seems to be a lot of shaggy grad students here.<p>
	     As you look to the <b>left</b> and look
	     to the <b>right</b> you realize that there is more
	     to the place than meets the eye.
	     <P>
      	     You can go back
	     <b>out</b>side"
    out = art_deco
    north = art_deco
;

holo: fixeditem
    noun = 'left' 'hologram' 'likeness' 'Denisyuk'
    adjective = 'holographic'
    location = media_lab
    sdesc = "hologram"
    ldesc = "A holographic likeness of Yuri Denisyuk stares into the
	     void. You feel an urge to look away. <P>"
;

www: fixeditem
    noun = 'right' 'web' 'www' 'game' 'adventure'
    adjective = 'world' 'wide' 'whimsical'
    location = media_lab
    sdesc = "world wide web"
    looked = nil
    ldesc = {
	if (!self.looked)
	{
	    "The cutting edge researchers here are studying the future
    of media. This particular group is examining the World Wide Web,
    and specifically, a whimsical Boston based adventure that has 
    been recently posted. As you wander in, you realize that these
    people are playing the exact same game that you are a character
    in. It's enough to give you the willies.
	      <P>\n
	     You can <b>look</b> more closely, or step back quietly.";
	    self.looked := true;
	}
	else
	    Me.travelTo(reboot);
    }
;

rebootVerb: restartVerb
    verb = 'reboot'
;

reboot: room
    sdesc = "Error"
    ldesc = "<H1>Error!</H1>
	     <P>
	     <STRONG>Paradox. Paradox. Cannot compute. Recursion
	     impossible. Paradox.
    Warning\: unrecoverable error.</STRONG>
					  
					   <P>
					       
     This was, as they say, a bad move.
     Unfortunately, the universe that you currently inhabit now has a
     system error.
     We suggest that you <b>reboot</b>
     immediately.
      <P>
      Good job buddy, you just crashed the universe."
;

med_center: room
    sdesc = "Medical Center"
    ldesc = "You have a bad feeling about this place. A couple of
	     private rooms connect to the <b>east</b>.<p>
	     There is a <b>poster board</b> here.
	     <P>
	     You can go <b>out</b>side
	     <P> <img src='artwork/jab11.png'><P>"
    nw = art_deco
    north = art_deco
    out = art_deco
    east = {
	     "Sorry, these rooms are for patients only. Furthermore, the
    door is closed, and you haven\'t yet discovered a good method for turning
    doorknobs. (All those other doors you've gone through have been the
    push open variety)";
	     return nil;
	 }
;

poster_board: fixeditem
    noun = 'poster' 'board'
    adjective = 'buliten' 'poster'
    location = med_center
    sdesc = "poster board"
    ldesc = "<H3>Medical Center message board</H3>
	     Looks like a lot of people have put up stuff. You can
	     read whatever you want. <P>\n
	     <OL>\n
	     <LI> <b>Help wanted</b>\n
	     <LI> <b>Used car for sale</b>\n
	     <LI> <b>apartment for rent</b>\n
	     <LI> <b>a message scrawled in blood</b>\n
	     </OL>\n
	     "
;

class posted_message: fixeditem, readable
    location = med_center
    noun = 'poster' 'message' 'announcement'
;

help_wanted: posted_message
    noun = 'help' 'wanted'
    adjective = 'help' 'wanted'
    sdesc = "Help Wanted"
    ldesc = "<H2>HELP WANTED</H2>
	     I'm trapped here against my will. They keep trying to
    sedate me. For God's sake if you get this message, send help. I
    don't think I can hold out much longer. The keep me locked in the
    upstairs cl - 
	      <P>\n
	     The handwriting breaks off.";
;

ferrari: posted_message
    noun = 'car' 'sale' 'ferrari'
    adjective = 'used' 'car' 'ferrari' 'for'
    sdesc = "Used car for sale"
    ldesc = {
	"<TITLE>Ferrari</TITLE>
	 Late model red two seater. $2000 or best offer.\n
	 \t<I>Honest Bob</I>";
	notify(ferrari,&hide_title,3);
    }
    hide_title = "<TITLE>Drool</TITLE>";
;
roomate: posted_message
    noun = 'appartment' 'rent' 'roomate' 
    adjective = 'appartment' 'for' 'rent' 'roomate'
    sdesc = "appartment for rent"
    ldesc = "&gt;&gt;&gt;&gt;&gt;  Are you a
    ... &lt;&lt;&lt;&lt;&lt;&lt;\n
	     <UL>\n
	     <LI> horseshoe throwing\n
	     <LI> snapple guzzling\n
	     <LI> finger biting\n
	     <LI> vegetarian?\n
	     </UL>\n
	     If so, check out 429 Beacon Street (located conveniently
	     off the green line)\n"
;

blood: posted_message
    noun = 'blood'
    adjective = 'message' 'scrawled' 'in' 'bloody'
    sdesc = "a message scrawled in blood"
    ldesc = "<CODE>\n
	     \n
	       They weren't demons after all
	     -- Mere Mortals
	     \n
	     </CODE>";
;

infirmary: room
    sdesc = "Med Center"
    ldesc = "You are lying on a towel in what can only be a
	     veterinarian's office. A few more cuts and bruises are
	     quietly healing. There is a <b>medical
	     chart</b> next to you. <P>\n
	     The only one <b>exit</b> to the room." 
    out = med_center
;

medical_chart: fixeditem
    noun = 'chart'
    adjective = 'medical'
    location = infirmary
    sdesc = "medical chart"
    ldesc = {
	"You read the chart, ignoring scrawled numbers and
    undecipherable signatures.
	 \n
	 <I>";
	if (time_group1)
	{
	    "Scruffy looking <<parserGetMe().breed>> was picked up on 
	     the street. Seems a little sickly - we're not ruling
	     out the possibility of mono. Looks like
	     the poor thing has been through a war, or at least
	     a heavy metal concert. Has ";
	    if (Me.flea_count >0)
		" fleas, and ";
	    " a couple of cuts. ";
	}
	else
	{
	    "John Dog - no identification.
	     Found bleeding on the street. Has ";
	    if (Me.flea_count >0)
		" fleas, and";
	    " bad breath.
	     Also a few bruises. No rabies.
	     We'll run a test for mono.\n";
	}
	 "</I>\n";
    }
;

