harvard_square: room
	sdesc = "Harvard Square"
	ldesc = "People stroll about. There is a train station here.<p>
A <b>sign</b> is next to the street. <P>

You can go:
<b>north</b>, 
<b>down</b>,
or
 <b>south</b>  <P>
<img  src='artwork/jab12.png'></P>"
	north = harvard_yard
	down = red_line
	south = ice_rink
;

parkingSign: fixeditem
	location = harvard_square
	noun = 'sign'
	adjective = 'parking'
	sdesc = "parking sign"
	ldesc = "The sign says:<H1>No Parking</H1>
These ubiquitous signs keep the traffic ticket people quite busy. A simple but not popularly understood thought springs to mind: <P>
<PRE>
 Boston + Car = Mistake
</PRE> 
 <P> <img align=top src='artwork/jab8.png'><P>"
;



harvard_yard : room
	sdesc = "Harvard Yard"
	ldesc = "There is a silly looking
<b>statue</b> here.<p>

You can travel <b>north</b> or <b>south</b>

<P> <img src='artwork/jab4.png'><P>"
	north = science_center
	south = harvard_square	
;

john_harvard: fixeditem
	noun = 'statue' 'john harvard'
	adjective = 'dumb' 'silly' 'silly looking'
	location = harvard_yard
	sdesc = 'dumb statue'
	ldesc = "You notice some burn marks around one of the fingers, as if there
 something had once been spot welded to the statue."
;

ice_rink: room
	sdesc = "Ice Rink"
	ldesc = "This collegic ice rink exudes sweat and pain. There are two booklets lying on a bench. The <b>first</b> 
contains dramatic action photos (completely unrelated to your quest), while the second one is labelled <b>\"HINTS\"</b><p>

You can go <b>north</b>"
	north = harvard_square
;

hockey_booklet: readable
	noun = 'booklet'
	location = ice_rink
	adjective = 'first' 'hockey'
	sdesc = "Hockey Booklet"
	ldesc = "<p>Unfortunately this booklet is slightly worse for wear. It appears to have been stepped on and torn, though you can still make out some words in the corner:</p>
<pre>http://www.mit.edu:8001/afs/athena.mit.edu/user/j/b/jbreiden/hockey/internet/top.html</pre>"
;

hint_booklet: readable
	noun = 'booklet'
	location = ice_rink
	adjective = 'second' 'hint'
	sdesc = "Hint Booklet"
	ldesc = "This booklet doesn't seem helpful. All it has is a map showing the
exact <b>location</b> of the sacred \"stick\". Too bad you have trouble reading maps."
	readdesc ="<H1>Error 40B</H1>
File not readable - and besides, a map would make your life much too easy.</B>
<P><HR><ADDRESS>CERN httpd 2.17bogus</ADDRESS>"
;

science_center: room 
	sdesc = "Science Center"
	ldesc = "The building you are in has unusual construction - the different floors are tiered, producing what some say resembles a pyramid, a hanging
		garden, a Polaroid Instamatic camera, or just a complete lack of aesthetics.<p>
		There is an
		elevator
		<b>in</b> the back attended to by a 
		<b>security guard.</b><p>\n
		The only exit is <b>out</b>.\n"
	signed_in = nil
	gruff = 
	{
		if(self.signed_in)
		{
			return elevator;
		}
		else
		{
			"<p><I>The security guard grumbles, \"Sign in\" and blocks your way.</I></p>\n";
			self.lookAround(true);
			return nil;
		}
	}
	in = self.gruff
	north = self.gruff
	out = harvard_yard
	south = harvard_yard
;

signVerb: deepverb
	verb = 'sign' 'sign in'
	sdesc = "sign in"
	action (actor) =
	{
		if (actor.location <> science_center)
		{
			"You do not know where to sign!";
		}
		else
		{
			"After a brief glance at your collar, he points to the sign-in book, 
			to which you dutifully place a paw print.";
			actor.location.signed_in := true;
		}
	}
;
	
security_guard: fixeditem 
	noun = 'guard'
	adjective = 'security' 'gruff'
	location = science_center
	sdesc = 'security guard'
	ldesc = 
	{
		"<p><I>The fellow is making anyone who uses the elevator sign in and 
		present identification. ";
		signVerb.action(parserGetMe());
		"</I></p>";
	}
;


elevator: room
	sdesc =	"Elevator"
	ldesc = "This is a <b>high speed lift.</b>\n
		\n
		There are eight possibilities.\n
		<ul>\n
		<li>8</li>\n
		<li>7</li>\n
		<li>6</li>\n
		<li>5</li>\n
		<li>4</li>\n
		<li>3</li>\n
		<li>2</li>\n
		<li>1</li>\n
		</ul>"
	buttons = elevator_button

;


class elevator_button: fixeditem, numObj
    location = elevator
    noun = 'button' 'key'
    sdesc = "button <<value>>"
    
    ldesc = "It is a button on the elevator panel. The numeral <<value>> is printed in the
    center of the plastic circle. "
    verDoPush(actor) = {}
    doPush(actor) =
    {
	"You push button <<value>> on the keypad.\n ";
	switch (value)
	{
	  case 1: actor.travelTo(science_center);
	  	break;
	  case 4: actor.travelTo(aromas);
	  	break;
	  case 8: actor.travelTo(stairwell);
	  	break;
	  default: actor.travelTo(worthless);
	  	break;
	}
    }
;



button_1: elevator_button
    noun = '1' 'one'
    adjective = 'first'
    value = 1
;

button_2: elevator_button
    noun = '2' 'two'
    adjective = 'second'
    value = 2
;

button_3: elevator_button
    value = 3
    noun = '3' 'three'
    adjective = 'third'
;

button_4: elevator_button
    value = 4
    noun = '4' 'four'
    adjective = 'fourth'
;

button_5: elevator_button
    value = 5
    noun = '5' 'five'
    adjective = 'fifth'
;

button_6: elevator_button
    value = 6
    noun = '6' 'six'
    adjective = 'sixth'
;

button_7: elevator_button
    value = 7
    noun = '7' 'seven'
    adjective = 'seventh'
;

button_8: elevator_button
    value = 8
    noun = '8' 'eight'
    adjective = 'eighth'
;

button_9: elevator_button
    value = 9
    noun = '9' 'nine'
    adjective = 'ninth'
;

button_10: elevator_button
    value = 10
    noun = '10' 'ten'
    adjective = 'tenth'
;



worthless: room
	sdesc = "Worthless area"
	ldesc = "There is nothing worthwhile on this floor.
		You go back <b>in</b> the elevator.\n "
	in = elevator
	north = elevator
;

aromas: room
	sdesc = "Fourth Floor"
	ldesc = "There is nothing worthwhile on this floor, except tantalizing aromas
		of wine and cheese. But no time for pleasure! Must press onwards!
		Must.. continue... must... fetch STICK!
		You go back <b>in</b> the elevator "
	in = elevator
;

stairwell: room
	sdesc = "Stairwell"
	ldesc = "You see a
		<b>sign</b><p>
		 A twisting flight of stairs leads
		 <b>upwards</b>.
		You can also go <b>in</b> the
		elevator here. "
	up=observitory
	in=elevator
;

loomis: fixeditem, readable
	location = stairwell
	noun = 'sign'
	adjective = 'chipped' 'blue'
	sdesc = "sign"
	ldesc = "The chipped blue sign reads<p>
		<h1> Loomis Michael Observatory </h1>
		and there is an arrow pointing upwards."

;

observitory: room
	sdesc = "Telescope"
	ldesc = 
	{ 
	  "This room is great. The first thing you notice is that the whole
		ceiling is encompassed by a spherical aluminum housing.
		
		In the middle of the room sits a large telescope with a ten inch
		lens.<p>\n";
		if (self.open)
		{"\n
		<i>A panel in the aluminum housing has slid back to allow you a clear view of
the outside</i></p>\n";
		}
		"<p>\n
		There are lots of things in here like:
		<ul>
		<li> a <b> log book</b>\n
		<li> a  <b> desk light</b>\n
		<li> a <b> wall switch</b> hanging on the wall\n
		<li> a <b> base switch </b> at the base of the scope\n
		<li>   an <b>eyepiece</b> on a <b>bench</b>\n
		<li> a cool sliding <b>chair</b>\n
		<li>     a huge <b>telescope </b> to look through

		</ul></p><p>\n A set of stairs leads <b>down</b>. \n ";
	}
	down = stairwell
;

chair: fixeditem
	noun = 'chair'
	adjective = 'swivel'
	sdesc = "swivel chair"
	ldesc = "The old wooden construction is a wonder to observe. In order to
get the most flexible possible setting, there are wheels underneath
to allow the whole structure to rotate around the perimeter of the room.<p>

In addition, the chair is spring loaded so as to roughly balance one's
weight anywhere between ground level and six feet high. A light person
might experience quite a catapult effect."

	location = observitory
;

tracking: fixeditem
	noun = 'switch'
	adjective = 'base' 'tracking'
	sdesc = "switch at the base of the scope."
	ldesc = "This switch is labeled \"Tracking\" and seems to be connected to a set
of very slow, very precise motors. The goal here is to compensate for the
rotation of the earth.<p>\n
"
	location = observitory
	verDoTurnOff(actor) = { "The switch is already off.\n"; }
	verDoSwitch(actor) = { "Unfortunately the switch seems to be
				permanently stuck in the \"off\" position.
				So much for time exposure photographs.\n"; }
	verDoTurnOn(actor) = { self.verDoSwitch(actor); };

desk_light: fixeditem
	noun = 'light'
	adjective = 'desk'
	sdesc = "desk light"
	ldesc = "This is a standard lamp, however, 
					the bulb inside is only fifteen watts and has a red filament. 
					There is barely enough light to see anything."
	location = observitory
;

bench: fixeditem, surface
	noun = 'bench' 'table'
	adjective = 'lens'
	location = observitory
	sdesc = "lens bench"
	ldesc = "There is a clean 22mm ocular lying on a bench. An infinite supply of scratchy eyepieces of other powers also are lying about."
;


logbook: fixeditem, readable
	noun = 'book' 'logbook'
	adjective = 'log'
	sdesc = "log book"
	ldesc = 
	{
		local logfile, line, i;
		logfile := fopen('logbook.txt','rt');
		"<h2> Telescope Log </h2>";
		/*for (i:=1; i < 5; i++)*/
                line :=  fread(logfile);
		while (line)
		{
			"<<line>>";
	                line :=  fread(logfile);
		}
		
		fclose(logfile);
		"\n\nThere is a <b>pen</b> clipped to the log book.";
	}
	location = observitory
;

pen: fixeditem
	noun = 'pen' 'intrument'
	adjective = 'writing'
	location = observitory
	sdesk= "pen"
	ldesc = "The ball point pen is clipped to the log book"
	verDoUse(actor) = {}
	doUse(actor) = 
	{
		"You try (by picking up the pen in your mouth) 
		scrawl your own observations in the logbook,
		but the pen is out of ink"; 
	}
;


		

wall_switch: fixeditem
	noun = 'switch'
	adjective = 'wall'
	sdesc = "wall switch"
	ldesc = "A switch hanging on the wall."
	verDoTurnon(actor) = {}
	doTurnon(actor) =
	{
		observitory.open := true;
		observitory.lookAround(true);
	}
	verDoTurnoff(actor) = {}
	doTurnoff(actor) =
	{
		observitory.open := nil;
		observitory.lookAround(true);
	}
	verDoSwitch(actor) = {}
	doSwitch(actor) =
	{
		observitory.open := not (observitory.open);
		observitory.lookAround(true);
	}
	location = observitory
;

eyepiece: item
	noun = 'lens' 'eyepiece'
	adjective = 'objective'
	sdesc = "eyepiece"
	ldesc = "This is a clean 22mm ocular eyepiece. "
	location = bench
	eaten = nil
	verDoTake(actor) = 
	{
		if (global.linear and !observitory.open)
		{
			"There is no point in picking up the eyepiece right now. 
			Try someting else first. ";
		}
	}
	doTake(actor) =
	{
			"A few options for consideration:
			<ul> \n
      <li> <b>Put</b> the eyepiece in the <b>telescope</b>\n
      <li> <b>Put</b> the eyepiece back on the <b>table</b>\n
      <li> <b>Swallow it</b>\n
      </ul>\n";
      inherited.doTake(actor);
	}
	verDoPut(actor)={}
	doPut(actor)={}
	verDoEat(actor)={}
	doEat(actor)=
	{
		"<p>You munch the eyepiece, like all your food, without chewing. It
			wasn't great, but then again, you've tasted worse.</p>\n
			<p>You may <b>contemplate the flavor</b> some more, or
			continue fiddling with the <b>telescope</b>.";
			self.moveInto(bench);
			self.eaten := true;
	}
;

flavor: fixeditem
	noun = 'flavor'
	location = eyepiece
	sdesc = "flavor"
	ldesc = "Yep, it tasted like aluminum and glass, sort of similar to
			eating a hard rock with sharp edges.<p>\n
			<p>You may <b>contemplate the flavor</b> some more, or
			continue fiddling with the <b>telescope</b>."
;

telescope: fixeditem
	noun = 'telescope'
	adjective = '10 inch'
	location = observitory
	sdesc = "telescope"
	ldesc = 
	{
		if (observitory.open and eyepiece.location = telescope)
			{
				if (time_night())
				{ /* Night open with eyepiece */
				  "<p>Using the telescopes precision
	optics and superior canine vision to overcome the
	disadvantages of city light pollution, you see far into the
	cosmos.</p>
				   \n
	<p>Celestial fireworks hurtle by.</p>\n
        <img src='added_images/sl9q_calar.PNG'>\n";
				incscore(10);				
				 }
				else /* day open with eyepiece */
				{
					"<p>The daytime sun makes it impossible to gaze into the cosmos. You swing
          the telescope around and focus in on Boston. You adjust the scope
          until you can see the Commons. Hey, there is master. He's been waiting
          a long time. He seems disappointed, probably because you have not yet
          retrieved the stick.</p>\n
          \n
           <P>You feel horrendously guilty.</p>\n";
				}
			}
		else /* either closed dome or missing eyepiece */
		{
			"<p>Strangely, you can't see anything at all while looking through the telescope.</p>\n ";
		}
	}
	verDoLookthru(actor) = {}
	doLookthru(actor) = {self.ldesc;}	
	verDoLookin(actor) = {}
	doLookin(actor) = {self.ldesc;}
	verIoPutIn(actor) =
	{
		if (global.linear and !observitory.open)
		{
			" There is no point in putting things in the telescope right now. 
			Try someting else first. \n";
		}
  }
	ioPutIn(actor,dobj) =
	{
		if (dobj = eyepiece)
		{
			dobj.moveInto(telescope);
		}
		else
		{
			"<<dobj.thedesc>> does not seem to fit in the telescope\n ";
		}
	}
;

