fenway: room
	sdesc = "Fenway Park"
	ldesc = "<p>This is the home of those awful Red Sox. A completely-irrelevent-to-this-game  <b>schedule</b>
is stuck to the wall. <P>

An open gate awaits your entrance <b>in</b> to it. </p>
 <P>Also, you can go back <b>down</b> into  the subway station.</p>"
	down = green_line
	in = fenway_2
;

compoundWord 'red' 'sox' 'redsox';

redsox_schedule: fixeditem, readable
	location = fenway
	noun = 'schedule'
	adjective = 'redsox'
	sdesc = "RedSox Schedule"
	ldesc = "<p>I'm just a TADS interpreter, how would I know?</p> 
		<p>try 'http://boston.redsox.mlb.com/NASApp/mlb/bos/schedule/bos_schedule_calendar.jsp'</p>"
	readdesc = "<p>I'm just a TADS interpreter, how would I know?</p> 
		<p>try 'http://boston.redsox.mlb.com/NASApp/mlb/bos/schedule/bos_schedule_calendar.jsp'</p>"
;


class fenway_room: room
    sdesc = "Fenway Park"
		infenway = true
    stay = 
    {	
    		if (fenway_2.sequence < 3)
    		{
    			fenway_2.sequence += 1;
    		}
    		fenway_2.ldesc;
    }
    out = green_line
;

fenway_2: fenway_room
		sequence = 1
		watched = nil
    ldesc = 
    {
			if (global.game_level = 8 or not (global.linear))
			{
				switch (sequence)
				{
					case 1:
      	      "You must have wandered in at just at the right time. The stadium is
                packed. (At least by this stadium's standards) Looks like the Red Sox
                are playing another team of close caliber, because the 30,000 person
                crowd is pretty excited. You smell beer, peanuts, smoke - all those
                nostalgic ballpark memories come back. Like the time you chased an entire
                Little League team around the Esplanade two years back.
                 <P>\n
                Ah, baseball. There seem to be a lot of options. ";
                notify(self,&stay,3);
          			break;
   				case 2: 
   						"The Spangled Banner is belted out over the loudspeakers. You
          			watch as the players take to the field, lazily tossing the ball
          			around. Ah, baseball. ";
                notify(self,&stay,3);
       				break;
       		case 3: "Despite your intense scrutiny, nothing much is happening. The
                   pitchers take turns throwing a ball, and once in a while someone
                   gets a whack at it. Neither team seems to be getting any runs,
                   and you are too far away to really see much. ";
                 unnotify(self,&stay);
                 break;
          case 4: "There is no longer any
                  reason to stay here.
                   <P>
                  You may <b>leave</b> the stadium.";
                  notify(self,&secure,3);
                  break;
          case 5: "Ha! There is no way that they'd ever let you back in here. Big burly
                  security people encourage you to move on.
                  <P>\n You may go to the <b>subway</b>";
                  break;
					}
					
          "<P>\n
          You can either
          <UL>\n ";
          if (watched)
            {
            	"<LI> <b>Continue</b> watching the game.\n "; 
            	watched := true;
            }
          else
            {"<LI> <b>Sit</b> and watch the game.\n "; }
          "<LI> <b>Doze</b> off
          <LI> Check out the <b>beer</b> and <b>hot dogs</b></A>\n
          <LI> <b>Wander</b> around aimlessly\n
          </UL>\n";
          "</UL>\n";
        }
        else
        {
          "No one is here. The place is deserted. Come back when there is more
          action.
          
          <P>\ You may go <b>out</b> to the subway";
        }   
    }
    secure = { "Secure. "; sequence := 5; }
    east = fenway_5
    west = fenway_18
    north = fenway_4
;

beer_dogs_smell: fixeditem
 /* fenway-4 */
	noun = 'beer' 'dog' 'dogs' 'dawg' 'dawgs'
	adjective = 'hot' 
	location = fenway_2
	sdesc = "beer and hot dogs"
	ldesc = {self.doSmell(parserGetMe());}
	doSmell(actor) = {actor.travelTo(fenway_4);}
  verDoTake(actor) = {}
  doTake(actor) = 
  {
  	"<p>While the concession guy isn't looking, you swipe one of his items.
      Delicious!</P>
       <P>
      You may
      <UL>\n
      <LI> <b>Sit and watch</b> the game\n
      <LI> Check out the <b>beer and hot dogs</b>\n
      <LI> <b>Wander</b> around aimlessly\n
      </UL>\n ";
  }
;

fenway_stick: stick_class
    location = fenway_25 
    real = true
    doTake(actor) =
    {
			inherited.doTakeBase(actor);
			"You grab the <b>stick</b>. ";
        fenway_2.sequence := 4;
        actor.travelTo(fenway_2);
    }
;
    
fenway_5: fenway_room
	sdesc = "Fenway Park"
	ldesc = 	"Trotting around the stands aimlessly is getting a little tiring. There
							are just too many people here. You do stumble across some <b>pamphlets</A>
							scattered across the ground.
				  <P>\n
        You find a <b>baseball glove</b> lying
        on one of the box seats.
         
        <UL>
        <LI> <b>Continue</b> watching the game.
        <LI> <b>Doze</b> off
        <LI> <b>Wander</b> around aimlessly
        </UL>"
    east = fenway_18
    west = fenway_2
    north = fenway_4
;
       			
fenway_18: fenway_room
	ldesc = "Yeah, right. You don't like baseball for the same reason you don't
        like polo. Who wants to watch a bunch of millionaires hitting a
        ball around? As the game starts, you wander about.
				  <P>\n
        You find a <b>baseball glove</b> lying
        on one of the box seats.
         
        <UL>
        <LI> <b>Continue</b> watching the game.
        <LI> <b>Doze</b> off
        <LI> <b>Wander</b> around aimlessly
        </UL>"
    east = fenway_2
    west = fenway_5
    north = fenway_4
;

fenway_4: fenway_room
	ldesc = "You follow your nose. The ground is quite sticky to walk through, but
          eventually you close in on a fellow loudly yelling, <B>Get your hot
          dawgs, heah.  Hot dawgs!</B>
           <P>\n
          Do you want to to try to grab a hot dog? "
    east = fenway_5
    west = fenway_18
    south = fenway_2
;

beer_dogs: fooditem
 /* fenway-4 */
	noun = 'beer' 'dog' 'dogs' 'dawg' 'dawgs'
	adjective = 'hot' 
	location = fenway_4
	sdesc = "beer and hot dogs"
	ldesc = "The hot dogs look delicious! "
	doSmell(actor) = "The meaty aroma of the hot dogs is irresistable. "
  verDoTake(actor) = {}
  doTake(actor) = 
  {
  	"<p>While the concession guy isn't looking, you swipe one of his items.
      Delicious!</P>
       <P>
      You may
      <UL>\n
      <LI> <b>Sit and watch</b> the game\n
      <LI> Check out the <b>beer and hot dogs</b>\n
      <LI> <b>Wander</b> around aimlessly\n
      </UL>\n ";
  }
  doSynonym('Take') = 'Eat'
;

pamphlets: fliers
	location = fenway_18
;

glove: item
	noun = 'glove'
	adjective = 'baseball'
	sdesc = "baseball glove"
	ldesc = {self.doTake(parserGetMe()); }
	location = fenway_5
	doTake(actor) =
	{
		unnotify(fenway_2,&stay);	
		actor.travelTo(fenway_17);
	}
;

fenway_17: room
	theglove = 'It'
	ldesc = {"<<self.theglove>> is attached to a young kid - wait a minute, you recognize this guy.
          It's the little <b>tyke</b> from the Boston
          Commons. The one who stole your stick. Nothing good could come
          from hanging out with him.
          
           <P> As you are about to leave, you hear a loud
          <STRONG>crack!</STRONG> Somebody has hit a foul ball, and against all
          odds, it's heading straight towards you.
          
           <P>
          <UL>
          <LI> <b>Catch the ball</b>
          <LI> <b>Run away!</b>
          </UL>";
          theglove := 'The glove';
          }
   stay = "If you want to attack the child, you'd have to open your mouth. That would
          mean dropping the ball, which is exactly what the little kid wants. Never!
          During the time spent doing this logical reasoning, you receive two whacks
          on the head from the kid's umbrella. <P>\n
          The only feasible solution here is to <b>run</b>
          like greased lightning.\n "
   out = fenway_22
 ;

ball: item
	noun = 'ball' 'baseball'
	sdesc = "baseball"
	location = fenway_17
	bulk = 10
	doTake(actor) = 
	{
		"
      With brilliant timing, you leap into the air, make a spectacular
      mouth grab, then do two and a half somersaults and a half pike twist
      before landing into the cheering crowd.
       <P>
      Meanwhile, the nearby child decides that he really wants to have that
      baseball. The youngster charges at you, screaming, and wielding
      an umbrella.
       <P>
      <UL>
      <LI> <b>Stay and fight</b>
      <LI> <b>Run!</b>
      </UL> ";

	}
; 

fenway_22: room
	sdesc = "Fenway Park"
	ldesc = "A dramatic high speed chase follows. You weave in and out through the
          crowd, with the psychotic kid hot on your tail. You leap over railings.
          He scrambles over seats. Fans get knocked down right and left.
           <P>\n
          Finally, both of you peel around the corner, right into a crowd of
          concession people. The resulting impact creates a scene of mass
          chaos.
           <P>\n
          There are
          <UL>\n
          <LI> A bunch of <b>concession people</b>
          scattered across the ground\n
          <LI> A crowd trying to get <b>free beer</b>\n
          </UL>\n "
;


free_beer: fixeditem
	noun = 'beer'
	adjective = 'free'
	sdesc = "free beer"
	ldesc = "What do you expect? This is after all Fenway Park. You can't even get near the area. 					The crowd has surrounded the fallen beer salesman with Homer Simpson 
					caliber stubbornness. "
	location = fenway_22
;


concession_people: fixeditem
	noun = 'people'
	adjective = 'concession'
	sdesc = "concession people"
	ldesc = { parserGetMe().travelTo(fenway_25); }
	location = fenway_22
;

fenway_25: room
	sdesc = "Fenway Park"
	ldesc = "Yikes! The hot dog guy is slumped over the railing. Popcorn slowly billows
          down, amid ice cream bars and peanut shells. There are chunks of rocks
          scattered about, and it looks like the soda guy collided pretty hard
          with the cotton candy vendor.
          
          Amid all the rubble, you notice, gleaming amid the spilt pretzels and
          weiners, what can only be a miracle. It is the <b><STRONG>stick!</STRONG></b> You have
          found it again.
          
           <P> <b>GET THE STICK</b>"
;
