chinatown: room
	sdesc = "Chinatown"
	ldesc = "<p>Even the dirt is covered with grime. You can go back <b>down</b> into the subway station,</p>
<p>you can go <b>west</b> into a dangerous looking alley </P>
<p>or follow the main street <b>south</b></p>"
	down = green_line
	west = alley
	south = china_shops
;

alley: room
// dynamic this is sometimes dangerous
	sdesc = {
			"Alley";
		   }
	
	secret_deployed = nil	
	ldesc = {
		"You are in a dark and dangerous area. While Boston\'s Combat Zone
has been on the decline in recent years, seedy bars, porn shops,
and random street violence still exist. Random <b>graffitti</b> adorns the walls.<p>";	
	}
	firstseen = {		notify(alley, &warning, 0);}
	warning = 
	{
		if (time_night())
		{
			"<p><i>Perhaps it was not so wise to come here at night!</i> <P>
A man wearing a white chef\'s hat is running at you with a large
meat cleaver! <P>
			<p>Quickly, you run through your list of options</p>
			<ol>\n
			<li><b>Stay</b> and get turned into kanji</li>\n
			<li><b>High tail</b> it out of here</li>\n";
			if (weapon.location = Me
			    and weapon.deployed <> (time_group1()?1:2))
				"<LI><b>Use your secret weapon</b>\n";
			"</ol>\n";
			notify(alley, &stay, 3);
		}
		else
		{
			"<h2>Beware!</h2>
 			<P>
			You may go back <b>east</b>";
		}
	}
	stay = {
		unnotify(alley,&warning);
		unnotify(alley,&stay);
		alley.isseen := nil;

		if (Me.location = alley)
		{
		"<P>
You stand your ground. No matter what the cost you're not backing
down. Nope, no matter what, no one is going to call this pooch a coward.
No Sireee.

<p><hr><p>

<I>
You watch in horror as the crazed cook whacks you again and again and
again with his meat cleaver. Blood is splattering everywhere. This is
the type of scene that would get cut when broadcast over network
television. <P>

Soon, everything starts to go blank. Could this be the end? Will
Rover survive?  Press a key to find the <b>gripping answers...</b></I>";
						morePrompt;
						Me.moveInto(infirmary);
						incturn(8);
						infirmary.lookAround(true);
						alley.isseen := nil;

		}
	}
	east = exit_alley()
	out = exit_alley()

;

weapon: item
	noun = 'Aegis' 'weapon' 'system'
	       'box'
	adjective = 'secret' 'my' 'ship-to-air' 'anti' 'missle' 'defence'
	            'glass'
	location = Me
	sdesc = "secret weapon"
	ldesc =
	{
	    if (time_group1())
	    {
		"Your trusty Aegis ship-to-air anti missile defense
		 system, ";
		if (deployed <> 1)
			"It has never been deployed.";
		else
			"It has already been used, and needs maintenance.";
	    }
	    else
	    {
		if (deployed <> 2)
		    "a small glass box, with a hammer
		     attached to it via chain. There is block
		     writing printed on
		     the box, reading IN CASE OF EMERGENCY,
		     USE HAMMER TO BREAK GLASS.<p>\n";
		else
		    "an empty biscut wrapper";
	    }

	}
	deployed = 0
	verDoUse (actor)= 
	{ 
	    if (actor.location <> alley)
		if (time_group1())
		    "You shouldn't use that here. Think of the havoc
		     it would cause!<p>\n ";
		else
		    "You don't think this is the emergency that your
		     secret weapon was meant for.<p>\n ";
	}
	doUse (actor) =
	{
	    if(time_group1())
		"Good thing you brought your trusty Aegis ship-to-air
		 anti missile
defense system along. You flip on the multimillion dollar device (always
a good idea) and lock the radar guided high caliber rapid fire Gatling
guns directly on the unsuspecting chef. Within milliseconds, the computer
has locked on target, and awaits only the final instructions for firing.
 <P>
To be safe, you also deploy a squadron of F-16 fighters, two of which are
carrying classified but very lethal nuclear payloads, while the others
carry more innocuous cluster bombs.
 <P> Unfortunately, the F-16's still produce more of a radar signature
than a meat cleaver, and your air defense systems automated friend or
foe recognition system is out of calibration. The aircraft are shot
down one by one, causing widespread damage, but that does not deter
the chef. He keeps on coming.
 <P>";
	    else /* group 2 */
		"You pull out a small glass box, with a hammer
	attached to it via chain. There is block writing printed on
	the box, reading IN CASE OF EMERGENCY, USE HAMMER TO BREAK
	GLASS. This seems like as good a time as any.
		 <P>
	Smash. Tinkle. Tinkle. You a brush away the fragments of glass
	to reveal a package of doggy biscuits. This is fantastic! You
	gobble down the biscuits one at a time, savoring their flavor
	and aroma for a few short seconds. Food is so good - and these
	were the crunchy type too. You can hardly sit still, you like
	doggy biscuits so much. Yum, yum! <P>\n
		 It's been quite a while since you've had biscuits as
	good as these. Yes, last time was when master gave... the
	thought of master brings a flood of sadness. You have let him
	down. Oh, where, where is the stick? You glance up, and
	through teary eyes, see that a man in a white hat is still
	coming at you with a meat cleaver. \n\n"; 
	self.deployed := time_group1()?1:2;
	incscore(10);
	actor.location.lookAround(true);	
	}
;

exit_alley: function
{
	unnotify(alley,&warning);
	unnotify(alley,&stay);
	if (time_night())
		{
			"<hr><p> <I>As you run for your life, the crazed cook takes swipe after swipe
at you. You manage to make it to the subway, but not entirely
unscathed. It looks as though the encounter cost you a wee bit
of you tail, more of a wound to your pride than anything else.
</I><P><hr><p>";
			return green_line;
		}
	else
		return chinatown;
}


graffitti: fixeditem
	location = alley
	noun = 'graffitti'
	sdesc = "graffitti"
	ldesc = "
The paint is smeared and dirty, but you think that you can make
out a few words. You see some initials like T.C. + N.L. circled
with a crude heart. There are also some specialized signatures,
of which only a letter or two at best are intelligible."
;
	
china_shops: room
	sdesc = "Shops"
	ldesc = "
There are a few commercial establishments here. <P>
\n
<B>
Looks like there's
</B>
<UL>\n
<LI> 	a restaurant to the <b>south</b>\n
<LI> 	a martial arts place to the <b>west</b>\n
<LI> 	a market to the <b>east</b>\n
</UL>\n
 <P>
You notice a garbage dumpster tucked away
in an inconspicuous, but nearby, location to the <b>southwest</b>.
 <P>\n
The road leads <b>north</b>"
	south = {shop_open(restraunt);}
	west = { 
		if (global.linear and global.game_level < 3)
		{
		    "Unfortunately the door is locked. You notice a
	banner in the window, saying \"Grand Opening Real Soon\". The
	merchandise looks quite interesting. Hopefully it won't be too
	long before they open for business.
		     <P>\n You return to the street.";
		    return nil;
		}
		else
		    return shop_open(kung_fu);
	}
	east = { shop_open(general_store);}
	sw = dumpster
	north = chinatown
;

restraunt: room
	sdesc = "Restraunt"
	ldesc = "This fine establishment serves good food, hence the name, 
		\"Good Food\"<P>\n
A <b>menu</b> is lying about.
 <P>You may <b>leave.</b>"
	out = china_shops
	north = china_shops
;

menu: readable
 noun = 'menu'
 location = restraunt
 sdesc = "Restraunt menu"
 ldesc = "
<B>Menu for success</B>\n
 <P>
A few helpful tips and pointers are listed.

 <P>
<UL>\n
<LI> A firm handshake\n
<LI> Look the interviewer straight in the eye\n
<LI> Show enthusiasm\n
<LI> Obtain the Medallion from groups of visitors\n
<LI> Show up five minutes early\n
<LI> Dress up - no sneakers\n
<LI> Start looking for a job early\n
<LI> Have several copies of your resume available\n
<LI> Don't get discouraged\n
</UL>\n"
	readdesc = {ldesc;}
;


general_store: room
	sdesc = "Market"
	ldesc = "
The aromatic smell or fruits, vegetables make you hungry. The smell of
meat makes you drool. The smell of chicken makes you light headed.
Your belly rumbles loudly. Food everywhere! <B>Food!</B> You almost
forget about the stick. Must.. Resist... Temptation... Must persevere...
with the mission. To keep focused, you vow to abstain from the
pleasures of the tummy until the stick is retrieved.

 <P>\n
You may <b>leave</b>"
	out = china_shops
	west = china_shops
;

class ninja_body: fixeditem
    noun = 'ninja' 'man'
    adjective = 'unconscious'
    count = 'zeroth'
    sdesc =     "<<count>> ninja"
    location = dumpster
    conscious = true
    phrase = 'empty'
    isEquivilant = true
    ldesc = {
	if (conscious)
	{
	    "<I> <<phrase>> </I> ";
	    conscious := nil;
	}
	else
	    "<I> The Ninja is quite unconscious. </I>";
    }
;



dumpster: room
	sdesc = "Dumpster"
	sequence = -1
	ldesc =
	{
	    "You are in a large green corroded trash container. Above you and
around you are metal walls. Below you is unspeakable disgusting stuff,
giving off a rank aroma. You have a strange urge to root through the
garbage, but you manage to contain yourself.
 <P>";
	    switch (sequence)
	    {
		local ninja;
		case 0: "Fortunately, the lid is bent open and you will
			 have no trouble getting out.
			 <P>
			 You may go <b>up</b>";
			break;
	         case 1:"<I>
			 Before you can move a paw, there is a horrific
			 crash, and then a thunk.
			 One of the ninjas from your prior engagement
			 lands right on top of you.
			 </I>";
			ninja := new ninja_body;
		        addword(ninja, &adjective, 'first');
		        ninja.count := 'first';
		        ninja_body.phrase := 'The Ninja looks back at
	you. With grim and heroic determination, he fights off the
	enveloping darkness and inches even closer. His last few
	breaths are spent repeating the words "<STRONG>For</STRONG>
	what end?" into your ear.';
 		         sequence ++;
		         break;
		
		 case 2:"<I> You don't even get a chance to
	budge. There is a horrific crash, and then a squish. A second the
	ninjas flies into the dumpster.  </I>";
			 ninja := new ninja_body;
		         addword(ninja, &adjective, 'second');
		        ninja.count := 'second';
		         ninja.phrase := 'You lick the Ninja
	until he wakes up. The sorry looking fellow is only able to
	speak one phrase, "They <STRONG>ATE</STRONG> it!" before
	dropping back into unconsciousness.';
 		         sequence ++;
		          break;
		
		case 3:"<I>Not again! There is a horrific crash, and then
	a thunk. Yet another another ninja has been tossed into the
	dumpster. It is getting quite crowded in here.
			</I>";
			 ninja := new ninja_body;
		         addword(ninja, &adjective, 'third');
		        ninja.count := 'third';
		         ninja.phrase := 'The Ninja, relatively
	unhurt, shouts out, "<STRONG>TOO</STRONG> bad!" as he jumps
	up. Unfortunately that is not the wisest thing to do in a dumpster.';
 		         sequence ++;
			 break;
		
		case 4: "<I>Surprise! In comes another beat up
	ninja. It's really amazing how many people can fit inside one
	dumpster. </I>";
			 ninja := new ninja_body;
		         addword(ninja, &adjective, 'fourth');
		        ninja.count := 'fourth';
		         ninja.phrase :=  ' The Ninja seems to be
	insane. He just sits there and giggles, "We <STRONG>WON</STRONG>,
	We <STRONG>WON</STRONG>" over and over again. ';
 		         sequence ++;
		         break;		         
	    }
	    if (sequence > 0 and sequence < 5)
	    {
		"<P>\n
		 Got some cool choices here
		 <UL>\n
		 \t<LI> <b>Examine the ninja</b>\n
		 \t<LI> <b>Leave</b> this dump\n
		 </UL>";
	    }
	}
	ninja_rain =
	{
	    if (sequence = 5)
	    {
		local i, max;
		"You decide to leap out of the self with
		 all your might. As you leave, yet another Ninja is flying in. The
		 resulting explosion (the dumpster had reached critical mass)
		 throws you clear.
		 <P>\n It takes a few seconds to get oriented\n\n";
		max := length(contents);
		for (i := 1; i <= max; i++)
		{
		    if (isclass (contents[i],ninja_body))
		    {
			local obj;
			obj := contents[i];
			delete obj;
			max --;
			i --;
		    }
		}
		self.sequence := 6;
		return china_shops;
	    }
	    if (sequence > 0 and sequence < 6 )
	    {
		self.lookAround(true);
		return nil;
	    }
	    else
		return china_shops;
	}
	
	up = self.ninja_rain
	out = self.ninja_rain
	northeast = "Try getting out of the dumpster first"
;



kung_fu: room
	sdesc = "Martial Arts Shop"
	ldesc =
"
The newly opened store sports quite a variety of merchandise - deadly
weapons and tourist toys glint alike in the reflected sunlight.
Everything is for sale, prices negotiable. No one is at the counter.
It is very quiet in here, almost too quiet.\n


 <P>\nFeel free to <b>pick up</b> some merchandise, if you desire.

 <P>\n You may <b>exit</b> the store."
	out = china_shops
	east = china_shops
;

class merchandise: item
	location = kung_fu
	ldesc = gymnastics()
	doTake(actor) = gymnastics()
;

thowing_stars: merchandise
	noun = 'stars' 'star'
	adjective = 'throwing' 'ninja'
	sdesc = "Ninja Stars"
;

brass_rat: merchandise
	noun = 'rat'
	adjective = 'brass'
	sdesc = "Brass Rat"
;

incense: merchandise
	noun = 'insense' 
	sdesc = "Insense"
;
cinder_blocks: merchandise
	noun = 'blocks' 'block'
	adjective = 'cinder'
	sdesc = "Cinder blocks"
;
tombstones: merchandise
	noun = 'tombstones' 'tombstone' 'headstones' 'headstone' 'stone'
	adjective = 'head' 'tomb'
	sdesc = "Tombstones"
;

soy_sauce: merchandise
	noun = 'sauce'
	adjective = 'soy'
	sdesc = "soy sauce"
;


gymnastics: function
{
    if (medallion.location <> Me)
    {
	"With a blink of an eye, a several blurry shapes wearing white uniforms
and black belts come flying out of a secret entrance. You hardly have
any time to appreciate the olympic caliber gymnastic tumbling that is
presented to you before the world turns upside down. The open door
seems to be spinning around, and growing larger and larger - it's
going right at you. You close your eyes in fear, and everything goes
black! Thunk. Crash. Clunk. Squish. You hurtle through something.
 <P>\n
When everything grinds to a halt (plus a few seconds), you get up the
courage to <b>open</b> your eyes again. \n\n";
	morePrompt;
	if ((global.linear and global.game_level = 3)
	    or (not global.linear and dumpster.sequence = -1)
	    )
	{
	    dumpster.sequence := 0;
	    setlevel(4);
	    incscore(100);
	    "<p>\n\n</p>";
	}

    }
    else
    {
	"With a blink of an eye, a several blurry shapes wearing white
	 uniforms and black belts come flying out of a secret
	 entrance. You hardly have any time to appreciate the olympic
	 caliber gymnastic tumbling that is presented. They come
	 closer and closer, and you inwardly prepare yourself for
	 almost certain discomfort.
	 <P>\n
	 So you thought that the medallion would protect you, huh? If this
	 was the movies, all those ninjas would stop at the last possible
	 second. Then some old dude would come out and there would be
	 all this mystical stuff.
	 <P>\n
	 Well it's not going to happen! The painfully familiar routine
	 occurs yet again.  You almost have it down by heart. First,
	 the world turns upside down. Then the door spins around, and
	 grows larger and larger - and you fly through it, yet another
	 perfect three pointer right into the
	 dumpster. Thunk. Crash. Clunk. Squish. 
	  <P>\n
	 When everything grinds to a halt (plus a few seconds), you
	 get up the courage to <b>open</b> your eyes again. \n\n";
	if ((global.linear and global.game_level = 5)
	    or (not global.linear and dumpster.sequence <= 0)
	    )
	{
	    incscore(100);
	    setlevel(6);
	    dumpster.sequence := 1;
	    "<p>\n\n</p>";
	}
    }
    Me.travelTo(dumpster);
}

/* TODO: replace shop_open with doors and descriptions from web */
shop_open: function (shop)
{
	if (!time_night()) 
		return shop;
	else
	{
	    "There is a heavy duty metal fence between you and the entrance.
	     The sign on the door says these are not business hours.
	     Try coming back in the morning.";
	    return nil;
	}
	
}

medallion: item
    noun = 'medallion' 'collar' 'neck'
    adjective = 'chinese' 'gold'
    sdesc = "chinese medallion"
    ldesc = "a once shiny but now very old medallion, covered
	     with Chinese lettering. "
;
			       
