#
# convert12.py
#
# this shows how valid series for chapter x book 1 can be mapped to valid series for x+1/2 or vice versa.
#

import sys
import itertools

the_max = 9
this_chapter = 4

first_book = True

def first_to_second(my_string, start_string = 'r'):
	return_string = start_string
	for x in range(0, len(my_string)):
		if (my_string[x] == 'w') != (return_string[x] == 'w'):
			return_string += 'w'
		else:
			return_string += 'r'
	return return_string

def second_to_first(my_string):
	return_string = ''
	for x in range(0, len(my_string) - 1):
		return_string += 'w' if my_string[x] != my_string[x+1] else 'r'
	return return_string

def convert_it(first_book = True):
    a = ['w', 'r']
    b = ['w', 'r']

    for count in range(1, this_chapter):
        b = [''.join(x) for x in itertools.product(b, a)]

    left_string = "book {}, chapter {}".format(1 if first_book else 2, this_chapter)
    right_string = "book {}, chapter {}".format(2 if first_book else 1, this_chapter + (1 if first_book else -1))

    print(left_string + '     ' + right_string)

    for c in b:
        if first_book:
            print('{:>{}s}'.format(c, len(left_string)), '<=> {}, {}'.format(first_to_second(c), first_to_second(c, 'w')))
        else:
            if c.startswith('r'):
                continue
            d = second_to_first(c)
            c2 = c + '/' + c.translate(str.maketrans("wr","rw"))
            print("{:>{}s} <=> {}".format(c2, len(left_string), d))

cmd_count = 1
while cmd_count < len(sys.argv):
    arg = sys.argv[cmd_count]
    if arg == 'f':
        first_book = True
    elif arg == 's':
        first_book = False
    elif arg.isdigit():
        this_chapter = int(arg)
    else:
        sys.exit("Need f or second to specify conversion from second book, along with an optional digit.")
    cmd_count += 1

if this_chapter > the_max:
    sys.exit("I'm not going to allow a chapter above 10. Sorry! If you want to, you can edit the source.")

convert_it(first_book)