var all_spells = [
	{name: "Sunburst", level: 1},
	{name: "Cold snap", level: 1},
	{name: "Smoke screen", level: 1},
	{name: "Undergrowth", level: 2},
	{name: "Windstorm", level: 2},
];
var easy_spells = all_spells.slice(0, 3);

window.all_buffs = ["muscle", "mischief", "magic"];

window.all_monsters = {
	"hornets": {
		name: "Giant hornets",
		
		base: 8,
		score: 8,
		wounds: 0,
		
		weapon: {
			name: "stingers",
			damage: 2
		},
	},

	"shadow": {
		name: "Shadow beast",
		
		base: 9,
		score: 9,
		wounds: 0,
		
		weapon: {
			name: "claws",
			damage: 1
		},
	},

	"tree": {
		name: "Evil tree",
		
		base: 10,
		score: 10,
		wounds: 0,
	},
};

window.create_character = function (char_name) {
	return {
		name: char_name, // Mirrored for debugging.
		health: 10,

		muscle: 1,
		mischief: 1,
		magic: 1,
		
		wounds: 0,
		blessings: 0,
		experience: 0,
		unused_exp: 0,
		signs: 0,
		
		weapon: null,
		armor: null,
		
		buffs: {
			muscle: 0,
			mischief: 0,
			magic: 0,
		},
		
		inventory: {
			meals: 0,
			torches: 0,
			silver: 0
		},
		
		spellbook: {},
	};
};

window.equip_character = function (character, archetype) {
	character.inventory.meals = 2;
	character.inventory.torches = 1;
	if (archetype === "fighter") {
		character.weapon = {
			name: "big hammer",
			damage: 1
		};
		character.armor = {
			name: "chain mail",
			protection: 3
		};
	} else if (archetype === "rogue") {
		character.weapon = {
			name: "shepherd's ax",
			damage: 3
		};
		character.armor = {
			name: "leather jerkin",
			protection: 2
		};
		var spell = easy_spells.random();  // SugarCube 2 feature.
		character.spellbook[spell.name] = {
			level: spell.level,
			//charges: 1
		};
	} else if (archetype === "mage") {
		character.weapon = {
			name: "crooked staff",
			damage: 2
		};
		character.armor = {
			name: "thick robes",
			protection: 1
		};
		var spells = all_spells.randomMany(2);  // SugarCube 2 feature.
		for (var i = 0; i < spells.length; i++) {
			var s = spells[i];
			character.spellbook[s.name] = {
				level: s.level,
				//charges: 1
			};
		}
	} else if (archetype === "hero") {
		character.weapon = {
			name: "walking stick",
			damage: 1
		};
		character.armor = {
			name: "thick coat",
			protection: 2
		};
		var spell = easy_spells.random();  // SugarCube 2 feature.
		character.spellbook[spell.name] = {
			level: spell.level,
			//charges: 1
		};
	}
};

window.roll_dice = function (count, sides, modifier) {
	var modifier = modifier || 0;
	var sum = 0;
	for (var i = 0; i < count; i++)
		sum += random(1, sides); // SugarCube 2 feature.
	return sum + modifier;
};

window.median_roll = function (count, sides, modifier) {
	var results = [0, 0, 0];
	for (var i = 0; i < 3; i++)
		results[i] = roll_dice(count, sides, modifier);
	results.sort();
	return results[1];
};

window.adjust_damage = function (damage, armor) {
	if (armor === null || armor === undefined)
		return damage;
	else if (damage <= armor.protection)
		return damage;
	else
		return damage - armor.protection;
};

window.give_random_spell = function (character) {
	var spell = all_spells.random();
	if (character.spellbook[spell.name] === undefined) {
		character.spellbook[spell.name] = {
			level: spell.level,
			//charges: 1
		};
	} else {
		character.buffs.magic++;
	}
	return spell.name;
};

window.heal_wounds = function (character, amount) {
	character.wounds -= amount;
	if (character.wounds < 0)
		character.wounds = 0;
};

window.cool_down_buffs = function (character) {
	for (var i in character.buffs) {
		if (character.buffs[i] > 0)
			character.buffs[i]--;
		else if (character.buffs[i] < 0)
			character.buffs[i]++;
	}
};

window.exp_to_advance = function (character) {
	if (character.experience < 100)
		return 35;
	else if (character.experience < 250)
		return 50;
	else if (character.experience < 500)
		return 85;
	else // The game isn't supposed to get this far.
		return 135;
};

window.numeral = function (n) {
	switch (n) {
		case 0: return "none";
		case 1: return "one";
		case 2: return "two";
		default: return "many";
	}
};
