/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History (this file)
 * 
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode; created this file.
 *
 * 23-Aug-03    djp     Version 2:12 
 *                      * Added support for ENTER ELEVATOR.  Added
 *                        up and down directions for volcanic rift.  Added 
 *                        'on/off' functionality for the desk lamps.  Added 
 *                        functionality for the computer room button. (Player
 *                        is given the opportunity to UNDO.)
 *                        Made bulletin boards and posters accessible in both
 *                        computer center rooms.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Added more methods for lifting the floor panels in
 *                        the computer room.  Added 'panels' to the floor
 *                        vocab when in the computer room.  Mentioned the
 *                        elevator in the description of the south computer
 *                        center room.
 *
 */

/* Additional rooms for 580-point version */

/* Note on compound words.  Compound word constructions were used in the
past to circumvent problems when verbs were used as adjectives; for example,
'actor, west' wouldn't parse correctly if an item defined 'west' as an
adjective.   This fix is no longer needed, and has been backed out from
version 2.00 onwards.

For the benefit of people using TADS 2.4.0 and later, we now also avoid
the use of adjectives which are used as a noun by other objects.
A bugfix in the interpreter allows the use of adjectives in these
circumstances, and this caused some confusion; for example, 'bird' could
refer to the cage in the absence of the bird, and 'rod' could refer to the
crystal bridge in the absence of the rod.
 */

S_Of_Center: room, NoNPC
    game580 = true
    sdesc = "South End of Computer Center"
    // DJP: Added a mention of the elevator at the N end (so its existence
    // doesn't come as a surprise if the maintenance man appears before the
    // player has seen the N end of the room)
    ldesc = {
        I(); "You are standing at the southern end of a long hall in what 
        appears to be a computer center.  The entire hall is lit by four rows 
        of fluorescent lightbulbs.  There are numerous bulletin boards, all
        filled with various messages of one sort or another.  The rest of
        the wall space is filled by a large collection of computer generated
        posters, ranging in size from a two foot square picture of a cat
        to a twenty foot long 360 degree view of Mars taken from the Viking
        lander.  The computer center extends northward from here, and there
        is a small passage to the south.  There is an elevator at the far
        north end of the west wall. ";
    } 
    south = At_Witts_End
    north = N_Of_Center
    hasfloor = true
;

board: floatingdecoration, readable
        game580 = true
        loclist = [S_Of_Center, N_Of_Center]
    noun = 'board' 'boards'
    adjective = 'bulletin'
    sdesc = "bulletin boards"    
    ldesc= "The bulletin boards are covered with various notices and
         memos, personal messages and system messages.  None of them 
         are particularly interesting. "
;

// DJP - added a phoney distantitem for the elevator as seen from the south
// room.
Elevator580_distant: distantItem
    game580 = true
    location = S_Of_Center
    sdesc = "elevator"
    noun = 'elevator' 'lift'
    ldesc = {Elevator580.ldesc;}
;

N_Of_Center: room, NoNPC 
    game580 = true
    sdesc = "North End of Computer Center"
    ldesc = {
        I(); "You are at the northern end of the computer center.  There are 
          more bulletin boards and posters covering the walls, and a large 
          sign on
          the wall reading, \"RALPH WITT MEMORIAL COMPUTER CENTER.\"  Below 
          that
          there is a considerably smaller sign saying, \"security area - access
          by authorized personel only.\"  To your left is an elevator, and next
          to it there is a green button, obviously used to call the elevator. ";
    }
    south = S_Of_Center
    north = {
        if(Box580.has_card) return Computer_Room;
        else pass north;
    }
    in = {
        Elevator580.verDoRide(Me);
        if (Elevator580.isopen) Elevator580.doRide(Me);
    }
    west = {
        return self.in;
    }
    Hasfloor = true
;

NCenterSign: fixeditem, readable
    sdesc = "signs"
    isThem = true
    noun = 'sign' 'signs'
    ldesc = {
        "A large sign on
         the wall reads \"RALPH WITT MEMORIAL COMPUTER CENTER.\"  A smaller
         sign below it reads \"security area - access by authorized personel 
         only.\" ";
         if(Elevator580.islocked) {
             "There is also an \"OUT OF ORDER\" sign on the elevator door. ";
         }
    }
    location = N_Of_Center     
;

Box580: fixeditem
        game580 = true
        location = N_Of_Center
    noun = 'box' 'slot'
    adjective = 'little'
    sdesc = "box"
    ldesc = "On the north wall there is a little box with a slot in it set 
             into the wall about four feet from the floor. "
    
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = 
    {
        if(dobj = card) {
            "You carefully insert the ID card into the slot in the box, which
             begins to emit a high pitched beeping sound for several seconds.
             All of a sudden, one section of the wall slides away, revealing
             another room to the north. ";
            Box580.has_card := true;
            card.moveInto(nil);
        }
        else "That doesn't fit in the slot. ";
    }
    heredesc = {
        P(); I();
        if(self.has_card) "A cool breeze blows from a room to the north. ";
        else "On the north wall there is a little box with a slot in it set 
             into the wall about four feet from the floor. ";
    }
;

NC_Button: buttonitem
        game580 = true
        location = N_Of_Center
    sdesc = "green button"
    ldesc = "It is a green button, obviously used to call the elevator. "
    adjective = 'green' 'elevator'
    
    doPush(actor) = {
        if(Elevator580.isopen || Elevator580.islocked) "Nothing happens. ";
        else 
        {
            Elevator580.isopen := true;
            "OK"; P(); I();
            "The elevator doors are now open. ";
        }
    }
;

Elevator580: fixeditem
    game580 = true
    location = N_Of_Center
    doRide(actor) = { 
        // DJP - close the elevator doors
        self.isopen := nil;
        P(); I();
        "The doors close behind you as you enter, and the elevator 
         immediately starts to go up quite rapidly.  After a while
         the acceleration lessens, but you continue going upwards
         for what seems like a very long time.  Finally the elevator
         starts to slow down (incidently doing nasty things to your
         stomach), and eventually grinds to a stop. "; 
        P(); I();
        "Bright light floods into the elevator as the doors open. 
         Bedazzled by the bright light, you stumble out of the
         elevator as your eyes try to adjust.  After a second
         or two, you hear a small 'swoosh' behind you, and, as
         you turn around, you realize that not only have the
         elevator's doors closed, but they have vanished
         altogether! ";
        P();
        actor.travelTo(Inside_Building);
      
    }
    verDoRide(actor) = {
        if(self.isopen) return;
        else "The elevator doors are shut. ";
    }
    doEnter(actor) = {self.doRide(actor);} // make enter synonym to ride.
    verDoEnter(actor)= {self.verDoRide(actor);}
    doBoard(actor) = {self.doRide(actor);}
    verDoBoard(actor)= {self.verDoRide(actor);}
    sdesc = "elevator"
    noun = 'elevator' 'lift'
    ldesc = {
        "The elevator doors are "; 
        if(self.isopen) "open. ";
        else "shut. ";
        if(self.islocked) "Taped to the doors is an \"OUT-OF-ORDER\" sign. ";
    }
    heredesc = {
        P(); I();
        return self.ldesc;
    }
    islocked = {
        if (Blob.ischasing || global.closing) return true;
        else return nil;
    }
;

Computer_Room: room, NoNPC
    game580 = true
    sdesc = "Computer Room"
    ldesc = { I();
        "You are standing in an air conditioned room with a raised floor.
         Filling most of the room is a LARGE computer with LOTS of blinking
         lights.  There is a display screen mounted in one section of the
         computer.  There appears to be only one control or switch of any
         sort on the machine, that being a big red button marked
         \"EMERGENCY STOP - Do not push!\"";
    }
    south = N_Of_Center
    down = { return self.west; }
    west = {
        if(theFloor.CR_isopen) {
            return Air_Duct;
        }
        else {
            pass west;
        }
    } 
    out = N_Of_Center
    hasfloor = true
    hasfloordesc = true
    floordesc = {
        if(theFloor.CR_isopen) "Several of the floor's panels have been 
            removed.  There is a small air duct leading down beneath the
            floor.  It'll be a tight fit, but you should be able to just
            squeeze through. ";
        else "The floor is composed of several small panels, and is higher
            than the floor of the room to the south. ";
    }
    floorvocab = ['tile' 'tiles' 'panel' 'panels']
    floorvocaba = ['floor']
;

CR_button: buttonitem, readable
    sdesc = "big red button"
    location = Computer_Room
    adjective = 'red' 'big' 'large' 'stop'
    ldesc = "It is a big red button marked \"EMERGENCY STOP - Do not push!\""
    doPush(actor) = {
        "OK. "; P(); I();
        // EXEC(9, I); // Presumably quits the game.
        "The lights on the computer blink, then go dark.  Everything around
        you fades into a gray nothingness, and you also pass out of 
        existence ... ";
        incscore(global.deathpoints,'for terminating your existence');
        call_it_a_day();
    }
;

modify theFloor
    verDoOpenWith( actor, io ) =
    {
        if(toplocation(actor) != Computer_Room) pass verDoOpenWith;
        if(self.CR_isopen) {
            "The floor is already open! ";
        }
    }
    doOpenWith(actor, io) =
    {
        if(io = cups) {
            "With the aid of the suction cups, you manage to pull up
             some of the panels on the floor.  Below the floor there
             is a small air duct leading down and to the west.  It
             looks like a tight fit, but I think you'll make it. ";
            self.CR_isopen := true;
        }
        else "I don't how to open the floor with <<io.sdesc>>. ";
    }
    verDoOpen(actor) =
    {
        if(toplocation(actor) != Computer_Room) pass verDoOpen;
        if(self.CR_isopen) {
            "The floor is already open! ";
        }
        else "I am game; would you care to explain how? ";
    }
    verDoTake( actor ) = 
    {
        if(toplocation(actor) != Computer_Room) pass verDoTake;
        if(self.CR_isopen) {
            "The floor has already been lifted! ";
        }
        else "I am game; would you care to explain how? ";
    }
    verDoTakeWith( actor, io ) =
    {
        if(toplocation(actor) != Computer_Room) pass verDoTakeWith;
        if(self.CR_isopen) {
            "The floor has already been lifted! ";
        }
    }
    verDoPull( actor ) = 
    {
        if(toplocation(actor) != Computer_Room) pass verDoPull;
        if(self.CR_isopen) {
            "The floor has already been pulled up. ";
        }
        else "I am game; would you care to explain how? ";
    }

    verDoPullWith( actor, io ) =
    {
        if(toplocation(actor) != Computer_Room) pass verDoPullWith;
        if(self.CR_isopen) {
            "The floor has already been pulled up. ";
        }
    }
    doTakeWith(actor, io) =
    {
        return self.doOpenWith(actor, io);
    }
    doPullWith(actor, io) =
    {
        return self.doOpenWith(actor, io);
    }
    verDoPush(actor) =
    {
        if(toplocation(actor) = Computer_Room) {
            if(not self.CR_isopen) "The floor has already been pushed back. ";
        }    
        else pass verDoPush;
    }
    verDoClose(actor) =
    {
        if(toplocation(actor) = Computer_Room) {
            if(not self.CR_isopen) "The floor is already shut. ";
        }
        else "The floor isn't open. ";
    }
    verDoReplace(actor) = 
    {
        if(toplocation(actor) = Computer_Room) {
            if(not self.CR_isopen) "The floor has already been replaced. ";
        }
        else "I don't know how to replace <<self.thedesc>>.";
    }
    
    doPush(actor) =
    {
        if(toplocation(actor) = Computer_Room) {
            "You replace the floor tiles, concealing the air duct from view. ";
            self.CR_isopen := nil;
        }
    }
    doClose(actor) =
    {
        return self.doPush(actor);
    }
    doReplace(actor) = 
    {
        return self.doPush(actor);
    }
    ioPutOn(actor,dobj) = {
        if((dobj = cups) and (toplocation(actor) = Computer_Room) and not
        self.CR_isopen) 
             self.doOpenWith(actor,dobj);
        else pass ioPutOn;
    }
    verIoAttachTo(actor) = {}
    ioAttachTo(actor,dobj) = {
        if((dobj = cups) and (toplocation(actor) = Computer_Room) and not
        self.CR_isopen) 
             self.doOpenWith(actor,dobj);
        else 
             "I don't see the point of trying to attach <<dobj.thedesc>> to
             <<self.thedesc>>. ";
    }
;
Computer: fixeditem
    game580 = true
    location = Computer_Room
    noun = 'computer' 'lights' 'supercomputer' 'mainframe'
    sdesc = "large computer"
    ldesc = "Filling most of the room is a LARGE computer with LOTS of
         blinking lights. "
    adjective = 'large' 'blinking'
    
    verDoTurnOff(actor) = {}
    doTurnOff(actor) = {
        return CR_button.doPush(actor);
    }
    verDoTurnOn(actor) = "The computer is already on. "
    verIoPutIn(actor) = {}
    ioPutIn(actor,dobj) = {
        if (dobj = disk)
            "Strangely, I can't see a floppy disk reader anywhere. ";
        else
            "I can't see any way to put anything into the computer. ";
    }
;

Crt: fixeditem, readable
    sdesc = "display screen"
    noun = 'crt' 'screen' 'monitor'
    adjective = 'display'
    ldesc = "In the middle of the screen is the message \"Adventure
        - RUNNING\". Everything else is just an indecipherable display 
        of numbers. "
        game580 = true
        location = Computer_Room
;

Air_Duct: room, NoNPC
    game580 = true
    sdesc = "Air Duct"
    ldesc = "You are in an air duct running from east to west.  There is a
             brightly lit room at the eastern end of the air duct. "
    up = Computer_Room
    east = Computer_Room
    west = S_Tunnel
    hasfloor = true
;

S_Tunnel: darkroom, NoNPC       
        game580 = true
        sdesc = "S-Shaped Tunnel"
        ldesc = "You are in an S-shaped tunnel.  The tunnel starts at the northeast,
             where there is a rectangular opening in the wall, and continues to the
             southwest, from which a dull rumbling can be heard. "
        east = Air_Duct
        ne = Air_Duct
        north = Air_Duct
        sw = E_Of_Rift
        west = E_Of_Rift
        south = E_Of_Rift
;

E_Of_Rift: room, NoNPC
    game580 = true
    sdesc = "East Edge of Volcanic Rift"
    ldesc = { I();
              "You are standing on the eastern edge of a HUGE volcanic rift.
               Almost a mile away on the other side, and maybe a hundred feet
               above you, is another passage.  Far to the north is an active
               volcano, the source of the lava flowing far below.  Carved into
               the wall, as if with a pen-knife, are the words 
               \"THGIRW RUBLIW\". "; 
    }
    east = S_Tunnel
    west = { 
        if(not persian_rug.isActive) {
            "I'm game.  Would you care to explain how? ";
            return nil;
        }        
        else { 
            local err;
            "(first boarding the rug)"; P();
            err := execCommand(global.travelActor, boardVerb, persian_rug);
            P();
            if(err = EC_SUCCESS) execCommand(global.travelActor, wVerb);
            return nil; /* nothing more to do */
        }
    }
    up = {return self.west;}
    fly_west = {        
        // TODO - add check for the player's inventory.
        if(true) { // if the player is not carrying too much.
            "You slowly rise up to the level of the ledge on the western side 
             of the rift.  The rug loops around once or twice, and then gently
             deposits you on the western side of the rift. "; P();
            return W_Of_Rift;
        }
        if(true) {
            "You climb onto the rug which gently starts to float across the 
             rift. The rug struggles to gain altitude (the ledge on the other 
             side is a bit higher), but is unable to because you are too 
             heavy.  The rug gently crumbles into the side of the rift, 
             twenty feet below the ledge it was aiming for.  Despite your 
             best efforts to hold on to a sheer cliff, you fall. ";
            persian_rug.moveInto(nil); // remove the rug.
            die();
        }
    }
    fly_up = {return fly_west;}
    cross = { return self.west; }
    down = { return self.jump; }
    climb = { return self.jump; }
    jump = {
        "Don't be ridiculous!";
        return nil;
    }
;

Rift: floatingdecoration
    iswavetarget = true // can wave rod at rift.
    sdesc = "volcanic rift"
    ldesc = "It is a huge volcanic rift with passages on the eastern and 
             western sides. Far to the north is an active volcano, the source 
             of the lava flowing far below. Carved into the western wall, as 
             if with a pen-knife, are the words \"THGIRW RUBLIW\". "
    noun = 'rift' 'chasm'
    adjective = 'volcanic' 'huge'
    game580 = true
        loclist = [ E_Of_Rift W_Of_Rift ]
    verDoJump(actor) = {}
    doJump(actor) = {
        global.travelActor := actor;
        actor.travelTo(actor.location.jump);
    }
;

W_Of_Rift: room, NoNPC
    game580 = true
    sdesc = "West Edge of Volcanic Rift"
    ldesc = { I();
        "You are on the western edge of the volcanic rift.  A passage
         continues up and west from here. ";
    }
    east = {
        if(not persian_rug.isActive) {
            "I'm game.  Would you care to explain how?";
            return nil;
        }
        else { 
            local err;
            "(first boarding the rug)"; P();
            err := execCommand(global.travelActor, boardVerb, persian_rug);
            P();
            if(err = EC_SUCCESS) execCommand(global.travelActor, eVerb);
            return nil; 
        }
    }
    down = {return self.east; }
    cross = { return self.east; }
    fly_east = {
        "The rug gently carries you back across the rift.";
        P();
        return E_Of_Rift;
    }
    fly_down = {return fly_east;}    
    up = Panelled_Passage
    west = Panelled_Passage
    study = Study
    // down = { return self.jump; }
    climb = { return self.jump; }
    jump = { "Don't be ridiculous!";
        return nil;
    }
;

Panelled_Passage: room, NoNPC
    game580 = true
    sdesc = "Panelled Passage"
    ldesc = { I();
        "You are in a long sloping passage.  The walls are covered with fine
         redwood paneling.  From the east comes a dim light and a dull rumbling
         noise.";
    }
    east = W_Of_Rift
    down = W_Of_Rift
    west = Study
    up = Study
    study = Study
    hasfloor = true
;

Panelling: fixeditem
    game580 = true
    noun = 'panelling' 'paneling'
    adjective = 'fine' 'redwood'
    sdesc = "panelling"
    ldesc = "The walls are covered with fine redwood panelling. "
    location = Panelled_Passage
;

Study: darkroom, NoNPC
    game580 = true
    sdesc = "Study"
    ldesc = { I(); "You are in an elaborately furnished study. ";
    }
        east = Panelled_Passage
        out = Panelled_Passage
        down = Panelled_Passage
    hasfloor = true
;

Desk580: decoration
        game580 = true
    sdesc = "desk"
    ldesc = "There is a magnificent redwood desk in the center of the room. "
    noun = 'desk'
    adjective = 'redwood' 'magnificent'
        location = Study
        heredesc = {
        P(); I();
        return ldesc;
    }
;

Desk_lamps: decoration, lightsource, switchItem 
    // BJS: Added this object, which is not portable.
    // DJP: but you can now switch off the lamps.
    game580 = true
    sdesc = "desk lamps"
    adesc = {self.sdesc;}
    ldesc = {
        if(self.islit)
            "The room is lit by several desk lamps scattered about the room. ";
        else
            "There are several unlit desk lamps scattered about the room. ";
    }
    noun = 'lamps' 'lamp'
    isThem = true
    adjective = 'desk'
    location = Study
    heredesc = {
        P(); I();
        return ldesc;
    }
    islit = true
    isActive = true
    verDoTurnon(actor) =
    {
        /*
         *   Modified to allow the lamps to be turned back on in the dark.
         *
         */
        if (self.isActive)
            "\^<<self.itisdesc>> already turned on! ";
    }
;
