/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      dmb     In real life:   David M. Baggett
 *
 *      djp     In real life:   David J. Picton
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *
 * Modification History (this file)
 *
 * CCR
 * ===
 *
 *  1-Jan-93    dmb     rec.arts.int-fiction BETA release (source only)
 *                      For beta testing only -- not for general
 *                      distribution.
 *
 * 20-Apr-93    dmb     Fixed a bug with the treasures: you could
 *                      get points for a treasure without being able
 *                      to carry it.  [Note added by DJP - this wasn't
 *                      really a bug because you got points just for
 *                      locating treasures.  But it does seem more sensible
 *                      to get points for the rug, for example, only when
 *                      you've dealt with the dragon. ]
 *
 * 29-Apr-96    djp     Supplied some suggested enhancements/bugfixes
 *                      to dmb.  These were incorporated in Version 2.0.
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 23-Apr-99    djp     New release (1.10) of Adventure 551.
 *                      Changes since version 1.01:
 *                      * added code for drinking wine from a container
 *                      * 'take keys from keyring' now gets a more sensible
 *                      message.
 *                      * corrected 'fill with' method for liquidcont to
 *                        recognize sea water.
 *                      * added new turnon and setlife methods to the
 *                        brass_lantern object.
 *
 * 30-Apr-99    djp     New release (1.11) of Adventure 551.
 *                      Changes since version 1.10
 *                      * fixed a bug affecting 'close cage'.
 *                      * verDoWave for black rod changed to default
 *                      * fixed 'feed bird with x' etc.
 *
 * 17-May-99    djp     New release (1.20)
 *                      Changes since version 1.11
 *                      * Amended 'wave rod' coding to handle the
 *                        loclist of the crystal bridge and its placement in
 *                        contents lists (as it's now a floatingdecoration
 *                        item.)
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes since version 1.21
 *                      * Removed 'dwarf' as adjective for axe.
 *                      * Corrected doPutIn code for bird to allow bird
 *                        to be placed in a room.
 *                      * Code for dropping the vase changed so it will
 *                        always break in a room with the smashdrop
 *                        property.
 *
 * 3-Aug-99     djp     Bugfix release - Version 2.01
 *                      * Corrected the warning about wandering outside
 *                        when the lamp is dead.  (Issued once only,
 *                        suppressed in 'nolampwarn' rooms.)
 *
 * 9-Nov-99     djp     New release - Version 2.10
 *                        Changes in this version
 *                      * Split ccr-item.t and ccr-npc.t into two files to
 *                        facilitate integration of ad551 updates into
 *                        Bennett Standeven's 550-point game.
 *                      * Incorporated some of Bennet Standeven's mods into
 *                        the code for easier integration of new versions.
 *
 * 17-Feb-00    djp     New release - Version 2.20
 *                        Changes in this version
 *                      * Further generalization of version handling
 *                      * Removed reference to coins in description of
 *                        pirate's treasure.
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *              bjs     Added 550-point extensions, split up items and npcs
 *                      into 3 files; 1 for each version.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *              djp     Changes since ad551 v2.20
 *                      * Changed a few pluradesc settings for endgame_clone
 *                        items.  Defined doCount methods for endgame_clone
 *                        items (and the keys).
 *                      * Added the weapon class (for obvious weapons like
 *                        the axe, swords)
 *                      * Rewrote the islisted method for the initmess class
 *                        (object is listed if seen from outside its
 *                        containing room.)
 *                      * Tidied up the NPC-style interaction methods for
 *                        the bird (attack bird with hands now equivalent to
 *                        attack bird; attacking now no longer done in a
 *                        verification method.)
 *                      * Changed the targloc for the vase to return
 *                        Inside_Building if we somehow succeed in dropping
 *                        it without breaking it.
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version
 *                      * Systematically added isThem properties to plural
 *                        objects (i.e. where sdesc is a plural phrase)
 *                      * Moved portable_chairitem and portable_beditem
 *                        to ccr-adv.t [N.B. these objects have subsequently
 *                        come back in here]
 *                      * Removed redundant verDoWave methods.
 *                      * Changed brass_lantern.wearbatteries to do nothing
 *                        in the endgame.
 *                      * Corrected a bug preventing the wine-in-the-cask
 *                        getting its deposit score when the cask was in the
 *                        chest before the chest was dropped.  Changed code
 *                        for liquidcont to add wine_in_the_cask to
 *                        global.checklist only for the right container and
 *                        liquid.
 *
 * 4-May-00     djp     Version 1.02: bugfix release
 *
 * 15-May-00    djp     Version 1.03: bugfix release
 *                      Changes in this version
 *                      * Corrected a minor bug in the code to check whether
 *                        a cage can't be put into the chest.
 *                      * Corrected the code to prevent the bird being killed
 *                        when it's in a cage
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Added provision for 701-point mode in treasure
 *                        scoring defaults.
 *                      * For 701-point game, disabled all extended uses of the
 *                        rod unless it has been upgraded.
 *                      * Changed the marked rod not to score points in the
 *                        701-point game.  (At present we only do the
 *                        550-point endgame so the marked rod isn't seen, but
 *                        this may change in a future version.)
 *              
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *                      Changes in this version
 *                      * Trying to move the rug when an object was on it
 *                        got the message 'you'd better remove the room first'
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version
 *                      * Changed vertesttake to return nil when the 
 *                        verDoTake method produces text
 *                      * Added a verDoThrowTo method for contliquid
 *                        items.
 *                      * Changed contliquid code to move the container when
 *                        moveInto is used, and to use the verifyRemove
 *                        method of the container.
 *                      * Removed faulty (and redundant) pluraldesc 
 *                        definition for black rods.
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version
 *                      * Added an adesc method for the endgame wicker
 *                        cages.
 *                      * Added isThem property for the magazines.
 *                      * Allowed the flask to be filled from the cask
 *                        in the 701-point game.
 *
 * 22-Nov-01    djp     Version 2.08: bugfix release
 *                      Changes in this version
 *                      * The response to OPEN CLAM has been made a little more
 *                        player-friendly.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version
 *                      * Standardization of library files.  A standard
 *                        adv.t file is now used, and most customizations
 *                        to standard library objects are now made in
 *                        advmods.t.
 *                      * Don't allow the bird to be rubbed or touched if
 *                        it's afraid.  Also take account of star-rods
 *                        held by the player in the endgame.
 *                      * Eliminated the use of self.failput for the
 *                        bird's verDoTake method.  The outhide function is
 *                        now used instead.
 *                      * Reworked the code to make 'take bird' work better
 *                        in the endgame.  The verification process
 *                        for 'take bird' now only rejects birds in the
 *                        player's possession.  The 'rod' checks are now
 *                        done at the command execution stage (doPutIn method).
 *                      * Moved the setup method for wicker_cage into the
 *                        endgame_clone class method to avoid a TADS bug - see
 *                        ccr_endg.t
 *                      * Changed the 'search' and 'look in' methods for the
 *                        liquidcont class to reflect changes in ccr-adv.t.
 *                      * Changed the construct and destruct methods for
 *                        batteries to reference the inherited methods.
 *                      * CHANGE BATTERIES now checks that the lamp is
 *                        dim.
 *                      * Moved functions into ccr-fun.t
 *                      * Added bothsides property to rug (reachable from
 *                        both sides of the dragon)
 *                      * Changed the pass_class property for the cage to fix
 *                      * a bug in 'look in cage'.
 *                      * Changed the verDoClose method for the cage (the
 *                        message used to assume that the player had put
 *                        the bird in the cage; that's wrong in the endgame.)
 *                      * Made the handling of SEARCH and LOOK IN more
 *                        consistent with current adv.t practice - see comments
 *                        in history.t.  Eliminated the use of unnecessary
 *                        doLookin/doSearch methods for containers.
 *                      * Updated liquidcont to use the new setIsoiled 
 *                        property for the rusty door.
 *                      * Enhanced set_of_keys to permit keys to be added
 *                        to the ring.
 *                      * Removed 'set' as an adjective for the batteries, to
 *                        circumvent a parser problem which stops 'set of keys'
 *                        from being recognized. 
 *                      * Corrected some incorrect messages when keys are
 *                        added or removed from the keyring.
 *
 * 12-Aug-03    bjs     Version 2.11: the rug now has a mechanism for flying.
 *                      Set .isActive to true to make it hover in midair.
 *              
 * 23-Aug-03    djp     Version 2:12 
 *                      * updated the flying code for the rug
 *                        to use the new moveme method, originally
 *                        developed for version 3.  Added new code for the
 *                        'fly' verbs.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Added code for pouring oil on certain doors in
 *                        the 701+ point extension.
 *                      * Vocab adjustment to brass lantern, to avoid
 *                        disambiguation problems when lights are referred to.
 *                      * Modification to the code for waving the rod.  The
 *                        upgraded rod will now consistently work after cave 
 *                        closure.  When the non-upgraded rod is used in the 
 *                        701- or 701+ point game, the message about flakes of
 *                        rust is always issued when the action would succeed 
 *                        in the 550-point version.
 *                      * defined the new available_keys object and moved
 *                        office_keys into this file.
 *                      * Made office_keys the key for the chest so that it
 *                        can't be unlocked if global.oldgame returns true.
 *                        (In previous versions the chest could be opened, but
 *                        there was no room for any objects.)  The misfit(io)
 *                        message has been customized to reassure the player.
 *                      * Corrected the verification method for spinning a
 *                        rod over a fissure (rejected if the rod is already
 *                        spinning).
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      Rev B
 *                      * Corrected the code for battery insertion to allow
 *                        the lamp to be recharged once for each set of
 *                        batteries (in the 550-point and 701(+) point 
 *                        versions)
 *
 * 9-Aug-05     djp     Version 3.12 Rev. A: Enhancements and bugfixes
 *                      * Use the new Wumpi.nodeath() method to determine
 *                        whether the lamp life is to be frozen and deaths
 *                        prevented.  The batteries now start to run down
 *                        
 *                      * Correction to keyItem verDoWear code; if the
 *                        keys are wearable, disallow 'wear keys' when 
 *                        they're already being worn.  Also the doCount
 *                        method has been changed to acknowledge added keys. 
 *                      * If the steel key has been put on and the set of keys
 *                        is held in hand, attaching the steel key to the set
 *                        of keys causes the latter object to be worn.
 *                      * Implement 'detach key from keyring' properly.
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Modifications to liquidcont.verDoDrink method in
 *                        connection with drinking wine.  Various checks are
 *                        now made, based on room properties.
 *                      * Added room properties in connection with the above.
 *                      * Defined the classes waveable_rod and spinnable_rod.
 * 12-Nov-06    djp     Version 3.20 Rev. A - minor corrections/enhancements
 *                      * Minor change to spinnable_rod.doTurn method (refer to
 *                        temporary reappearance of plaques and other strange
 *                        effects in Green_Trans_Room)
 * 20-Oct-07    djp     Version 3.20 Rev. C 
 *                      * Changes to loclist of Debris (see rm11.t)
 *                      * Adjustment to code when a rod is spun in Plaque_Room
 *                        (clear the 'moved' property of eight_pointed_star
 *                        which is now an initmess object)
 *                      * Correction to Ming Vase vocab ('ming' is an 
 *                        adjective)
 *                      * Fixes to verDoTakeOut property of the
 *                        spinnable_rod class.  Commands like 'take rod from
 *                        sack' failed with an inappropriate message.
 * 30-Mar-09    djp     Version 3.20 Rev. D
 *                      * Spinnable rods can now be cleaned.
 *                      * Correction to set_of_keys.ioPutOn - if the key
 *                        is already on the ring, just issue a message to
 *                        that effect.
 *
 * 21-Nov-10    djp     Version 3.21
 *                      * PHLEECE now recognized while standing on the rug.
 *                      * The code for unlocking the chest has been enhanced
 *                        to open the chest as well.  Similarly the chest is
 *                        now closed, if necessary, before it is locked.
 *                      * Classes portable_chairitem and portable_beditem
 *                        now inherit most of their methods from chairitem and
 *                        beditem.  (The verification methods defined in 
 *                        adv.t now make the extra checks needed for portable
 *                        items - the player must not be allowed to enter
 *                        an object in his possession)
 *                      * Amended the code for persian_rug to accommodate the
 *                        new scheme for sitting/lying/standing
 */


/* Note on adjectives.

Some 'pruning' of adjectives has now been carried out with the advent of
TADS 2.4.0 which fixes an old parser bug, allowing an adjective to be used as
a noun when another object (not present at the location) defines the same
word as a noun.  The new behaviour is correct, but used to cause confusion
in some cases; for example, 'bird' could refer to the cage in the
absence of the bird, or 'rod' to the crystal bridge.
*/

/* Note on version-specific objects.  If an object has no 'gamevvv' properties,
it exists in all game versions.  If an object has any 'gamevvv' propertie(s)
set, it exists just in those version(s); for example, if just the 'game551'
property is set, the object is present only in the 551-point game.

If the locationvvv property is defined, where vvv is the version, the object
(e.g. keys, food, bottle, trident, diamonds) is moved to that location in
the specified version.   The location350 property is not used in practice.
Note that this mechanism should not be used for objects whose location is
a method.)

*/

/*
 * This file defines all carryable items in the original game, and the items
 * for other versions are defined in the other files beginning with ccr-itm.
 * A flag (moved) is set when an item is first moved.
 */

/* Define the default special_cantreach method.  By default, this is 
   called recursively for self.location until the object is found to be
   held by the actor, or self.location evaluates to nil. 

   self = room or container for which the special check is being made.
   obj = object under consideration
   actor = actor trying to reach the object
   chain = list containing the containment chain, starting with 'self' and
           ending with 'obj'.  If chain[1] is the room, chain[2] will be the
           top-level container.

   At present the initial special_cantreach call is made only for portable
   items (class item), but it may be extended to nonportable objects in
   the future.

 */

// class for axes and swords etc.
class weapon: item
    doPurloin(actor) = {
        self.nograb := nil;
        pass doPurloin;
    }
;

class initmess: item // for objects with an initial description
    has_heredesc = (not self.moved)
    isListedinRoom = {
        if (self.moved) return true;
        else return nil;
        }
    heredesc = {
        if (not self.moved) {
            P(); I(); self.initdesc;
        }
    }
    // fromloc can be set to an object from which the item can be taken,
    // e.g. 'take pole from mud'
    verDoTakeOut(actor, io) = {
        if (io = self.fromloc and not self.moved) {
            self.verDoTake(actor);
        }
        else pass verDoTakeOut;
    }
    verDoTakeOff(actor, io) = {
        if (io = self.fromloc and not self.moved) {
            self.verDoTake(actor);
        }
        else pass verDoTakeOff;
    }
;

// Class for objects like the singing sword which use a heredesc when 
// described in the top-level room description, but the normal adesc
// otherwise.

// Used for objects with constantly-changing descriptions.

class condlisted: item
    has_heredesc = true
    isListedinRoom = nil
    // fromloc can be set to an object from which the item can be taken,
    // e.g. 'take pole from mud'
    verDoTakeOut(actor, io) = {
        if (io = self.fromloc and not self.moved) {
            self.verDoTake(actor);
        }
        else pass verDoTakeOut;
    }
    verDoTakeOff(actor, io) = {
        if (io = self.fromloc and not self.moved) {
            self.verDoTake(actor);
        }
        else pass verDoTakeOff;
    }
;

class canpick: item // for mushrooms, flowers
    verDoPick(actor) = {self.verDoTake(actor);}
    doPick(actor) = {self.doTake(actor);}
;

class liquidcont:  qcontainer
    contentsVisible = {return(true);}


//    set contname, sdescbase and emptydesc as in these examples:
//    contname = "bottle"  (noun only)
//    sdescbase = "small bottle" (adjective(s) + noun)
//    emptydesc = "small empty bottle"

    // Derived property indicating that the container is sealed (e.g.
    // the flask)

    issealed = {return (self.issealable and (not self.isopen));}

    haswater = nil
    hasoil = nil
/* Added for 551-point version */
    haswine = nil
    sdesc = {
        if (self.haswater)
            {self.sdescbase;" of water";}
        else if (self.hasoil)
            {self.sdescbase;" of oil";}
        else if (self.haswine)
            {self.sdescbase;" of wine";}
        else
            {self.emptydesc;}
    }

    ldesc = {
        if (self.haswater)
            {"The ";self.contname;" is full of clear water. ";}
        else if (self.hasoil)
            {"The ";self.contname;" is full of oil. ";}
        else if (self.haswine)
            {"The ";self.contname;" is full of wine. ";}
        else {"There is nothing inside the ";self.contname;".";}
    }
    doSearch(actor) = {
        self.ldesc;
    }

    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        if (self.haswater)
            {"The ";self.contname;" is already full of water.";}
        else if (self.hasoil)
            {"The ";self.contname;" is already full of oil.";}
        else if (self.haswine)
            {"The ";self.contname;" is already full of wine.";}
        else if (isclass(dobj,Streamitem)) {  // DJP
            "The ";self.contname;" is now full of water.";
            self.haswater := true;
        }
        else if (dobj = Oil) {
            "The ";self.contname;" is now full of oil.";
            self.hasoil := true;
        }
        else if (dobj = Wine) {
            "The ";self.contname;" is now full of wine.";
            self.haswine := true;
            // check scores in the case of wine in the cask
            if(self = cask) global.checklist += wine_in_the_cask;
        }
        else if (dobj = Sea_Water) {
            dobj.verDoTake(actor);
        }
        else if (dobj = Djinn) "I don't think the djinn
                    would appreciate that.";  // BJS: Added.
        /* allow the bottle or flask to be filled with liquid from the cask */
        else if (isclass(dobj,contliquid)) {
            if(((self = bottle) or (self = flask)) and dobj.mycont = cask) {
                "(Filling the ";self.contname;" with a little of
                the ";
                dobj.adesc;" from the ";dobj.mycont.contname;
                ").\n";
                self.(dobj.myflag) := true;
                "Done.\n";
            }
            else {
                "I don't think %you% could fill ";self.thedesc;
                " from ";dobj.mycont.thedesc;". ";
            }
        }
        else {
            caps(); self.thedesc; " will only hold liquids.";
        }
    }

    verDoFill(actor) = {}
    verDoFillWith(actor,io) = {
        if (io = Sea_Water) Sea_Water.verDoTake(actor);
        else if (not isclass(io,roomliquid) and
        not isclass(io, contliquid)) {
            " %You% can't fill ";self.thedesc;
        " with ";io.thedesc;". ";}
    }

    doFill(actor) = {
        local toploc := toplocation(actor);
        if (self.isIn(Sea_Water.location))
            Sea_Water.verDoTake(actor);
        else if (Streamitem.classfind(toploc)) // DJP
            self.ioPutIn(actor, Stream);
        else if (self.isIn(Oil.location))
            self.ioPutIn(actor, Oil);
        else if (self.isIn(Wine.location))
            self.ioPutIn(actor, Wine);
/* allow filling from the cask only.  Allowed filling of flask. */
        else if ( ((self = bottle) or (self = flask)) and cask.isReachable(Me)
        and cask.haswater)
            {"\n(from the cask)\n";self.ioPutIn(actor, Stream);}
        else if ( ((self = bottle) or (self = flask)) and cask.isReachable(Me)
        and cask.hasoil)
            {"\n(from the cask)\n";self.ioPutIn(actor, Oil);}
        else if ( ((self = bottle) or (self = flask)) and cask.isReachable(Me)
        and cask.haswine)
            {"\n(from the cask)\n";self.ioPutIn(actor, Wine);}
        else
            {"There is nothing here with which to fill the ";
            self.contname;". ";}
    }

    verDoEmpty(actor) = {}
    doEmpty(actor) = {
        // DJP - emptying the container on the ground will water
        // the plant.
        if (toplocation(actor) = In_West_Pit)
            self.doPourOn(actor,Plant);
        else if (self.haswater or self.hasoil or self.haswine)
            {"%Your% ";self.contname;" is now empty and the ground
            is wet.";}
        else
            {"The ";self.contname;" is already empty!";}

        self.empty;
    }

    verDoPourOn(actor, io) = {}
    doPourOn(actor, io) = {
        if (isclass (io,RustyDoor_Class)) {
            if(RustyDoor.isoiled and self.hasoil) {
                "There's no need to do that now -
                %you've% already oiled this door.";
            }
            else if (self.hasoil) {
                "The oil has freed up the hinges so that the
                door will now move, although it requires some
                effort.";
                io.setIsoiled(true);
            }
            else if (self.haswater or self.haswine) {
                "The hinges are quite thoroughly
                rusted now and won't budge.";
                io.setIsoiled(nil);    // DJP
            }
            else {
                "The ";self.contname;" is empty. ";
            }
    
            self.empty;
        }
        else if ((io = EndDoor) or (io = NoisyDoor)) {
            if (self.hasoil) {
                if (io = EndDoor) {
                    "You pour oil on the hinges of the door, in the
                    hope that this will prevent the door
                    from creaking. ";
                }
                else {
                    "You pour oil on the hinges of the door, ";
                    if (not self.isopen)
                        "in the hope that it will now open more easily and
                        silently. ";
                    else
                        "in the hope that this will prevent it from 
                        creaking. ";
                }
                io.setIsoiled(true);
                if(NoisyDoor.opencount > 1) NoisyDoor.opencount := 1;
            }
            else if (self.haswater or self.haswine) {
                "Pouring oil on the door might make
                sense.  Other liquids don't. ";
            }
            else {
                "The ";self.contname;" is empty.";
            }
    
            self.empty;
        }
        else if (isclass(io,Access_Shaft_Grille)) {
            if (self.hasoil) {
                if (self.isopened)
                    "You've already got this grille open. ";
                else
                    "You pour oil on the hinges and lock of the
                    grille, in the hope that this will help you
                    to open it. ";
                    io.setIsoiled(true);
            }
            else if (self.haswater or self.haswine) {
                "Pouring oil on the grille might make
                sense.  Other liquids don't. ";
            }
            else {
                "The ";self.contname;" is empty.";
            }
    
            self.empty;
        }
        else if (io = Plant) {
            if (self.haswater) {
                Plant.water;
            }
            else if (self.hasoil) {
                "The plant indignantly shakes the oil
                off its leaves and asks, \"Water?\"";
            }
            else if (self.haswine) {
                "The plant drunkenly shakes the wine
                off its leaves and asks, \"Water?\"";
            }
            else {
                "The ";self.contname;" is empty.";
            }
    
            self.empty;
        }
        // Added code for sword - DJP
        // water/wine makes the sword clean; oil makes it oily and
        // it can't be cleaned afterwards.
        else if ((io = sword) or (io = Anvil)) {
            if(self.haswater or self.haswine) {
                if(not sword.isoily) {
                if(not sword.isclean) {
                    sword.isclean := true;
                    addword(sword, &adjective, 'clean');
                }
                sword.heredesc;
                }
                else
                    "Unfortunately, the water just
                    runs off the sword.  It is still
                    very oily.  ";
            }
            else if(self.hasoil) {
                if(sword.isclean) {
                    sword.isclean := nil;
                    delword(sword, &adjective, 'clean');
                }
                if(not sword.isoily) {
                    sword.isoily := true;
                    addword(sword, &adjective, 'oily');
                }
                sword.heredesc;
            }
            else {
                "The ";self.contname;" is empty.";
            }
    
            self.empty;
        }
        else if (io = theFloor) {
            // DJP - pouring on the ground where the plant is waters
            // the plant.
            if (toplocation(actor) = In_West_Pit)
                self.doPourOn(actor,Plant);
            else self.doEmpty(actor);
        }
        else
            "That doesn't seem productive.   ";
    }

    verDoDrink(actor) = {
        if (not self.hasoil and not self.haswater and not self.haswine)
            {"The ";self.contname;" is empty.";}
        else if (self.hasoil)
            "I'd advise %you% not to drink the oil, you fool!";
        //
        // Forbid the drinking of alcohol in the following circumstances:
        //
        // 1. The drunken player can't get to the appropriate location without
        //    the boat (which he'd be incapable of using) or other objects
        //    (which he'd lose).  An exception is made for Transindection 
        //    pendants - if worn, they stay with the player.
        //
        // 2. The player is in danger (e.g. due to Chaser NPC's or Wumpi)
        //
        else if (self.haswine) {
            local toploc := toplocation(actor);
            
            // Areas beyond the wheat-stone bridge
            if(toploc.wino_wsbridge)
                "That wheat-stone bridge needs to be crossed with care.  If
                you want to get back safely, I suggest that you stay off the
                booze until later. ";
            // Areas beyond the quicksand.  In the 701+ point game a different
            // message is issued if the player could get out by spinning a rod,
            // but drinking is still prohibited.
            else if(toploc.wino_quicksand) {
                // Is the player wearing a Zarkonalized pendant?
                local o := firstobj(pendantItem),zpend := nil;
                while (o) {
                    if((o.location = actor) and o.isworn and o.Zarkalonized) 
                        zpend := true;
                    o := nextobj(o,pendantItem);
                }
                // Does the player have everything required to get out of
                // here without crossing the quicksand?  
                if((pendant.location = Me) and pendant.isworn and 
                zpend and (gray_rod.isIn(Me) or black_rod.isIn(Me) or
                (multicolored_rod.isIn(Me) and (multicolored_rod.activated
                or eight_pointed_star.isIn(Me)))))
                    "Even though you have the means to get back without
                    crossing the quicksand, you'll need a clear head to do so.
                    I'd stay sober if I were you. ";
                else
                    "That damp sand looked very treacherous. You'll
                    need a clear head to get back safely. ";
            }
            // is the player in an isolated or Transindection area with
            // no pendant?  If so, no drinking.
            else if ( ((toploc.analevel != 0) or toploc.isolated) and not
            ((pendant.location = actor) and pendant.isworn)) 
                "Hmmm... You've managed to get here without wearing the gold
                pendant.  You may have the means to get out again, but
                alcohol definitely isn't the solution. ";
            // general prohibition on drinking in dangerous areas
            else if (toploc.sober)
                "You need to keep a clear head here - that wouldn't help. ";
            else if(Wumpi.phase = 1) 
                "You'd better move the Wumpi to a safer Transindection level
                first - this isn't going to help! ";
            else if((Wumpi.phase >= 2) and (Wumpi.phase <= 4))
                "You'd better get well away from the Wumpi first - this isn't
                 going to help! ";
            if (Wumpus.ischasing)
                "You'd better do something about the Wumpus
                first - this isn't going to help! ";
            if (Goblins.ischasing)
                "You'd better do something about the goblins first - this
                isn't going to help! ";
            else if (Blob.ischasing and Blob.chase >= 13)
                "You'd better do something about the strange blob first - this
                isn't going to help! ";
            else if (Dwarves.numberhere(actor) = 1)
                "You'd better do something about the dwarf first -
                this isn't going to help! ";
            else if (Dwarves.numberhere(actor) > 1)
                "You'd better do something about the dwarves
                first - this isn't going to help! ";
            else if (not defined(self,&winocode))
                "Drinking alcohol while caving is a bad idea. ";
        }
    }
    doDrink(actor) = {
        if (self.haswine) {
            self.winocode;
            self.empty;
        }
        else {
            "The ";self.contname;" is now empty.";
            self.empty;
        }
    }

    empty = {
        // check scores if we're pouring away the wine
        if (self = cask and self.haswine) global.checklist += wine_in_the_cask;
        self.haswater := nil;
        self.hasoil := nil;
        self.haswine := nil;
    }
;

/* Kludge to override all fixeditem properties.  This class should go at the
   end of the list. */
class unfixeditem: fixeditem
    isListed = true
    isfixed = nil
    weight = 0
    bulk = 0
    verDoTake( actor ) =
    {
        inherited thing.verDoTake(actor);
    }
    verDoTakeOut( actor, io ) =
    {
        inherited thing.verDoTakeOut(actor);
    }
    verDoDrop( actor ) =
    {
        inherited thing.verDoDrop(actor);
    }
    verDoTakeOff( actor, io ) =
    {
        inherited thing.verDoTakeOff(actor,io);
    }
    verDoPutIn( actor, io ) =
    {
        inherited thing.verDoPutIn(actor,io);
    }
    verDoPutOn( actor, io ) =
    {
        inherited thing.verDoPutOn(actor,io);
    }
    verDoMove( actor ) =
    {
        inherited thing.verDoMove(actor);
    }
    verifyRemove(actor) =
    {
        inherited thing.verifyRemove(actor);
    }

;


/* DJP - define new classes for portable chairs and beds. */

class portable_chairitem: item, chairitem, unfixeditem
    // Catch attempts to remove the item while the player is inside.
    verifyRemove(actor) =
    {
        if (actor.isIn(self)) {
            "%You%'ll have to get ";self.outOfPrep;" ";self.thedesc;" first.";
        }
        else if (self.isfixed)
            inherited fixeditem.verifyRemove(actor);
        else
            pass verifyRemove;
    }
;
class portable_beditem: item, beditem, unfixeditem
    ischair = nil
    isbed = true
    sdesc = "bed"
    verifyRemove(actor) =
    {
        if (actor.isIn(self)) {
            "%You%'ll have to get ";self.outOfPrep;" ";self.thedesc;" first.";
        }
        else if (self.isfixed)
            inherited fixeditem.verifyRemove(actor);
        else
            pass verifyRemove;
    }
;

/*
 * Important notes about treasures:
 *
 * If you want to add treasures, use the CCR_treasure_item class.
 *
 * Each treasure is worth self.takepoints points when taken for the
 * first time, and an additional self.depositpoints when deposited
 * in the building.  Scoring is handled by the customized moveInto method 
 * (which adds the relevant object(s) to global.checklist) and by the
 * global.gendaemon code (which checks the position of all objects listed
 * in global.checklist). Be sure to update global.maxscore and scoreRank
 * if you add treasures (or anything else that gives the player points,
 * for that matter).  
 *
 * The proper way to check if an object is a treasure is:
 *
 *    if (isclass(obj, CCR_treasure_item))
 *        ...
 *
 */
class CCR_treasure_item: item
    plural = 'treasures' 'goodies'

    basis = 1
    takepoints = {      // for taking the treasure.
        if (global.game550) return 2;
        else if (global.newgame) return basis*2;
        else return self.oldtakepoints;
    }
    depositpoints = { // for correctly depositing the item.
        if (global.game701) return 10;
        if (global.game550) return 13;
        else if (global.newgame) return basis*3;
        else return self.olddepositpoints;
    }

    oldtakepoints = 2    // points for taking this treasure in old game
    olddepositpoints = 12    // points for putting in building in old game

    awardedpointsfortaking = nil
    awardedpointsfordepositing = nil

    targloc = Safe          // Where to put it for full credit
    contloc = Inside_Building // location of target container or nil
                  // if this is not to be checked
    outercontloc = nil      // location of outer container or nil if
                  // this is not to be checked
                  // Note: in an 'old' (350 or 550 point)
                  // game, targloc, contloc
                  // and outercontloc are ignored and
                  // Inside_Building, nil and nil used
                  // instead, unless the oldkeep property
                  // is set to true.  This includes scoreable
                  // non-treasure objects.

    // DJP - the need for takescore/checkscore has now been obviated.
;

class coinitem: item // flags that an item can be used as coins
    iscoinitem = true
;


/* 2 */
brass_lantern: endgame_clone, lightsource
    // N.B. endgame_clone is a subclass of item and is defined in ccr-endg.t
    endgame_pile = lamp_collection
    nosack = true    // don't put in a container to make room for
            // more objects.
    mass = 1
    turnsleft = 650 // new game expert mode
    sdesc = "brass lantern"
    ldesc = {
        "It is a shiny brass lamp";

        if (self.islit) {
            if (self.turnsleft <= 30)
                ", glowing dimly.";
            else
                ", glowing brightly.";
        }
        else
            ".  It is not currently lit.";
    }
    pluraldesc = { // for endgame
        if (self.islit) "lit brass lanterns";
        else "unlit brass lanterns";
    }
    location = Inside_Building
    noun = 'lamp' 'headlamp' 'headlight' 'lantern' 'torch'
    adjective = 'electric' 'brass'
    plural = 'lamps' 'lanterns' 'torches' // for endgame

    verDoLookin(actor) = {}
    verDoSearch(actor) = {}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = {
        "You open the lamp, revealing ";
        if (self.turnsleft > 30)
            "a set of batteries. When the time comes to replace
            them, do PUT BATTERIES IN LAMP or CHANGE BATTERIES, if
            I haven't already done it for you. ";
        else if(self.turnsleft > 0)
            "a set of nearly-dead batteries.  To
            replace them, do PUT BATTERIES IN LAMP or CHANGE BATTERIES. ";
        else
            "a set of worn-out batteries.  To
            replace them, do PUT BATTERIES IN LAMP or CHANGE BATTERIES.
            As a special concession, I'll allow you to do this even in
            a dark room. ";
        "You close the lamp again. ";
    }
    verDoOpen(actor) = {}
    doOpen(actor) = {self.doSearch(actor);}
    verDoClose(actor) = {"It's already closed.";}

    ison = nil
    islit = {
        if (self.ison and self.turnsleft > 0)
            return true;
        else
            return nil;
    }

    verDoRub(actor) = {}
    doRub(actor) = {
        "Rubbing the electric lamp is not particularly
        rewarding.  Anyway, nothing exciting happens.";
    }

    verDoTurnon(actor) = {
        if (self.ison)
            "It's already on.";
    }
    doTurnon(actor) = {
/* DJP - check whether the room was lit .. */
        local waslit := actor.location.islit;

        if(self.isIn(Crystal_Palace)) {
            "Your lamp is now on, but the glare from the walls is
            absolutely blinding.  If you proceed you are likely to
            fall into a pit. ";
        }
        else "The lamp is now on.";
        self.ison := true;

        if (self.turnsleft > 0)
            notify(self, &wearbatteries, 0);
        else
            "  Unfortunately, the batteries seem to
            be dead.";
/* DJP - check whether the lamp has just lit the room and print
   the room description if appropriate. */
        if (actor.location.islit and not waslit)
        {
            "\n";
            actor.location.enterRoom(actor);
        }
    }
    turnon = {
/* DJP - added method to silently turn on the lamp */
        if(self.ison) return;
        self.ison := true;
        if (self.turnsleft > 0)
            notify(self, &wearbatteries, 0);
    }
    verDoTurnoff(actor) = {
        if (not self.ison)
            "It's already off.";
    }
    doTurnoff(actor) = {
        "The lamp is now off.";
        self.turnoff;
        if (not actor.location.islit) {
            P(); I(); "It is now pitch black.  If you proceed you
            will likely fall into a pit. ";
        }
        if (actor.isIn(Foggy_Plain))Fog.heredesc;
    }
/* DJP - added method to set the lamp life to some arbitrary value */
    setlife(v) = {
        // if the lamp life was 0 or less, and we're now setting it
        // to a positive quantity, and the lamp is off, we turn off
        // the daemon.
        if(self.turnsleft < 1 and (not self.ison) and v > 0)
        unnotify(self, &wearbatteries);
        // if the lamp life was positive, and we're now setting it
        // to 0 or less, and the lamp is off, we turn on the daemon.
        if(self.turnsleft > 0 and (not self.ison) and v < 1)
        notify(self, &wearbatteries,0);
        // reset wandernote if we've recharged the batteries
        if(v > 0) self.wandernote := nil;
        // change the number of turns to the desired value.
        self.turnsleft := v;
    }

    verDoLight(actor) = { self.verDoTurnon(actor); }
    doLight(actor) = { self.doTurnon(actor); }

    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        local waslit := actor.location.islit;
        if (isclass(dobj,old_batteries))
        "Those batteries are dead; they won't
        do any good at all.";
        else if (isclass(dobj,fresh_batteries)) {
            if (self.turnsleft > 30 ) {
                "There's still life left in your batteries - I
                wouldn't change them until your lamp starts to
                grow dim. ";
            }
            else {
                self.do_replace(dobj);
                "Done. ";
                /* DJP - check whether the lamp has just lit the room and
                print the room description if appropriate. */
                if (actor.location.islit and not waslit) {
                    "\n";
                    actor.location.enterRoom(actor);
                }
            }
        }
        else
            "The only thing %you% might successfully put in
            the lamp is a fresh set of batteries.";
    }

    // The following method is called when the player gets resurrected.
    turnoff = { // DJP - changed to leave daemon running when lamp has
                // run out of power.
        if (self.ison) {
            self.ison := nil;
            if(self.turnsleft > 0) // DJP
                unnotify(self, &wearbatteries);
        }
    }

    wearbatteries = {  // various mods made - DJP
        local toploc;
        // do nothing if this is a lamp 'clone' in the endgame
        if (self <> brass_lantern) return;
        // do nothing in Transindection areas until Wumpi are known
        // to be safe or the green pendant has been obtained.
        if (Wumpi.nodeath(self)) return; 
        self.turnsleft := self.turnsleft - 1;
        if (self.turnsleft = 0) { // DJP - issue message once only.
            P(); I();
            "Your lamp has run out of power. ";
        }
        if (self.turnsleft < 1) {
            toploc := toplocation(Me);
            if (self.replace_batteries) {
                // do nothing
            }
            else if (toploc.isoutside and not toploc.nolampwarn
            and not self.wandernote) { // DJP
                self.wandernote := true;
                P(); I();
                "You can't explore the cave without a lamp,
                and there's not much point in wandering
                around out here";
                if(global.newgame)
                    ", unless you want to explore the castle.
                    If not, ";
                else
                    ". ";
                "I suggest you quit now";
                if (not self.destroyed and
                (fresh_batteries.obtained >
                fresh_batteries.used)) {
                    if (global.game550) ", unless you can get
                        hold of those batteries, or find some
                        other way of recharging the lamp.
                        (As a special concession I'll allow you to
                        CHANGE BATTERIES in a dark room, if you
                        can reach it without falling into a
                        pit.) ";
                    else ", unless you can get hold of those
                        batteries.
                        (As a special concession I'll allow you to
                        CHANGE BATTERIES in a dark room, if you
                        can reach it without falling into a
                        pit.) ";
                }
                else {
                    if (not self.destroyed and
                    global.game550)
                        ", unless you can find some way of
                        recharging the lamp. ";
                    else
                        ". ";
                }
            }
        }
        else if (self.turnsleft = 30) {
            P(); I();
            "Your lamp is getting dim. ";

            if (self.replace_batteries) {
                // do nothing.
            }

            // DJP: Modified for extra sets of batteries. The
            // wording is mostly the same, but the tests are
            // altered.

            // have we used up all the sets available in the game?
            else if (fresh_batteries.used >=
            fresh_batteries.available) {
                // DMB: changed the wording of this
                // slightly for convenience.
                "You're also out of spare batteries.
                You'd best start wrapping this up. ";
            }
            // or are there some unused fresh batteries
            // around somewhere?
            else if (fresh_batteries.obtained >
                fresh_batteries.used) {
                "You'd best go back for those
                batteries. ";
            }
            // or we could obtain another set
            else {
                "You'd best start wrapping this up,
                unless you can find ";
                if(fresh_batteries.obtained = 0) {
                    "some fresh batteries.  I seem to recall
                    there's a vending machine in the maze.
                    Bring some coins with you. ";
                }
                else "a further set of batteries - maybe
                there are more coins you can use in the
                vending machine.  ";
            }
        }
    }

    replace_batteries = { // modified - DJP.  It only happens automatically
                          // if we are in a lit room, or the batteries are
                          // in our possession.   But batteries can be
                          // changed manually even in a dark room.
        local waslit := Me.location.islit;
        local i,o,l:=length(fresh_batteries.list);
        for (i := 1; i <= l; i++) {
            o := fresh_batteries.list[i];
            if (o.isIn(truetop(Me)) and o.isVisible(Me) and
            o.isReachable(Me) and (Me.location.islit
            or o.isIn(Me))) {
                "\nI'm taking the liberty of replacing the
                batteries. ";
                self.do_replace(o);
                /* DJP - check whether the lamp has just lit the
                room and print the room description if appropriate. */
                if (Me.location.islit and not waslit) {
                    "\n";
                    Me.location.enterRoom(Me);
                }
            return true;
            }
        }
        return nil;
    }

    do_replace(o) = {
        local p;
        // remove the good batteries
        delete o;
        // create a set of used batteries and drop them
        p := new old_batteries;
        p.moveInto(droploc(Me));
        p.moved := nil;
        if(self.turnsleft < 1 and not self.ison)
            unnotify(self, &wearbatteries);
        if (global.vnumber = 0)
            self.turnsleft := 2500;
        else {
            // original 551-point Fortran version gave only 400
            // turns per set of batteries, but this seems ungenerous
            // compared with the old game.  So we give 1000 turns
            // for the first set of new batteries and 2500 turns
            // for the second.    In novice mode, we add another
            // 500 turns in each case.
            //
            // Similarly, the 550-point version only gave 300 turns for the
            // batteries, but we give 1000 or 1500 instead.
            //
            if (fresh_batteries.used = 1)
            self.turnsleft := 1000;
            else
            self.turnsleft := 2500;
            if(global.novicemode) self.turnsleft += 500;
        }
        self.wandernote := nil;
        // DJP -- allow one use of NOSIDE SAMOHT for each set of batteries.
        // (in accordance with original adv550 coding).
        self.is_relit := nil;
    }
    magic_recharge = { // BJS: NOSIDE SAMOHT has been used to
                       // recharge the lamp:
        local i, ultloc, d := nil;    // Find room that lamp is in.
        for (i:=self; i<>nil; i:=i.location) ultloc := i;
        if(Me.isIn(ultloc) and isclass(ultloc, darkroom)
            and not self.is_relit) {
            // self.is_relit flags that NOSIDE SAMOHT has been used to
            // recharge the current set of batteries.  (In accordance with
            // the original acode source, we now allow one recharge per set
            // of batteries.  The acode source (but not the TADS port) also 
            // checks that the Sorcerer's Lair has been visited.

            // Note that the 660-point and 770-point games allow multiple
            // recharges with NOSIDE SAMOHT.  However, the 701(+) point
            // versions only allow one recharge per set of batteries.  There is
            // a good reason - the player can obtain one set of batteries
            // for free, using a set of non-treasure coins (lead slugs).

            //
            //  If player is in same room, which isn't lit, then:

            // Electrocute player if lamp is held.
            if (self.isIn(Me)) { "With a sharp sizzling
                sound, a large spark of electricity
                jumps out of thin air and strikes
                your lamp.  The immense electrical
                charge flows to ground through your
                body and fries you to a crisp.    ";
                d := true;
            }

            // Blow up lamp if it's already charged.
            if (self.turnsleft > 40) {
                if (rand(2) = 1 and not d) {
                    "With a loud \"zap\" a bolt
                    of lightning springs out of
                    midair and strikes your lamp,
                    which immediately and violently
                    explodes.  You narrowly miss
                    being torn to shreds by the
                    flying metal."; P();
                }

                else if (not d) { "In a loud crackle
                    of electricity, a bolt of
                    lightning jumps out of nowhere
                    and strikes your lamp.    The
                    lamp instantly explodes like
                    a grenade, and you are mown
                    down by a cloud of shrapnel.";
                    d:=true;
                }
                // Blow up the lamp.
                self.moveInto(nil); self.turnoff;
                self.setlife(0);
                self.destroyed := true;
            }
            // Otherwise recharge it. Give twice as many turns as in
            // original...
            else {
                self.is_relit := true;
                self.setlife(300); // But give more time in novice mode.
                if(global.novicemode) self.setlife(500);
                if(not d) self.turnon;
                if(not d) "The air fills with tension,
                    and there is a subdued crackling sound.
                    A blue aura forms about your lantern,
                    and small sparks jump from the lantern
                    to the ground.  The aura fades away after
                    several seconds, and your lamp is once
                    again shining brightly.";
            }
                // Kill player if d is true:
            if (d) die();
        }
        else "Nothing happens."; // If lamp isn't in room, etc.
    }
    doCount(actor) = {
        if (actor.isIn(At_Ne_End) or actor.isIn(At_Sw_End))
            "You lose count of the number of brass
            lanterns you can see around here! ";
        else pass doCount;
    }
;

/* 4 */
wicker_cage:endgame_clone, container // coding reworked for endgame
    endgame_pile = wicker_cage_row
    pass_class = container
    mass = 1
    sdesc = {
        if (self.isqcontainer) {  // set in endgame
            if(self.hasbird)
                "occupied wicker cage";
            else
                "empty wicker cage";
        }
        else "wicker cage";
    }
    adesc = {
        if (self.isqcontainer) {  // set in endgame
            if(self.hasbird)
                "an occupied wicker cage";
            else
                "an empty wicker cage";
        }
        else "a wicker cage";
    }
    ldesc = {
        if(itemcnt(self.contents) <> 0){
        "It's a small wicker cage.";
            P(); "It contains ";
            listcont(self);". ";
        }
        else "It's a small empty wicker cage. ";
    }
    pluraldesc = {
        if (self.isqcontainer) {
            if(self.hasbird)
                "occupied wicker cages";
            else
                "empty wicker cages";
        }
        else "wicker cages";
    }

    location = In_Cobble_Crawl

    noun = 'cage' 'birdcage'
    plural = 'cages'
    adjective = 'small' 'wicker' 'empty' // Removed 'bird'

    /* We change 'empty' to 'occupied' when a bird is put into a cage.
    This allows the player to distinguish between empty and non-empty
    cages in the endgame.  */

    hasbird = (itemcnt(self.contents) > 0)
    // the construct method makes a 'quiet' container and sets up the
    // adjectives for an empty cage.
    construct = {
        self.isqcontainer := true;
        self.emptyvocab;            //set the vocab for an empty cage
        pass construct;
    }
    // returns the number of empty cages at a location
    loccounte(loc) = {
        local i,j,o,l,ll;
        ll := self.list + wicker_cage;
        l := length(ll);
        j := 0;
        for (i := 1; i<= l; i++) {
        o := ll[i];
        if(o.location = loc and length(o.contents) = 0)
            j += 1;
        }
        return j;
    }
    // returns the first empty cage at a location
    firstcage(loc) = {
        local i,j,o,l,ll;
        ll := self.list + wicker_cage;
        l := length(ll);
        j := 0;
        for (i := 1; i<= l; i++) {
        o := ll[i];
        if(o.location = loc and length(o.contents) = 0)
            return o;
        }
        return nil;
    }

    verDoOpen(actor) = {
        local birdobj;
        if(itemcnt(self.contents) = 0) "It's already open. ";
        else {
            birdobj := self.contents[1];
            birdobj.verDoDrop(actor);
        }
    }
    doOpen(actor) = {
        local birdobj;
        "(releasing the bird)\n";
        birdobj := self.contents[1];
        birdobj.doDrop(actor);
    }
    verDoClose(actor) = {
        // DJP - changed to be right in the endgame.
        if(itemcnt(self.contents) > 0) "It's already closed. ";
        else "There's little point in closing the cage when it's
        empty. ";
    }


/* The Fortran version prevents the cage from going into the sack, but this
   isn't compatible with the cage being 'small'. Now we stop the cage
   from going into the sack if it contains the bird. */


    /* Added to make 'put bird in cage' work better in the endgame */
    verIoPutIn(actor) = {
        if (length(self.contents) > 0) { 
            "There's already a bird in the cage. ";
        }
    }
    ioPutIn(actor, dobj) = {
        if (dobj <> little_bird and dobj.objclass <> little_bird) {
            caps(); self.thedesc; " isn't a suitable container
            for anything but a bird.";
        }
        else
        if (self.location.nobird) {
            "Are you kidding?  %Do% %you% want to suffocate the
            poor thing?";
        }
        else pass ioPutIn;
    }
    doCount(actor) = {
        if (actor.isIn(At_Ne_End) or actor.isIn(At_Sw_End))
            "You lose count of the number
            of birdcages you can see around here! ";
        else pass doCount;
    }

    // Adjust the vocabulary when a bird is put in or taken out.  This
    // code is called by the moveInto method of little_bird.
    emptyvocab = {
        delword(self,&adjective,'occupied');
        addword(self,&adjective,'empty');
    }
    fullvocab = {
        addword(self,&adjective,'occupied');
        delword(self,&adjective,'empty');
    }
;

/* 5 */

// Due to the large number of rods in the 701+ version, we now define
// special classes to handle 'magic wand' properties.

class waveable_rod: item
    // Code for a waveable rod.  In some game versions, the rod must be upgraded
    // before it will work in locations other than the fissure.  (After cave
    // closure the rods won't work at all unless it has been upgraded.)

    doWave(actor) = {
        /* clear global.noAskWave (see thing.doWave) */
        global.noAskWave := nil;
        if (self.isIn(Window.location))
            "The shadowy figure waves back at you with a
            similar-looking rod, but nothing else happens. ";
        else if (self.isIn(West_Side_Of_Fissure) or
        self.isIn(On_East_Bank_Of_Fissure)) {
            if (global.closed and not self.isupgraded)
                "Peculiar.  Nothing happens.";
            else {
                if (CrystalBridge.exists)
                    CrystalBridge.vanish(actor,self);
                else
                    CrystalBridge.appear(actor);
            }
        }
        else if(self.isIn(Decrepit_Bridge.location) and
        self.isupgraded and not Decrepit_Bridge.isfallen) {
            "Nothing obvious happens.";
            Decrepit_Bridge.crosscount := -1;
        }
        else if(self.isIn(RicketyBridge.location) and
        self.isupgraded and RicketyBridge.exists) {
            "Nothing obvious happens.";
            RicketyBridge.strengthened := true;
        }
        else if (self.isIn(At_Breath_Taking_View) or
        self.isIn(Valley_Faces)) {
            if (not global.game550) "Nothing happens (in this
                version of Adventure). ";
            else if (global.closed and not self.isupgraded) {
                "Peculiar.  Nothing happens. ";
            }
            // In the 701-point game the rod must be upgraded before you
            // can create the bridge
            else if (global.game701 and not self.isupgraded) {
                "Flakes of rust fall off the rod, but nothing else happens. ";
            }
            else {
                if (WheatStoneBridge.exists) {
                    "The earth shudders violently,
                    and steam blasts upward from
                    the geyser.  The wheat-stone
                    bridge cracks and splits, and
                    the fragments fall into the gorge. ";
                    WheatStoneBridge.moveLoclist([]);
                    WheatStoneBridge.exists := nil;
                }
                else {
                    "The earth begins to shudder
                    violently, and smoke flows up
                    from the gorge beneath your
                    feet.  With a violent >glop<,
                    the volcano belches out an
                    immense blast of molten lava
                    which flies into the air above
                    the gorge and suddenly solidifies
                    into a fragile-looking arch of
                    wheat-colored stone that bridges
                    the gorge. ";
                    WheatStoneBridge.moveLoclist(
                    [At_Breath_Taking_View Valley_Faces]);
                    WheatStoneBridge.exists := true;
                }
            }
        }
        // This is only possible in the 550-point or 701-point game.  In the 
        // latter, we require that the rod be upgraded.
        else if (self.isIn(Coral_Passage) or self.isIn(Coral_Pass_2)) {
            if(global.closed and not self.isupgraded)
                "Peculiar. Nothing happens. ";
            else if(global.game701 and not self.isupgraded) {
                "Flakes of rust fall off the rod, but nothing else happens. ";
            }
            else {
                // Don't soften the quicksand when the rod is waved again.
                // That would be too difficult.
                "Nothing obvious happens.";
                QuickSand.isHard := true;
            }
        }
        else
            "Nothing happens.";
    }
    upgrade = {
        if(self.isupgraded) return;
        self.isupgraded := true;
        delword (self, &adjective, 'rusty');
        addword (self, &adjective, 'shiny');
    }
    downgrade = {
        if(not self.isupgraded) return;
        self.isupgraded := nil;
        delword (self, &adjective, 'shiny');
        addword (self, &adjective, 'rusty');
    }
;
class spinnable_rod: item
    //
    // This code should be invoked only in the 701+ point version.  Nothing 
    // special happens unless there is a plaque in the room.  If the
    // isplaqueroom property of the room is set to true, the player will be
    // transported instantly. 
    //
    // Spin rod over fissure or bridge
    // (action methods are coded for the indirect objects)
    //
    verDoSpinOver(actor,io) = {self.verDoTurn(actor);}
    mycolor = 'red'
    verDoTurn(actor) = {
        local toploc := toplocation(actor);
        if(not self.isIn(actor))
            "You're not holding <<self.thedesc>>. ";
        else if(self.isspinning) {
            caps(); "<<self.thedesc>> is already spinning! ";
        }
        else if(not(toploc = Rodspinplaque.location)
        and not toploc.isplaqueroom) {
            if(manual.isread)
                return;
            else pass verDoTurn;
        }
    }
    doTurn(actor) = {
        local toploc := toplocation(actor);
        self.isspun := true;
        if(not(toploc = Rodspinplaque.location)
        and not toploc.isplaqueroom) {
            "You spin the rod in your hands.  It turns very freely,
            but nothing unusual happens here.  Maybe you should take 
            another look at the manual... ";
        }
        else {
            local oldana := toploc.analevel;
            local stopturns := 2;
            if (toploc.isplaqueroom) stopturns := 1;
            // Does this rod need a star?
            if (self.needs_activation and not self.activated) {
                "You start to turn the rod in your hand, and it spins very
                rapidly - but nothing else happens.  Maybe if you could find
                a star to put on the end ... ";
                return;
            }
            // Is a security alert in progress?  (Now possible due to the
            // presence of a plaque at Red level)
            if (global.triggered_alert) {            
                "You start to turn the rod in your hand, and the star begins
                to glow dimly, but nothing exciting happens.  Something seems
                to be blocking the rod's magic properties. ";
                return;
            }
            // Otherwise the rod spins rapidly and shows the Transindection
            // color of its normal destination.  If the room has the
            // isplaqueroom property set, the player is teleported
            // immediately.
            if(self.isIn(Green_Trans_Room))
                "You start to turn the rod in your hand, and something strange
                happens.  The broken ceramic pendant issues a high-pitched
                whistling noise, and the ghostly plaques reappear, hanging in
                mid-air where you saw them before!  Suddenly the noise stops,
                and your pendant issues three bright beams of green light.  One
                is directed at the star at the end of your rod, and the other
                two illuminate the plaques.  Your rod starts to spin of its
                own accord, faster and faster ... ";
            else 
                "You start to turn the rod in your hand, and something strange
                happens!  The star turns <<self.mycolor>> and the rod starts to
                spin of its own accord, faster and faster ... ";
            notify(self, &stopspin, stopturns);
            self.isspinning := true;
            // If a room has the isplaqueroom property, spinning a rod will
            // transport the player with no further ado
            if (toploc.isplaqueroom) {
                local newana;
                if ((toploc = Plaque_Room) and (In_Debris_Room.west 
                != Debris_West)) {
                    "You feel a sharp pain in your ears, followed by a
                    sudden gust of wind from the east.  The chamber then
                    goes completely dark, and you find yourself ... ";
                    // switch the west direction in the debris room and ensure
                    // that the new descriptions will be printed in full
                    Debris_West.east := In_Debris_Room;
                    Debris_West.isseen := nil;
                    In_Debris_Room.west := Debris_West;
                    In_Debris_Room.isseen := nil;
                    Debris_West.isolated := nil;
                    Plaque_Room.isolated := nil;
                    eight_pointed_star.moveInto(Debris_West);
                    eight_pointed_star.moved := nil;
                }
                else {
                    "You feel a sudden gust of wind, and the room goes dark.
                    You then find yourself ... ";
                }
                P();
                if ((pendant.location = actor) and pendant.isworn and
                pendant.strictcontrol) {
                    actor.travelTo(self.myhome2[oldana+1]);
                }
                else if ((broken_pendant.location = actor) and 
                broken_pendant.isworn and broken_pendant.strictcontrol) {
                    actor.travelTo(self.myhome2[oldana+1]);
                }
                else
                    actor.travelTo(self.myhome);
                P();
                newana := toplocation(actor).analevel;
                if (newana != oldana) {
                    if((pendant.location = actor) and pendant.isworn) {
                        "The gold pendant whispers to your mind: ";
                        if (pendant.strictcontrol)
                            "\"Warning 09A2:  Transindection movement
                            mediated by unregistered object, type
                            Astral Staff.  Unable to block movement
                            due to lack of proximity to Control Room.\" ";
                        else 
                            "\"Warning 09A1: Transindection movement 
                            mediated by unregistered object, type Astral 
                            Staff.\" ";
                    }
                    if (not IronBridge.transchanged) {
                        P();
                        "You ponder the implications of your discovery.  
                        I'd bet that even Eldrand didn't know that the
                        rods could transport you through Transindection! ";
                    }
                    IronBridge.transchanged := true;
                }
            }
        }
    }
    stopspin = {
        local toploc := toplocation(self);
        local meloc := toplocation(parserGetMe());
        if (toploc = meloc) {
             P();
             "The rod slows down again and comes to rest. ";
        }
        self.isspinning := nil;
    }
    // methods for attempting to detach a star from a rod
    verDoDetach(actor)={
        local lst:=objwords(1),noun;
        if (length(lst) > 0) {
            noun:=lst[length(lst)];
            if(noun = 'star') return;
            else "You'll need to be more specific. ";
        }
        else "You'll need to be more specific. ";
    }
    verIoDetachFrom(actor)={}
    verIoTakeOut(actor)={}
    verDoDetachFrom(actor,io) = {
        if(not (io=self))
             "That's not attached to <<self.thedesc>>. ";
        else {
            local lst:=objwords(1),noun;
            if (length(lst) > 0) {
                noun:=lst[length(lst)];
                if(noun = 'star') return;
                else {
                    caps(); "<<self.thedesc>> isn't attached to anything. ";
                }
            }
            else {
                caps(); "<<self.thedesc>> isn't attached to anything. ";
            }
        }
    }        
    verDoTakeOut(actor,io)= {
        local lst,noun;
        if (not (io=self)) {
            pass verDoTakeOut;
        }
        lst := objwords(1);
        if (length(lst) > 0) {
            noun:=lst[length(lst)];
            if(noun = 'star')
                return;
            else {
                caps(); "<<self.thedesc>> isn't attached to anything. ";
            }
        }
        pass verDoTakeOut;
    }

    doDetach(actor) = {
         "It is beyond your power to detach the star from the rod. ";
    }
    ioDetachFrom(actor,dobj) = {        
         self.doDetach(actor);
    }          
    ioTakeOut(actor,dobj) = {self.ioDetachFrom(actor,dobj);}
    // cleaning is synonymous with rubbing
    doClean(actor) = { self.doRub(actor); }
    doCleanWith(actor,io) = { self.doRub(actor,io); }
;
black_rod: endgame_clone, waveable_rod, spinnable_rod
    endgame_pile = black_rod_bundle
    mass = 2
    // DJP: change sdesc/thedesc in the endgame to help with disambiguation
    sdesc = {
        if (At_Sw_End.isseen) "star rod";
        else "black rod";
    }
    ldesc = {
        "It's a three foot black rod with a ";
        if(self.isupgraded) "shiny ";
        else "rusty ";
        "star on an end. ";
        if (At_Sw_End.isseen)
            "To distinguish this type of rod from the kind found at the
            southwest end, I'll refer to it as a \"star rod\" and to the
            other type as a \"marked rod\". ";
    }
    location = In_Debris_Room
    noun = 'rod' 'wand' // DJP - removed 'star' from noun list
    plural = 'rods' 'wands'
    // 'rusty' is changed dynamically - DJP
    adjective = 'black' 'rusty' 'star' 'magic'
    myhome = In_Debris_Room
    myhome2 = [In_Debris_Room, Blue_Debris_Room, Green_Debris_Room]
;

/*
 * The following rod is actually an explosive.    The 350-point game
 * leaves the player to figure it out from a so-called hint, but
 * the 551-point game is more direct.
 *
 * I've added the words 'explosive' and 'dynamite' as nouns and adjectives,
 * and 'blast' as an adjective.     Perhaps this will give some lucky soul
 * a clue.
 *
 * Note that this object is never seen - it is in fact used as a class for
 * dynamic object creation.  However, it should NOT be defined as a class.
 * For the benefit of the score-checking routine, it should be left as
 * an object so that it will appear in the appropriate lists when they are
 * built by preinit.  In the 551-point game the appropriate score will be
 * given when any of its dynamically-created 'clones' is deposited in the
 * target location.
 *
 */
/* 6 */
black_mark_rod: endgame_clone
    endgame_pile = black_mark_rod_bundle
    mass = 2
    sdesc = "marked rod"
    ldesc = {
        "It's a three foot black rod with a rusty mark on an end.
        To distinguish the two types of rod, I'll refer to this
        type as a \"marked rod\" and to the other type as a
        \"star rod\". ";
    }
    location = nil
    noun = 'rod' 'explosive' 'dynamite'
    plural = 'rods'
    adjective = 'black' 'rusty' 'mark' 'marked' 'blast' 'explosive'
    'dynamite'

    takepoints = 0
    // This rod scores points in the 551-point game, but not in the 
    // 550-point and 701-point versions which use the 'cylindrical room' 
    // endgame.
    depositpoints = {if (global.newgame and not global.game701) return 2;
    else return 0;}
    targloc = {
        if(global.newgame) return Phone_Booth2;
        else return At_Ne_End;
    }
    contloc = nil
    oldkeep = true

    doWave(actor) = {
        /* clear global.noAskWave (see thing.doWave) */
        global.noAskWave := nil;
        "Nothing happens.";
    }

    verDoBlastWith(actor) = {}
    doBlastWith(actor) = { endpuzzle(); }
;

/* 10 */
velvet_pillow: endgame_clone, surface
    endgame_pile = velvet_pillow_pile
    mass = 1
    sdesc = "velvet pillow"
    ldesc = {
        "It's just a small velvet pillow. ";
        if(itemcnt(self.contents) > 0) {
            P(); I();
            "Resting delicately on the pillow, you see "; listcont(self); ". ";
        }
    }
    pluraldesc = "velvet pillows"  // for endgame
    location = In_Soft_Room
    noun = 'pillow'
    plural = 'pillows'           // for endgame
    adjective = 'velvet' 'small'

/* The code for 'put vase on pillow' now actually does just that.  It only
   works when the pillow has been dropped at a location. */
    verIoPutOn(actor) = {
        if (self.isIn(Me)){
            "%You% could at least drop the "; self.thedesc;
            " first! ";
        }
        else if (not isclass(self.location,room) and
        isclass(self.location,container)) {
            "%You% can't do that while "; self.thedesc;
            " is in a container. ";
        }
        else pass verIoPutOn;
    }
    ioPutOn(actor, dobj) = {
        if (dobj <> ming_vase and dobj <> glass_vial) {
            "%You% %do%n't need to put "; dobj.thedesc; " on ";
            self.thedesc;". ";
        }
        else {
            if (dobj = ming_vase) "The vase is now resting, delicately,
                on a velvet pillow.";
            if (dobj = glass_vial) "The vial is now resting, delicately,
                on a velvet pillow.";
            dobj.moveInto(self);
        }
    }
    verifyRemove(actor) = {
        if (ming_vase.isIn(self))"%You%'d better take the vase first. ";
        if (glass_vial.isIn(self)) "%You%'d better take the vial first. ";
        else pass verifyRemove;
    }
;

/* 14 */
giant_bivalve: endgame_clone
    endgame_pile = oyster_bed
    mass = 7
    bulk = 4 // your hands would certainly be full!
    opened = nil

    sdesc = {
        if (self.opened)
            "giant oyster";
        else
            "giant clam";

        if (self.isIn(Me))
            " >grunt!<";
    }
    thedesc = {
        if (self.opened)
            "the giant oyster";
        else
            "the giant clam";
    }

    ldesc = {
        "It's an enormous ";
        if (self.opened) "oyster";
        else "clam";
        " with its shell tightly closed. ";

        // During the endgame, the oyster has something
        // written on it.
        if (self.isIn(At_Ne_End) or self.isIn(At_Sw_End) or
        self.isIn(Phone_Booth2)) {
            "Interesting.  There seems to be something
            written on the underside of the oyster.";
        }
    }
    pluraldesc = "giant oysters" // for repository

    location = In_Shell_Room
    noun = 'clam' 'oyster' 'bivalve' 'shell'
    plural = 'oysters' // for repository
    adjective = 'giant' 'enormous' 'massive' 'big' 'huge' 'tightly'
        'closed' 'five' 'foot' 'five-foot' '5-foot'

    ishuge = true

    verDoOpen(actor) = { self.verDoOpenWith(actor, nil); }
    doOpen(actor) = {
        if (trident.isIn(Me)) {
            //
            // In the original, "open clam" would work
            // as long as you were carrying the trident,
            // but this seems very prone to accidental
            // solving, and since we aren't limited to
            // two word parsing, I've just taken the
            // liberty of forcing the player to type
            // "open clam with trident."
            //
            "The clam can't be opened just like that.  %You%'ll have to open it
            \(with\) something. "; // DJP - made a little more user-friendly.
                                   // (we don't use askio because this might
                                   // choose the trident automatically)
        }
        else {
            "%You% %do%n't have anything strong enough to
            open "; self.thedesc; ".";
        }
    }
    verDoOpenWith(actor, io) = {
        if (self.isIn(Me)) {
            "I advise %you% to put down "; self.thedesc;
            " before opening it.  >Strain!<";
        }
    }
    doOpenWith(actor, io) = {
        if (io = trident) {
            if (self.opened) {
                "The oyster creaks open, revealing nothing
                but oyster inside.  It promptly snaps shut
                again.";
            }
            else {
                "A glistening pearl falls out of the clam and
                rolls away.  Goodness, this must really be an
                oyster.     (I never was very good at
                identifying bivalves.)    Whatever it is, it
                has now snapped shut again.";

                self.opened := true;
                pearl.moveInto(In_A_Cul_De_Sac);
            }
        }
        else {
            caps(); io.thedesc; " isn't strong enough to
            open "; self.thedesc; ".";
        }
    }
    verDoBreak(actor) = {
        "The shell is very strong and is impervious to
        attack.";
    }
    verDoAttack(actor) = { self.verDoBreak(actor); }
    verDoAttackWith(actor, io) = { self.verDoBreak(actor); }

    //
    // The oyster has a hint written on its underside once
    // the cave's closed.  (Look, don't ask me, I'm just
    // porting this game!)
    //
    verDoRead(actor) = {
        if (not self.isIn(At_Ne_End) and not self.isIn(At_Sw_End))
            "You're babbling -- snap out of it!";
    }
    doRead(actor) = {
        //
        // This is supposed to be a hint (i.e., it's supposed
        // to cost points), but DMB put it in as a freebie
        // for the old game because he thought the final puzzle
        // was absurdly difficult even with the free hint.
        //
        if(global.oldgame) {
            "It says, \"There is something strange about this
            place, such that one of the words I've always known
            now has a new effect.\"";
        }
        // DJP - for the new game, the hint is very direct and we
        // do charge points.
        else {

            if (not self.isread) {
                "This looks like a hint.  I can read it for you,
                but it will cost you 10 points.  Do you want the
                hint? ";

                if(yorn()) incscore(-10);
                else return;
            }

            "It says, \"Not all black rods are magic wands. Some are
            useful for other cave construction purposes. There might
            be some around here.\"";
            self.isread := true;
        }
    }
;

/* 16 */
spelunker_today:  readable
    mass = 1
    sdesc = "recent issues of \"Spelunker Today\""
    adesc = { self.sdesc; }
    ldesc = { self.readdesc; }
    isThem = true 
    readdesc = {
        "I'm afraid the magazines are written in dwarvish. ";
        if (global.newgame) {
             self.isread := true;
             "However, two pictures attract %your% attention. ";
             if (SafeCombination.isseen) {
                 "One shows a dwarf sweeping the rock in the
                 Dusty Rock room, revealing the inscription. ";
             }
             else {
                 "One shows a dwarf brushing the
                 dust off a rock, revealing an inscription which looks like
                 a series of numbers - a date, perhaps? Unfortunately
                 you can't read them clearly. ";
             }
             if (Throne_Room.isseen) {
                 "Another picture shows the diminutive Mountain King
                 sitting on his throne, wearing his little crown and
                 holding a black rod with a shiny star on an end. ";
             }
             else {
                 "Another picture shows
                 a king sitting on a large, intricately-wrought throne.
                 He wears a heavy-looking crown, and he holds a long black
                 staff with a shiny metal star on one end.";
             }
        }
        self.read := true;
    }

    location = In_Anteroom
    plural = 'magazines'
    noun = 'magazine' 'issue' 'issue' 'spelunker'
        'today' 'dwarvish'
    adjective = 'spelunker' 'today' 'dwarvish'

    takepoints = 0

    depositpoints = 1

    targloc = At_Witts_End
    contloc = nil
    oldkeep = true // keep same targloc etc. in old game
;

/* 19 */
tasty_food:  fooditem
    mass = 2
    sdesc = "some tasty food"
    adesc = { self.sdesc; }
    thedesc = "the tasty food"
    ldesc = {
        if(global.newgame) {
        "It's your favorite - watercress sandwiches.  They might not
        be to everyone's taste, though.";
        }
        else {
        "Sure looks yummy! However, something in the back of your
        mind cautions you against eating it.  This is an Adventure
        game, and the food may be needed for something else!";
        }
    }
    location551 = Pantry
    location = Inside_Building
    noun = 'food' 'ration' 'rations' 'tripe'
    adjective = 'yummy' 'tasty' 'delicious' 'scrumptious'
;

/* 20 */
bottle: endgame_liquidcont
    // N.B. endgame_liquidcont is a subclass of liquidcont and is defined
    // in ccr-endg.t
    endgame_pile = bottle_pile   // for endgame
    mass = 1
    noun = 'bottle'
    plural = 'bottles'

    adjective = 'small'

    haswater = true

    contname = "bottle"
    sdescbase = "small bottle"
    emptydesc = "small empty bottle"
    pluraldesc = "empty bottles" // for endgame
    location551 = Pantry
    location = Inside_Building
    // Code for drinking wine from the container.  In the original
    // version, drinking wine from the bottle had the same effect as
    // drinking from the cask/fountain, which doesn't make sense in
    // view of the smaller quantity.
    winocode = {
        local toploc := toplocation(Me);
        local newloc,inv,o,i,l,newturns;
        "The wine goes to your head, and you feel very sleepy ...
        You awaken with a mild headache, and try to focus your
        eyes.... "; P();
        Me.health := (Me.health*90)/100;
        if (brass_lantern.turnsleft > 25 and brass_lantern.ison) {
            newturns := brass_lantern.turnsleft -
            rand(brass_lantern.turnsleft)/ 10;
            if (newturns < 25) newturns := 25;
            brass_lantern.setlife(newturns);
        }
    }

;

/* 28 */
axe:  weapon
    mass = 3
    nograb = nil    // hack for when you attack the bear etc. with it

    sdesc = "dwarf's axe"
    ldesc = {
        if (self.nograb) {
            if (Me.isIn(Bear.location))
                "It's lying beside the bear.";
            else if (Me.isIn(Dog.location))
                "It's lying beside the dog.";
            else if (Me.isIn(Wumpus.location))
                "It's lying beside the Wumpus.";
        }
        else {
            "It's just a little axe.  It may be useful to throw
            it in self-defence";
            if (global.oldgame and not global.game550)
                ". ";
            else
                ", and in the case of dwarves you
                might try using it for hand-to-hand combat. ";
        }
    }
    location = nil        // created when first dwarf attacks
    noun = 'axe' 'ax'     // DJP: added alternative US spelling
    adjective = 'little' 'dwarvish' 'dwarven' 'dwarf\'s'
    nosack = true        // Don't put into containers automatically
    verifyRemove(actor) = {
        if (self.nograb){
            "No chance.  It's lying beside the ";
            if (Me.isIn(Bear.location))
                "ferocious bear";
            else if (Me.isIn(Dog.location))
                "hideous black dog";
            else if (Me.isIn(Wumpus.location))
                "Wumpus";
            ", quite within harm's way.";}
        else pass verifyRemove;
    }
    // DJP.     Stop the dwarves from attacking after the axe is taken
    // (in the original, they wouldn't attack after any object was
    // taken).
    doTake(actor) = {
        Dwarves.noattack := true;
        pass doTake;
    }
;

/* 39 */
/* DJP - we now create the batteries dynamically, and in principle
we could have as many sets as we liked. In practice, it's limited by
the number of coinitem objects in the game. */

compoundWord 'sets' 'of' 'sets-of';
compoundWord 'sets-of' 'batteries' 'sets-of-batteries';
compoundWord 'sets-of' 'fresh' 'sets-of-fresh';
compoundWord 'sets-of-fresh' 'batteries' 'sets-of-fresh-batteries';
class fresh_batteries: item
    mass = 3
    isEquivalent = true
    sdesc = "set of fresh batteries"
    pluraldesc = "sets of fresh batteries"
    ldesc = {
        "They look like ordinary batteries.  A sepulchral
        voice says, \"Still going!\"";
    }
    noun = 'set' 'batteries' 'battery' 'duracel' 'duracell' 'duracels'
        'duracells' 'energizer' 'energizers' 'everready'
        'everreadies' 'eveready' 'evereadies'
    adjective = 'fresh'
    plural = 'sets' 'batteries' 'sets-of-batteries'
        'sets-of-fresh-batteries'
    // available is now evaluated automatically at the preinit stage as
    // a count of the coinitem objects.
    used = 0 // number of sets we have used (goes up by 1 whenever
             // batteries are changed)
    obtained = 0 //number of sets we have obtained - increased by 1 when
                 // a new set is obtained)
    location = Dead_End_14
    construct = {
        inherited.construct;
        self.moved := nil;
        fresh_batteries.obtained++;
    }
    destruct = {
        inherited.destruct;
        fresh_batteries.used++;
    }
    verDoTakeOut(actor,io) = {
        if(io = brass_lantern) {
            "To replace the batteries in the lamp, do
            PUT BATTERIES IN LAMP or CHANGE BATTERIES. ";
        }
        else pass verDoTakeOut;
    }
    verDoChange(actor) = {self.verDoReplace(actor);}
    doChange(actor) = {self.doReplace(actor);}
    verDoReplace(actor) = {
        if(not brass_lantern.isVisible(actor) or not
        brass_lantern.isReachable(actor))
            "You can't do that unless the lamp is at hand. ";
        else if (brass_lantern.turnsleft > 30 ) {
            "There's still life left in your batteries - I
            wouldn't change them until your lamp starts to
            grow dim. ";
        }
    }
    doReplace(actor) = {
        local waslit := actor.location.islit;
        brass_lantern.do_replace(self);
        "Done. ";
        /* DJP - check whether the lamp has just lit the room and
        print the room description if appropriate. */
        if (actor.location.islit and not waslit) {
            "\n";
            actor.location.enterRoom(actor);
        }
    }
;

compoundWord 'worn' 'out' 'worn-out'; // DJP - kludge to avoid problems with
                      // actor, out.
compoundWord 'sets' 'of' 'sets-of';
compoundWord 'sets-of' 'batteries' 'sets-of-batteries';
compoundWord 'sets-of' 'worn-out' 'sets-of-worn-out';
compoundWord 'sets-of' 'dead' 'sets-of-worn-out';
compoundWord 'sets-of' 'dry' 'sets-of-worn-out';
compoundWord 'sets-of' 'old' 'sets-of-worn-out';
compoundWord 'sets-of' 'flat' 'sets-of-worn-out';
compoundWord 'sets-of-worn-out' 'batteries' 'sets-of-worn-out-batteries';

class old_batteries: item
    mass = 3
    sdesc = "set of worn-out batteries"
    pluraldesc = "sets of worn-out batteries"
    isEquivalent = true
    ldesc = {
        "They look like ordinary batteries.  A sepulchral voice
        says: \"They're now useless.\" ";
    }
    noun = 'set' 'batteries' 'battery' 'duracel' 'duracell' 'duracels'
        'duracells' 'energizer' 'energizers' 'everready'
        'everreadies' 'eveready' 'evereadies'
    plural = 'sets' 'batteries' 'sets-of-batteries'
        'sets-of-worn-out-batteries'
    adjective = 'worn-out' 'dead' 'dry' 'old' 'flat'
        'discharged'
    location = nil
    verDoTakeOut(actor,io) = {
        if(io = brass_lantern) {
            "To replace the batteries in the lamp, do
            PUT BATTERIES IN LAMP. ";
        }
        else pass verDoTakeOut;
    }
    // DJP - added so that disambiguator will choose good batteries
    // automatically
    verDoPutIn(actor,dobj) = {
        if(dobj <> brass_lantern) pass verDoPutIn;
        else
            "Those batteries are dead; they won't
            do any good at all.";
    }
    verDoChange(actor) = {self.verDoReplace(actor);}
    doChange(actor) = {self.doReplace(actor);}
    // similarly, ensure that 'change batteries' chooses the right
    // set without any prompting.
    verDoReplace(actor) = {
        if(not brass_lantern.isVisible(actor) or not
        brass_lantern.isReachable(actor) or not (actor.location.islit
        or brass_lantern.isIn(actor)))
            "You can't do that unless the lamp is at hand. ";
        else
            "Those batteries are dead; they won't
            do any good at all.";
    }
;


/* The following objects will need to be multiplied now.  There will be
   nine: three types of liquid in three containers. A special class will
   be defined.*/

class contliquid: fixeditem, floatingItem
    locationOK = true    // tell compiler OK for location to be method
//    mycont = bottle         - must define as the container to hold the
//                   liquid
//    myflag = &haswater   - container flag to indicate presence of
//                   the liquid

    location = {
        if (self.mycont.(self.myflag))
            return self.mycont;
        else
            return nil;
    }

    verDoTake (actor) = {self.mycont.verDoTake (actor);}
    doTake (actor) = {self.mycont.doTake (actor);}

    verDoDrop (actor) = {self.mycont.verDoDrop (actor);}
    doDrop (actor) = {self.mycont.doDrop (actor);}

    verDoPourOn(actor, io) = {}
    doPourOn(actor, io) = { self.mycont.doPourOn(actor, io); }

    verDoDrink(actor) = { self.mycont.verDoDrink(actor); }
    doDrink(actor) = { self.mycont.doDrink(actor); }

    verDoGiveTo(actor,io) = { self.mycont.verDoGiveTo(actor,io); }

/* Verification methods for throwing refer to the container.  If the indirect
   object allows the liquid to be thrown, special code may be required to
   throw the container instead, or to empty it. */

    verDoThrowAt(actor,io) = { self.mycont.verDoThrowAt(actor,io);}
    verDoThrowTo(actor,io) = { self.mycont.verDoThrowTo(actor,io);}

    verDoPutIn(actor,io) = {}
/* This method is only called by ordinary containers - not by containers
   for liquids which only use ioPutIn. */
    doPutIn(actor, io) = {
        caps(); io.thedesc; " would leak all over the
        place if %you% tried to carry liquids in it. ";
    }
    verIoFillWith(actor) = {}
    ioFillWith(actor,dobj) = {dobj.ioPutIn(actor, self);}
/*  in case there is any rogue code which tries to move the liquid, the
    moveInto method will move the container instead */
    moveInto(loc) = {self.mycont.moveInto(loc);}
/*  verifyRemove now checks the container */
    verifyRemove(actor) = {self.mycont.verifyRemove(actor);}

;



/* 81 */
water_in_the_bottle: contliquid
    mycont = bottle
    myflag = &haswater

    sdesc = "water in the bottle"
    adesc = "water"
    ldesc = "It looks like ordinary water to me."
    thedesc = "the bottled water"
    adjective = 'bottled' 'water'
    noun = 'water'
;
/* 83 */
oil_in_the_bottle: contliquid
    mycont = bottle
    myflag = &hasoil

    sdesc = "oil in the bottle"
    adesc = "oil"
    ldesc = "It looks like ordinary oil to me."
    thedesc = "the bottled oil"
    adjective = 'bottled' 'oil'
    noun = 'oil'

;

/* 85 */
wine_in_the_bottle: contliquid
    game551 = true
    mycont = bottle
    myflag = &haswine

    sdesc = "wine in the bottle"
    adesc = "wine"
    ldesc = "It's a small quantity of sparkling vintage wine.  In a
        larger container it would be valuable."
    thedesc = "the bottled wine"
    adjective = 'bottled' 'wine'
    noun = 'wine'

;


/* 101 */
little_bird: endgame_clone, feedable // DJP - coding reworked for endgame.
    endgame_pile = wicker_cage_row
    mass = 2
    sdesc = {
        local loctype := self.location;
        if(loctype) {
            if(loctype.objclass) loctype := loctype.objclass;
        }
        if (loctype <> wicker_cage)
            "cheerful ";

        "little bird";
    }
    ldesc = {
        local loctype := self.location;
        if(loctype) {
            if(loctype.objclass) loctype := loctype.objclass;
        }
        if (loctype = wicker_cage)
            "The little bird looks unhappy in the cage.";
        else
            "The cheerful little bird is sitting here singing.";
    }
    pluraldesc = "little birds"
    location = In_Bird_Chamber
    noun = 'bird'
    plural = 'birds'
    adjective = 'cheerful' 'happy' 'singing'

    // ATTACKING
    verDoAttackWith(actor,dobj) = {
        if (dobj <> Hands) pass verDoAttackWith;
    }
    doAttackWith(actor,dobj) = {self.doAttack(actor);}
    verDoAttack(actor) = {
        if (self.isIn(wicker_cage) or self.location.objclass = wicker_cage)
            "Oh, leave the poor unhappy bird alone.";
    }
    doAttack(actor) = {
        "The little bird is now dead.  Its body disappears.";
        self.moveInto(nil);
    }

    // KICKING, THROWING not implemented

    // GIVING
    verIoGiveTo(actor) = {
        "I suspect it would prefer bird seed.";
    }

    // FEEDING

    verDoFeed(actor) = {}
    doFeed(actor) = {
        "It's not hungry. (It's merely pinin' for the fjords).
         Besides, %you% have no bird seed.";
    }
    doFeedWith(actor,io) = {
        self.doFeed(actor);
    }

    verDoTake(actor) = {
        local outhideStatus;
        if (self.isIn(Me)) {
            "%You% already %have% the little bird.    If
            you take it out of the cage it will likely
            fly away from you.";
        }
        else if (wicker_cage.firstcage(actor)) {
            outhideStatus := outhide(true);
            self.verDoPutIn(actor,wicker_cage.firstcage(actor));
            if (outhide(outhideStatus)) // verification failed - do again
                 self.verDoPutIn(actor,wicker_cage.firstcage(actor));
            else // pass control to the default method
                 pass verDoTake;
        }
    }
/* flag to stop 'put in' from trying to do an implied 'take' - this could
   cause a loop */
    noImpliedTake = true
    doTake(actor) = {
        if(wicker_cage.firstcage(actor))
            self.doPutIn(actor,wicker_cage.firstcage(actor));
        // actor isn't holding any cage(s) at all
        else if (wicker_cage.loccount(actor) = 0)
            "%You% can catch the bird, but %you% cannot carry it.";
        // actor is holding one or more occupied cages.
        else
            "You have no empty cage in which to carry the bird.";
    }
    doPutIn(actor,io) = {
    /*
     * Catch any attempt to remove the bird.  It won't cooperate
     * if a rod is visible in the room (551-point version etc.)
     * or is carried by the player (350-point version).  In the endgame we
     * now check for star-rods held by the player.  The 701+ point game has
     * a gray rod which should have exactly the same effects and the black
     * one, except when it is spun at the Green-level fissure.
     */
        local rodcond := true;
        if (global.oldgame and black_rod.isIn(actor))
            rodcond := nil;
        if (global.oldgame and gray_rod.isIn(actor))
            rodcond := nil;
        else if(global.newgame and black_rod.isVisible(actor))
            rodcond := nil;
        else if(global.newgame and gray_rod.isVisible(actor))
            rodcond := nil;
        else if (black_rod.loccountin(actor))
            rodcond := nil;
        else if (gray_rod.isIn(actor))
            rodcond := nil;

        if (not rodcond) {
            "The bird was unafraid when %you% entered, but
            as %you% approach%es% it becomes disturbed and you
            cannot catch it.";
        }
        else
            pass doPutIn;
    }

    // identify lots of reasons to reject the action.  This is all
    // very complex now that there are multiple cages.
    verDoPutIn(actor, io) = {
        local loc1 := self.location;
        local loc2 := io;
        if (loc1) {
            if(loc1.objclass)loc1 := loc1.objclass;
        }
        if (loc2) {
            if(loc2.objclass)loc2 := loc2.objclass;
        }
        // Container not a birdcage or room?
        if (loc2 <> wicker_cage and not isclass(loc2,room)) {
            "Don't put the poor bird in "; io.thedesc; "! ";
        }
        // Bird already in the cage in question?
        else if (io = self.location) {
            "The bird is already in the cage! ";
        }
        // (endgame) Bird is already in a cage
        else if (loc1 = wicker_cage and loc2 = wicker_cage) {
            "The bird is already in a cage! ";
        }
        // (endgame) Cage is already in use
        else if (loc2 = wicker_cage and itemcnt(io.contents) > 0) {
            "There's already a bird in the cage. ";
        }
        else pass verDoPutIn;
    }

    verDoDrop(actor) = { // DJP - this is used for both 'drop' and 'release'
                         // and therefore the action is OK if the bird is
                         // held by the player, or is in a cage.
        local loc;
        loc := self.location;
        if (loc) {
            if (loc.objclass) loc := loc.objclass;
        }
        if (self.isIn(actor)) return;
        else if (loc = wicker_cage) return;
        else "%You're% not carrying <<self.thedesc>>. ";
    }
    doDrop(actor) = {
        if (self.isIn(Snake.location)) {
            "The little bird attacks the green snake, and
            in an astounding flurry drives the snake
            away.";

            self.moveInto(Snake.location);
            Snake.moveInto(nil);
        }
        else if (self.isIn(Dragon.location)) {
            "The little bird attacks the green dragon,
            and in an astounding flurry gets burnt to a
            cinder.  The ashes blow away.";

            self.moveInto(nil);
        }
        else if (self.isIn(Snakepit.location)) { //endgame
            "The little bird attacks the green snakes, and in an astounding 
            flurry chases the snakes away.  Some of them escape into the 
            Treasure Vault, but others head towards the north-eastern end of 
            the room where the dwarves are sleeping ... \n";
            end_dwarves();
        }
        else
            "You release the bird. ";
            global.dropsilent := true;
            inherited.doDrop(actor);
            global.dropsilent := nil;
    }

    doTakeOut(actor, io) = {
        // Drop ourselves automatically.  (The bird flies away
        // when taken out of a container.)
        self.doDrop(actor);
    }
    moveInto(loc) = {
        // if the bird is being moved to or from a cage, we
        // adjust the vocabulary of the cage and bird.
        local loc1 := self.location;
        local loc2 := loc;
        if (loc1) {
            if(loc1.objclass)loc1 := loc1.objclass;
        }
        if (loc2) {
            if(loc2.objclass)loc2 := loc2.objclass;
        }
        if (loc1 = wicker_cage) {
            self.emptyvocab;
            self.location.emptyvocab;
        }
        if (loc2 = wicker_cage) {
            self.fullvocab;
            loc.fullvocab;
        }
        pass moveInto;
    }
    emptyvocab = {
        addword(self,&adjective,'cheerful');
        addword(self,&adjective,'happy');
        addword(self,&adjective,'singing');
        delword(self,&adjective,'unhappy');
        delword(self,&adjective,'sulking');
    }
    fullvocab = {
        delword(self,&adjective,'cheerful');
        delword(self,&adjective,'happy');
        delword(self,&adjective,'singing');
        addword(self,&adjective,'unhappy');
        addword(self,&adjective,'sulking'); 
    }
    listendesc = {
        if (self.location = wicker_cage or
        self.location.objclass = wicker_cage)
        "The little bird is sulking silently in its cage. ";
        else
        "The little bird is singing sweetly. ";
    }
    verDoRub(actor) = {
        local rodcond := true;
        if(self.location = wicker_cage or self.location.objclass = wicker_cage)
            return;
        else {
            if (global.oldgame and black_rod.isIn(actor))
                rodcond := nil;
            else if(global.newgame and black_rod.isVisible(actor))
                rodcond := nil;
            else if (black_rod.loccountin(actor))
                rodcond := nil;
    
            if (not rodcond) {
                "The bird was unafraid when %you% entered, but
                as %you% approach%es% it becomes disturbed and flies
                away from you.";
            }   
        }
    }
    verDoTouch(actor) = {
        self.verDoRub(actor);
    }
    doTouch(actor) = {
        inherited.verDoTouch(actor);
    }
    verDoSmell(actor) = {
        self.verDoRub(actor);
    }
;

/* 102 */

set_of_keys:  clothingItem, keyItem,  qsurface
    mass = 1
//
// Changed to define 'key' as an adjective.  Thus set_of_keys can only be
// referred to as a 'key' if no single key is also present. 
//
// This object is itself a key, but also acts as a container for loose keys
// which can be attached or detached.  The keyring can be worn if a wearable
// key is attached (e.g. the steel key).
//
    sdesc = "set of keys"
    ldesc = {
        "It's a normal-looking keyring, to which several keys are
        attached";
        if (itemcnt(self.contents) = 0) {
            ". ";
        }
        else {
            ", including ";listcont(self);". ";
        }
    }
    location551 = Pantry
    location = Inside_Building
    noun = 'set' 'keyring' 'key-ring' 'ring'
    adjective = 'key'  // usable only if no single key is present
    iswearable = nil   // not wearable until we add a wearable key
    verDoWear(actor) = {
        if(not self.iswearable)
             inherited thing.verDoWear(actor);
        else // exclude this item if it is already worn
             inherited clothingItem.verDoWear(actor); 
    }
    verIoPutOn(actor) = {}
    verIoAttachTo(actor) = {}
    verDoTakeOut(actor,io) = {
        if (io = self) {
            "I respectfully suggest that you leave the keys on the ring. ";
        }
        else
        pass verDoTakeOut;
    }
    ioPutOn(actor,dobj) = {
        if(dobj.isIn(self)) {
            caps(); dobj.thedesc; " is already on the ring. ";
        }
        else if(dobj = self) {
            "You can't put <<dobj.thedesc>> on itself! ";
        }
        else if(isclass(dobj,keyItem)) {
            local wasworn := dobj.isworn;
            dobj.moveInto(self);
            if(isclass(dobj,clothingItem)) self.iswearable := true;
            "You add <<dobj.thedesc>> to the keyring. ";
            if (wasworn and (self.location = actor)) self.isworn := true;
        }
        else
            "You could only attach keys to the keyring. ";
    }
    ioAttachTo(actor,dobj) = {
        self.ioPutOn(actor,dobj);
    }
    verIoDetachFrom(actor) = {}
    ioDetachFrom(actor,dobj) = {
        local outhideStatus;
        // Check the location of the key
        if (not dobj.isIn(self)) {
            caps(); dobj.thedesc; " is not attached to the keyring. ";
            return;
        }
        // Silently check the verDoDetach method.
        outhideStatus := outhide(true);
        dobj.verDoDetach(actor);
        // If verification failed, print the message and exit.
        if (outhide(outhideStatus)) {
            dobj.verDoDetach(actor);
            return;
        }
        dobj.doDetach(actor);
        if (clothingItem.classcount(self) = 0) {
             self.isworn := nil;
             self.iswearable := nil;
        }
    }
    doCount(actor) = {
        "There are about half a dozen keys on the ring";
        if (itemcnt(self.contents))
            ", plus the keys which you have attached. ";
        else
            ". ";
    }
    // If the key ring contains the appropriate key for the
    // object being locked or unlocked, use that key instead.
    ioUnlockWith(actor,dobj) = {
        if(dobj.mykey and dobj.mykey <> self) {
             if(dobj.mykey.isIn(self)) {
                  "(using <<dobj.mykey.thedesc>>)\n";
                  dobj.doUnlockWith(actor, dobj.mykey);
                  return;
             }
        }
        pass ioUnlockWith;
    }
    ioLockWith(actor,dobj) = {
        if(dobj.mykey and dobj.mykey <> self) {
             if(dobj.mykey.isIn(self)) {
                  "(using <<dobj.mykey.thedesc>>)\n";
                  dobj.doLockWith(actor, dobj.mykey);
                  return;
             }
        }
        pass ioLockWith;
    }
;

// A special object representing the available keys at a location.  Only 
// referenced by special methods.  It is defined as a class to ensure that
// it won't be found by a reference to 'keys', and won't appear in a 
// sequence generated by the firstobj() and nextobj() functions.

class available_keys: keyItem, floatingItem
    // Dummy object to try all the available keys for an object.
    isReachable(actor) = true
    isVisible(actor) = true
    list = {
        local i, loclist := [];
        local actor := getActor(&verbActor);
        for (i := firstobj(keyItem); i; i := nextobj(i, keyItem)) {
            // Only select reachable and visible keys
            if(i.isReachable(actor) and i.isVisible(actor)) {
                // silently check the verification method for
                // unlocking with the key (in case there is a special check)
                outhideStatus := outhide(true);
                self.verIoLockWith(actor);
                // if the verification produced no output, add the
                // key to the list.
                if (not outhide(outhideStatus))
                    loclist += i;
            }
        }
        return loclist;
    }
    sdesc = "keys available at your location"
    adesc = {self.sdesc;}
    isThem = true
    ioUnlockWith(actor,dobj) = {
        if(dobj.mykey and find (self.list,dobj.mykey)) {
             "(using <<dobj.mykey.thedesc>>)\n";
             dobj.mykey.ioUnlockWith(actor, dobj);
             return;
        }
        pass ioUnlockWith;
    }
    ioLockWith(actor,dobj) = {
        if(dobj.mykey and find (self.list,dobj.mykey)) {
             "(using <<dobj.mykey.thedesc>>)\n";
             dobj.mykey.ioLockWith(actor, dobj);
             return;
        }
        pass ioLockWith;
    }
;

// A dummy key for any locked object with unobtainable keys.  Defined as
// a class (see available_keys)

class office_keys: keyItem
    location = nil
    verDoPurloin(actor) = {
        "You can't actually obtain this item. ";
    }
;

/*
 * Treasures from the original version.
 */
/* 50 */
large_gold_nugget: CCR_treasure_item
    mass = 6
    basis = 2
    olddepositpoints = 10
    targloc = treasure_chest

    sdesc = "large gold nugget"
    ldesc = "It's a large sparkling nugget of gold!"
    location = In_Nugget_Of_Gold_Room
    noun = 'gold' 'nugget'
    adjective = 'gold' 'large'

    islarge = true
;
/* 51 */
several_diamonds: CCR_treasure_item
    mass = 2
    basis = 2
    olddepositpoints = 10
    isThem = true

    sdesc = "several diamonds"
    adesc = { self.sdesc; }
    thedesc = "the diamonds"
    ldesc = "They look to be of the highest quality!"
    /* location moved in 551-point game */
    location551 = Hall_Of_Ice
    location = West_Side_Of_Fissure
    noun = 'diamond' 'diamonds'
    adjective = 'several' 'high' 'quality' 'high-quality'
;
/* 53 */
precious_jewelry: CCR_treasure_item
    mass = 2
    olddepositpoints = 10

    sdesc = "precious jewelry"
    adesc = { self.sdesc; }
    ldesc = "It's all quite exquisite!"
    location = In_South_Side_Chamber
    noun = 'jewel' 'jewels' 'jewelry'
    adjective = 'precious' 'exquisite'
;
/* 54 */
rare_coins: CCR_treasure_item, coinitem
    mass = 3
    basis = 5
    olddepositpoints = 10
    isThem = true

    sdesc = "rare coins"
    adesc = "some rare coins"
    ldesc = "They're a numismatist's dream!"
    location = In_West_Side_Chamber
    noun = 'coins'
    adjective = 'rare'
;
/* 55 */
treasure_chest: CCR_treasure_item, keyedLockable, picklock
    mass = 5
    basis = 5
    targloc = Inside_Building
    contloc = nil

    spotted = nil    // found yet?  See also Dead_End_13 in ccr-room.t
    sdesc = "treasure chest"
    ldesc = {
        if(global.oldgame) {
            "It's the pirate's treasure chest, completely filled
            with riches of all kinds! ";
        }
        else {
            "It's the pirate's treasure chest, partly filled with
            riches of all kinds.   There's plenty of room
            for anything else you might want to store in there. ";
        }
        if(global.newgame) {
            "At present it is ";
            if (self.isopen) 
                "open";
            else {
                "closed"; 
                if (self.islocked) 
                    " and locked";
                else 
                    " but unlocked";
            }
            ".\n";
        }
        if (self.isopen) {
            if(itemcnt (self.contents) > 0) {
                P(); "It contains ";listcont(self);
                ". ";
            }
        }
    }
    location = nil
    maxbulk = {if (global.newgame) return 500; else return 0;}
    noun = 'chest' 'box' 'treasure' 'lock'
    adjective = 'pirate' 'pirate\'s' 'treasure'

    doOpen(actor) = {
        inherited.doOpen(actor);
        self.seentreasures := true;
    }
    isopen = nil
    islocked = true
    // In the 'oldgame' versions, don't allow the chest to be unlocked.
    mykey = {
        if (global.oldgame) return office_keys;
        else return set_of_keys;
    }
    // In the 'oldgame' versions we issue an additional message to reassure
    // the player (based on the response to UNLOCK CHEST in Mike Arnautov's 
    // 770-point version.)
    misfit(io) = {
        inherited.misfit(io);
        if (global.oldgame)
            "Still, it is obviously full of fabulously valuable treasures, so 
            we'll allow you the points for just leaving it in the building. ";
    }
      
    ishuge = true
    nobird = true
    ioPutIn ( actor, dobj ) = {
        if(dobj.islong) {
            caps(); dobj.thedesc; " is too long to go into ";
            self.thedesc; ".  ";
        }
        else if(dobj.ishuge) {
            caps(); dobj.thedesc; " is too large to go into ";
            self.thedesc; ".  ";
        }
        else if((dobj = wicker_cage or dobj.objclass = wicker_cage)
        and length(dobj.contents) > 0){
            "Are you kidding?  %Do% %you% want to suffocate the poor bird?";
        }
        else pass ioPutIn;
    }
    // DJP - method to tell sack_of_holding and pirate code whether this
    // container is suitable for a particular object.
    accepts_item(dobj) = {
        if(global.oldgame) return nil;
        if(dobj.islong or dobj.ishuge) return nil;
        if((dobj = wicker_cage or dobj.objclass = wicker_cage) and
        length(dobj.contents) > 0) return nil;
        return true;
    }
    // Banish pirate if chest is purloined.
    doPurloin(actor) = {
        Pirates.loclist := [];
        unnotify(Pirates, &move);
        self.spotted := true;
        PirateMessage.moveInto(nil);
        pass doPurloin;
    }
    doUnlockWith(actor,io) = {
        local waslocked := self.islocked;
        inherited.doUnlockWith(actor,io);
        if (waslocked and not self.islocked) {
             self.isopen := true;
             "You open the chest, revealing ";listlist(self.contents);". ";
        }
    }
    doLockWith(actor,io) = {
        if(self.isopen) {
            "(closing <<self.thedesc>> first)\n";
            self.isopen := nil;
        }
        pass doLockWith;
    }
;

/* This item is purely cosmetic, and is included in the chest to make it look
valuable.  The original Fortran version of the 551-point game made it sound
like an empty box. */

pirates_treasure: fixeditem

    sdesc = "pirate's loot"
    adesc = {"the ";self.sdesc;}
    /* Description changed to make it clear that there are no coins which
       could be used to buy batteries.  The reference to 'strange items' 
       reflects a curious detail in the 550-point game - the pirate's 
       dinghy is to be found on an alien planet, with the implication that
       he found his treasures there!  (It should, however, be
       changed for the 660-point and 770-point games. In these versions the
       pirate's beach is on Earth and the alien beach is elsewhere.)
     */
    ldesc = {
        "It must be fabulously valuable.  You can see many strange items,
        some of which look quite unlike anything you saw before.  Unusually,
        however, there are no coins of any description.  "; P();
        if(global.oldgame)
            "The treasure fills the chest right up to the
            top - there's no room for anything else. ";
        else "The treasure partly fills the chest, leaving plenty
            of room for other items. ";
    }
    noun = 'booty' 'loot' 'riches'
    adjective = 'pirates' 'pirate\'s'
    isListed = true
    mass = 0  // included with chest
    bulk = 0    // included with chest
    location = treasure_chest

    verifyRemove(actor) = {"%You%'d best leave it in the chest
        - if %you% were to take it out, some items might get lost.";}

    verDoTake(actor) = {self.verifyRemove(actor);}
    verDoPutIn(actor,io) = {self.verDoTake(actor);}
    verDoPutOn(actor,io) = {self.verDoTake(actor);}

;
/* 56 */
golden_eggs: CCR_treasure_item
    mass = 4
    basis = 3
    olddepositpoints = 14

    sdesc = "nest of golden eggs"
    ldesc = "The nest is filled with beautiful golden eggs!"
    location = In_Giant_Room
    noun = 'eggs' 'egg' 'nest'
    adjective = 'golden' 'beautiful'
;
/* 57 */
trident: CCR_treasure_item
    mass = 3
    basis = 2
    olddepositpoints = 14
    targloc = treasure_chest

    sdesc = "jeweled trident"
    ldesc = "The trident is covered with fabulous jewels!"
    location551 = Blue_Grotto_East    // changed for 551-point version
    location = In_Cavern_With_Waterfall
    noun = 'trident'
    adjective = 'jeweled' 'jewel-encrusted' 'encrusted' 'fabulous'

    islarge = true

    verIoOpenWith(actor) = {}
    ioOpenWith(actor, dobj) = {
        dobj.doOpenWith(actor, self);
    }
;
/* 58 */
ming_vase: CCR_treasure_item, liquidcont
/* Actually it can't really hold liquids but we pretend that it does */
    mass = 2
    basis = 2
    olddepositpoints = 14

/* For full credit, the pillow puzzle must normally be solved! Putting the vase
   in the sack or chest is possible but won't do.  There is one exception - if
   we succeed in dropping the vase in the building without breaking it.  This
   should only be possible if the player gets killed in the building. */

    targloc = {
        if (self.location = Inside_Building) return self.location;
        else return velvet_pillow;
    }
    contloc = {
        if (self.location = Inside_Building) return nil;
        else pass contloc;
    }
    oldkeep = true    // keep same targloc etc. in all versions.
    sdesc = "ming vase"
    contname = "vase"
    sdescbase = "ming vase"
    emptydesc = "ming vase"

    adesc = {"a ";self.sdesc;}
    ldesc = {
        "It's a delicate, previous, ming vase!";
    }
    location = In_Oriental_Room
    noun = 'vase' 'pottery' //DJP removed 'shards'
    adjective = 'ming' // DJP ming made an adjective so 'ming vase' works

    /* Now changed to check the normal 'drop' location
    in case we're in a nested room, and to actually put the vase on
    the pillow! */

    doDrop(actor) = {
        local toproom := toplocation(actor);
        // in soft room, vase can simply be dropped safely on the
        // floor - DJP
        if (toproom.softfloor) pass doDrop;
        // or in any other room where the pillow is in the
        // normal location for dropping objects.  (However we exclude
        // the case where the player's room has the smashdrop property;
        // this is set when objects fall down to another room).
        else if (velvet_pillow.location = droploc(actor) and not
        toproom.smashdrop) {
            "The vase is now resting, delicately, on a
            velvet pillow.";
            self.moveInto(velvet_pillow);

        }
        // otherwise, vase shatters.
        else {
            "The ming vase drops with a delicate crash.";
            self.shatter;
        }
    }

    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        if (dobj = Sea_Water) {
            dobj.verDoTake(actor);
        }
        else if (isclass(dobj,roomliquid)) {
            "The sudden change in temperature has
            delicately shattered the vase.";
            self.shatter;
        }
        else if (not isclass(dobj,contliquid)){
            "The vase looks rather delicate.  It may break if
            %you% put%s% solid objects into it.";
        }
    }

    verDoFill(actor) = {}
    doFill(actor) = {
        local toploc := toplocation(actor);
        if (self.isIn(Sea_Water.location))
            Sea_Water.verDoTake(actor);
        else if (Streamitem.classfind(toploc)) // DJP
            self.ioPutIn(actor, Stream);
        else if (self.isIn(Oil.location))
            self.ioPutIn(actor, Oil);
        else if (self.isIn(Wine.location))
            self.ioPutIn(actor, Wine);
        else
            "There is nothing here with which to fill the
            vase.";
    }

    verDoBreak(actor) = {}
    doBreak(actor) = {
        "%You% %have% taken the vase and hurled it delicately to
        the ground.";

        self.shatter;
    }

    shatter = {
        self.moveInto(nil);
        shards.moveInto(droploc(parserGetMe()));
    }
;
/* 58 (after it's been broken)*/
shards: item
    mass = 2
    bulk = 3 // shards are hard to carry, except in a container
    sdesc = "some worthless shards of pottery"
    adesc = { self.sdesc; }
    ldesc = {
        "They're just worthless shards of pottery";

        if (self.location = Me.location)    // not in a container
            ", littered everywhere.";
        else
            ".";

        " They look to be the remains of what was once a
        beautiful vase.     I guess some oaf must have dropped it.";
    }

    noun = 'pottery' 'shards'
    adjective = 'worthless'
;

/* 59 */
egg_sized_emerald: CCR_treasure_item
    mass = 3
    basis = 3
    olddepositpoints = 14

    sdesc = "emerald the size of a plover's egg"
    adesc = { "an "; self.sdesc; }
    ldesc = "Plover's eggs, by the way, are quite large."
    location = In_Plover_Room
    noun = 'emerald'
    adjective = 'egg-sized'
;
/* 60 */
platinum_pyramid: CCR_treasure_item
    mass = 4
    basis = 4
    olddepositpoints = 14

    sdesc = "platinum pyramid"
    ldesc = "The platinum pyramid is 8 inches on a side!"
    location = In_Dark_Room
    noun = 'platinum' 'pyramid'
    adjective = 'platinum' 'pyramidal'
;
/* 61 */
pearl: CCR_treasure_item
    mass = 1
    basis = 4
    olddepositpoints = 14

    sdesc = "glistening pearl"
    ldesc = "It's incredibly large!"
    location = nil
    noun = 'pearl'
    adjective = 'glistening' 'incredible' 'incredibly' 'large'
;
/* 62 */
/* This is one of the most complicated objects in the game.  It can be
   carried, but it is also a nestedroom on which the player can sit, lie
   or stand. In the 580-point game it is also a means of transport. It also
   behaves like a vehicle when Transindection movements are made. */
persian_rug: portable_beditem, CCR_treasure_item
    mass = 3
    basis = 3
    olddepositpoints = 14
    targloc = Inside_Building
    contloc = nil
    // reachable from both sides of the dragon
    bothsides = (self.location = Dragon.location) 
    sdesc = {
        "Persian rug";

        if (self.isIn(Dragon.location))
            " (upon which the dragon is sprawled out)";
        if (self.isActive)
            " (which is floating in midair)";
    }
    adesc = {
        "a "; self.sdesc;
    }
    ldesc = {
        if (self.isIn(Dragon.location))
            "The dragon is sprawled out on the Persian rug!!";
        else if (not self.isIn(Me))
            "The Persian rug is spread out on the floor here.";
        else
            "The Persian rug is the finest %you've% ever seen!";
        if(self.isActive) " It is floating in midair!";
        if(itemcnt(self.contents) > 0) {
            P(); "On the rug, %you% see%s% ";
            listcont(self);". ";
        }
    }
    location = In_Secret_Canyon
    noun = 'rug' 'persian'
    adjective = 'persian' 'fine' 'finest' 'dragon\'s'
    ishuge = true // change from Fortran version which allowed you to
                  // store the rug safely in the chest, but only gave
                  // points for dropping it on the floor.  Now the
                  // rug is too big to go into containers and must be
                  // dropped on the floor.
    isdroploc = true // drop objects here not in outer room
    softfloor = {    // whether to allow a soft landing for the vase
       if (self.location) return self.location.softfloor;
       else return nil;
    }
    //
    // We want the player to be able to pick things in the
    // room up while sitting on the rug.
    reachable = {
        local toploc := toplocation(self);
        if (toploc = nil) toploc := self;
        return toploc.allcontents;
    }
    // This makes the contents of containers accessible as well:
    canReachContents = true

    verifyRemove(actor) = {
        local i,o;
        if (self.isIn(Dragon.location))
            "%You%'ll need to get the dragon to move first!";
        else if(self.isActive)
            "The rug floats away from you every time you try to grab it.";
        else if(itemcnt(self.contents) = 1) {
            for(i := 1;i <= length(self.contents);i++){
                o := self.contents[i];
                   if(o.isListed) break;
            }
            "%You%'d better remove ";o.thedesc;" first.";
        }
        else if(itemcnt(self.contents) > 1) {
            "There are objects on "; self.thedesc;".  %You%'d
            better remove them first.";
        }
        else pass verifyRemove;
    }
    say_posture = true // mention posture in room description
    verDoLieon(actor) = {
        if (self.isIn(Dragon.location)) {
            "That would be very unwise.  %You%'d better get the
            dragon to move first!";
        }
        else pass verDoLieon;
    }
    verDoSiton(actor) = {
        if (self.isIn(Dragon.location)) {
            "That would be very unwise.  %You%'d better get the
            dragon to move first!";
        }
        else pass verDoSiton;
    }
    verDoStandon(actor) =
    {
        if (self.isIn(Dragon.location)) {
            "That would be very unwise.  %You%'d better get the
            dragon to move first!";
        }
        else if ( actor.location = self and (actor.posture = 'standing'))
        {
            "%You're% already "; self.statusPrep; " ";
            self.thedesc; "! ";
        }
        else if (actor.isCarrying(self))
        {
            "%You%'ll have to drop <<thedesc>> first!";
        }
        else if (not isclass(self.location,room) and 
        isclass(self.location,surface))
        {
            "%You% can't do that while <<self.thedesc>> is 
            on <<self.location.adesc>>!";
        }
        else if (not isclass(self.location,room))
        {
            "%You% can't do that while <<self.thedesc>> is 
            in <<self.location.adesc>>!";
        }
    }
    doStandon(actor) = {
        "Okay, %you're% now standing "; 
        if (self.onroom) "on "; else "in "; 
        self.thedesc; ". ";
        actor.moveInto(self);
        actor.posture := 'standing';
    }
    verIoPutOn(actor) = {
        if (self.isIn(Dragon.location))
            "That would be very unwise.  %You%'d better get the
            dragon to move first!";
        else if (self.isIn(Me)){
            "%You% could at least drop the "; self.thedesc;
            " first! ";
        }
        else if (not isclass(self.location,room) and
        isclass(self.location,container)) {
            "%You% can't do that while "; self.thedesc;
            " is in a container.  ";
        }
        else pass verIoPutOn;
    }
    ioPutOn( actor, dobj ) = {
        if (self.checksmash(actor,dobj,onPrep,self))
        pass ioPutOn;
    }
    verDoRide(actor) = {
        if(self.isActive) self.verDoBoard(actor);
        else pass verDoRide;
    }
    doRide(actor) = {
        self.doBoard(actor);
    }
/* We can drop the rug in any room, so all the magic words should work */
    xyzzy = {return self.location.xyzzy;}
    phleece = {return self.location.phleece;}
    plugh = {return self.location.plugh;}
    plover = {return self.location.plover;}
    phuce = {return self.location.phuce;}
    pray = {return self.location.pray;}
    smichel = {return self.location.smichel;}
    reflect = {return self.location.reflect;}
    click = {return self.location.click;}
    thurb = {return self.location.thurb;}
    north = {return self.flymove(&fly_north);}
    east = {return self.flymove(&fly_east);}
    west = {return self.flymove(&fly_west);}
    south = {return self.flymove(&fly_south);}
    nw = {return self.flymove(&fly_nw);}
    sw = {return self.flymove(&fly_sw);}
    ne = {return self.flymove(&fly_ne);}
    se = {return self.flymove(&fly_se);}
    up = {return self.flymove(&fly_up);}
    down = {return self.flymove(&fly_down);}
            
    flying_check = {
        local actor := getActor(&verbActor);

        if (not global.game580) {
            "Only wizards can do that. ";
            return nil;
        }
        
        if (not (persian_rug.isVisible(actor) and persian_rug.isActive)){
            "I'm game.  Would you care to explain how?"; 
            return nil;
        }
        else if (not (actor.location = persian_rug)){
            "%You%'d better get on the rug first."; return nil;
        }
        else return true;
    }

    flymove(prop) = {
        local flydest, actor := getActor(&travelActor);

        if (self.isActive) {
            flydest := self.moveme(prop);
            if(flydest) return flydest;
            else {"%You% can't fly that way."; return nil;}
        }
        else {
            "%You%'d have to get off the rug first. ";
            return nil;
        }
    }
    verDoFly(actor) = {}
    doFly(actor) = {
        if (self.flying_check)
            "Just tell me which direction you want to fly!";
    }
    verDoFlyN(actor) = {}
    doFlyN(actor) = {if (self.flying_check){
        actor.travelTo(self,&north);}}
    verDoFlyS(actor) = {}
    doFlyS(actor) = {if (self.flying_check){
        actor.travelTo(self,&south);}}
    verDoFlyE(actor) = {}
    doFlyE(actor) = {if (self.flying_check){
        actor.travelTo(self,&east);}}
    verDoFlyW(actor) = {}
    doFlyW(actor) = {if (self.flying_check){
        actor.travelTo(self,&west);}}
    verDoFlyNW(actor) = {}
    doFlyNW(actor) = {if (self.flying_check){
        actor.travelTo(self,&nw);}}
    verDoFlyNE(actor) = {}
    doFlyNE(actor) = {if (self.flying_check){
        actor.travelTo(self,&ne);}}
    verDoFlySW(actor) = {}
    doFlySW(actor) = {if (self.flying_check){
        actor.travelTo(self,&sw);}}
    verDoFlySE(actor) = {}
    doFlySE(actor) = {if (self.flying_check){
        actor.travelTo(self,&se);}}

;
/* 63 */
rare_spices: CCR_treasure_item
    mass = 1
    olddepositpoints = 14

    sdesc = "rare spices"
    adesc = { self.sdesc; }
    ldesc = "They smell wonderfully exotic!"
    location = In_Chamber_Of_Boulders
    noun = 'spices' 'spice'
    adjective = 'rare' 'exotic'

    verDoSmell(actor) = {}
    doSmell(actor) = { self.ldesc; }
;
/* 64 */
golden_chain: CCR_treasure_item, keyedLockable
    mass = 3
    basis = 4
    olddepositpoints = 14

    isfixed = {
        if (self.islocked)
            return true;
        else
            return nil;
    }
    isListed = { return not self.isfixed; }

    mykey = set_of_keys    // pretty handy, those!
    islocked = true        // locked meaning "locked to the wall."
    isopen = nil        // need this since we're keyedLockable

    sdesc = "golden chain"
    ldesc = {
        "The chain has thick links of solid gold!";

        if (self.islocked) {
            if (Bear.wasreleased)
                "It's locked to the wall!";
            else
                " The bear is chained to the wall with it!";
        }
    }
    heredesc = {
        if (self.isfixed) {
            P(); I();
            if (Bear.wasreleased)
                "There is a golden chain here, locked
                to the wall.";
            else
                "There is a golden chain here, and a
                large cave bear is locked to the wall
                with it!";
        }
    }

    location = In_Barren_Room
    noun = 'chain' 'links' 'shackles'
    adjective = 'solid' 'gold' 'golden' 'thick'

    verDoLock(actor) = {
        if (not self.isIn(In_Barren_Room)) {
            "There is nothing here to which the chain can
            be locked.";
        }
        else
            pass verDoLock;
    }
    verDoLockWith(actor, io) = {
        self.verDoLock(actor);    // -> pass verDoLock (OK?)
        pass verDoLockWith;
    }

    verDoUnlock(actor) = {
        if (not Bear.wasreleased and not Bear.istame) {
            "There is no way to get past the bear to
            unlock the chain, which is probably just as
            well.";
        }
        else
            pass verDoUnlock;
    }
    verDoUnlockWith(actor, io) = {
        self.verDoUnlock(actor);
        pass verDoUnlockWith;
    }

    // inherit proper doUnlock from keyedLockable
    doUnlockWith(actor, io) = {
        Bear.wasreleased := true;
        pass doUnlockWith;
    }

    verifyRemove(actor) = {
        if (not Bear.wasreleased) {
            if (Bear.istame)
                "It's locked to the friendly bear.";
            else
                "It's locked to the ferocious bear!";
        }
        else if (self.islocked)
            "The chain is still locked to the wall.";
    }
;

bars_of_silver: CCR_treasure_item
    game350 = true    // Note that this implies game550 by default
    olddepositpoints = 10
    sdesc = "bars of silver"
    adesc = { self.sdesc; }
    ldesc = "They're probably worth a fortune!"
    location = Low_N_S_Passage
    noun = 'silver' 'bars'
    adjective = 'silver'
;
