#include <adv3.h>
#include <en_us.h>

#include "SayQuery/SayQuery.h"


tiana: Person
    vocabWords = 'red-haired short red haired hair redhaired redhead 
        red-head head girl/tiana/t'
    
    /* 
     *   Having Tiana constantly referred to as "the red-haired girl that 
     *   you can't remember the name of" is really starting to get on my 
     *   nerves. The joke wore thin several years ago. So just use the long 
     *   form the first time her name is printed, and after that call her 
     *   "the red-haired girl".
     */
    nameCount = 0
    name()
    {
        if (nameCount == 0)
        {
            nameCount++;
            return 'red-haired girl that you can\'t remember the name of';
        }
        else
        {
            return 'red-haired girl';
        }
    }
    
    
    /* 
     *   Often in the endings I want to use Tiana's real name, and if the PC 
     *   hasn't learnt it yet, I need to indicate what's going on.
     */
    learnNameInPassing()
    {
        if (isProperName)
        {
            return '';
        }
        else
        {
            learnName();
            return '--- that\'s the red-haired girl\'s name, Tiana ---';
        }
    }
    
    
    location = lawnWest
    
    desc()
    {
        "<<isProperName ? 'Tiana' : 'The girl'>> seems to be pretty quiet. She 
        has short red hair and freckles and is wearing faded jeans and a bright 
        pink jumper. The jumper looks a bit funny with her hair. Right now 
        she's ";
        
        /* mention what she's doing */
        reportActivity(true);
        ".";
        
        /* mention not being able to remember her name if it's not yet known */
        if (!isProperName)
        {
            "<.p>Emma did say what her name was, but you can't remember. It 
            was something that started with T, like Tahlia. ";
        }
    }
    
    aName = (theName)
    globalParamName = 'tiana'
    
    
    /* Later in the game the player may learn her name. */
    learnName() 
    {
        /* set her printed name to Tiana */
        name = 'Tiana';
        isProperName = true;
        
        /* get rid of the "wrong name" Unthing */
        tianaWrongName.removeFromPlay();
    }
    
    /* 
     *   How Tiana is described in the room description varies depending on 
     *   what she's doing at the time.
     */
    specialDesc()
    {
        if (counting.active_ && !gPlayerChar.isCheating && 
            counting.countedTo == 50)
        {
            /* 
             *   When the counting scene is just about to end and the PC 
             *   isn't cheating, say that she's looking around. (The default 
             *   would say that she's counting, but - nominally - she's 
             *   finished doing that.)
             */
            "{The tiana/she} looks around, blinking in the bright sunlight. ";
        }
        else
        {
            "{The tiana/she} is <<reportActivity(true)>>. ";
        }
    }
    
    remoteSpecialDesc(actor)
    {
        if (lastActionWasInteresting())
            "{The tiana/she} is <<location.actorInName>>, <<reportActivity(nil)>>. ";
        else
            "{The tiana/she} is <<reportActivity(true)>>. ";
    }
    
    /* Choose and remember a pathway for Tiana to take. */
    calcPathToHidingSpot()
    {
        local path;

        if (gPlayerChar.isIn(lawnEast) || gPlayerChar.isIn(lotsaBushes))
        {
            /* 
             *   If the PC or Yvonne went northwest, Tiana will have to go 
             *   around the front of the house. (This can only happen if the PC 
             *   is cheating.)
             */
            path = pathFrontOfHouse;
        }
        else
        {
            /* Normally, Tiana goes behind the shed. */
            path = pathBehindShed;
        }
        
        pathToHidingSpot = path;
        return path;
    }
    
    
    /* Start counting for Hide and Seek */
    startHnSCounting()
    {
        /* set the ActorState */
        setCurState(tianaHnSCounting);
        
        /* set her current action */
        lastAction = CountAction.createActionInstance();
    }
    
    
    /* When Tiana is counting, she can't see anything. */
    canSee(obj)
    {
        if (curState == tianaHnSCounting)
            return nil;
        
        return inherited(obj);
    }
    
    
    /* 
     *   Attacking Tiana ends the story. Also, it is really mean and totally 
     *   unprovoked.
     */
    dobjFor(Attack)
    {
        action()
        {
            inherited();
            "You lunge at {the Tiana/her}. Startled, she stumbles backwards. When 
            you make another movement towards her, she screams and runs away into
            the house.<.p>
            A bit later, Mum comes out and makes you apologise to Tiana
            <<learnNameInPassing>> and then takes you home where you can't do 
            any more damage. ";
            endGame('You are in big trouble');
        }
    }
    
    dobjFor(Hug)
    {
        action()
        {
            if (isPlayingHnS)
            {
                "{The tiana/she} grins and gives you an enthusiastic hug in
                return, almost knocking you over. ";
                
                /* This counts as Tiana taking an action for this turn. */
                nextRunTime++;
            }
            else
            {
                "{The tiana/she} wriggles out of your hug as quickly as possible
                and moves away from you a bit. ";
            }
        }
    }
    
    /*
     *   Tiana is departing locally (staying within view throughout
     *   the travel, and moving further away from the PC) 
     */
    sayDepartingLocally(dest, conn)
    {
        /* get the travel direction */
        local dir = getDirection(location, dest);
        
        "\^<<travelerName(nil)>> wanders off <<dir.name>> to 
        <<dest.destName>>. ";
    }

    /*
     *   Tiana is traveling remotely (staying within view through the
     *   travel, and moving from one remote top-level location to another) 
     */
    sayTravelingRemotely(dest, conn)
    {
        /* get the direction */
        local loc = lastTravelBack.getDestination(location, self);
        local dir = getDirection(loc, dest);
        
        if (isCheating)
            "\^<<travelerName(nil)>> heads <<dir.name>> from
            <<loc.theName>> to <<travelerLocName>>. ";
        else
            "\^<<travelerName(nil)>> gives up on <<loc.theName>>
            and wanders <<dir.name>> to <<travelerLocName>>. ";
    }

    /* Tiana is leaving in a given compass direction */
    sayDepartingDir(dir, conn)
    {
        local nm = travelerRemoteLocName;
        
        if (isCheating)
            "\^<<travelerName(nil)>> <<verbToLeave>> 
            <<nm != '' ? ' from ' + nm : ''>> to the <<dir.name>>. ";
        else
            "\^<<travelerName(nil)>> <<nm != '' ? ' gives up on ' + nm + 
              ' and' : ''>> wanders off to the <<dir.name>>. ";
    }

    /* Tiana is arriving from a compass direction */
    sayArrivingDir(dir, conn)
    {
        "\^<<travelerName(true)>> wanders into 
        <<travelerRemoteLocName>> from the <<dir.name>>. ";
    }
    
    /* Tiana is arriving via the path. */
    sayArrivingViaPath (conn)
    {
        "\^<<travelerName(true)>> wanders up <<conn.theName>> from 
        <<conn.getDestination(location, conn).theName>>. ";
    }
    
    
    dobjFor(PlayWith)
    {
        action()
        {
            /* 
             *   If asking Tiana about hide and seek, let's just assume that 
             *   the player (and by extension the PC) know that Tiana 
             *   prefers Hide and Seek to Sardines.
             */
            if (gTopic.getBestMatch == tHnS)
            {
                gPlayerChar.knowsTianaPrefersHnS = true;
            }
            
            inherited();
        }
    }
    
    
    
    /* 
     *   If the PC tells Tiana to COUNT or HIDE in response to her 
     *   count-or-hide question, she goes along with it.
     */
    obeyCommand(issuingActor, action)
    {
        if (curConvNode == tianaCountOrHide && 
            (action.actionOfKind(CountAction) || 
             action.actionOfKind(HideAction)))
        {
            return true;
        }
        
        return inherited(issuingActor, action);
    }
;



/* Default refusal to obey commands. */
+ DefaultCommandTopic
    "{The tiana/she} screws up her nose and says, <q>I don\'t really want 
    to.</q> "
;

++ AltTopic
    "{The tiana/she} just keeps counting. Maybe she didn't hear you. "
    
    isActive = (tiana.curState == tianaSCounting)
;



/* Tiana's AgendaItems */
+ HideAgendaItem;
+ SearchAgendaItem;
+ MoveAgendaItem;



/* normal conversation with Tiana */

/* Telling her about the bird */
+ AskTellGiveShowTopic [babyBird, nest, tBirds]
    topicResponse()
    {
        "<q><<tiana.isProperName ? 'Tiana' : 'Hey'>>!</q> you  
        <<gPlayerChar.isIn(upTree) ? 'call down' : 'say'>>. <q>Guess
        what I found!</q><.p>
        {The tiana/she} looks up. <q>What?</q><.p>
        <q>A baby bird in a nest! Come look.</q><.p>
        <<tiana.isProperName ? 'Tiana' : 'The girl'>> stares. <q>Really?</q>
        She hesitates and then comes<<tiana.getOutermostRoom == 
          gPlayerChar.getOutermostRoom ? '' : ' running'>>. ";
        
        /* 
         *   If the PC isn't in the same location as the bird, move her into 
         *   the bird's location, so the status line will show the right 
         *   room name at the end of the game.
         */
        if (gPlayerChar.getOutermostRoom != babyBird.getOutermostRoom)
        {
            "<.p><q>Over here,</q> you say, leading the way. ";
            gPlayerChar.moveIntoForTravel(babyBird.getOutermostRoom);
        }
        
        "{The tiana/she} is shorter than you are, so you have to
        help her up the tree. 
        <.p>Seeing the baby bird, she gasps softly. <q>It's so 
        beautiful,</q> she whispers. <q>Where are its mummy and 
        daddy? Do you think it's an orphan?</q><.p>
        You shake your head. <q>They'll probably come back if we
        stay quiet and just watch.</q><.p>
        You and Tiana <<tiana.isProperName ? '' : '--- that\'s 
            the red-haired girl\'s name, Tiana ---'>> settle down in
        the tree and wait, talking in tiny whispers.<.p>
        The two of you spend the afternoon watching the baby bird, although
        the mother bird doesn't come back before it's time to go home.
        Emma and Yvonne come looking for you, but Emma isn't
        interested in the birds, so they go away again.
        By the time you have to leave, you've agreed that Tiana will come 
        and visit you tomorrow. ";
        
        endGame('You have made a friend');
    }
;


/* response when the PC hasn't encountered the baby bird yet */
++ AltTopic, StopEventList
    [
        '<q>Do you like birds?</q> you ask.<.p>
        {The tiana/she} blinks. <q>Yeah, I guess so... I like the ones that
        sing, and the ones that are all brightly coloured, and cute little ones. 
        Why?</q><.p>
        Good question. <q>I dunno... I was just wondering, I guess.</q> ',
        
        'You already asked {the tiana/she} if she liked birds, and she said
        yes. '
    ]
    
    isActive = (!gPlayerChar.hasSeen(babyBird))
;



/* 
 *   Reaction to the PC messing around after offering to count. Fictionally, 
 *   this is the PC's reaction, not Tiana's, but it's cleaner to implement 
 *   it as Tiana's.
 */
+ BeforeAction
    actor = gPlayerChar
    condition = (gPlayerChar.roleInHnS == roleCounting &&
        !gActionIs(Count) && !gActionIs(CountTo) && !gActionIs(Close))
    
    isOneOff = true
    
    react()
    {
        "<q>Just a minute,</q> you say to {the tiana/her}. <q>There's
        something I have to do first.</q><.p>
        She looks puzzled, but nods.<.p>";
    }
;



/* Reaction to the PC not answering her count-or-hide question immediately. */
+ BeforeAction
    actor = gPlayerChar
    
    condition = (tiana.curConvNode == tianaCountOrHide &&
            !(gActionIn(SayTo, Count, CountTo, HideIn, Hide, Close, 
                        ConvTopicT)))
    
    react()
    {
        tiana.setConvNode(nil);
    }
;



/* default responses to ask/tell commands */
+ DefaultSayAskTellTopic, ShuffledEventList
    eventList()
    {
        /* default responses appropriate for any situation */
        local lst = 
        [
            '{The tiana/she} looks vague and says nothing. ',
            '{The tiana/she} doesn\'t reply. Guess she didn\'t hear you. ',
            '{The tiana/she} jumps at the sound of your voice. <q>What?</q> she 
            says. <q>Sorry, I wasn\'t listening.</q> ',
            '{The tiana/she} shrugs. ',
            '{The tiana/she} nibbles one of her fingernails and then stares at
            it thoughtfully, ignoring you. '
        ];
        
        /* default responses that are only appropriate while playing Sardines */
        if (!tiana.isPlayingHnS)
        {
            lst += '<q>Maybe we\'d better get back to the game,</q> 
                {the tiana/she} suggests nervously. ';
        }
        
        return lst;
    }
;


++ AltTopic
    "{The tiana/she} is busy counting. If you really want to play Hide and 
    Seek, you\'d better find a hiding place. "
    
    isActive = (getActor.curState == tianaHnSCounting)
;



/* Conversation while searching for Emma */
+ tianaSearching: ActorState;



/* telling her stuff */

/* telling her about Emma/Emma's hiding place */
++ AskTellTopic, StopEventList
    [emma, bushNearCubby, tHidingSpot, tCheating]
    [
        new function {
            "You glance around to make sure no one else is listening, and 
            then whisper to {the tiana/her}, <q>I know where Emma is 
            hiding.</q><.p>
            She looks puzzled. <q>But why&mdash;</q><.p>
            <q>She's hiding in the bush near the cubby house. You should
            go hide there too.</q><.p>
            <<tiana.isProperName ? 'Tiana' : 'The girl'>> stares at you.
            <q>You shouldn't be telling me, that's not how the game works...
            I'm supposed to find Emma on my own. If I go hide there now, I'll
            be cheating.</q> She hesitates. <q>Do you really think I 
            should?</q><.p>
            <q>Go on, don't be scaredy. You can't just stop playing, that'd be
            silly. Anyway, it's only one game. You can play properly next time.</q>
            <.p>
            {The tiana/she} doesn't look like she agrees, but she nods. <q>I
            guess...</q> ";
            tiana.isCheating = true;
        },
        'You\'ve already told {the tiana/her} where Emma is hiding. '
    ]
    
    isActive = (gPlayerChar.isCheating)
;


+++ AltTopic, StopEventList
    [
        new function {
            "<q>I think Emma is pretty bossy, don\'t you?</q> you confide.<.p>
            {The tiana/she} wriggles nervously. <q>Uh... a bit, I guess. I
            don\'t know...</q><.p>
            <q>Like how she asks what we want to play and then she just goes 
            ahead and decides herself.</q><.p>
            <<tiana.isProperName ? 'Tiana' : 'The girl'>> laughs suddenly.
            <q>I know what you mean.</q> ";
        },
        'You\'ve already asked {the tiana/she} what she thinks about Emma.
        She agreed with you that Emma is pretty bossy. '
    ]
    
    isActive = (gTopic.getBestMatch() == emma &&
                (!gPlayerChar.isCheating || gActionIs(AskAbout)))
;


+++ AltTopic
    "You don't know anything worth mentioning about Emma's hiding spot. "
    
    isActive = (!gPlayerChar.isCheating && gTopic.getBestMatch() == tHidingSpot)
;


+++ AltTopic, StopEventList
    [
        '<q>Do you think we should ask Emma to play Hide and Seek with us
        too?</q> you ask.<.p>
        {The tiana/she} frowns. <q>She won\'t want to, will she?</q> she
        says. <q>She really wanted to play her game. But I guess you can
        ask her.</q> ',
        
        'You already asked {the tiana/she} if you should invite Emma to
        play Hide and Seek with you. She didn\'t think Emma would want
        to, but she said you could try asking. '
    ]
    
    isActive = (gPlayerChar.isPlayingHnS && gTopic.getBestMatch() == emma)
;



/* 
 *   Default response to talking to Tiana about any HidingSpot - including 
 *   Emma's hiding spot, if the player isn't cheating.
 */
++ AskTellGiveShowTopic @HidingSpot
    topicResponse()
    {
        local t = gTopic.getBestMatch();
        gMessageParams(t);
        
        "<q>Why don't you try looking <<t.actorInPrep>> the 
        <<t.disambigName>>?</q> you suggest.<.p>";
        
        if (t.searchedBy(tiana))
            "<q>I've already looked there,</q> {the tiana/she} says. ";
        else if (tiana.canTouch(t))
            "<q>I was just going to, actually,</q> {the tiana/she} says,
            frowning. ";
        else
            "<q>I'm looking over here,</q> {the tiana/she} says.
            <q>Why don't <i>you</i> look there?</q> ";
    }
    
    /* less likely than other topic responses, all things considered */
    matchScore = 50
    
    isActive = (!tiana.isPlayingHnS)
;



/* Asking Tiana about herself for the first time reveals her name. */
++ AskTellTopic [tiana, tName]
    topicResponse()
    {
        "This is a bit embarrassing. <q>Um, sorry, I forgot your 
        name,</q> you mutter.<.p>
        The girl turns to look at you. <q>Oh --- I'm Tiana,</q> she 
        says. A short pause. <q>My mum works for Emma's mum, so
        we visit sometimes,</q> she adds.<.p>
        <q>My mum does too,</q> you say. <q>She just started a few
        weeks ago.</q><.p>
        Tiana nods. <q>I know. Emma said.</q> <<tiana.isPlayingHnS ?
          '' : 'She frowns. <q>I guess we\'d better get back to the 
              game...</q>'>> ";
        getActor.learnName();
    }
;


/* 
 *   AltTopic for asking/telling Tiana about herself when you already 
 *   know her name.
 */
+++ AltTopic
    "You put on your best grownup voice. <q>So, Tiana, what do you 
    do?</q><.p>
    Tiana stares at you blankly. <q>Do? I don't know what you 
    mean.</q> "
    
    isActive = (tiana.isProperName() && gTopic.getBestMatch() == tiana)
;


/* 
 *   AltTopic for asking/telling Tiana about her name when you already know it.
 */
+++ AltTopic
    "You already know her name --- it's Tiana. "
    
    isActive = (tiana.isProperName() && gTopic.getBestMatch() == tName)
;



/* Asking about the game. */
++ AskTellTopic, StopEventList [tGame, tHnS]
    [
        new function()
        {
            "<q>Do you like this game?</q> you ask {the tiana/her}. 
            <q>Emma didn't really let us say what we wanted to play,
            did she?</q><.p>
            <<tiana.isProperName ? 'Tiana' : 'The girl'>> wrinkles her
            nose and says, <q>It's okay, I guess...</q> A short pause.
            <q>I like proper Hide and Seek better,</q> she adds. ";
            
            /* Now the PC knows Tiana prefers Hide and Seek to Sardines. */
            gPlayerChar.knowsTianaPrefersHnS = true;
        },
        
        'You already asked {the tiana/her} what she thought about Emma\'s game.
        She said she liked proper Hide and Seek better. '
    ]
;


+++ AltTopic
    topicResponse()
    {
        "<q>Do you want to play Hide and Seek instead?</q> you
        ask {the tiana/she}.<.p>
        She stares at you. <q>But we're already playing this game.
        What about Emma and Yvonne? Won't they be upset?</q><.p>
        <q>So what? They're not the boss of us. Come on, don't you want
        to play Hide and Seek?</q><.p>
        <<tiana.isProperName ? 'Tiana' : 'The girl'>> grins. 
        <q>Okay,</q> she says. <q>Do you want to hide or count 
        first?</q><.convnode Tiana\'s count-or-hide question> ";
        
        /* now the PC and Tiana are playing a new game */
        Person.peoplePlayingHnS += [gPlayerChar, tiana];
        
        /* and Tiana is no longer doing whatever she was doing earlier */
        tiana.lastAction = WaitAction.createActionInstance();
    }
    
    isActive = (gPlayerChar.knowsTianaPrefersHnS && 
                gTopic.getBestMatch() == tHnS)
;



/* Inviting Tiana to engage in fun behaviour with you. */
++ AskTellTopic [swing, cubbyHouse, cubbySlide, sandpit]
    topicResponse()
    {
        /* get the topic object */
        local topic = gTopic.getBestMatch();
        
        /* print the appropriate invitation to play text */
        topic.playWithTiana();
        
        /* move the PC into the right location for status line accuracy */
        gPlayerChar.moveIntoForTravel(topic.getOutermostRoom);
        
        /* end the game */
        endGame('You have made a friend');
    }
;


+++ AltTopic
    topicResponse()
    {
        local obj = gTopic.getBestMatch();
        gMessageParams(obj);
        "Playing Hide and Seek is more interesting than chatting about 
        {the obj/her}. ";
    }
    
    isActive = (gActor.isPlayingHnS)
;



++ AskTellTopic, StopEventList @yvonne
    [
        new function()
        {
            "<q>What do you think about Yvonne?</q> you ask {the tiana/her}.
            <q>Do you like her?</q><.p>
            <<tiana.isProperName ? 'Tiana' : 'The girl'>> fidgets, frowns, and
            finally admits, <q>She scares me a bit.</q><.p>
            <q>Why?</q><.p>
            <q>She just... she gets upset and angry about things all the time,
            little things, and then she yells at people...</q> {The tiana/she}
            trails off and starts chewing a fingernail. ";
        },
        
        'You already asked {the tiana/her} what she thought of Yvonne.
        She said she\'s a bit scared of Yvonne. '
    ]
;


+++ AltTopic, StopEventList
    [
        '<q>Yvonne was cheating!</q> you say. <q>She had her eyes open while
        we were counting!</q><.p>
        <q>Really? How do you know?</q><.p>
        You hesitate. <q>I just... sort of blinked, and I saw her...</q><.p>
        {The tiana/she} frowns, but doesn\'t say anything. ',
        
        'Better not mention cheating again. You almost gave yourself away last
        time. '
    ]
    
    isActive = (!yvonne.isCheatingOfHerOwnAccord)
;


+++ AltTopic, StopEventList
    [
        '<q>Do you think we should ask Yvonne to play Hide and Seek with us
        too?</q> you ask.<.p>
        {The tiana/she} looks startled. <q>I dunno... maybe, I guess. You 
        can if you want to.</q> ',
        
        'You already asked {the tiana/her} whether you should invite Yvonne
        to play with you. She didn\'t sound too enthusiastic, but she said
        you could if you wanted to. '
    ]
    
    isActive = (gPlayerChar.isPlayingHnS && !yvonne.isPlayingHnS)
;
    



/* Saying HELLO to Tiana. */
++ HelloTopic
    topicResponse()
    {
        "<q>Hi!</q> you say chirpily.<.p>
        {The tiana/she} stares at you. <q>Uh, hi,</q> she replies.
        <.p>
        <q>Sorry, I forgot your name,</q> you say.<.p>
        <q>Oh --- it's Tiana.</q><.p>
        Of course, that's what it was. You knew it started with a 
        T. ";
        tiana.learnName();
    }
;


+++ AltTopic
    "<q>Hello!</q> you say.<.p>
    Tiana just gives you a funny look. "
    
    isActive = (tiana.isProperName)
;


/* Tiana's normal reactions */

/* The PC trying to walk past Tiana */
++ walkPastTianaReaction: BeforeAction
    actor = gPlayerChar
    action = TravelViaAction
    
    isOneOff = true
    
    /* runs before the other walking-past-Tiana reaction */
    priority = 150
    
    /* 
     *   Only applies if the PC is in the same location as Tiana and trying 
     *   to walk past her to her next destination.
     */
    condition()
    {
        /* doesn't apply if Tiana is cheating or playing Hide and Seek */
        if (tiana.isCheating || tiana.isPlayingHnS)
            return nil;
        
        /* 
         *   only applies if the PC is in the same location as Tiana and 
         *   attempting to go to her next destination
         */
        if (gActor.getOutermostRoom != tiana.getOutermostRoom)
        {
            return nil;
        }
        else
        {
            /* Get Tiana's path to the hiding spot. */
            local path = tiana.pathToHidingSpot;
            
            /* 
             *   If Tiana hasn't decided on a path yet, this Reaction 
             *   doesn't apply.
             */
            if (!path)
                return nil;
            
            /* Find out where Tiana is in her path. */
            local i = path.indexOf(tiana.location);
            
            
            /* 
             *   If she and the PC are already at the end of the path, this 
             *   Reaction doesn't apply.
             */
            if (!i || i >= path.length)
            {
                return nil;
            }
            
            /* Find Tiana's next destination. */
            local next = path[i + 1];
            
            /* 
             *   Is the PC's destination the same as Tiana's next 
             *   destination? If so, this Reaction applies; if not, it 
             *   doesn't.
             */
            if (gDobj != next)
                return nil;
        }
        
        /* 
         *   If we got this far, then all the conditions are satisfied. 
         *   Hopefully. Gosh, this code is a mess.
         */
        return true;
    }
    
    /* This Reaction temporarily stops the PC from proceeding. */
    stopAction = true
    
    /* Reaction: Tiana asks the PC to go search somewhere else. */
    react()
    {
        "{The tiana/she} puts out her hand to stop you as you start 
        to walk away. <q>Um... &lsquo;scuse me, but I was going to 
        search over there next. Can't you go look somewhere else, 
        like";
        
        /* 
         *   Where should the PC go instead? There are three paths to the 
         *   hiding spot, and theoretically the PC should be taking the one 
         *   that isn't in use by either Tiana or Yvonne. 
         */
        if (tiana.pathToHidingSpot == Person.pathBehindShed &&
             yvonne.pathToHidingSpot == Person.pathAcrossLawn)
        {
            " the front lawn";
        }
        else if (tiana.pathToHidingSpot == Person.pathFrontOfHouse &&
                 yvonne.pathToHidingSpot == Person.pathAcrossLawn)
        {
            " behind the shed";
        }
        else if (tiana.pathToHidingSpot == Person.pathFrontOfHouse &&
                 yvonne.pathToHidingSpot == Person.pathBehindShed)
        {
            " behind the house";
        }
        else
        {
            /* 
             *   I don't think this should be possible, but at this point I 
             *   barely understand the systems I've put in place. So, just 
             *   to be safe, a non-committal default...
             */
            "... I don't know, just somewhere else";
        }
        
        "?</q><.p>
        You hesitate. ";
        
        tiana.initiateConversation(nil, 'look-somewhere-else');
    }
;



/* The PC ignores Tiana's protest and walks past her anyway. */
++ walkPastTianaReaction2: BeforeAction
    actor = gPlayerChar
    action = TravelViaAction
    condition()
    {
        return delegated walkPastTianaReaction.condition();
    }
    
    /* This reaction only occurs once. */
    isOneOff = true
    
    react()
    {
        "<.p>{The tiana/she} sighs quietly as you leave, but doesn't 
        say anything. ";
    }
;



/* 
 *   Reaction to seeing the PC having fun outside the game. This is an 
 *   AgendaItem rather than an AfterAction so that it will appear last in 
 *   the list of things happening this turn (after Yvonne's action). 
 */
+ tianaPcHavingFunReaction: AgendaItem
    isReady()
    {
        /* This only happens if Tiana can see the PC. */
        if (!tiana.canSee(gPlayerChar))
            return nil;
        
        local action = gPlayerChar.lastAction;
        local dobj = action.getDobj();
        
        /* 
         *   is the PC engaging in fun behaviour? 
         *
         *   swinging on the swing is fun 
         */
        if (action.actionOfKind(SwingOnAction) && dobj == swing)
            return true;
        
        /* sliding down the slide is fun */
        if (action.actionOfKind(SlideDownAction) && dobj == cubbySlide)
            return true;
        
        /* digging in the sandpit is fun */
        if (action.actionOfKind(DigAction) && dobj == sandpit)
            return true;
        
        /* I guess not */
        return nil;
    }
    
    /* this overrides any other AgendaItems */
    agendaOrder = 1
    
    invokeItem()
    {
        "<.p>{The tiana/she} has been watching you. <q>That looks like fun,</q>
        she says wistfully. <q>But shouldn't you be looking for Emma? Don't 
        you want to play the game?</q> ";
        
        getActor.initiateConversation(nil, 
                          'Tiana\'s want-to-play-Sardines question');
        
        isDone = true;
    }
;



/* 
 *   Conversation when Tiana is counting for Sardines. Mostly just default 
 *   responses, but give special responses to asking about Sardines and 
 *   Hide-and-Seek (TODO: and cheating?).
 */
+ tianaSCounting: ActorState
    isInitState = true
;


/* Asking about the game */
++ AskTellTopic @tGame
    "<q>How does this game go again?</q> you ask. <q>I still don't get it.</q>
    <.p>
    Yvonne sighs loudly, but {the tiana/she} stops counting for a minute to 
    explain, <q>Emma's gone to hide, okay? We have to count to 50, and then we 
    go to find her, and when we find her we have to hide with her. You have to 
    try and be the first one to find her.</q> "
;


/* Asking about Hide and Seek */
++ AskTellTopic @tHnS
    topicResponse()
    {
        "<q>This isn't how my friends play Hide and Seek,</q> you say. <q>When we 
        play it, one person counts and everyone else hides.</q><.p>
        {The tiana/she} stops counting for a minute. <q>It's not Hide and Seek,</q>
        she says, <q>it's this other game that Emma likes.</q> A pause. <q>I like
        proper Hide and Seek better,</q> she adds wistfully. ";
        gPlayerChar.knowsTianaPrefersHnS = true;
    }
;

+++ AltTopic
    "<q>Do you want to play Hide and Seek instead, then?</q> you ask.<.p>
    Before {the tiana/she} can say anything, Emma jumps in. 
    <q>We can't play Hide and Seek now!</q> she says. <q>We're playing this 
    game, and it's lots more fun than Hide and Seek, you'll see.</q><.p>
    {The tiana/she} sighs quietly and says nothing. "
    
    isActive = (gPlayerChar.knowsTianaPrefersHnS)
;


/* Talking about anything else. */
++ DefaultSayAskTellTopic
    "{The tiana/she} just keeps counting. Maybe she didn't hear you. "
;




/* Conversation when Tiana is counting for Hide and Seek (not for Sardines!) */
+ tianaHnSCounting: ActorState;



/* Asking her name */
++ AskTellTopic [tiana, tName]
    topicResponse()
    {
        "<q>By the way,</q> you say, <q>I forgot what your name was,
        sorry...</q><.p>
        The red-haired girl stops counting for a moment. <q>That's okay,</q>
        she says. <q>It's Tiana.</q> Before you can say anything else, 
        she starts to count again.";
        getActor.learnName();
    }
    
    /* only active if the PC doesn't know Tiana's name yet */
    isActive = (!tiana.isProperName)
;



/* ConvNode for when Tiana sees the PC having fun outside the game. */
+ ConvNode 'Tiana\'s want-to-play-Sardines question';


++ YesTopic
    "<q>Yes. 'Course I do!</q> you reply.<.p>
    {The tiana/she} sighs. <q>I guess we'd better get back to it 
    then.</q> "
;


++ NoTopic
    topicResponse()
    {
        "<q>No,</q> you reply. <q>Emma didn't even ask us what we wanted
        to play.</q><.p>
        {The tiana/she} smiles at you and says, <q>I like proper Hide and 
        Seek better than this game.</q> ";
        
        /* 
         *   Now the PC nows Tiana prefers playing Hide and Seek rather than 
         *   Sardines.
         */
        gPlayerChar.knowsTianaPrefersHnS = true;
    }
;


+++ AltTopic
    "<q>No,</q> you reply. <q>Emma didn\'t even ask us what we wanted to
    play.</q><.p>
    {The tiana/she} grins. <q>I don\'t like it much either,</q> she admits. "
    
    isActive = (gPlayerChar.knowsTianaPrefersHnS)
;



+ tianaCountOrHide: ConvNode
    'Tiana\'s count-or-hide question'
    
    /* 
     *   if the ConvNode times out instead of getting a reply, have Tiana 
     *   choose the roles instead
     */
    noteLeaving()
    {
        if (gPlayerChar.roleInHnS == nil)
        {
            /* 
             *   add this to her agenda so it will happen at the end of the
             *   player's turn, instead of at the beginning
             */
            tiana.addToAgenda(tianaChoosesToCount);
        }
        
        inherited();
    }
;


++ tellTianaYoullCount: SayAskTellTopic @tCounting
    topicResponse()
    {
        gPlayerChar.choosesHnSRole(roleCounting);
        
        /* change her last action */
        getActor.lastAction = WaitAction.createActionInstance();
    }
;


++ tellTianaYoullHide: SayAskTellTopic @tHiding
    topicResponse()
    {
        gPlayerChar.choosesHnSRole(roleHiding);
        
        "<<Person.peoplePlayingHnS.length() > 2 ? '{The tiana/she}' : 'She'>>
        immediately closes her eyes and begins to count, barely
        loud enough for you to hear her. ";
        
        /* set ActorState, to avoid inappropriate responses */
        getActor.startHnSCounting();
    }
;


+ tianaChoosesToCount: AgendaItem
    initiallyActive = nil
    isReady = true
    invokeItem()
    {
        "<.p>Since you don't answer her question, {the Tiana/she} says, 
        <q>If you don't care, I'll count, and you can hide.</q> She puts her
        hands over her eyes and starts to count, so quietly that
        you can hardly hear her.<.p> ";
        
        /* set the roles */
        gPlayerChar.roleInHnS = roleHiding;
        tiana.roleInHnS = roleCounting;
        
        /* change Tiana's ActorState */
        tiana.startHnSCounting();
    }
;


+ ConvNode 'look-somewhere-else';

++ YesTopic
    topicResponse()
    {
        "<q>I guess so,</q> you say.<.p>
        {The tiana/she} smiles at you. <q>Thanks,</q> she says, and goes back to
        what she was doing before. ";
        
        /* 
         *   effectively ends the conversation, so Tiana goes straight back to
         *   what she was doing before
         */
        tiana.nextRunTime--;
    }
;

++ NoTopic
    topicResponse()
    {
        "<q>No, I want to look here,</q> you say. <q>You can look over there 
        instead if you want to, but I'm staying here.</q><.p>
        {The tiana/she} says nothing and turns away from you. ";
        
        /* 
         *   effectively ends the conversation, so Tiana goes straight back to
         *   what she was doing before
         */
        tiana.nextRunTime--;
    }
;



/* Tiana's Unperson */
tianaUnperson: Unperson
    linkedPerson = tiana
;



/* 
 *   If the player uses Tiana's name before learning it, make out that 
 *   they've just remembered it.
 */
BeforeAction
    /* 
     *   this is the player's beforeAction, in case the player, say, asks 
     *   another character about Tiana while she isn't around
     */
    location = me
    
    /* 
     *   activate it if part of the player's command contained 'tiana' and 
     *   the player doesn't know her name yet
     */
    condition = (!tiana.isProperName &&
                 libGlobal.commandText.toLower.find('tiana'))
    
    react() 
    {
        /* 
         *   use reportAfter so this will appear after the main command 
         *   response, even though we do the processing before
         */
        reportAfter('<.p>(Of course, <i>that\'s</i> the red-haired girl\'s 
            name. Tiana. Emma did tell you, but Emma has been telling you a lot 
            of things. It\'s hard to remember all of them.)<.p>');
        tiana.learnName();
    }
;


/* Make a note of all the text the player has typed for a command so far. */
StringPreParser
    doParsing(str, which) {
        /* 
         *   This only needs to be done if the PC doesn't know Tiana's name 
         *   yet.
         */
        if (!tiana.isProperName)
        {
            if (which == rmcCommand)
                libGlobal.commandText = str;
            else
                libGlobal.commandText += (' ' + str);
        }
        
        /* In any case, return the string unchanged. */
        return str;
    }
    
   /* 
    *   I don't want to include transcript comments in this check, so let 
    *   the comment pre-parser run first. If the command gets through to 
    *   this stage, it should be safe.
    *
    *   The spelling corrector should also run first, so that if the player 
    *   types something like "Taina" that gets corrected to "Tiana", the 
    *   reaction will still trigger.
    */
    execBeforeMe = [commentPreParser, defaultSpellingCorrector]
;


modify libGlobal
   commandText = nil
;



/* 
 *   Special grammar to parse "girl you can't remember the name of" and its 
 *   variants.
 */
grammar nounWord(girlCantRememberName):
    'girl' ('that' | 'who' | 'whom' | ) ('you' | 'I' | ) ('can\'t' | 'cannot' | 
        'can' 'not' | 'cant') 'remember' (('the' | ) 'name' ('of' | ) | )
    : SpecialNounPhraseProd
    getMatchList = [tiana, tianaUnperson]
    
    /* 
     *   this futzing around is apparently necessary because there are 
     *   different possible ways for the player to enter this phrase
     */
    getAdjustedTokens() 
    {
        local origToks = getOrigTokenList();
        local adjToks = new Vector(origToks.length());
        
        foreach (local tok in origToks) 
        {
            adjToks.append(tok[3]);
            if (tok[3] is in ('girl', 'name'))
                adjToks.append(&noun);
            else
                adjToks.append(&adjective);
        }
        
        return adjToks;
    }
;



/* something to handle the player trying "Tahlia" or various other like names */
tianaWrongName: MultiLoc, Unthing
    'tahlia/talia/tina/tara/tatiana/titania/tania/tanya/taylor/tamara/tallulah/tamsin/tasha/tiara/tilda/tia/titty'
    'red-haired girl that you can\'t remember the name of'
    
    notHereMsg()
    {
        /* 
         *   actions that use one of Tiana's wrong names should never take any
         *   time
         */
        gAction.actionTime = 0;
        return('No, that\'s not her name. But it definitely started with T. ');
    }
    
    initialLocationClass = Room
    isHer = true
    
    /* get rid of it once the player knows Tiana's real name */
    removeFromPlay()
    {
        locationList.forEach({x: self.moveOutOf(x)});
    }
;
