#charset "us-ascii"

#pragma once

#ifndef ADV3_H
#include <adv3.h>
#endif

#ifndef singleDir
#include <en_us.h>
#endif

/*
 * Yes No Maybe
 * 
 * Credits: This is a routine by Scott Steinfath found on the TextAdventure archive (answerme.t) for Tads v2.0, 
 *          converted to Tads 3.0.17 by Cleo Kraft
 *
 * Description: The parser/narrator can ask the player a yes/no/maybe question and if the player actually answers it
 *          back, an answer can be given. 
 *
 * Example: 
 *          Player: "attack dragon"
 *          Parser: "What, are you crazy or something?"
 *          Player: "yes"
 *          Parser: "That's what I thought!"
 *
 * Set up:
 *          If you have the parser ask the player an arbitrary question:
 *          1. set the variable myNarrator.questionAsked=true
 *          2. set single quoted string values for myNarrator.qYes, qNo and qMaybe
 *             using the myNarrator.setNarratorQuestion(yes,no,maybe) function.
 * 
 * Example:
 *   someMethod{
 *            "Ooooh. How cute. You\'re going to awaken the frost giant. 
 *            Are you sure or shall I call the undertaker? ";
 *            local sYes = 'Seems like you have this well thought out. At least you\'ve got a plan. ';
 *            local sNo = 'Good idea. Let\'s let sleeping giants lie. ';
 *            local sMaybe = 'I can see you\'re quite decisive. ';
 *            myNarrator.setNarratorQuestion(sYes,sNo,sMaybe);
 *
 * File Order: Put near the end of your file order in the Tads workbench
 *             as this file modifies actor.t, actions.t, etc. 
 *   
 */

myNarrator: object
    questionAsked = nil // nil or true - was a question asked to the player?
    questionTurn = nil// nil or turn number this was set
    qYes=nil // nil or a single quoted string value ''
    qNo=nil  // nil or a single quoted string value ''
    qMaybe=nil // nil or a single quoted string value ''
    // This function sets all the string values and flags ready
    setNarratorQuestion(yestext,notext,maybetext){
        myNarrator.questionAsked=true;
        myNarrator.questionTurn=libGlobal.totalTurns;
        myNarrator.qYes=yestext;
        myNarrator.qNo=notext;
        myNarrator.qMaybe=maybetext;
    }
;

// see actions.t
modify YesAction
  execAction(){
     if((myNarrator.questionAsked!=nil) &&
        (myNarrator.questionTurn!=nil)){
         if((libGlobal.totalTurns-1)==(myNarrator.questionTurn)){
            say(myNarrator.qYes);  
            myNarrator.questionAsked=nil;
            exit;
         }
     }
     gIssuingActor.sayYes(gActor);// default in actions.t
  }
;

// see actions.t
modify NoAction
  execAction(){
    if((myNarrator.questionAsked!=nil) &&
        (myNarrator.questionTurn!=nil)){
         if((libGlobal.totalTurns-1)==(myNarrator.questionTurn)){
            say(myNarrator.qNo);  
            myNarrator.questionAsked=nil;
            exit;
         }
     }
     gIssuingActor.sayNo(gActor);// default in actions.t
  }
;


VerbRule(Maybe)
    'maybe' | 'possibly' | 'say' 'maybe' | 'could' 'be' | 'say' 'could' 'be' | 'say' 'possibly' 
    : MaybeAction
    verbPhrase = 'say/saying maybe'
;

DefineConvIAction(Maybe)
  execAction(){
    if((myNarrator.questionAsked!=nil) &&
        (myNarrator.questionTurn!=nil)){
         if((libGlobal.totalTurns-1)==(myNarrator.questionTurn)){
            say(myNarrator.qMaybe);  
            myNarrator.questionAsked=nil;
            exit;
         }
     }
     gIssuingActor.sayMaybe(gActor);
  }
;


SuggestedMaybeTopic
    name = 'maybe'
    fullName = 'say maybe'
;

modify Actor
  sayMaybe(actor) { sayToActor(actor, maybeTopicObj, maybeConvType); }
 
  defaultMaybeResponse(fromActor)
        { mainReport(&noResponseFromMsg, self); } // where "no" doesn't mean logical yes/no but no as in "The actor does not respond. "
;

class SuggestedMaybeTopic: SuggestedTopic
    suggestionGroup = [suggestionYesNoMaybeGroup] // suggestionGroup = [suggestionYesNoGroup] // actor.t
;

maybeConvType: ConvType
    unknownMsg = &sayMaybeMsg
    topicListProp = &miscTopics
    defaultResponseProp = &defaultMaybeResponse
    defaultResponse(db, other, topic)
        { db.defaultMaybeResponse(other); }
;

class YesNoMaybeTopic: MiscTopic
    includeInList = [&miscTopics]
    matchList = [yesTopicObj, noTopicObj, maybeTopicObj]
;

class MaybeTopic: YesNoTopic
    matchList = [maybeTopicObj]
;

maybeTopicObj: object;

modify playerActionMessages
  sayMaybeMsg = (addressingNoOneMsg)
;

// YES/NO/MAYBE suggestion group - see msg_neu.t
suggestionYesNoMaybeGroup: SuggestionListGroup
    showGroupList(pov, lister, lst, options, indent, infoTab)
    {
        /*
         *   if we have one each of YES and NO responses, make the entire
         *   list "say yes or no"; otherwise, use the default behavior 
         */
        if (lst.length() == 2
            && lst.indexWhich({x: x.ofKind(SuggestedYesTopic)}) != nil
            && lst.indexWhich({x: x.ofKind(SuggestedNoTopic)}) != nil
            && lst.indexWhich({x: x.ofKind(SuggestedMaybeTopic)}) != nil)
        {
            /* we have a [yes, no] group - use the simple message */
            "say yes, no or maybe";
        }
        else
        {
            /* inherit the default behavior */
            inherited(pov, lister, lst, options, indent, infoTab);
        }
    }
    groupPrefix = "say";
;
