#ifndef ADV3_H
#include <adv3.h>
#endif

#ifndef _BIGNUM_H_
#include <bignum.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// //#error "You can put an error here too if the variable <> something. "
#endif

/* Will probably not use this flag but putting it here in case we wish to 
 * conditionally include startrooms.t or not. This idea could be used to
 * offer a different random set of start rooms, perhaps from another include
 * file. 
 */
#ifndef START_ROOMS
#define START_ROOMS
#endif

// --------  B E G I N    R O O M S  --------
//  
//  RRRRR     OOOO     OOOO    M   M    SSSS 
//  R    R    O  O     O  O    MM MM   S   
//  RRRRR    O    O   O    O   M M M    SSS 
//  R    R    O  O     O  O    M   M       S
//  R     R   OOOO     OOOO    M   M   SSSS 


/*
 *   Begin a different game here...
 *   as a reward for finishing Diabolical with a "win" ending, perhaps 
 *   we'll ask the player if they'd like to play this other game. 
 */
myKeyRingTwo: Keyring 
  vocabWords = 'blue plastic (key) keyring/ring' 
  name = 'blue plastic keyring'
  desc = "A blue plastic keyring. Handy for organizing all your keys. "
  location = pixyland
; 
+ houseKey: Key 
  vocabWords = '(shiny) (metal) (copper) (house) key'
  name = 'shiny copper key'
  desc = "This is the copper metal key to your house. "
;

/*
 *  We'll only add this to "win" game finish options from the original game, not the bonus game.
 */
modify finishOptionAmusing
    doOption {
              local iDone = 0; 
              local s0 = '';
              do{
                "<br>Would you like to play the bonus game (y/n)? ";
                s0 = inputManager.getInputLine(nil, nil);
                s0 = s0.toLower();
                if((s0 == 'y') || 
                    (s0 == 'yes') || 
                    (s0 == 'n') ||
                    (s0 == 'no')
                    ){ 
                        iDone++;
                }
              }while(iDone==0);
              if((s0 == 'y') || (s0 == 'yes')){
                   gameMain.bonusGameRunning = true;
                   setPlayer(me);
                   gPlayerChar.moveIntoForTravel(restartRoom);
                   // avoid having two lamps in the bonus game...
                   brassLantern.moveIntoForTravel(pixyland);// in the bonus game we use brassLanternTwo instead (as it is an Attachable version for iron hooks and such)
                   gPlayerChar.lookAround(true);
                   throw new TerminateCommandException();// break out of finish options
              }else{
                "<.p>Some amusing things you might try next time are: swim down in the pool and allow yourself
                to drown (just do \'look\' commands a bunch of times) - that triggers reincarnation. You might
                also restart the game three times and notice something different in the mansion basement. ";
                    return true;// return to accept other finishOption commands from the player
              }
    }
;

notSleepy: TravelBarrier
   sleepyCheck {
      // checks to see if the pc/npc is wearing clothing or not and returns true or nil
      if(gPlayerChar.readyToSleep) return true;// if you're carrying nothing, you're nude, so return 1 or true
      return nil; 
   }
   canTravelerPass(traveler) { 
        local iSleepy = notSleepy.sleepyCheck;
        if(iSleepy) return nil;
        return true;
   }
   explainTravelBarrier(traveler) { 
        "You\'re too sleepy to leave your room right now. ";
   }
;

restartRoom: Room 
    name = ''
    iRanit = nil
    desc {
        if(restartRoom.iRanit){
            // "*** Error - somehow you wound up in a restart room again. ";
            gPlayerChar.moveIntoForTravel(startRoomTwo);
            gPlayerChar.lookAround(true);
            exit;
        }
              
              local iDone = 0; 
              local s0 = '';
              do{
                "<br>Skip intro (y/n)? ";
                s0 = inputManager.getInputLine(nil, nil);
                s0 = s0.toLower();
                if((s0 == 'y') || 
                    (s0 == 'yes') || 
                    (s0 == 'n') ||
                    (s0 == 'no')
                    ){ 
                        iDone++;
                }
              }while(iDone==0);
              if((s0 == 'y') || (s0 == 'yes')){        
                gameMain.skipIntro = true;
              }else{
                gameMain.skipIntro = nil;
              }
              restartRoom.iRanit = true;
              
              clearScreen();
    
              if(!gameMain.skipIntro){
                "<br>\n";
                if(gameMain.is_a_little_girl){
                    "You spent some time on the island as a little girl but eventually changed back to normal
                    and returned home. ";
                }else if(gameMain.is_a_girl){
                    "You spent some time on the island as a woman but eventually changed back to normal
                    and returned home. ";
                }else{
                    "You spent some time on the island and eventually returned home. ";
                }
                "You still have a few extra weeks left of vacation before you have to return to work so
                you decided to go and investigate a creepy old abandoned mansion on the outskirts of 
                town. ";
            
                "<br>\n<p>A taxi drops you off outside the main gate. \"Goodbye!\" the driver shouts while
                laughing at you,\"and good luck in that crazy place!\"</p>";
            
                "<h1>Mysterious Mansion</h1>";
              }
              // restore player back to normal, etc.
              foreach(local obj in me.contents){
                if(obj.ofKind(BodyPart) && obj != me){
                    obj.moveIntoForTravel(pixyland);
                }else if(obj.isWornBy(gPlayerChar) && obj != me){
                    obj.makeWornBy(nil);
                    obj.moveIntoForTravel(pixyland);
                }else if(obj != gPlayerChar && obj != me){
                    obj.moveIntoForTravel(pixyland);
                }
              }
              gameMain.is_a_girl = nil;
              gameMain.is_a_little_girl = nil;
              me.pcAge = 18;
              me.pcHeight = '6\' 2\"';
              me.pcHair = 'brown';
              me.pcEyes = 'blue';
              tempPlayerClothes.moveInto(me);
              mePenis.moveInto(me); 
              myKeyRingTwo.moveInto(me);
              girlingBooth.playerGirlified = nil;
              libGlobal.totalTurns = 0;// it's a new game to reset the turn counter
              /*
               * To Do: loop through all objects in the game and remove score items out 
               *        from the original game (not the bonus game here). Otherwise "full score"
               *        will incorrectly show the wrong total points possible. 
               */
              // me.hide();
              setPlayer(me);
              me.moveInto(startRoomTwo);      
              gPlayerChar.lookAround(true);
              me.discovered = true;
              throw new TerminateCommandException();// break out of finish options and/or stops desc of pixyland bug on first (new) turn
              // inherited(traveler);// show the room description
    }
;

startRoomTwo: OutdoorRoom
    name = 'outside gate'
    // vocabWords = '(the) concrete sidewalk' // we COULD use this but we'll use a Decoration and/or RoomPart object for the sidewalk
    theName = 'the sidewalk'
   // roomParts = static (inherited - defaultNorthWall + passagewaySuperNorthWall)
    inOnThe = 'on the' // used for PoV description from outside this location, can be 'in the' 'on the' or 'of the' - brassLantern uses this reference in a few rooms for outside PoV reference (i.e. through a window or looking through the gate)
    inRoomName(pov) { return 'on the sidewalk'; }
    // roomFirstDesc { }
    desc {
        /*
         *  We should probably just use the built-in
         *  roomFirstDesc instead of below but this is
         *  here for future reference.
         */
        if(!gPlayerChar.hasSeen(startRoomTwo)){
            // optionally put something here for first room look desc
            daemonID = new PromptDaemon(self, &daemon); 
            otherStuffDesc();
            local s0 = '';
            local iDone = 0;
        }
        /*
         * We're trying to get fancy here, just to see what we can do. 
         */
        if(!brassLanternTwo.moved){
           "On a sidewalk a tall iron gate stands before you wedged between a black brick wall stretching out in both
           directions off into the distance. There\'s an iron hook on the wall";
              if((ironHook.attachedObjects.length > 0) || (ironHook.contents.length > 0)){
                if(ironHook.contents.length > 0 && ironHook.contents[1] == brassLanternTwo){
                    " with a brass lantern dangling from it. ";
                }else{
                    ". ";
                }
           }else{
                ". ";
           }
           " Atop the wall on either side of the gate sits a pair of stone gargoyles glancing down at you with 
           menacing eyes. Off in the distance beyond the gate and past the driveway you see an old mansion. Behind 
           you across the street a large forest stretches off down the hillside.<.P>";
        }else{
           "On a sidewalk a tall iron gate stands before you wedged between a black brick wall stretching out in both
           directions off into the distance. There\'s an iron hook on the wall";
           /*
            * More fancy stuff (with different text results if the player put the lamp back on the hook). 
            *                                                                                           ^
            *                                                                                           |
            *  NOTE: in case you're wondering, the period goes outside the parenthesis if what's in there is
            *        not the complete sentence - this is just a reminder to me because sometimes I make the 
            *        mistake of putting the period before, not after.
            *        EX: I enjoy breakfast (sometimes). If the entire sentence is parenthetical, then you put 
            *            the punctuation inside the parenthesis.
            *        EX: King Arthur went to the round table. (If you didn't know, the round table is where he
            *            has his knights gather. Also it's a great place to order pizza 
            *            delivered (if they deliver (assuming you know what delivery means
            *            (assuming also you know why I'm using so many parenthesis here))).)
            *        
            *            - Cleo [6/23/2019]
            */
           if(ironHook.attachedObjects != nil){
                if(ironHook.attachedObjects.length > 0 && ironHook.attachedObjects[1] == brassLanternTwo){
                    " with a brass lantern hanging from it, swaying in the breeze. ";
                }else{
                    ". ";
                }
           }else{
                ". ";
           }
           "Atop the wall on either side of the gate sits a pair of stone gargoyles glancing down at you with 
           menacing eyes. Off in the distance beyond the gate and past the driveway you see an old mansion. Behind 
           you across the street a large forest stretches off down the hillside.<.P>"; 
        }   
        if(gameMain.allowHtmlLinks){
           "The hillside road stretches off to the <a href=\"east\">east</a> and <a href=\"west\">west</a> as 
           far as the eye can see. The only other obvious way leads <a href=\"in\">in</a> through the gate. ";
        }else{
           "The hillside road stretches off to the east and west as far as the eye can see. The only other
           obvious way leads in through the gate. "; 
        }
    }
    
    daemon(){
        gameMain.stuckDetectorCount++;
        local iStuck = gameMain.stuckDetectorCount;
        if(iStuck > 99){
            clearStuckCount();
        }
        // // local var
        // local sRoomShortName = (gPlayerChar.isIn(mainElevator) ? 'elevator' : 'room');
        // // has the player interrogated George Wellhart yet?
        //if(!interrogateGeorgeWellhart.ranIt){
        //    if(iStuck >= stuckLimit){
        //        if((gPlayerChar.location == floorNine) || (gPlayerChar.location == floorNineSecurity) || ((gPlayerChar.location == mainElevator) && (elevatorControlPanel.currentFloor.number == 9)) ||
        //           (gPlayerChar.location == cell1) || (gPlayerChar.location == cell2) || (gPlayerChar.location == cell3) || (gPlayerChar.location == cell4) ||
        //           (gPlayerChar.location == cell_5) || (gPlayerChar.location == cell_6)){
        //            "<.p>One of your guards enters the <<sRoomShortName>> and says,\"Excuse me, sir, but the prisoner is waiting for your interrogation in
        //            the interrogation chamber on this level. I just thought I\'d remind you.\"<.p>With that the guard turns and leaves.";
        //            clearStuckCount();
        //        }else{ 
        //            "<.p>One of your guards enters the <<sRoomShortName>> and says,\"Excuse me, sir, but the prisoner is waiting for your interrogation on floor nine.
        //            I just thought I\'d remind you.\"<.p>With that the guard turns and leaves.";
        //            clearStuckCount();
        //        }
        //    }
        // }
        // // has the player watched a transformation yet?
        //if((interrogateGeorgeWellhart.ranIt != nil) && 
        //   (gameMain.watchedTransformation == nil)){
        //    if(iStuck >= stuckLimit){
        //         // #CC9360 is the color for tan. We'll create a tan "graphical" note out of a couple of table cells for better presentation
        //         "<.p>A little red bearded dwarf runs into the <<sRoomShortName>> and hands you an urgent note which reads: 
        //         <table border=0 bgcolor=\"#CC9360\">
        //         <tr><td width=25></td><td width=250>
        //         \"<i>The sex change lab is in need of another test subject. Perhaps you should use your computer and schedule it on 
        //         the procedure menu.<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Signed,
        //         <br>&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;A Friend</i><br>
        //         </td></tr></table>
        //         <.p>With that the note erupts in a cloud of orange smoke and vanishes into thin air.<.p>The dwarf chuckles and runs away.<br>"; 
        //         clearStuckCount();       
        //    }
        //}
    }
    
    daemonID = nil
    
    stuckLimit = 20 // turns unstil program determines the player is wasting time and needs a hint
    
    clearStuckCount(){
        gameMain.stuckDetectorCount = 0;// a hint was just given so start counter over again
        stuckLimit = (20 + rand(10) + rand(10));// reset stuckLimit detection to 20 + 2d10 turns
    }
    
    north = mansionGateOuter
    // out asExit(south)
    in asExit(north)
    
    south {
        return self.myNoTravelObj;
        //if(libraryHiddenDoor01b.isOpen){
        //     return libraryHiddenDoor01b;
        //}else{
        //     return self.myNoTravelObj;
        //}
    } 
    
    west {
        if(gameMain.is_a_little_girl){
            return mansionSouthWestWallArea;
        }else{
            return self.myNoTravelObjTwo;
        }        
    }
    
    myNoTravelObj : NoTravelMessage { 
        travelDesc {     "Thick forest just past a deep drainage ditch across the street blocks the way. "; 
                   }
    }
    
    myNoTravelObjTwo: NoTravelMessage {
        travelDesc {    "You\'d rather investigate the old abandoned looking mansion than go that way right now. ";
                   }           
    }
    
    //up : TravelMessage {
    //    travelBarrier = [haveNotWatchedTransformationBarrier, controlHatchNotOpen]
    //  // canTravelerPass(traveler){ if(traveler.isIn(mainElevator)){ return nil; } return true; }
    //  // explainTravelBarrier(traveler){ "You need to step out of the elevator by going <a href=\"north\">north</a> first. "; }
    //  // isConnectorApparent(origin,actor) { return lexicalParent.isIn(self); }
    //   travelDesc {
    //        "You climb up the ladder. ";
    //   }
    //   destination {
    //         return forest;
    //   }    
    // }// end TravelMessage
;
+ ironHook: Attachable, Fixture, RestrictedSurface
    name = 'iron hook'
    vocabWords = 'iron hook'
    desc = "An ordinary iron hook on the brick wall. " // " <<ironHook.isAttachedTo(brassLanternTwo) ? 'A brass lantern hangs from it. ' : ''>> "
    // attachedObjects = [brassLanternTwo]  
    validContents = [brassLanternTwo]
    isListed = nil
    contentsListed = nil

  isMajorItemFor(obj) {  
        if(obj == brassLanternTwo) return true;
        return nil; 
  } 
  canAttachTo(obj){
           // this means the note can only attach to the bulletin board (& vice versa)             
           if(obj == brassLanternTwo) return true;
           return nil; 
  }  
  iobjFor(PutOn) maybeRemapTo((gDobj !=nil),AttachTo,self,gDobj)
  dobjFor(AttachTo){
       preCond = [touchObj]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ 
                 //"We\'re running our attach to stuff now... \n";
                 if(gIobj.isIn(gActor)){
                   /* send the object to the actor's drop destination */
                   gActor.getDropDestination(gIobj, nil)
                      .receiveDrop(gIobj, dropTypeDrop);
                 }               
                 inherited; 
       }
  }
  // "Attach lamp to hook" triggers this...
  iobjFor(AttachTo){
       preCond = [touchObj]
       verify(){ inherited; }
       check(){ inherited; }
       action(){ 
                 //"We\'re running our attach to stuff now... \n";
                 if(gDobj.isIn(gActor)){
                   /* send the object to the actor's drop destination */
                   gActor.getDropDestination(gDobj, nil)
                      .receiveDrop(gDobj, dropTypeDrop);
                 }               
                 inherited; 
       }
  }
  
  roomBeforeAction(){
            // if(gActionIs(Jump)){ }
  } 
  
  roomAfterAction(){
           // if(gActionIs(Look) || gActionIs(Examine)){ }
           // checkWork.workApproved = nil;// reset the checkWork routine in case player updated database here
  }
  
  /* 
   * Default for enteringRoom(traveler) is an empty method that must be overriden by
   * classes. We will use the startRoom's enteringRoom method for resetting flags 
   * and so on. 
   */
  enteringRoom(traveler){
        // do stuff
  }  
;
++ brassLanternTwo:  Attachable, Flashlight 
  name = 'brass lantern'
  vocabWords = '(small) (nifty) (rusty) (dusty) (dust) (covered) (scratched) (weathered) (brass) (latn) lantern/lamp/light/flashlight/linterna/lmpara/ligero/antorcha/torch'   
  desc = "It is a rather heavy duty brass lantern. It looks a bit weathered and 
          scratched from so much use. There/'s some scratchy writing on the side. "    
  touchInfo = true // testing to see if we can get it in the dark
  initDesc = "It\'s a seemingly familiar object to you. It looks a bit weathered
          and scratched from so much use. There\'s some scratchy writing on the 
          side. The lantern\'s dangling from an iron hook on the brick wall. "
  isListed = self.isAttachedTo(ironHook) ? nil : true
  isListedInContents = (
                        (gPlayerChar.location == startRoomTwo && (self.isAttachedTo(ironHook)) ||
                           (gPlayerChar.location == startRoomTwo && 
                             (ironHook.contents.length > 0 && (ironHook.contents[1] == brassLanternTwo)
                           ) 
                        ))) ? nil : true
  /*
   * We'll rem out this specialDesc as startRoomTwo desc handles how we see the lamp if it's hanging on the hook
   * but we'll leave the code rem'd here in case we want to try something fancy like this later.
   * Oh, and by the way, if you don't know what "rem" is it means "remark" - rem was a Basic (a.k.a. gwbasic, quickbasic, etc.) command
   * and the second programming language I learned after Pascal. - Cleo Kraft
   */
  //specialDesc { 
  //      local otherLocation = gPlayerChar.isIn(startRoomTwo) ? mansionDriveway : startRoomTwo;
  //      if(otherLocation == startRoomTwo){   
  //          return nil;
  //      }else{
  //          if(brassLanternTwo.isAttachedTo(self) || brassLanternTwo.location == ironHook){
  //              if(gAction == LookAction) return nil;
  //              "A brass lantern hangs from an iron hook on the wall. ";
  //          }else{
  //              return nil;
  //          }
  //      }
  //}  
  dobjFor(Read){ preCond=[touchObj,objHeld]
                 verify(){}
                 check(){ inherited; }
                 action(){ 
                    "<i>Crowther and Woods - I still have your lantern if you want it back.</i> ";
                    /*
                     *   Will Crowther wrote "Colossal Cave Adventure" with
                     *   expansion help from Don Woods in the 1970's (1975-1977)
                     *   The brass lantern/lamp in this game is just a tribute to them,
                     *   for who's text adventure inspired me to write my own.
                     *   Changed it so there's writing on the lamp now. Originally
                     *   if you tried to read the lamp (in my game here) it would 
                     *   say "There is nothing written on the brass lantern."
                     *             - Cleo Kraft
                     * 
                     *             6 JUN 2019
                     */
                 }
               }  
  disambigName = 'dusty brass lantern' // optional - helps better identify an item if other items are like it nearby
  brightnessOn = 4
  bulk = 5
  weight = 2
  dobjFor(TurnOn) {
        preCond = [touchObj,objHeld]
        verify() { inherited;  }
        check(){ inherited; }
        action(){ inherited; }
  }
  /*
   *  The original lamp in the game was seen first just around sunset, so the player
   *  needed it to see in the dark. We won't restrict it in the bonus game. - Cleo Kraft
   */
  //dobjFor(Drop){
  //      preCond=[objHeld]
  //      verify(){  if(
  //                    (gActor.location.ofKind(OutdoorRoom)) &&
  //                    (gameMain.generalTime == 'night')
  //                   ) illogicalNow('Not out here. You\'ll need it in the dark to see your way. '); 
  //      }
  //}
  dobjFor(Take){
        preCond = [touchObj, objNotWorn, roomToHoldObj]
        verify(){ inherited; }
        check(){ inherited; }
        action(){
                        
            // we'll do these steps just in case the above fails for some reason...
            // ironHook.detachFrom(self);
            self.detachFrom(ironHook);
            
             /* move me into the actor's direct contents */
            moveInto(gActor);

            /* issue our default acknowledgment of the command */
            defaultReport(&okayTakeMsg);
        }        
  }
  moveWhileAttached(movedObj, newCont){
            ironHook.detachFrom(self);
            self.detachFrom(ironHook);
  }
  canAttachTo(obj){
           /* This means the lamp can only attach to the iron hook (& vice versa)             
            * Note that you only really need a "canAttachTo(obj)" routine in the
            * actual iron hook item but we list it here just for completeness.
            */ 
           if(obj == ironHook) return true;
           return nil; 
 }    
; 
+ Decoration '(etched) (metal) (plaque) (plack) (brass) (lamp) (lantern) (tribute) writing' 'brass lantern writing'
    "Someone etched some writing into the side of the brass lantern. It reads: <i>Crowther & Woods - I still have your lantern if you want it back.</i> "
;
+ drivewayFar: Decoration '(the) (ordinary) (solid) (outer) (outside) (mansion) gravel driveway' 'driveway'
    desc {
        "It\'s just an ordinary gravel driveway";
        if(gPlayerChar.location == startRoomTwo){
            " just inside the gate. ";
        }else{
            ". ";
        }
        gPlayerChar.location.listRemoteContents(mansionDriveway);
    }
;
+ mansionGateOuter: Door '(my) (your) (front) (black) (iron) (mansion) (house) (sidewalk) door/gate' 'gate'
  "The gate is made of iron bars with spikes up top. "
   masterObject = mansionGateOuter
   otherSide = mansionGateInner
;
++ mansionGateOuterBars: SenseConnector, Fixture '(thick) (black) (iron) (mansion) (front) (gate) bars' 'iron bars'
  "Just some thick iron bars on the gate. "
  connectorMaterial = glass // tried without = glass and it doesn't work
  locationList = [startRoomTwo,mansionDriveway]
  dobjFor(LookIn) remapTo(LookThrough,self)
  /* 
   * Function: dobjFor(LookThrough)
   * 
   * The following calls the "roomRemoteDesc" routine (defined in thing.t)
   * in the opposite room from which the player is currently in.
   *    Example (in the mansionDrivewayRoom): 
   *     roomRemoteDesc(pov){
   *          if(pov == startRoom){
   *            "From the other side of the main gate you see
   *             the driveway curve around to the west and end
   *             at a garage door. A footpath beside the driveway
   *             goes up to the front porch of the mansion. ";
   *          }else{
   *             // default is to just show our normal description
   *             self.desc;
   *          }       
   *     }
   *
   * See also: lookDir.t (tads module from IF-Archive)
   *             \__ uses listRemoteContents in a "northLook" room property example (vs. roomRemoteDesc)
   *               |_ describeRemoteRoom(startRoom)
   *
   * TO DO: list the contents of the room you're looking into.
   *        For now we won't do this as it involves checking for
   *        obstructions in the way of the viewpoint, plus complex
   *        special object descriptions. 
   */
  dobjFor(LookThrough){
          verify(){ }
          check(){ } 
          action(){ 
            local otherLocation = gPlayerChar.isIn(startRoomTwo) ? mansionDriveway : startRoomTwo;
            if(otherLocation == startRoomTwo){   
               "You look up through the gate and see the driveway on the other side. ";
            }else{
                "You peer through the gate and see the sidewalk out front. ";
            }
            gPlayerChar.location.listRemoteContents(otherLocation);
         }// end action
  }// end dobjFor(LookThrough)
;


// start room allows west travel to here IF the player is a little girl
mansionSouthWestWallArea: OutdoorRoom 'west edge of wall'
    "... mansion southwest wall area (only little girls should be able to get to here ..."
    east = startRoomTwo;
;

mansionDriveway: OutdoorRoom
    name = 'driveway'
    desc = "...driveway room desc goes here..."
    north = mansionPorchTwo // mansionPorch is already a room name in the orig. game
    south = mansionGateInner
    out asExit(south)
    in asExit(north)
;
+ mansionGateInner: Door '(my) (your) (front) (pink) (and) (white) (villa) (thatched) (hut) (plastic) bead beads door' 'door'
  "The gate is made of iron bars with spikes up top. "
   masterObject = mansionGateOuter
   otherSide = mansionGateOuter
;
+ sidewalkFar: Decoration '(the) (ordinary) (solid) (outer) (outside) (mansion) concrete sidewalk' 'sidewalk'
    desc {
        "It\'s just an ordinary concrete sidewalk";
        if(gPlayerChar.location == mansionDriveway){
            " just outside the gate. ";
        }else{
            ". ";
        }
        gPlayerChar.location.listRemoteContents(startRoomTwo);
    }
;
+ placeholderTrowel: Thing '(little) (rusty) (iron) (gardening) trowel' 'trowel'
  "A rusty iron trowel used for gardening. "    
;

mansionPorchTwo: OutdoorRoom 'porch'
    "...front porch desc goes here..."
    south = mansionDriveway
    north = mansionDoor
;
+ mansionDoor : LockableWithKey, Door '(neat) (little) (green) (painted) (wood) (wooden) door' 'door' 
  "It's a neat little door, painted green to match the window frame. " 
  keyList = [gmDmSkeletonKey]
  initiallyLocked = true
; 

mansionFoyer: Room 'foyer'
    "...foyer room desc goes here..."
    north = outsideDifferentTGARLab
    south = mansionDoorInside
    travelBarrier = [basicallyClothed] // if we're careful this condition should not even matter
;
+ mansionDoorInside : Lockable, Door -> mansionDoor '(neat) (little) (green) (wood) (wooden) door' 'door'; 

mansionFormSaverLabRoom: Room 'form saver lab'
    "...form saver lab room desc goes here..."
    south = girlingLabTwo
;
/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ formSaverBoothTwo:  OutOfReach, Heavy, LockableWithKey, Readable, Occluder, OpenableContainer, Booth
  name = 'form saver booth'
  vocabWords = '(human) (body) (form) (saver) scanner booth'
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  readDesc = "<i>Form Saver</i>"
  actorTravelingWithin(origin, dest){
        if((dest == formSaverBoothTwo) &&
           (formSaverTwo.controlsSet == true) &&
           (formSaverTwo.hasUsed == nil)
          ){
              "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
              inputManager.pauseForMore(true);// better than using just the morePrompt()
              "<HR ALIGN=CENTER NOSHADE><br>";
              "There\'s a brief spark of light and then darkness once more. You feel a sudden wave of energy 
              flow downward through your body and the machine shuts off again.<.p>
              You think: <i>that was certainly quick!</i><.p>The machine shuts off again
              and the door slides open. A moment later you hear a rattle and clunk somewhere
              outside. You hear a pleasant female voice say,\"Adult human male body successfully scanned. 
              Please step outside and withdraw form cube from the receptical. Thank you.\" ";
              formSaverTwo.hasUsed = true;
              formCube.moveIntoForTravel(formSaverRecepticalTwo);
              formSaverBoothTwo.makeOpen(true);
              formSaverBoothTwo.makeLocked(nil);
          }
  }
  dobjFor(Close)
    {
        verify()
        {
            if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. ');

            /* it makes no sense to close something that's already closed */
            if (!isOpen)
                illogicalAlready(&alreadyClosedMsg);
        }
        action()
        {
            /* make it closed */
            makeOpen(nil);

            /* show the default report */
            defaultReport(&okayCloseMsg);
        }
    }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
         check(){ inherited(); }
         action(){ inherited(); }         
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gActor.ofKind(Male)){
                 "The inside of the booth has plain white metal walls. 
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly saves copies of peoples bodies. ";
                 if(formSaverTwo.hasUsed){
                         "You\'ve arleady made a copy of your original self so there\'s really no need for you to be in here anymore. ";
                 }
           }else{
                 "The ceiling is higher than you remember it when you were a boy. 
                 The form saver array mounted up there is out of your reach now,
                 though you could easily reach it before. The ceiling, walls and floor 
                 are made up of plain white metal. You realize you have no need to be
                 in here except perhaps to reflect upon the past a little. You\'ve saved
                 your old male form using this machine";
                 if(gActor.hasSeen(bodyRestorer)){
                        " now you just have to use the body restorer machine when ever you\'re
                        ready to turn back to normal again";
                 }else{
                        " but you still don\'t know where the normalizer machine is. At least
                        you have the peace of mind that you\'ve made a backup of yourself before
                        turning into a girl";
                 }
                ". <.p>You can exit the booth by going ";
                if(gameMain.allowHtmlLinks){
                    "<a href=\"out\">out</a>";
                }else{
                    "out";
                }           
                ". ";  
           }
     }else{
           "From outside you can see the booth has white metal walls. There is a control panel on it and on the side there\'s a little receptical. 
            There\'s writing in green letters above the door that indicate this is a form saver. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == formSaverBoothTwo) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == formSaverBoothTwo) return nil;
        if((gPlayerChar.location != formSaverBoothTwo) && (obj.location == formSaverBoothTwo)) return nil;
        if((gPlayerChar.location == formSaverBoothTwo) && (obj == formSaverRecepticalTwo)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == formSaverBoothTwo) &&
               (gActor.location != formSaverBoothTwo)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, formSaverControlsTwo)
    // from the Occluder class... - remove if you remove Occluder from this object
    occludeObj(obj, sense, pov){
        /* by default, simply ask the object what it thinks */
        // return obj.isOccludedBy(self, sense, pov);// the default
        // we override the default for special occluded objects
        if(obj != nil){
               if(pov.isIn(formSaverBoothTwo)){
                    // if point of view is on roof then the desk is occluded (blocked) from view
                    if(obj == formSaverRecepticalTwo) return true; 
                    if((obj == formCube) && (formCube.isIn(formSaverRecepticalTwo))) return true;
                    if(obj == formSaverControls) return true;
                    if((obj.isIn(formSaverRoom)) && (formSaverBoothTwo.isOpen == nil)) return true;
               }
               if(pov.isIn(mansionFormSaverLabRoom)){
                    if((obj.isIn(formSaverBoothTwo)) && (formSaverBooth.isOpen != true) ) return true;
               } 
                         
        }
        // Note: Thing.t returns nil by default on a call to occludeObj(obj, sense, pov)
        // ...however we will return the default at this point for the Occluder class, which is to ask the object what to do
        return obj.isOccludedBy(self, sense, pov);// the default
    }
;
++ Unthing '(form) (saver) (booth) (machine) control*controls' 'controls'
    'You can\'t see the controls from in here. '
;

formSaverTwo: Fixture, Readable, Heavy '(strange) (body) (form) saver recorder device/machine/invention' 'form saver'
  "A form saver. "   
  location = mansionFormSaverLabRoom // formSaverRoom was the orig. game's location but this is a copy in the mansionFormSaverLabRoom
  controlsSet = nil
  hasUsed = nil
;
+ formSaverRecepticalTwo : RestrictedContainer, Component '(form) (saver) (recorder) (device) (machine) (invention) (booth) slot/hole/aperature/receptical' 'receptical'
  "A little slot located on the side of the machine. "
   validContents = [formCube] 
; 
+ formSaverControlsTwo: Fixture 
  vocabWords = '(main) (strange) (form) (saver) (machine) (device) (invention) (view) key keys keypad keyboard board button buttons lever levers switch switches panel screen viewscreen control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if(gameMain.is_a_girl){
                      /*
                       *  To DO: 
                       *       1. allow the player to save an adult woman form cube to mess around with later (might introduce bugs or extra stuff to code)
                       */ 
                      "There\'s no reason to mess with the controls. You already saved your original form 
                      and you can just use the girl maker to turn back into your current form whenever you want. ";
                      exit;            
               }
               // We never use the form saver on anyone but the player in this game so remming this out (plus it's buggy) - Cleo Kraft 6/13/2019
               /*
                *   if(formSaverBooth.contents != nil){ local obj = nil; local
                *   oActor = nil; foreach(obj in formSaverBooth.contents){
                *   if(obj.ofKind(Actor)) oActor = obj; } if(obj != nil){
                *   if((oActor != nil) && (oActor != formSaverControls)){
                *   gMessageParams(oActor); local s0 = 'You don\'t need to form
                *   save \^{subj oActor}{the/he}. '; say(s0); exit; }else{
                *   gMessageParams(obj); local s1 = 'You can\'t form save {subj
                *   obj}{the/he}. '; say(s1); exit; } } }
                */
               if(formSaverTwo.hasUsed == nil){
                          /* Let's do it! */
                          if(formSaverTwo.controlsSet != nil){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "The controls on this machine are rather simple. You set them to record a standard human body. The timer\'s set. Now it\'s
                               time for you to enter the booth to record your form. ";
                               formSaverTwo.controlsSet =  true;
                          }
               }else{
                           "You\'ve already stored your original form once. You don\'t need to do it again. ";
                           exit;
               }
         }
  }  
;

girlingLabTwo: Room 'girling lab'
    "...girlingLabTwo room desc goes here..."
    north = mansionFormSaverLabRoom
;
+ Odor 'strong feminine female girly womanly body smell/scent' 'feminine scent'
  descWithSource { if(gActor.location == girlingBooth){
                     if(gameMain.is_a_girl==nil){
                           "It smells like a girl in here. ";
                     }else{
                           "It smells like a girl in here even more so than before. Maybe because you\'re a girl now. ";
                     }
                 }
  }
  hereWithSource = descWithSource
  displaySchedule = [2, 3, 3, 5] 
  noLongerHere = "The feminine scent diminishes a little. " 
; 
+ girlMakerTwo: Fixture, Readable, Heavy '(strange) (little) (girl) (sex) (change) (sexchange) (tg) (tf) (tgtf) (transformation) (woman) (female) machine/device/invention/maker' 'girl maker'
  "It\'s got a sleek outer appearance with white metal everywhere and knobs, dials and buttons
  all over. Just above the control panel in bright pink letters it reads \"little girl maker.\" The inside
  is nicely decorated with wall to wall pink fabric. "
  /* player tries to put something in the machine... reroute it to "put gDobj in slot" */
  iobjFor(PutIn) maybeRemapTo((gDobj !=nil),PutIn,gDobj,girlingBoothTwo)
  readDesc = "<i>girl maker</i> "
  dobjFor(Use) remapTo(Use, boothControlsTwo)
  dobjFor(Enter) remapTo(Enter, girlingBoothTwo)
  dobjFor(Board) remapTo(Enter, girlingBoothTwo)
; 
+ boothScreenTwo: Decoration '(view) (display) (black) (and) (green) monitor/screen/viewscreen' 'view screen'
  "An ordinary view screen on the side of the machine. Black with green letters. Below it sits a keyboard ready for use.  "
;
+ boothControlsTwo: Fixture 
  vocabWords = '(main) (strange) (sexchange) (sex) (change) (little) (girl) (tg) (tf) (tgtf) (transformation) (machine) (device) (invention) (maker) (view) screen viewscreen key keys keypad keyboard board button buttons lever levers switch switches panel control*controls' 
  name = 'controls'
  desc = "Though there are buttons, levers and switches all over the outside of the booth of various colors, sizes and shapes, 
          the main control panel is fairly straightforward enough. A simple keyboard and viewscreen. "
  dobjFor(Use){
         verify(){ logicalRank(110,'');
         }
         action(){
               if(gameMain.is_a_girl){
                      "You\'ve got no business messing around with the little girl maker controls.
                      You\'ve already turned yourself into a girl and you really don\'t think this
                      thing would turn you back to normal again anyway. Better try something else. ";
                      exit;            
               }
               // we never used the girling booth on others in the game so remming this out - plus it's buggy - Cleo Kraft 6/13/2019
               /*
                *   if(girlingBooth.contents != nil){ local obj = nil; local
                *   oActor = nil; foreach(obj in girlingBooth.contents){
                *   if(obj.ofKind(Actor)) oActor = obj; } if(obj != nil){
                *   if(oActor != nil){ gMessageParams(oActor); local s0 = '';
                *   if(oActor.ofKind(Female)){ s0 = '\^{subj oActor}{the/he} is
                *   already a girl. '; }else{ s0 = 'It\'s probably not a good
                *   idea to turn {subj oActor}{the/he} into a girl without his
                *   permission. '; } say(s0); exit; }else{ gMessageParams(obj);
                *   local s1 = 'You can\'t turn {subj obj}{the/he} into a girl!
                *   {It\'s} not even alive! Before you use the machine better
                *   make sure it\'s empty first. Don\'t want any unexpected
                *   disasters to happen. '; say(s1); exit; } } // if obj is nil
                *   it should skip to hasUsed check below }
                */
               if(formSaverTwo.hasUsed == nil){
                          if(gActor.hasSeen(formSaverTwo)){
                                "You consider setting the controls but decide it\'s best to wait until you figure out how to use that
                                form saver machine you saw. Turning into a little girl is one thing but doing so with no way back to normal doesn\'t
                                sound too safe. ";
                          }else{
                                "You mess with the controls a little but then stop and ask yourself <i>what in the world am I doing? I haven\'t even figured out if
                                there\'s even a way to change back to normal again. I can\'t go turning myself into a girl without taking precautions. I\'ve
                                got to find out if there\'s another machine that can normalize me once I do this.</i> ";
                          }
                          exit;
               }else{
                          /* Let's do it! */
                          if(girlingBoothTwo.girlingSet){
                               "You\'ve already set the controls. The automatic timer is ticking. Now you\'ve just got to enter the booth and wait
                               for this machine to do its thing. ";
                          }else{
                               "Unaware of what you\'re really doing, as many of the controls aren\'t even labeled with anything that makes sense,
                               you set the controls for a standard male to female sex change. It seems the preselected girl model for this is blonde but
                               you\'ve got two choices for I.Q., <b>normal</b> or <b>abysmal</b>, whatever that means. Make your selection: ";
                                local iDone = 0;
                                local s0 = '';
                                do{
                                  "<br> Please choose <b><a href=\"normal\">normal</a></b> or <b><a href=\"abysmal\">abysmal</a></b> : ";
                                  s0 = inputManager.getInputLine(nil, nil);
                                  s0 = s0.toLower();
                                  if((s0 == 'a') || 
                                     (s0 == 'normal') ||
                                     (s0 == 'n') ||
                                     (s0 == 'abysmal')
                                  ){ 
                                  iDone++;
                                }else{
                                   "Please choose <b><a href=\"normal\">normal</a></b> or <b><a href=\"abysmal\">abysmal</a></b><br>";
                                } 
                                "\n";
                               }while(iDone==0);
                               "<br>\nA warning pops up that indicates \"form already in use\" but you ignore it. It\'s probably nothing important. ";
                               "<br>\nThe display indicates the form is set. "; 
                               girlingBoothTwo.warningSeen = true;
                               girlingBoothTwo.girlingSet = true;
                               girlingBoothTwo.playerGirlified = nil;
                               if((s0=='n') || (s0=='normal')){
                                      girlingBoothTwo.girlType = 'normal';
                               }else{
                                      girlingBoothTwo.girlType = 'abysmal';
                                      "You grin slightly at what you\'re about to do to yourself. Turn yourself into a girl with an abysmal I.Q. 
                                      You figure if you\'ve got to be a blonde, why not go all the way and be the stereotypical dumb blonde, right? 
                                      You\'re going for the real girl experience. Submersing yourself into the world of women, turning yourself into
                                      the weaker sex. Hopefully the mental changes work and you\'ll actually <i>think</i> like a girl a little bit
                                      more this way. If not, you\'re not worried a bit. You were always great in math but you\'re on vacation and this
                                      little one-night adventure probably won\'t require you to do any math anyway. What\'s the <i>worst</i> that could
                                      happen? You suddenly become afraid of mice? You give the side of the machine a little pat. Now all you\'ve got to
                                      do is enter it and wait. ";
                               }
                          }
               }
         }
  }  
;
/*
 *   OutOfReach conditionally... if we are inside it we can not interact with objects outside of it
 */
+ girlingBoothTwo:  OutOfReach, Heavy, Openable, LockableWithKey, Booth 
  warningSeen = nil
  girlingSet = nil
  playerGirlified = nil
  girlType = 'normal' // 'normal' or 'abysmal' (abysmal is dumb blonde model)
  name = 'girling booth'
  vocabWords = '(girling) (girlifying) (transformation) booth'  
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  initiallyOpen = true
  
  dobjFor(Close){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
  }
  dobjFor(Open){
         verify(){ if(gActor.isDirectlyIn(self)) illogicalNow('It only opens and closes from the controls outside. '); 
                   inherited(); 
         }
  }
  actorTravelingWithin(origin, dest){
        // "origin: <<origin.name>>...<br>dest: <<dest.name>> ";  
        if((dest == girlingBoothTwo) &&
           (girlingBoothTwo.girlingSet == true) &&
           (girlingBoothTwo.playerGirlified == nil)
          ){
                       "You enter the booth. The door slides shut, closing you in the dark and you hear a click. ";
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       "<HR ALIGN=CENTER NOSHADE><br>";
                        girlingBoothTwo.makeOpen(nil);
                        girlingBoothTwo.makeLocked(true);
                        "There\'s a brief spark of light and then darkness once more. You feel a sudden wave of energy 
                        flow downward through your body.<.p>";
                        "You can\'t see a thing but you feel yourself changing.
                        You get the sense you\'re melting into the floor - it\'s quite disorienting and it takes 
                        a moment or so to realize you\'re actually shrinking down in size.
                        You hear a hiss as vents open up in the walls and floor and blow air on you.
                        It feels warm but you quickly realize that your entire body has become heated up
                        due to whatever strange process is going on and a few breaths of cold air tells you
                        that the vents are trying frantically to keep your body temperature from getting too hot. 
                        You imagine the energy involved in transforming all the matter in a human body from one
                        form to another must put out a tremendous amout of heat.<.p>";
                        // ** string break
                        "You feel the shaft of your penis pull slowly inward all the way to the base of the 
                        head of your cock. It remains that way for a few moments as your ball sack is sucked in
                        and then your pee hole splits in two as your plumbing is rewired. The original pee hole
                        grows bigger, forming the lips of your new vagina. You don\'t see all this because it\'s 
                        so dark in the booth but you feel and sense everything that is happening.<.p>";
                        // ** string break
                        inputManager.pauseForMore(true);// better than using just the morePrompt()
                        "<HR ALIGN=CENTER NOSHADE><br>";
                        "As all this is happening you feel yourself shrinking in height. You sense this because
                        of the uncanny sinking sensation going on. The entire transformation finishes up in twenty 
                        seconds though it feels almost like an eternity. The cold air blowing in through the vents
                        makes you shiver and you realize somehow all your clothes have simply vaporized.<.p>";
                        "You hear gearwork now and feel yourself being dressed up in new clothes.<.p> 
                        Finally it\'s done and the vents shut down and withdraw back into hidden compartments
                        and the booth door slides back open. You\'re nude - the process somehow dissolved all your
                        clothes. You hear a pleasant female voice crackle in over the speaker,\"Grown male to little girl
                        conversion complete. Have a nice day.\"<.p>";
                        // ** string break
                        "You\'re a little girl now";
                        if(girlingBoothTwo.girlType == 'abysmal'){
                               " and it feels oddly <i>normal</i>. You think it might have something to do
                               with setting the machine to abysmal. You quickly try to think of something
                               complicated, like math, and discover a vast emptiness replacing the skill you had
                               before. Simple addition, subraction and multiplication seems okay but the other stuff
                               like calculus and algebra is hauntingly absent. You try to test your memory further
                               but it\'s like trying to guess at something that isn\'t or wasn\'t ever there. Skills
                               seem to be the only thing really affected but if you had to stay this way you know you
                               could probably just relearn them. Memory of everything else seems to be okay. You remember
                               your girlfriend, your family and even the place you grew up. You remember everything 
                               but you lost entire skill sets. You <i>feel</i> like the dumb little girl you\'ve turned yourself
                               into, ditsy and care free and it feels great";
                        }else{
                               " and you can tell because there\'s an uneasy <i>wrongness</i> about your body. The gap in
                               your crotch, the long hair on your head, the soft smooth skin all over... everything\'s different and all out of
                               place. You didn\'t expect to feel so overwhelmingly different. You feel sickeningly good,
                               not good as in you like what\'s happened but good as in goody-goody-two-shoes kind of good. 
                               You don\'t think your mind\'s been tampered with exactly because you can still act how you
                               please but something\'s definately wired up differently in this little girl mind you\'ve inherited.
                               A certain self consciousness of your actions and the thought out reactions of others, if you will, 
                               that you didn\'t have before. You can\'t quite put your finger on it because it\'s something
                               you think all girls must have. The reason why you\'ve always thought, at the core, all girls
                               are nice, at least except the ones that are a little mean sometimes. There\'s a sense of 
                               kindness in you that you\'ve never felt before and it feels unnatural.<.p>";
                               // ** string break
                               "You think for a moment, testing your memory. Everything's intact but now you\'ve got another problem.
                               You still like girls and it\'ll be a long time before you\'re old enough to date if you remain stuck
                               this way but when that happens will you like girls still... or will you be doomed to become attracted
                               to boys?<.p>";
                               // ** string break
                               "<i>All right, let\'s see what mischief I can get into now that I\'m a little girl</i>";
                       }
                       ".<.p>";
                       // don't allow re-use
                       girlingBoothTwo.playerGirlified = true;
                       formSaverTwo.hasUsed = true;
            
                       tempPlayerClothes.moveInto(pixyland);
                       tempPlayerClothes.makeWornBy(nil);
                       gameMain.girlType = girlingBooth.girlType;
                       gPlayerChar.girlType = girlingBooth.girlType; // added this line in an attempt to fix the bug, appears to work. - Lashek
                       mePenis.moveIntoForTravel(pixyland);
                       noPenis.moveInto(gPlayerChar);
                       me.is_A_Girl = true;
                       gPlayerChar.is_A_Girl = true; // CromexxHuman class needs this set for clothes handling
                       gameMain.is_a_girl = true; // this is the KEY variable to set for sex changing player
                       girlingBooth.playerGirlified = true;
                       gameMain.is_a_little_girl = true;
                       me.pcAge = 6;
                       me.pcHeight = '3\' 10\"';
                       me.pcHair = 'blond';
                       me.pcEyes = 'blue';
                       
                       // move LG body parts to the player 
                       //local oArray = [myB2,myB3,myB4,myB5,myB6,myB7,myB8,myB9,myB10,
                       //                myB11,myB12,myB13,myB14,myB15,myB16,myB17,myB18,myB19,myB20,
                       //                myB21,myB22,myB23,myB24,myB25,myB26,myB27,myB28,myB29,myB30,
                       //                myB31,myB32,myB33];
                       //oArray.forEach({x:x.moveInto(traveler)});
                       //oArray.forEach({x:x.makeWornBy(traveler)});
         
                       // hmm... maybe the above isn't needed if we just make the player be Audrey
                       audrey.discovered = nil;// make her invisible/hidden
                       audrey.moveIntoForTravel(gPlayerChar.location);
                       setPlayer(audrey);
                       me.discovered = nil;
                       me.moveIntoForTravel(pixyland);
                       audrey.discovered = true;
            
                       // open and unlock booth
                       girlingBoothTwo.makeOpen(true);
                       girlingBoothTwo.makeLocked(nil);
                       inputManager.pauseForMore(true);// better than using just the morePrompt()
                       "<HR ALIGN=CENTER NOSHADE><br>";
        }
  }
  desc {
     if(gActor.isDirectlyIn(self)){
           if(gameMain.is_a_girl == nil){
                 "Pink fabric is on the walls and floor in this little transformation booth.
                 A strange array up above and just in reach seems to contain the beam device or ray gun or
                 whatever that allegedly turns boys into girls. ";
                 if(formSaverTwo.hasUsed){
                         if(girlingBoothTwo.girlingSet){
                                "Now all you have to do is wait for the machine to transform you. ";
                         }else{
                                "You saved your old male form using the form saver machine, now all you
                                have to do is go outside the booth and use the control panel, then run
                                back in here and wait for your transformation. ";
                         }                    
                 }else{
                       if(!gActor.hasSeen(formSaverTwo)){
                             "You\'re not stupid. You know you\'d better find the normalizer 
                             machine first, wherever it is, before using this thing. Oh sure,
                             you could turn yourself into a girl right now if this thing works
                             but why take a chance? You\'d feel a whole lot safer knowing behforhand
                             that you could undo the transformation. Just standing in here right now
                             kind of gives you the creeps. It would be fun all right but <i>permanently</i> a girl?
                             That\'s a scary proposition and you\'re just not ready for anything like that yet. ";       
                       }else{
                             "You\'re not comfortable standing in here. You saw that form saver back there and
                             know you\'d better use it before fooling around in this girl maker. If you turned
                             into a girl and couldn\'t change back again you don\'t know what in the world you\'d
                             do. ";
                       }
                 }
           }else{
                 "The ceiling is higher than you remember it when you were a boy. 
                 The transformation array mounted up there is out of your reach now,
                 though you could easily reach it before. The walls and floor have soft
                 pink fabric all over but it\'ll do you no good just standing in here gawking 
                 at your surroundings. This is the inside of a little girl maker. A machine that clearly
                 has one purpose. That sole purpose of turning you into a girl, which it did 
                 just as its outer lettering advertised. You\'ll not be changing back to normal 
                 in this thing. That\'s for sure. "; 
           }
           if(gPlayerChar.location == girlingBoothTwo){
                "<.p>You can exit the booth by going ";
                if(gameMain.allowHtmlLinks){
                    "<a href=\"out\">out</a>";
                }else{
                    "out";
                }           
                ". ";  
           }
     }else{
           "From outside you can see the booth is lined with smooth, delicate pink fabric. ";
     }
  }
  tooDistantMsg = (gPlayerChar.location == girlingBoothTwo) ? 'You can\'t reach anything from inside the booth. ' : 'You need to go in the booth first to reach {that dobj/him}. '
  cannotReachFromOutsideMsg(dest) { return self.tooDistantMsg; }
  cannotReachFromInsideMsg(dest) { return  self.tooDistantMsg; }
  canObjReachContents(obj) { 
        if(gPlayerChar.location == girlingBoothTwo) return nil;
        if((gPlayerChar.location != girlingBoothTwo) && (obj.location == girlingBoothTwo)) return nil;
        return true;
  }
  iobjFor(TakeFrom)
    {
        verify()
        {
            /* check what we know about the dobj */
            if (gDobj == nil)
            {
                /* 
                 *   We haven't yet resolved the direct object; check the
                 *   tentative direct object list, and count us as
                 *   illogical if none of the possible direct objects are
                 *   in me.  
                 */
                if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
                    illogicalAlready(takeFromNotInMessage);
                else if (gTentativeDobj.indexWhich(
                    {x: x.obj_.isDirectlyIn(self)}) != nil)
                    logicalRank(150, 'directly in');
            }
            else if (!gDobj.isIn(self))
            {
                /* 
                 *   the dobj isn't in me, so it's obviously not logical
                 *   to take the dobj out of me 
                 */
                illogicalAlready(takeFromNotInMessage);
            }
            else if (gDobj.isDirectlyIn(self))
            {
                /* 
                 *   it's slightly more likely that they want to remove
                 *   the object from its direct container 
                 */
                logicalRank(150, 'directly in');
            }
        }
        check(){
            if((gDobj.location == girlingBoothTwo) &&
               (gActor.location != girlingBoothTwo)
               ){
                "You can\'t reach it from outside the booth. ";
                exit;
            }
            inherited();
        }
    }
    dobjFor(Use) remapTo(Use, boothControlsTwo)
;
++ Unthing '(girling) (transformation) (booth) (machine) control*controls' 'controls'
    'You can\'t see the controls from in here. '
;


// delete this later - was going to use this as the bonus game start room but changed my mind - Cleo Kraft 6/22/2019
teenageBoysBedroom: ClothingRemovalRoom  
    name = 'bedroom'
    desc { 
        if(!gPlayerChar.hasSeen(teenageBoysBedroom)){
            "This is your master\'s old bedroom. It\'s all decked out just the way he
            likes with posters of rock bands, sports banners and things like that
            on the walls. There\'s a wooden framed Captain\'s bed with drawers built in.
            Over in the corner by the window is your master\'s computer desk. He\'s got a large
            walk-in closet to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
            }else{
                "west"; 
            }
            " and the main way out is through a bedroom door to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
            }else{
                "south"; 
            }
            ". ";
        }else{
            "You\'re in your master\'s bedroom. Apart from the bed, computer desk and chair, there\'s 
            really no other funiture in here. A closet is to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"west\">west</a>";
            }else{
                "west"; 
            }
            " and the way out is through a bedroom door to the ";
            if(gameMain.allowHtmlLinks){
                "<a href=\"south\">south</a>";
            }else{
                "south"; 
            }
            ". ";
        }
    }
    // south = yourBoysBedroomDoorInner
    south : NoTravelMessage {
         travelDesc { 
                 "Your master\'s not about to let you go anywhere freely except back to your lamp. ";
         }
   }
;
+ yourBoyBed: Bed, Heavy 
    vocabWords = '(your) (my) (master\'s) (large) (single) (twin) (mattress) (black) (painted) (Captain) (Captain\'s) bed' 
    name = 'bed' 
    desc = "It\'s a black wooden Captain\'s bed with a few drawers under it. "
; 
+ myBoyBedSheets: Decoration 
    vocabWords = '(your) (my) (master\'s) (white) (cotton) (bed) sheet/sheets' 
    name = 'sheets'
    desc = "White cotton bed sheets. "
    isPlural = true
;
+ myBoysBlanket: Decoration 
    vocabWords = '(your) (my) (master\'s) (black) (wool) covers blanket' 
    name = 'blanket'
    desc = "A black wool blanket. "
;

redGlass: Decoration '(bright) (dull) (broken) red glass pile' 'red glass pile'
    "A pile of red glass on the floor. "
    location = pixyland
;

greenGlass: Decoration '(bright) (dull) (broken) green glass pile' 'green glass pile'
    "A pile of green glass on the floor. "
    location = pixyland
;

blueGlass: Decoration '(bright) (dull) (broken) blue glass pile' 'blue glass pile'
    "A pile of blue glass on the floor. "
    location = pixyland
;

glassPieces: Decoration '(million) (glass) pieces' 'pieces'
    "A million glass pieces on the floor. "
    location = pixyland
;
/*
 * The above were just experimental TG/AR versions of what we used before.
 * What we really need for the bonus game is something better than just 
 * a transformation booth. 
 */
differentTGARLab: Room
    vocabWords = '(sex) (change) (age) (regression) (transformation) lab room'    
    name = 'lab'
  //  roomFirstDesc = 'As you enter you notice a man in a white lab coat standing
  //      behind a little podium working some sort of controls. Another bigger fellow
  //      is standing on a circular platform in the middle of the room. '
    desc {
        if(gameMain.is_a_little_girl){
            "... LG desc of lab room ... ";
        }else{
            "... normal desc of lab room ... ";
        }        
    }
    south = differentTGARLabDoorTwo
    out = differentTGARLabDoorTwo    
;
+ differentTGARLabDoorTwo : LockableWithKey, Door 
  name = 'door'
  vocabWords = '(black) (painted) (wood) (wooden) (sex) (gender) (change) (age) (regression)(transformation) (lab) (room) door' 
  desc = "It's a black painted metal door. "
  keyList = [gmDmSkeletonKey]
  initiallyLocked = nil
  dobjFor(Unlock){
        preCond=[]
        verify(){}
        check(){
            if(self.isLocked()){
                failCheck('It\'s locked and you don\'t have the key. ');
            }
        }
        
  }
  dobjFor(Open){
        preCond=[]
        verify(){}
        check(){
            if(self.isLocked()){
                failCheck('It\'s locked and you don\'t have the key. ');
            }
        }
    }
; 
+ transformationMachinePlatform: Heavy, BasicPlatform
    igoreTransformed = nil
    playerTransformed = nil
    name = 'circular platform'
    isIt = true
    vocabWords = '(round) (circular) (metallic) (metalic) stage platform'
    desc = "It\'s a circular platform in the middle of the room. This seems to be the 
        target area for the large ominous looking ray gun mounted in the ceiling. "
    verifyEntry(posture, alreadyMsg, noRoomMsg){
           if(gPlayerChar.canSee(igoreNormal)){
                failCheck('Igore is on it and there\'s only room for one person. You\'ll just have to wait your turn. ');
            }else if(gPlayerChar.canSee(igoreGirl)){
                failCheck('Igore (the little girl) is on it still. You\'ll just have to wait your turn. ');
            }         
                    /* 
         *   if the given posture isn't allowed, tell the caller to use the
         *   inherited default handling 
         */
        if (allowedPostures.indexOf(posture) == nil)
            return true;

        /* this posture is allowed, but it might not be obvious */
        if (obviousPostures.indexOf(posture) == nil)
            nonObvious;

        /* 
         *   If the actor is already on this chair in the given posture,
         *   this action is redundant.  If we already verified okay on this
         *   point for this same action, ignore the repeated command - it
         *   must mean that we applied a precondition that did all of our
         *   work for us (such as moving us out of a nested room
         *   immediately within us).  
         */
        if (gActor.posture == posture && gActor.isDirectlyIn(self)
            && gAction.verifiedOkay.indexOf(self) == nil)
            illogicalNow(alreadyMsg);
        else
            gAction.verifiedOkay += self;

        /*
         *   If there's not room for the actor's added bulk, don't allow
         *   the actor to sit/lie/stand on the chair.  If the actor is
         *   already within the chair, there's no need to add the actor's
         *   bulk for this change, since it's already counted as being
         *   within us.  
         */
        if (!gActor.isIn(self)
            && getBulkWithin() + gActor.getBulk() > bulkCapacity)
            illogicalNow(noRoomMsg);

        /* we can't sit/stand/lie on something the actor is holding */
        if (isIn(gActor))
            illogicalNow(&cannotEnterHeldMsg);

        /* 
         *   if the actor is already in me, but in a different posture,
         *   boost the likelihood slightly 
         */
        if (gActor.isDirectlyIn(self) && gActor.posture != posture)
            logicalRank(120, 'already in');

        /* tell the caller we don't want to inherit the base class handling */
        return nil;
 
    }    
;
+ transformationMachineRayGun: Distant, Decoration
    name = 'ray gun'
    vocabWords = '(black) (metal) (metalic) (metallic) (sex) (gender) (change) (age) (regression) (tg) (ar) (transformation) ray gun'
    desc = "A black metallic ray gun mounted in the ceiling right above a circular platform in the middle of the lab. "
;
+ transformationMachinePodiumControls: Heavy, Surface
    name = 'controls'
    vocabWords = '(transformation) (machine) (wood) (wooden) podium lever levers button buttons control controls'
    desc = "Just some controls atop a little wooden podium. "
    dobjFor(Use){
        preCond=[objVisible,touchObj]
        verify(){ }
        check(){
            if(gPlayerChar.canSee(madScientist)){
                failCheck('Not with the mad scientist watching you. ');
            }
        }
    }
;
+ labCounter: Heavy, Surface
    name = 'counter'
    vocabWords = '(lab) (room) (black) (marble) (sink) counter top'
    desc = "It\'s a black marble counter top around the sink. "
;
++ orphUpBathSinkFaucet: OnOffControl, Fixture '(little) (small) (plastic) (blue) (handled) (metal) (silver) (silvery) (sink) faucet' 'sink faucet'
    "A little plastic blue handled faucet on the sink. <<isOn ? 'The faucet is on.' : 'The faucet is off.'>> "
   isOn = nil
   disambigName = 'sink faucet'
   dobjFor(TurnOn){
          preCond=[touchObj,actorDirectlyInRoom]
          verify(){ 
                logicalRank(110,'likely');// nonObvious;
                inherited; 
          }
          check(){ inherited; }
          action(){ inherited;           
               "The water starts pouring out. ";
          }
    }
    dobjFor(TurnOff){
         preCond=[touchObj,actorDirectlyInRoom]
          verify(){ 
                logicalRank(110,'likely');// nonObvious;
                inherited; 
          }
          check(){ inherited; }
          action(){ inherited;           
               "The water stops running. ";
          }
    }
    dobjFor(Use){
            preCond=[touchObj,actorDirectlyInRoom]
            verify(){
            if(gActor.isIn(orphangeUpBathTub)){
                logicalRank(2,'ulikely');
            }else{
                logicalRank(110,'likely');// nonObvious;
            }            
            }
            check(){ 
                
            }
            action(){
                if(isOn){
                       local tokList = Tokenizer.tokenize('turn off sink faucet');
                       executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
                }else{
                       local tokList = Tokenizer.tokenize('turn off sink faucet');
                        executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
                }
            }
    }
    
    roomAfterAction(){ 
        if(orphUpBathSinkFaucet.isOn){
            "The sink water is running. ";
        }
    }
;
++ labSink: RestrictedContainer, Component
    name = 'sink'
    vocabWords = '(lab) (room) (steel) (metal) sink'
    desc = "Just a steel metal sink. "
    validContents = [redBeaker,blueBeaker,greenBeaker]
    dobjFor(TurnOff) remapTo(TurnOff,orphUpBathSinkFaucet)
    dobjFor(TurnOn) remapTo(TurnOn,orphUpBathSinkFaucet)
    iobjFor(WashIn){
        verify(){ logicalRank(110,''); }
        check(){}
        action(){}
    }
    iobjFor(Wash){
        verify(){
            logicalRank(110,'likely');
        }
    }    
;
+++ redBeaker: RestrictedContainer
    validContents = []    
    name = 'red beaker'
    vocabWords = '(red) glass beaker'
    desc = "A red glass beaker. "
    isDirty = true
    crackCount = 0
    isBroken = nil
    dobjFor(Drop){
        preCond = [objHeld]
        verify(){ inherited; }
        check(){ inherited; }
        action(){ 
            inherited;
            if(self.crackCount == 0){
                "It hits the floor and cracks a little. ";
                "<.p>The professor slaps his forehead and says,\"Clumsy!\" ";
            }else if(self.crackCount == 1){
                "It hits the floor and cracks a little more. ";
                "<.p>The professor mumbles something angrily to himself. ";
            }else if(self.crackCount > 1){
                "It hits the floor and breaks into a million pieces. ";
                redGlass.moveIntoForTravel(differentTGARLab);
                redBeaker.moveIntoForTravel(pixyland);
                "<.p>The professor slaps his forehead and says,\"Numbskull! Nitwit! You worthless
                little... That <i>DOES</i> it! Get over there on the platform right now. I know how
                to fix YOU for this.\" ";
                madScientist.setCurState(transformingPlayerNow);
            }            
            self.crackCount++;
        }
    }
    dobjFor(ThrowAt){
        preCond = [objHeld]
        verify(){
            /* by default, we can throw something if we can drop it */
            verifyMoveTo(gActor.getDropDestination(self, nil));

            /* can't throw something at itself */
            if (gIobj == self)
                illogicalSelf(&cannotThrowAtSelfMsg);

            /* can't throw dobj at iobj if iobj is in dobj */
            if (gIobj != nil && gIobj.isIn(self))
                illogicalNow(&cannotThrowAtContentsMsg);
        }
        check(){
            if(gPlayerChar.canSee(igoreNormal) || gPlayerChar.canSee(igoreGirl)){
                    failCheck('The professor waggles a finger at you when you get ready to throw the beaker.
                        You decide to hold off on this for now. ');
            }            
        }
        action(){
            /* 
             *   process a 'throw' operation, finishing with hitting the
             *   target if we get that far 
             */
            // "...throw at action... gIobj == <<gIobj.name>> .... ";
            local iBreak = nil;
            if(gIobj != nil){
                if(gIobj == defaultCeiling){
                    iBreak = true;
                }   
                local oVector = new Vector(32);
                oVector = [defaultNorthWall,defaultSouthWall,defaultEastWall,defaultWestWall,defaultCeiling, 
                    transformationMachineRayGun,labCounter,orphUpBathSinkFaucet];
                foreach(local obj in oVector){
                    if(gIobj == obj){
                        iBreak = true;               
                    }
                }
                if(iBreak){
                    local projectile = self;
                    local target = gIobj;
                    gMessageParams(projectile, target);
                    "{The projectile/he} hit{[s]|} {the target/him}
                    and shatters into a million pieces";
                    if(gIobj == (defaultCeiling || transformationMachineRayGun)){
                        " and falls to the floor";
                    }
                    ". ";
                    redGlass.moveIntoForTravel(differentTGARLab);
                    redBeaker.moveIntoForTravel(pixyland);
                    madScientist.setCurState(transformingPlayerNow);
                    "<.p>\"Fool! Numbskull! Now you\'ve broken it! I know JUST what to do with you. I\'ll FIX you
                    for this!\" the professor hollars. ";
                    madScientist.setCurState(transformingPlayerNow);
                }else{
                    processThrow(gIobj, &throwTargetHitWith);
                    if(gIobj == madScientist){
                        "You throw the red beaker at the mad scientist and he catches it and waggles a finger at you.
                        <.p>\"Fool! You might have broken it. I know just what to do with you. I\'ll FIX you for this!\" he 
                        hollars. ";
                        redGlass.moveIntoForTravel(differentTGARLab);
                        redBeaker.moveIntoForTravel(pixyland);
                        madScientist.setCurState(transformingPlayerNow);
                    }
                }
            }
        }// end action
    }// end dobjFor(ThrowAt)
    iobjFor(ThrowAt)
    {
        /* by default, anything can be a target */
        verify() { }
    }

    
    
    dobjFor(Wash){
        preCond = [touchObj, objNotWorn, roomToHoldObj]
        verify(){ logicalRank(110,'likely'); }
        check(){
            if(!self.isHeldBy(gActor)){
                tryImplicitAction(Take, self);
            }
            if(!self.isDirty){
                failCheck('I\'s already washed. ');
            }
            if(!self.isHeldBy(gActor)){
                failCheck('You need to be holding it first. ');
            }
            if(!gActor.canSee(orphUpBathSinkFaucet)){
                failCheck('You\'ll have to try that someplace else. ');
            }
            if(!orphUpBathSinkFaucet.isOn){
                failCheck('The faucet\'s not on. ');
            }
            if(!transformationMachinePlatform.igoreTransformed){
                failCheck('The master frowns at you and says,\"Do that later. I\'m much too busy right now for these silly distractions of yours. ');
            }
            if(gActor.canSee(igoreGirl)){
                failCheck('The master clears his throat. \"Ahem... do you really have to be doing that right now? Try and make a little less
                    noise. You\'ll do that later,\" he says. ');
            }
        }
        action(){
            self.isDirty = nil;
            madScientist.cleanedBeakersCheck();
            defaultReport('{You/he} wash{es/ed} {the dobj/him}. ');
        }
    }
;
+++ greenBeaker: RestrictedContainer
    validContents = []    
    name = 'green beaker'
    vocabWords = '(green) (hard) plastic beaker'
    desc = "A green hard plastic beaker. "
    isDirty = true
    dobjFor(Wash){
        preCond = [touchObj, objNotWorn, roomToHoldObj]
        verify(){ logicalRank(110,'likely'); }
        check(){
            if(!self.isHeldBy(gActor)){
                tryImplicitAction(Take, self);
            }
            if(!self.isDirty){
                failCheck('I\'s already washed. ');
            }
            if(!self.isHeldBy(gActor)){
                failCheck('You need to be holding it first. ');
            }
            if(!gActor.canSee(orphUpBathSinkFaucet)){
                failCheck('You\'ll have to try that someplace else. ');
            }
            if(!orphUpBathSinkFaucet.isOn){
                failCheck('The faucet\'s not on. ');
            }
            if(!transformationMachinePlatform.igoreTransformed){
                failCheck('The master frowns at you and says,\"Do that later. I\'m much too busy right now for these silly distractions of yours. ');
            }
            if(gActor.canSee(igoreGirl)){
                failCheck('The master clears his throat. \"Ahem... do you really have to be doing that right now? Try and make a little less
                    noise. You\'ll do that later,\" he says. ');
            }
        }
        action(){
            self.isDirty = nil;
            madScientist.cleanedBeakersCheck();
            defaultReport('{You/he} wash{es/ed} {the dobj/him}. ');
        }
    }
;
+++ blueBeaker: RestrictedContainer
    validContents = []    
    name = 'blue beaker'
    vocabWords = '(blue) hard plastic beaker'
    desc = "A blue hard plastic beaker. "
    isDirty = true
    dobjFor(Wash){
        preCond = [touchObj, objNotWorn, roomToHoldObj]
        verify(){ logicalRank(110,'likely'); }
        check(){
            if(!self.isHeldBy(gActor)){
                tryImplicitAction(Take, self);
            }
            if(!self.isDirty){
                failCheck('I\'s already washed. ');
            }
            if(!self.isHeldBy(gActor)){
                failCheck('You need to be holding it first. ');
            }
            if(!gActor.canSee(orphUpBathSinkFaucet)){
                failCheck('You\'ll have to try that someplace else. ');
            }
            if(!orphUpBathSinkFaucet.isOn){
                failCheck('The faucet\'s not on. ');
            }
            if(!transformationMachinePlatform.igoreTransformed){
                failCheck('The master frowns at you and says,\"Do that later. I\'m much too busy right now for these silly distractions of yours. ');
            }
            if(gActor.canSee(igoreGirl)){
                failCheck('The master clears his throat. \"Ahem... do you really have to be doing that right now? Try and make a little less
                    noise. You\'ll do that later,\" he says. ');
            }
        }
        action(){
            self.isDirty = nil;
            madScientist.cleanedBeakersCheck();
            defaultReport('{You/he} wash{es/ed} {the dobj/him}. ');
        }
    }
;


outsideDifferentTGARLab: Room 'cubby hole'
    "This is a little cubby hole beside the foyer staircase. There\'s a black metal door here leading north. "
    south = mansionFoyer
    north = mansionLabDoorInsideTwo
    in = mansionLabDoorInsideTwo
    out = mansionFoyer
;
+ mansionLabDoorInsideTwo : Lockable, Door -> differentTGARLabDoorTwo '(black) (painted) (wood) (wooden) (sex) (gender) (change) (age) (regression)(transformation) (lab) (room) door' 'door';

 

madScientist: Actor
    playerToldAboutHimself = nil
    toldPlayerAboutPlans = nil
    location = differentTGARLab
    name = 'scientist'
    vocabWords = '(crazy) (mad) (evil) (mr) (mister) man guy dude master scientist professor Binks'
    properName = 'Professor Binks' 
    isProperName = nil
    theName = 'the professor'
    isQualifiedName = (isProperName) // see: en_us.t eliminates use of "a" or "the" before the name 
    age = 38
    cleanedBeakers = nil
    // actorHereDesc = " " 
    is_a_girl = nil
    is_a_little_girl = nil
    initializeThing(){
        inherited;
        // setCurState(kellyGirlPlaying);
        // setKnowsAbout(me);
    }
    idleTurn() {
        inherited; 
    } 
    cleanedBeakersCheck(){
        if((!redBeaker.isDirty) && (!greenBeaker.isDirty) && (!blueBeaker.isDirty)){
            // set the actor state to talking
            "<.p>The professor rushes over and takes the clean beakers from you. \"Good,\" he says. \"At least you can
            do ONE thing right so far. I\'ll put these away and then we can talk.\"<.p>You watch him put the beakers away
            and then he unlocks the door and returns over to you and says,\"Very well. What do you want to talk about?\" ";
            differentTGARLabDoorTwo.makeOpen(nil);
            differentTGARLabDoorTwo.makeLocked(nil);
            blueBeaker.moveIntoForTravel(pixyland);
            greenBeaker.moveIntoForTravel(pixyland);
            redBeaker.moveIntoForTravel(pixyland);
            madScientist.setCurState(madScientistTalking);
        }        
    }
;  
+ transformingPlayerNow: HermitActorState
    isInitState = nil
    stateDesc = nil
    attentionSpan = 4
    specialDesc = "The mad scientist is over at the controls with a gun pointed at you. <<transformingPlayerNow.madExperimentTableTwo.doScript()>> "
    noResponse = "He waggles the gun at you and towards the platform in the middle. "
    
    madExperimentTableTwo: StopEventList {
        eventList = [
            new function(){
                differentTGARLabDoorTwo.makeOpen(nil);
                differentTGARLabDoorTwo.makeLocked(true);
                "\"You\'re of NO use to me at all. If you can\'t simply wash my beakers without
                breaking one of them then there\'s no hope for you ever becomming my new lab assistant,\" the mad
                scientist says. \"Just stay over there on the transformation platform while I fire up the machine.\" ";
            }
            ,new function(){
                if(!gPlayerChar.isOn(transformationMachinePlatform)){
                    "The professor comes over and drags you over to the platform. \"And STAY THERE until it\'s finished,\" he warns
                    heading back over to the controls. ";
                    local tokList = Tokenizer.tokenize('stand on platform');
                    executeCommand(gPlayerChar,gPlayerChar,tokList,nil);// nil = start of sentence (true/nil)
                }            
            },
            '<.P>You hear loud humming coming from somewhere up in the ceiling.
            <.p>\"It won\'t be long now, <<gameMain.playerName>>. First I must warm up the machine,\" the scientist says rubbing his hands giddily. ',
            '<.P>\"And now I set the controls to little girl, age six, blue eyes, blonde hair,\" the scientist says chuckling to himself. ',
            '<.p>\"I think, for you, we won\'t mess with your head. You\'ll retain all your male memories. Behaving like a little girl 
            will be up to you if you want,\" the professor says with a mischivious grin. ',
            new function(){
                "A bright white light shoots down from the ceiling, engulfing you.<.p>WAMP!
                <.P>For a few moments it seems like you\'re hovering over your body... and then suddenly you\'re back
                and the bright light is gone and you feel pretty different all over. Your perspective of the room has 
                changed due to the height loss you received. Everything seems so much bigger to you now. ";
                workingTheControls.playerTransformed = true;   
                transformationMachinePlatform.playerTransformed = true;
 
                tempPlayerClothes.moveInto(pixyland);
                tempPlayerClothes.makeWornBy(nil);
                gameMain.girlType = 'normal';
                gPlayerChar.girlType = girlingBooth.girlType; // added this line in an attempt to fix the bug, appears to work. - Lashek
                mePenis.moveIntoForTravel(pixyland);
                noPenis.moveInto(gPlayerChar);
                me.is_A_Girl = true;
                gPlayerChar.is_A_Girl = true; // CromexxHuman class needs this set for clothes handling
                gameMain.is_a_girl = true; // this is the KEY variable to set for sex changing player
                girlingBooth.playerGirlified = true;
                gameMain.is_a_little_girl = true;
                me.pcAge = 6;
                me.pcHeight = '3\' 10\"';
                me.pcHair = 'blond';
                me.pcEyes = 'blue';
                       
                // hmm... maybe the above isn't needed if we just make the player be Audrey
                audrey.discovered = nil;// make her invisible/hidden
                audrey.moveIntoForTravel(gPlayerChar.location);
                setPlayer(audrey);
                me.discovered = nil;
                me.moveIntoForTravel(pixyland);
                audrey.discovered = true;
            
                // open and unlock booth
                girlingBoothTwo.makeOpen(true);
                girlingBoothTwo.makeLocked(nil);
                inputManager.pauseForMore(true);// better than using just the morePrompt()
                "<HR ALIGN=CENTER NOSHADE><br>";
                differentTGARLabDoorTwo.makeOpen(nil);
                differentTGARLabDoorTwo.makeLocked(nil);
                "<.p>The professor chuckles and says,\"Though you don\'t realize it yet this was no mere transformation.
                Other than you or I, no one outside this room will have remembered you as anything other than the little 
                girl you are. Reality itself has been altered. You don\'t even have the same parents anymore. Well, the 
                fact is, right now I\'ve put you in orphan status, which means if you don\'t get over to the Hathoway House
                for Girls pretty soon you\'re going to be in pretty big trouble once they catch you. Muwhahahahahahaaaaa!\" ";     
                madScientist.setCurState(waitingForPlayerToLeave);
            },
            '<.p>\"Your name is Audrey now,\" the professor informs you. \"There\'s a whole mess of individuals over at the 
            orphanage who already know you by that name. You\'ll find that out soon enough. I\'ll leave it up to you to see
            yourself out of here and figure out where that orphanage is.\" ',
            ''
        ]
  }
;
+ waitingForPlayerToLeave: HermitActorState
    isInitState = nil
    stateDesc = nil
    attentionSpan = 4
    specialDesc = "The mad scientist is standing behind the control podium with his arms crossed, watching you. "
    noResponse = "He points to the door. \"I\'ve nothing further to discuss with you. Just get out of here. I never want to 
        see you ever, ever again,\" he says. "
;
+ watchingPlayerDoDishes: HermitActorState
    isInitState = nil
    stateDesc = nil
    attentionSpan = 4
    specialDesc = "The mad scientist is standing behind the control podium with his arms crossed, watching you. "
    noResponse = "He points to the dirty beakers in the sink. \"When you\'re finished cleaning those, then we\'ll talk,\" he says. "
;
+ workingTheControls: HermitActorState
    isInitState = true
    stateDesc = nil
    attentionSpan = 4 // after 4 turns he goes back to working the controls
    permissionToLeave = nil
    igoreTransformed = nil
    playerTransformed = nil
    //nextState = brendaBathing
  
    // stateDesc - this is a message that's added to the actor's basic description (the "npcDesc" proprerty in the Actor object). 
    //             Most actors will have a permanent description that never changes - a basic description of their physical 
    //             appearance - along with some extra information that describes what they're doing right now. The stateDesc 
    //             lets you add this extra state-dependent part. 
    // specialDesc - displays the actor's in-room description. This is the description displayed in the room description (for 
    //             example, when entering the room, or in response to a LOOK command). By default, we'll invoke the actor's 
    //             actorHereDesc method. 
    // obeyCommand(issuingActor, action) - determine if we should obey the given action. By default, we'll simply refuse all commands. 
    // beforeAction(), afterAction() - these give the state object a chance to react to an action. The Actor's beforeAction() and afterAction() methods (respectively) call these on the current state object, so these simply let you put reaction code with the state rather than with the actor. 
    // beforeTravel(traveler, connector), afterTravel(traveler, Connector) - like beforeAction() and afterAction(), the Actor forwards these calls to the ActorState, to give the state object a chance to respond. 
    // activateState(actor, oldState) - this is called when the new state is about to become active. 
    // deactivateState(actor, newState) - this is called when the state is active, and another state is about to be activated for the actor. 
    specialDesc = "A scientist is here (working some controls). <<workingTheControls.madExperimentTable.doScript()>>"
    noResponse = "He seems to be too busy to talk to you right now. "
    madExperimentTable: StopEventList {
        eventList = [
            new function(){
                differentTGARLabDoorTwo.makeOpen(nil);
                differentTGARLabDoorTwo.makeLocked(true);
                "<.p>You hear a click from behind you as the door swings shut. ";
            }
            ,
            '<.P>You hear loud humming coming from somewhere up in the ceiling and notice a few coiled up metal disks up there
            begin to glow as well as the little spherical tip below the odd contraption. <i>Is that a RAY GUN?</i> you think to yourself.
            <.p>\"It won\'t be long now, Igore. First I must warm up the machine,\" the scientist says rubbing his hands giddily. ',
            '<.P>\"And now I set the controls to little girl, age six, blue eyes, blonde hair,\" the scientist says chuckling to himself. ',
            '<.p>\"For this we\'ll also lower the intelligence to be that of what a six year old little girl would have,\" the scientist 
            says.<.P>\"Master, please, I don\'t want to be stupid,\" Igore begs.<.p>\"Shut up! You won\'t notice the difference anyhow you
            stupid fool and don\'t interrupt me again. This is for <i>science</i>,\" the master says rubbing his hands giddily. ',
            new function(){
                "A bright white light shoots down from the ceiling, engulfing Igore.<.p>WAMP!<.P>The machine powers down as the light vanishes
                as quickly as it appeared and there standing center stage is no longer a man but a confused looking little girl in what looks 
                like an Alice in Wonderland costume. She gasps and looks down at herself as she toys around with the lower edges of her dress 
                a little. \"Master, I think it worked,\" she says and adds,\"boy, do I feel funny!\"<.p>The master claps his hands and giddily
                hops up and down a few times and exclaims,\"Success! It worked! My invention is a success! With it I now have the power to rule
                the world. One by one I\'ll reduce all of the world leaders to be helpless little girls. Muwhahahahahahahaaaa!\"<.p>You begin
                to think that maybe now would be a good time to leave. ";
                workingTheControls.igoreTransformed = true;   
                transformationMachinePlatform.igoreTransformed = true;
                igoreNormal.discovered = nil;
                igoreNormal.moveIntoForTravel(pixyland);
                igoreGirl.moveIntoForTravel(differentTGARLab);
                igoreGirl.discovered = true;
            },
            ''
        ]
  }

    beforeTravel(traveler, connector){
        if(traveler == gPlayerChar){
            if(!differentTGARLabDoorTwo.isLocked()){
                "The scientist hurries past you";
                if(differentTGARLabDoorTwo.isOpen()){
                    " and slams the door shut";
                    differentTGARLabDoorTwo.makeOpen(nil);
                }
                if(!differentTGARLabDoorTwo.isLocked()){
                    " and locks it with a key";
                    differentTGARLabDoorTwo.makeLocked(true);
                }
                ". \"You\'re not going anywhere right now. I want you to see my experiment. I am going to turn my
                assistant Igore into a little girl with my machine. If it works it will be revolutionary,\" he says
                walking back over to the control panel as he pockets the key. ";                
            }else{
                "You try the handle but the door\'s locked. The scientist notices what you\'re trying to do and 
                merely chuckles at your failed attempt. ";
            }
            if(!workingTheControls.permissionToLeave) 
                exit; // stop the action!
        }
    }
;
    
madScientistTalking: InConversationState
  location = madScientist
  isInitState = nil
  stateDesc = nil
  attentionSpan = 4 // after 4 turns he goes back to working
  nextState = madScientistWorking
  specialDesc {
          if(madScientist.isProperName){
               "Professor Binks is here. ";
          }else{
               "The mad scientist is here. ";
          }
  }
;
++ madScientistWorking: ConversationReadyState
  isInitState = nil 
  specialDesc {
          if(madScientist.isProperName){
               "The professor is here. ";
          }else{
               "The professor is here. ";
          }
  }
; 
+++ madScientistHello: HelloTopic, StopEventList
   [
      new function(){
         "\"Hi there,\" you say to the mad scientist.<.p>
         He nods and says,\"Hi. What\'s news?\"<.p>
         \"My name is <<gameMain.playerName>>,\" you say introducing yourself.<.p>
         \"I\'m Professor Binks but you can just call me Professor,\" he says. <.p> ";
         madScientist.isProperName = true;
      },
      new function(){
         "\Hi Professor,\" you say.<.p>
         \"Hello <<gameMain.playerName>>,\" he says with a nod. ";
      }
   ] 
//  curScriptState = 2 
;
+++ ByeTopic
  topicResponse {
       "\"Bye, Professor\" you say to him.<.p>
       \"Talk to you later, <<gameMain.playerName>>,\" he says waving you off. ";
  }
;
+++ ImpByeTopic
   topicResponse {
           " ";
   }
;


professorDAT: DefaultAskTellTopic, ShuffledEventList
  [
     '\"What do you think about ' + gTopic.getTopicText + '?\" you ask the Professor.<.p>
     \"Your guess is as good as mine,\" he replies. ',
     '\"I\'d like to know about ' + gTopic.getTopicText + ',\" you say to the Professor.<.p>
     \"I really don\'t know,\" he replies. '
  ]
     location = madScientistTalking
;

AskTellTopic @genericTopicTopic
  topicResponse { 
        "\"What topics do you suggest?\" you ask the Professor.<.p> ";
        "<br>1. <a href=\"ask professor about himself\">ask the professor about himself</a>.
      <br>2. <a href=\"ask professor about becomming a little girl\">ask professor about becomming a little girl</a>
      <br>3. <a href=\"ask professor about sex transformation\">ask professor about sex transformation</a> ";
  }
  location = madScientistTalking
;

TellTopic, SuggestedTellTopic @genericMeTopic
  location = madScientistTalking
  topicResponse {
     if(gameMain.is_a_little_girl){
            "You tell him a bit about yourself (about who you were before your transformation).
            <.p>\"That\'s cute,\" he says with a shrug. ";
     }else{
            "You tell him a little about yourself but he doesn\'t seem too interested about it. ";            
     }
     madScientist.playerToldAboutHimself = true;
  } 
  timesToSuggest = 1 
  name = 'yourself'
  isActive = (madScientist.playerToldAboutHimself == nil)
;

TellTopic, SuggestedTellTopic @genericHimselfTopic
    location = madScientistTalking
    topicResponse {
        if(gameMain.is_a_little_girl){
            "\"You\'ve no business asking me that now, child,\" he says looking quite annoyed at you. ";
        }else{
            if(!madScientist.toldPlayerAboutPlans){
                "\"Ah yes. Well, I\'ve been making various inventions over the years but my transformation
                machine is my greatest success. With it I hope to turn all the world leaders into little girls
                so then *<i>I</i>* can rule the world. Muwhahahahahahaha! What do you think of that, huh? Pretty
                nifty,\" he says. ";
                madScientist.toldPlayerAboutPlans = true;
            }else{
                "\"We\'ve already discussed that. Let\'s talk about something else instead,\" he says. ";
            }
        }
    }
    timesToSuggest = 1
;

// ask professor about changing me into a girl
pesterProf: AskTopic @sexchangeTopic2
   location = madScientistTalking
   topicResponse {
        "You ask the professor about turning you into a girl.<.p> ";
        if(gameMain.is_a_girl || gameMain.is_a_little_girl){
            "\"You already ARE one, silly,\" he says. ";
        }else{
            pesterProf.pesterProfessorList.doScript();
        } 
   }
    pesterProfessorList: StopEventList {
        eventList = [
            '<.p>\"Not right now,\" he says. \"Maybe later.\" ',
            new function(){
                "\"I said not now,\" he says looking annoyed. ";
            }
            ,'<.P>\"Stop bothering me about that,\" he says. '
        ]
  }
;
// ask professor about sex change transformation
AskTopic @sexchangeTopic
    location = madScientistTalking
    topicResponse {
        "You ask the professor about sex change transformation. ";
        if(gameMain.is_a_girl || gameMain.is_a_little_girl){
            "\"You already ARE one, silly,\" he says with a grin. ";
        }else{
                       
        }        
    }
;
// ask professor about turning me into a boy
AskTopic @sexchangeTopic3
    location = madScientistTalking
    topicResponse {
        "You ask the professor about turning you into a boy. ";
         if(!gameMain.is_a_girl || !gameMain.is_a_little_girl){
            "\"You already ARE one, silly,\" he says with a grin. ";
        }else{
                        
        }
    }
;
// ask professor about becomming a little girl
AskTopic @littleGirlChangeTopic
    location = madScientistTalking
    topicResponse {
        "You ask the professor about turning you into a little girl. ";
         if(gameMain.is_a_girl || gameMain.is_a_little_girl){
            "\"You already ARE one, silly,\" he says with a grin. ";
        }else{
                        
        }
    }
;
    
scientistGreetsPlayer: AgendaItem
  initiallyActive = true
  location = madScientist
  isReady = (
             (gPlayerChar.canSee(madScientist))
            ) 
  invokeItem {
                 "A man in a lab coat turns his head and notices you and says,\"Ah, perfect time! You may
                 now witness my experiment. I am going to transform my assistant Igore into a wee little
                 girl with my latest invention.\"<.p>The man on the round
                 platform in the middle of the room looks nervous and asks,\"Master, is it going to hurt?\"<.p>
                 \"You won\'t feel a <i>thing</i>. Afterwards, though, I expect you\'ll feel a bit peculiar,\" the
                 scientist says and turns to look at you again and says,\"You there, feel free to poke around as much
                 as you like. I may need you as my new assistant. Just don\'t break anything or try to interfere with
                 my experiment.\" ";
                 madScientist.setCurState(workingTheControls);
                 // madScientist.isProperName = true;
                 self.isDone = true;
  }  
;

igoreGirl: Hidden, Female, CromexxHuman
    discovered = nil 
    location = pixyland
    name = 'Igore'
    vocabWords = '(crazy) (mad) (evil) (mr) (mister) (scientist\'s) (lab) (laborotory) (little) Alice assistant girl igor Igore'
    properName = 'Igore' 
    isProperName = true
    theName = 'Igore'
    isQualifiedName = (isProperName) // see: en_us.t eliminates use of "a" or "the" before the name 
    age = 28
    // actorHereDesc = " " 
    is_a_girl = true
    is_a_little_girl = true
    initializeThing(){
        inherited;
        // setCurState(kellyGirlPlaying);
        setKnowsAbout(me);
    }
    takeAttemptedCounter = 0
    dobjFor(Take){
        preCond=[objVisible,touchObj]
        verify(){ }
        check(){
            if(gameMain.is_a_little_girl){
                failCheck('Your tiny little arms are too weak to try and pick her up. ');
            }else{
                local s0 = 'You pick her up in your arms and she screams and kicks. \"Put me DOWN!\" she cries and you
                    set her back down. ';
                igoreGirl.takeAttemptedCounter++;
                if(igoreGirl.takeAttemptedCounter > 1){
                    s0 = 'You pick her up again and she throws another tantrum, kicking and screaming in your arms. \"I said
                        put me down you big <i>MEANIE</i>!\" she cries and you set her down. ';
                }
                if(gPlayerChar.canSee(madScientist) || (madScientist.location == gPlayerChar.location)){
                    if(igoreGirl.takeAttemptedCounter > 1){
                        s0 += '<.p>The master only grins at the scene you just caused. ';    
                    }else{
                        s0 += '<.p>The master chuckles at the scene you just caused and says,\"Not so big and strong, <i>NOW</i>, are
                        you Igore? Hee-hee!\" ';
                    }
                }
                failCheck(s0);
            }
        }
        action(){ }        
    }
    idleTurn() {
        inherited; 
        if(gPlayerChar.canSee(igoreGirl) && (igoreGirl.location == differentTGARLab)){
            igoreGirl.distractedTable.doScript();
        }
    } 
    distractedTable: StopEventList {
        eventList = ['',
            '<.P>The little girl scratches her side and says,\"Master, I feel funny.\"<.p>\"It is to be expected. You\'ll get used to it,
            I\'m sure,\" the master says. ',
            '<.p>The little girl on the platform glances down at the shiny black flats on her feet and says,\"My feet are so tiny now.\"',
            new function(){
                "<.p>The little girl walks over to the master and tugs at his shirt sleeve and aks,\"Master, could you change me back now?\"
                <.p>\"NO! The answer is no. I wish to keep you that way to discover if there are any long term effects. Now scoot. Skedaddle. Don\'t
                bother me. Go and play with dolls now or something.\"<.p>The little girl looks even more confused and then a bright smile 
                comes over her face. \"That\'s right... I like dollies now! Okee-dokies!\ she says and hurries to the door, goes up on tiptoes
                to try and open it and says,\"Master... the door\'s locked.\" ";
                "<HR ALIGN=CENTER NOSHADE><br>\n\"Oh very well,\" the master says and walks over and briefly unlocks the door and lets her
                out but then he quickly shuts and locks it again with his key and turns to you and says,\"Now then... what to do about you.
                On the one hand I <i>DO</i> need a replacemeent assistant. On the other hand I\'m not so sure I can trust you now that you 
                witnessed what I can do with my transformation machine. For now you can clean up those beakers over there in the sink. If you
                can manage <i>THAT</i> without breaking any then maybe I can use you around here after all.\"<.P> ";
                igoreGirl.discovered = nil;
                igoreGirl.moveIntoForTravel(pixyland);
                madScientist.setCurState(watchingPlayerDoDishes);
            },
            ''
        ]
  }
;  
+ igoresShoes: AdvancedCromexxClothing
  name = 'shiny black flats'
  vocabWords = '(neat) (cute) (little) (shiny) (little) (girl) (girl\'s) (black) (Igor\'s) (Igore\'s) flats/shoes'
  tableColor = '#F781F3' // pink
  disambigName = 'Igore\'s flats'
  myDesc = 'Some neat little shiny black flats for a little girl. '
  collectiveGroup = igoresOutfit01
  isPlural = true
  //properName = 'maid\s shoes'
  //isProperName = true // this == true plus set properName to eliminate "a" or "the" in desc
  // wornName = "spigly spogly french maid\'s shoes"
  clothLevel = 1
  inv_nbr = 7 // shoes
  wornBy = igoreGirl
;
+ igoresDress: HangableCromexxClothing
  name = 'light blue play dress'
  vocabWords = '(cute) (little) (light) (lightblue) (blue) (girl) (girl\'s) (Igore\'s) (play) (white) (alice) (in) (wonderland) bib dress'
  myDesc = 'A cute little light blue play dress with a white bib apron on front. '
  collectiveGroup = igoresOutfit01
  clothLevel = 12
  inv_nbr = 3 // chest
  sm_picture = 'cl_lg_dress1.png' // otherwise a '' string pointing to a pic file
  lg_picture = nil // otherwise a '' string pointing to a pic file
  wornBy = igoreGirl
  tableColor = '#F781F3' // pink
  attachedObjects = [] // DO put yourLGhangar in this array if you START the game with this hanging on it
  // isListed = (isAttachedTo(yourLGhangar) || isIn(yourLGhangar) ? nil : true)  // don't list in the room if this is on the hangar - will handle listing hangar stuff seperately 
  // isListedIncontents = (isAttachedTo(yourLGhangar) || isIn(yourLGhangar) ? nil : true)
  // dobjFor(PutIn) maybeRemapTo(((gIobj != nil) && (gIobj == yourLGhangar)),AttachTo,self,gIobj)
;
+ igoresTights: AdvancedCromexxClothing
  name = 'white tights'
  vocabWords = '(cute) (little) (white) (girl) (girl\'s) (Igor\'s) (Igore\'s) tights/leggings'
  tableColor = '#F781F3' // pink
  myDesc = 'Some white tights for a little girl. '
  isPlural = true
  collectiveGroup = igoresOutfit01
  clothLevel = 23 
  inv_nbr = 5 // legs
  sm_picture = 'cl_lg_tights1.png' // otherwise a '' string pointing to a pic file
  lg_picture = nil // otherwise a '' string pointing to a pic file
  wornBy = igoreGirl
;
+ igoresUndershirt: AdvancedCromexxClothing
  name = 'white little girl\'s undershirt'
  vocabWords = '(cute) (little) (white) (cotton) (girl) (girl\'s) (tee) (t) (Igore\'s) (Igor\'s) undershirt/shirt/t-shirt'
  myDesc = 'A white undershirt for a little girl. '
  tableColor = '#F781F3' // pink
  collectiveGroup = igoresOutfit01
  clothLevel = 6 
  // inv_nbr = 0 // not applicable - not considered armor
  inv_nbr = 16 // 17 = underwear bottom   16 = underwear top     3 = chest
  sm_picture = 'lg_undershirt1.png' // otherwise a '' string pointing to a pic file
  lg_picture = nil // otherwise a '' string pointing to a pic file
  wornBy = igoreGirl
;
+ igoresPanties: AdvancedCromexxClothing
  name = 'white panties'
  vocabWords = '(cute) (cotton) (little) (white) (girl) (girl\'s) (Igor\'s) (Igore\'s) underwear/panties/panty'
  myDesc = 'Some white cotton panties for a little girl. '
  tableColor = '#F781F3' // pink
  isPlural = true
  collectiveGroup = igoresOutfit01
  clothLevel = 3 
  // inv_nbr = 0 // not applicable - not considered armor
  inv_nbr = 17 // 17 = underwear bottom   16 = underwear top     3 = chest
  sm_picture = 'lg_panties1.png' // otherwise a '' string pointing to a pic file
  lg_picture = nil // otherwise a '' string pointing to a pic file
  wornBy = igoreGirl
;
+ selfExamination: HermitActorState
    isInitState = true
    stateDesc = nil
    attentionSpan = 4 // after 4 turns he goes back to working the controls
    permissionToLeave = nil
    igoreTransformed = nil
    //nextState = brendaBathing
  
    // stateDesc - this is a message that's added to the actor's basic description (the "npcDesc" proprerty in the Actor object). 
    //             Most actors will have a permanent description that never changes - a basic description of their physical 
    //             appearance - along with some extra information that describes what they're doing right now. The stateDesc 
    //             lets you add this extra state-dependent part. 
    // specialDesc - displays the actor's in-room description. This is the description displayed in the room description (for 
    //             example, when entering the room, or in response to a LOOK command). By default, we'll invoke the actor's 
    //             actorHereDesc method. 
    // obeyCommand(issuingActor, action) - determine if we should obey the given action. By default, we'll simply refuse all commands. 
    // beforeAction(), afterAction() - these give the state object a chance to react to an action. The Actor's beforeAction() and afterAction() methods (respectively) call these on the current state object, so these simply let you put reaction code with the state rather than with the actor. 
    // beforeTravel(traveler, connector), afterTravel(traveler, Connector) - like beforeAction() and afterAction(), the Actor forwards these calls to the ActorState, to give the state object a chance to respond. 
    // activateState(actor, oldState) - this is called when the new state is about to become active. 
    // deactivateState(actor, newState) - this is called when the state is active, and another state is about to be activated for the actor. 
    specialDesc = "A confused little girl is standing on a round platform in the middle of the room. "
    noResponse = "She seems to be too distracted from her recent transformation to talk to you right now. "
;




igoresOutfit01: ClothingOutfit 
  vocabWords = '(cute) (little) (girl) (girl\'s) (daytime) (day) (time) (wonderland) igore\'s outfit/outift/clothes'  // 'outift' is for dysleis programisr
  name = 'wonderland outfit'
  disambigName = 'Igor\'s wonderland outfit'
  desc = "It\'s a light blue dress with a white bib on the front, some white tights and shiny black flats. "  
  // NOTE: "myCromOutfitList" is something you have to manually set
  //        as well as in each object in this list, that object
  //        should have a pointer back to this CollectiveGroup 
  //        by using "collectiveGroup = <thisCollectiveGroupObjName>"
  myCromOutfitList = [igoresDress,igoresTights,igoresShoes,igoresUndershirt,igoresPanties]
  owner = igoreGirl // interesting thing about this is you can say "remove droid's outfit" and it works, even though memdroid's name(s) aren't up in the vocabWords
;

igoreNormal: Hidden, Female, CromexxHuman
    discovered = true 
    location = differentTGARLab
    name = 'Igore'
    vocabWords = '(crazy) (mad) (evil) (mr) (mister) (scientist\'s) (lab) (laborotory) assistant man guy dude igor Igore'
    properName = 'Igore' 
    isProperName = true
    theName = 'Igore'
    isQualifiedName = (isProperName) // see: en_us.t eliminates use of "a" or "the" before the name 
    age = 28
    // actorHereDesc = " " 
    is_a_girl = nil
    is_a_little_girl = nil
    initializeThing(){
        inherited;
        // setCurState(kellyGirlPlaying);
        // setKnowsAbout(me);
    }
    idleTurn() {
        inherited; 
    } 
;  
+ waitingForTransformation: HermitActorState
    isInitState = true
    stateDesc = nil
    attentionSpan = 4 // after 4 turns he goes back to working the controls
    permissionToLeave = nil
    igoreTransformed = nil
    //nextState = brendaBathing
  
    // stateDesc - this is a message that's added to the actor's basic description (the "npcDesc" proprerty in the Actor object). 
    //             Most actors will have a permanent description that never changes - a basic description of their physical 
    //             appearance - along with some extra information that describes what they're doing right now. The stateDesc 
    //             lets you add this extra state-dependent part. 
    // specialDesc - displays the actor's in-room description. This is the description displayed in the room description (for 
    //             example, when entering the room, or in response to a LOOK command). By default, we'll invoke the actor's 
    //             actorHereDesc method. 
    // obeyCommand(issuingActor, action) - determine if we should obey the given action. By default, we'll simply refuse all commands. 
    // beforeAction(), afterAction() - these give the state object a chance to react to an action. The Actor's beforeAction() and afterAction() methods (respectively) call these on the current state object, so these simply let you put reaction code with the state rather than with the actor. 
    // beforeTravel(traveler, connector), afterTravel(traveler, Connector) - like beforeAction() and afterAction(), the Actor forwards these calls to the ActorState, to give the state object a chance to respond. 
    // activateState(actor, oldState) - this is called when the new state is about to become active. 
    // deactivateState(actor, newState) - this is called when the state is active, and another state is about to be activated for the actor. 
    specialDesc = "<<scientistGreetsPlayer.isDone ? 'Igore' : 'A nervous looking man'>> is standing on a round platform in the middle of the room. "
    noResponse = "He seems to be too busy to talk to you right now. "
;