/* $Id: endgame.t 1.8 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Endgame for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

endgame : darkroom
    noun = 'endgame'
    sdesc = "Marble Room"
    ldesc = "You are in an enormous, round room; not quite as large 
        as it seemed in the dark, but still larger than king Dargon's 
	throne room, and almost a splendid. The ceiling is a gilt cupola
	high above the floor's vast expanse of polished marble;
	the walls are inlaid with gold and jewels.\b
	Apart from a pedestal in the
	centre of the floor, the room is empty. The only exit leads
	north."

    north = {
        if (stone.isIn(Me) or heliax.isIn(endgame)) {
	    heliax.leaving;
	    return nil;
	}
	else
	    return confined;
    }
    floorobj = cavefloor
;

endgame_walls : decoration
    noun = 'wall' 'walls' 'jewels' 'gold'
    sdesc = "walls"
    adesc = "walls"
    location = endgame
;

endgame_ceiling : decoration
    noun = 'ceiling' 'cupola'
    adjective = 'gilt' 'golden'
    sdesc = "ceiling"
    location = endgame
;

pedestal : fixeditem, surface
    noun = 'pedestal' 'pillar' 'velvet'
    adjective = 'marble'
    sdesc = "pedestal"
    ldesc = {
        "A marble pillar, about a five feet high. Its top surface 
	is covered with black velvet";
        if (itemcnt(self.contents)) {
	    ".\b";
	    inherited.ldesc;
	}
	else
	    "; a small depression in the velvet shows where the 
	    crystal was placed. ";
    }
    location = endgame
;    

heliax : Actor
    noun = 'wizard' 'man' 'heliax'
    adjective = 'old' 'tall' 'gaunt'
    isHim = true
    sdesc = "Heliax"
    thedesc = self.sdesc
    adesc = self.sdesc

    ldesc = "An old man; tall, gaunt, almost cadaverous, with a long
        white beard. His cloak is dark blue and he is leaning on a staff."

    actorDesc = {
        if (stone.isIn(Me))
            "Heliax watches you with a slightly worried expression. ";
	else
	    "Heliax is holding << stone.thedesc >>.";
    }
	
    hasspoken = nil

    touchdesc = {
        "Heliax recoils, startled. \"What on earth are you doing?\"";
    }
    
    appear = {
        self.moveInto(endgame);
        self.nodaemon := true;
        notify(self, &daemon, 0);
    }

    // This method is called when the player plays the whistle
    // in Heliax's presence
    musicresponse = {
        "Heliax winces. \"Stop that horrible noise at once!\"
	He points his staff at you, and makes a strange gesture.
	\^<< whistle.thedesc >> vanishes with a popping sound.
	\"That's much better.\"";
	self.nodaemon := true;
	whistle.moveInto(nil);
    }
    
    // This method is called when the player tries to break the
    // Stone
    breakStone(iobj) = {
        if (self.location = nil) {
	    "As you lift your hand with << stone.thedesc >>, you
	    hear a dry cough behind you.\n\"I wouldn't do that
	    if I were you.\"\b
	    You turn around to face an old man standing right 
	    behind you.\b
	    \"Perhaps I should introduce myself: Heliax, wizard of some
	    repute, and the owner of that << stone.sdesc >> you're handling
	    so carelessly. Better give it to me before there is an 
	    accident.\"";
	    self.appear;
	}
	else {
	    "You throw << stone.thedesc >> against << iobj.thedesc >> with
	    all your force. Heliax lifts his staff to stop you, but too
	    late: << stone.thedesc >> shatters into a myriad fragments.\b
	    There is a tremendous explosion - no, not an explosion, but
	    \(music\), music as from a thousand organs, playing a hundred
	    melodies at the same time: songs of triumph, victory, freedom, 
	    pure joy, all at once.\b";
	    ending2();
	}
    }

    // This method is called when the player tries to leave with
    // the Stone (or without it, once Heliax is alerted).
    leaving = {
        if (self.location = nil) {
	    "\"Now, just where do you think you are going, young man?\"
	    The voice is dry, as the crackling of old leaves.
	    \"You weren't thinking of stealing anything, were you?\"\b
	    You turn around and face an old man standing right behind you.
	    Where did he come from?\b
	    \"Perhaps I should introduce myself: Heliax, wizard of some
	    repute, and the owner of that << stone.sdesc >> you're carrying 
	    around.\" ";
	    self.appear;
	}
	else if (stone.isIn(Me)) {
	    "Heliax points his staff at you and mumbles a few syllables.
	    You find that you can't enter the doorway; an invisible 
	    force blocks your way. \"Perhaps you should return 
	    my << stone.sdesc >> before you leave.\" ";
	    self.nodaemon := true;
	}
	else {
	    "You start towards the exit, but Heliax waves you back.
	    \"You won't get out that way. Just wait a few seconds
	    and I'll show you a better exit.\"";
	    self.nodaemon := true;
	}
    }
    
    count = 0
    daemon = {
        if (self.nodaemon) {
	    self.nodaemon := nil;
	    return;
	}
	if (stone.isIn(Me))
            switch (++self.count) {
	        case 1:
	            "\b\"That << stone.sdesc >> you are carrying 
		    happens to be of great value to me. 
		    I'd be very grateful to have it back. Now.\"\n";
		    break;
	        case 2:
	            "\bHeliax sighs. \"Now, why don't you just return 
		    that << stone.sdesc >>, and I shall be happy to 
		    show you out.\"\n";
		    break;
	        case 3:
	            "\b\"You really should be careful 
		    with << stone.thedesc >>; it can be quite dangerous if 
		    you don't know how to handle it. Why don't you just 
		    give it to me instead?\"\n";
		    break;
                case 4:
	            "\bHeliax sighs. \"Very well.\" He points his staff at 
		    you and mumbles a few syllables. 
		    \^<< stone.thedesc >> flashes briefly, vanishes 
		    from your hand, and reappears in 
		    Heliax's. \"Thank you; there's a good boy.\"\n";
		    self.takestone;
		    break;
 	    }
	    else if (stone.isIn(endgame)) {
	        "\bHeliax looks at << stone.thedesc >>, smiles, and 
		points his staff at it. \^<< stone.thedesc >> vanishes 
		with a flash of light and reappears in his hand.\n";
		self.takestone;
	    }
    }

    daemon2 = {
        if (self.nodaemon) {
	    self.nodaemon := nil;
	    return;
	}
        switch (++self.count) {
	    case 1:
	        "\bHeliax looks into << stone.thedesc >> for a while,
		and then starts polishing it on his sleeve.\n";
		break;
	    case 2:
	        "\b\"Just a moment; I'll show you out in a minute.\"\n";
		break;
	    case 3:
	        "\bHeliax looks at you, then at << stone.thedesc >>, then 
		at you again. \"On second thought, we can't have you
		running around and telling everybody about me, can we?\"\b
		Quite slowly and carefully he
		pronounces a strange word: \"Queltuya\". 
		A bolt of incandescent white light shoots out 
		of << stone.thedesc >> and hits you straight between 
		your eyes.\n";
		die();
		break;
	}
    }
    
    actorAction(v, d, p, i) = {
        "Heliax ignores you.";
	exit;
    }

    verDoAskAbout(actor, io) = {
    }
    doAskAbout(actor, io) = {
        if (not stone.isIn(Me)) {
	    "Heliax doesn't seem to be listening.";
	    return;
	}
	
	self.nodaemon := true;
        switch (io) {
	    case aayela:
	        "\"Oh, that's a long story. We can talk about it 
		later, after you've given me my crystal back.\"";
		break;
	    case stone:
	        "\"It's mine, you know, and I'd like to have it back.\"";
		break;
	    default:
	        "\"We can talk about that later. First give 
		me << stone.thedesc >>.\"";
		break;
	}
    }
    
    verDoTellAbout(actor, io) = {
    }
    doTellAbout(actor, io) = {
        self.doAskAbout(actor, io);
    }
    
    ioGiveTo(actor, dobj) = { 
 	if (dobj = stone) {
	    "Heliax eagerly takes << dobj.thedesc >>, looking it over 
	    as if checking it for damage, polishing it on his sleeve. ";
	    self.nodaemon := true;
	    self.takestone;
	}
	else {
	    "A bit puzzled, Heliax looks at << dobj.thedesc >>,
	    and puts it in his pocket. \"Why, thank you!\" ";
	    self.nodaemon := true;
	    dobj.moveInto(self);
	}
    }	     

    ioThrowAt(actor, dobj) = {
        if (dobj = stone) {
            "Heliax deftly catches << dobj.thedesc >>. 
	    \"Careful - you might break it!\"";
	    self.takestone;
	}
	else {
	    "Heliax ducks, and << dobj.thedesc >> lands on the floor. ";
	    if (not stone.isIn(self)) {
	        "\"Stop that nonsense and 
		give me << stone.thedesc >>!\"";
		self.nodaemon := true;
	    }
	    dobj.moveInto(endgame); 
	}
    }
    
    verIoThrowTo(actor) = {
        self.verIoThrowAt(actor);
    }
    ioThrowTo(actor, dobj) = {
        self.ioThrowAt(actor, dobj);
    }

    verDoAttackWith(actor, io) = {
    }
    verDoAttack(actor) = {
    }
    
    doAttack(actor) = {
        "Heliax dodges your attack with surprising agility, lifts his
	staff, and brings it down on your head with a nasty,
	crunching sound.";
	die();
    }
    doAttackWith(actor, io) = {
        self.doAttack(actor);
    }
    
    // This method is called when Heliax acquires the stone
    takestone = {
        stone.moveInto(self);
	unnotify(self, &daemon);
	self.count := 0;
	notify(self, &daemon2, 0);
    }    
;    
	    
staff : item
    noun = 'staff' 'wand'
    sdesc = "staff"
    ldesc = "A rather narrow, oak staff, about six feet long."
    location = heliax
;

/*
 * Some vocabulary for asking questions
 */
vocab : thing
    noun = 'dargon' 'dahra'
    adjective = 'king' 'queen'
;    

aayela : Actor
    noun = 'aayela' 'spirit' 'angel'
    isHer = true
;    
    
/*
 * "Bad" ending: player kills Heliax
 */
ending1 : function
{
    "Your head is filled with music: a dark, violent melody of utmost 
    horror and disgust. The music only lasts for an instant; then it is
    gone and replaced by a feeling of almost infinite power. A
    bolt of white light shoots out from << stone.thedesc >> towards
    Heliax; as he collapses, screaming, you realize that the power
    of << stone.thedesc>>, Aayela's Stone, is yours to command; 
    that the spirit trapped in the crystal must follow your merest wish.\b
    
    You need only think of home, and you're there: in the middle of the
    throne room, where startled courtiers run off in all directions.
    A few well-aimed power bolts silence the wretches; then everybody
    shows proper respect for their new ruler.\b
    
    For who needs that old fool, king Dargon anymore, now that you have 
    returned in triumph, with the power to unite the country and smite
    its enemies? A touch of the Stone heals queen Dahra; then, after 
    marrying her, you ascend to the throne, the greatest ruler the
    Realm has ever known. The Stone of Aayela burns white in your 
    crown; shining silently with a cold, steady light.\b";
    
    more();
    
    "\bSometimes, at night, you are beset with doubts: was this really what
    was meant to happen? You think of the idealistic young knight who
    set out on his king's command, to cure his queen, so long ago; 
    you think of the people who have died because they stood in your way,
    the lies you have told, the king whom you deposed.\b
    But then you think of 
    how naive you used to be, and what you are now, and what
    you have achieved. Your enemies are dead, yes; but it was their own fault
    for opposing you. The old king is dead; but he was getting senile, a
    liability for the state. And you are happy now - you have everything you
    ever wanted: women, wealth, power.\b
    
    But you miss the music.\b\b";
    
    game_over();
}
    
    
/*
 * "Good" ending
 */
ending2 : function()
{
    "A luminous mist rises from the shattered crystal; slowly gathering
    together, solidifying into a humanoid figure, beautiful,
    shining like the sun, towering over the trembling wizard: Aayela,
    spirit of light, finally liberated from her crystalline prison.\b
    
    The music rises into a triumphant crescendo; Aayela approaches you,
    reaches out her hand towards you, touches you -";

    more(); 
        
    "\bAnd you are immersed in light, and music, and the light is music,
    and the music is the world. The entire earth lies before you:
    the bass notes of the mountains, the green arpeggios of the trees,
    the rhytm of the sea and the rivers, the steely timbre of the stars. 
    \bThe dark dissonance
    that is Heliax dissolves into individual notes, blending with
    other harmonies, becoming a part of the whole again. For a moment -
    or for an eternity - you are a part of the cosmic counterpoint,
    until you can hear the entire universe as a single chord, yet
    resolve every voice out of trillions.\b And all is light, and music,
    and the universe is light and the light is music.\b";
    
    more();
    
    "\bWhen you return home, it is without the Stone you were sent
    to fetch, but nobody mentions it; without saying anything,
    grieving courtiers show you into the Queen's presence. 
    The King looks up from his vigil, desperate
    hope in his eyes, but sees that you are empty-handed and looks
    away. Queen Dahra, however, quietly sits up in her bed and smiles
    at you, and her husband.\b
    
    Some people call the queen's recovery a miracle, others say that
    her illness has run its natural course; most of them take it for
    granted that you had nothing to do with it. The King, however, 
    as generous as ever, rewards you richly.\b
    
    But you do not care very much for glory or riches anyway, 
    now that you are carrying the light inside you,
    and the music.\b\b";
    game_over();
}
