! This file is for the storage of objects prefixed with the word 'CONTAINER'
! i.e. objects which can contain other objects.
! Most (but not all) containers have the attribute 'container'.

Class AGTObject	! To define AGT objects.
 with
  after
  [;
   Take: print_ret "You are now carrying ", (the)self, ".";
   Drop: print_ret "You drop ", (the)self, ".";
  ],
  before
  [;
   Eat, Kiss: print_ret "Eat ", (the)self, "? You must be kidding!";
   Attack: "It really would make more sense to specify a living creature. Hostility really requires a target of some sort.";
  ],
  key_to ROOM_Limbo
;

! A huge fish.
AGTObject CONTAINER_Fish "huge fish" ROOM_Theatre
 with
  after
  [;
   Eat:	! D'oh!
    move self to ROOM_Limbo;
    "You eat ", (the)self, ". Not bad.";	! D'OH!
   Open:	! <Eerie music...>
    print_ret (The)self, " opens easily in your hands. Inside ", (the)self, " there is a silver key.";
  ],
  description "The huge fish shines in the light. It gazes mournfully at your with its lidless eye. You notice a bulge in the fish's belly.",
  initial "A huge fish lies at your feet.",
  name "huge" "fish"
 has
  container
  edible	! So you can be stupid and eat the key too!
  openable
;

! The small book
AGTObject CONTAINER_Book "small book" ROOM_Study
 with
  before
  [;
   Lock:	! With the key from the fish!
    if (second.key_to==self && self hasnt locked && self hasnt open)
    {
     give self locked;
     "You lock the book with the key.";
    }
   Unlock:	! With the key from the fish!
    if (second.key_to==self && self has locked)
    {
     give self ~locked;
     "You unlock the book with the key.";
    }
  ],
  description "The small book has an old leather cover with faded Hebrew letters on the cover. The single word, when translated, means ~understanding,~ or ~recognition.~ The book is held closed by a small silver lock.",
  name "small" "book"
 has
  lockable
  locked
  openable
  scored
;