' "Haunted Horror"
' Created with QDK 3.53 - UNREGISTERED VERSION

define game <Haunted Horror>
	asl-version <350>
	gametype singleplayer
	start <Porch>
	game author <Matt Slotnick>
	game version <2.00 FINAL>
	game copyright <2005 Matt Slotnick>
	game info <Created with QDK 3.53 - UNREGISTERED EVALUATION VERSION.>
	startscript {
		msg <|s11Welcome to |bHaunted Horror|xb|s00|n|nThe story so far...|nYou pull up to a scary looking house on a dark and stormy night. You have gotten recent calls about mysterious happenings coming from this house and you were told by your boss to investigate. After all, you are a private eye investigator. So it makes sense to do your job. As you get out of your car, you look around, and something seems strange about this house...|n|nWhat is your name?>
		enter <Player>
		msg <Welcome, #Player#, your game will begin momentarily...>
		pause <1000>
	}
	command <open folder> if got <Folder> then {
		msg <You open the folder to review the record files of the house that you are investigating.|n|n|bFirst Recording|xb|nYear: 1977|nMonth/Day: October 12th|nFamily Name: Smith|nReport: A small family consisting of a mother, father, and a daughter lived in this house for 1 year. On October 12th, 1977, the family was reported as "missing". An investigation search went on for two months, and the family was never found again.>
		msg <|n|n|bSecond Recording|xb|nYear: 1991|nMonth/Day: June 14th|nFamily Name: Jones|nReport: A family consisting of a mother and two sons lived in this house for a year and half. On June 14th, 1991, the family was proved to be dead inside of the house. The reason for why is still unknown, and authorities say that they will probably never know why.>
		msg <|n|n|bThird Recording|xb|nYear: 2004|nMonth/Day: September 2nd|nFamily Name: Roberts|nReport: A family which only consisted of a widow lived in this house for 2 years. The report made on September 2nd, 2004 was that the widow went inside her house and a strange gas was inside, which eventually killed her. Authorities don't know where the gas came from.>
	}
	else msg <You do not have the folder in your posession.>
	command <read notebook> if got <Notebook> then {
		if ( %Notebook% = 0 ) then msg <You flip through the pages of the notebook and stop at some writing. It says:|n"What are the next two numbers?|n15-30-10-5-20|nThe next two numbers are the first code, enter it as (number)-(number)."> else msg <You flip through more pages of the notebook and more is written:|n"Green-Red-Blue-Orange-Black"|nWonder what it means?>
		inc <Notebook; 1>
	}
	else msg <You do not have the notebook in your posession.>
	command <Green-Red-Blue-Orange-Black> if got <Small Box> then {
		msg <You press the buttons on the small box and it pops open. Inside is a key.>
		move <Key; #quest.currentroom#>
	}
	else msg <Do you like saying colors randomly? Try getting a certain item first.>
	command <take key> if here <Key> then {
		msg <You pick it up.>
		give <Key>
		if ( %Score% = 0 ) or ( %Score% = 6 ) or ( %Score% = 7 ) or ( %Score% = 13 ) or ( %Score% = 20 ) then inc <Score; 5>
	}
	else msg <I can't see that anywhere.>
	command <switch 1> if got <Panel> then {
		msg <You flipped switch 1.>
		if ( %switch1% = 0 ) then {
			inc <switch1; 1>
			msg <Switch 1 is now on.>
		}
		else {
			dec <switch1; 1>
			msg <Switch 1 is now off.>
		}
	}
	else msg <What?>
	command <switch 2> if got <Panel> then {
		msg <You flipped switch 2.>
		if ( %switch2% = 0 ) then {
			inc <switch2; 1>
			msg <Switch 2 is now on.>
			if ( %switch2% = 1 ) and ( %switch2% = 1 ) then do <switch>
		}
		else {
			dec <switch2; 1>
			msg <Switch 2 is now off.>
		}
	}
	else msg <What?>
	command <switch 3> if got <Panel> then {
		msg <You flipped switch 3.>
		if ( %switch3% = 0 ) then {
			inc <switch3; 1>
			msg <Switch 3 is now on.>
			if ( %switch2% = 1 ) and ( %switch3% = 1 ) then do <switch>
		}
		else {
			dec <switch3; 1>
			msg <Switch 3 is now off.>
		}
	}
	else msg <What?>
	error <badcommand; What are you trying to do?>
	define variable <Score>
		type numeric
		value <0>
		display <Score:!%% Finished>
	end define
	define variable <Notebook>
		type numeric
		value <0>
	end define
	define variable <switch1>
		type numeric
		value <0>
	end define
	define variable <switch2>
		type numeric
		value <0>
	end define
	define variable <switch3>
		type numeric
		value <0>
	end define
end define

define synonyms
end define

define room <Porch>
	prefix <the front>
	look <You are standing on the front porch of the supposedly haunted house. There is a door infront of you with a doorbell next to it.>
	south <Car>
	command <ring doorbell> {
		msg <You ring the doorbell. A man inside the house opens the door and greets you.|n|n"Good evening, sir. You must be the detective that I have called for. Please, do come in. I hope this is not a bad time.">
		create exit north <Porch; Living Room>
	}

	define object <Door>
		look <The front door to the house.>
		speak <This door isn't voice-activated.>
		examine <The front door to the house.>
		article <it>
		gender <it>
	end define

end define

define room <Living Room>
	north <Main Hallway>
	south <Porch>
	east <East Hallway>
	west <Kitchen>
	command <give safe paper to man> if got <Paper2> then {
		msg <You show the man the paper from the safe. The man says, "Well, it appears you solved the safe mystery. Unfortunatly, I do not know the code to the second floor, looks like you will have to figure it out yourself.">
		inc <Score; 7>
		hide <Paper2>
	}
	else msg <You do not have that object.>

	define object <Man>
		look <The man who is in the house.>
		speak choose <Living Room>
		examine <The man who is in the house.>
		article <it>
		gender <he>
	end define

end define

define room <Car>
	look <You walked back to your car. There is a folder sitting on the passenger seat. It holds all the record files for this house.>
	indescription <You are in your:>
	north <Porch>

	define object <Folder>
		look <A folder containing all the record files to the house.>
		take
		speak <This folder doesn't speak.>
		examine <A folder containing all the record files to the house.>
		article <it>
		gender <it>
	end define

end define

define room <Kitchen>
	indescription <You are in the:>
	east <Living Room>
	northwest <Bedroom02>
end define

define room <Main Hallway>
	look <You walk into the Main Hallway of the house. There are pictures of people lined up on both sides of the hallway.>
	indescription <You are in the:>
	north <Family Room>
	south <Living Room>
	up <2nd Floor>
end define

define room <East Hallway>
	look <You are standing in the East Hallway. There are several paintings lined up on both sides of the hallway. The paintings are famous pieces of art.>
	indescription <You are in the:>
	west <Living Room>
	northeast <Bedroom01>
end define

define room <Bedroom01>
	alias <Guest Bedroom>
	look <You walk into a guest bedroom off of the east hallway. There is not much here, except for a bed and a table. A safe is bolted into the side of the wall.>
	indescription <You are in the:>
	southwest <East Hallway>
	command <2-50-7> {
		msg <You enter the code into the safe and it opens up. There is another piece of paper here.>
		move <Paper2; Bedroom01>
	}

	define object <Safe>
		look <Enter the code to open the safe.>
		speak <This safe does not speak.>
		examine <Enter the code to open the safe.>
		article <it>
		gender <it>
	end define

end define

define room <Family Room>
	look <From the Main Hallway, you walk into the Family Room. There is a TV in the corner infront of a couch and a chair.>
	indescription <You are in the:>
	south <Main Hallway>
	command <use cord on tv> if got <Cord> then {
		msg <You plug the TV in and it turns on. The TV is flashing a code. It says, "Put these numbers in order to solve the door code:|n4-8-1-9-3-10. Once you solve this, enter the numbers in the right order to open the door.">
		hide <Cord>
	}
	else msg <You do not have the cord.>

	define object <TV>
		look <A TV.>
		speak <This TV does not speak.>
		examine <A TV.>
		article <it>
		gender <it>
	end define

end define

define room <2nd Floor>
	look <You walk up the stairs to the 2nd floor. Unfortunatly, there is a door infront of you and it appears to be locked. There is a number pad next to the handle. Looks like you need to know the password to get in.>
	indescription <You are on the:>
	down <Main Hallway>
	command <1-3-4-8-9-10> {
		create exit north <2nd Floor; Wide Hallway>
		msg <You enter in the code and hear the door unlock.>
		if ( %Score% = 0 ) or ( %Score% = 7 ) then inc <Score; 6>
	}

	define object <Door2>
		alias <Door>
		look <A door with a number pad.>
		speak <This door does not speak.>
		examine <A door with a number pad.>
		article <it>
		gender <it>
	end define

end define

define room <Bedroom02>
	alias <Guest Bedroom>
	look <You walk into a guest bedroom off of the kitchen. Looks like this was used recently with the sheets all messed up. The people recently here looks like they left a piece of paper on the table.>
	indescription <You are in the:>
	southeast <Kitchen>
	script if here <Paper> then msg <> else move <Cord; Bedroom02>

	define object <Paper>
		look <The paper says, "Eth Odec ot het fesa si tow-tiffy-vesen.">
		take
		speak <This paper does not speak.>
		examine <The paper says, "Eth Odec ot het fesa si tow-tiffy-vesen.">
		article <it>
		gender <it>
	end define

end define

define room <Extra>

	define object <Paper2>
		alias <Safe Paper>
		look <This paper reads: "Kas hte uoshe epeekr hte odce ot eth sconde foorl nda ivge imh htis apper.">
		take
		speak <This paper does not speak.>
		examine <This paper reads: "Kas hte uoshe epeekr hte odce ot eth sconde foorl nda ivge imh htis apper.">
		article <it>
		gender <it>
	end define

	define object <Cord>
		look <A power cord.>
		take
		speak <This cord does not speak.>
		examine <A power cord.>
		article <it>
		gender <it>
	end define

	define object <Notebook>
		look <A notebook, wonder if anything is writtin inside?>
		take
		speak <This notebook does not talk.>
		examine <A notebook, wonder if anything is writtin inside?>
		article <it>
		gender <it>
	end define

	define object <Key>
		look <A small key.>
		take
		speak <This key does not speak.>
		examine <A small key.>
		article <it>
		gender <it>
	end define

	define object <Panel>
		look <A panel with 3 switches on it. To turn the switches, type [switch 1] to flip switch 1, type [switch 2] to flip switch 2 or type [switch 3] to flip switch 3.>
		take
		speak <This panel does not speak.>
		examine <A panel with 3 switches on it. To turn the switches, type [switch 1] to flip switch 1, type [switch 2] to flip switch 2 or type [switch 3] to flip switch 3.>
		article <it>
		gender <it>
	end define

	define object <Answer Sheet>
		look <Take this sheet and run!>
		take
		gain set numeric <Score; 99>
		speak <RUN!!!>
		examine <Take this sheet and run!>
		article <it>
		gender <it>
	end define

end define

define room <Wide Hallway>
	look <You open the door and find youself in a wide hallway upon the second floor. There are 3 doors infront of you. Wonder where they lead to?>
	indescription <You are in the:>
	north <room03>
	south <2nd Floor>
	east <room02>
	west <room01>
end define

define room <room01>
	alias <Storage Closet>
	look <You open the door to find that it is a storage closet. Searching the shelves might find something useful?>
	indescription <You are standing infront of a:>
	east <Wide Hallway>
	command <search shelves> if got <Notebook> then msg <You search the shelves and find nothing of interest.> else {
		msg <You search the shelves and find a notebook!>
		give <Notebook>
	}
end define

define room <room02>
	alias <Master Bathroom>
	look <You open the door to the master bathroom. There is a sink and a toilet next to each other. A shower is on the opposite side of the room. A smaller door is infront of you on the other wall that appears to be locked.>
	indescription <You are in the:>
	west <Wide Hallway>
	command <35-15> {
		msg <You enter the code and the door unlocks.>
		create exit east <room02; 1st Chamber>
		if ( %Score% = 0 ) or ( %Score% = 6 ) or ( %Score% = 7 ) or ( %Score% = 13 ) or ( %Score% = 18 ) or ( %Score% = 11 ) then inc <Score; 7>
	}
end define

define room <room03>
	alias <Master Bedroom>
	look <You step into the master bedroom. Not a lot here, only a bed and a nightside table. On top of the table is a small box.>
	indescription <You are in the:>
	south <Wide Hallway>

	define object <Small Box>
		look <A small box with 5 buttons on top, the colors of Black, Blue, Orange, Green, and Red.>
		take
		speak <This box does not speak.>
		examine <A small box with 5 buttons on top, the colors of Black, Blue, Orange, Green, and Red.>
		article <it>
		gender <it>
	end define

end define

define room <1st Chamber>
	look <You walk through the door to find another, again locked, door. Looks like you need the key.>
	indescription <You are in the:>
	west <room02>
	command <use key> if got <Key> then {
		msg <You unlock the door with the key and it leads into another passage way.>
		create exit north <1st Chamber; 2nd Chamber>
	}
	else msg <You do not have a key.>
end define

define room <2nd Chamber>
	south <1st Chamber>
	description {
		if ( %Score% = 13 ) or ( %Score% = 20 ) or ( %Score% = 14 ) or ( %Score% = 18 ) or ( %Score% = 25 ) then inc <Score; 9>
		msg <You are in the |cr2nd Chamber|cb.|nYou can go |bsouth|xb.|nYou open the door to find yourself in the second chamber. There is yet another door and it is, of course, locked. There is an inscription upon the wall.>
	}
	command <look at wall> msg <You look at the inscription upon the wall. It says:|n"To open this door, solve the riddle.|nWhat's 42+86 halfed divided by 8? Your answer is the first number.|nIf half of the kreeks are krooks and half of the krooks are kraaks and a quarter of the kraaks are kruuks, how many kreeks are kruuks? Times your answer by 100 and round. This number is the second number.|nEnter your code as (number)-(number)">
	command <8-6> {
		msg <You enter in the code and the door unlocks.>
		create exit west <2nd Chamber; 3rd Chamber>
	}
end define

define room <3rd Chamber>
	alias <Final Chamber>
	east <2nd Chamber>
	description {
		if ( %Score% = 25 ) or ( %Score% = 29 ) or ( %Score% = 27 ) or ( %Score% = 34 ) then inc <Score; 10>
		msg <You are in the |crFinal Chamber|cb.|nYou can go |beast|xb.|nYou walk inside the final chamber. The final door is infront of you. Find the answer to open the door. Another inscription is on the wall.>
	}
	command <look at wall> msg <An inscription is writtin upon this wall. It says:|n"Round the square root of all the code numbers added up. This number is your answer.">
	command <13> {
		msg <You enter in the final code and the door unlocks.>
		create exit north <3rd Chamber; Staircase>
	}
end define

define room <Staircase>
	north <Attic>
	south <3rd Chamber>
	description {
		if ( %Score% = 34 ) or ( %Score% = 35 ) or ( %Score% = 39 ) or ( %Score% = 37 ) or ( %Score% = 44 ) then inc <Score; 18>
		msg <You are on the |crStaircase|cb.|nYou can go |bsouth|xb or |bnorth|xb.|nYou open the door and find yourself standing infront of a staircase. I wonder where they lead to?>
	}
end define

define room <Attic>
	look <You walk up the staircase and find yourself in the attic. There are a couple of chests here and some old raggedy clothes.>
	indescription <You are in the:>
	south <Staircase>
	command <open chests> msg <Which one?>
	command <open chest 1> msg <You open the chest and search through it. Unfortunatly, there doesn't seem to be anything in it.>
	command <open chest 2> msg <You open the chest and search through it. Unfortunatly, there doesn't seem to be anything in it.>
	command <open chest 3> {
		msg <You open the chest and search through it. You find a panel inside with 3 different switches on it. I wonder what each switch does?>
		move <Panel; Attic>
		set numeric <Score; 80>
	}

	define object <Chest 1>
		look <An old dusty chest.>
		speak <This chest does not speak.>
		examine <An old dusty chest.>
		article <it>
		gender <it>
	end define

	define object <Chest 2>
		look <An old dusty chest.>
		speak <This chest does not speak.>
		examine <An old dusty chest.>
		article <it>
		gender <it>
	end define

	define object <Chest 3>
		look <An old dusty chest.>
		speak <This chest does not speak.>
		examine <An old dusty chest.>
		article <it>
		gender <it>
	end define

end define

define room <Secret Room>
	look <You walk inside the room, and there is a notice on the table. I wonder what it says?>
	indescription <You are in the:>
	west <Attic>

	define object <Notice>
		take {
			timeron <Notice>
			msg <You have |b13|xb seconds to escape this house before it self destructs.>
			move <Answer Sheet; Secret Room>
		}
		article <it>
		gender <it>
	end define

end define

define procedure <switch>
	if ( %switch3% = 1 ) and ( %switch2% = 1 ) then {
		msg <As you turn the switch on, you hear a slow rumble. The wall next to you begins to slide to the right, revealing a secret room!>
		create exit east <Attic; Secret Room>
		set numeric <Score; 87>
	}
	
end define

define timer <Notice>
	interval <13>
	action if got <Answer Sheet> then {
		playerwin
		set numeric <Score; 100>
		timeroff <Notice>
	}
	else {
		playerlose
		timeroff <Notice>
	}
	disabled
end define

define text <intro>

end define

define text <win>
You leap out of the house just as it explodes into smitherines. You run to your car to call the police, but you find a small note on your dashboard. It says:

"Nice job, you escaped your doom. But not for long!"

|bGAME OVER - YOU WIN|xb
end define

define text <lose>
The house explodes into smitherines and unfortunatly, you are too close to it! You get hit multiple times by pieces of brick and cement. They knock you unconscious. By the time the police get there, they announce you dead at the scene.

Here's a hint: Did something appear when you tried to take the notice?

|bGAME OVER - YOU LOSE|xb

end define

define selection <Living Room>
	info <How can I help you sir?>
	choice <Who are you?> msg <"I am the owner of this land that this house is upon. I am very concerned with the recent reports that have come out of this house. I am concerned that no one will want to live in such a house with all of these killing reports.">
	choice <Can you brief me on the report?> msg <"Why certainly sir. Most of the reports, which I am sure you have been briefed upon, have consisted of people being killed or have gone missing inside of this house. Most of the reports are very strange and we can not figure out what has happened to these families or what has caused them to be killed. The authorities can not find many clues, and since there were no people here during the time of the killings, it is harder to get critical information.">
	choice <What should I be looking for?> msg <"Well, sir, you are a detective, shouldn't you know that yourself? I guess you could be looking for anything mysterious, or something that really seems out of the ordanary.">
end define

