COMMAND ANY
NewLife
SetVariableTo 1 6           (*Initialize laser pistol*)
PrintMessage 85             (*Lost your key*)
BlankLine
END_COMMAND

COMMAND ANY
Present 302                 (*If the Robot is here...*)
RandomMessage 70 79         (*He spouts a Floydism*)
BlankLine
END_COMMAND

COMMAND ANY
Present 301                 (*If Jody is here...*)
NOT IsWearingSomething      (*and you're naked...*)
PrintMessage 59             (*she screams and faints*)
SwapLocations 301 297       (*Replace Jody with unconscious Jody*)
DoneWithTurn
END_COMMAND

COMMAND ANY
CounterEquals 1 3           (*Two turns after murdering Jody...*)
PrintMessage 58             (*Stricken with remorse, you kill yourself*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 84               (*Power Core*)
Present 205                 (*Rock*)
PrintMessage 52             (*Rock is glowing*)
BlankLine
END_COMMAND

COMMAND ANY
NOT Present 300             (*No Monsters here*)
NOT AtLocation 77           (*Not in galley*)
FlagOFF 9                   (*Before takeoff*)
FlagOFF 10                  (*Force Field Off*)
TurnsGT 20                  (*After Turn 20*)
Chance 10                   (*10% Chance*)
PutInCurrentRoom 300
PrintMessage 46             (*Creature rushes in*)
BlankLine
END_COMMAND

COMMAND ANY
AtLocation 71               (*Airlock*)
FlagON 9                    (*Ship in Space*)
FlagOFF 4                   (*Outer door open*)
PrintMessage 40             (*You get sucked out into space*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagON 9                    (*Ship in Space*)
FlagOFF 3                   (*Inner door open*)
FlagOFF 4                   (*Outer door open*)
PrintMessage 39             (*You get sucked out into space*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND ANY
Present 301                 (*Jody here*)
IsCarrying 213              (*Holding Lettuce*)
VerbIsDirection             (*If you try to leave...*)
DropIt 213
PrintMessage 61             (*Jody takes the lettuce*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND HELP
MinusScore 1                (*Lose a point for using help*)
END_COMMAND

COMMAND SCREAM
PrintMessage 86             (*You practice wailing*)
DoneWithTurn
END_COMMAND

COMMAND WEAR ANY
IsWearingSomething          (*If you're wearing something...*)
NOT NOUNIsNumber 206        (*But not the Jetpack...*)
PrintMessage 54             (*You can't wear multiple outfits*)
DoneWithTurn
END_COMMAND

COMMAND SOUTH
AtLocation 72               (*If you're on the Bridge...*)
FlagOFF 5                   (*And the Elevator is on the lower level*)
PrintMessage 84             (*You can't go south*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND NORTHEAST
AtLocation 72               (*On the Bridge...*)
FlagON 3                    (*And the inner door is closed...*)
PrintMessage 92             (*You can't go that way*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND NORTHEAST
AtLocation 71               (*In the airlock...*)
FlagON 4                    (*And the outer door is closed...*)
PrintMessage 92             (*You can't go that way*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND SOUTHWEST
AtLocation 2                (*At the campsite...*)
FlagON 4                    (*And the outer door is closed...*)
PrintMessage 92             (*You can't go that way*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND SOUTHWEST
AtLocation 71               (*In the airlock...*)
FlagON 3                    (*And the inner door is closed...*)
PrintMessage 92             (*You can't go that way*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND SHOOT CREATURE
Present 300                 (*Monster here*)
IsCarrying 210              (*You've got the laser...*)
VariableLT 1 1              (*But it's empty...*)
PrintMessage 48             (*CLICK!*)
KillPlayer                  (*And you're out of there*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ANY
IsCarrying 210              (*You have the laser...*)
VariableLT 1 1              (*And it's empty...*)
PrintMessage 50             (*CLICK!*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ROBINSON
Present 301                 (*Jody's here...*)
IsCarrying 210              (*And you've got the gun...*)
VariableGT 1 0              (*And it's got some juice...*)
DestroyNOUN                 (*Jody dies (you fiend!)*)
SubtractFromVariable 1 1    (*Subtract one shot*)
Tone 440 1000               (*Make a keen sound*)
TurnCounterON 1             (*Turn on remorse counter*)
PrintMessage 57             (*Jody dies*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ROBINSON
Present 297                 (*Unconscious Jody here...*)
IsCarrying 210              (*And you have the gun...*)
VariableGT 1 0              (*And it ain't empty...*)
DestroyNOUN                 (*Jody dies (you fiend!)
SubtractFromVariable 1 1    (*Subtract one shot*)
Tone 440 1000               (*Make a keen sound*)
TurnCounterON 1             (*Turn on remorse counter*)
PrintMessage 60             (*Shoot Jody on the floor*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ROBOT
Present 302                 (*Robot is here...*)
IsCarrying 210              (*And you've got the gun...*)
VariableGT 1 0              (*And it has juice...*)
PrintMessage 69             (*Robot outdraws you...*)
KillPlayer                  (*So you die*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT CREATURE
Present 300                 (*Creature is here...*)
IsCarrying 210              (*You've got the gun...*)
VariableGT 1 0              (*It's got juice...*)
DestroyNOUN                 (*ZAP the creature...*)
SubtractFromVariable 1 1    (*Subtract one shot...*)
Tone 440 1000               (*Make a keen sound*)
PrintMessage 47             (*Creature destroyed*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT LASER
IsCarrying 210              (*You've got the gun...*)
VariableGT 1 0              (*And it's got juice...*)
DestroyNOUN                 (*The gun shoots itself?!*)
PrintMessage 51             (*Nyahh, Nyahh message*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ANY
IsCarrying 210              (*You've got the gun...*)
NOUNIsMovable               (*What you're zapping is movable or heavy*)
  OR
NOUNweightGT 98
DestroyNOUN                 (*ZAP what you're shooting at*)
Tone 440 1000               (*Make a keen sound*)
SubtractFromVariable 1 1    (*Subtract one shot*)
PrintMessage 56             (*The object is destroyed*)
DoneWithTurn
END_COMMAND

COMMAND SHOOT ANY
IsCarrying 210              (*You've got the gun...*)
VariableGT 1 0              (*Its got juice...*)
PrintMessage 49             (*Can't shoot objects that are in Room Desc*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE VIEWPORT
AtLocation 72               (*On the Bridge...*)
FlagOFF 9                   (*Ship on the ground...*)
PrintMessage 1              (*You see the landscape*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE VIEWPORT
AtLocation 72               (*On the Bridge...*)
FlagON 9                    (*After takeoff*)
PrintMessage 2              (*You see a starfield*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocationGT 70             (*If you can see the airlock...*)
AtLocationLT 73
FlagON 3                    (*And Inner Airlock Door is closed...*)
PrintMessage 3              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocationGT 70             (*If you can see the airlock...*)
AtLocationLT 73
FlagON 4                    (*And Outer Airlock Door is closed...*)
PrintMessage 4              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocationGT 70             (*If you can see the airlock...*)
AtLocationLT 73
FlagOFF 3                   (*And Inner Airlock Door is Open...*)
PrintMessage 5              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocationGT 70             (*If you can see the airlock...*)
AtLocationLT 73
FlagOFF 4                   (*And Outer Airlock Door is Open...*)
PrintMessage 6              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocation 2                (*At the campsite*)
FlagON 3                    (*Inner Airlock Door Closed*)
PrintMessage 3              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocation 2                (*At the campsite*)
FlagON 4                    (*Outer Airlock Door Closed*)
PrintMessage 4              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocation 2                (*At the campsite*)
FlagOFF 3                   (*Inner Airlock Door Open*)
PrintMessage 5              (*Game tells you so*)
END_COMMAND

COMMAND EXAMINE AIRLOCK
AtLocation 2                (At the campsite*)
FlagOFF 4                   (*Outer Airlock Door Open*)
PrintMessage 6              (*Game tells you so*)
END_COMMAND

COMMAND ACTIVATE JETPACK
NOT IsWearing 206           (*If you aren't wearing the jetpack...*)
PrintMessage 9              (*The game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
AtLocationGT 5              (*If you're indoors...*)
IsWearing 206               (*And wearing the jetpack...*)
PrintMessage 14             (*You get rammed into the bulkhead *)
KillPlayer                  (*Bye bye*)
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
Present 206                 (*Jetpack here*)
FlagON 10                   (*If the Force Field is on...*)
PrintMessage 45             (*You ram it*)
KillPlayer                  (*OOPS!*)
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
FlagOFF 6                   (*If you haven't found the drillsite...*)
Present 206
PrintMessage 8              (*You can't go there*)
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
NOT IsWearing 204           (*If you're not wearing the spacesuit...*)
PrintMessage 55             (*It's too cold to fly*)
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
AtLocation 2                (*If you're at the campsite...*)
IsWearing 206               (*And wearing the jetpack...*)
FlagON 6                    (*And you've found the Jetpack
GoToRoom 3                  (*You go to the drillsite*)
PrintMessage 7              (*Game tells you so*)
BlankLine
DoneWithTurn
END_COMMAND

COMMAND ACTIVATE JETPACK
AtLocation 3                (*If you're at the drillsite...*)
GoToRoom 2                  (*You return to the campsite*)
PrintMessage 10
BlankLine
DoneWithTurn
END_COMMAND

COMMAND EXAMINE PROJECTOR
AtLocation 2                (*If you're at the campsite...*)
FlagOFF 10                  (*And the projector is off...*)
PrintMessage 42             (*The game tells you so*)
END_COMMAND

COMMAND EXAMINE PROJECTOR
AtLocation 2                (*If you're at the campsite...*)
FlagON 10                   (*And the projector is on...*)
PrintMessage 43             (*The game tells you so*)
END_COMMAND

COMMAND ACTIVATE PROJECTOR
AtLocation 2                (*If you're at the campsite...*)
FlagOFF 10                  (*And the projector is off...*)
TurnFlagON 10               (*It comes on...*)
PrintMessage 41             (*And the game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND DEACTIVATE PROJECTOR
AtLocation 2                (*If you're at the campsite...*)
FlagON 10                   (*And the projector is on...*)
TurnFlagOFF 10              (*It goes off...*)
PrintMessage 44             (*And the game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND USE SCOPE
ReDirectTo EXAMINE SCOPE
END_COMMAND

COMMAND EXAMINE SCOPE
AtLocation 72               (*If you're on the Bridge...*)
FlagON 9                    (*After liftoff...*)
PrintMessage 53             (*You see stars*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE SCOPE
AtLocation 72               (*If you're on the Bridge...*)
FlagOFF 6                   (*And haven't found the drillsite yet...*)
TurnFlagON 6                (*You find it...*)
PrintMessage 11             (*And the game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE SCOPE
AtLocation 72               (*If you're on the Bridge...*)
FlagON 6                    (*And you've already found the drillsite...*)
PrintMessage 35             (*You see the Rob-&-Sons returning*)
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 3
ReDirectTo START RIG
END_COMMAND

COMMAND START RIG
AtLocation 3                (*At Drillsite*)
IsLocated 209 255           (*Empty Bottle in the Rig*)
SwapLocations 209 212       (*Replace Empty Bottle With Full*)
PrintMessage 89             (*The Bottle is now full*)
DoneWithTurn
END_COMMAND

COMMAND START RIG
AtLocation 3                (*Drillsite*)
PrintMessage 90             (*Dutronium spills on ground*)
DoneWithTurn
END_COMMAND

COMMAND FILL BOTTLE
AtLocation 3                (*If you're at the drillsite...*)
Present 253                 (*And the dutronium pool is here...*)
IsCarrying 209              (*And you've got the empty bottle...*)
SwapLocations 209 212       (*You fill it up*)
PrintMessage 12
DoneWithTurn
END_COMMAND

COMMAND PUT FUEL IN CORE
ReDirectTo POUR FUEL
END_COMMAND

COMMAND PUT ANY IN CORE
AtLocation 84               (*Power Core*)
NOT NOUNIsNumber 212        (*Not the full bottle*)
DestroyNOUN
PrintMessage 88             (*Item incinerated*)
DoneWithTurn
END_COMMAND

COMMAND POUR FUEL
AtLocation 84               (*If you're at the Power Core...*)
IsCarrying 212              (*With a bottle full of fuel...*)
SwapLocations 212 209       (*The bottle empties...*)
TurnFlagON 1                (*And the fuel tank fills*)
PrintMessage 13
DoneWithTurn
END_COMMAND

COMMAND POUR FUEL
NOT AtLocation 84           (*Not in Power Core*)
IsCarrying 212              (*Got the full bottle*)
SwapLocations 212 209       (*Swap with empty bottle*)
PrintMessage 91             (*You pour it on the ground*)
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 75               (*Elevator*)
FlagOFF 5                   (*Elevator on bottom*)
ChangePassageway 1 72       (*North to bridge*)
GoToRoom 72                 (*Bridge*)
ChangePassageway 2 75       (*South from Bridge to Elevator*)
GoToRoom 76                 (*Lower Deck*)
ChangePassageway 2 74       (*South from Lower Deck to Shaft*)
GoToRoom 75                 (*Back to Elevator*)
TurnFlagON 5                (*Elevator now on top*)
PrintMessage 82             (*Elevator Rises*)
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 75               (*Elevator*)
FlagON 5                    (*Elevator on top*)
ChangePassageway 1 76       (*North to Lower Deck*)
GoToRoom 72                 (*Bridge)
ChangePassageway 2 0        (*South from Bridge leads nowhere*)
GoToRoom 76                 (*Lower Deck*)
ChangePassageway 2 75       (*South from Lower Deck to Elevator*)
GoToRoom 75                 (*Back to Elevator*)
TurnFlagOFF 5               (*Elevator now on bottom*)
PrintMessage 83             (*Elevator goes down*)
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 86               (*In the Freezing Tube...*)
FlagOFF 9                   (*Before liftoff...*)
PrintMessage 15             (*Marine finds you*)
EndGame
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 86               (*In the Freezing Tube...*)
FlagON 9                    (*After liftoff...*)
FlagOFF 7                   (*But didn't set the course...*)
PrintMessage 16             (*You're Lost in Space*)
EndGame
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 86              (*Freezing Tube*)
FlagON 9                   (*In Space*)
FlagON 7                   (*Course Set*)
PrintMessage 17            (*Win the game*)
WaitForReturn
PrintMessage 34
PlusScore 1
WinGame
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 2               (*Campsite*)
FlagOFF 4                  (*Outer door open*)
ChangePassageway 8 0 
PrintMessage 18            (*Outer door closes*)
TurnFlagON 4
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 2              (*Campsite*)
FlagON 4                  (*Outer Door Closed*)
ChangePassageway 8 71
PrintMessage 19           (*Outer door opens*)
TurnFlagOFF 4
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 71             (*In the Airlock*)
FlagOFF 4                 (*Outer Door Open*)
ChangePassageway 5 0
PrintMessage 18           (*Outer door closes*)
TurnFlagON 4
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 71            (*Airlock*)
FlagON 4                 (*Outer Door Closed*)
ChangePassageway 5 2
PrintMessage 19          (*Outer door opens*)
TurnFlagOFF 4
DoneWithTurn
END_COMMAND

COMMAND TURN KNOB
AtLocation 72            (*Control Room*)
FlagOFF 5                (*Elevator down*)
ChangePassageway 2 75    (*Can now walk south to elevator*)
GoToRoom 76              (*Lower Deck*)
ChangePassageway 2 74    (*Lower deck South now leads to shaft*)
GoToRoom 75              (*Elevator*)
ChangePassageway 1 72    (*North now leads to Bridge*)
GoToRoom 72              (*Back to the Bridge*)
PrintMessage 80          (*The elevator is now here*)
TurnFlagON 5
DoneWithTurn
END_COMMAND

COMMAND TURN KNOB
AtLocation 72            (*In the Control Room...*)
FlagON 5                 (*And the elevator is already here...*)
PrintMessage 81          (*The game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 76            (*If you're on the Lower Deck...*)
FlagOFF 5                (*And the elevator is already here...*)
PrintMessage 81          (*The game tells you so*)
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 76            (*Lower Deck)
FlagON 5                 (*Elevator on top*)
PrintMessage 80          (*Elevator is now here*)
ChangePassageway 2 75    (*South leads to elevator again*)
GoToRoom 72              (*Bridge)
ChangePassageway 2 0     (*Can't go south from Bridge now*)
GoToRoom 75              (*Elevator*)
ChangePassageway 1 76    (*North leads to lower deck again*)
GoToRoom 76              (*Back to the Lower Deck*)
TurnFlagOFF 5
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 72            (*Control Room*)
FlagOFF 4                (*Outer Door Open*)
GoToRoom 71
ChangePassageway 5 0     (*Outer door closes*)
GoToRoom 72
PrintMessage 18
TurnFlagON 4
DoneWithTurn
END_COMMAND

COMMAND PUSH BUTTON
AtLocation 72            (*Control Room*)
FlagON 4                 (*Outer door closed*)
GoToRoom 71
ChangePassageway 5 2     (*Outer door opens*)
GoToRoom 72
PrintMessage 19
TurnFlagOFF 4
DoneWithTurn
END_COMMAND

COMMAND PULL BUTTON
AtLocation 71            (*Airlock*)
FlagOFF 3                (*Inner Door Open*)
ChangePassageway 8 0     (*It closes*)
PrintMessage 20
TurnFlagON 3
DoneWithTurn
END_COMMAND

COMMAND PULL BUTTON
AtLocation 71            (*Airlock*)
FlagON 3                 (*Inner Door Closed*)
ChangePassageway 8 72    (*It opens*)
PrintMessage 21
TurnFlagOFF 3
DoneWithTurn
END_COMMAND

COMMAND PULL BUTTON
AtLocation 72            (*Control Room*)
FlagOFF 3                (*Inner Door Open*)
ChangePassageway 5 0     (*It closes*)
PrintMessage 20
TurnFlagON 3
DoneWithTurn
END_COMMAND

COMMAND PULL BUTTON
AtLocation 72            (*Control Room*)
FlagON 3                 (*Inner door closed*)
ChangePassageway 5 71    (*It opens*)
PrintMessage 21
TurnFlagOFF 3
DoneWithTurn
END_COMMAND

COMMAND EXAMINE PANEL
AtLocation 72            (*Control Room*)
FlagOFF 1                (*Tank is empty*)
PrintMessage 22          (*Game tells you*)
DoneWithTurn
END_COMMAND

COMMAND EXAMINE PANEL
AtLocation 72            (*Control Room*)
FlagON 1                 (*Tank is full*)
PrintMessage 23          (*Game tells you*)
DoneWithTurn
END_COMMAND

COMMAND LAUNCH
ReDirectTo PULL SWITCH
END_COMMAND

COMMAND PULL SWITCH
AtLocation 73            (*Space Pod *)
PrintMessage 36          (*Space Pod doesn't work*)
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagON 9                (*Already in space*)
PrintMessage 24         (*Game tells you*)
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the bridge*)
FlagOFF 1               (*But no gas*)
PrintMessage 25         (*You don't liftoff*)
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagOFF 12              (*Robot Still Working*)
PrintMessage 68         (*Robot stops you*)
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagON 1                (*Fuel Tank full*)
FlagON 10               (*Force Field On*)
PrintMessage 26         (*Ship rams force field*)
EndGame
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagON 1                (*Ship Fueled*)
FlagOFF 10              (*Force Field*)
FlagOFF 3               (*Inner airlock open*)
FlagOFF 4               (*Outer airlock open*)
PrintMessage 28         (*Player Suffocated*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagOFF 11              (*Jody still here*)
IsSomewhere 301
  OR
IsSomewhere 297
PrintMessage 64         (*Can't leave with Jody here*)
DoneWithTurn
END_COMMAND

COMMAND PULL SWITCH
AtLocation 72           (*On the Bridge*)
FlagON 1                (*Ship fueled*)
FlagOFF 10              (*Force Field*)
PrintMessage 29         (*Liftoff*)
TurnFlagON 9
DoneWithTurn
END_COMMAND

COMMAND SET ASTROGATOR
ReDirectTo ENTER COURSE
END_COMMAND

COMMAND ENTER COURSE
NOT AtLocation 72       (*Not on Bridge*)
PrintMessage 30         (*You can't set course*)
DoneWithTurn
END_COMMAND

COMMAND ENTER COURSE
FlagOFF 2               (*Chartbook hasn't been read*)
PrintMessage 31         (*You don't know the course*)
DoneWithTurn
END_COMMAND

COMMAND ENTER COURSE
PrintMessage 32
TurnFlagON 7            (*Course is entered*)
DoneWithTurn
END_COMMAND

COMMAND ENTER COURSE
FlagON 7                (*You've already done it*)
PrintMessage 33
DoneWithTurn
END_MESSAGE

COMMAND READ BOOK
IsCarrying 208
TurnFlagON 2
END_COMMAND

COMMAND USE RADIO
FlagOFF 9               (*Pre-liftoff*)
PrintMessage 37         (*Bill Rob-&-Son answers*)
DoneWithTurn
END_COMMAND

COMMAND USE RADIO
FlagON 9                (*After liftoff*)
PrintMessage 38         (*Just static*)
DoneWithTurn
END_COMMAND

COMMAND ANY
AtLocation 71           (*In Airlock*)
FlagON 9                (*Pre-liftoff*)
FlagOFF 4               (*Outer door open*)
PrintMessage 40         (*You get sucked out into space*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND ANY
FlagON 9                (*After liftoff*)
FlagOFF 3               (*Inner door open*)
FlagOFF 4               (*Outer door open*)
PrintMessage 39         (*You get sucked out into space*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND EAT LETTUCE
Present 301             (*Jody is here*)
DestroyNOUN             (*Bye bye lettuce*)
SendToRoom 301 0        (*Jody goes for more*)
TurnFlagON 11           (*Jody has left the ship*)
PrintMessage 62
BlankLine
DoneWithTurn
END_COMMAND

COMMAND KISS ANY
Present 301             (*Jody here*)
NOUNIsCreature
PrintMessage 63         (*She kills you*)
KillPlayer
DoneWithTurn
END_COMMAND

COMMAND ASK JODY ABOUT ANY
Present 301
PrintMessage 65
DoneWithTurn
END_COMMAND

COMMAND ASK ROBOT ABOUT ANY
Present 302              (*Robot is here
PrintMessage 66          (*He gives you a Smart-alec reply*)
DoneWithTurn
END_COMMAND

COMMAND TAKE PACK
Present 302              (*Working robot*)
SwapLocations 302 298    (*Swap working robot with deactivated one*)
TurnFlagON 12            (*Robot is deactivated*)
PrintMessage 67          (*Robot goes off*)
END_COMMAND

COMMAND TURN ON ANY
PrintMessage 87          (*Don't say TURN ON, say START*)
DoneWithTurn
END_COMMAND

COMMAND TURN OFF ANY
PrintMessage 87          (*Don't say TURN OFF, say STOP*)
DoneWithTurn
END_COMMAND
