1 REM *** The Quest for Waitomo Cave (Version 1.04)            ***
2 REM *** Written in: BLASSIC 0.8.1                            ***
3 REM *** Homepage: http://www.geocities.com/dunric/quest.html ***
4 REM *** Author: Paul Allen Panks (dunric@yahoo.com)          ***
5 COLOR 15,1:CLS
6 COLOR 15,1:PRINT "The Quest for Waitomo Cave ";:COLOR 7,1:PRINT"(Version 1.04)"
7 COLOR 10,1:PRINT "By Paul Panks (dunric@yahoo.com)"
8 COLOR 11,1:PRINT "Written in BLASSIC 0.8.1"
9 PRINT:GOSUB 3200
10 COLOR 7,1:PRINT "The Waitomo Caves, nestled in the country of New Zealand, were"
11 PRINT"formed over 30 million years ago. You first heard about the caves from"
12 PRINT"your grandfather, who was a periodic explorer of the famous caves.":PRINT
13 PRINT"You became fascinated by his stories of The Ghost Walk, Bridal Chamber and"
14 PRINT"Mirror Pool. He even mentioned the existence of The Glowworm, a species"
15 PRINT"of insect which glowed internally in order to attract food. Combined with"
16 PRINT"further stories of underground streams and fossilized shells, your"
17 PRINT"desire became exploring these caves.":PRINT
18 PRINT"Your goal in this game is to fully explore these caves, and to uncover"
19 PRINT"as much treasure (or other objects) before the air becomes too foul"
20 PRINT "to support your spelunkering adventures.":PRINT
21 COLOR 14,1:PRINT "Press any key to begin playing...":DIM lo(75),no$(75),ob$(75),mh(75),m(250,6),vb$(25),wd$(10):GOSUB 2500
22 a$=INKEY$:IF a$="" THEN GOTO 22
23 COLOR 15,1:CLS:COLOR 11,1:PRINT"Check for Saved Game":PRINT:COLOR 15,1
24 PRINT "Are you playing a saved game (y/n)?";
25 a$=INKEY$:IF a$="" THEN GOTO 25
26 IF a$="y" OR a$="Y" THEN PRINT " Yes":GOTO 30
27 IF a$="n" OR a$="N" THEN PRINT " No":GOTO 50
28 GOTO 25
30 PRINT:COLOR 7,1:PRINT "Enter name of saved game to load: ";:COLOR 11,1:INPUT "",na$
31 COLOR 14,1:PRINT "Loading ";na$;"...";
32 OPEN na$+".sav" FOR INPUT AS #1
33 INPUT#1,na$:INPUT#1,rm:INPUT#1,ic:INPUT#1,hp:INPUT#1,hm:INPUT#1,mp:INPUT#1,mm
34 INPUT#1,dy:INPUT#1,fd:INPUT#1,wa:INPUT#1,bg:INPUT#1,wd:INPUT#1,lt:INPUT#1,lk
35 INPUT#1,qs:INPUT#1,by
36 FOR x=7 TO 50:INPUT #1,lo(x):NEXT
37 CLOSE 1:PRINT "Done!":PRINT:GOTO 56
50 PRINT:COLOR 11,1:PRINT "New character":PRINT:COLOR 15,1:PRINT "Enter your name: ";:INPUT "",na$:IF LEN(na$)>8 THEN PRINT:COLOR 4,1:PRINT "Too long!":GOTO 50
51 PRINT:rm=1:ic=0:hp=100:hm=100:mp=20:mm=20:dy=1:fd=500:wa=500:bg=0:wd=0:lt=0:lk=0:qs=1:by=0
52 FOR x=7 TO 50:READ lo(x):NEXT:CLS:COLOR 15,1:PRINT "The Quest for Waitomo Cave":COLOR 10,1:PRINT "By Paul Panks (dunric@yahoo.com)":COLOR 11,1:PRINT "Version 1.04":PRINT:COLOR 15,1
53 DATA 1,1,21,22,1037,1039,32,33,92,41,1037,1044,1036,1036,1043,1032,2
54 DATA 1037,1034,21,1042,21,1039,1050,24,33,7,16,55,43,20,52,87,85,46,95
55 DATA 71,88,92,65,78,58,67,95
56 REM main loop -- do not remove this line, please
59 IF lt=0 AND rm<>1 THEN COLOR 12,1:PRINT "< It is too dark to see anything... >":COLOR 15,1:PRINT "You should probably 'light lantern' at some point...":GOTO 170
60 ON rm GOTO 1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028
61 ON rm>28 GOTO 1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056
62 ON rm>56 GOTO 1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084
63 ON rm>84 GOTO 1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095
70 m(1,1)=2:m(2,2)=1:m(2,1)=3:m(3,1)=4:m(3,2)=2:m(4,1)=5:m(4,2)=3:m(4,3)=11:m(4,4)=24:m(5,1)=6:m(5,2)=4:m(6,1)=7:m(6,2)=5:m(7,2)=6:m(7,3)=8:m(7,4)=23
71 m(8,3)=12:m(8,4)=7:m(9,3)=14:m(9,2)=10:m(10,1)=9:m(10,2)=11:m(11,1)=10:m(11,4)=4:m(12,1)=20:m(12,4)=8:m(13,2)=14:m(14,1)=13:m(14,3)=16:m(14,4)=14
72 m(15,2)=16:m(16,1)=15:m(16,2)=17:m(16,3)=18:m(16,4)=14:m(17,1)=16:m(18,3)=19:m(18,4)=16:m(19,4)=18:m(20,2)=12:m(20,1)=21:m(21,2)=20
73 m(22,2)=25:m(23,3)=7:m(23,4)=25:m(24,3)=4:m(24,4)=28:m(25,1)=22:m(25,3)=23:m(26,2)=27:m(26,4)=33:m(27,1)=26:m(27,2)=28:m(28,1)=27:m(28,2)=29:m(28,3)=24
74 m(29,1)=28:m(29,4)=31:m(30,1)=31:m(31,1)=32:m(31,2)=30:m(31,3)=29:m(32,2)=31:m(32,4)=36:m(33,1)=34:m(33,3)=26:m(34,1)=35:m(34,2)=33:m(35,2)=34:m(35,6)=51
75 m(36,3)=32:m(36,4)=46:m(37,4)=45:m(38,4)=44:m(39,4)=43:m(40,4)=42:m(41,2)=42:m(42,1)=41:m(42,2)=43:m(43,3)=39:m(43,4)=49
76 m(44,1)=43:m(44,2)=45:m(44,3)=38:m(44,4)=48:m(45,1)=44:m(45,2)=46:m(45,3)=37:m(45,4)=47:m(46,1)=45:m(46,3)=36:m(47,3)=45:m(48,3)=44:m(49,3)=43:m(50,3)=42
77 m(51,5)=35:m(51,1)=52:m(52,1)=53:m(52,2)=51:m(53,1)=54:m(53,2)=52:m(54,1)=55:m(54,2)=53:m(55,1)=56:m(55,2)=54:m(55,3)=70:m(55,4)=62
78 m(56,1)=57:m(56,2)=55:m(57,1)=58:m(57,2)=56:m(58,2)=57:m(58,4)=59:m(59,3)=58:m(59,4)=60:m(60,3)=59:m(60,4)=61:m(61,3)=60
79 m(62,3)=55:m(62,4)=63:m(63,2)=64:m(63,3)=62:m(64,1)=63:m(64,2)=65:m(65,1)=64:m(65,4)=66:m(66,1)=67:m(66,3)=65:m(67,2)=66
80 m(68,1)=69:m(69,3)=74:m(69,2)=68:m(70,3)=73:m(70,4)=55:m(71,3)=75:m(71,2)=72:m(72,1)=71:m(72,2)=73:m(73,1)=72:m(73,2)=74:m(73,3)=76:m(73,4)=70
81 m(74,1)=73:m(74,3)=77:m(74,4)=69:m(75,3)=84:m(75,4)=71:m(76,3)=81:m(76,4)=73:m(77,2)=78:m(77,4)=74:m(78,1)=77:m(78,3)=79:m(79,2)=80:m(79,4)=78:m(80,1)=79
82 m(81,3)=88:m(81,4)=76:m(82,4)=83:m(83,1)=84:m(83,3)=82:m(84,1)=85:m(84,2)=83:m(84,4)=75:m(85,3)=86:m(85,2)=84:m(86,3)=87:m(86,4)=85:m(87,4)=86
83 m(88,4)=81:m(88,6)=89:m(89,5)=88:m(89,6)=90:m(90,5)=89:m(90,6)=91:m(91,5)=90:m(91,3)=92:m(92,4)=91:m(92,1)=93:m(93,1)=94:m(93,2)=92:m(94,1)=95:m(94,2)=93
84 m(95,2)=94
85 COLOR 15,1:PRINT "Obvious exits here: ";:COLOR 6,1:PRINT "<  ";:COLOR 14,1
86 IF m(rm,1)>0 THEN PRINT "north  ";
87 IF m(rm,2)>0 THEN PRINT "south  ";
88 IF m(rm,3)>0 THEN PRINT "east  ";
89 IF m(rm,4)>0 THEN PRINT "west  ";
90 IF m(rm,5)>0 THEN PRINT "up  ";
91 IF m(rm,6)>0 THEN PRINT "down  ";
92 COLOR 6,1:PRINT ">"
93 COLOR 12,1:IF lo(7)=rm THEN PRINT "lantern."
94 IF lo(8)=rm THEN PRINT "oil."
95 IF lo(9)=rm THEN PRINT "rope."
96 IF lo(10)=rm THEN PRINT "pole."
97 IF lo(11)=rm THEN PRINT "key."
98 IF lo(12)=rm THEN PRINT "scroll."
99 IF lo(13)=rm THEN PRINT "food."
100 IF lo(14)=rm THEN PRINT "bottle."
101 IF lo(15)=rm THEN PRINT "water."
102 IF lo(16)=rm THEN PRINT "helmet."
103 IF lo(17)=rm THEN PRINT "shield."
104 IF lo(18)=rm THEN PRINT "boots."
105 IF lo(19)=rm THEN PRINT "armor."
106 IF lo(20)=rm THEN PRINT "gauntlets."
107 IF lo(21)=rm THEN PRINT "ring."
108 IF lo(22)=rm THEN PRINT "amulet."
109 IF lo(23)=rm THEN PRINT "dagger."
110 IF lo(24)=rm THEN PRINT "sword."
111 IF lo(25)=rm THEN PRINT "longsword."
112 IF lo(26)=rm THEN PRINT "scimitar."
113 IF lo(27)=rm THEN PRINT "broadsword."
114 IF lo(28)=rm THEN PRINT "orb."
115 COLOR 11,1:IF lo(29)=rm THEN PRINT "shroud."
116 COLOR 12,1:IF lo(30)=rm THEN PRINT "chest."
117 IF lo(31)=rm THEN PRINT "rat."
118 IF lo(32)=rm THEN PRINT "skeleton."
119 IF lo(33)=rm THEN PRINT "warrior."
120 IF lo(34)=rm THEN PRINT "goblin."
121 IF lo(35)=rm THEN PRINT "hobbit."
122 IF lo(36)=rm THEN PRINT "knight."
123 IF lo(37)=rm THEN PRINT "barbarian."
124 IF lo(38)=rm THEN PRINT "villager."
125 IF lo(39)=rm THEN PRINT "sorcerer."
126 IF lo(40)=rm THEN PRINT "thief."
127 IF lo(41)=rm THEN PRINT "ghost."
128 IF lo(42)=rm THEN PRINT "paladin."
129 IF lo(43)=rm THEN PRINT "elf."
130 IF lo(44)=rm THEN PRINT "bard."
131 IF lo(45)=rm THEN PRINT "werewolf."
132 IF lo(46)=rm THEN PRINT "vampire."
133 IF lo(47)=rm THEN PRINT "adventurer."
134 IF lo(48)=rm THEN PRINT "demigorgon."
135 IF lo(49)=rm THEN PRINT "glowworm."
136 IF lo(50)=rm THEN PRINT "dragon."
150 i=INT(RND*15)+1:IF i>11 THEN COLOR 11,1:PRINT "A cool wind blows from the southeast."
151 IF i>13 THEN COLOR 14,1:PRINT "The sun shines and you feel better.":hp=hm:mp=mm
152 fd=fd-1:wa=wa-1:IF fd=25 THEN COLOR 4,1:PRINT "Your food supply is getting too low!":COLOR 15,1
153 IF wa=25 THEN COLOR 4,1:PRINT "You feel very thirsty indeed!":COLOR 15,1
154 IF i>5 AND i<8 THEN COLOR 15,1:PRINT "You sense a draft coming from the northeast."
155 IF lo(28)=0 AND lo(29)=0 AND lo(30)=0 AND lo(50)=998 THEN GOTO 900
170 COLOR 6,1:PRINT ">";:COLOR 11,1:a$="":n$="":v$="":xl$="":v=0:n=0:si=0:FOR x=1 TO 5:wd$(x)="":NEXT:n=0:v=0:si=0:xl$="":INPUT "",a$:COLOR 15,1
171 GOSUB 2000:GOSUB 2500:IF a$="n" OR a$="north" OR a$="go north" THEN n=1:GOTO 190
172 IF a$="s" OR a$="south" OR a$="go south" THEN n=2:GOTO 190
173 IF a$="e" OR a$="east" OR a$="go east" THEN n=3:GOTO 190
174 IF a$="w" OR a$="west" OR a$="go west" THEN n=4:GOTO 190
175 IF a$="u" OR a$="up" OR a$="go up" THEN n=5:GOTO 190
176 IF a$="d" OR a$="down" OR a$="go down" THEN n=6:GOTO 190
177 IF a$="i" OR a$="inv" OR a$="inve" OR a$="inven" OR a$="invent" OR a$="inventory" THEN GOTO 205
178 IF a$="l" OR a$="look" OR a$="lk" THEN GOTO 60
179 IF a$="?" OR a$="score" OR a$="sc" OR a$="help" THEN GOTO 3000
180 IF a$="q" OR a$="quit" OR a$="exit" OR a$="bye" OR a$="good bye" OR a$="goodbye" THEN PRINT:COLOR 11,1:PRINT "Thanks for playing! :)":COLOR 7,1:PRINT "dunric@yahoo.com":END
181 S=1:Z=0:XL$=A$:FOR a=1 TO LEN(xl$)
182 IF MID$(xl$,a,1)=" " THEN a$=MID$(xl$,s,a-s):s=a+1:z=z+1:wd$(z)=a$
183 NEXT:z=z+1:a$=MID$(xl$,s,a-s):wd$(z)=a$:IF z>5 THEN COLOR 15,1:PRINT "Command is too complex. Please try again.":GOTO 170
184 v$=wd$(1):n$=wd$(2):IF wd$(3)="and" OR wd$(3)="then" THEN COLOR 15,1:PRINT "No 'and' with 'then' allowed.":GOTO 170
185 v=0:n=0:FOR x=1 TO 25:IF wd$(1)=vb$(x) OR wd$(3)=vb$(x) THEN v=x:x=50
186 NEXT:FOR x=1 TO 50:IF wd$(2)=no$(x) OR wd$(4)=no$(x) THEN n=x:x=50
187 NEXT:IF v=0 THEN IF v<>11 AND v<>14 AND v<>15 THEN COLOR 4,1:PRINT "What?":GOTO 170
188 ON v GOTO 190,211,220,230,240,250,260,270,280,290,300,310,320,400,410,500
189 COLOR 4,1:PRINT "What?":GOTO 170
190 IF lo(32)=rm AND n=1 THEN COLOR 15,1:PRINT "The skeleton stops you. He hisses ";:COLOR 4,1:PRINT "'You may not pass here!'":GOTO 170
191 IF lo(41)=rm AND n=1 THEN COLOR 15,1:PRINT"The ghost steps in front!":PRINT "He moans ";:COLOR 4,1:PRINT "'I cannot allow your passage north...'":GOTO 170
192 IF rm=46 THEN i=INT(RND*15)+1:IF i>11 THEN COLOR 11,1:PRINT "Suddenly, the rock gives way and you fall to your death!":COLOR 4,1:PRINT "Alas, you have died...":PRINT:COLOR 7,1:PRINT "< The End >":GOTO 999
193 IF lo(36)=rm AND n=1 THEN COLOR 15,1:PRINT "You try to move north, but the knight steps in front!":PRINT "He bellows ";:COLOR 4,1:PRINT "'Only the honorable may pass here!'":GOTO 170
194 IF lo(37)=rm AND n=1 THEN COLOR 15,1:PRINT "The barbarian stops you!":PRINT "He growls ";:COLOR 4,1:PRINT "'You shall NOT have this treasure, knave!!'":GOTO 170
195 IF rm=20 AND lk=0 AND n=1 THEN COLOR 7,1:PRINT "The northern door is locked. You'll need a key!":GOTO 170
196 IF rm=20 AND lk=1 AND n=1 THEN COLOR 7,1:PRINT "Click! The door unlocks and so you move north..."
197 IF rm=65 AND n=4 AND ic>5 THEN COLOR 7,1:PRINT "You are carrying too much weight":PRINT "to pass through to the west!":GOTO 170
198 IF rm=67 AND n=2 AND lo(49)=rm THEN COLOR 15,1:PRINT "The ooze from the glowworm is much too sticky to move!!":GOTO 170
199 IF rm=88 AND n=6 AND lo(9)<>0 THEN COLOR 7,1:PRINT "You slip off the edge...":FOR x=1 TO 5:PRINT "A":PRINT "R":PRINT "G":PRINT "H":NEXT:COLOR 4,1:PRINT "*** SPLAT! ***":PRINT:COLOR 7,1:PRINT "< The End >":GOTO 999
200 IF n=1 AND lo(45)=rm THEN COLOR 15,1:PRINT "But the werewolf stops you!":COLOR 15,1:PRINT "It growls ";:COLOR 4,1:PRINT "'This lake is MINE, fool!'":GOTO 170
201 IF rm=94 AND n=1 THEN IF lo(28)<>0 THEN COLOR 15,1:PRINT "A voice booms out ";:COLOR 4,1:PRINT "'You are not experienced":PRINT "enough yet to enter the hidden cave!'":GOTO 170
202 IF rm=94 AND n=1 THEN IF lo(29)<>0 OR lo(29)<>205 THEN COLOR 15,1:PRINT "A voice booms out ";:COLOR 4,1:PRINT "'You are not experienced":PRINT "enough yet to enter the hidden cave!'":GOTO 170
203 IF m(rm,n)=0 OR n>6 OR n=0 THEN COLOR 4,1:PRINT "You can't go that way.":GOTO 170
204 GOSUB 2000:rm=m(rm,n):COLOR 11,1:PRINT "You move "no$(n)"...":COLOR 15,1:GOTO 59
205 COLOR 15,1:si=0:PRINT "You are carrying:":FOR x=7 TO 30:IF lo(x)=0 THEN COLOR 15,1:PRINT "   "no$(x)".":si=1
206 IF lo(x)=105 THEN COLOR 11,1:PRINT "   "no$(x)" ";:COLOR 12,1:PRINT "(wielded)";:COLOR 15,1:PRINT ".":si=1
207 IF lo(x)=205 THEN COLOR 10,1:PRINT "   "no$(x)" ";:COLOR 13,1:PRINT "(worn)";:COLOR 15,1:PRINT ".":si=1
208 ac=0:IF lo(x)=205 THEN ac=ac+x
209 NEXT:IF si=0 THEN COLOR 4,1:PRINT "Nothing!":GOTO 170
210 GOTO 170
211 IF lo(n)=rm AND n>30 THEN COLOR 4,1:PRINT "You can't get that!":GOTO 170
212 IF n<7 THEN COLOR 4,1:PRINT "What did you want to get?":GOTO 170
213 IF lo(n)<>rm THEN COLOR 4,1:PRINT "You don't see that here.":GOTO 170
214 IF ic>=10 THEN COLOR 4,1:PRINT "You are carrying too much already!":GOTO 170
215 lo(n)=0:ic=ic+1:PRINT no$(n)":ok":GOTO 170
220 IF lo(n)=105 THEN COLOR 4,1:PRINT "You must unwield that first.":GOTO 170
221 IF lo(n)=205 THEN COLOR 4,1:PRINT "You must remove it first.":GOTO 170
222 IF lo(n)=rm THEN COLOR 4,1:PRINT "Don't be silly!":GOTO 170
223 IF n<7 THEN COLOR 4,1:PRINT "What?":GOTO 170
224 IF n=0 THEN COLOR 4,1:PRINT "Huh?":GOTO 170
225 lo(n)=rm:ic=ic-1:PRINT no$(n)":dropped":GOTO 170
230 IF lo(n)<>0 OR n<16 AND n>22 OR lo(n)=205 THEN COLOR 4,1:PRINT "You can't wear that!":GOTO 170
231 IF lo(n)=105 THEN COLOR 4,1:PRINT "You can't wear that!":GOTO 170
232 IF lo(n)=rm THEN COLOR 4,1:PRINT "What?":GOTO 170
233 IF n<16 OR n>22 THEN COLOR 12,1:PRINT "You can't wear that!":GOTO 170
234 lo(n)=205:ac=ac+n:PRINT no$(n)":worn":GOTO 170
240 IF lo(n)<>205 THEN COLOR 4,1:PRINT "You can't remove that!":GOTO 170
241 lo(n)=0:ac=ac-n:PRINT no$(n)":removed":GOTO 170
250 IF lo(n)<>0 OR n<23 AND n>27 OR wd=1 THEN COLOR 4,1:PRINT "You can't wield that now!":GOTO 170
251 IF lo(n)=205 THEN COLOR 4,1:PRINT "You can't wield that!":GOTO 170
252 IF lo(n)=rm THEN COLOR 4,1:PRINT "What?":GOTO 170
253 IF lo(n)=105 THEN COLOR 4,1:PRINT "You are already wielding it!":GOTO 170
254 IF n<23 OR n>27 THEN COLOR 12,1:PRINT "You can't wield that!":GOTO 170
255 wd=0:FOR x=7 TO 30:IF lo(x)=105 THEN wd=1
256 NEXT:IF wd=1 THEN COLOR 12,1:PRINT "You are wielding something already!":GOTO 170
257 lo(n)=105:dm=n:wd=1:PRINT no$(n)":wielded":GOTO 170
258 COLOR 15,1
260 IF lo(n)<>105 THEN COLOR 4,1:PRINT "You can't unwield that!":GOTO 170
261 lo(n)=0:dm=1:wd=0:PRINT no$(n)":unwielded":GOTO 170
270 GOTO 2600
280 IF n=7 THEN GOTO 2600
281 IF lo(n)=0 OR lo(n)=205 THEN IF n=9 THEN COLOR 7,1:PRINT "*** Poof! ***":COLOR 15,1:PRINT "The rope goes up in smoke!":lo(9)=1:ic=ic-1:GOTO 170
282 IF lo(n)=0 OR lo(n)=205 THEN IF n=10 THEN COLOR 15,1:PRINT "The wooden pole is only charred slightly.":GOTO 170
283 IF lo(n)=0 OR lo(n)=205 THEN IF n=12 THEN COLOR 7,1:PRINT "*** Poof! ***":COLOR 15,1:PRINT "The scroll goes up in flames!":lo(12)=1:ic=ic-1:GOTO 170
284 IF lo(n)=0 OR lo(n)=205 THEN IF n=29 THEN COLOR 15,1:PRINT "The shroud lights, becoming a flaming shroud!":ob$(29)="shroud: a flaming shroud endowed with magical properties.":no$(29)="flameshroud":ac=ac+n:by=1:GOTO 170
285 IF lo(n)=0 OR lo(n)=205 THEN IF n=30 THEN COLOR 15,1:PRINT "The treasure chest is not flammable.":GOTO 170
286 PRINT "You can't do that here.":GOTO 170
290 IF lo(n)=0 OR lo(n)=105 OR lo(n)=205 OR lo(n)=rm THEN GOTO 292
291 PRINT "What?":GOTO 170
292 IF n=12 THEN COLOR 15,1:PRINT "The scroll reads:":PRINT:COLOR 7,1:PRINT "   ...'Use the orb in sticky situations, and the rope to climb down...":GOTO 170
293 COLOR 7,1:IF n=0 AND rm<>1 THEN PRINT "...":GOTO 170
294 IF n=0 AND rm=1 THEN COLOR 15,1:PRINT "The sign reads: ";:COLOR 11,1:PRINT "'Type 'help' for a list of commands. Good luck!'":GOTO 170
295 COLOR 7,1:PRINT ob$(n):GOTO 170
300 IF n=12 THEN IF lo(n)=0 OR lo(n)=rm THEN COLOR 7,1:PRINT ob$(n):GOTO 292
301 GOTO 290
310 IF n=30 AND lo(n)=0 OR n=30 AND lo(n)=rm THEN IF lo(11)<>0 THEN PRINT "You need a key in order to unlock the treasure chest.":GOTO 170
311 IF n=30 AND lo(n)=0 OR n=30 AND lo(n)=rm THEN IF lo(11)=0 THEN COLOR 7,1:PRINT "Click!":COLOR 15,1:PRINT "The treasure chest unlocks!":COLOR 12,1:PRINT "...Alas, it is nothing but dirt! Damnit!...":GOTO 170
312 IF rm=20 THEN GOTO 2600
313 PRINT "You can't unlock/open that. Sorry.":GOTO 170
320 GOTO 420
400 GOTO 2600
410 IF rm=65 THEN PRINT "There isn't a way to pass through it.":GOTO 170
411 IF rm=20 THEN PRINT "There isn't a way inside.":GOTO 170
412 IF rm=35 THEN PRINT "You'll need to find some other way.":GOTO 170
413 IF rm=88 THEN PRINT "You can't enter that from here!":GOTO 170
414 IF rm>90 THEN COLOR 7,1:PRINT "You enter inside...":COLOR 15,1:PRINT "You feel refreshed!!":hp=hm:mp=mm:fd=500:wa=500:GOTO 170
415 PRINT "It's beyond your power to do that!":GOTO 170
420 IF n<31 OR lo(n)<>rm THEN COLOR 12,1:PRINT "You can't kill that!":GOTO 170
421 IF lo(n)=rm AND n<31 THEN COLOR 12,1:PRINT "You can't kill that!":GOTO 170
422 COLOR 6,1:PRINT:PRINT ">"
423 i=INT(RND*35)+1
424 COLOR 7,1:PRINT "You are fighting "no$(n)"...":PRINT
425 COLOR 15,1:FOR x=7 TO 30:IF lo(x)=105 THEN dm=x
426 NEXT:IF dm>1 THEN COLOR 11,1:PRINT "You are wielding the "no$(dm)"...":PRINT
427 IF dm=1 THEN COLOR 11,1:PRINT "You are wielding NOTHING...":PRINT
428 ac=0:FOR x=7 TO 30:IF lo(x)=205 THEN ac=ac+x
429 NEXT:IF i=10 THEN IF lo(17)=205 THEN COLOR 10,1:PRINT "Your SHIELD strikes a blast of light at "no$(n)"!!":COLOR 15,1:PRINT "The "no$(n)" is hit VERY HARD!":mh(n)=mh(n)-i+40
430 IF i=11 THEN IF lo(19)=205 THEN COLOR 14,1:PRINT "Your ARMOR glows and you feel warm!":hp=hp+25:IF hp>hm THEN hp=hm
431 IF i=12 THEN IF lo(20)=205 THEN COLOR 6,1:PRINT "Your GAUNTLETS come to life!":COLOR 13,1:PRINT "The "no$(n)" is DESTROYED!!":mh(n)=mh(n)-i+50
432 IF i=13 THEN IF lo(21)=205 THEN COLOR 11,1:PRINT "Your RING pulsates!":COLOR 12,1:PRINT "A flash of LIGHT hits "no$(n)"!!":hp=hp+mh(n):mh(n)=mh(n)-hp:IF hp>hm THEN hp=hm
433 IF i=14 THEN IF lo(22)=205 THEN COLOR 14,1:PRINT "Your AMULET glows!":COLOR 15,1:PRINT "A flash of LIGHT blinds "no$(n)"!!":mh(n)=mh(n)-150
434 IF i=15 THEN IF lo(29)=205 THEN COLOR 11,1:PRINT "Your SHROUD vibrates!":COLOR 10,1:PRINT "The entire area is BLASTED with HOLY LIGHT!!!":mh(n)=mh(n)-500
435 IF i=16 THEN IF lo(26)=105 THEN COLOR 11,1:PRINT "Your SCIMITAR glows!!":COLOR 15,1:PRINT "The "no$(n)" is SMASHED into atoms!!!":mh(n)=mh(n)-hm
436 IF i=17 THEN IF lo(27)=105 THEN COLOR 13,1:PRINT "Your BROADSWORD hums violently!":COLOR 12,1:PRINT "The "no$(n)" is slashed IN HALF!!!":mh(n)=1
437 IF i<10 THEN COLOR 15,1:PRINT "You missed "no$(n)"..."
438 IF i>17 AND i<22 THEN COLOR 15,1:PRINT "You hit "no$(n)".":mh(n)=mh(n)-i
439 IF i>21 AND i<26 THEN COLOR 15,1:PRINT "You hit "no$(n)" very hard.":mh(n)=mh(n)-i:mh(n)=mh(n)-i:mh(n)=mh(n)-i
440 IF i>25 AND i<30 THEN COLOR 10,1:PRINT "AMAZING BLOW!!":PRINT "You smashed "no$(n)" with a bone-crushing sound!!":mh(n)=mh(n)-i:mh(n)=mh(n)-i:mh(n)=mh(n)-i:mh(n)=mh(n)-i
441 IF i>29 THEN COLOR 15,1:PRINT "The "no$(n)" dodged your attack..."
442 PRINT:COLOR 14,1:PRINT "*** Press any key to continue ***"
443 a$=INKEY$:IF a$="" THEN GOTO 443
444 PRINT:COLOR 6,1:PRINT ">":IF mp>10 THEN IF hp<50 THEN mp=mp-10:hp=hp+25:COLOR 14,1:PRINT:PRINT "You cast HEAL...":COLOR 15,1:PRINT ">>>>>>";:COLOR 7,1:PRINT ">>>>>>";:COLOR 8,1:PRINT ">>>>>>";:COLOR 7,1:PRINT " H E A L ! ! !":IF hp>hm THEN hp=hm
445 f=INT(RND*35)+1:IF f<10 THEN COLOR 15,1:PRINT "The "no$(n)" missed you..."
446 IF f>9 AND f<15 THEN COLOR 12,1:PRINT "The "no$(n)" hit you.":hp=hp-f
447 IF f>14 AND f<20 THEN COLOR 13,1:PRINT"The "no$(n)" hit you very hard.":hp=hp-f:hp=hp-f
448 IF f>19 AND f<25 THEN COLOR 12,1:PRINT "CRUSHING BLOW!!":PRINT "The "no$(n)" smashed you into atoms!!":hp=hp-f:hp=hp-f:hp=hp-f:hp=hp-f
449 IF f=25 THEN IF n=36 THEN COLOR 11,1:PRINT "The "no$(n)" does a tremendous downward CHOP!!":COLOR 15,1:PRINT "You are hit VERY HARD!!":hp=hp-mh(n)
450 IF f=25 THEN IF n=37 THEN COLOR 11,1:PRINT "The "no$(n)" charges you!!":COLOR 15,1:PRINT "You sustain a DEVASTATING BLOW!!":hp=hp-mh(n):hp=hp-mh(n)
451 IF f=25 THEN IF n=39 THEN COLOR 11,1:PRINT "The "no$(n)" CASTS a FIREBALL at you!!":COLOR 14,1:PRINT ">>>>>>";:COLOR 6,1:PRINT ">>>>>>";:COLOR 12,1:PRINT ">>>>>>";:COLOR 4,1:PRINT ">>>>>>";:COLOR 7,1:PRINT " F I R E - B A L L ! ! !":PRINT:COLOR 15,1:PRINT "You are BURNED BADLY!!!":hp=hp-500
452 IF f=25 THEN IF n=45 THEN COLOR 11,1:PRINT "The "no$(n)" BITES YOU HARD!!":COLOR 12,1:PRINT "You are BLEEDING BADLY!!!":hp=hp-250
453 IF f=25 THEN IF n=46 THEN COLOR 11,1:PRINT "The "no$(n)" sinks his teeth INTO YOUR NECK!!!":COLOR 12,1:PRINT "You TURN UNDEAD!!!":hp=hp-5000
454 IF f=25 THEN IF n=48 THEN COLOR 12,1:PRINT "The "no$(n)" grabs you!":COLOR 15,1:PRINT "It hisses,'Care for a DANCE?!'":COLOR 11,1:PRINT "The "no$(n)" slams you against the floor!":COLOR 15,1:PRINT "You turn ghostly white and whither...dead away!!":hp=0
455 IF f=25 THEN IF n=49 THEN COLOR 15,1:PRINT "The "no$(n)" says, '";:COLOR 12,1:PRINT "I don't want to fight you, sir!'"
456 IF f>25 AND f<30 THEN COLOR 13,1:PRINT "CRUSHING BLOW!!!":PRINT "The "no$(n)" SPLITS YOU IN HALF!!!":hp=hp-mh(n):hp=hp-mh(n):hp=hp-mh(n)
457 IF f>29 THEN COLOR 11,1:PRINT "You dodged the attack..."
458 COLOR 15,1:PRINT:IF hp<1 THEN COLOR 12,1:PRINT "Alas, you have died...":COLOR 15,1:PRINT "You have fallen in battle to the "no$(n)"...":PRINT:COLOR 7,1:PRINT "< The End >":GOTO 999
459 IF mh(n)<1 THEN COLOR 12,1:PRINT "The "no$(n)" has died.":COLOR 15,1:PRINT "You killed it dead.":GOTO 470
460 PRINT:GOTO 422
470 COLOR 14,1:PRINT "You gained some experience and gold.":en=en+i+n:IF en>50 THEN lv=lv+1:hm=hm+25:mm=mm+15:hp=hm:mp=mm:COLOR 11,1:PRINT "You gained a level!":en=0
471 ex=ex+en:IF ex>25000 THEN ex=25000
472 IF lv>20 THEN lv=20
473 IF hm>500 THEN hm=500
474 IF mm>250 THEN mm=250
475 lo(n)=998
476 FOR x=7 TO 30:IF lo(x)=1000+n THEN COLOR 7,1:PRINT "You found "no$(x)" on it!":lo(x)=rm
477 NEXT:COLOR 15,1:GOTO 170
500 COLOR 7,1:PRINT "Saving "na$"..."
501 COLOR 15,1
502 OPEN na$+".sav" FOR OUTPUT AS #1
503 PRINT#1,na$:PRINT#1,rm:PRINT#1,ic:PRINT#1,hp:PRINT#1,hm:PRINT#1,mp:PRINT#1,mm
504 PRINT#1,dy:PRINT#1,fd:PRINT#1,wa:PRINT#1,bg:PRINT#1,wd:PRINT#1,lt:PRINT#1,lk
505 PRINT #1,qs:PRINT#1,by
506 FOR x=7 TO 50:PRINT #1,lo(x):NEXT
507 CLOSE 1:PRINT "Done.":GOTO 170
899 REM win scenerio
900 PRINT:COLOR 11,1:PRINT "Congratulations!!! You've succeeded in finding all the treasures!":PRINT
901 COLOR 15,1:PRINT "As you look upon the treasures you've collected, you feel a surge of":PRINT "pride in your accomplishments. You're grandfather would've been so":PRINT"proud of you! These treasures will fetch a hefty price at the local"
902 PRINT "museum. It seems that in exploring these fabulous caves you've discovered":PRINT "wonders beyond your wildest imagination! You'll no doubt retire richer than":PRINT "your grandfather, if not in riches than in spirit!":PRINT
903 COLOR 7,1:PRINT "< The End >":PRINT
904 GOTO 904
999 END
1001 COLOR 7,1:PRINT "You are standing at the entrance to Waitomo Cave.":PRINT "The passage ahead leads into darkness below.":COLOR 11,1:PRINT "There is a small wooden sign here.":GOTO 70
1002 COLOR 7,1:PRINT "You have entered into Holden's Cave, named after":PRINT"the man who rediscovered these caves. A chamber lies to the":PRINT"north of here.":GOTO 70
1003 COLOR 7,1:PRINT "You are walking down a darkened chamber within the caves.":PRINT "A tunnel is up ahead, leading off in all directions before you.":GOTO 70
1004 COLOR 7,1:PRINT "You are facing a tunnel within the caves. It appears to":PRINT "branch off here and head into the forbidding beauty of":PRINT "darkness unknown.":GOTO 70
1005 COLOR 7,1:PRINT "You are walking down a chamber known as The Ghost Walk.":PRINT"Disembodied spirits of unfortunate spelunkers roam these halls.":PRINT "The passage continues north.":GOTO 70
1006 COLOR 7,1:PRINT "The Ghost Walk continues before you, opening up into a great":PRINT"chamber ahead. You notice some strange formations on":PRINT"either side of the cavern.":GOTO 70
1007 COLOR 7,1:PRINT "You are facing a point of decision within the Ghost Walk.":PRINT "You feel chilly here, as if the spirits of evil have entered into you!":PRINT "A tunnel heads off to the east and west here.":GOTO 70
1008 COLOR 7,1:PRINT "You are walking down a darkened tunnel within the caves.":PRINT "It branches off here, heading east into darkness.":GOTO 70
1009 COLOR 7,1:PRINT "The tunnel branches off here, heading south. It appears to":PRINT "connect with the main chamber towards the southwest.":GOTO 70
1010 COLOR 7,1:PRINT "You are walking down a narrow tunnel just east of the main":PRINT "chamber. It is very dark in here, as few particles of light ever":PRINT "reach these floors.":GOTO 70
1011 COLOR 7,1:PRINT "You have entered into a narrow tunnel, just east of the":PRINT "main chamber. It is very narrow here, as you can barely seem to fit":PRINT "past these walls!":GOTO 70
1012 COLOR 7,1:PRINT "You are crawling on your knees into a narrow tunnel. There":PRINT "is very little light here, as one might expect. A doorway is north of here.":GOTO 70
1013 COLOR 7,1:PRINT "You have reached a dead end within these caves. The tunnel":PRINT "appears to stop here, as the porous walls don't give much way":PRINT "in either direction.":GOTO 70
1014 COLOR 7,1:PRINT "As you walk down the tunnel, you notice stalactites hanging down":PRINT "from the towering walls of this cavern. They appear massive in size.":GOTO 70
1015 COLOR 7,1:PRINT "You have again reached a dead end, this time north of an artery":PRINT "tunnel chiseled from the porous walls of this cavern. The only":PRINT"exit is back south.":GOTO 70
1016 COLOR 7,1:PRINT "You have reached a point of decision along this narrow series":PRINT "of tunnels. You can head east, which takes you into darkness, or west...":PRINT"which leads into something else entirely!":GOTO 70
1017 COLOR 7,1:PRINT "You have reached a dead end within the caverns. This tunnel appears":PRINT"to stop abruptly here for unknown reasons.":GOTO 70
1018 COLOR 7,1:PRINT "You are walking down a darkened tunnel within Waitomo Cave.":PRINT "There is a small area creviced into the eastern wall.":PRINT "It appears to be a crack or cleft of some sort.":COLOR 11,1:PRINT "The crack appears too small to enter, however.":GOTO 70
1019 COLOR 7,1:PRINT "You have reached a small crack or cleft within the caves. It appears":PRINT"to fissure to the south, perhaps down some 300 feet or so.":PRINT"However, it cannot be entered from here.":COLOR 11,1:PRINT "You'll need to find another way down into the cavern.":GOTO 70
1020 COLOR 7,1:PRINT "You have reached a mysterious oak door, chiseled into the cavern":PRINT"itself. It appears magical, as though someone -- or something? -- has":PRINT"crafted it from a source beyond knowledge.":COLOR 11,1:PRINT "Beyond the door lies a small keep.":GOTO 70
1021 COLOR 7,1:PRINT "At last you open the door! This keep appears chiseled from the":PRINT "surrounding limestone itself. There are a few items of interest":PRINT "here, although they might not be worth taking without a fight!":COLOR 11,1:PRINT "A pale light, softly glowing green, emanates from the surrounding walls.":GOTO 70
1022 COLOR 7,1:PRINT "You have reached a dead end within the caverns. This tunnel":PRINT"appears to stop here at a large wall. It does not appear climbable, however.":GOTO 70
1023 COLOR 7,1:PRINT "You are walking down a small tunnel, just west of the Ghost Walk.":PRINT "You can here the faint sounds of disembodied spirits, as they howl":PRINT "into the darkness above.":COLOR 11,1:PRINT "These spirits appear trapped within the walls themselves!":GOTO 70
1024 COLOR 7,1:PRINT "You have entered into a narrow passageway, just west of the":PRINT "main chamber. It heads off to the west here, leading into a larger tunnel":PRINT"which parallels it to the north.":COLOR 11,1:PRINT "The tunnel appears rather shallow and steep.":GOTO 70
1025 COLOR 7,1:PRINT "You are walking down a narrow tunnel. The light appears very dim here, as":PRINT "your lantern flickers in the foul air above. You feel as":PRINT "though the light is fading somewhat, the deeper you go into these caves!":GOTO 70
1026 COLOR 7,1:PRINT "You are walking down a small tunnel, heading north. The walls":PRINT "are especially porous here, as you can make out the distant rumble of":PRINT "moving water {far} below.":COLOR 11,1:PRINT "The tunnel breaks off here, heading southwest.":GOTO 70
1027 COLOR 7,1:PRINT "You are walking past a narrow tunnel. It appears to have fairly":PRINT "porous walls. You also hear a faint rumble ahead, as if rushing water is":PRINT "moving past large rocks ahead.":COLOR 11,1:PRINT "The rumble is coming from below, not above.":GOTO 70
1028 COLOR 7,1:PRINT "You are standing in a narrow passageway, west of the main":PRINT "chamber. The walls appear quite porous here, as they vibrate faintly with":PRINT "the sounds of rumbling movement.":GOTO 70
1029 COLOR 7,1:PRINT "You are walking down a southern tunnel. The walls are less porous than":PRINT "in previous tunnels, but that doesn't mean safety, either!":PRINT "A larger series of tunnels can be seen towards the west, heading":PRINT "into darkness ahead.":GOTO 70
1030 COLOR 7,1:PRINT "You have reached a dead end within the caves. It appears to stop":PRINT "abruptly here, as though these walls are less porous and more rigid.":COLOR 11,1:PRINT "The only exit lies to the north, ahead of you.":GOTO 70
1031 COLOR 7,1:PRINT "You are walking down a large tunnel, west of the main chamber.":PRINT "There are several stalactites and stalagmites here, some larger than ten":PRINT "feet in length! The tunnel appears to branch north, heading west from":PRINT "here. There is also a passageway to the east.":GOTO 70
1032 COLOR 7,1:PRINT "You are walking down a large tunnel on the upper level of this":PRINT "cavern. You notice the tunnel branches to the west here, heading into a":PRINT "series of smaller chambers ahead.":COLOR 11,1:PRINT "According to your grandfather, these are Maori burial grounds.":GOTO 70
1033 COLOR 7,1:PRINT "As you turn west, you notice a large tunnel heading into a massive":PRINT "opening ahead. This shaft appears to descend several hundred feet below, as":PRINT "the rush of cool air hits your face from below.":COLOR 11,1:PRINT "The shaft appears several kilometers ahead. You'll need to walk further.":GOTO 70
1034 COLOR 7,1:PRINT "You are heading north towards a massive opening in the cavern floor.":PRINT "This is a large shaft, descending down some three hundred feet":PRINT "below the current tunnel. It also appears rather unsteady, as you'll need a":PRINT "rope to descend further down.":COLOR 11,1:PRINT "There doesn't appear to be a rope nearby, however."
1035 COLOR 7,1:PRINT "At last you reach the shaft! This massive opening descends several hundred":PRINT "feet below the current tunnel. Looking down, you see a smaller chamber":PRINT "opening into a passageway towards the north.":COLOR 11,1:PRINT "Jumping does not appear wise. You'll definately need a rope to descend it!":GOTO 70
1036 COLOR 7,1:PRINT "You are standing in a narrow tunnel near the Maori Burial Ground.":PRINT "The Maori built these catacombs to house the deceased. You sense a chill":PRINT "in the air ahead, as if spirits roam these walls.":COLOR 11,1:PRINT "There is a cold chill in the air, sending a shiver down your spine.":GOTO 70
1037 COLOR 7,1:PRINT "You are facing a burial chamber within the Maori Burial Ground.":PRINT "This small opening within the wall appears to house a wrapped sheath":PRINT "of mummified remains. It appears spooky, as you feel somewhat on edge by":PRINT "this unsightly discovery!":COLOR 11,1:PRINT "The mummified remains appears relatively well preserved.":GOTO 70
1038 COLOR 7,1:PRINT "You are facing a smaller chamber within the Maori Burial Ground.":PRINT "A small opening is here, housing a pile of dusty bones. Whomever was":PRINT "buried here was given much thought!":COLOR 11,1:PRINT "The bones appear very brittle to the touch.":GOTO 70
1039 COLOR 7,1:PRINT "You are facing a small chamber within the Maori Burial Ground.":PRINT "A small opening is clearly visible here, although it does not appear":PRINT "to house any discernable remains. The tomb appears empty.":GOTO 70
1040 COLOR 7,1:PRINT "You are facing a larger burial chamber within the Maori Burial Ground.":PRINT "This large opening within the wall houses at least two mummified":PRINT"remains, some of them laiden with gold and jewels!":COLOR 11,1:PRINT"Damn, the remains are too far up to reach...What a pity!":GOTO 70
1041 COLOR 7,1:PRINT "You are facing a stone tablet within the Maori Burial Ground.":PRINT "Your grandfather mentioned this years ago, but you never thought it existed!":PRINT "The stone tablet reads (in part): ";:COLOR 4,1:PRINT "'Beware those who enter this abode!'":GOTO 70
1042 COLOR 7,1:PRINT "You are standing within the catacombs of the Maori Burial Ground.":PRINT "This is an area of darkness intermixed with sparse light. Shadows appear":PRINT "to hang from the ghostly walls, as the sounds and whispers of":PRINT "an ancient immortality pervade throughout the catacombs.":COLOR 11,1:PRINT "There is a stone tablet up ahead to the north of here.":GOTO 70
1043 COLOR 7,1:PRINT "You are standing in the middle of the Maori Burial Ground catacombs.":PRINT "The catacombs were hewn from the surrounding limestone long ago, as part":PRINT "of a complex series of burial chambers. You sense a ghostly presence within":PRINT "these walls, as if someone is watching you!":GOTO 70
1044 COLOR 7,1:PRINT "You are walking in the midst of the Maori Burial Ground.":PRINT "A series of catacombs are hewn into the surrounding limestone, many on either":PRINT "side of this passageway. You notice a faint chill in the air, as if someone":PRINT"is cooling the air around you deliberately.":GOTO 70
1045 COLOR 7,1:PRINT "You are walking into the Maori Burial Ground, a series of":PRINT "catacombs hewn into the surrounding limestone of this cavern.":PRINT "On either side of this passageway lay tombs of unknown origin, some of":PRINT "them occupied by bones and mummified corpses.":COLOR 11,1:PRINT "The Burial Ground heads north here, into darkness ahead.":GOTO 70
1046 COLOR 7,1:PRINT "You are walking down a large tunnel, near a large burial ground.":PRINT "There is a large crevice here, which looks exceptionally unstable. Crossing":PRINT "it to the north may be dangerous!":COLOR 11,1:PRINT "There is a slight risk that crossing it may crack the surrounding rock!":GOTO 70
1047 COLOR 7,1:PRINT "You are facing a small burial chamber, hewn into the surrounding":PRINT "limestone above. It appears to be empty, however, as there are no":PRINT "visible bones or other remains there.":GOTO 70
1048 COLOR 7,1:PRINT "You are facing a large catacomb, hewn into the rocks above. It appears":PRINT "to house a mummified body, which is wrapped in a clothlike":PRINT "wrapping or sheath. The air is fairly cold here, suggesting the spirits":PRINT "of the deceased are nearby!":COLOR 11,1:PRINT "You feel positively freaked out here!":GOTO 70
1049 COLOR 7,1:PRINT "You are facing a burial chamber hewn into the surrounding limestone":PRINT "of this cavern. It appears largely void of anything, however, as someone":PRINT "has apparently raided it before you.":GOTO 70
1050 COLOR 7,1:PRINT "You are facing a small burial chamber hewn into the rock above.":PRINT "There are a few small bones here, but nothing more. Apparently":PRINT "great care was taken to stack them, suggesting an elder or loved one.":COLOR 11,1:PRINT "This appears to be the most plain of all the burial tombs.":GOTO 70
1051 COLOR 7,1:PRINT "You finally descend the long way down! This is the second level (or floor)":PRINT "of the Waitomo Cave. You recall that your grandfather knew of a secret":PRINT "passageway, leading to the underground streams below.":COLOR 11,1:PRINT "You can use the rope to ascend upward if need be...":GOTO 70
1052 COLOR 7,1:PRINT "You are walking down a large passageway on the second level of the Waitomo":PRINT "Cave. The passage ahead opens into a wider one towards the north.":PRINT "There appear to be many small tunnels up ahead (also to the":PRINT "north of here).":GOTO 70
1053 COLOR 7,1:PRINT "You are walking within a large passage on the second level of the":PRINT "cave. The air is quite foul here, suggesting a thin level of oxygen ahead.":COLOR 11,1:PRINT "Far ahead, you can barely make out the sounds of rushing water.":GOTO 70
1054 COLOR 7,1:PRINT "You are walking down a large {yet narrow} passageway within":PRINT "the Waitomo Cave. There is a small chamber up ahead, heading off in four":PRINT "directions. You notice the walls are far more porous here, suggesting":PRINT "God-knows-what lay ahead!":GOTO 70
1055 COLOR 7,1:PRINT "You are facing a point of decision near a large passageway. Four distinct":PRINT "tunnels branch off here, heading off in all visible directions.":PRINT "The largest tunnel {to the north} slopes downward at a sharp angle":PRINT "of descent.":COLOR 11,1:PRINT "The darkest tunnel heads east of here.":GOTO 70
1056 COLOR 7,1:PRINT "You are walking down a narrow tunnel, sloping downward as you go.":PRINT "The walls appear to be closing in on you, but maybe that's your reward":PRINT "for foolishly exploring these caves!":COLOR 11,1:PRINT "The tunnel slopes downward near a fossilized section of limestone walls.":GOTO 70
1057 COLOR 7,1:PRINT "You are walking down a narrow passageway, just south of a":PRINT "fossilized section of limestone. The walls ahead appear to be fossilized":PRINT "by time, surrounding within them every living creature and object within":PRINT "fifteen hundred feet.":GOTO 70
1058 COLOR 7,1:PRINT "You are facing a fossilized section of limestone walls. These walls":PRINT "contain the fossilized remains of every living creature and object":PRINT "nearby. Some of the fossils are shells, while others appear to be":PRINT "indistinguishable from the surrounding cavern.":GOTO 70
1059 COLOR 7,1:PRINT "You are walking down a narrow tunnel, fossilized with insects and":PRINT "assorted shells. These tunnels are among the most famous in all of":PRINT "New Zealand, for they contain some fossils reported to be over 28 million":PRINT "years old!":COLOR 11,1:PRINT "Many of these fossils are shells, obviously.":GOTO 70
1060 COLOR 7,1:PRINT "You are walking down a narrow tunnel. The walls appear to contain":PRINT "fossilized remains of shells and other insects. They appear very":PRINT "old, as some of these fossils were created when the caves where formed over":PRINT "30 million years ago.":GOTO 70
1061 COLOR 7,1:PRINT "You have reached a small keep, hewn into the surrounding walls":PRINT "above you. It is nothing more than a small crevice, however, with some":PRINT "room for a small bed.":COLOR 11,1:PRINT "You notice a small hammock nearby, swinging eerily by itself.":GOTO 70
1062 COLOR 7,1:PRINT "You are traversing a tunnel near a large passageway. It heads into":PRINT "darkness ahead, although a faint glow can be seen as you head":PRINT "further down the tunnel. The walls appear to be slightly in motion, as if":PRINT "vibrating the sounds of rushing water nearby.":GOTO 70
1063 COLOR 7,1:PRINT "As you turn west here, you notice the tunnel brighten considerably ahead.":PRINT "A strange glow emanates from these walls, as if something is lighting":PRINT "up the cavern from within!":COLOR 11,1:PRINT "You notice strange creatures here, some of them glowing green.":GOTO 70
1064 COLOR 7,1:PRINT "As you walk down this tunnel, you can't help but feel in awe of these":PRINT "glowing creatures! Your grandfather called them 'Glowworms', and they":PRINT "certainly are glowing, aren't they?!! As you stare oddly at thease":PRINT "strange-looking worms, you notice a fluorescent glow coming":PRINT "from within their wormy interiors.":COLOR 11,1:PRINT "These worms are natural to these caves it seems.":GOTO 70
1065 COLOR 7,1:PRINT "You have reached a small hole, heading into an even smaller tunnel":PRINT "ahead. It appears barely open, however. You may just be able to squeeze":PRINT "past it, but you'll need to drop some of your weight first!":COLOR 11,1:PRINT "The crevice appears too narrow to pass with armor on.":GOTO 70
1066 COLOR 7,1:PRINT "At last you squeeze through the hole! That was quite a stretch, wasn't it?!!":PRINT "Up ahead, you notice a large opening, hewn into the surrounding":PRINT "tunnel. There is a soft light ahead as well, but you'll need":PRINT "to get closer first.":COLOR 11,1:PRINT "The light appears different from the others.":GOTO 70
1067 COLOR 7,1:PRINT "You have reached a small opening hewn into the rock in front of you.":PRINT "A large family of Glowworms are here, many of them moving about the":PRINT "room in fluorescent fulminations. In fact, some of them are oozing greenish":PRINT "looking slime onto the surrounding floor. Yuck!":COLOR 11,1:PRINT "Your feet are beginning to stick to the floor!":GOTO 70
1068 COLOR 7,1:PRINT "You have reached a dead end within the caves. It appears as though":PRINT "the walls have stopped here, or something has stopped them. Whatever the":PRINT "cause, the only exit remains back north.":GOTO 70
1069 COLOR 7,1:PRINT "The tunnel turns here, twisting south into a darkened portion of the":PRINT "tunnel ahead. Another turn twists east, heading into a larger passageway":PRINT "to the north.":COLOR 11,1:PRINT "The southern tunnel appears closed off by something.":GOTO 70
1070 COLOR 7,1:PRINT "You are walking down a darkened tunnel, just east of the main passageway.":PRINT "It appears to head east from here, but where it leads is anyone's":PRINT "guess. You notice a series of stalactites hanging down from the walls above, as":PRINT "well as several stalagtites from the floor {many of them several":PRINT "feet in length}.":GOTO 70
1071 COLOR 7,1:PRINT "The tunnel twists here, heading east into a narrow section of the":PRINT "cave. You notice etchings on the wall here, some of them carved by":PRINT "spelunkers such as yourself. Reading one, you notice the following: ":COLOR 4,1:PRINT "'Beware the eastern path!'":GOTO 70
1072 COLOR 7,1:PRINT "You are crawling on your belly down a narrow tunnel. This wasn't":PRINT "described by your grandfather at all, so it must be a secret":PRINT "passageway! You cough and spit out the foul dirt and dust, and your lungs are":PRINT "just screaming for air!":COLOR 11,1:PRINT "Whatever lies ahead may very well be forbidding and ugly!":GOTO 70
1073 COLOR 7,1:PRINT "You have reached another decision point {gravy!} within these":PRINT "tunnels. The path appears to head off in four directions here, sending":PRINT "shivers down your spine. The largest of them lies to the east, but a very":PRINT "narrow one is slightly visible to the north.":COLOR 11,1:PRINT "You'll need to crawl on your belly to reach it, however.":GOTO 70
1074 COLOR 7,1:PRINT "You have reached a smaller tunnel towards the south. A cool wind blows":PRINT "up from a draft towards the east. The tunnel appears to branch off":PRINT "here, heading to the southeast.":GOTO 70
1075 COLOR 7,1:PRINT "You are crawling on your belly in a darkened cavern, spitting out":PRINT "dust and dirt as you go. You can literally feel the cavern walls closing":PRINT "in, as if they want you to go even further!":COLOR 11,1:PRINT "You can {barely} make out an opening to the east of here.":GOTO 70
1076 COLOR 7,1:PRINT "You are descending a large passageway, heading east. The tunnel":PRINT "appears to open up substantially to the east, before descending":PRINT "into darkness below.":COLOR 11,1:PRINT "The rumble of rushing water emanates throughout.":GOTO 70
1077 COLOR 7,1:PRINT "A sense of great calm and peace pervades throughout this tunnel. As you":PRINT "walk further down, you can sense the walls getting farther and":PRINT "farther away. The more distant they become, the more peaceful you feel.":COLOR 11,1:PRINT "The walls appear to be on fire, lit by something wicked!":GOTO 70
1078 COLOR 7,1:PRINT "You sense a great color ahead, as if your brain has been trapped in a":PRINT "kaleidoscope of shapes and colors unknown. The walls appear to be on fire,":PRINT "as if something wicked has started a blaze across the landscape ahead!":PRINT "You feel slightly dizzy as well, the life slowly being drained, it seems...":GOTO 70
1079 COLOR 7,1:PRINT "You see colors on the walls, as if something has lit them up like":PRINT "distant hues upon the colors of the Great Sky. You feel the natural pull":PRINT "from your body, as the spirits of old raise you up above the caverns.":COLOR 11,1:PRINT "You appear to be hallucinating, it would seem...":GOTO 70
1080 COLOR 7,1:PRINT "At last, you have reached a patch of mushrooms! You feel very peaceful":PRINT "inside, as the mushrooms fill your nostrils with euphoric feelings":PRINT "of softness, love and Great Peace.":COLOR 11,1:PRINT "The mushrooms appear quite alive, as if dancing by the fiery walls...":GOTO 70
1081 COLOR 7,1:PRINT "You are walking down a large passageway, descending into darkness":PRINT "below. The sounds of rushing water rumble in your ears, sending shockwaves":PRINT "down your spine. You can feel the tingling sensation of movement, as if":PRINT "something below were moving very fast!":COLOR 11,1:PRINT "Towards the east is a large crevice, descending into a large stream below.":GOTO 70
1082 COLOR 7,1:PRINT "You have reached a dead end within the caves. There isn't a way around":PRINT "to the east, as you'll just have to head back west in order to":PRINT "find your fortunes there.":COLOR 11,1:PRINT "East of here, you can feel the rumbling of water below.":GOTO 70
1083 COLOR 7,1:PRINT "You are walking in a narrow tunnel, heading south. The tunnel appears":PRINT "to branch to the east here, but where it goes is not known. You notice":PRINT "that the tunnel ahead {to the north} is much wider than the base of the":PRINT "walls in front of you. Could this mean something, you wonder?":GOTO 70
1084 COLOR 7,1:PRINT "You are facing a long tunnel, heading north into darkness. It branches off":PRINT "to the north and south from here, available on either side by":PRINT "cascading light. Your lantern appears to flicker somewhat, as if pushed":PRINT "by an unseen wind.":COLOR 11,1:PRINT "The wind feels much warmer here, as if lit up by the surrounding heat.":GOTO 70
1085 COLOR 7,1:PRINT "As you turn east, you notice a smaller tunnel heading further down":PRINT "the chamber. It appears to head into a small keep, although it is not clearly":PRINT "visible from your vantage point.":GOTO 70
1086 COLOR 7,1:PRINT "You are crawling down a small tunnel, pressed into the floor by the low":PRINT "ceiling above. It appears almost too narrow to pass, but with some":PRINT "effort it might be possible!":COLOR 11,1:PRINT "The keep ahead {to the east} appears to be closed off from the front.":GOTO 70
1087 COLOR 7,1:PRINT "At last you reach the hidden keep! Your grandfather never mentioned this":PRINT "in his stories, so perhaps it is a secret passageway that no one":PRINT "else has found {until now}. There are a few items visible here, although":PRINT "what they are or who placed them there remains a mystery.":GOTO 70
1088 COLOR 7,1:PRINT "You are looking down a large crevice, descending into steep darkness below.":PRINT "You can hear the loud rumbling of a stream below, but it isn't":PRINT "accessible from here. The steep cliff below drops down some one hundred":PRINT "feet, a perilous drop indeed!":COLOR 11,1:PRINT "You'll need a rope to descend any further...":GOTO 70
1089 COLOR 7,1:PRINT "You are at the top of the cliff, descending downward. There are some 100":PRINT "feet of dangerous rocks and jagged edges below you. It looks quite dangerous":PRINT "to the eye, but you feel a sense of soaring height by these":PRINT "magificent cliffs!":COLOR 11,1:PRINT "Be careful here, as the descent is fairly rocky...":GOTO 70
1090 COLOR 7,1:PRINT "You are descending a long crevice below a rushing stream below.":PRINT "The sense of soaring height is evident here, as the cavern below rushes down":PRINT "to greet you slowly. As you twirl dangerously on the rope, you feel a":PRINT "sense of power envelope your being. This is wonderful!":GOTO 70
1091 COLOR 7,1:PRINT "At last you reach the base level, just beside the stream. That was quite":PRINT "a trip! Looking up, you sense that the descent took some twenty minutes":PRINT "to complete. By your estimation, that was well over one-hundred":PRINT "feet of climbing!":COLOR 11,1:PRINT "A large stream is ahead to the east.":GOTO 70
1092 COLOR 7,1:PRINT "You are looking at your reflection over a large stream. The water is gently":PRINT "moving to the north, towards some rocks. A large stream of light cascades":PRINT "down from above, illuminating the rocks below. The stream continues north.":COLOR 11,1:PRINT "There is a large waterfall ahead {to the north}.":GOTO 70
1093 COLOR 7,1:PRINT "You are wading in a fairly slow moving stream, just south of the":PRINT "waterfall. The sounds of rushing water fill your head, as water splashes":PRINT "onto rocks nearby. The water feels very cold, but you don't mind it much.":COLOR 11,1:PRINT "Up ahead lies a small waterfall, cascading down from above.":GOTO 70
1094 COLOR 7,1:PRINT "You are looking up at a magnificent waterfall, as it cascades down from":PRINT "several hundred feet above. As the water splashes down before you, you feel":PRINT "a great sense of pride in your accomplishments. You're grandfather would":PRINT "have been so proud of this moment!":COLOR 11,1:PRINT "Just beyond the waterfall is a small cave, hidden from view...":GOTO 70
1095 COLOR 7,1:PRINT "At last you reach the cave! The waterfall is being you, sending a blinding":PRINT "flash of water across the cave's entrance. No one has been here":PRINT "for a very long time, although you sense there's a reason behind it, too!":COLOR 11,1:PRINT "Just ahead of you, you sense the faint shadows of movement.":GOTO 70
1999 END
2000 no$(1)="north":no$(2)="south":no$(3)="east":no$(4)="west":no$(5)="up":no$(6)="down"
2007 no$(7)="lantern":no$(8)="oil":no$(9)="rope":no$(10)="pole":no$(11)="key":no$(12)="scroll":no$(13)="food":no$(14)="bottle":no$(15)="water"
2016 no$(16)="helmet":no$(17)="shield":no$(18)="boots":no$(19)="armor":no$(20)="gauntlets":no$(21)="ring":no$(22)="amulet":no$(23)="dagger"
2024 no$(24)="sword":no$(25)="longsword":no$(26)="scimitar":no$(27)="broadsword":no$(28)="orb":no$(29)="shroud":no$(30)="chest"
2031 no$(31)="rat":no$(32)="skeleton":no$(33)="warrior":no$(34)="goblin":no$(35)="hobbit":no$(36)="knight":no$(37)="barbarian":no$(38)="villager"
2039 no$(39)="sorcerer":no$(40)="thief":no$(41)="ghost":no$(42)="paladin":no$(43)="elf":no$(44)="bard":no$(45)="werewolf":no$(46)="vampire":no$(47)="adventurer"
2048 no$(48)="demigorgon":no$(49)="glowworm":no$(50)="dragon"
2101 ob$(1)="north: a direction heading north."
2102 ob$(2)="south: a direction heading south."
2103 ob$(3)="east: a direction heading east."
2104 ob$(4)="west: a direction heading west."
2105 ob$(5)="up: a direction heading up."
2106 ob$(6)="down: a direction heading down."
2107 ob$(7)="lantern: this brass lantern has rusted hinges."
2108 ob$(8)="oil: a flask of lantern oil. Useless without it."
2109 ob$(9)="rope: a long coil of rope about 100' in length."
2110 ob$(10)="pole: a long wooden pole about 10 feet in length."
2111 ob$(11)="key: this small wooden key has several dents."
2112 ob$(12)="scroll: an ancient scroll with unknown script."
2113 ob$(13)="food: standard food rations lasting up to two weeks."
2114 ob$(14)="bottle: a small glass bottle. It appears empty.":IF bg=1 THEN ob$(14)="bottle: a small glass bottle. It is filled with water."
2115 ob$(15)="water: you notice the water is crystal clear."
2116 ob$(16)="helmet: a brass helmet stained in blood. It looks useful."
2117 ob$(17)="shield: a long metal shield with a bird emblazoned on it."
2118 ob$(18)="boots: a pair of leather boots. They look fairly sturdy."
2119 ob$(19)="armor: a chainlinked suit of brass armor. It appears heavy."
2120 ob$(20)="gauntlets: a pair of metal gauntlets. They look well built."
2121 ob$(21)="ring: this small iron ring glows with a soft hue."
2122 ob$(22)="amulet: a small amulet worn around the neck. It appears delicate."
2123 ob$(23)="dagger: a small metal dagger. It appears slightly worn."
2124 ob$(24)="sword: a fine brass sword. It has sharp edges."
2125 ob$(25)="longsword: a longsword with a double blade. It looks deadly."
2126 ob$(26)="scimitar: a magical scimitar. It glows with a strong light."
2127 ob$(27)="broadsword: this broadsword is very heavy, but powerful nonetheless."
2128 ob$(28)="orb: this is the sacred Orb of Light, said to be crafted from light itself!"
2129 ob$(29)="shroud: this holy shroud glows from within with a sacred light!"
2130 ob$(30)="chest: this heavy wooden treasure chest may contain lots of gold!"
2131 ob$(31)="rat: a common rat. It looks diseased. Ugh!"
2132 ob$(32)="skeleton: a skeleton with blood-soaked bones. He looks mean and nasty."
2133 ob$(33)="warrior: a strong warrior with flowing hair and a powerful gaze. He looks mean."
2134 ob$(34)="goblin: a menacing goblin with an ugly face and putrid teeth. He growls at you!"
2135 ob$(35)="hobbit: a simple hobbit, somehow lost. How did he get down here?"
2136 ob$(36)="knight: a strong knight from the countryside. He stands powerfully nearby."
2137 ob$(37)="barbarian: an evil barbarian. He seems very strong and evil, indeed!"
2138 ob$(38)="villager: a common villager. He smiles at you briefly before passing."
2139 ob$(39)="sorcerer: an evil sorcerer with a deadly gaze. He seems like a powerful man!"
2140 ob$(40)="thief: a no-good thief."
2141 ob$(41)="ghost: a translucent spectre haunting the caverns. He appears ghostly."
2142 ob$(42)="paladin: a strong paladin with a persistent manner. He seems content."
2143 ob$(43)="elf: a funny looking elf with pointed ears. He appears friendly."
2144 ob$(44)="bard: a traveling bard who plays a harp. He wears a beard and a frock."
2145 ob$(45)="werewolf: a vicious werewolf, with steely blue eyes. It watches you intently."
2146 ob$(46)="vampire: an evil vampire with fangs and blood-stained teeth. Watch out!"
2147 ob$(47)="adventurer: a common adventurer from out of town. She seems friendly enough."
2148 ob$(48)="demigorgon: a hideously evil being with massive wings and sharp claws!"
2149 ob$(49)="glowworm: this worm glows from within with a strong greenish hue. Wow!"
2150 ob$(50)="dragon: a powerful dragon with tough scales and powerful claws."
2151 RETURN
2500 vb$(1)="go":vb$(2)="get":vb$(3)="drop":vb$(4)="wear":vb$(5)="remove":vb$(6)="wield":vb$(7)="unwield":vb$(8)="use":vb$(9)="light":vb$(10)="read"
2501 vb$(11)="examine":vb$(12)="open":vb$(13)="kill":vb$(14)="climb":vb$(15)="enter":vb$(16)="quit"
2502 vb$(16)="save":mh(31)=48:mh(32)=180:mh(33)=248:mh(34)=172:mh(35)=84:mh(36)=288:mh(37)=400:mh(38)=120:mh(39)=480:mh(40)=58
2503 mh(41)=382:mh(42)=496:mh(43)=346:mh(44)=312:mh(45)=678:mh(46)=728:mh(47)=210:mh(48)=1080:mh(49)=280:mh(50)=896
2504 RETURN
2599 REM extended use
2600 IF n=7 AND lo(7)=0 THEN IF lo(8)=0 THEN IF lt=0 THEN lt=1:COLOR 7,1:PRINT "Click!":COLOR 15,1:PRINT "The lantern is now aglow.":ob$(7)="lantern: a brass lantern with rusted hinges. It is glowing softly.":GOTO 170
2601 IF n=7 AND lo(7)=0 THEN IF lo(8)=0 THEN IF lt=1 THEN COLOR 15,1:PRINT "The lantern is already on.":GOTO 170
2602 IF n=7 AND lo(7)=0 THEN IF lo(8)<>0 THEN PRINT "You need the oil in order to use the lantern!":GOTO 170
2603 IF n=8 AND lo(8)=0 THEN COLOR 15,1:PRINT "No good by itself.":GOTO 170
2604 IF n=9 THEN IF lo(9)=0 THEN IF rm=35 THEN rm=51:PRINT "You use the rope...":COLOR 7,1:PRINT "You descend slowly down the shaft...":COLOR 15,1:GOTO 60
2605 IF n=9 THEN IF lo(9)=0 THEN IF rm=51 THEN rm=35:PRINT "You use the rope...":COLOR 7,1:PRINT "You ascend slowly up the shaft...":COLOR 15,1:GOTO 60
2606 IF n=9 THEN IF lo(9)=0 THEN IF rm=88 THEN rm=89:PRINT "You use the rope...":COLOR 7,1:PRINT "You descend slowly down the shaft...":COLOR 15,1:GOTO 60
2607 IF n=9 THEN IF lo(9)=0 THEN IF rm=91 THEN rm=90:PRINT "You use the rope...":COLOR 7,1:PRINT "You ascend slowly up the shaft...":COLOR 15,1:GOTO 60
2608 IF n=9 THEN IF lo(9)=0 THEN PRINT "The rope cannot be used here.":GOTO 170
2609 IF n=10 THEN IF lo(10)=0 THEN IF rm=88 OR rm=91 THEN PRINT "The pole is too small to be of any use here.":GOTO 170
2610 IF n=10 THEN IF lo(10)=0 THEN IF rm=38 OR rm=39 THEN PRINT "You use the pole...":COLOR 7,1:PRINT "Some gold is knocked down, so you pick it up!":g=g+25:GOTO 170
2611 IF n=10 THEN IF lo(10)=0 THEN PRINT "The pole has no use here.":GOTO 170
2612 IF n=11 AND lo(11)=0 THEN IF rm=20 AND lk=0 THEN lk=1:COLOR 7,1:PRINT "Click!":COLOR 15,1:PRINT "The door is now unlocked!":GOTO 170
2613 IF n=11 AND lo(11)=0 THEN IF rm=20 AND lk=1 THEN COLOR 15,1:PRINT "The door is already unlocked.":GOTO 170
2614 IF n=11 AND lo(11)=0 THEN PRINT "The key has no use here.":GOTO 170
2615 IF n=12 AND lo(12)=0 THEN PRINT "Try reading it instead.":GOTO 170
2616 IF n=13 AND lo(13)=0 THEN PRINT "You must eat the food instead.":GOTO 170
2617 IF n=14 AND lo(14)=0 THEN IF rm>90 THEN lo(15)=0:wa=500:bg=1:PRINT "You fill the bottle with water.":GOTO 170
2618 IF n=14 AND lo(14)=0 THEN PRINT "The bottle has no use here. Try near a source of water instead.":GOTO 170
2619 IF n=15 AND lo(15)=0 THEN PRINT "Try drinking the water instead.":GOTO 170
2620 IF lo(n)=0 THEN IF n>15 AND n<28 THEN PRINT "That has no use here.":GOTO 170
2621 IF lo(n)=0 THEN IF n=28 THEN IF lo(49)=rm THEN lo(49)=66:PRINT "Frightened, the glowworm runs away!":GOTO 170
2622 IF lo(n)=0 THEN IF n=28 THEN IF lo(45)=rm THEN COLOR 15,1:PRINT"The werewolf laughs at you! He growls ";:COLOR 4,1:PRINT "'I'm not frightened":PRINT "by your orb! BWHAHAHAHA!'":GOTO 170
2623 IF lo(n)=0 THEN IF n=28 THEN IF lo(n>30)=rm THEN COLOR 15,1:PRINT "The "no$(n)" laughs at you! It says ";:COLOR 4,1:PRINT "'That orb doesn't":PRINT "frighten me! FOOL!'":GOTO 170
2624 IF lo(n)=0 THEN IF n=28 THEN PRINT "The orb has no use here. Try someplace else.":GOTO 170
2625 IF lo(n)=0 THEN IF n=29 THEN PRINT "The shroud cannot be used, only worn.":GOTO 170
2626 IF lo(n)=0 THEN IF n=30 THEN PRINT "The treasure chest cannot be used, only opened.":GOTO 170
2627 COLOR 15,1:PRINT "What you expected didn't happen.":GOTO 170
2999 END
3000 IF a$="score" OR a$="?" OR a$="sc" THEN GOTO 3100
3001 COLOR 7,1:PRINT "This game is a text adventure. You play by entering in commands as follows:":PRINT
3002 COLOR 11,1:PRINT "go north (or south, east, west, up or down)"
3003 COLOR 11,1:PRINT "get dagger"
3004 COLOR 11,1:PRINT "drop dagger"
3005 COLOR 11,1:PRINT "wear armor"
3006 COLOR 11,1:PRINT "remove armor"
3007 COLOR 11,1:PRINT "wield dagger"
3008 COLOR 11,1:PRINT "unwield dagger"
3009 COLOR 11,1:PRINT "use rope"
3010 COLOR 11,1:PRINT "light lantern"
3011 COLOR 11,1:PRINT "read scroll"
3012 COLOR 11,1:PRINT "examine dragon"
3013 COLOR 11,1:PRINT "unlock door"
3014 COLOR 11,1:PRINT "kill dragon"
3015 COLOR 11,1:PRINT "climb rope"
3016 COLOR 11,1:PRINT "enter pools"
3017 COLOR 11,1:PRINT "look"
3018 COLOR 11,1:PRINT "inventory"
3019 COLOR 11,1:PRINT "save"
3020 COLOR 11,1:PRINT "score (or ?)"
3021 COLOR 11,1:PRINT "quit":PRINT:COLOR 15,1:PRINT"If you have any questions, please email me at: ";:COLOR 14,1:PRINT "dunric@yahoo.com":GOTO 170
3100 COLOR 15,1:PRINT "You are "na$" the cave explorer!"
3101 PRINT "You have "hp" hit points (of "hm"), and carry"
3102 PRINT "with you "g" gold coins. You also have "ex
3103 PRINT "experience points.":COLOR 14,1:PRINT "Type 'i' or 'inventory' for objects carried.":GOTO 170
3200 return
