
game_generation = 1;
game_metrics = null;
game_streamout = new Array();
game_streamclear = false;
game_streamdisable = false;

/* Print a line of text. (Or several lines, if the argument contains \n
   characters.)

   The optional second argument is the text style. The standard glkote.css
   file defines all the usual Glk styles: 'normal', 'emphasized' (italics),
   'preformatted' (fixed-width), 'subheader' (bold), 'header' (large bold),
   'alert', 'note', and 'input'.

   If the third argument is true, the text is appended to the previous
   line instead of starting a new line.
*/
function say(val, style, runon) {
  if (style == undefined)
    style = 'normal';
  var ls = val.split('\n');
  for (ix=0; ix<ls.length; ix++) {
    if (runon) {
      if (ls[ix])
        game_streamout.push({ content: [style, ls[ix]], append: 'true' });
      runon = false;
    }
    else {
      if (ls[ix])
        game_streamout.push({ content: [style, ls[ix]] });
      else
        game_streamout.push({ });
    }
  }
}

/* Print a line of text, appending it to the previous line. This is a
   clearer shortcut for say(val, style, true).
*/
function say_runon(val, style) {
  say(val, style, true);
}

function say_hyperlink(val, link) {
  game_streamout.push({ content: [{style:'normal', hyperlink:link, text:val}], append: 'true' });
}

function clearwindow() {
  game_streamclear = true;
}

function disablewindow() {
  game_streamdisable = true;
}

/* This is the top-level game event hook. It's all set up for a basic
   game that accepts line input. */
function game_accept(res) {
  if (res.type == 'init') {
    game_metrics = res.metrics;
    startup();
  }
  else if (res.type == 'arrange') {
    game_metrics = res.metrics;
  }
  else if (res.type == 'line') {
    say_runon(res.value, 'input');
    respond(res.value);
  }
  else if (res.type == 'hyperlink') {
    respond(res.value);
  }

  game_select();
}

/* This constructs the game display update and sends it to the display.
   It's all set up for a basic game that accepts line input. */
function game_select() {
  game_generation = game_generation+1;

  var metrics = game_metrics;
  var pwidth = metrics.width;
  var pheight = metrics.height;

  var argw = [
    { id: 1, type: 'buffer', rock: 11,
      left: metrics.outspacingx,
      top: metrics.outspacingy,
      width: pwidth-(2*metrics.outspacingx),
      height: pheight-(metrics.outspacingy+metrics.outspacingy) }
  ];

  var argc = [ ];
  if (game_streamout.length) {
    var obj = { id: 1 };
    if (game_streamout.length)
      obj.text = game_streamout;
    if (game_streamclear)
      obj.clear = true;
    argc.push(obj);
  }

  var argi = [ 
    { id: 1, gen: game_generation, hyperlink: true }
  ];

  var arg = { type:'update', gen:game_generation, windows:argw, content:argc, input:argi };

  if (game_streamdisable)
    arg.disable = true;

  GlkOte.update(arg);

  game_streamout.length = 0;
  game_streamclear = false;
}

/* The game interface object. */
Game = {
  accept: game_accept,
  spacing: 0
};

$(document).ready(function() {
        GlkOte.init();
    });
