function ending()
	image("courtroom", "cover")
	clearText()

	text [[You hitch up your skirts in your fists and hurtle towards the main doors.]]

	text [[They're heavy and ill-maintained, but you're able to pull one of the doors open and hurtle into the darkened corridor outside.]]

	choice("Keep running.", "ending_keepRunning")
end

function ending_keepRunning()
	image("dungeon_moss", "cover")

	text [[But what are you going to do now? You don't even remember the route you came, and you never, ever, *ever* want to see the inside of that courtroom again as long as you live.]]

	choice("Just keep running, then!", "ending_keepRunning2")
end

function ending_keepRunning2()
	image("dungeon_stairs", "cover")

	text [[Trying not to think about the banging, squawking and hissing from behind you, you gallop down a staircase. As you get further away from the entryway, the air gets darker and darker. If you carry on, you soon won't be able to see your hand in front of your face.]]

	choice("Not this way.", "ending_darker")
	choice("Push on.", "ending_pushOn")
end

function ending_darker()
	text [[Where else can you go?]]
	choice("Push on.", "ending_pushOn")
end

function ending_pushOn()
	clearText()
	image("dungeon_hole", "cover")
	text [[You slow to a walk, throat aching from your panting for breath. You keep one hand on the wall, but then you're worried about stepping on your skirt.]]

	choice([[Can adders see in the dark?]], "ending_adders")
end

function ending_adders()
	text [[No, they don't have very good eyesight at all, and their hearing is even worse. But that's because they don't need it! Aren't you glad you know all this! Little Armeline in her room by herself all day with all her books.]]

	text [[Snakes don't need to be able to see well in the dark, because their sense of smell is so excellent that they could probably tell what you ate for breakfast just from the trace left by your fingers down this stone wall.]]

	choice("Even I don't know what my last breakfast was.", "ending_breakfast")
end

function ending_breakfast()
	text [[You've been doing alright at ignoring the physical pain in your stomach, and the sour taste and smell of your own breath. But you weren't able to run as fast as you would like. Because you're empty.]]

	if cheesePasty then
		text [[And now, you're definitely going to have to give up on getting that cheese pasty off Milpreve.]]
	end

	text [[Hey, do you think if you starve, you'll end up like Hobson?]]

	text [[Do you think if you were a skeleton, you would be like Hobson? Or was that just what he was always like?]]

	text [[You're going to find out.]]

	choice([[Wonder what it feels like to still have an *animus* while your eyeballs decompose in your own skull.]], "ending_wonder")
	choice([[NO, DO NOT WONDER THAT.]], "ending_wonder")
end

function ending_wonder()
	text [[You don't have to wonder - everything is so dark that it feels like it's already happening! That almost painful feeling of your eye trying to find something to look at probably feels like a maggot would. ]]

	text [[How long have you been descending? Do you even know which way up you are?]]

	text [[Every step, it feels like you could just float off into the atmosphere like a candle balloon.]]

	text [[Can you hear that? That deep, deep pounding coming from under you, of fleet feet on the run?]]

	choice([[It's definitely Milpreve.]], "ending_itsMilpreve")
	choice([[It's definitely Milpreve with a unit of 100 armed empsychons.]], "ending_empsychons")
	choice([[NO, I CAN'T HEAR ANYTHING!]], "ending_hearNothing")
end

function ending_itsMilpreve()
	text [[Of course.]]
	jump "ending_horseNoise"
end

function ending_empsychons()
	text [[Obviously.]]
	jump "ending_horseNoise"
end

function ending_hearNothing()
	text [[Oh, you definitely can.]]
	jump "ending_horseNoise"
end

function ending_horseNoise()
	text [[And the sound is getting closer. In fact, it sounds like it's coming towards you. Or are you coming toward it? In fact, it sounds like it'll be right in front of you right…]]

	text [[…now!]]

	choice([["NO!"]], "ending_no")
end

function ending_no()
	text [["No what?"]]

	text [[A whinny and a clatter of hooves. The voice is not what you expected.]]

	text [["I didn't think I'd see you all the way out here! I rather hoped I could burst dramatically into the courtroom. Why do you have your eyes closed?"]]

	text [[It is at this point that you realise you had squeezed your eyes closed in the dark and forgot to reopen them.]]

	choice([[Open your eyes.]], "ending_hihob")
end

function ending_hihob()
	image "hobson_horse"

	text [[In front of you is Hobson, mounted on the gigantic, sweet-scented horse you'd seen in his stables. Atop his head is some kind of macaronic periwig.]]

	choice([["Can we leave very, very quickly?"]], "ending_leave")
end

function ending_leave()
	text [["Naturally! That's what the horse is for, you see."]]

	jump "ending_ride"
end

function ending_ride()
	if visited("ending_rightWay", "ending_hobsonWhatNow", "ending_city", "ending_testimony", "ending_attire") then
		jump "ending_nearGatefold"
	end

	if not visited "ending_ride" then
		clearText()

		image("exit", "cover")

		text [[With your fists clinging onto Hobson's ridiculous woolen overcoat, you watch as the fading grandeur of the Citadel falls away into unfinished courtyards and empty gardens.]]

		image "hobson_horse"

		text [[Perhaps it is because of the concentration required to ride at such a speed - you are relieved to have his spindly body protecting your face from the grit in the air - Hobson seems unusually taciturn during the ride. Eventually, you decide to break the silence yourself.]]


	end

	choiceOnce([["Are we going the right way?"]], "ending_rightWay")
	choiceOnce([["What are you going to do now? When you get back, I mean."]], "ending_hobsonWhatNow")
	choiceOnce([["What do you think will happen to the city?"]], "ending_city")
	choiceOnce([["About your testimony…"]], "ending_testimony")
	choiceOnce([["About your attire..."]], "ending_attire")
end

function ending_rightWay()
	text [["Oh, yes. Perhaps you're not attuned to this kind of thing – you are the upland sort, after all – but these bones can feel a *hum* in the air. Why, it's as good as a compass!]]
	text [["Considerably better, in fact, since every compass in the city has been acting peculiar ever since the relocation. They just spin and spin. Strangest thing. I'm sure it was somebody's job to fix them, but I can't quite remember…"]]

	jump "ending_ride"
end

function ending_hobsonWhatNow()
	text [[He laughs. "Why, tend to the stables, of course! That is my job, after all. And, indeed, I have a whole symphony to write! Quite a daunting prospect, I'm sure you can imagine. All this time, chafing against the rules handed down by that lackwit lizard, and now…" He trails off.]]

	text [["Do you know, I'm finding it quite difficult to know where to start? I spent an awful lot of time thinking about writing music, but unable to, of course, owing to that ridiculous serpent and his ill-judged austerity, his narrow-minded tastelessness, his complete ignorance of the finer things! And, now…"]]

	text [["...But of course it should be easy! What with the final impediment gone, and, really, all the time one could possibly need. Why, I believe I could start as early as today!" He hesitates. "Or perhaps tomorrow!"]]

	jump "ending_ride"
end

function ending_city()
	text [["I expect there will be some changes, no doubt." He shifts uncomfortably.]]

	choice([["What do *you* think should happen?"]], "ending_think")
end

function ending_think()
	text [["For Gallos to return to its *ideals!*" He coughs, which is impressive. "With Milpreve gone, there should be, well, an awful lot more free time for everyone, let me tell you! We could really get things going again, bring the city back to the cultural heights it occupied during those halcyon days when…when…" He seems to be losing his train of thought.]]

	choice([["Was that *really* what it was like? Back before the relocation?"]], "ending_really")
end

function ending_really()
	text [["More or less," he says, more hesitant now. "There was a lot of talk about what sort of place Gallos *could* be, with everyone freed from the shackles of tedium and toil. People had a great surplus of optimism in those days, make no mistake. They needed it, really, what with the circumstances, you know. The wars, and…other things."]]
	text [[He falls silent.]]

	jump "ending_ride"
end

function ending_testimony()
	text [["What about it?"]]
	choice([["'Her Serenity's *rules*… *rap our knuckles*… to what *measure*-'? I just got that. Very nice."]], "ending_jokes")
end

function ending_jokes()
	text [[Hobson looks relieved. "I was worried about your blank expression when I said that. But it wasn't for your sake!]]

	text [["Milpreve hates Citizens playing with words for the same reason my old stablemaster used to hate me playing with flints. If he recorded some alliterations attached to the wrong allusions, the whole place could go up in a puff of *aphorismus.*"]]

	text [["With him gone, though, we'll be able to pun as much as we want. Well, I will." Hobson goes quiet. "I don't know if there's anybody else left who would be receptive, even as much to get angry with me. And what's the point of making puns if people don't get angry?"]]

	jump "ending_ride"
end

function ending_attire()
	text [[Hobson gives an excited squeak.]]

	text [["Oh, this old thing? This is just something I had lying around."]]

	text [[You open your mouth to ask for more information, as he clearly wants, but he can't hold in his excitement enough to let you talk.]]

	text [["It's a real Gethrick cassock and battlewig!]]
	text [["In the last days before the Relocation, I challenged a commander of the Prince-Bishop's men to dice and it was the luckiest run I've ever had! Roll after roll, all perfect. I took every last stitch on him."]]
	text [[He giggles. "You can't see it but I'm also in the fellow's drawers."]]
	jump "ending_ride"
end

function ending_nearGatefold()
	text [[The two of you continue to ride. The landscape around here is bleak and craggy, with stones jutting from the ground at odd angles. A crepuscular haze suffuses everything, but in the distance you can see an indistinct suggestion of a treeline. Ragwort tramps through thick ferns and bracken. You think that he snorts every so often, but then realise it is the sporadic puffs of steam that emerge from his joints.]]

	text [[After some time without conversation, you notice that Hobson appears to be slumping forward in the saddle and listing carelessly to one side.]]

	choice([["Hobson, are you quite all right?"]], "ending_allRight")
end

function ending_allRight()
	text [[Hobson rights his skeletal form and shakes himself. "It's getting a little hard-going, I'm afraid. I really shouldn't get too much closer to the gatefold, I shouldn't think. Of course it's safe for you, perfectly safe, but, for some of us, things are a little more precarious." His bones are making a clicking sound and you realise that he's shaking.]]

	choice([["Perhaps I should go the rest of the way on my own."]], "ending_ridiculous")
end

function ending_ridiculous()
	text [["Ridiculous!" He points a bony finger up in the air for emphasis, and swings abruptly to the left. With some effort he manages to regain his perpendicularity. "I shall'n't hear of it. There could be any sort of monsters and malefactors in such a wasted blastland as this. Brigands or witchbandits or thorn-folk or grindylow or…why I've heard tell even the *living dead* can be found in such a place!]]

	text [["Can you imagine," he murmurs. "Can you imagine."]]

	text [[Ragwort has by now slowed down almost to a stop. Hobson doesn't seem to have noticed.]]

	choice([["Hobson, I really think it's not good for you to travel this far from the city. I can find my way to the gatefold by myself, don't worry."]], "ending_goAlone")
end

function ending_goAlone()
	text [["It's…yes." Hobson doesn't move while you dismount. "Straight line, you know, just keep…just keep on, can't miss it…"]]

	text [["Thank you, Hobson." You gently guide Ragwort around to face the rough direction of the city and give him an encouraging pat. He trots off cheerfully.]]

	text [["Goodbye!" you call after, and then, "Thank you for everything!". You hope he heard you.]]

	jump "ending_woods"
end

function ending_woods()
	clearImage()
	clearText()

	text [[You turn to face the distant woods and continue on. You have no clear sense of how long you've been travelling, and you feel a little fear at the prospect of losing your way in this trackless hinterland. As you travel, though, you become aware of a subtle *slantedness* around you, an insistent prickling that feels profoundly unfamiliar, a piercing olfactory sensation no herbal concoction could ever replicate.]]

	text [[Beneath the unearthly sky, the bracken rises to a thick overgrown tangle, and your progress becomes arduous. The foliage envelops you until you can no longer see anything above, and can only keep pressing forward, following the stinging sharpness of the air.]]

	text [[A flicker in the corner of your eye catches your attention. Turning, you see a mass of branches and roots that draws itself up, many-limbed, resolving into the now-familiar figure of Scowles.]]

	image("scowles", "cover")

	text [["I CAME TO SAY GOODBYE."]]

	text [[You're not sure what to say. "Thank you for…all your help."]]

	text [["NO." He rustles slightly. "IT IS YOU WHO WERE OF HELP.]]

	text [["FOR AN AGE NOW THE CITY OF GALLOS HAS BEEN IN ANGUISH. THEIR QUEEN WAS A LOSS THEY COULD NOT CONTEMPLATE. AND SO THEY TRIED TO KEEP THEIR WAYS LONG AFTER THEIR TIME HAD PASSED.]]

	text [["YOUR ARRIVAL WAS A RARE CHANCE. YOU, AN OUTSIDE FORCE, ABLE TO TIP THE BALANCE AND BRING GALLOS TO ITS SENSES."]]

	jump "ending_scowles"
end

function ending_scowles()
	if visited("ending_why", "ending_scowlesWhatNow", "ending_scowlesMilpreve", "ending_lost") then
		jump "ending_return"
	end
	choiceOnce([["Is that…why you brought me to the city?"]], "ending_why")
	choiceOnce([["What will happen to the city now? Will everyone be all right?"]], "ending_scowlesWhatNow")
	choiceOnce([["I know Milpreve was awful to you, but perhaps he wasn't really as bad as all that?]], "ending_scowlesMilpreve")
	choiceOnce([["Do you know the way to the gatefold from here? I think I might be lost."]], "ending_lost")
end

function ending_why()
	text [["YES. THE UNDERMARCH HAD NEED OF YOU AND SO I DECIDED TO ACT."]]
	jump "ending_scowles"
end

function ending_scowlesWhatNow()
	text [["THE RULE OF MILPREVE IS AT AN END. PERHAPS GALLOS WILL ENDURE FOR ANOTHER AGE. PERHAPS NOT."]]
	jump "ending_scowles"
end

function ending_scowlesMilpreve()
	text [["I'd hate to think of anything to happen to him, even if he was sort of a tyrant."]]

	text [["MILPREVE'S POWER FAR EXCEEDED HIS CAPABILITY. AS IT WAS WITH GWENHAELA, AND WITH SO MANY OTHERS. I AM SURE THAT HE WILL BECOME A DEPENDABLE MEMBER OF SOCIETY, GIVEN TIME."]]

	jump "ending_scowles"
end

function ending_lost()
	text [["YOU HAVE PASSED THROUGH THE GATEFOLD. CONTINUE UPON YOUR PATH AND YOU WILL RETURN TO THE PLACE WHERE I FOUND YOU."]]
	jump "ending_scowles"
end

function ending_return()
	clearImage()

	text [[Night is beginning to fall. Scowles melts into it.]]

	image("woods", "cover")

	text [[The vegetation begins to thin as you make your way through, and the acrid smell that filled your nostrils is displaced by the more familiar scent of grass, cow parsley and gorse, just as you remember from the woods near your aunt's house when you were a child.]]

	text [[You look back, to try and see the gatefold shimmering above, but in the hazy twilight you find it increasingly hard to make out anything at all.]]

	text [[As you turn to continue home, you are startled momentarily to see a small adder on the path in front of you, slithering away rapidly into the long grass.]]

	jump "ending_river"
end

function ending_river()

	image("river", "cover")

	text [[After a short while you reach the edge of a little river that runs through the woods. You have never seen the water looking such a normal colour as this, but the embankment looks so much like the areas downstream of the River Rue. You head along its bank, in the direction from where it flows - towards the rapidly dying embers in the sky.]]

	text [[It's cold. You should have worn something warmer.]]

	text [[The Moon is full in the cloudless sky, so you can at least see a little; pale outlines in the dark. An owl hoots somewhere high above, and you think of the vultures again. It must be hours since you saw them in the courtroom, saw them for the last time, holding back Milpreve to give you a chance to escape.]]

	image("pentrith", "cover")

	text [[You shiver a little. You can't be too far off now. You can see a mass of dark shapes in the distance, and you hope fervently that it might be Ruan-le-pentrith. But your heart sinks as you study the skyline – if it really was Pentrith, you'd surely be able to see the dyers' workshop from here, with its tall chimney to carry the caustic fumes away.]]

	text [[In the moonlight you catch sight of a church spire, high on a hill. No! It *is* Pentrith!]]

	text [[But you can't see the chimney anywhere. And the river water didn't have a speck of dyer's-pink. Something must have happened to the workshop! Perhaps it…burned down? How long were you away? No more than a day, surely?]]

	text [[You duck under a branch, instinctively reaching up to steady the garland of flowers on your head.]]

	text [["*Gwenhaela!* For heaven's sake, where have you *been*, child?"]]

	text [[The sound of your mother's voice brings you back to earth immediately, and you turn to see her, concern etched in her face, and you find your relief admixed with a tincture of annoyance, because she knows you're by no means a *child*, you'll be sixteen in a few short months, ready to carve your own place in the world, to go out and to study the most advanced philosophical arts under the most eminent scholars yet living, so that you can finally realise your ambition, the most beautiful city ever seen by human eyes, and the ages of confusion and chaos will be at an end, as finally humanity will have a singular shining beacon to guide them, no more toil, no more tedium, a euphoria of purpose for all,]]

	clearText()

	jump "ending_credits"
end

function ending_credits()

	image("lute")

	text [[#Credits]]

	text [[*An interactive fiction game by* Axile Studio]]

	text [[*Made in* Folia]]

	text [[*Written, designed and scripted by* Alex McGivern and Holly Boson]]

	text [[*Produced by* Holly Boson]]

	text [[*The visual assets used in the game came from various public domain sources preserved by the British Library, the Library of Congress, and the Internet Archive. Please support their efforts to share art and culture.*]]

	line [[Support the Internet Archive: https://archive.org/donate]]

	line [[Support the British Library: https://support.bl.uk/]]

	line [[Support the Library of Congress: https://crowd.loc.gov]]
end
