/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.filemanagement;

import eu.irreality.age.InputOutputClient;
import eu.irreality.age.World;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class WorldLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static World loadWorldFromPath(String moduledir, Vector gameLog, InputOutputClient io, Object mundoSemaphore) {
        World theWorld = null;
        File inputAsFile = new File(moduledir);
        if (inputAsFile.isFile()) {
            System.out.println("Attempting world location: " + inputAsFile);
            try {
                theWorld = new World(moduledir, io, false);
                System.out.println("World generated.\n");
                if (mundoSemaphore != null) {
                    Object object = mundoSemaphore;
                    synchronized (object) {
                        mundoSemaphore.notifyAll();
                    }
                }
                gameLog.addElement(inputAsFile.getAbsolutePath());
            }
            catch (IOException ioe) {
                io.write("No puedo leer el fichero del mundo: " + inputAsFile + "\n");
                ioe.printStackTrace();
                return null;
            }
        }
        try {
            System.out.println("Attempting world location: " + moduledir + "/world.xml");
            theWorld = new World(moduledir + "/world.xml", io, false);
            System.out.println("World generated.\n");
            if (mundoSemaphore != null) {
                Object ioe = mundoSemaphore;
                synchronized (ioe) {
                    mundoSemaphore.notifyAll();
                }
            }
            gameLog.addElement(moduledir + "/world.xml");
        }
        catch (IOException e) {
            System.out.println(e);
            io.write("No puedo encontrar el mundo en el directorio " + moduledir + "\n");
        }
        if (theWorld == null) {
            io.write("No encontrado el fichero del mundo. Tal vez el directorio seleccionado [" + moduledir + "] no sea un directorio de mundo AGE v\u00e1lido.\n");
            return null;
        }
        return theWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static World loadWorld(String moduledir, Vector gameLog, InputOutputClient io, Object mundoSemaphore) {
        World theWorld = null;
        try {
            URL url;
            block10: {
                url = null;
                try {
                    url = new URL(moduledir);
                }
                catch (MalformedURLException mue) {
                    url = WorldLoader.class.getClassLoader().getResource(moduledir);
                    if (url != null) break block10;
                    throw mue;
                }
            }
            if (url.toString().endsWith("/")) {
                url = new URL(url.toString() + "world.xml");
            }
            theWorld = new World(url, io, false);
            System.out.println("World generated.\n");
            if (mundoSemaphore != null) {
                Object object = mundoSemaphore;
                synchronized (object) {
                    mundoSemaphore.notifyAll();
                }
            }
            gameLog.addElement(theWorld.getResource("world.xml").toString());
            return theWorld;
        }
        catch (MalformedURLException e1) {
            return WorldLoader.loadWorldFromPath(moduledir, gameLog, io, mundoSemaphore);
        }
        catch (IOException ioe) {
            io.write("No puedo leer el fichero del mundo: " + moduledir + "\n");
            ioe.printStackTrace();
            return null;
        }
    }
}

