/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.debug;

import bsh.EvalError;
import bsh.TargetError;
import eu.irreality.age.World;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionPrinter {
    public static String getStackTrace(Throwable aThrowable) {
        if (aThrowable == null) {
            return "[no exception]";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String getExceptionReport(TargetError te) {
        StringBuffer report = new StringBuffer();
        report.append("**\n");
        report.append("Error: " + te.printTargetError((Throwable)te));
        report.append("Location: " + te.getErrorSourceFile() + "\n");
        report.append("Line: " + te.getErrorLineNumber() + "\n");
        report.append("Offending text: " + te.getErrorText() + "\n");
        report.append("Message: " + te.getMessage() + "\n");
        report.append("Detailed trace: " + ExceptionPrinter.getStackTrace(te) + "\n");
        if (te.getCause() != null) {
            report.append("Cause report: " + ExceptionPrinter.getExceptionReport(te.getCause()));
        }
        if (te.getTarget() != null && te.getTarget() != te) {
            report.append("Target report: " + ExceptionPrinter.getExceptionReport(te.getTarget()));
        }
        report.append("**\n");
        return report.toString();
    }

    public static String getExceptionReport(EvalError te) {
        StringBuffer report = new StringBuffer();
        report.append("File: " + te.getErrorSourceFile() + "\n");
        report.append("Stack trace: " + ExceptionPrinter.getStackTrace(te) + "\n");
        report.append("Cause report: " + ExceptionPrinter.getExceptionReport(te.getCause()));
        report.append("\n");
        return report.toString();
    }

    public static String getExceptionReport(EvalError te, String aRoutine, Object theCaller, Object[] theArguments) {
        StringBuffer report = new StringBuffer();
        report.append("Syntax error in BeanShell code in object: " + theCaller + "\n");
        report.append("Loaded to call method " + (aRoutine == null ? "(no method)" : aRoutine) + "\n");
        report.append(theArguments == null || theArguments.length == 0 ? "(with no arguments)" : "With arguments: ");
        if (theArguments != null) {
            for (int i = 0; i < theArguments.length; ++i) {
                report.append(theArguments[i] + " ");
            }
        }
        report.append("\n");
        report.append(ExceptionPrinter.getExceptionReport(te));
        return report.toString();
    }

    public static void reportEvalError(EvalError ee, World w, String aRoutine, Object theCaller, Object[] theArguments) {
        w.writeError(ExceptionPrinter.getExceptionReport(ee, aRoutine, theCaller, theArguments));
    }

    public static String getExceptionReport(Throwable e) {
        return ExceptionPrinter.getStackTrace(e);
    }
}

