/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyEntry {
    private String propertyName;
    private String propertyValue;
    private Object propertyValueObject = null;
    private long timeUnitsLeft;

    public Object clone() {
        PropertyEntry pe = new PropertyEntry(this.propertyName, this.propertyValue, this.timeUnitsLeft);
        pe.propertyValueObject = this.propertyValueObject;
        Debug.println("HAVE CLONED PROP: " + this.propertyName + "=" + this.propertyValue);
        return pe;
    }

    public String getName() {
        return this.propertyName;
    }

    public String getValue() {
        return this.propertyValue;
    }

    public long getTimeLeft() {
        return this.timeUnitsLeft;
    }

    public boolean getValueAsBoolean() {
        if (this.propertyValue == null | this.propertyValue.equals("")) {
            return false;
        }
        return this.propertyValue.equalsIgnoreCase("true") || this.propertyValue.equals("1") || this.propertyValue.equals("yes");
    }

    public int getValueAsInteger() {
        try {
            return Integer.valueOf(this.propertyValue);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public double getValueAsDouble() {
        try {
            return Double.valueOf(this.propertyValue);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public float getValueAsFloat() {
        try {
            return Float.valueOf(this.propertyValue).floatValue();
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    public Object getValueAsWrapper() {
        if ("true".equals(this.propertyValue)) {
            return new Boolean(true);
        }
        if ("false".equals(this.propertyValue)) {
            return new Boolean(false);
        }
        try {
            return Integer.valueOf(this.propertyValue);
        }
        catch (NumberFormatException nfe) {
            try {
                return Double.valueOf(this.propertyValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.propertyValue;
            }
        }
    }

    public Object getValueAsObject() {
        return this.propertyValueObject;
    }

    public PropertyEntry(String name, String value, long timeUnitsLeft) {
        this.propertyName = name;
        this.propertyValue = value;
        this.timeUnitsLeft = timeUnitsLeft;
    }

    public void setObjectValue(Object o) {
        this.propertyValueObject = o;
    }

    public void setTime(long l) {
        this.timeUnitsLeft = l;
    }

    public void setValueAndTime(String s, long l) {
        this.propertyValue = s;
        this.timeUnitsLeft = l;
    }

    public void setValue(boolean b, long l) {
        this.setValue(String.valueOf(b), l);
    }

    public void setValue(boolean b) {
        this.setValue(String.valueOf(b));
    }

    public void setValue(int i, long l) {
        this.setValue(String.valueOf(i), l);
    }

    public void setValue(int i) {
        this.setValue(String.valueOf(i));
    }

    public void setValue(Object o) {
        this.propertyValue = o != null ? o.toString() : "null";
        this.propertyValueObject = o;
    }

    public void setValue(Object o, long l) {
        this.propertyValue = o.toString();
        this.propertyValueObject = o;
        this.setTime(l);
    }

    public void decreaseTime() {
        --this.timeUnitsLeft;
    }

    public boolean needsUpdate() {
        return this.timeUnitsLeft <= 0L;
    }

    public String toString() {
        return this.propertyName + ":" + this.propertyValue + " (" + this.propertyValueObject + ") !" + this.timeUnitsLeft;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("PropertyEntry");
        suElemento.setAttribute("name", this.propertyName);
        suElemento.setAttribute("value", this.propertyValue);
        suElemento.setAttribute("timeUnitsLeft", String.valueOf(this.timeUnitsLeft));
        return suElemento;
    }

    public PropertyEntry(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("PropertyEntry node not Element");
        }
        Element e = (Element)n;
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("name attribute missing at PropertyEntry");
        }
        this.propertyName = e.getAttribute("name");
        if (!e.hasAttribute("value")) {
            throw new XMLtoWorldException("value attribute missing at PropertyEntry");
        }
        this.propertyValue = e.getAttribute("value");
        if (!e.hasAttribute("timeUnitsLeft")) {
            throw new XMLtoWorldException("timeUnitsLeft attribute missing at PropertyEntry");
        }
        try {
            this.timeUnitsLeft = Long.valueOf(e.getAttribute("timeUnitsLeft"));
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Wrong number format at timeUnitsLeft attribute, at PropertyEntry");
        }
    }
}

