/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Entity;
import eu.irreality.age.Mobile;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.StringMethods;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Description {
    protected String text;
    protected long comparand;
    protected long mask;
    protected List conditions;

    public Object clone() {
        Description nueva = new Description(this.text, this.comparand, this.mask);
        ArrayList<ObjectCode> nuevasCondiciones = new ArrayList<ObjectCode>();
        if (this.conditions != null) {
            for (int i = 0; i < this.conditions.size(); ++i) {
                nuevasCondiciones.add(((ObjectCode)this.conditions.get(i)).cloneIfNecessary());
            }
        }
        nueva.conditions = nuevasCondiciones;
        return nueva;
    }

    public Description(String ntext, long ncomparand, long nmask) {
        this.text = ntext;
        this.comparand = ncomparand;
        this.mask = nmask;
    }

    public boolean matches(long state) {
        return (this.mask & (state ^ this.comparand)) == 0L;
    }

    public boolean matchesConditions(Entity context, Entity viewer) {
        if (viewer == null) {
            return this.matchesConditions(context);
        }
        long comparand = (long)((Mobile)viewer).getRelationshipState(context) * (long)Math.pow(2.0, 32.0) + (long)context.getState();
        if (!this.matches(comparand)) {
            return false;
        }
        if (this.conditions == null) {
            return true;
        }
        for (int i = 0; i < this.conditions.size(); ++i) {
            ReturnValue rv = new ReturnValue(null);
            try {
                ((ObjectCode)this.conditions.get(i)).run(null, context, null, rv, new Object[][]{{"viewer", viewer}});
            }
            catch (TargetError te) {
                te.printStackTrace();
                continue;
            }
            if (!(rv.getRetVal() instanceof Boolean) || ((Boolean)rv.getRetVal()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean matchesConditions(Entity context) {
        if (!this.matches(context.getState())) {
            return false;
        }
        if (this.conditions == null) {
            return true;
        }
        for (int i = 0; i < this.conditions.size(); ++i) {
            ReturnValue rv = new ReturnValue(null);
            try {
                ((ObjectCode)this.conditions.get(i)).run(null, context, null, rv, new Object[][]{{"viewer", null}});
            }
            catch (TargetError te) {
                te.printStackTrace();
                continue;
            }
            if (!(rv.getRetVal() instanceof Boolean) || ((Boolean)rv.getRetVal()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Description");
        String theText = this.text;
        if (theText.startsWith("P$")) {
            theText = theText.substring(2);
            suElemento.setAttribute("properName", "true");
        } else if (theText.startsWith("N$")) {
            theText = theText.substring(2);
            suElemento.setAttribute("properName", "false");
        }
        Text t = doc.createTextNode(theText);
        suElemento.appendChild(t);
        suElemento.setAttribute("stateComparand", String.valueOf(this.comparand));
        suElemento.setAttribute("stateMask", String.valueOf(this.mask));
        if (this.conditions != null) {
            for (int i = 0; i < this.conditions.size(); ++i) {
                ObjectCode oc = (ObjectCode)this.conditions.get(i);
                Element el = (Element)oc.getXMLRepresentation(doc, "Condition");
                suElemento.appendChild(el);
            }
        }
        return suElemento;
    }

    public Description(World w, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Description node not element");
        }
        Element e = (Element)n;
        long comparand = 0L;
        long mask = 0L;
        try {
            if (e.hasAttribute("stateComparand")) {
                comparand = Long.valueOf(e.getAttribute("stateComparand"));
            }
            if (e.hasAttribute("stateMask")) {
                mask = Long.valueOf(e.getAttribute("stateMask"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute stateComparand or stateMask");
        }
        boolean terminamos = false;
        while (!terminamos) {
            try {
                Node hijo;
                for (hijo = n.getFirstChild(); !(hijo instanceof Text && hijo.getNodeValue().trim().length() != 0 || hijo == null); hijo = hijo.getNextSibling()) {
                }
                Text t = (Text)hijo;
                if (t == null) {
                    throw new XMLtoWorldException("Description node containing no text node");
                }
                this.comparand = comparand;
                this.mask = mask;
                this.text = t.getData().trim();
                this.text = StringMethods.textualSubstitution(this.text, "\\n", "\n");
                terminamos = true;
            }
            catch (ClassCastException cce) {}
        }
        NodeList nl = e.getElementsByTagName("Condition");
        for (int i = 0; i < nl.getLength(); ++i) {
            ObjectCode oc = new ObjectCode(w, (Element)nl.item(i));
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(oc);
        }
        if (e.hasAttribute("properName")) {
            boolean isProper = Boolean.valueOf(e.getAttribute("properName"));
            this.text = isProper ? "P$" + this.text : "N$" + this.text;
        }
    }
}

