/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.Utility;
import eu.irreality.age.filemanagement.Paths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public class CommandLineClient
implements InputOutputClient {
    private Vector gameLog;
    private BufferedReader reader = null;
    private PrintStream writer = null;
    private boolean echoEnabled = true;
    private String echoText = "Tu orden:  ";
    private String encoding = "UTF-8";
    private boolean rebotFriendly = false;
    private boolean unstrict = false;

    private static String getDefaultEncoding() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            System.out.println("Windows system detected, setting default console encoding to CP850");
            return "CP850";
        }
        String enc = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Unix system detected, setting default console encoding to " + enc);
        return enc;
    }

    public CommandLineClient(Vector gameLog, boolean rebotFriendly, boolean unstrict) {
        this(gameLog, CommandLineClient.getDefaultEncoding(), rebotFriendly, unstrict);
    }

    public CommandLineClient(Vector gameLog, String encoding, boolean rebotFriendly, boolean unstrict) {
        this.encoding = encoding;
        this.gameLog = gameLog;
        this.rebotFriendly = rebotFriendly;
        this.unstrict = unstrict;
        if (rebotFriendly) {
            this.echoText = "> ";
        }
        try {
            this.reader = new BufferedReader(new InputStreamReader(System.in, encoding));
            this.writer = new PrintStream((OutputStream)System.out, true, encoding);
            this.writer.println();
            this.writer.println();
            this.writer.println("******************************************************************");
            this.writer.println("*** CheapAGE - Command Line Interface for Aetheria Game Engine ***");
            this.writer.println("Special CheapAGE commands:");
            if (unstrict) {
                this.writer.println("save <filename.alf>: save the game");
            } else {
                this.writer.println("/save <filename.alf>: save the game");
            }
            if (unstrict) {
                this.writer.println("quit, exit, fin: quit the game");
            } else {
                this.writer.println("/quit, /exit, /fin: quit the game");
            }
            this.writer.println("******************************************************************");
            this.writer.println();
            this.writer.println();
            if (!rebotFriendly) {
                this.waitKeyPress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void borrarPantalla() {
        this.clearScreen();
    }

    public void clearScreen() {
        for (int i = 0; i < 25; ++i) {
            this.writer.println();
        }
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void escribirTitulo(String s) {
    }

    public void escribirTitulo(String s, int pos) {
    }

    public void forceInput(String s, boolean outputEnabled) {
        if (outputEnabled) {
            this.gameLog.addElement(s);
        }
        if (outputEnabled) {
            this.write("\n");
            this.write(this.getColorCode("input") + this.echoText + s.trim() + this.getColorCode("reset") + "\n");
        }
    }

    public void forzarEntrada(String s, boolean outputEnabled) {
        this.forceInput(s, outputEnabled);
    }

    public String getColorCode(String name) {
        return "";
    }

    public String getInput(Player pl) {
        try {
            String line;
            String lowerLine;
            if (this.echoEnabled) {
                this.writer.print(this.echoText);
            }
            if ((lowerLine = (line = this.reader.readLine()).toLowerCase().trim()).equalsIgnoreCase("/quit") || lowerLine.equalsIgnoreCase("/fin") || lowerLine.equalsIgnoreCase("/exit") || this.unstrict && (lowerLine.equalsIgnoreCase("quit") || lowerLine.equalsIgnoreCase("fin") || lowerLine.equalsIgnoreCase("exit"))) {
                this.writer.println("Quitting CheapAGE. Bye!");
                System.exit(0);
            } else if (lowerLine.startsWith("/save") || lowerLine.startsWith("salvar") || this.unstrict && (lowerLine.equalsIgnoreCase("save") || lowerLine.startsWith("salvar"))) {
                this.writer.println("Saving the game...");
                this.processSaveLogCommand(line);
                return this.getInput(pl);
            }
            this.gameLog.addElement(line);
            return line;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public String getRealTimeInput(Player pl) {
        this.writer.println("[WARNING] Real-time mode unsupported at the moment in the command-line client.\n");
        this.writer.println("Please use the windowed client.");
        return this.getInput(pl);
    }

    public boolean isColorEnabled() {
        return false;
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isMemoryEnabled() {
        return false;
    }

    public boolean isTitleEnabled() {
        return false;
    }

    public void waitKeyPress() {
        if (this.rebotFriendly) {
            this.writer.println("Escribe cualquier cosa para seguir...\n");
        } else {
            this.writer.println("Pulsa [ENTER] para seguir...\n");
        }
        try {
            this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String s) {
        this.writer.print(s);
    }

    public void writeTitle(String s) {
    }

    public void writeTitle(String s, int pos) {
    }

    public void saveLog(File f) throws IOException, FileNotFoundException {
        FileOutputStream fin = new FileOutputStream(f);
        PrintWriter fwrite = new PrintWriter(new BufferedWriter(Utility.getBestOutputStreamWriter(fin)));
        for (int i = 0; i < this.gameLog.size(); ++i) {
            fwrite.println((String)this.gameLog.elementAt(i));
        }
        fwrite.flush();
    }

    private void processSaveLogCommand(String command) {
        String path = command.substring(command.indexOf(" ") + 1);
        File f = new File(Paths.SAVE_PATH, path);
        try {
            this.saveLog(f);
            System.out.println("Log saved to " + f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

