lection = room {
	nam = 'ベリンの講義',
	pic = 'gfx/lection.png',
	dsc = [[俺は椅子に座った。ここは部屋の中のすべての音が明瞭に聞こえる。それじゃあ、高名な物理学者の講義を拝聴するとしようじゃないか。^^

「それで、1935年の12月にシュレーディンガー博士が発表した論文で、これからお見せする実験が解説されている」^
ベリンはしゃべるのを中断し奇妙な箱をテーブルの上に置いた。^
「私は実験がとても好きだ」^ベリンの白い微笑が妙に輝いて見えた。^^

「ご覧のとおり、この箱である」^その何の変哲もない箱の表面を手で叩いてみせた。^^

「この箱には毒ガスのコンテナと放射線カウンタ、放射性物質と時計が組み込まれている。実験のパラメータはすでに設定済みだ。1時間のうちに放射性物質が崩壊する確率、イコール、50パーセントである」^^

「もし崩壊が起これば、組み込まれたメカニズムによって、コンテナから毒ガスが内部の箱に放出される。つまり諸君、これは非常に簡単な仕組みだ。そうだろ？」^ベリンがまた微笑を浮かべた。^^

「さて、このシュレーディンガー博士の実験のポイントは、箱の中に猫を閉じ込めておくことにある。もちろん生きている猫であるが」^^
「量子論に従うなら、我々が素粒子を観測すると──素粒子の状態は2つの重ね合わせの状態として説明されるが──崩壊の状態と非崩壊の状態にある。その結果、箱の中の猫は生きていると同時に死んでいることになる」^
ベリンは声を高めた。^^

「これは単なる思考のゲームのように聞こえるが、ここで私がただの空論ではないということを証明してみせよう」^^

「もし実験者が箱を開けたら──2つの状態のうち片方を観測することになる──“崩壊が発生し、猫は死ぬ”あるいは“崩壊は発生せず、猫は生きている”である。シュレーディンガー博士はこのパラドックスは量子力学理論の矛盾を証明すると考えた。しかし量子力学は我々の世界の真実の姿である！」^
ベリンはまた声を高めた。^^

「ハンス・モラベック博士が1987年に、さらにブルーノ・マーチャル博士が1988年に、それぞれが個別に猫の観点からシチュエーションを評価し、この理論が正しいことを部分的に証明した」^^

「もしエヴェレットの多世界解釈が真実なら、この猫の実験が行われるすべての場所で世界は2つに分離されていることになる。1つめの世界では猫は生きており、2つめの世界では死んでいる。死んでいる世界では猫は存在を停止する。かたや、生きている猫の視点から見れば、実験が続けられ猫が死ぬという結果は得られない」^^

「これは真実である。つまりいくつかの分岐における猫は、それが生きている世界のみで観測が可能だからである。もし多世界解釈が正しいとすれば、猫はそれが死なない世界のみにおいて観測することができる」^
ベリンは口を閉じてみんなを見回した。^^

「これの意味するところはなにか、諸君。問題だ。これはなにを意味しているのだろうか？」^^

「想像してみたまえ。観測者の近くで原子爆弾が爆発したとする。多世界解釈によると、その観測者はほとんどすべての並行世界で破壊されるだろう。この事実にもかわらず、観測者がかろうじて生き残っている異世界がほんの少しながら存在する」^^

「それで我々はこのアイデアにたどり着いた」^
ベリンは声高に言った。「量子の不滅である!!」^^

「量子不滅論では、無限の並行世界のうちすくなくともひとつにおいては観測者が生きて存在し、観測者が実体を観測する可能性を持ったまま存在している。その幸運な世界がほんのわずかしかないとしてもである。このように、観測者は自分が永遠に生きていられることを発見するのである」^^

「我々は今年に入ってから、この研究のために非常な努力を重ねてきた。聡明な指導者の元において……」^
ベリンは壁にかかっている肖像画をちらりを見た。^^

「そして私は明言する。諸君、我々は情報処理センターに十分な量のデータを保有している」^
彼は天井を見上げた。^^

「この理論を証明するために十分な情報であり、重ねて言うが、理論と実験によって科学的にこれを証明するために。そして多世界解釈の正当性を証明するために」^^

「それが我々にとってどういう意味を持つのか？諸君には分からないかもしれない。しかし……」^
ベリンは腕時計を見た。^
「しかし、もうすぐ列車がウランを積んで研究所の裏のゲートに到着するだろう。それは諸君が原子爆弾を装備するのに十分な量のウランだ。」^^

「諸君はいまや量子不滅論が真実であることを確信し、そのうちのひとりは無敵のテロリストになる！」^^

「世界はキミ自身の存在で分岐する」ベリンはひとりひとりを指さして言った。「キミは偉大なる支配者、そして勝利者になるのだ!!!」^
やつの声はほとんど叫び声に近かった。部屋のみんなは誰も反論しなかった。全員が立ち上がって拍手喝采さいした。彼らの目は邪悪な炎で燃え上がっていた。なんというひどい妄想だ、俺はそう思った。俺の足が言うことを聞かない。俺は椅子に座ったまま動けなかった。^^

「しかし……、ここで本題に戻ろう」ベリンは言った。「我々の実験を続けることにしよう」^
彼はそう言いながら生きた実験体をテーブルの下から取り出した。それは俺のバルシクだった……。^^

「オーケー。ではこの猫を箱の中に入れて彼女がいったいどうなるか確かめてみよう」^
俺の視界が赤くぼんやりとかすんで見えた。^
	]],
	enter = function(s)
	-- end of episode 2
		eside = nil;
		moika = nil;
		eating = nil;
		kitchen = nil;
		stolcorridor = nil;
		entrance = nil;
		floor2 = nil;
		eroom = nil;
		room33 = nil;
		room3x = nil;
		cor3 = nil;
		toilet3 = nil;
		floor3 = nil;
		toilet = nil;
		toiletw = nil;
		room4x = nil;
		room46 = nil;
		hall42 = nil;
		hall41 = nil;
		floor4 = nil;
		floor5 = nil;
		povardlg = nil;
		kitchendlg = nil;
		facectrl = nil;
	end,
	act = function(s, w)
		if w == 1 then
			set_music("mus/under.s3m");
			return walk('escape1');
		end
	end,
	obj = {
		vobj(1, 'next', '{次へ}'),
	};
};

profdlg = dlg {
	nam = '!!!',
	pic = 'gfx/me.png',
	dsc = '俺はこぶしを握り締め立ち上がって声限りに叫んだ。',
	obj = {
		[1] = phr('それは彼女じゃない！彼だ！', 
	'ベリンは彼の手を止めた。彼の視線はゆっくりを俺に焦点を合わせた。彼は俺を思い出したかのような顔をした。^「おい警備!!ホールに外部の人間が紛れ込んでいるぞ、叩き出せ!!」^ベリンは叫んだ。',
	[[poff(2);escape1.obj:add('guardian')]]),
		[2] = phr('俺の猫に触るな！', 
	'ベリンはしゃべるのを止めてじっと俺を見た。彼は驚いた顔をし、^「警備、警備員はいないか!!侵入者だ!!」',
	[[poff(1);escape1.obj:add('guardian')]]),
	},
};

profdlg2 = dlg {
	nam = 'ベリン',
	pic = 'gfx/prof2.png',
	dsc = 'ベリンの顔色はだんだん血の気が失せていった。彼はショットガンを凝視していた。',
	obj = {
		[1] = phr('俺は猫を取り戻しに来たんだ！', 
	'俺はベリンの手からバルシクを取り戻してボストンバックに押し込んだ。',
		[[inv():add('mycat'); lifeon('mycat')]]),
		[2] = phr('あいつらに外に出るように言え。',
	'ベリンの顔は蒼白になっている。彼はもう俺の言っていることが聞こえていないようだった。',
		[[pon(3)]]),
		[3] = _phr('おい、あいつらをここから追い出せ!!', 
		'俺はやつの顔を揺さぶった。ベリンはパニックになっているようだった。彼はただ黒いショットガンのバレルを凝視していた。',
		[[pon(3); back();]]);
	},
};
gdlg1 = dlg {
	nam = '警備員',
	pic = 'gfx/guard42.png',
	dsc = '俺は警備員に向かって叫び声を上げ、自分の声が変に裏声になっているのに気付いた。',
	obj = {
	[1] = phr('銃をテーブルの上に置いてこっちによこせ。',
		'警備員は怯えたようなまなざしで俺を見つめた。',
		[[pon(2)]]),
	[2] = _phr('「おい、銃をテーブルの上に置け!!」俺はベリンの胸にバレルをぐいと押し付けた。彼は今にも気絶しそうだった。',
	'警備員は慎重にショットガンをテーブルの上に乗せてこちらに滑らせた。俺は素早くそれを取り上げた。そして2丁の銃を両手に構えた。',
		[[pon(3); inv():add('shotgun')]]),
	[3] = phr('おい、俺の顔が気に入らないか!?',
		'警備員はただ黙っていた。額から汗が滴り落ちている。',
		[[pon(3); back();]]),
	};
};

shotgun = obj {
	nam = '警備員のショットガン',
	inv = 'ポンプアクションのショットガンだ。弾は6発装填できる。面白い、いったい何発使ったんだ？',
	dsc = 'ポンプアクションの{ショットガン}が床の上に落ちている。',
	tak = function(s)
		if s._unloaded then
			return '弾がないからもう必要ない。', false
		end
		return '俺のショットガンを取った。';
	end,
};

guardian = obj {
	nam = '警備員',
	dsc = function(s, w)
		if not professor._gun then
			return '俺はショットガンを持った{警備員}がゆっくりと近づいてくるのを目にした。';
		end
		if have('shotgun') then
			return '{警備員}は武器を持っていない。彼は俺を凝視している。';
		end
		return '{警備員}は銃を構えているが、その手が震えているのが見えた。';
	end,
	act = function(s, w)
		if not professor._gun then
			return '俺はすぐに捕まってしまうだろう。';
		end
		return walk('gdlg1');
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'いや、それはできない。';
		end
		if w == 'gun' then
			if not professor._gun then
				return 'バレルを短くした俺のショットガンは遠くにある標的は撃てない。';
			end
			return 'この状況ではベリンに銃を向けたほうがいいだろう。もし撃ったらリロードしないといけない。'; 
		end
	end
};

professor = obj {
	nam = 'ベリン',
	dsc = function(s, w)
		if not s._gun then
			return '{ベリン}が黒板の前に立っており、俺のバルシクを片手に握っている。';
		end
		return '俺はショットガンのバレルを{ベリン}の胸に向けた。';
	end,
	act = function(s)
		if not s._gun then
			return walk('profdlg');
		end
		return walk('profdlg2');	
	end,
	used = function(s, w)
		if w == 'gun' then
			if s._gun then
				return '俺はショットガンの銃口をベリンの胸に当ててぐいと押した。';
			end
			s._gun = true;
			objs():add('guardian');
			gun._hidden = false;
			return '俺はバレルを短くしたショットガンを上着から取り出した。テーブルを飛び越えてベリンに走り寄った。';
		end
	end,
};

pdlg = dlg {
	nam = '人々',
	pic = 'gfx/me.png',
	dsc = '俺はテーブルに並んでいるみんなを見てわめき立てた。',
	obj = {
		[1] = phr('これは嘘だ!!こんなSF小説みたいなことは絶対にありえん!!',
			'みんなはシンと静まり返っている。',[[pon(2)]]),
		[2] = _phr('世界はひとつしかないに決まっているだろ!!ここにいるみんなも子供の頃から知っているはずだ。みんな、この研究所から出ろ！科学かぶれした変な宗教に騙されてるぞ!!', 
		'みんなの応えは無言だった。'),
		[3] = phr('まるでレミングスの群れだな。お前ら、こんなものに騙されてるのか!?',
			'彼らは何も応えない。俺の顔に刺さる彼らの視線がちくちくと痛い。',
			[[pon(3); back();]]),
	},
};

narod = obj {
	nam = '人々',
	dsc = function(s)
		if not professor._gun then
			if seen('guardian') then
				return 'ホールにいる{人々}は疑わしい目つきで俺を見た。ヒソヒソとささやきあう者もいる。';
			end
			return 'ホールにいる{人々}はベリンを見ている。';
		end
		return 'ホールにいる{人々}はピシリと凍りついた。彼らの目がすべて俺に向いている。ここで俺が失敗すれば、俺は死に、世界は確実に滅びる。';
	end,
	act = function(s)
		if professor._gun then
			return walk('pdlg');
		end
		if seen('guardian') then
			return '彼らは別に俺に襲いかかる様子もなかった。';
		end
		return '狂っている！彼らは狂信者だ……。';
	end,
	used = function(s, w)
		if w == 'gun' or w =='shotgun' then
			return 'いくらなんでも弾が足りないと思うぞ。';
		end
		return 'それはかわいそうだ……。';
	end
};

win = obj {
	nam = '窓',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = 'ガラスがひとつ割れている。';
		end
		return '広い{窓}が3つ西に面している。'..st;
	end,
	act = '窓の外は暗い。なにも見えないが粉雪がガラスに当たってはじけている。';
	used = function(s, w)
		if w ~= 'gun' and w ~= 'shotgun' then
			return 'あまり意味ないだろう。';
		end
		if s._broken then
			return 'すでに割れている。';
		end
		if not have('shotgun') then
			return '警備員は俺を撃つだろう。';
		end
		s._broken = true;
		ways():add('window');
		return '俺は近くの窓をショットガンの台尻で叩き割った。';
	end	
};

escape1 = room {
	nam = 'ホール2',
	dsc = 'ホールの中にいる。人々は実験の続きを待っている。',
	pic = function()
		if professor._gun then
			return 'gfx/meandgun.png';
		end
		return 'gfx/lection2.png';
	end,
	obj = {
		'win',
		vobj(4, '照明', 'ホールは蛍光灯で{照明}されている。'), 
		'professor',
		'narod',
		vobj(5, '箱', 'テーブルの上に{箱}が乗っている。'),
		'portrait',
	},
	act = function(s, w)
		if w == 5 then
			return 'ムカつく箱……。';
		end
		if w == 4 then
			return '蛍光灯が6つ。俺はこのチラチラする明かりが嫌いだ。';
		end
	end,
	used = function(s, w, ww)
		if ww == 'gun' or ww == 'shotgun' then
			if not professor._gun then
				return 'やめたほうがいい。';
			end
			if w == 4 then
				return '部屋を暗くすれば確かに動きやすいが。だが彼らもそうだ。こいつらは大勢いるので危険だ。';
			end
			if w == 5 then
				return 'まだ毒がそこにある。俺はバルシクを苦しめたくない。';
			end
		end
	end,
	exit = function(s, t)
		if t == 'window' and not have('mycat') then
			return 'バルシクはどうするんだ？?', false
		end
		if t == 'cor4' then
			return '今すぐどうにかしないと！', false;
		end
	end,
	way = { 'cor4' },
};
lest = obj {
	nam = function(s, w)
		if s._seen then
			return 'ハシゴ';
		else
			return 'なにか分からない……。';
		end
	end,
	dsc = function(s, w)
		if s._seen then
			return '吹雪の中に目を凝らして{ハシゴ}を見つけた！';
		end
		return '吹雪の中に目を凝らすとなにか{構造物}の骨組みが見えた。';
	end,
	act = function(s, w)
		if not s._seen then
			ways():add('ladder');
			s._seen = true;
			return 'あれは火災避難用のハシゴだ!!';
		end
		return '掴むか落ちるか、それが問題だ。';
	end,
};

window = room {
	nam = function(s)
		if here() == window then
			return '窓枠へ';
		end
		return '窓へ';
	end,
	pic = 'gfx/fromwin1.png',
	enter = "俺も狂気じみているとは思うのだが、窓から飛び出した。背中で悲鳴が聞こえた。";
	dsc = '窓枠から身を乗り出し外の暗闇を見た。',

	obj = {
		'lest',
	},
	exit = function(s, t)
		if t == 'escape1' then
			return 'もう戻れない。あそこには狂信者どもが大勢いる。', false;
		end
	end,
	way = { 'escape1',},
};


down = room {
	nam = '下る';
};

window5 = obj {
	nam = 'window',
	dsc = function(s, w)
		if s._broken then
			return '割れた{窓}が俺に左にある。';
		end
		return '俺の左にある{窓}から黄色い光が漏れている。';
	end,
	act = function(s)
		if not s._broken then
			return '窓は閉まっている。';
		end
		return walk('room5');
	end,
	used = function(s, w)
		if w == 'gun' or w == 'shotgun' then
			if s._broken then
				return 'すでに壊れている。';
			end
			s._broken = true;
			return '俺はショットガンの台尻で窓ガラスを叩き割った。粉々に砕けたガラスが夜の暗闇に落ちていった。';
		end
	end
};


up = room {
	_num = 0;
	nam = '上る',
	enter = function(s, w)
		s._num = s._num + 1;
		if s._num == 2 then
			lifeon('ladder');
			return '突然暗闇がサーチライトの強力な光によって白く切り取られ、けたたましいサイレンで静寂が破られた。下にいる誰かに見られているようだ。', false;
		end
		if s._num > 4 then
			ladder.way:del('up');
			ladder.obj:add('window5');
		end
		return '俺はのろのろとハシゴを上った。', false;
	end
};

ladder = room {
	nam = 'ハシゴ',
	pic = 'gfx/ladder.png',
	dsc = [[俺は凍てつきそうなハシゴに掴まっている。冷たい粉雪が俺の顔に鋭く刺さる。]],

	act = function(s, w)
		if w == 1 then
			return 'このままここにいたら凍りついてしまうだろう。';
		end
	end,
	obj = {
		vobj(1, 'ハシゴのフレーム', '俺は鉄製の{ハシゴのフレーム}を握っている。'),
	};
	enter = function(s)
		inv():del('gun');
		return [[俺は走り出しジャンプした。空中で恐ろしくなって心臓が止まりそうなったが、バルシクの体温をボストンバックに感じ、次の瞬間俺の手はしっかりと黒い鉄のパイプを握っていた。ショットガンが肩から外れて下に落ちていった。]];
	end,
	way = { 'up', 'down' },
	life = function(s)
		if rnd(2) == 1 then
			return '俺はマシンガンの固い銃声を聞いた。弾が何発か俺のすぐそばに当たった。';
		end
	end,
	exit = function(s, t)
		if t == 'down' then
			if s._shoot then
				return '俺は殺されるかもしれない。そしてバルシクも殺されるかもしれない。そしてあいつらは世界を滅ぼすだろう。', false;
			end
			lifeon('ladder');
			s._shoot = true;
			return 'サーチライトが俺のまわりの暗闇を白く切り取り、サイレンがけたたましく鳴り響きまわりの静寂を汚した。俺はハシゴを下に降りた。俺は下にいる誰かに見られているらしく叫び声が聞こえた。', false;
		end
		if t ~= 'up' then
			lifeoff('ladder');
		end
	end
};

hand = obj {
	nam = '怪我をした手',
	inv = '手から血が流れている。このままだと俺は気を失うだろう。',
	life = '俺の手から滴り落ちた血が床の上に赤い円を作っている。',
	used = function(s, w)
		if w == 'galstuk' then
			inv():del('galstuk');
			inv():del('hand');
			lifeoff('hand');
			return '俺はネクタイを包帯代わりにして怪我をした手に巻いた。とりあえず出血は治まったようだ。';
		end
	end
};

computers = obj {
	nam = 'サーバルーム',
	dsc = '背の高いラックに収納されたサーバ{ハードウェア}が部屋のほとんどを占めている。廃熱ファンのノイズだけが静かに聞こえる。ネットワーク機器のパネルがチラチラと神経質に瞬いている。 ^';
	act = function(s)
		if kover._fire then
			return '燃やせ！悪魔のマシンなど燃やしてしまえ!!さっさと逃げ出したほうがよさそうだ。';
		end
		return 'このハードウェアには悪魔が棲んでいる!!全部ぶっ壊してしまわねばならん。しかしどうやってだ？ ^俺の経験から、最も確実なのはハードディスクや記録メディアのデータを壊してしまえば（別の言い方をすると、キュリー点に達しさえすれば）いいということは分かっている。 ^^このイカれたマシンをすべて燃やし尽くしてやる!!だが……どうやって火をつければいいんだ？';
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'サーバマシンを撃つのか？あんまり効果なさそうだ。この呪われた機械は燃やしてしまわないとな。';
		end
	end
};

poroh = obj {
	nam = '火薬',
	inv = 'この火薬は役に立つかもしれない。',
};

trut = obj {
	nam = '導火線',
	inv = '紙で火薬を巻いて包んだものだ。これで導火線になる。',
	use = function(s, w)
		if w == 'ibp' and ibp._knife and not ibp._trut then
			ibp._trut = true;
			inv():del('trut');
			return '俺は導火線を無停電電源に仕込んだ。';
		end
	end
};

fire = obj {
	nam = '火',
	inv = '紙が燃え尽きてしまう、消えないうちになんとかしないと!!',

	use = function(s, w)
		if w == 'poroh' then
			return 'そのまま火をつけたら俺の手の上で爆発するだろう。';
		end
		if w == 'news' then
			return '新聞紙を小さくちぎって火をつけると燃えはじめた。';
		end
		inv():del('fire');
		if w ~= 'kover' then
			return '燃え尽きて灰になっちまった……。';
		end
		if kover._fire then
			return '俺はカーペットに燃える火を移した。';
		end
		kover._fire = true;
		return '俺は燃える火をカーペットに移した。毛羽立ったカーペットの表面が少しずつ燃え始めた。きっとこれで火事になるだろう。';
	end
};

ibp = obj {
	nam = '無停電電源',
	dsc = '取り外した{無停電電源}が床の上にある。',
	inv = function(s)
		if not s._knife then
			return 'これはサーバのための非常用電源ユニットだ。これをどうすればいい？';
		end
		local st = '';
		if s._trut then
			st = 'バッテリーの上に火薬と新聞紙がある。';
		end
		return '分解した無停電電源。バッテリーに繋がる端子がある。'..st;
	end,
	act = function(s)
		if not have('ibp') then
			if not have('fire') and not kover._fire then
				take('ibp');
				return '俺は無停電電源をもう一度取った。';
			end
			return 'これ以上必要ないだろう。';
		end
		return s:inv();
	end,
	used = function(s, w)
		if not have('ibp') then
			return '無理だろう。';
		end
		if w == 'knife' then
			s._knife = true;
			return '俺は無停電電源のネジを外した。バッテリーに繋がる端子が見える。';
		end
		if w == 'provodki' and s._knife then
			if not provodki._knife then	
				return 'まだ電線の反対側が被覆されている。';
			end
			if not s._trut then
				return '俺は電線を端子につなぎショートさせた。銅線が接触したときに火花が散った。導火線が必要だな。';
			end
			drop('ibp');
			ibp._trut = false;
			inv():add('fire');
			return '俺は電線を端子につなぎショートさせた。銅線が接触したときに火花が散った。導火線が燃え始めた！ファイヤァァ!!!';
		end
		if w == 'provod' then
			return '電線を無停電電源に差し込んでまた戻した。うーん……なにか違う。';
		end
	end,
};

provodki = obj {
	nam = '電線',
	inv = function(s)
		if s._knife then
			return '両端がむき出しになった2本の銅線'
		end
		return '2本の電線'
	end,
	used = function(s, w)
		if w == 'knife' and not s._knife then
			s._knife = true;
			return '俺は電線の被覆をナイフで切り銅線をむき出しにした。';
		else
			return 'それは無理だろうな。';
		end
	end
};

provod = obj {
	nam = '無停電電源から伸びた電線',
	inv = '無停電電源に繋がっている電線だ。',
	used = function(s, w)
		if w == 'knife' then
			if not knife._oster then
				return 'ナイフの刃が鈍すぎて切れない。';
			end
			inv():del('provod');
			inv():add('provodki');
			return '俺は電線の被覆を剥がして2本の銅線をむき出しにした。'
		end
	end
};

ups = obj {
	nam = '無停電電源',
	dsc = '{非常用電源ユニット}がすべてのラックに取り付けてある。',
	act = function(s)
		if have('hand') then
			return '俺は手を怪我している。出血が激しい。片手じゃ無停電電源を外せないだろう。';
		end
		if not have('ibp') and not seen('ibp') then
			inv():add('ibp');
			inv():add('provod');
			return '時間はかかったが無停電電源を外して1個取り出すことができた。';
		end
		return 'すでに1個持っている。';
	end,
};

kover = obj {
	nam = 'カーペット',
	dsc = function(s)
		if s._fire then
			return '床の{カーペット}がどんどん燃え広がっている。';
		end
		return '床は赤い{カーペット}で覆われている。';
	end,
	act = 'こんなふかふかのカーペットは贅沢すぎる。',
};

room5 = room {
	nam = '情報処理センター';
	pic = 'gfx/servers.png',
	dsc = [[研究所の南側のほとんどを占める大きな部屋にいる。]],
	enter = function(s, f)
		if f == 'ladder' then
			set_music('mus/hybrid.xm');
			lifeon('hand');
			inv():add('hand');
			return '俺はジャンプして運よく窓枠をとらえた。だが右手に怪我をしてしまった。出血した傷口から痛みが伝わってきたが部屋の中へ飛び込んだ。';
		end
	end,
	exit = function(s, f)
		set_music("mus/under.s3m");
	end,
	act = function(s, w)
		if w == 1 then
			return 'もう戻れない。寒すぎるし外では銃声が響いている。';
		end
	end,

	obj = { 'computers', 'ups',
		vobj(1, '窓', '冷たい冬の風が壊れた{窓}を通り抜けていく。'),
		'kover',
		'dout',
		'portrait',
	},
};

dout = obj {
	nam = 'ドア',
	dsc = function(s)
		return '前方に出口の{ドア}が見える。';
	end,
	act = function(s)
		if not kover._fire then
			return 'ここは情報処理センターらしい。記憶装置の中に潜む病原菌から世界を守るために俺はこれを破壊しなければならない。';
		end
		return '俺はドアを目指して走った。外はエレベータに繋がっているはずだ。しかし、鍵がかかっている！ドアを開くには正しいアクセスレベルのIDカードが必要だということだ。ここれで俺も燃え尽きてしまうのか!?';
	end,
	used = function(s, w)
		if not kover._fire then
			return s:act();
		end
		if w == 'card' then
			return '俺はドアのカードリーダーにIDカードをかざした。ビープ音が鳴って不許可を告げた。このままだと俺は焼け死んでしまう!!';
		end
		if w == 'shotgun' then
			return walk('escape2');
		end
		return 'それは無理だろうな。';
	end
};

handgdlg = dlg {
	nam = '警備員',
	pic = 'gfx/handhoh.png',
	dsc = 'さっきのやつよりは若い、30歳くらいの警備員だ。俺を見ているが混乱しているようだ。',

	obj = {
	[1] = phr('銃をよこせ！', 
		'「お、俺は武器は持ってないよ……」^彼は頭を横に振って言った。こいつの言ってることを信じていいものかどうか、しかし近寄って武器を調べる気にはならない。'),

	[2] = phr('鍵だ、赤いドアの鍵をよこせ！', 
		'警備員の顔色が青くなった。^「そのドアの鍵は誰も持っていないんだ」^なんというナンセンス！ だってそうだろ？'),

	[3] = phr('よし分かった！そのままそこにじっとしてろ。', '警備員はただ黙って俺を見ていた。',
		[[pon(3);back();]]),
	},
};

win5 = obj {
	nam = '窓',
	dsc = function (s)
		if s._broken then
			return '壊れた{窓}に冬の冷たい風が吹き込んでくる。流れ込んできた粉雪が床の上で渦を巻いている。';
		end
		return '広い{窓}が西に面している。';
	end,
	act = function(s)
		if not s._broken then
			return '俺は窓に近寄った。ほう、この窓からは広い屋根が見渡せるな。屋根は建物の正面に伸びている。';
		end
		return '窓は壊れている。今日これで3つめだが。';
	end,
	used = function(s, w)
		if s._broken then
			return s:act();
		end
		if w == 'shotgun' then
			s._broken = true;
			ways():add('krysha');
			return 'うー……今日はこれでもう3回目なわけだが。俺はありったけの力を込めてショットガンを振り、窓ガラスを粉々にして屋根の上にぶちまけた。'; 
		end
	end,
};

escape2 = room {
	_timer = 0,
	nam = '5階ホール',
	pic = 'gfx/floor5e.png',
	dsc = [[5階の天井はとても高い。]],
	enter = function(s, f)
		if f == 'room5' then
			lifeon('escape2');
			return 'ムカつくドアをショットガンの台尻で殴りつけようとしたが、突然ドアの外側に誰かがやってくるのが聞こえた。警備員が来た！カードリーダーがビープ音を立ててドアが開く。警備員は、はたと立ち止まった。彼が見下ろした視線の先には、自分の胸にポンプアクションのショットガンの銃口が突きつけられている。俺はそいつをエレベータのあるホールに押し出し、俺自身も部屋を出た。';
		end
		if f == 'krysha' then
			lifeon('escape2');
		end
	end,
	life = function(s)
		s._timer = s._timer + 1;
		if s._timer == 3 then
		return '突然サイレンの音が鳴り響いた。無線機から緊迫した声が流れた。「緊急警報!!5階全フロアはアクセスレベルゼロ、繰り返す、5階全フロアはアクセスレベルゼロ!!」';
		end
		if s._timer > 3 then
			return '「5階全フロアはアクセスレベルゼロ!!」^俺はサイレンのやかましい音で神経が参りそうだった。';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return '俺の足の裏が、毛足の長い赤いベルベットのカーペットに足跡の形に模様を描いている。なんという贅沢品だ。';

		end
		if w == 2 then
			return 'またか。クリスタル製だろ。';
		end
		if w == 4 then
			return 'そっちは火災発生中だ。';
		end
		if w == 5 then
			return '俺のIDカードはここじゃ使えんだろう。';
		end
		if w == 6 then
			return walk('handgdlg');
		end
	end,
	used = function(s, w, ww)
		if w == 6 then
			return '俺は銃口を警備員に向けている。';
		end
		if w == 5 then
			return 'それは無理だろうな。';
		end
	end,
	obj = {
	vobj(1, 'カーペット', 'エレベータのあるホールには赤い{カーペット}が敷かれている。'),
	vobj(2, 'シャンデリア', 'クリスタル製の{シャンデリア}が天井から吊り下げられている。'),
	'win5',
	vobj(4, '情報', '情報処理センターへの{ドア}が開け放たれている。部屋の中から煙が出てきている。');
	vobj(5, '赤いドア', 'プレートのない向かい側の{ドア}。どっしりと重量感のあるこのドアは赤い革で装飾されている。'),
	vobj(6, '警備員', '両手を挙げた{警備員}が真ん中に立っている。');
	},
	way = { 'lift','room5' },
	exit = function(s, t)
		if t == 'room5' then
			return 'そっちは炎が燃え上がっている！', false
		end
		if t == 'lift' then
			return '俺はすべてのエレベータが動いていることに気がついた。つまり警備員達が登ってきているということだ。急いでここから逃げ出さないと!!', false;
		end
		if t == 'krysha' then
			lifeoff('escape2');
		end
	end
};

swin = obj {
	nam = '南の窓',
	dsc = '煙が南側の{窓}から出ている。',
	act = 'ああ、情報処理センターの窓のひとつだ。俺は窓から炎が出ているのを見た。',
};

nwin = obj {
	nam = '北の窓',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = '窓ガラスは壊れている。';
		end
		return '北側の{窓}は暗闇に黄色い光を投げかけている。'..st;
	end,
	act = function(s)
		if s._broken then
			return walk('hall5');
		end
		return 'うーん……、窓から豪勢なホールが見える。';
	end,
	used = function(s, w)
		if w == 'shotgun' then
			s._broken = true;
			ways():add('hall5');
			return 'はあぁ……頼むからこれで最後にしてくれよ……。俺はショットガンを振りかぶって窓ガラスを叩き割った。';
		end
	end,
};

hall5 = room {
	nam = 'ホール',
	pic = 'gfx/hall5.png',
	enter = function(s, f)
		if f == 'krysha' then
			return '俺はホールに飛び込みまわりを見回した。';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return 'なんという無駄な贅沢。';
		end
		if w == 2 then
			return '俺は支柱の表面をぐるりとなでた。大理石かよ！';
		end
		if w == 3 then
			return 'このシャンデリアはマウンテンクリスタルで作られたんだと思う。';
		end
		if w == 4 then
			return '暗闇だ……、待て、今何か見えた。研究所の裏側に列車のようなものが現れたような気がしたが。';
		end
		if w == 5 then
			return '粉雪が割れた窓から流れ込んできている。';
		end
		if w == 6 then
			if s.way:srch('escape3') then
				return walk('escape3');
			end
			return walk('gudlg');
		end
		if w == 7 then
			return 'このドアは鍵がかかっている。俺の持っている鍵では開かない。';
		end
		if w == 8 then
			return 'うーん、これはピカソか？';
		end
		if w == 9 then
			return 'もうなんだかひどい虚脱感に取り付かれてしまった……。いいや、寝てる場合じゃないだろ。';
		end
	end,
	used = function(s, w, ww)
		return 'そんなことをしても……。';
	end,
	dsc = '建物の北側のほとんどはこの豪勢なホールで占められている。',
	obj = {
		vobj(1,'カーペット', '俺の足はふかふかとした赤いベルベットの{カーペット}に毛並みに沈み込んだ。'),
		vobj(2,'支柱', '8本の大理石の{支柱}が並んで通路の形を作っている。'),
		vobj(3,'シャンデリア', 'ゴーシャスな{シャンデリア}が天井から下がっている。'),
		vobj(4,'東の窓', '4つの{窓}が東に面している。'),
		vobj(5,'西の窓', '割れた{窓}が俺の左にある。'),
		vobj(6,'小さなドア', 'ホールの北の突き当たりに小さな木星の{ドア}がある。'),
		vobj(7,'ホールのドア', 'ホールの入り口の{ドア}が俺の後ろにある。'),
		vobj(8,'油絵', '壁に豪華な額に入った{油絵}が飾られている。'),
		vobj(9,'ソファー', '柔らかい{ソファー}がまわりに置かれている'),
	},
	way = { 'krysha' },
};

krysha = room {
	nam = '屋根',
	pic = 'gfx/krysha.png',
	enter = function(s, f)
		return '俺は急いで壊れた窓を乗り越え屋根の上に出た。';
	end,
	dsc = 'この建物はどうやら元々は4階建てで、後から5階フロアを建て増ししたようだ。建物の北の屋根の上を、最初の窓に届くところまで歩いた。',
	obj = {'nwin', 'swin'},
	way = {'escape2'},
};

gudlg2 = dlg {
	nam = '肖像画の男',
	pic = 'gfx/pmanb.png',
	dsc = '俺はやつのうつむいた顔を見た。平然と落ち着いた表情だった。',
	obj = {
		[1] = phr('これで答えが出たろ、おっさん？',
		'だが返ってきた答えは重たい唸り声だった。',
		[[pon(1); back();]]),
		[2] = phr('でもなぜなんだ？なんでこんなことをする？',
		'やつは顔を上げて俺をじっと見つめた。^「私は自分の仕事をしたにすぎない」',
		[[pon(3);poff(1);]]),
		[3] = _phr('ここでやっていることは全部詐欺だ、まったくの嘘だ！',
		'「私は使い捨てられた。だから……考えた。世界はこの間違いを償わなくてはいけない」',
		[[pon(4)]]),
		[4] = _phr('なにを言っているんだ？',
		'「私は教授として働いてきた。ところがもう私は必要とされなくなってしまった。私は……私はそれが承服できなかった」',
		[[pon(5)]]),
		[5] = _phr('なんつー悪党だお前は……。',
		'「だが私はこれらのものを作った。あれらを作り上げたのだ。わ……私は永遠に存在していられる!!誰にも邪魔はさせない」',
		[[pon(6)]]),
		[6] = _phr('お前は気が狂ってるよ。',
		'部屋の隅にいる彼の体はまるで寒気がするというように震えていた。',
		[[pon(1); back()]]),
	}
};

gudlg = dlg {
	nam = '肖像画の男',
	pic = 'gfx/pman.png',
	enter = function(s)
		lifeoff('mycat');
		inv():del('shotgun');
		return [[おかしい。ドアの鍵は開いていた。俺はゆっくりと用心しながらドアを開けて部屋の中に入った。突如リボルバーの銃口が俺の顔に向いているのに気がついた。^^「ブラボー、ブラボー!!よくやった」^^肘掛け椅子に深く座った男が言った。リボルバーの持ち主だ。^^「長いこと待たされたよ。キミがあの森の住民かね？いいだろう、警備員を待とう。それからキミのショットガンを床に置きたまえ」^俺はなにもできなかった。彼の指示に従う以外は。]];
	end,
	dsc = [[俺はその顔を見た。この建物のすべての部屋の壁にかかっていた肖像画の顔だった。穏やかな表情でなんの感情も現さない。薄く微笑している。俺はとにかく時間を稼ぐ必要があった。そこであれこれ質問することにした。]],

	obj = {
	[1] = phr('ちょっと話せるか？^^',
	'「ふーむ。なにを話そうというのかね。キミと私の共通の話題とはいったいなんだね、ええと、森の住民でよかったかな？」',
	[[pon(2)]]),
	[2] = _phr('たとえばだ、エヴァレットの多世界解釈、ありゃいったいなんだ？本当にそんなことがありえるのか？',
	'「はははは」^肖像画の男は感情の乏しい乾いた笑い方をした。^「もちろんありえないとも。あれは不滅性を求めるバカ共を信じ込ませるためのおとぎ話にすぎん。おそらくな」',
	[[pon(3)]] ),
	[3] = _phr('それで、科学的な実証はまったくないわけだ？',
	'男は笑うのをやめて真顔に戻った。 ^「もしかすると、もしかすると真実かもしれないじゃないか」 ^俺に向かってミステリアスな薄笑いを見せた。 ^「真実とはいったいなにか、キミ自身はどう思うかね？」',
	 [[pon(4)]]),
	[4] = _phr('俺はすべて嘘だと思う。',
	'「キミは本当にそれを知って言っているのかね？」^空虚な瞳が俺を見た。^「イエスまたはノーで答えたまえ！」^その言葉を聞いて突然俺はパニックに襲われた。'
	,[[pon(5,9)]]),
	[5] = _phr('でたらめだ！', 
	'「それでもしもだ、想像してみたまえ。もしも、だ。キミは優秀なハッカーだったそうじゃないか。キミは予測したり先を考えるのが好きだろう？」',
[[pon(6);poff(9)]]),

	[6] = _phr('いいや俺は騙されないぞ。こんなことが真実なわけがない！もしこれが真実なら世界は消滅してしまう。じきに崩壊するか、すくなくとも未来はない！だから……、',
	'「そう、そのとおりだ。キミも分かってきたじゃないか。つまりはキミしか存在しない!!キミ自身の心に聞いてみたまえ。誰がその答えをキミに与えたのか。キミがそれを求めたのか？キミの願望がそれを生み出したのか？ 」^^俺は彼が掘った暗い奈落の底にどんどんと落ちていく。',
	 [[pon(7)]]),
	[7] = _phr('もしも、もしも……でもなぜ？',
	'「そう、そうだよ」 ^肖像画の男は急にやさしげな口調になった。新しい恐怖の波が俺を飲み込んでいく。俺はがっくりと床に膝をついた。俺の心臓は狂ったようにガンガンと早鐘を鳴らし、今にも胸から飛び出さんばかりに鼓動している。',

	[[pon(8)]]),
	[8] = _phr('いやだ……やめてくれ。',
	'「もしすべてが真実なら、キミはなにも恐れることはない」 ^彼は満足そうに言う。俺の心臓はどんどんリズムを早めている。終いには俺の胸が破裂して、ふわふわの黒い毛のボールが飛び跳ねたかと思うと、肖像画の男のそばをジャンプし猛烈な勢いで彼の顔に突進した。1発の銃声が響いた。鋭い痛みが左肩に突き刺さって俺は我に返った。俺はジャンプして突進した。',
	[[return walk('escape3')]]),
	[9] = _phr('まあそれが真実であると仮定しよう。',
		'「ああ、いいとも。考えて、考えたまえ。キミは優秀なハッカーだ、そうだろう？」^^肖像画の男はそう囁いた。',
		[[pon(6);poff(5)]])
	},
};

--shkf = obj {
--	nam = 'край шкафа',
--	inv = 'Я держу в руках край шкафа.',
--};

shkaf = obj {
	nam = '書棚',
	inv = '俺は両手で書棚の角を持った。',
	dsc = function(s)
		if s._fall then
			return 'ドアは{書棚}でブロックされている。';
		end
		return '{書棚}がドアの近くに設置してある。';
	end,
	act = function(s)
		if not escape3._guards or s._fall then
			return '蔵書の書名のいくつかは哲学と……物理学だ。';
		end
		inv():add('shkaf');
		return '俺は書棚の端をしっかりと掴んだ。';
	end,
};

fromw5 = room {
	nam = '窓枠へ',
	dsc = '俺は窓枠の上に乗っている。氷のような冷たい風が吹き付けて呼吸が苦しい。',
	pic = 'gfx/fromwin2.png',
	enter = 'またか。これが最後だといいんだがな。',
	act = function(s, w)
		if w == 1 then
			return walk('nwall');
		end
	end,
	obj = {
		vobj(1, '雨樋', '目を凝らすと右のほうに{雨樋}のパイプがあるのが分かった。'),
	},
	way = { 'escape3' },
	exit = function(s, t)
		if t == 'escape3' then
			return '急げ！はやいとこずらかるぞ！', false;
		end
	end
};

winr5 = obj {
	nam = '窓',
	dsc = function(s)
		if s._broken then
			return '冬の冷たい風が壊れた{窓}から吹き込んでくる。';
		else
			return '{窓}は北に面している。';
		end
	end,
	act = function(s, w)
		if escape3._guards then
			if not shkaf._fall then
				return '風景を眺めてる場合じゃない。警備員が追いかけて来れないようにしないといけない。';
			end
			if not have('mycat') then
				return 'バルシクを置いていくのか？いっそのことここで心中したほうがましだ！';
			end
--			if not have('revol') then
--				return 'Лучше поднять с пола пистолет, на всякий случай.';
--			end
			if s._broken then
				ways():add('fromw5');
				return walk('fromw5');
			else
				return '窓は閉まっている。';
			end
		end
		escape3._guards = true;
		lifeon('escape3');
		return '漆黒の暗闇が窓の外に広がっている。暗闇に目を凝らしていると背後でかすかに足音が聞こえた。足音はホールのほうから聞こえてくる。すでに警備員が駆けつけているようだ。なんとかしなければ！';
	end,
	used = function(s, w)
		if escape3._guards and not shkaf._fall then
			return '時間がない。警備員が大勢ドアから押し入ってくるだろう。';
		end
		if w == 'shotgun' then
			if not s._broken then
				s._broken = true;
				return 'またか？うー、俺はショットガンを振り上げて窓ガラスを割った。カケラは暗闇に消えていった。';
			end
			return 'この窓はすでに壊れている。';
		end
	end,
};

revol = obj {
	nam = 'リボルバー',
	dsc = '{リボルバー}のピストルが床の上に転がっている。',
	inv = '弾は6発。',
	tak = '俺は床からリボルバーを拾い上げた。',
};

escape3 = room {
	nam = '部屋の中',
	pic = 'gfx/manroom.png',
	enter = function(s, f)
		if f == 'gudlg' then
			inv():del('mycat');
			hall5.way:add('escape3');
			return '俺は銃が落ちる音を聞いた。それで俺は手に触れるものを手当たり次第グーで殴った。バルシクは前に後ろに気ぜわしそうに走り回っていた。';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return walk('gudlg2');
		end
		if w == 2 then
			return '抽象画は俺の趣味に合わん。';
		end
		if w == 3 then
			local st = '';
			if shkaf._fall then
				st = '書棚で塞がれている。';
			end
			return 'ホールに続くドアだ。'..st;
		end
	end,
	used = function(s, w, ww)
		if w == 1 and ww == 'shotgun' or ww == 'revol' then
			return 'ああ、こいつらは悪党だが弱っているうえに丸腰のやつを撃つ気にはなれない。';
		end
		if w == 3 and ww == 'shkaf' then
			shkaf._fall = true;
			inv():del('shkaf');
			return '俺は書棚を押して床に倒しドアを塞いだ。';
		end
	end,
	dsc = [[俺は狭い部屋にいる。だが快適な部屋だ。テーブルが真ん中に置いてある。そのそばで横倒しになった肘掛け椅子が転がっている。小さなシャンデリアがほのかに灯っている。小さな2つの書棚が壁に沿って立っている。]],
	obj = {
		vobj(1, '男', '肖像画の{男}がテーブルに寄りかかって床に座り込んでいる。彼の唇からぽたぽたと血が垂れている。男はうめき声を上げた。'),
		vobj(2, '油絵', '壁にかかった何枚かの{油絵}。'),
		vobj(3, 'ドア', '俺の後ろに{ドア}がある。'),
		'revol',
		'shkaf',
		'shotgun',
		'mycat',
		'winr5',
	},
	life = function(s)
		if rnd(3) == 1 then
			return '俺は銃声を聞いた。弾がドアを貫通した。なんとかしなければ。';
		end
	end,
	exit = function(s,t)
		if t == 'hall5' then
			if shkaf._fall then
				return '出口は書棚で塞がれている。', false;
			end
			if s._guards then
				return 'まともに撃たれるだろう。', false;
			end
			s._guards = true;
			lifeon('escape3');
			return '俺がホールに出ると突然反対側のドアが開いて警備員が飛び込んだ。I\'m going to go to the hall when suddenly the door on the opposite side opens and the guards run in. 俺は急いでドアを閉めた。', false;
		end
		lifeoff('escape3');
	end,
	way = {
		'hall5'
	},
};

nwall = room {
	nam = '北側',
	dsc = '俺は研究施設の北側の壁に来ている。',
	pic = 'gfx/nside.png',
	way = {'eside2','wside' },
	act = function(s, w)
		if w == 1 then
			return 'ああ、雨樋のパイプだな。頑丈に出来ている。だがこれを伝って登るというのはちょっと無理だ。';
		end
	end,
	enter = function(s, f)
		if f == 'fromw5' then
			return '左肩の激痛に耐えつつ俺は窓枠を飛び越え、雨樋のパイプを掴んだ。俺の心臓は狂ったように打ち鳴らされ、バルシクと俺は冬の暗闇の中を落ちた。手のひらに傷を負いながら雨樋を滑り落ちていった。';
		end
	end,
	obj = { vobj(1, '雨樋',
		'建物の東の隅に沿って{雨樋}のパイプが伸びている。')},
	exit = function(s, t)
		if t == 'wside' then
			if not s._guards then
				s._guards = true;
				return '俺はまわりを見回し、大勢の警備員が検問所を走り出て俺のほうにやって来るのを見た。^「あそこにいるぞ!!」^彼らの叫び声が聞こえた。銃声が聞こえて俺は後ろに下がった。',
				false;
			end
			return 'あいつらに捕まってしまうだろう。', false;
		end
	end
};

eside2 = room {
	nam = '研究所の裏側',
	pic = 'gfx/esidee.png',
	dsc = [[研究施設の裏側の壁にいる。列車のレールがある。]],
	act = function(s,w)
		if w == 1 then
			return 'マシンガンが研究所の南側に向いている。近づかないほうがよさそうだ。';
		end
		if w == 2 then
			return 'ほう……。さっき聞こえたのはやっぱり列車の音だったのか。積み荷はまだ降ろされていないようだ。しかしゲートはすでに開かれている。';
		end
		if w == 3 then
			return '列車が4台見える。ディーゼル機関車“ChME3”だ。すべての列車が研究所内に止まっている。';
		end
	end,
	obj = {
	vobj(1,'監視塔', 'レールが敷かれている入り口は銃座のある{監視塔}で守られている。'),
	vobj(3,'列車', '俺は何台かの{列車}の黒い輪郭を確認した。'),
	vobj(2,'ゲート', '建物の壁にある鉄製の大きな{ゲート}が開いている。出入り口から光が漏れ出しているのが見えた。'),
	},
	exit = function(s, t)
		if t == 'sside' then
			return '南側のマシンガンが怖い。危険すぎる。',
			false
		end
		if t == 'nwall' and nwall._guards then
			return 'ここまで来てもう戻れない……。', false;
		end
	end,
	way = {'nwall','train','sside'},
};
function checkloc()
	if p1._off or p2._off then -- battary or switch off off
		p3._off = true;
		p4._off = true;
		p5._off = true;
--		p51._off = true;
--		p6._off = true;
	end
	if p3._off or p4._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p5._off then
		p7._off = true;
	end
	if p51._off then
		p71._off = true;
	end
	if p6._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p7._off then
--		p71._off = true;
	end
end

p1 = obj {
	_off = false,
	nam = '切断機',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return 'VBバッテリー{切断機}：'..st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。';
	end
};

p2 = obj {
	_off = true;
	nam = 'キー',
	dsc = function(s)
		local st = '下向き。^';
		if s._off then
			st = '上向き。^';
		end
		return 'ボタンの{キー}スイッチ：'..st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'キースイッチを回した。';
	end
};
p3 = obj {
	_off = true,
	nam = '電圧計',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '{電圧計}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p4 = obj {
	_off = false,
	nam = '熱電流計',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '{熱電流計}：'..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p5 = obj {
	_off = true,
	nam = '2段目ポンプ',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '2段目の燃料{ポンプ}：'..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p6 = obj {
	_off = true,
	nam = 'コントローラ',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '{コントローラ}：'..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p7 = obj {
	_off = true,
	nam = '2段目のディーゼルエンジンスタート',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '2段目のディーゼルエンジン{スタート}：'..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'スイッチを切り替えた……。'
	end
};

p51 = obj {
	_off = true,
	nam = '1段目ポンプ',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '1段目の燃料{ポンプ}：'..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p71 = obj {
	_off = true,
	nam = '1段目ディーゼルエンジンスタート',
	dsc = function(s)
		local st = 'オン。^';
		if s._off then
			st = 'オフ。^';
		end
		return '1段目のディーゼルエンジン{スタート}：'..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off or p7._off then
			return 'おかしい……動かない。'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return '切り替えた。'
	end
};

p8 = obj {
	_num = 1,
	nam = '反転器',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = 'ニュートラル。^';
		elseif s._num == 2 then
			st = '後進。^';
		elseif s._num == 3 then
			st = '前進。^';
		end
		return '{反転器}のハンドル：' .. st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		return '切り替えた。'
	end
};

p9 = obj {
	_num = 1,
	nam = 'コントローラ',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = '0。^';
		elseif s._num == 2 then
			st = '1。^';
		elseif s._num == 3 then
			st = '2。^';
		end
		return '{コントローラ}ハンドル：'..st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		if s._num == 1 then
			return '切り替えた。'
		end
		if not p71._off and not p7._off then
			if p8._num == 2 then
				s._num = 1;
				return '機関車は重い体を起こすように身震いしてからゆっくりと前進を始めた。俺はコントローラを0に戻した。';
			elseif p8._num == 3 then
				lifeoff('mycat');
				set_music('mus/liberty.s3m');
				return walk('theend');
			end
		end
		s._num = 1;
		return 'なにも起こらない。俺はコントローラを0に戻した。';
	end
};
	
train = room {
	nam = function(s)
		if here() == train then
			return '機関車の運転席';
		end
		return '列車へ';
	end,
	pic = 'gfx/cab.png',
	dsc = '機関車の中にいる。これだけの分厚い鉄だと確実に銃弾から守られている。機関室は放置されているようだ。たくさんのメーター機器とコントローラが並んでいる。',
	act = function(s, w)
		if w == 2 then
			if p1._off or p2._off then
				return '警笛ボタンを押したがなにも聞こえなかった。';
			end
			return '鈍い笛のような音が聞こえた。俺は列車の機関士になった気分だった。';
		end
		if w == 1 then
			return 'どうしてもこれを動かさなければならん。これならどんなものが来ても俺を止めることは不可能だろう。';
		end
	end,
	life = function(s)
		local st = '';
		if not p7._off or not p71._off then
			st = '俺は機関車が振動するのを感じた。ディーゼルエンジンが動いている。';
		end
		if rnd(10) < 5 then
			st = st..'俺は銃弾がこの鉄の要塞に当たるのを聞いた。';
		end
		return st;
	end,
	exit = function(s,t)
		if t == 'eside2' then
			return 'いや、ここにいたほうがいい。ここが最後の防衛線だ。',
				false;
		end
		lifeoff('train');
	end,
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then 
			return cat('俺は猫のように体を丸めながら列車に走った。^^', 
				walk('vorota')), false;
		end
		lifeon('train');
		set_music('mus/hispeed.s3m');
		return '俺は猫のように体を丸めながら列車に走った。列車の横を走るうちに“危険：高出力の放射線”と書かれた標識に気付いた。さらに走り続けて機関車にたどり着いた。 背後から撃ってくる音が聞こえた。監視塔のマシンガンの銃口がこっちに向いている。機関車の重たいドアを開けて……俺は中に転がり込んだ！。' 
	end,
	obj = {
		'p2', 'p1', 'p4', 'p3',  'p71','p51', 'p7', 'p5', 'p9', 'p8', 'p6',
		vobj(2, '警笛', '機関車の{警笛}。^');
		vobj(1, '窓', '{窓}からレールの先にある閉じたままのゲートが見えた。'),
	},
	way = { 'eside2' },
};

guards1 = obj {
	nam = '警備員',
	dsc = function(s, w)
		if s._broken then
			return 'セキュリティゲートの前で、{警備員}達が落下したシャンデリアの下から抜け出そうとしている。';
		end
		if s._shoot then
			return '{警備員}達が俺の弾に当たらないようにセキュリティゲートの影に隠れているのが見えた。';
		end
		return '1階ホールでマシンガンを抱えた{警備員}達が俺のほうに向かってくるのが見えた。';
	end,
	act = function(s, w)
		if s._broken then
			return 'あいつらを足止めするのに成功したようだ。';
		end
		if s._shoot then
			return 'ひどいやつだな！';
		end
		return 'ラッキーなことに俺はまだ生きているようだ。';
	end,
	used = function(s, w)
		if w == 'shotgun' or w == 'revol' then
			if s._shoot then
				return '効果ないだろう。警備員はぶ厚い金属製のセキュリティゲートの向こう側にいる。';
			end
			s._shoot = true;
			return '俺は壁から顔を出して、とくに狙いを定めずに何度か撃った。';
		end
	end,
};

lustra1 = obj {
	nam = 'シャンデリア',
	dsc = function(s, w)
		if s._broken then
			return '天井には{シャンデリア}がひとつ下がっている。';
		end
		return '輝く{シャンデリア}が2つ天井から吊り下がっている。';
	end,
	act = function(s, w)
		if guards1._shoot then
			return 'シャンデリアのひとつがちょうどセキュリティゲートの上に吊り下がっている。';
		end
		return '近寄って見るのは無理だが、たぶんクリスタル製だろう。';
	end,
	used = function(s, w)
		if w == 'revol' then
			return 'このリボルバーの弾ではシャンデリアにたいしたダメージを与えられないだろう。';
		end
		if w == 'shotgun' then
			shotgun._unloaded = true;
			s._broken = true;
			guards1._broken = true;
			lifeoff('vorota');
			drop('shotgun');
			return '俺は壁から顔を出してショットガンを撃った。銃声とシャンデリアの砕ける音が俺の耳を直撃した。シャンデリアのひとつが砕けて、天井のかけらごと叫び声を上げる警備員の真上に落ちるところが見えた。俺は弾切れになったショットガンを捨てた。';
		end
	end,
	
};

vorota = room {
	nam = '1階ゲート',
	pic = 'gfx/shooting.png',
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then
			lifeon('vorota');
			return '1階ゲートの近くで銃声が聞こえ弾を避けるために俺は壁に体を押し付けた。';
		end
	end,
	life = function(s)
		if rnd(6) < 4 then
			return '銃声が響いた。俺は壁に身を寄せた。';
		end 
	end,
	act = function(s, w)
		if w == 1 then
			return 'あのセキュリティゲートは今日俺が中に入るのに通ったやつだ。今は別の側から見ている。';
		end
	end,
	dsc = '俺は開いたゲートにいる。やつらは研究所の1階ホールに続くゲートを開けたようだ。',
	obj = {
	vobj(1, 'セキュリティゲート', 'ホールの奥に{セキュリティゲート}の列が見える。'),
	'lustra1',
	'guards1',
	},
	exit = function(s, t)
		if not guards1._broken and t == 'train' then
			return '俺は先を急いだが、マシンガンが俺を狙って撃ち始め慌てて戻った。',
			false;
		end
	end,
	way = { 'train', 'eside2' },
};

theend = room {
	nam = 'エピローグ',
	pic = 'gfx/chme3.png',
	dsc = [[俺はコントローラのハンドルを最前面に動かした。すると機関車は大きく振動して加速した。列車の後ろのほうで叫び声が響き、この要塞の強固な壁にマシンガンの弾が当たってむなしく跳ね返るのが聞こえた。^^列車は加速を続けた。それからすぐに猛烈な衝突があった！鉄のゲートが俺の1350馬力の列車の前に立ちはだかり、あっけなく敗北した。ゲートの蝶番が破壊されレールに沿って数十メートルも引きずられることになった。^^
バルシクが顔を出してまわりを見回した。俺はいつもやるように彼の耳の後ろをかいてやった。^^
銃声が聞こえなくなってから俺は振り返って窓の外を見た。俺が最後に見る研究所の姿だった。建物の上部がトーチのように燃え上がっている。5階フロアはすべて炎に飲み込まれているようだ。それから俺は空を見上げた。夜はふけて今はまったくの暗闇になっていた。俺はダイヤモンドのように輝く数百万の星々を見上げた。^^

しばらくすると外の景色は雪に覆われた針葉樹林になっていき、俺がよく慣れ親しんだ松とモミの木の形をした黒い影が見えた。景色の中でひとつだけ慣れ親しんでいないものはといえば、この列車の響きだけだった。^^

怪我をした左の肩が急に痛み出し、自分がずいぶん疲れていることを思い出した。俺は床に座り込んで運転台の冷たい壁に寄りかかった。俺は低く響くエンジンのノイズを聞きながらバルシクの頭をなでた。^^

バルシクはいつもの賢そうな瞳で俺を見上げて、まるでなにかを尋ねるかのようにゴロゴロとノドを鳴らした。家に帰ろう。俺はバルシクにそう答えた。俺たちは家に帰るんだ……。^^

THE END^^

---^^
^^
<u>クレジット</u>^^
^^

ロシア語原作とINSTEADエンジン： ^
Peter Kosyh ハンドルネーム：gl00my // 2009^^

グラフィック： ^
Peter Kosyh、いくつかの写真はオープンソースのものを使った。^^

音楽： ^
One fine day // Elwood^
Revelation // necros^
New beginning // Purple Motion^
Ice frontier // Skaven^
Planete football // Frank Amoros^
Underwater world II // Slightly Magic^
Hybrid song // Quazar^
Hispeed - track whatever // Purple Motion^
Liberty // Zapper^^

テスター： ^
Sergey Kalichev ハンドルネーム：Pkun^
Vladimir Podobaev ハンドルネーム：zloyvov^^

英語版翻訳：^
エピソード1：tkzv^
エピソード2と3：Vladimir Podobaev^^

日本語版翻訳：nomad3yzec^^

もしこのゲームが気に入ったのなら、INSTEADエンジンでオリジナルのゲームを作り歴史に名前を刻んでくれたまえ :-)。^^

謝辞： ^
協力してくれたすべての人に。 :)^^

]],
};

