/*
	HEWX.H
	Header file for wxWindows port of the Hugo Engine
	(c) 2002 by Kent Tessman
*/

// For compilers that support precompilation, includes "wx/wx.h"
#include "wx/wxprec.h"
#ifdef __BORLANDC__
#pragma hdrstop
#endif
// for all others, include the necessary wxWin headers
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#ifdef __WXMAC__
#include <MacTypes.h>
#include <Windows.h>
extern char StringANSI[], StringMac[];
#define VIDEO_SUPPORTED
#endif

#define CONFIG_NAME "wxHugo"


// ----------------------------------------------------------------------------
// Private classes
// ----------------------------------------------------------------------------

// Define a new application type, each program should derive a class from wxApp
class HEApp : public wxApp
{
public:
	// This one is called on application startup and is a good place for the app
	// initialization (doing it here and not in the ctor allows to have an error
	// return: if OnInit() returns false, the application terminates)
	virtual bool OnInit();
	virtual int MainLoop();
	virtual int OnExit();
	void PrintArgs();
	int ProcessArgs();
	void ChooseFile();
};

// Define a new frame type: this is going to be our main frame
class HEFrame : public wxFrame
{
public:
	HEFrame(const wxString& title, const wxPoint& pos, const wxSize& size);
	void UpdateMenuItems(void);

	void OnResize(wxSizeEvent& event);
	void OnChar(wxKeyEvent& event);
//	void OnPaint(wxPaintEvent& event);
	void OnClose(wxCloseEvent& event);

	// Menu events:
	// File menu
	void OnOpen(wxCommandEvent& event);
	void OnQuit(wxCommandEvent& event);
	// Story menu
	void OnStory(wxCommandEvent& event);
	// Options menu
	void OnFont(wxCommandEvent& event);
	void OnColor(wxCommandEvent& event);
	void OnFastScrolling(wxCommandEvent& event);
#ifdef __WXMAC__
	void OnQuartzRendering(wxCommandEvent& event);
#endif
	void OnGraphics(wxCommandEvent& event);
	void OnGraphicsSmoothing(wxCommandEvent& event);
	void OnSound(wxCommandEvent& event);
	void OnUnfreeze(wxCommandEvent& event);
	void OnResetDisplay(wxCommandEvent& event);
	void OnCompassRose(wxCommandEvent& event);
	void OnScrollback(wxCommandEvent& event);
	// Help
	void OnAbout(wxCommandEvent& event);
	// Context menus
	void HandleContextCommand(wxCommandEvent& event);

private:
	DECLARE_EVENT_TABLE()
};

// Define a new canvas which can receive some events
class HECanvas: public wxWindow
{
public:
	int width, height;
	int needs_updating, override_update;
	int scroll_offset;
	bool isactive;

	HECanvas(HEFrame *frame, wxWindowID id, const wxPoint& pos, const wxSize& size);
	
	void Update(bool visible);
#ifdef NO_WXCARET
	void DrawCaret(void);
	void DrawCaret(int x, int y);
	bool caret_drawn;
	int caret_x, caret_y;
#endif

	// event handlers (these functions should _not_ be virtual)
	void OnSetFocus(wxFocusEvent& event);
	void OnKillFocus(wxFocusEvent& event);
	void OnPaint(wxPaintEvent& event);
	void OnMouseEvent(wxMouseEvent& event);
	void OnContextMenu(wxMouseEvent& event);
	void OnChar(wxKeyEvent& event);

private:	
	DECLARE_EVENT_TABLE()
};

// ----------------------------------------------------------------------------

#ifndef wxCHECK_VERSION
#define wxCHECK_VERSION(major,minor,release) \
    (wxMAJOR_VERSION > (major) || \
    (wxMAJOR_VERSION == (major) && wxMINOR_VERSION > (minor)) || \
    (wxMAJOR_VERSION == (major) && wxMINOR_VERSION == (minor) && wxRELEASE_NUMBER >= (release)))
#endif

void ProcesswxWinMessages(void);

// IDs for the controls and the menu commands
enum
{
	// menu items
	// File
	Menu_Open = 1,
	Menu_Quit,
	// Story
	Menu_Restart,
	Menu_Restore,
	Menu_Save,
	Menu_Undo,
	// Options
	Menu_Fonts,
		Menu_FixedFont,
		Menu_PropFont,
		Menu_DefaultFonts,
		Menu_SmartFormatting,
#ifdef __WXMAC__
		Menu_QuartzRendering,
#endif
	Menu_Colors,
		Menu_ForeColor,
		Menu_BackColor,
		Menu_SLForeColor,
		Menu_SLBackColor,
		Menu_RestoreColors,
	Menu_FastScrolling,
	Menu_Graphics,
	Menu_GraphicsSmoothing,
	Menu_Sound,
	Menu_Unfreeze,
	Menu_ResetDisplay,
	Menu_CompassRose,
	Menu_Scrollback,
	// Help
	Menu_About,
	Menu_Context	// Must be last
};

// Window identifiers
enum
{
	CANVAS_ID = 500,
	SCROLLBACK_ID
};

// Faux-keypress codes
enum
{
	CTRL_LEFT_KEY = 1000,
	CTRL_RIGHT_KEY,
	BACKSPACE_KEY
};

// from hewxwin.cpp

extern "C" void wxAlert(char *a);
extern "C" void wxAlertVal(char *a, int v);
extern void TypeCommand(char *cmd, bool clear, bool linefeed);

extern HEApp *app;
extern HEFrame *frame;
extern HECanvas *canvas;
extern wxBitmap *bitmap;
extern wxFont *fontCurrent;
extern char faceProp[], faceFixed[];
extern int sizeProp, sizeFixed, familyProp, familyFixed;
extern wxColour *def_fcolor, *def_bgcolor, *def_slfcolor, *def_slbgcolor;
extern wxColour *update_bgcolor;
extern int fast_scrolling, sound_enabled, graphics_enabled;
extern int graphics_smoothing;
extern char processed_accelerator_key;
#ifdef __WXMAC__
extern long quartz_rendering;
extern SInt32 system_version;
#endif

// from hewx.cpp

extern "C"
{
void PushKeypress(int k);
int PullKeypress(void);
void ConstrainCursor(void);
void FlushBuffer(void);
wxColour *hugo_color(int c);

extern char scrollback_buffer[];
extern int scrollback_pos;
extern char waiting_for_key;
extern char getline_active;
}

// from hesound.cpp

extern "C"
{
void hugo_stopmusic(void);
void hugo_stopsample(void);
}
int InitPlayer(void);
void ExitPlayer(void);
void SuspendAudio(void);
void ResumeAudio(void);
#if wxUSE_THREADS
extern bool use_sound_thread;
#endif

// from hevideo.cpp
#ifdef VIDEO_SUPPORTED
extern "C" void hugo_stopvideo(void);
#endif

// additional/conditional stuff

#ifdef COMPASS_ROSE_DEFINED
extern int compass_showing;
extern int compass_x, compass_y;
void ShowCompassRose(bool show);
void ShowScrollback(void);
#ifdef __WXMAC__
extern WindowRef compass;
bool CompassEvent(EventRecord *);
#endif
#endif

