// Created with Squiffy 5.1.3
// https://github.com/textadventures/squiffy

(function(){
/* jshint quotmark: single */
/* jshint evil: true */

var squiffy = {};

(function () {
    'use strict';

    squiffy.story = {};

    var initLinkHandler = function () {
        var handleLink = function (link) {
            if (link.hasClass('disabled')) return;
            var passage = link.data('passage');
            var section = link.data('section');
            var rotateAttr = link.attr('data-rotate');
            var sequenceAttr = link.attr('data-sequence');
            if (passage) {
                disableLink(link);
                squiffy.set('_turncount', squiffy.get('_turncount') + 1);
                passage = processLink(passage);
                if (passage) {
                    currentSection.append('<hr/>');
                    squiffy.story.passage(passage);
                }
                var turnPassage = '@' + squiffy.get('_turncount');
                if (turnPassage in squiffy.story.section.passages) {
                    squiffy.story.passage(turnPassage);
                }
                if ('@last' in squiffy.story.section.passages && squiffy.get('_turncount')>= squiffy.story.section.passageCount) {
                    squiffy.story.passage('@last');
                }
            }
            else if (section) {
                currentSection.append('<hr/>');
                disableLink(link);
                section = processLink(section);
                squiffy.story.go(section);
            }
            else if (rotateAttr || sequenceAttr) {
                var result = rotate(rotateAttr || sequenceAttr, rotateAttr ? link.text() : '');
                link.html(result[0].replace(/&quot;/g, '"').replace(/&#39;/g, '\''));
                var dataAttribute = rotateAttr ? 'data-rotate' : 'data-sequence';
                link.attr(dataAttribute, result[1]);
                if (!result[1]) {
                    disableLink(link);
                }
                if (link.attr('data-attribute')) {
                    squiffy.set(link.attr('data-attribute'), result[0]);
                }
                squiffy.story.save();
            }
        };

        squiffy.ui.output.on('click', 'a.squiffy-link', function () {
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('keypress', 'a.squiffy-link', function (e) {
            if (e.which !== 13) return;
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('mousedown', 'a.squiffy-link', function (event) {
            event.preventDefault();
        });
    };

    var disableLink = function (link) {
        link.addClass('disabled');
        link.attr('tabindex', -1);
    }
    
    squiffy.story.begin = function () {
        if (!squiffy.story.load()) {
            squiffy.story.go(squiffy.story.start);
        }
    };

    var processLink = function(link) {
		link = String(link);
        var sections = link.split(',');
        var first = true;
        var target = null;
        sections.forEach(function (section) {
            section = section.trim();
            if (startsWith(section, '@replace ')) {
                replaceLabel(section.substring(9));
            }
            else {
                if (first) {
                    target = section;
                }
                else {
                    setAttribute(section);
                }
            }
            first = false;
        });
        return target;
    };

    var setAttribute = function(expr) {
        var lhs, rhs, op, value;
        var setRegex = /^([\w]*)\s*=\s*(.*)$/;
        var setMatch = setRegex.exec(expr);
        if (setMatch) {
            lhs = setMatch[1];
            rhs = setMatch[2];
            if (isNaN(rhs)) {
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
                squiffy.set(lhs, rhs);
            }
            else {
                squiffy.set(lhs, parseFloat(rhs));
            }
        }
        else {
			var incDecRegex = /^([\w]*)\s*([\+\-\*\/])=\s*(.*)$/;
            var incDecMatch = incDecRegex.exec(expr);
            if (incDecMatch) {
                lhs = incDecMatch[1];
                op = incDecMatch[2];
				rhs = incDecMatch[3];
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
				rhs = parseFloat(rhs);
                value = squiffy.get(lhs);
                if (value === null) value = 0;
                if (op == '+') {
                    value += rhs;
                }
                if (op == '-') {
                    value -= rhs;
                }
				if (op == '*') {
					value *= rhs;
				}
				if (op == '/') {
					value /= rhs;
				}
                squiffy.set(lhs, value);
            }
            else {
                value = true;
                if (startsWith(expr, 'not ')) {
                    expr = expr.substring(4);
                    value = false;
                }
                squiffy.set(expr, value);
            }
        }
    };

    var replaceLabel = function(expr) {
        var regex = /^([\w]*)\s*=\s*(.*)$/;
        var match = regex.exec(expr);
        if (!match) return;
        var label = match[1];
        var text = match[2];
        if (text in squiffy.story.section.passages) {
            text = squiffy.story.section.passages[text].text;
        }
        else if (text in squiffy.story.sections) {
            text = squiffy.story.sections[text].text;
        }
        var stripParags = /^<p>(.*)<\/p>$/;
        var stripParagsMatch = stripParags.exec(text);
        if (stripParagsMatch) {
            text = stripParagsMatch[1];
        }
        var $labels = squiffy.ui.output.find('.squiffy-label-' + label);
        $labels.fadeOut(1000, function() {
            $labels.html(squiffy.ui.processText(text));
            $labels.fadeIn(1000, function() {
                squiffy.story.save();
            });
        });
    };

    squiffy.story.go = function(section) {
        squiffy.set('_transition', null);
        newSection();
        squiffy.story.section = squiffy.story.sections[section];
        if (!squiffy.story.section) return;
        squiffy.set('_section', section);
        setSeen(section);
        var master = squiffy.story.sections[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(squiffy.story.section);
        // The JS might have changed which section we're in
        if (squiffy.get('_section') == section) {
            squiffy.set('_turncount', 0);
            squiffy.ui.write(squiffy.story.section.text);
            squiffy.story.save();
        }
    };

    squiffy.story.run = function(section) {
        if (section.clear) {
            squiffy.ui.clearScreen();
        }
        if (section.attributes) {
            processAttributes(section.attributes);
        }
        if (section.js) {
            section.js();
        }
    };

    squiffy.story.passage = function(passageName) {
        var passage = squiffy.story.section.passages[passageName];
        if (!passage) return;
        setSeen(passageName);
        var masterSection = squiffy.story.sections[''];
        if (masterSection) {
            var masterPassage = masterSection.passages[''];
            if (masterPassage) {
                squiffy.story.run(masterPassage);
                squiffy.ui.write(masterPassage.text);
            }
        }
        var master = squiffy.story.section.passages[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(passage);
        squiffy.ui.write(passage.text);
        squiffy.story.save();
    };

    var processAttributes = function(attributes) {
        attributes.forEach(function (attribute) {
            if (startsWith(attribute, '@replace ')) {
                replaceLabel(attribute.substring(9));
            }
            else {
                setAttribute(attribute);
            }
        });
    };

    squiffy.story.restart = function() {
        if (squiffy.ui.settings.persist && window.localStorage) {
            var keys = Object.keys(localStorage);
            jQuery.each(keys, function (idx, key) {
                if (startsWith(key, squiffy.story.id)) {
                    localStorage.removeItem(key);
                }
            });
        }
        else {
            squiffy.storageFallback = {};
        }
        if (squiffy.ui.settings.scroll === 'element') {
            squiffy.ui.output.html('');
            squiffy.story.begin();
        }
        else {
            location.reload();
        }
    };

    squiffy.story.save = function() {
        squiffy.set('_output', squiffy.ui.output.html());
    };

    squiffy.story.load = function() {
        var output = squiffy.get('_output');
        if (!output) return false;
        squiffy.ui.output.html(output);
        currentSection = jQuery('#' + squiffy.get('_output-section'));
        squiffy.story.section = squiffy.story.sections[squiffy.get('_section')];
        var transition = squiffy.get('_transition');
        if (transition) {
            eval('(' + transition + ')()');
        }
        return true;
    };

    var setSeen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) seenSections = [];
        if (seenSections.indexOf(sectionName) == -1) {
            seenSections.push(sectionName);
            squiffy.set('_seen_sections', seenSections);
        }
    };

    squiffy.story.seen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) return false;
        return (seenSections.indexOf(sectionName) > -1);
    };
    
    squiffy.ui = {};

    var currentSection = null;
    var screenIsClear = true;
    var scrollPosition = 0;

    var newSection = function() {
        if (currentSection) {
            disableLink(jQuery('.squiffy-link', currentSection));
        }
        var sectionCount = squiffy.get('_section-count') + 1;
        squiffy.set('_section-count', sectionCount);
        var id = 'squiffy-section-' + sectionCount;
        currentSection = jQuery('<div/>', {
            id: id,
        }).appendTo(squiffy.ui.output);
        squiffy.set('_output-section', id);
    };

    squiffy.ui.write = function(text) {
        screenIsClear = false;
        scrollPosition = squiffy.ui.output.height();
        currentSection.append(jQuery('<div/>').html(squiffy.ui.processText(text)));
        squiffy.ui.scrollToEnd();
    };

    squiffy.ui.clearScreen = function() {
        squiffy.ui.output.html('');
        screenIsClear = true;
        newSection();
    };

    squiffy.ui.scrollToEnd = function() {
        var scrollTo, currentScrollTop, distance, duration;
        if (squiffy.ui.settings.scroll === 'element') {
            scrollTo = squiffy.ui.output[0].scrollHeight - squiffy.ui.output.height();
            currentScrollTop = squiffy.ui.output.scrollTop();
            if (scrollTo > currentScrollTop) {
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.4;
                squiffy.ui.output.stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
        else {
            scrollTo = scrollPosition;
            currentScrollTop = Math.max(jQuery('body').scrollTop(), jQuery('html').scrollTop());
            if (scrollTo > currentScrollTop) {
                var maxScrollTop = jQuery(document).height() - jQuery(window).height();
                if (scrollTo > maxScrollTop) scrollTo = maxScrollTop;
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.5;
                jQuery('body,html').stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
    };

    squiffy.ui.processText = function(text) {
        function process(text, data) {
            var containsUnprocessedSection = false;
            var open = text.indexOf('{');
            var close;
            
            if (open > -1) {
                var nestCount = 1;
                var searchStart = open + 1;
                var finished = false;
             
                while (!finished) {
                    var nextOpen = text.indexOf('{', searchStart);
                    var nextClose = text.indexOf('}', searchStart);
         
                    if (nextClose > -1) {
                        if (nextOpen > -1 && nextOpen < nextClose) {
                            nestCount++;
                            searchStart = nextOpen + 1;
                        }
                        else {
                            nestCount--;
                            searchStart = nextClose + 1;
                            if (nestCount === 0) {
                                close = nextClose;
                                containsUnprocessedSection = true;
                                finished = true;
                            }
                        }
                    }
                    else {
                        finished = true;
                    }
                }
            }
            
            if (containsUnprocessedSection) {
                var section = text.substring(open + 1, close);
                var value = processTextCommand(section, data);
                text = text.substring(0, open) + value + process(text.substring(close + 1), data);
            }
            
            return (text);
        }

        function processTextCommand(text, data) {
            if (startsWith(text, 'if ')) {
                return processTextCommand_If(text, data);
            }
            else if (startsWith(text, 'else:')) {
                return processTextCommand_Else(text, data);
            }
            else if (startsWith(text, 'label:')) {
                return processTextCommand_Label(text, data);
            }
            else if (/^rotate[: ]/.test(text)) {
                return processTextCommand_Rotate('rotate', text, data);
            }
            else if (/^sequence[: ]/.test(text)) {
                return processTextCommand_Rotate('sequence', text, data);   
            }
            else if (text in squiffy.story.section.passages) {
                return process(squiffy.story.section.passages[text].text, data);
            }
            else if (text in squiffy.story.sections) {
                return process(squiffy.story.sections[text].text, data);
            }
			else if (startsWith(text,'@') && !startsWith(text,'@replace')) {
				processAttributes(text.substring(1).split(","));
				return "";
			}
            return squiffy.get(text);
        }

        function processTextCommand_If(section, data) {
            var command = section.substring(3);
            var colon = command.indexOf(':');
            if (colon == -1) {
                return ('{if ' + command + '}');
            }

            var text = command.substring(colon + 1);
            var condition = command.substring(0, colon);
			condition = condition.replace("<", "&lt;");
            var operatorRegex = /([\w ]*)(=|&lt;=|&gt;=|&lt;&gt;|&lt;|&gt;)(.*)/;
            var match = operatorRegex.exec(condition);

            var result = false;

            if (match) {
                var lhs = squiffy.get(match[1]);
                var op = match[2];
                var rhs = match[3];

				if(startsWith(rhs,'@')) rhs=squiffy.get(rhs.substring(1));
				
                if (op == '=' && lhs == rhs) result = true;
                if (op == '&lt;&gt;' && lhs != rhs) result = true;
                if (op == '&gt;' && lhs > rhs) result = true;
                if (op == '&lt;' && lhs < rhs) result = true;
                if (op == '&gt;=' && lhs >= rhs) result = true;
                if (op == '&lt;=' && lhs <= rhs) result = true;
            }
            else {
                var checkValue = true;
                if (startsWith(condition, 'not ')) {
                    condition = condition.substring(4);
                    checkValue = false;
                }

                if (startsWith(condition, 'seen ')) {
                    result = (squiffy.story.seen(condition.substring(5)) == checkValue);
                }
                else {
                    var value = squiffy.get(condition);
                    if (value === null) value = false;
                    result = (value == checkValue);
                }
            }

            var textResult = result ? process(text, data) : '';

            data.lastIf = result;
            return textResult;
        }

        function processTextCommand_Else(section, data) {
            if (!('lastIf' in data) || data.lastIf) return '';
            var text = section.substring(5);
            return process(text, data);
        }

        function processTextCommand_Label(section, data) {
            var command = section.substring(6);
            var eq = command.indexOf('=');
            if (eq == -1) {
                return ('{label:' + command + '}');
            }

            var text = command.substring(eq + 1);
            var label = command.substring(0, eq);

            return '<span class="squiffy-label-' + label + '">' + process(text, data) + '</span>';
        }

        function processTextCommand_Rotate(type, section, data) {
            var options;
            var attribute = '';
            if (section.substring(type.length, type.length + 1) == ' ') {
                var colon = section.indexOf(':');
                if (colon == -1) {
                    return '{' + section + '}';
                }
                options = section.substring(colon + 1);
                attribute = section.substring(type.length + 1, colon);
            }
            else {
                options = section.substring(type.length + 1);
            }
            var rotation = rotate(options.replace(/"/g, '&quot;').replace(/'/g, '&#39;'));
            if (attribute) {
                squiffy.set(attribute, rotation[0]);
            }
            return '<a class="squiffy-link" data-' + type + '="' + rotation[1] + '" data-attribute="' + attribute + '" role="link">' + rotation[0] + '</a>';
        }

        var data = {
            fulltext: text
        };
        return process(text, data);
    };

    squiffy.ui.transition = function(f) {
        squiffy.set('_transition', f.toString());
        f();
    };

    squiffy.storageFallback = {};

    squiffy.set = function(attribute, value) {
        if (typeof value === 'undefined') value = true;
        if (squiffy.ui.settings.persist && window.localStorage) {
            localStorage[squiffy.story.id + '-' + attribute] = JSON.stringify(value);
        }
        else {
            squiffy.storageFallback[attribute] = JSON.stringify(value);
        }
        squiffy.ui.settings.onSet(attribute, value);
    };

    squiffy.get = function(attribute) {
        var result;
        if (squiffy.ui.settings.persist && window.localStorage) {
            result = localStorage[squiffy.story.id + '-' + attribute];
        }
        else {
            result = squiffy.storageFallback[attribute];
        }
        if (!result) return null;
        return JSON.parse(result);
    };

    var startsWith = function(string, prefix) {
        return string.substring(0, prefix.length) === prefix;
    };

    var rotate = function(options, current) {
        var colon = options.indexOf(':');
        if (colon == -1) {
            return [options, current];
        }
        var next = options.substring(0, colon);
        var remaining = options.substring(colon + 1);
        if (current) remaining += ':' + current;
        return [next, remaining];
    };

    var methods = {
        init: function (options) {
            var settings = jQuery.extend({
                scroll: 'body',
                persist: true,
                restartPrompt: true,
                onSet: function (attribute, value) {}
            }, options);

            squiffy.ui.output = this;
            squiffy.ui.restart = jQuery(settings.restart);
            squiffy.ui.settings = settings;

            if (settings.scroll === 'element') {
                squiffy.ui.output.css('overflow-y', 'auto');
            }

            initLinkHandler();
            squiffy.story.begin();
            
            return this;
        },
        get: function (attribute) {
            return squiffy.get(attribute);
        },
        set: function (attribute, value) {
            squiffy.set(attribute, value);
        },
        restart: function () {
            if (!squiffy.ui.settings.restartPrompt || confirm('Seguro quieres reiniciar?')) {
                squiffy.story.restart();
            }
        }
    };

    jQuery.fn.squiffy = function (methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions]
                .apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else if (typeof methodOrOptions === 'object' || ! methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            jQuery.error('Method ' +  methodOrOptions + ' does not exist');
        }
    };
})();

var get = squiffy.get;
var set = squiffy.set;


squiffy.story.start = 'Inicio';
squiffy.story.id = '06a8b0e589';
squiffy.story.sections = {
	'PUNTAJE': {
		'text': "<p><table style=\"background-color:black;color:white;\" width=\"100%\"></p>\n<p><tr></p>\n<p><td style=\"text-align:left;\" >&nbsp;Puntaje Memoria: <b>{puntaje_memoria}&nbsp;</b></td></p>\n<p><td style=\"text-align:right;\">&nbsp;Puntaje {seccion}: <b>{puntaje}&nbsp;</b></td>\n</tr>\n</table>\n<br></p>",
		'passages': {
		},
	},
	'PUNTAJEMEMORIA': {
		'text': "<p><table style=\"background-color:black;color:white;\" width=\"100%\"></p>\n<p><tr></p>\n<p><td style=\"text-align:left;\" >&nbsp;Puntaje Memoria: <b>{puntaje_memoria}&nbsp;</b></td>\n</tr>\n</table>\n<br></p>\n<!-- Variables del juego -->",
		'passages': {
		},
	},
	'Inicio': {
		'clear': true,
		'text': "<!-- Encabezado para textadventures.co.uk -->\n<!-- <img src=\"MemoriaTitulo.jpg\" align=middle alt=\"Paisaje con islas flotando en el cielo\" height=\"145\" width=\"221\">&nbsp;<font face=\"papyrus\" color=\"darkblue\" size=10>M&nbsp;e&nbsp;m&nbsp;o&nbsp;r&nbsp;i&nbsp;a</font> -->\n<!-- <br>versión 01.01.01 -->\n<!-- <br><a href=\"https://incanus.caad.club/memoria.html\" target=\"_blank\">Visita su página web</a> -->\n<!-- Encabezado para otras publicaciones -->\n<p><font face=\"papyrus\" color=\"darkblue\" size=10>M&nbsp;e&nbsp;m&nbsp;o&nbsp;r&nbsp;i&nbsp;a</font>\n<br>versión 01.01.01\n<br><br>\nLos Ancianos nos enseñan que después de la muerte, hay algo más que Recuerdo y Memoria.<br><br>\nY tú ¿quieres aprender de los Ancianos?<br><br>\nEntonces, presta debida atención... <a class=\"squiffy-link link-section\" data-section=\"Leyenda del Protector\" role=\"link\" tabindex=\"0\">y comienza a aprender</a>.</p>\n<!-- Intro Leyenda del Protector -->",
		'attributes': ["puntaje=0","puntaje_Naufragio=0","puntaje_Aldea=0","puntaje_Viajero=0","puntaje_memoria=0","decision_final=0","seccion=Naufragio","not derrame_minireactor","not puerta_volada","not visto_trozo_capsula","not visto_fragmentos","not visto_flotadores","not tengo_pistola","not tengo_esterilla","not tengo_pasto_corto","not tengo_pasto_largo","not visto_cazadores","not visto_risa","not visto_circulo","not visto_saludo","not visto_Mayor","not visto_erial","not llevo_pistola"],
		'passages': {
		},
	},
	'Leyenda del Protector': {
		'clear': true,
		'text': "<font face=\"papyrus\" color=\"darkred\"><b><blockquote>\nAl principio sólo estaban La Gente y los Cazadores.<br>\nLa Gente era presa de los Cazadores<br>\nY por largo tiempo<br>\nvivimos en el temor de los Cazadores.<br>\n<br>\nLos Cazadores siempre acechaban<br>\nen los Campos de las Flores de Fuego...<br>\ny a veces, cuando hacía frío,<br>\nhabía que arriesgar la vida.<br>\n<br>\nLos Cazadores siempre acechaban<br>\ncerca del Lago Ardiente...<br>\ny ver su belleza<br>\nequivalía a morir.<br>\n<br>\nLos Cazadores siempre acechaban en las llanuras...<br>\ny era peligroso conseguir alimento.<br>\n<br>\nPero llegó <a class=\"squiffy-link link-section\" data-section=\"Sigue el Protector\" role=\"link\" tabindex=\"0\">El Protector</a>.\n</blockquote></b></font>",
		'passages': {
		},
	},
	'Sigue el Protector': {
		'clear': true,
		'text': "<font face=\"papyrus\" color=\"darkgreen\"><b><blockquote>\nEl Protector alejó a los Cazadores<br>\nmás allá de los Páramos<br>\ny La Gente tuvo paz.<br>\n<br>\nEl Protector ahuyentó a los Cazadores.<br>\nEl Protector siempre estaba cerca.<br>\nEl Protector vigilaba de noche.<br>\nEl Protector vigilaba de día.<br>\nEl Protector nos cuidaba.<br>\n<br>\nEl Protector era el mejor amigo de la aldea.<br>\nLa vida se volvió fácil gracias a El Protector.<br>\n<br>\nEl Protector nunca exigió nada...<br>\npero, a veces, necesitaba descansar.<br>\nEl Protector dormía por poco tiempo...<br>\npero debía ser <a class=\"squiffy-link link-section\" data-section=\"Fin del Protector\" role=\"link\" tabindex=\"0\">despertado por La Gente</a>.\n</blockquote></b></font>",
		'passages': {
		},
	},
	'Fin del Protector': {
		'clear': true,
		'text': "<font face=\"papyrus\" color=\"darkred\"><b><blockquote>\nUn día El Protector se echó a dormir<br>\ny La Gente no pudo despertarlo.<br>\n<br>\nNadie estaba para ahuyentar a los Cazadores<br>\nY volvimos a ser presa de los Cazadores.<br>\n<br>\nY por largo tiempo<br>\nvivimos nuevamente en el temor de <a class=\"squiffy-link link-section\" data-section=\"Parte I\" role=\"link\" tabindex=\"0\">los Cazadores</a>.\n</blockquote></b></font>\n\n\n\n<!-- Parte I El Naufragio -->\n<!-- Max Puntaje Memoria: 1 -->",
		'passages': {
		},
	},
	'Parte I': {
		'clear': true,
		'text': "<p><font color=\"white\"></p>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"34%\" style=\"background-color:black;text-align:center;font-family:courier;\"><b><br>\nParte I<br>\n<br>\nNaufragio<br>\n<br></b></td>\n<td width=\"33%\"></td>\n</tr></table>\n</font>\n<br><br>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"33%\"></td>\n<td width=\"33%\" style=\"text-align:right;\"><a class=\"squiffy-link link-section\" data-section=\"Naufragio\" role=\"link\" tabindex=\"0\">Continuar</a></td>\n</tr></table>",
		'passages': {
		},
	},
	'Naufragio': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCalor.</p>\n<p>Dolor.</p>\n<p>¡Ruido!</p>\n<p>Me despierto con todo el cuerpo adolorido... pero al menos sigo vivo.</p>\n<p>Miro a mi alrededor y aunque el resto de la <a class=\"squiffy-link link-passage\" data-passage=\"capsula\" role=\"link\" tabindex=\"0\">cápsula de escape</a> parece estar entera, mis otros compañeros tuvieron <a class=\"squiffy-link link-passage\" data-passage=\"compañeros\" role=\"link\" tabindex=\"0\">peor suerte</a> que yo.</p>\n<p>Bueno, está por verse si a mí me irá mejor: el calor es apenas más soportable que el <a class=\"squiffy-link link-passage\" data-passage=\"sirena\" role=\"link\" tabindex=\"0\">ruido de la sirena</a>, así que más vale que salga de aquí cuanto antes.</p>\n<p>Abro mi vaina de seguridad y pruebo a pararme; no tengo nada roto, parece, así que de momento todo va bien.</p>\n<p>El <a class=\"squiffy-link link-section\" data-section=\"panel de mandos\" role=\"link\" tabindex=\"0\">panel de mandos</a> parpadea de color rojo furioso reclamando mi atención, pero del <a class=\"squiffy-link link-section\" data-section=\"minirreactor\" role=\"link\" tabindex=\"0\">minirreactor</a> emana un calor cada vez más fuerte... ¡y el tiempo apremia!</p>",
		'passages': {
			'capsula': {
				'text': "<p>Cuando los micrometeoritos atravesaron el casco de la nave, sólo tres de nosotros alcanzamos a abordar este módulo de emergencia. Ignoro qué pasó después o si alguien más consiguió salir a tiempo.</p>",
			},
			'compañeros': {
				'text': "<p>Sus vainas de seguridad están perforadas por miríadas de agujeros, que también están en el &quot;techo&quot; de la cápsula. Puedo ver los cuerpos incinerados y retorcidos de mis compañeros; un amasijo de carne mezclado con plástico y metal. Pobres diablos...</p>",
			},
			'sirena': {
				'text': "<p>La computadora a bordo ha activado el claxon de emergencia... Apenas logro escuchar mis pensamientos, pero me ha despertado y estoy agradecido de eso.</p>",
			},
		},
	},
	'panel de mandos': {
		'text': "<p>Me bastan unos segundos para ver que el panel informa que hay una falla en el sistema de enfriamiento primario.</p>\n<p>Me acerco al minirreactor y uso la palanca manual a un costado para &quot;bombear&quot; el sistema de enfriamiento y reiniciarlo.</p>\n<p>En cosa de segundos el calor baja a niveles más normales, el panel de mandos queda de un color verde apagado y el claxon de la sirena se desconecta.</p>\n<p>Suspiro.</p>\n<p>Es hora de <a class=\"squiffy-link link-section\" data-section=\"esclusa\" role=\"link\" tabindex=\"0\">salir de aquí</a> y ver qué hay allá afuera...</p>",
		'attributes': ["puntaje+=1","puntaje_Naufragio+=1"],
		'passages': {
		},
	},
	'minirreactor': {
		'text': "<p>Me acerco al minirreactor con algo de ansiedad, pulso el botón rojo de purga... y libero algo de combustible del reactor a la atmósfera.</p>\n<p>En cosa de segundos el calor baja a niveles más normales, el panel de mandos queda de un color amarillo intenso y el claxon de la sirena se desconecta.</p>\n<p>Suspiro. Lo lamento por este planeta, pero no se me ha ocurrido nada mejor.</p>\n<p>Es hora de <a class=\"squiffy-link link-section\" data-section=\"esclusa\" role=\"link\" tabindex=\"0\">salir de aquí</a> y ver qué hay allá afuera...</p>",
		'attributes': ["derrame_minireactor"],
		'passages': {
		},
	},
	'esclusa': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAbro la puerta interior y entro en la esclusa de la cápsula.</p>\n<p>La luz de la puerta exterior está de <a class=\"squiffy-link link-passage\" data-passage=\"luz ambiental\" role=\"link\" tabindex=\"0\">color verde</a>; buenas noticias.</p>\n<p>La puerta en sí se ve entera, pero los bordes del sello estanco parecen estar algo quemados.</p>\n<p>No parece haber otras fallas, así que puedo probar a <a class=\"squiffy-link link-section\" data-section=\"manualmente\" role=\"link\" tabindex=\"0\">abrir manualmente</a> la puerta exterior... o <a class=\"squiffy-link link-section\" data-section=\"volarla\" role=\"link\" tabindex=\"0\">volarla</a>, por las dudas.</p>",
		'passages': {
			'luz ambiental': {
				'text': "<p>Luz verde quiere decir que la atmósfera afuera tiene presión igualada con la cápsula y que la &quot;mezcla&quot; de gases es respirable.</p>",
			},
		},
	},
	'manualmente': {
		'text': "<p>Bombeo la palanca un par de veces y la puerta exterior se abre silenciosamente. Un panel de seguridad se desliza y me presenta una pistola de señales, que cojo prontamente.</p>\n<p>Salgo con cuidado, cerrando la puerta interior tras de mí, y doy mis primeros pasos en <a class=\"squiffy-link link-section\" data-section=\"un mundo nuevo\" role=\"link\" tabindex=\"0\">un mundo nuevo</a>.</p>",
		'attributes': ["puntaje+=1","puntaje_Naufragio+=1","tengo_pistola"],
		'passages': {
		},
	},
	'volarla': {
		'text': "<p>Retrocedo hasta la entrada interior de la esclusa y pulso el botón de emergencia.</p>\n<p>Con un ruido sordo, la puerta exterior sale disparada y aterriza quién sabe dónde.</p>\n<p>Salgo con cuidado, cerrando la puerta interior tras de mí, y doy mis primeros pasos en <a class=\"squiffy-link link-section\" data-section=\"un mundo nuevo\" role=\"link\" tabindex=\"0\">un mundo nuevo</a>.</p>",
		'attributes': ["puerta_volada"],
		'passages': {
		},
	},
	'un mundo nuevo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLa cápsula aterrizó y quedó semienterrada en algún sitio dentro de un vasto <a class=\"squiffy-link link-passage\" data-passage=\"crater\" role=\"link\" tabindex=\"0\">cráter</a>.</p>\n<p>A la tenue luz de <a class=\"squiffy-link link-passage\" data-passage=\"las estrellas\" role=\"link\" tabindex=\"0\">las estrellas</a> se distinguen algunas rocas aquí y allá... y en la distancia, me parece vislumbrar el borde escarpado del cráter.</p>\n<p>Más vale que me aleje de aquí\n{if derrame_minireactor: cuanto antes: la radioactividad que expulsó el reactor no hace aconsejable quedarse cerca de la cápsula; además, necesito }\n{else: para }encontrar un sitio elevado para orientarme. El borde del cráter no parece lejano y servirá para ver a mi alrededor.</p>\n<p>No tengo forma de saber a qué hora sale el sol en este planeta, así que tengo que decidir si <a class=\"squiffy-link link-section\" data-section=\"explorar\" role=\"link\" tabindex=\"0\">explorar el cráter</a> o bien dedicarme a salir del cráter; <a class=\"squiffy-link link-section\" data-section=\"lentamente\" role=\"link\" tabindex=\"0\">lentamente</a>, a cubierto entre las rocas o <a class=\"squiffy-link link-section\" data-section=\"rapidamente\" role=\"link\" tabindex=\"0\">rápidamente</a>, a campo traviesa.</p>",
		'passages': {
			'crater': {
				'text': "<p>El cráter es fruto de algún impacto anterior, seguro. Lo que sea que ocurrió aquí no tuvo ni el control ni la gracia de la cápsula, que apenas dejó una brecha corta en el <a class=\"squiffy-link link-passage\" data-passage=\"suelo\" role=\"link\" tabindex=\"0\">suelo</a> antes de detenerse.</p>",
			},
			'suelo': {
				'text': "<p>El suelo del cráter está seco y resquebrajado, en algunas partes hasta pulido y casi vitrificado. En algunos sitios se ven algunos hoyos esféricos, como burbujas secas.</p>\n<p>Definitivamente, algo muy feo le cayó encima a este mundo...</p>",
			},
			'las estrellas': {
				'text': "<p>No hay nada que resulte reconocible en el cielo. Otro mundo, en verdad... pero, curiosamente, no siento temor por estas luces celestes; más bien tranquilidad.</p>",
			},
		},
	},
	'explorar': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe alejo unos cien metros de la cápsula, sin perder de vista su <a class=\"squiffy-link link-passage\" data-passage=\"baliza\" role=\"link\" tabindex=\"0\">baliza</a>, para poder revisar el <a class=\"squiffy-link link-passage\" data-passage=\"terreno\" role=\"link\" tabindex=\"0\">terreno</a> a mi alrededor.</p>\n<p>Las <a class=\"squiffy-link link-passage\" data-passage=\"rocas\" role=\"link\" tabindex=\"0\">rocas</a> a mi alrededor parecen ser más frecuentes según me alejo de la cápsula.</p>\n<p>Hay <a class=\"squiffy-link link-passage\" data-passage=\"trozo capsula\" role=\"link\" tabindex=\"0\">algo blanco</a> en el suelo aquí cerca.</p>\n<p>No logro ver mucho más en la oscuridad y no quisiera esperar a que amanezca en este descampado, así que debo decidir cómo salir del cráter; puedo avanzar <a class=\"squiffy-link link-section\" data-section=\"lentamente\" role=\"link\" tabindex=\"0\">lentamente</a>, a cubierto entre las rocas o moverme más <a class=\"squiffy-link link-section\" data-section=\"rapidamente\" role=\"link\" tabindex=\"0\">rápido</a>, a campo traviesa.</p>",
		'passages': {
			'baliza': {
				'text': "<p>La luz automática de la baliza de la cápsula, parpadeando en rojo, amarillo y blanco, se distingue sin problemas en la oscuridad. </p>",
			},
			'terreno': {
				'text': "<p>El suelo del cráter está seco y resquebrajado, en algunas partes hasta pulido y casi vitrificado; al tacto casi parece vidrio.</p>\n<p>En algunos sitios se ven algunos hoyos esféricos, como burbujas  de piedra reventadas por el calor.</p>\n<p>La verdad, en la penumbra no se puede ver mucho más, pero está claro que aquí golpeó algo mucho más grande que la cápsula.</p>",
			},
			'rocas': {
				'text': "<p>El suelo se ve... diferente cerca de las rocas, pero con esta luz no distingo demasiados detalles y, la verdad, no quiero alejarme mucho de la cápsula.</p>",
			},
			'trozo capsula': {
				'text': "<p>Me acerco y veo que es un trozo de la cápsula, doblado por el calor y chamuscado en los bordes; parte del escudo de reingreso, sin duda.</p>\n<p>Intento doblarlo un poco pero se deshace en mis manos.</p>\n<p>Miro los pequeños restos que caen al suelo y no puedo sino estar agradecido de haber salido caminando de este desastre...</p>",
				'attributes': ["visto_trozo_capsula"],
			},
		},
	},
	'lentamente': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nHe caminado un par de kilómetros cuando el sol aparece en el horizonte, que comienza a tomar color a medida que la estrella <i>verde</i> sube al cielo.</p>\n<p><i>¡Violeta!</i> El cielo es de un hermoso color violeta, suave y aterciopelado. Las nubes, de colores rojo y escarlata, flotan suavemente aquí y allá.</p>\n<p>Entre las nubes hay... algo más, como formas <i>enormes</i>, parecidas a <a class=\"squiffy-link link-passage\" data-passage=\"globos\" role=\"link\" tabindex=\"0\">globos</a>.</p>\n<p>Quedo tan embobado con el espectáculo que se me olvida que debo seguir avanzando. Es curioso: todo es nuevo y sin embargo algo hay en el paisaje que me parece familiar...</p>\n<p>A la luz creciente del amanecer puedo ver con un poco más de detalle; lo que yo creía que eran rocas en realidad son <a class=\"squiffy-link link-passage\" data-passage=\"fragmentos\" role=\"link\" tabindex=\"0\">fragmentos</a>... que no parecen naturales. De hecho, se vuelven más escasos a medida que me acerco al borde del cráter, lo que confirma mi idea inicial de que esto no es de origen natural.</p>\n<p>Cuidando permanecer oculto, apuro el paso y sigo avanzando hasta llegar al <a class=\"squiffy-link link-section\" data-section=\"borde del crater\" role=\"link\" tabindex=\"0\">borde del cráter</a>.</p>",
		'passages': {
			'globos': {
				'text': "<p>Sean lo que sean esos globos, son grandes y redondos, translúcidos y de una apariencia etérea. No están quietos, pero se mueven en forma casi imperceptible, a veces atravesando las nubes, otras veces rodeándolas y consumiéndolas lentamente...</p>",
				'attributes': ["visto_flotadores"],
			},
			'fragmentos': {
				'text': "<p>Examinándolos de cerca, parecen estar incrustados en el suelo, el que se transparenta en su contacto y permite ver formas difusas bajo su superficie reseca.</p>\n<p>Algunos fragmentos son grandes, y se parecen a partes de un fuselaje de una astronave; otros, más pequeños, parecen afilados dientes, saliendo del suelo en ángulos extraños.</p>\n<p>Por lo visto otros viajeros que se acercaron a este mundo también corrieron nuestra suerte, pero en estos despojos no se distingue ningún detalle que permita inferir de dónde venían.</p>",
				'attributes': ["visto_fragmentos"],
			},
		},
	},
	'rapidamente': {
		'text': "<p>He caminado un par de kilómetros cuando el sol aparece en el horizonte, que comienza a tomar color a medida que la estrella, de color verde, sube a un cielo de un raro color violeta.</p>\n<p>A la luz creciente del amanecer puedo ver con un poco más de detalle; las rocas más bien parecen fragmentos más escasos a medida que me acerco al borde del cráter. De acercarme a ellos vería más detalles, pero llevo prisa.</p>\n<p>Es curioso: todo es nuevo y sin embargo algo hay en el paisaje que me parece familiar...</p>\n<p>Siguiendo paso vivo, sigo avanzando y pronto llego al <a class=\"squiffy-link link-section\" data-section=\"borde del crater\" role=\"link\" tabindex=\"0\">borde del cráter</a>.</p>",
		'passages': {
		},
	},
	'borde del crater': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nDesde los escarpados lindes del cráter contemplo por fin en su plenitud la desolación que está contenida dentro de sus límites.</p>\n<p>No se vé vegetación alguna por todo este extenso erial, aunque a algunos cientos de metros de su borde se distinguen algunas... eh... <a class=\"squiffy-link link-passage\" data-passage=\"plantas\" role=\"link\" tabindex=\"0\">plantas</a>, creo.</p>\n<p>Con el sol un poco más en lo alto, el aire vibra sobre el suelo del cráter e incluso parece que en algunos sitios el sol se reflejara sobre su resquebrajada superficie, deslumbrándome y haciendo difícil distinguir detalle alguno... aunque la <a class=\"squiffy-link link-passage\" data-passage=\"baliza\" role=\"link\" tabindex=\"0\">baliza</a> de la cápsula se ve claramente.</p>\n<p>Es la única baliza a la vista.</p>\n<p>No vislumbro nada que no forme parte del cráter; ni siquiera una columna de humo... nada.</p>\n<p>Soy, de momento, el único superviviente.</p>\n<p>Bueno... empieza a hacer calor y por lo pronto hay que seguir viviendo: necesito encontrar refugio, comida y agua. Puedo intentar <a class=\"squiffy-link link-section\" data-section=\"rodear el crater\" role=\"link\" tabindex=\"0\">rodear el cráter</a> para ver si cambia el paisaje, o bien, directamente <a class=\"squiffy-link link-section\" data-section=\"cazadores\" role=\"link\" tabindex=\"0\">dirigirme a la espesura</a>.</p>",
		'passages': {
			'plantas': {
				'text': "<p>Se ven arbustos y pastos, pero de unas formas que apenas recuerdan a vegetales. Los colores no ayudan mucho: azul, magenta, anaranjado, celeste.</p>\n<p>Y de nuevo esta curiosa sensación de familiaridad...</p>",
			},
			'baliza': {
				'text': "<p>La luz automática de la baliza de la cápsula, parpadeando en rojo, amarillo y blanco, se distingue sin problemas, pese a la hora y la resolana.</p>",
			},
		},
	},
	'rodear el crater': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCamino a paso vivo, alejándome hacia el... ¿Norte, Sur? No tengo manera de saberlo.</p>\n<p>Por más que avanzo, el paisaje sigue igual; a veces las plantas están un poco más cerca o más lejos del borde del cráter, pero la vegetación en sí no cambia mayormente.</p>\n<p>Me detengo un momento para tomarme un respiro y cuando me dispongo a reanudar el camino noto <a class=\"squiffy-link link-passage\" data-passage=\"algo diferente\" role=\"link\" tabindex=\"0\">algo diferente</a> más adelante.</p>\n<p>Bueno, puedo <a class=\"squiffy-link link-section\" data-section=\"sendero\" role=\"link\" tabindex=\"0\">continuar adelante</a> y ver qué descubro o dejarlo e <a class=\"squiffy-link link-section\" data-section=\"cazadores\" role=\"link\" tabindex=\"0\">internarme en la espesura</a>.</p>",
		'passages': {
			'algo diferente': {
				'text': "<p>Haciendo sombra, me parece distinguir un sendero que penetra entre las plantas.</p>",
			},
		},
	},
	'sendero': {
		'text': "<p>Se trata de un terreno seco y pisoteado, que se adentra entre las plantas, con unos como <a class=\"squiffy-link link-passage\" data-passage=\"pastos\" role=\"link\" tabindex=\"0\">pastos</a> altos a lado y lado.</p>\n<p>Decido que si quiero avanzar rápido este... ¿sendero? es mi mejor opción, así que comienzo a recorrerlo.</p>\n<p>Según avanzo, noto a ratos un <a class=\"squiffy-link link-passage\" data-passage=\"olor\" role=\"link\" tabindex=\"0\">olor</a> que va y viene... y que no me gusta, no sé por qué, así que apuro el paso.</p>\n<p>Llevo recorrido como un kilómetro cuando me topo de bruces con... bueno, <a class=\"squiffy-link link-section\" data-section=\"primer contacto\" role=\"link\" tabindex=\"0\">los nativos</a>, creo.</p>",
		'attributes': ["puntaje+=1","puntaje_Naufragio+=1"],
		'passages': {
			'pastos': {
				'text': "<p>La luz se mueve en el pasto en oleadas sinuosas: azul, celeste, calipso... Nunca había visto plantas como estas, pero la sensación es casi como si estuviera en un sueño. Más miro el pasto y más siento algo como un vago recuerdo.</p>",
			},
			'olor': {
				'text': "<p>Es un almizcle entre dulzón y cálido. No entiendo por qué, pero es un olor que me inspira miedo.</p>",
			},
		},
	},
	'cazadores': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLlego sin problemas hasta las plantas y comienzo a moverme entre unos pastos altos. La luz del sol crea <a class=\"squiffy-link link-passage\" data-passage=\"reflejos\" role=\"link\" tabindex=\"0\">reflejos</a> en el pasto, mecido por el viento.</p>\n<p>A poco andar siento que me falta el aire; aún no termino de acostumbrarme a esta atmósfera, así que respiro <a class=\"squiffy-link link-passage\" data-passage=\"aroma pasto\" role=\"link\" tabindex=\"0\">hondo</a>.</p>\n<p>Más recuperado me dispongo a avanzar, cuando de pronto escucho un silbido agudo, parecido al siseo de una serpiente.</p>\n<p>Me quedo completamente inmóvil{if seen manualmente: y activo la pistola de señales, que espero me sirva de algo}; ese ruido no fue el pasto movido por el aire.</p>\n<p>Un <a class=\"squiffy-link link-passage\" data-passage=\"olor nuevo\" role=\"link\" tabindex=\"0\">olor nuevo</a> llega a mi nariz... y no me gusta.</p>\n<p>No pienso quedarme sentado, así que puedo <a class=\"squiffy-link link-section\" data-section=\"sigilosamente\" role=\"link\" tabindex=\"0\">intentar avanzar sigilosamente</a>, <a class=\"squiffy-link link-section\" data-section=\"correr\" role=\"link\" tabindex=\"0\">salir corriendo</a> o {if seen manualmente:aprontar la pistola}{else:tentar mi suerte, sin armas} y {if seen manualmente:<a class=\"squiffy-link link-section\" data-section=\"luchar\" role=\"link\" tabindex=\"0\">luchar</a>}{else:<a class=\"squiffy-link link-section\" data-section=\"ataque del Cazador\" role=\"link\" tabindex=\"0\">luchar</a>}.</p>",
		'passages': {
			'reflejos': {
				'text': "<p>La luz se mueve en el pasto en oleadas sinuosas: azul, celeste, calipso... como si fuera un sueño, o un vago recuerdo.</p>",
			},
			'aroma pasto': {
				'text': "<p>Mi nariz se llena del olor del pasto, un aroma agrio y ácido.  No entiendo por qué, pero es un olor reconfortante.</p>\n<p>Me pregunto, qué gusto tendrán estas plantas...</p>",
			},
			'olor nuevo': {
				'text': "<p>Es un almizcle entre dulzón y cálido. No entiendo por qué, pero es un olor que me inspira miedo.</p>",
			},
		},
	},
	'sigilosamente': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe muevo lentamente, un paso tentativo a la vez, abriendo los pastos con mucho cuidado.</p>\n<p>No vuelvo a escuchar el ruido de pasos... pero el olor permanece en el ambiente.</p>\n<p>Lo que sea, no está demasiado lejos.</p>\n<p>Avanzo así por algunos minutos hasta que, de pronto, me percato de que <a class=\"squiffy-link link-section\" data-section=\"primer contacto\" role=\"link\" tabindex=\"0\">ya no estoy solo</a>.</p>",
		'attributes': ["puntaje+=1","puntaje_Naufragio+=1"],
		'passages': {
		},
	},
	'correr': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe lanzo hacia adelante, pero antes de dar diez pasos algo increíblemente rápido y pesado pasa a escasos centímetros míos, dándome un empujón que me derriba y me deja tirado en el suelo.</p>\n<p>Aunque estoy ileso, me pongo de pie con dificultad y escucho que el ruido de pasos cesa bruscamente algunos metros detrás de mí.</p>\n<p>Está visto que no voy a esquivarlo corriendo, así que es una de dos: puedo intentar <a class=\"squiffy-link link-section\" data-section=\"sigilosamente\" role=\"link\" tabindex=\"0\">moverme en silencio</a> o {if seen manualmente:aguantar a pie firme pistola en mano}{else:tentar mi suerte, desarmado como estoy} y {if seen manualmente:<a class=\"squiffy-link link-section\" data-section=\"luchar\" role=\"link\" tabindex=\"0\">luchar</a>}{else:<a class=\"squiffy-link link-section\" data-section=\"ataque del Cazador\" role=\"link\" tabindex=\"0\">luchar</a>}.</p>",
		'attributes': ["visto_cazadores"],
		'passages': {
		},
	},
	'ataque del Cazador': {
		'text': "<p>No tengo que esperar demasiado. Algo surge de entre el pasto y me golpea, antes de que pueda distinguir nada, abriéndome una fea herida en el costado.</p>\n<p>Desesperado, intento levantarme pero el dolor me derrota y quedo tendido.</p>\n<p>Me doy vuelta para intentar arrastrarme... y de pronto noto que <a class=\"squiffy-link link-section\" data-section=\"primer contacto\" role=\"link\" tabindex=\"0\">ya no estoy solo</a>.</p>",
		'attributes': ["visto_cazadores"],
		'passages': {
		},
	},
	'luchar': {
		'text': "<p>Un ruido pesado de pasos se acerca a la carrera, así que levanto la pistola y disparo una bengala en dirección del ruido.</p>\n<p>La luz roja avanza como cohete entre los pastos y da de lleno en algo que da un chillido y se aleja corriendo.</p>\n<p>Me levanto, algo más tranquilo... y de pronto noto que <a class=\"squiffy-link link-section\" data-section=\"primer contacto\" role=\"link\" tabindex=\"0\">ya no estoy solo</a>.</p>",
		'attributes': ["puntaje+=1","puntaje_Naufragio+=1","visto_cazadores"],
		'passages': {
		},
	},
	'primer contacto': {
		'clear': true,
		'text': "<p>{if puntaje=2: {@puntaje_memoria-=1}}\n{if puntaje=1: {@puntaje_memoria-=1}}\n{if puntaje=0: {@puntaje_memoria-=1}}\n{PUNTAJE}\nSon cinco individuos <a class=\"squiffy-link link-passage\" data-passage=\"hominidos\" role=\"link\" tabindex=\"0\">vagamente homínidos</a> y no llevan <a class=\"squiffy-link link-passage\" data-passage=\"nada puesto\" role=\"link\" tabindex=\"0\">nada puesto</a>. {if seen sendero: Por lo que veo, estaban ocupados recogiendo pasto, pero en cuanto me ven llegar lo dejan y m}{else:M}e rodean completamente en silencio, algunos de pie y otros en cuclillas.</p>\n<p>Nadie hace ningún gesto, pero no apartan sus <a class=\"squiffy-link link-passage\" data-passage=\"ojos\" role=\"link\" tabindex=\"0\">ojos</a> de mí en ningún instante.</p>\n<p>Debiera estar asustado, pero en cambio siento alivio y calma.</p>\n<p>{if seen ataque del Cazador:Intento moverme, pero el dolor me derrumba y doy un quejido, lo que atrae sus miradas a mi herida.}</p>\n<p>Uno de ellos, de piel más clara que el resto, dice... algo, en una voz musical y muy queda. Por unos instantes, los demás se vuelven a ¿él, ella? y le... ¿cantan, le hablan cantando? No lo sé...\n{if seen ataque del Cazador:\nLa vista se me nubla...}</p>\n<p>Alcanzo a distinguir al de piel clara alejándose y metiendo mucho ruido entre los pastos.</p>\n<p>¡Un silbido a lo lejos!</p>\n<p>{if seen ataque del Cazador:Los demás, me toman entre todos y me llevan en andas...</p>\n<p>...y ya no veo <a class=\"squiffy-link link-section\" data-section=\"Leyenda del Viajero\" role=\"link\" tabindex=\"0\">nada más</a>.}\n{else:Los demás, me rodean entre todos y me empujan, corriendo, hasta que salimos de los pastos.</p>\n<p>A lo lejos, creo ver <a class=\"squiffy-link link-section\" data-section=\"Leyenda del Viajero\" role=\"link\" tabindex=\"0\">unas chozas</a>...}</p>",
		'attributes': ["puntaje_memoria+=1"],
		'passages': {
			'hominidos': {
				'text': "<p>Tienen  miembros delgados y largos. No tienen pelo ni vello corporal alguno a la vista y la piel es de color celeste, casi transparente; no parecen tener órganos internos.</p>",
			},
			'nada puesto': {
				'text': "<p>Nada a la vista me permite saber si son hombres, mujeres, jóvenes, viejos o qué.</p>",
			},
			'ojos': {
				'text': "<p>Los ojos son redondos, completamente negros. Si tienen iris o pupila, no puedo distinguirlo.</p>\n<!-- Interludio Leyenda del Viajero -->",
			},
		},
	},
	'Leyenda del Viajero': {
		'clear': true,
		'text': "<font face=\"papyrus\" color=\"darkblue\"><b><blockquote>\nUn día, con un gran estruendo,<br>\nLlegó hasta nosotros El Viajero<br>\nDescendió del cielo,<br>\nen el mismo lugar que El Protector.<br>\n<br>\nSu llegada fue imprevista,<br>\ny su periplo hasta La Gente<br>\n{if seen ataque del Cazador:fue accidentado y doloroso,}\n{else: fue seguro y prudente,}<br>\n{if seen sendero: aunque no conocía }\n{else: pues pronto encontró }a los Cazadores.<br>\n<br>\nEl Viajero era diferente a El Protector<br>\nEl Viajero era diferente a los Cazadores<br>\nEl Viajero era diferente a La Gente<br>\npues El Viajero no pertenecía a la Memoria\n{if puntaje_memoria&gt;0:<br>aunque parecía tener Recuerdos propios}.<br>\n<br>\nY La Gente esperó<br>\npara ver lo que haría <a class=\"squiffy-link link-section\" data-section=\"Parte II\" role=\"link\" tabindex=\"0\">El Viajero</a>...\n</blockquote></b></font>\n\n\n\n<!-- Parte II La Aldea -->\n<!-- Max Puntaje Memoria: 2 -->",
		'attributes': ["puntaje =0"],
		'passages': {
		},
	},
	'Parte II': {
		'clear': true,
		'text': "<p><font color=\"white\"></p>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"34%\" style=\"background-color:black;text-align:center;font-family:courier;\"><b><br>\nParte II<br>\n<br>\nLa Aldea<br>\n<br></b></td>\n<td width=\"33%\"></td>\n</tr></table>\n</font>\n<br><br>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"33%\"></td>\n<td width=\"33%\" style=\"text-align:right;\"><a class=\"squiffy-link link-section\" data-section=\"Tienda\" role=\"link\" tabindex=\"0\">Continuar</a></td>\n</tr></table>",
		'passages': {
		},
	},
	'Tienda': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nDespierto  con la luz de la mañana, filtrándose entre las <a class=\"squiffy-link link-passage\" data-passage=\"rendijas\" role=\"link\" tabindex=\"0\">rendijas</a> de mi <a class=\"squiffy-link link-passage\" data-passage=\"tienda\" role=\"link\" tabindex=\"0\">tienda</a>.</p>\n<p>Me he acostumbrado por fin a los ciclos de luz de este mundo y ya no necesito que me despierten; según mi <a class=\"squiffy-link link-passage\" data-passage=\"reloj\" role=\"link\" tabindex=\"0\">reloj</a>, me ha hecho falta casi un año (tiempo de la Tierra, claro) para conseguirlo... pero la verdad a mí no me lo parece; viviendo con La Gente, el tiempo pasa de una manera dulce, casi imperceptible.</p>\n<p>No tengo ninguna preocupación por esto del Naufragio; más bien siento que estoy como de vacaciones en casa de mis padres y que todo va bien. </p>\n<p>Bueno, no del todo: la <a class=\"squiffy-link link-passage\" data-passage=\"esterilla\" role=\"link\" tabindex=\"0\">esterilla</a> en la que estoy recostado está demasiado tibia y mi estómago me gruñe para recordarme que es <a class=\"squiffy-link link-section\" data-section=\"desayunar\" role=\"link\" tabindex=\"0\">hora de desayunar</a>, por mucho que se imponga <a class=\"squiffy-link link-section\" data-section=\"aseo\" role=\"link\" tabindex=\"0\">hacer el aseo</a> antes.</p>",
		'attributes': ["seccion=Aldea"],
		'passages': {
			'rendijas': {
				'text': "<p>La Gente es muy delicada y no han hecho observaciones de lo poco... diestro de mi trabajo de tejido. Por más que los observo, aún no puedo trenzar pasto como ellos y mi tienda es evidencia de ello.</p>",
			},
			'tienda': {
				'text': "<p>La tienda está hecha de una sola pieza o manta, tejida con pasto más bien basto y sin tratar; es bastante rígida y se tiene en pie sin mayor soporte.</p>",
			},
			'reloj': {
				'text': "<p>Mi reloj está implantado subcutáneamente y registrará la hora, tiempo terrestre, hasta que muera. A La Gente le ha asustado un poco la primera vez que lo vieron, pero ya se han acostumbrado a que, de improviso, salgan letras y números en mi muñeca.</p>",
			},
			'esterilla': {
				'text': "<p>La he tejido con pasto y me sirve bien como cama, aunque no es demasiado mullida. En este momento lleva varios días sin asearse y ya hace falta sacudirla un poco.</p>",
			},
		},
	},
	'aseo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCon cuidado, hago un rollo con la esterilla y salgo de la tienda, cuidando de dejarla entre abierta para que ventile.</p>\n<p>Como siempre, escucho el ajetreo de la mañana a unos cuantos pasos, entre las tiendas y un poco más allá.</p>\n<p>Mi tienda está algo apartada de las demás; en la aldea aún no se acostumbran a mi olor y si bien La Gente es <a class=\"squiffy-link link-passage\" data-passage=\"modales\" role=\"link\" tabindex=\"0\">muy fina</a> como para decírmelo, creo que mi &quot;aroma personal&quot; les desagrada un poco. He optado, pues, por mejorar la convivencia y dejarles, al menos, dormir sin interrumpir su sueño con mis, ejem, efluvios... para no hablar de evacuar mis <a class=\"squiffy-link link-passage\" data-passage=\"necesidades\" role=\"link\" tabindex=\"0\">necesidades</a>, que es casi un ritual personal.</p>\n<p>Podría <a class=\"squiffy-link link-section\" data-section=\"sacudirla\" role=\"link\" tabindex=\"0\">sacudir la esterilla aquí mismo</a>... o buscar un lugar más alejado de la aldea y dejarlo para <a class=\"squiffy-link link-section\" data-section=\"desayunar\" role=\"link\" tabindex=\"0\">después del desayuno</a>.</p>",
		'attributes': ["tengo_esterilla"],
		'passages': {
			'modales': {
				'text': "<p>La etiqueta, los buenos modales y la cortesía de La Gente son increíblemente sofisticados. A ratos llega a ser un poco agobiante, pero reconozco que con ello evitan mil y una desavenencias, grandes o pequeñas, en el día a día: se respira una paz <i>casi</i> permanente, vaya.</p>",
			},
			'necesidades': {
				'text': "<p>Ha sido todo un asunto &quot;protocolar&quot; el poder resolver lo de mis necesidades. Lo hago en privado, en lugares más bien discretos y a una distancia casi ridícula de la aldea. Qué le vamos a hacer...</p>",
			},
		},
	},
	'sacudirla': {
		'text': "<p>La verdad, el hambre me está empezando a molestar, así que sacudo sin más la esterilla frente a mi tienda...</p>\n<p>...y esparzo trocitos de mi piel y mi olor todo al rededor. No es de extrañar que esta buena gente no quiera ni acercarse a mi tienda; el lugar es francamente apestoso para ellos.</p>\n<p>Dejo la esterilla dentro de mi tienda y, sintiéndome algo culpable, voy a <a class=\"squiffy-link link-section\" data-section=\"desayunar\" role=\"link\" tabindex=\"0\">desayunar</a>.</p>",
		'attributes': ["not tengo_esterilla"],
		'passages': {
		},
	},
	'desayunar': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen aseo:\n{if tengo_esterilla:Llevando la esterilla bajo el brazo, me}{else:Con lo del aseo ya resuelto, me}\n}\n{else:Me} dirijo a paso vivo a buscar algo para desayunar, avanzando <a class=\"squiffy-link link-passage\" data-passage=\"con cuidado\" role=\"link\" tabindex=\"0\">con cuidado</a> entre las tiendas.</p>\n<p>Como ya despuntó el alba, en el <a class=\"squiffy-link link-passage\" data-passage=\"circulo\" role=\"link\" tabindex=\"0\">círculo</a> del desayuno sólo quedan algunos <a class=\"squiffy-link link-passage\" data-passage=\"ancianos\" role=\"link\" tabindex=\"0\">ancianos</a> cuidando de <a class=\"squiffy-link link-passage\" data-passage=\"niños\" role=\"link\" tabindex=\"0\">niños</a> pequeños que mastican su pasto medio dormidos.</p>\n<p>Tomo asiento en un lugar libre{if tengo_esterilla:, usando la esterilla de cojín} y después de <a class=\"squiffy-link link-passage\" data-passage=\"saludar\" role=\"link\" tabindex=\"0\">saludar</a> cortésmente (que demora lo suyo) hago la pregunta que sólo los niños pequeños hacen en esta circunstancia: &quot;¿Qué tenemos hoy para comer en la mañana, Mayores?&quot;</p>\n<p>Al oír esto, todos fijan la vista en mí y <a class=\"squiffy-link link-passage\" data-passage=\"rien\" role=\"link\" tabindex=\"0\">fruncen el ceño</a>. Uno de los niños, pobrecito, se tapa el rostro, que se le ha vuelto <a class=\"squiffy-link link-passage\" data-passage=\"sonrojo\" role=\"link\" tabindex=\"0\">casi morado</a>.</p>\n<p>Tratando de parecer serio, <a class=\"squiffy-link link-passage\" data-passage=\"uno de los ancianos\" role=\"link\" tabindex=\"0\">uno de los ancianos</a> me invita a que me acerque al centro y me sirva yo mismo de los <a class=\"squiffy-link link-section\" data-section=\"alimentos\" role=\"link\" tabindex=\"0\">alimentos dispuestos</a>.</p>",
		'passages': {
			'con cuidado': {
				'text': "<p>Mientras no pases a llevar sus tiendas y andes procurando no tropezar, a La Gente no le molesta que camines cerca de sus tiendas, día o noche.</p>",
			},
			'circulo': {
				'text': "<p>Las comidas, las conversaciones, el trabajo... todo salvo lo estrictamente íntimo La Gente lo hace en círculos: sentados o de pie, en familia o en grupos tan amplios como la ocasión lo amerite.</p>\n<p>Entiendo que los círculos de la aldea completa son ocasiones solemnes, aunque no he presenciado ningún círculo a la fecha y no sé cómo o por qué se convocan.</p>",
				'attributes': ["visto_circulo"],
			},
			'ancianos': {
				'text': "<p>Me costó su tiempo entenderlo, pero la piel de La Gente, conforme se hace mayor, se vuelve más lisa y translúcida. Los ancianos tienen, pues, una apariencia más bien etérea... y los decanos de la aldea son poco menos que transparentes.</p>",
			},
			'niños': {
				'text': "<p>Como en todas partes, los niños de La Gente son dulces, bulliciosos e inquietos. Su piel es de un color intenso y más bien arrugada; entre La Gente, el fin de la infancia lo marca, precisamente, la desaparición de la última &quot;arruga de la irresponsabilidad&quot;.</p>",
			},
			'saludar': {
				'text': "<p>Me toma su rato: saludo, respuesta, contrarrespuesta... ajustando el tono de voz y la deferencia debida según la edad de cada uno. No hay más de diez personas entre ancianos y niños, pero han pasado diez minutos o así en esto de decir &quot;Buenos días&quot;.</p>",
				'attributes': ["visto_saludo"],
			},
			'rien': {
				'text': "<p>Se están riendo. No vean la de malentendidos que me causó <i>no</i> entender este tipo de cosas al principio.</p>",
				'attributes': ["visto_risa"],
			},
			'sonrojo': {
				'text': "<p>El crío se ha sonrojado de risa.</p>",
			},
			'uno de los ancianos': {
				'text': "<p>Su piel es extremadamente lisa, por lo que entiendo que es el más anciano de cuantos viven en la aldea: el Decano de La Gente, al que incluso los demás ancianos tratan con mucha deferencia.</p>",
				'attributes': ["visto_Mayor"],
			},
		},
	},
	'alimentos': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAl centro hay unas enormes <a class=\"squiffy-link link-passage\" data-passage=\"vainas\" role=\"link\" tabindex=\"0\">vainas secas</a>, con <a class=\"squiffy-link link-passage\" data-passage=\"pasto fresco\" role=\"link\" tabindex=\"0\">pasto fresco</a> de distinto largo y grosor, para el gusto y la edad de cada comensal. Además, hay una pequeña <a class=\"squiffy-link link-passage\" data-passage=\"escudilla\" role=\"link\" tabindex=\"0\">escudilla</a> con semillas: una cortesía que algún aldeano anónimo ha tenido conmigo, sin duda, pues no es parte del menú habitual de La Gente.</p>\n<p>Los niños están comiendo pasto como si les fuera la vida en ello: engullen hojas de hasta un metro de largo en cuestión de segundos; los ancianos, con menos ansia y más dignidad, mastican con calma su comida, y de vez en cuando les hacen alguna reconvención en voz baja a los niños, que comen más despacio, al menos por unos <a class=\"squiffy-link link-passage\" data-passage=\"educacion\" role=\"link\" tabindex=\"0\">breves momentos</a>.</p>\n<p>Tengo pues para comer <a class=\"squiffy-link link-section\" data-section=\"comer pasto\" role=\"link\" tabindex=\"0\">el pasto de siempre</a> o <a class=\"squiffy-link link-section\" data-section=\"comer semillas\" role=\"link\" tabindex=\"0\">las semillas</a>, para variar un poco.</p>",
		'passages': {
			'vainas': {
				'text': "<p>Son vainas de alguna planta que crece muy lejos de la aldea. De color violeta, muy gruesas y rugosas, son usadas por La Gente como fuentes para servir el pasto o para llevar objetos pequeños dentro de la aldea.</p>",
			},
			'pasto fresco': {
				'text': "<p>El pasto grueso y de color azul intenso, que es más bien largo, suele ser el favorito de los niños; los ancianos prefieren un pasto más corto, tierno y pálido. Los adultos, por otra parte, comen según gusto o antojo.</p>",
			},
			'escudilla': {
				'text': "<p>La escudilla no es más que una semilla grande, partida en dos y ahuecada. Como las vainas, son de alguna planta que crece a varios días de camino de la aldea.</p>",
			},
			'educacion': {
				'text': "<p>Dice La Gente que basta una pareja para tener y criar un niño, pero hace falta de la aldea <i>completa</i> para educarlo.</p>\n<p>No les falta razón...</p>",
			},
		},
	},
	'comer pasto': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nPara no perder la costumbre, cojo un poco de pasto, hago un rollito con una hoja (ante las miradas divertidas y apenas disimuladas de los niños) y me lo meto a la boca.</p>\n<p>Vaya si es amargo: incluso el pasto tierno me toma su rato el comerlo, así que ya casi me da lo mismo coger pasto tierno o pasto más duro, porque igual acabo rumiando no menos de tres minutos por <i>cualquier</i> bocado antes de poder tragarlo.</p>\n<p>Lo bueno del pasto es que te deja saciado y sin sed... pero al poco rato <a class=\"squiffy-link link-passage\" data-passage=\"comidas\" role=\"link\" tabindex=\"0\">ya tienes hambre de nuevo</a>.</p>\n<p>{if tengo_esterilla:\n{tejido esterilla} \n}{else:\n{finalizar desayuno}\n}</p>",
		'passages': {
			'comidas': {
				'text': "<p>Los hábitos de alimentación de La Gente se han ajustado a esta dieta; salvo en la mañana y al atardecer, todo el mundo come cuando y cuanto puede.</p>\n<p>A nadie se le ocurriría ofenderse por ello.</p>",
			},
		},
	},
	'comer semillas': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nDe buena gana, cojo un puñado de semillas y me las voy echando a la boca de una en una, ante la mirada interesada de ancianos y niños.</p>\n<p>Nadie más que yo come esto y sin embargo La Gente lo ha incorporado en sus costumbres de forrajeo, por lo que no suele faltarme: es una comida muy satisfactoria y puedo pasar medio día afanándome sin necesitar otro sustento...</p>\n<p>...salvo algo de pasto para saciar la sed, claro.</p>\n<p>No soy químico ni nutricionista, pero entre el pasto y las semillas no echo en falta nada de menos en <a class=\"squiffy-link link-passage\" data-passage=\"regimen\" role=\"link\" tabindex=\"0\">mi alimentación</a>.</p>\n<p>{if tengo_esterilla:\n{tejido esterilla} \n}{else:\n{finalizar desayuno}\n}</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
			'regimen': {
				'text': "<p>Es un régimen alimenticio sencillo y algo tedioso, pero la verdad es que si bien he adelgazado mucho, no me he enfermado ni he notado debilidad alguna con esta &quot;dieta&quot;.</p>\n<p>Trajino y me afano no poco en la aldea y nunca me he sentido desnutrido o decaído.</p>",
			},
		},
	},
	'finalizar desayuno': {
		'text': "<p>Momentos más tarde, ya he terminado de desayunar. Podría, pues, ayudar con la <a class=\"squiffy-link link-section\" data-section=\"cosecha diaria\" role=\"link\" tabindex=\"0\">cosecha diaria</a> de pastos... o bien ocuparme ahora de mi <a class=\"squiffy-link link-section\" data-section=\"aseo personal\" role=\"link\" tabindex=\"0\">aseo personal</a>, antes de que mi olor comience a molestar a más Gente.</p>",
		'passages': {
		},
	},
	'tejido esterilla': {
		'text': "<p>Uno de los niños está mirando con auténtica fijación la esterilla sobre la que estoy sentado, al punto que incluso ha dejado de comer; entiendo <i>casi</i> todo el lenguaje corporal de La Gente y estoy <i>seguro</i> de que el chico desea preguntarme algo, pero titubea y mira al anciano que tiene cerca una y otra vez.</p>\n<p>Aunque el anciano no ha juzgado cortés el importunarme, podría <a class=\"squiffy-link link-section\" data-section=\"curiosidad\" role=\"link\" tabindex=\"0\">atender la curiosidad del niño</a>... o bien finalizar mi desayuno y <a class=\"squiffy-link link-section\" data-section=\"aseo personal\" role=\"link\" tabindex=\"0\">seguir con el aseo</a>, antes de que el olor de veras comience a molestar a más Gente.</p>",
		'passages': {
		},
	},
	'curiosidad': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nTermino de masticar y tragar mi bocado y con lentitud extiendo mi brazo con la palma hacia arriba, indicando mi disposición a recibir una pregunta personal.</p>\n<p>El chico se <a class=\"squiffy-link link-passage\" data-passage=\"aclara la garganta\" role=\"link\" tabindex=\"0\">aclara la garganta</a> y me pregunta, hablando <a class=\"squiffy-link link-passage\" data-passage=\"lentamente\" role=\"link\" tabindex=\"0\">lentamente</a>: &quot;Viajero ¿Por qué tu tejido dice lo mismo una y otra vez?&quot;</p>\n<p>El anciano que estaba cerca del niño me mira atentamente; de hecho, <i>todos</i> dejan de comer y se hace un silencio muy educado (aunque algo incómodo, para mí) en espera de la respuesta.</p>\n<p>&quot;De donde yo vengo&quot;, le respondo, &quot;no nos han enseñado a tejer en la lengua de La Gente. Espero no haber ofendido a nadie con un tejido tan... <a class=\"squiffy-link link-passage\" data-passage=\"monotono\" role=\"link\" tabindex=\"0\">monótono</a>.&quot;</p>\n<p>El niño <a class=\"squiffy-link link-passage\" data-passage=\"agita las manos\" role=\"link\" tabindex=\"0\">agita las manos</a> y se sienta al lado del anciano que tenía cerca. El {if visto_Mayor:Mayor}{else:<a class=\"squiffy-link link-passage\" data-passage=\"Mayor\" role=\"link\" tabindex=\"0\">Mayor</a>} se dirige a todos, diciendo &quot;El Viajero está aprendiendo de La Gente, pero no ha vivido con ellos mucho tiempo aún.&quot; Luego, se dirige a mí diciendo &quot;Cuando quieras aprender a tejer tu Memoria, puedes pedir ayuda a los Mayores.&quot;</p>\n<p><i><b><a class=\"squiffy-link link-section\" data-section=\"Memoria\" role=\"link\" tabindex=\"0\">Memoria</a></b></i>...</p>",
		'passages': {
			'aclara la garganta': {
				'text': "<p>Es como el gorjeo de un ave pequeña: breve y deliciosamente musical.</p>",
			},
			'lentamente': {
				'text': "<p>Es una deferencia muy cortés; aún me cuesta entender a La Gente cuando hablan a velocidad normal.</p>",
			},
			'agita las manos': {
				'text': "<p>Está denegando sin ofensa.</p>",
			},
			'monotono': {
				'text': "<p>La esterilla, efectivamente, está hecha con base en el mismo nudo, repetido una y otra vez...</p>",
			},
			'Mayor': {
				'text': "<p>Su piel es extremadamente lisa, por lo que entiendo que es el más anciano de cuantos viven en la aldea: el Decano de La Gente, al que incluso los demás ancianos tratan con mucha deferencia.</p>",
				'attributes': ["visto_Mayor"],
			},
		},
	},
	'Memoria': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAún no logro entender del todo qué es esto de la Memoria para La Gente: mis primeras aproximaciones han sido accidentales y más bien inquietantes.</p>\n<p>De lo que sí estoy seguro es de que la Memoria forma parte integral de sus tradiciones, es un tema delicado y  no se trata ni se menciona de manera baladí.</p>\n<p>Curiosamente, sin saber realmente de qué trata, algo siempre se agita dentro de mí cuando dicen esta palabra: como recuerdos de un sueño, no lo sé...</p>\n<p>Algo de lo que estoy pensando debe reflejarse en mi rostro; nadie dice nada por unos instantes y noto, algo turbado, que yo también me he quedado mudo.</p>\n<p>Como fuere, es un ofrecimiento muy generoso, por lo que, saliendo de mi estupor, <a class=\"squiffy-link link-passage\" data-passage=\"agradecer\" role=\"link\" tabindex=\"0\">agradezco debidamente</a> y como ya terminé de comer, me despido cortésmente y tomo mi esterilla para  <a class=\"squiffy-link link-section\" data-section=\"aseo personal\" role=\"link\" tabindex=\"0\">terminar con mi aseo</a>.</p>",
		'attributes': ["puntaje_memoria+=1"],
		'passages': {
			'agradecer': {
				'text': "<p>Con lentitud, llevo primero mi mano derecha a mi hombro izquierdo y luego la mano izquierda al hombro derecho.</p>",
			},
		},
	},
	'aseo personal': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen curiosidad:Me}{else:Tras despedirme con la debida cortesía, me} alejo con calma del círculo del desayuno, camino de la periferia de la aldea.</p>\n<p>Casi al salir de la aldea, me encuentro con uno de los aldeanos más <a class=\"squiffy-link link-passage\" data-passage=\"jovenes\" role=\"link\" tabindex=\"0\">jóvenes</a>, sentado frente a una de las tiendas, con una expresión algo ausente y plácida: parece estar contemplando la mañana.</p>\n<p>&quot;¡Qué hermosa y verde que ha amanecido <a class=\"squiffy-link link-passage\" data-passage=\"sol\" role=\"link\" tabindex=\"0\">La Luz</a>!&quot; me dice, a modo de saludo.</p>\n<p>&quot;¡Qué bueno es poder contemplarla en paz!&quot;, le respondo según se estila a esta hora.</p>\n<p>&quot;¿No vas a la cosecha de pasto, Viajero?&quot; pregunta con el {if visto_risa:ceño fruncido}{else:<a class=\"squiffy-link link-passage\" data-passage=\"sonriendo\" role=\"link\" tabindex=\"0\">ceño fruncido</a>}.</p>\n<p>&quot;Hoy es mi día para el aseo, y el pasto huele mejor si el que lo recoge está limpio&quot;, le contesto.</p>\n<p>Al oír esto, se pone de pie y se pone a caminar conmigo, diciendo &quot;¡Te acompaño! Quiero asearme yo también y estar limpio para participar en la cosecha.&quot;</p>\n<p>Como por regla general no es bueno salir solo de la aldea, <a class=\"squiffy-link link-passage\" data-passage=\"agradecer\" role=\"link\" tabindex=\"0\">le agradezco</a> y seguimos camino a la <a class=\"squiffy-link link-section\" data-section=\"playa\" role=\"link\" tabindex=\"0\">playa del Lago Ardiente</a>.</p>",
		'passages': {
			'jovenes': {
				'text': "<p>Los muchachos (y muchachas) de La Gente tienen una piel lisa, sin ninguna arruga infantil, de un color más bien celeste, aún sin la semitransparencia de los adultos.</p>",
			},
			'sol': {
				'text': "<p>Así llaman al sol local: La Luz. Un nombre sencillo y hermoso, muy propio de La Gente.</p>",
			},
			'sonriendo': {
				'text': "<p>Se ve que le causa gracia. No vean la de malentendidos que me causó <i>no</i> entender este tipo de cosas al principio.</p>",
				'attributes': ["visto_risa"],
			},
			'agradecer': {
				'text': "<p>Como vamos caminando, llevo mi mano izquierda al hombro derecho{if tengo_esterilla:: la otra está llevando la esterilla, de cualquier manera}.</p>",
			},
		},
	},
	'playa': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen explorar el cañaveral:\nCon cuidado, me abro paso por entre los juncos y salgo del cañaveral, caminando en breve por la playa.</p>\n<p>Al acercarme, veo que mi acompañante se ha sentado en la arena y contempla absorto el Lago Ardiente.</p>\n<p>No parece haberse percatado de mi regreso, la verdad.</p>\n<p>Bueno, ya es hora de {if tengo_esterilla:<a class=\"squiffy-link link-section\" data-section=\"sacudir la esterilla\" role=\"link\" tabindex=\"0\">sacudir la esterilla</a>, que para eso la traje conmigo}{else:<a class=\"squiffy-link link-section\" data-section=\"asearse\" role=\"link\" tabindex=\"0\">limpiarme un poco</a>}.\n}\n{else:\nLa playa que bordea el <a class=\"squiffy-link link-passage\" data-passage=\"lago\" role=\"link\" tabindex=\"0\">Lago Ardiente</a> es un sitio muy tranquilo: nada parece perturbar su <a class=\"squiffy-link link-passage\" data-passage=\"arena\" role=\"link\" tabindex=\"0\">arena</a> verde y sólo se escucha el ruido del <a class=\"squiffy-link link-passage\" data-passage=\"viento\" role=\"link\" tabindex=\"0\">viento</a>, resonando en el cañaveral de la <a class=\"squiffy-link link-passage\" data-passage=\"cienaga\" role=\"link\" tabindex=\"0\">ciénaga</a> cercana. La vista, en todo caso, es impresionante: un inmenso mar de lodo ardiente, hasta donde alcanza la vista.</p>\n<p>Nada más llegar a la playa, mi acompañante se ha tendido en la arena y, sin mediar palabra, ha empezado a frotarse el cuerpo con la arena de la playa.</p>\n<p>En cuanto a mí y ya que estoy aquí, podría aprovechar de <a class=\"squiffy-link link-section\" data-section=\"explorar el cañaveral\" role=\"link\" tabindex=\"0\">explorar el cañaveral</a>... o bien imitar a mi acompañante{if tengo_esterilla:, empezando por <a class=\"squiffy-link link-section\" data-section=\"sacudir la esterilla\" role=\"link\" tabindex=\"0\">sacudir la esterilla</a>, que para eso la traje conmigo}{else: y <a class=\"squiffy-link link-section\" data-section=\"asearse\" role=\"link\" tabindex=\"0\">limpiarme un poco</a>}.\n}</p>",
		'passages': {
			'lago': {
				'text': "<p>Los Mayores dicen que alguna vez todo el lago era un inmenso mar de lava fundida o &quot;roca  caliente y líquida&quot; como dice La Gente. Ahora, es un enorme lodazal... ardiente; nadie puede cruzarlo o vadearlo sin morir quemado.</p>",
			},
			'viento': {
				'text': "<p>El viento susurra una brisa suave y tranquila, aunque algo tibia.</p>",
			},
			'arena': {
				'text': "<p>La arena es de un hermoso color verde, muy fina, suave y brilla un poco a la luz. Cubre todo el lugar. Donde toma contacto con el lago, la arena parece estar sólida y semitransparente, con un color amarillo encendido.</p>",
			},
			'cienaga': {
				'text': "<p>En la ciénaga el suelo está caliente y, aunque no quema como en el lago, su calor húmedo llega hasta la playa. El lugar está casi totalmente ocupado por un denso cañaveral, formado de juncos morados, altos y fuertes.</p>",
			},
		},
	},
	'explorar el cañaveral': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEn la ciénaga el Lago Ardiente se ha mezclado hace tan largo tiempo ya con la <a class=\"squiffy-link link-passage\" data-passage=\"arena\" role=\"link\" tabindex=\"0\">arena</a> de la playa que el suelo está caliente, aunque no quema. Todo al rededor está casi totalmente ocupado por un denso cañaveral, formado de <a class=\"squiffy-link link-passage\" data-passage=\"juncos\" role=\"link\" tabindex=\"0\">juncos</a> morados, altos y fuertes.</p>\n<p>En general casi nadie viene aquí y es un buen lugar para descansar: ni siquiera los Cazadores se acercan a este lugar.</p>\n<p>La calma del lugar es <a class=\"squiffy-link link-passage\" data-passage=\"absoluta\" role=\"link\" tabindex=\"0\">absoluta</a>.</p>\n<p>La densidad de los juncos es tal que no hay manera de llegar desde aquí al Lago, que apenas se divisa entre las plantas.</p>\n<p>En todo caso, no es el mejor lugar para asearse; para eso, será mejor <a class=\"squiffy-link link-section\" data-section=\"playa\" role=\"link\" tabindex=\"0\">regresar a la playa</a>.</p>",
		'passages': {
			'arena': {
				'text': "<p>La arena se ha mezclado y compactado debido a las raíces de los juncos. Su color verde se ha mezclado con el tono morado de los juncos y apenas quedan granos sueltos.</p>",
			},
			'juncos': {
				'text': "<p>Los juncos del cañaveral son de tonos morados, pasando por el rosa y el violeta. Crecen altos y muy fuertes, firmemente anclados al blando y caliente suelo de la Ciénaga.</p>\n<p>Están muy cerca unos de otros, formando un marjal impenetrable. El lago toca el perímetro de los juncos, aunque a los juncos no parece afectarlos.</p>",
			},
			'absoluta': {
				'text': "<p>Sólo se escucha la voz del viento, hablando en su eterno lenguaje de paz susurrante...</p>",
			},
		},
	},
	'sacudir la esterilla': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCuidando de no molestar a mi acompañante, me acerco lo más que puedo a la orilla del lago y sacudo vigorosamente la esterilla.</p>\n<p>Cualquier partícula de mi piel, pelos, o lo que sea que estuvieran en mi esterilla se los lleva prontamente el viento y aterrizan aquí y allá en la superficie del lago, que las incinera de inmediato; veo algunas chispas que pronto desaparecen en pequeñísimas volutas de humo.</p>\n<p>Esto es sin duda mejor que apestar aun más el lugar en torno a mi tienda... la que algún día también habré de limpiar de esta guisa, seguro.</p>\n<p>{asearse}</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
		},
	},
	'asearse': {
		'text': "<p>{if seen sacudir la esterilla:\nManteniendo las distancias con mi acompañante, }\n{else:\nCuidando de no molestar a mi acompañante, me acerco lo más que puedo a la orilla del lago y }\ntomo un puñado de arena, con el que comienzo a frotar mis piernas.</p>\n<p>Repito la operación con mis brazos, con el torso y con la cara; para la espalda no hay más remedio que tenderme en la arena y arrastrarme lo suficiente para sentir algo de escozor.</p>\n<p>Todo esto hecho, por supuesto frente a la mirada divertida del aldeano, que no pronuncia palabra alguna aunque sigue con la vista cada una de mis cabriolas en la playa.</p>\n<p>Ya debidamente aseado, me siento unos momentos a descansar al lado del muchacho en la orilla y contemplamos juntos el tiempo pasar.</p>\n<p>Al cabo de unos momentos, me pongo de pie y le digo &quot;Voy de regreso a la aldea, para ayudar con la cosecha ¿vienes?&quot;.</p>\n<p>Absorto, me responde &quot;Gracias, pero creo que me quedaré aquí un rato más.&quot;</p>\n<p>Me despido con la debida cortesía y me encamino <a class=\"squiffy-link link-section\" data-section=\"cosecha diaria\" role=\"link\" tabindex=\"0\">de regreso a la aldea</a>.</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
		},
	},
	'cosecha diaria': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen aseo personal:\nSintiéndome renovado tras el aseo, regreso a paso vivo a la aldea y{if tengo_esterilla:, tras dejar la esterilla en mi tienda,}\n}{else:\nCon un buen desayuno en el cuerpo, dejo atrás la aldea y }\nme dirijo a llanura, para colaborar con la cosecha de pasto.</p>\n<p>Al poco andar me adentro en los campos de pastos, un verdadero océano de tallos de varios tonos de <a class=\"squiffy-link link-passage\" data-passage=\"azul\" role=\"link\" tabindex=\"0\">azul</a>. En breve llego a un claro nuevo y en plena formación, donde un {if visto_circulo:círculo}{else:<a class=\"squiffy-link link-passage\" data-passage=\"circulo\" role=\"link\" tabindex=\"0\">círculo</a>} de aldeanos se  ocupan en recolectar pasto que luego han de llevar a la aldea.</p>\n<p>Después de {if visto_saludo:saludar}{else:<a class=\"squiffy-link link-passage\" data-passage=\"saludar\" role=\"link\" tabindex=\"0\">saludar</a>} me dispongo a participar en la cosecha. Puedo empezar por recolectar <a class=\"squiffy-link link-section\" data-section=\"pasto corto\" role=\"link\" tabindex=\"0\">pasto corto</a> o bien coger primero el <a class=\"squiffy-link link-section\" data-section=\"pasto largo\" role=\"link\" tabindex=\"0\">pasto largo</a>.</p>",
		'passages': {
			'azul': {
				'text': "<p>Aún no me acostumbro a los efectos de la luz al moverse en el pasto: se generan ondas de color azul, celeste, calipso...</p>\n<p>La Gente, por supuesto, ya está acostumbrada pero, para mí, el &quot;espectáculo&quot; llega a ser casi hipnótico, cuando me descuido un poco.</p>",
			},
			'saludar': {
				'text': "<p>Me toma su rato: saludo, respuesta, contra respuesta... ajustando el tono de voz y la deferencia debida según la edad de cada uno. No hay más de cinco adultos en este círculo, pero han pasado diez minutos o así en esto de decir &quot;buenos días&quot;.</p>",
				'attributes': ["visto_saludo"],
			},
			'circulo': {
				'text': "<p>Las comidas, las conversaciones, el trabajo... todo salvo lo estrictamente íntimo La Gente lo hace en círculos: sentados o de pie, en familia o en grupos tan amplios como la ocasión lo amerite. En este momento, por ejemplo, han de haber 6 o 7 círculos como este en la llanura, ocupados en la cosecha diaria.</p>\n<p>Entiendo que los círculos de la aldea completa son ocasiones solemnes, aunque no he presenciado ninguno a la fecha y no sé cómo o porqué se convocan.</p>",
				'attributes': ["visto_circulo"],
			},
		},
	},
	'pasto largo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCon algo de esfuerzo, voy cogiendo &quot;hojas&quot; de pasto largo, más bien grueso y de color azul intenso, que se usa para tejidos bastos como los de las tiendas... y por supuesto, para comer, siendo especialmente apreciado por los niños.</p>\n<p>Cuando ya me pesan demasiado las hojas cortadas en el brazo, voy dejando lo recolectado en un fardo creciente de hojas similares al centro del círculo.</p>\n<p>Habiendo hecho una contribución razonable, es momento de decidir si {if seen pasto corto:ayudo a <a class=\"squiffy-link link-section\" data-section=\"llevar pasto\" role=\"link\" tabindex=\"0\">llevar parte de lo recolectado a la aldea</a> o dejarlo así y <a class=\"squiffy-link link-section\" data-section=\"explorar llanura\" role=\"link\" tabindex=\"0\">explorar la llanura cercana</a>.}{else:sigo con la recolección de <a class=\"squiffy-link link-section\" data-section=\"pasto corto\" role=\"link\" tabindex=\"0\">pasto corto</a>, ayudo a <a class=\"squiffy-link link-section\" data-section=\"llevar pasto\" role=\"link\" tabindex=\"0\">llevar parte de lo recolectado a la aldea</a> o lo dejo así y <a class=\"squiffy-link link-section\" data-section=\"explorar llanura\" role=\"link\" tabindex=\"0\">exploro la llanura cercana</a>.}</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
		},
	},
	'pasto corto': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCon facilidad y casi sin esfuerzo voy cortando los tallos de pasto corto, tierno y pálido, usado para tejer mantas o esterillas, alguna <a class=\"squiffy-link link-passage\" data-passage=\"prenda de vestir\" role=\"link\" tabindex=\"0\">prenda de vestir</a> y ciertamente como alimento, que los ancianos prefieren al pasto más largo.</p>\n<p>Al momento en que ya no puedo sostener los tallos que he cortado, voy dejando lo recolectado en un lote de hojas parecidas al centro del círculo.</p>\n<p>Cuando veo que ya he hecho un buen aporte, es momento de ver qué hacer ahora: {if seen pasto largo:ayudar a <a class=\"squiffy-link link-section\" data-section=\"llevar pasto\" role=\"link\" tabindex=\"0\">llevar parte de lo recolectado a la aldea</a> o dejarlo así y <a class=\"squiffy-link link-section\" data-section=\"explorar llanura\" role=\"link\" tabindex=\"0\">explorar la llanura cercana</a>.}{else:sigo con la recolección de <a class=\"squiffy-link link-section\" data-section=\"pasto largo\" role=\"link\" tabindex=\"0\">pasto largo</a>, ayudo a <a class=\"squiffy-link link-section\" data-section=\"llevar pasto\" role=\"link\" tabindex=\"0\">llevar parte de lo recolectado a la aldea</a> o lo dejo así y <a class=\"squiffy-link link-section\" data-section=\"explorar llanura\" role=\"link\" tabindex=\"0\">exploro la llanura cercana</a>.}</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
			'prenda de vestir': {
				'text': "<p>Aparte de mis &quot;breves&quot; requerimientos de vestimenta, no hay demasiadas ropas a la vista. La Gente suele ir desnuda y no elabora prendas de vestir, salvo una especie de tocado para usar como sombrilla, si el sol cae muy fuerte.</p>",
			},
		},
	},
	'llevar pasto': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nTomo varias hojas de pasto largo y, con una de ellas, ato un montón lo más grande que mi destreza me permite. La verdad es que he cogido un buen montón y uno de los aldeanos me <a class=\"squiffy-link link-passage\" data-passage=\"felicita\" role=\"link\" tabindex=\"0\">felicita</a> por mi aporte, mientras los demás {if visto_risa:fruncen el ceño}{else:<a class=\"squiffy-link link-passage\" data-passage=\"sonrien\" role=\"link\" tabindex=\"0\">fruncen el ceño</a>} en apreciación.</p>\n<p>Con cuidado, llevo mi fardo de pasto de regreso a la aldea. Me demoro un poco, pero al cabo encuentro un {if visto_circulo:círculo}{else:<a class=\"squiffy-link link-passage\" data-passage=\"circulo\" role=\"link\" tabindex=\"0\">círculo</a>} de aldeanos que están acopiando el pasto recolectado y separándolo según su calidad y el uso que se le dará.</p>\n<p>Sintiendo satisfacción por haber aportado a La Gente con lo que es diariamente necesario, me alejo de la aldea hasta llegar a la llanura para <a class=\"squiffy-link link-section\" data-section=\"explorar llanura\" role=\"link\" tabindex=\"0\">explorar los campos de pasto</a>.</p>",
		'attributes': ["puntaje+=1","puntaje_Aldea+=1"],
		'passages': {
			'felicita': {
				'text': "<p>Me da unos golpes con sus pies en mis pantorrillas. Costumbres de La Gente...</p>",
			},
			'sonrien': {
				'text': "<p>Se están riendo. No vean la de malentendidos que me causó <i>no</i> entender este tipo de cosas al principio.</p>",
				'attributes': ["visto_risa"],
			},
			'circulo': {
				'text': "<p>Las comidas, las conversaciones, el trabajo... todo salvo lo estrictamente íntimo La Gente lo hace en círculos: sentados o de pie, en familia o en grupos tan amplios como la ocasión lo amerite.</p>\n<p>Entiendo que los círculos de la aldea completa son ocasiones solemnes, aunque no he presenciado ninguno a la fecha y no sé cómo o porqué se convocan.</p>",
			},
		},
	},
	'explorar llanura': {
		'clear': true,
		'text': "<p>{if puntaje=2: {@puntaje_memoria-=1}}\n{if puntaje=1: {@puntaje_memoria-=1}}\n{if puntaje=0: {@puntaje_memoria-=1}}\n{PUNTAJE}\nAvanzo entre los pastos, pasando a veces por el costado de otros {if visto_circulo:círculos}{else:<a class=\"squiffy-link link-passage\" data-passage=\"circulo\" role=\"link\" tabindex=\"0\">círculos</a>} o atravesándolos discretamente.</p>\n<p>Al cabo de un rato de caminata, llego al límite de los pastos y me enfrento con una cerca prácticamente impenetrable de <a class=\"squiffy-link link-passage\" data-passage=\"flores de fuego\" role=\"link\" tabindex=\"0\">flores de fuego</a>, que se extienden todo alrededor de los campos donde La Gente cosecha ahora su pasto.</p>\n<p>Es un verdadero muro al que no conviene acercarse: varios Cazadores que lo han intentado quedaron atrapados entre sus tallos rojos y ardieron hasta quedar reducidos a meras cenizas.</p>\n<p>Cuesta creer lo diferente que era todo esto <i><a class=\"squiffy-link link-section\" data-section=\"Parte III\" role=\"link\" tabindex=\"0\">cuando llegué a este planeta</a></i>...</p>",
		'attributes': ["puntaje_memoria+=1"],
		'passages': {
			'circulo': {
				'text': "<p>Las comidas, las conversaciones, el trabajo... todo salvo lo estrictamente íntimo La Gente lo hace en círculos: sentados o de pie, en familia o en grupos tan amplios como la ocasión lo amerite. En este momento, por ejemplo, han de haber 6 o 7 círculos como este en la llanura, ocupados en la cosecha diaria.</p>\n<p>Entiendo que los círculos de la aldea completa son ocasiones solemnes, aunque no he presenciado ninguno a la fecha y no sé cómo o porqué se convocan.</p>",
				'attributes': ["visto_circulo"],
			},
			'flores de fuego': {
				'text': "<p>Cada una de estas flores tiene un hermoso capullo, con pétalos de color violeta con estrías anaranjadas. Sus pistilos son de un índigo brillante, despiden un aroma sulfuroso, dulzón, intenso y penetrante... y emanan un calor fuerte, casi sofocante.</p>\n<p>El viento, al mover las flores, las hace soltar unas pequeñas chispas luminosas de polen.</p>\n<!-- Parte III El Viajero -->\n<!-- Max Puntaje Memoria: 1 -->",
			},
		},
	},
	'Parte III': {
		'clear': true,
		'text': "<p><font color=\"white\"></p>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"34%\" style=\"background-color:black;text-align:center;font-family:courier;\"><b><br>\nParte III<br>\n<br>\nEl Viajero<br>\n<br></b></td>\n<td width=\"33%\"></td>\n</tr></table>\n</font>\n<br><br>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"33%\"></td>\n<td width=\"33%\" style=\"text-align:right;\"><a class=\"squiffy-link link-section\" data-section=\"El Viajero y el Muro de Fuego\" role=\"link\" tabindex=\"0\">Continuar</a></td>\n</tr></table>",
		'passages': {
		},
	},
	'El Viajero y el Muro de Fuego': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>&quot;¡Saludos, Viajero!&quot;, dice el aldeano, y agrega luego algo que <a class=\"squiffy-link link-passage\" data-passage=\"idioma\" role=\"link\" tabindex=\"0\">no logro entender</a>.</p>\n<p>Se ha parado de forma que su sombra me cubre y, la verdad agradezco el gesto. A pesar de que acabo de comer hace un rato no me siento con fuerzas para algo tan elemental como levantar mi mano para hacer sombra sobre los ojos.</p>\n<p>Hago un esfuerzo y me siento más derecho, tratando de no seguir apoyado en la <a class=\"squiffy-link link-passage\" data-passage=\"tienda\" role=\"link\" tabindex=\"0\">tienda</a> que me han obsequiado, para responder un &quot;¡Te saludo también!&quot; con algo de cansancio.</p>\n<p>Intento incorporarme, pero no lo consigo. Sencillamente, no tengo la energía necesaria.</p>\n<p>El aldeano, para no obligarme a mirar hacia arriba, se <a class=\"squiffy-link link-passage\" data-passage=\"sentarse\" role=\"link\" tabindex=\"0\">sienta</a> frente a mí, con el <a class=\"squiffy-link link-passage\" data-passage=\"ceño fruncido\" role=\"link\" tabindex=\"0\">ceño fruncido</a>.</p>\n<p>&quot;Estás débil, Viajero. Hoy y antes de hoy sin moverte.&quot; dice el aldeano, hablando despacio para que le entienda bien.</p>\n<p>&quot;Débil, sí&quot;, le respondo. &quot;Como mucho, pero pocas fuerzas&quot;, le digo <a class=\"squiffy-link link-passage\" data-passage=\"entrecortadamente\" role=\"link\" tabindex=\"0\">entrecortadamente</a>.</p>\n<p>Se hace un silencio y al cabo el aldeano dice &quot;Ancianos pueden ayudar.&quot;</p>\n<p>Le contesto con un &quot;Ayuda, sí, gracias&quot; muy quedo.</p>\n<p>El aldeano espera cortesmente a que <a class=\"squiffy-link link-section\" data-section=\"levantarse\" role=\"link\" tabindex=\"0\">trate de levantarme</a>... o a que <a class=\"squiffy-link link-section\" data-section=\"visitar anciano\" role=\"link\" tabindex=\"0\">le pida ayuda</a> para ponerme de pie.</i></p>",
		'attributes': ["puntaje =0","seccion=Viajero"],
		'passages': {
			'idioma': {
				'text': "<p><i>Aún no logro comprender todas las sutilezas de su lenguaje y mi vocabulario es bastante limitado.</p>\n<p>Mi estado actual tampoco ha ayudado a mi aprendizaje, la verdad...</i></p>",
			},
			'tienda': {
				'text': "<p><i>Entiendo que el anterior ocupante murió atacado por algo así como una bestia peligrosa y, aunque no es la costumbre seguir usando una tienda en estos casos (o así lo entendí), me la han cedido hasta que pueda hacer una por mí mismo.</p>\n<p>No sé la verdad cuándo será eso; el entramado con que han tejido la tienda es complejísimo.</i></p>",
			},
			'sentarse': {
				'text': "<p>Creo <i>que se ha sentado: al menos sus piernas están plegadas y en contacto con el suelo, pero haría falta un fakir terrestre para imitar al aldeano.</i></p>",
			},
			'ceño fruncido': {
				'text': "<p><i>No sé si está preocupado por mí o qué; el lenguaje gestual de esta gente es todavía un misterio para mí.</i></p>",
			},
			'entrecortadamente': {
				'text': "<p><i>Debo parecer como un niño chico aprendiendo sus primeras palabras.</i></p>",
			},
		},
	},
	'levantarse': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>Intento pararme... pero no hay caso, estoy demasiado débil.</i></p>\n<p>{visitar anciano}</p>",
		'passages': {
			'circulo': {
				'text': "<p><i>Hay huellas en el suelo: varios ancianos, adultos y niños estuvieron aquí hace no mucho.</i></p>",
			},
			'esperamos': {
				'text': "<p><i>Si no fuera por el aldeano que me acompaña y sostiene, hace rato que ya me habría desplomado en el suelo, respeto o no.</i> </p>",
			},
		},
	},
	'visitar anciano': {
		'clear': true,
		'text': "<p><i>{if seen levantarse:Tragándome mi orgullo, le }\n{else:\nLe}\nextiendo las manos para que me ayude a pararme, lo que el aldeano hace prontamente.</p>\n<p>Apoyándome en el aldeano, caminamos lentamente hasta llegar a un <a class=\"squiffy-link link-passage\" data-passage=\"circulo\" role=\"link\" tabindex=\"0\">sitio circular</a> donde {if visto_Mayor:uno de los mayores}{else:<a class=\"squiffy-link link-passage\" data-passage=\"uno de los mayores\" role=\"link\" tabindex=\"0\">uno de los mayores</a>} de la aldea está comiendo en solitario.</p>\n<p>El anciano parece estar completamente absorto en algo que no vemos, así que <a class=\"squiffy-link link-passage\" data-passage=\"esperamos\" role=\"link\" tabindex=\"0\">esperamos</a> respetuosamente en silencio.</p>\n<p>Cuando el anciano ha terminado de... lo que sea, nos hace un gesto y <a class=\"squiffy-link link-section\" data-section=\"el anciano\" role=\"link\" tabindex=\"0\">nos acercamos</a>.\n</i></p>",
		'passages': {
			'circulo': {
				'text': "<p><i>Hay huellas en el suelo: varios ancianos, adultos y niños estuvieron aquí hace no mucho.</i></p>",
			},
			'esperamos': {
				'text': "<p><i>Si no fuera por el aldeano que me acompaña y sostiene, hace rato que ya me habría desplomado en el suelo, respeto o no.</i> </p>",
			},
			'uno de los mayores': {
				'text': "<p>Su piel es extremadamente lisa, por lo que entiendo que es el más anciano de cuantos viven en la aldea: el Decano de La Gente, al que todos parecen tratar con mucha deferencia.</p>",
				'attributes': ["visto_Mayor"],
			},
		},
	},
	'el anciano': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>Con cuidado, nos sentamos junto al anciano. El aldeano toma la palabra y algo alcanzo a entender de lo que dice:</p>\n<p>&quot;Mayor, el Viajero... comida... pero cansado hoy... antes de hoy cansado... ayudarlo...&quot; y otras muchas cosas que no alcanzo a entender.</p>\n<p>El anciano escucha atentamente, mirándome de vez en cuando.</p>\n<p>Cuando el aldeano ha terminado de hablar, el anciano le agradece (creo) y luego le dice... algo.</p>\n<p>Algo que nunca había escuchado en su idioma. Sin embargo, en mi mente se ha formado una idea en forma casi instantánea.</i></p>\n<p><b>Memoria.</b></p>\n<p><i>No sé si es la falta de fuerzas o qué, pero nada más oír esa palabra siento un ligero mareo. Al ver esto, el anciano y el aldeano me ayudan a recostarme, mientras se dicen algo en voz muy baja.</i></p>\n<p><b>Memoria.</b></p>\n<p><i>El aldeano y el anciano comienzan a hablar en forma rítmica, casi cantando...</p>\n<p>...y comienzo a caer en un profundo <a class=\"squiffy-link link-section\" data-section=\"Protector\" role=\"link\" tabindex=\"0\">sopor</a>.</i></p>",
		'passages': {
		},
	},
	'Protector': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>No entiendo lo que está pasando: no estoy del todo conciente pero tampoco estoy dormido. </p>\n<p>El anciano y el aldeano siguen canturreando, repitiendo una y otra vez algo así como un verso largo.</p>\n<p>Sintiendo como si la cabeza me diera vueltas, varias partes del canto van cobrando significado de una manera muy extraña, ya que el idioma sigue sin hacerme sentido.</p>\n<p>Y entiendo que parte de lo que estoy oyendo (o escuchando, por momentos) es un relato de los hechos de la aldea.</p>\n<p>La llegada de La Gente, en un tiempo inmemorial, desde tierras áridas a las llanuras, ricas en pasto...</p>\n<p>La amenaza constante de los Cazadores, desde aquel pasado remoto...</p>\n<p>Un periodo de paz, cuando un ser extraño y diferente, al que llamaron Protector, cuidó de la aldea, alejando a los Cazadores...</p>\n<p>La desaparición del Protector y el regreso de terror y la muerte a manos de los Cazadores...</p>\n<p>...y otras cosas, para las que no tengo conceptos o palabras salvo una:\n</i></p>\n<p><b><a class=\"squiffy-link link-section\" data-section=\"despertar\" role=\"link\" tabindex=\"0\">Memoria</a>.</b></p>",
		'passages': {
		},
	},
	'despertar': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>En algún momento han debido dejar de cantar y descubro que estoy despierto, lúcido... y que, para mi completo estupor, entiendo </i>mucho<i> mejor al anciano cuando me habla.</p>\n<p>&quot;¿Te sientes mejor, Viajero?&quot;, me pregunta el mayor.</p>\n<p>La sensación que tengo al escucharlo es muy rara, aunque se parece mucho al de una asimilación de <a class=\"squiffy-link link-passage\" data-passage=\"hipnopedia\" role=\"link\" tabindex=\"0\">hipnopedia</a>;casi sin pensarlo, respondo en su idioma un &quot;Sí, gracias, me siento mucho mejor&quot; que no habría sabido decir correctamente</i> esta mañana.</p>\n<p><i>Y, en verdad, me encuentro mejor: más descansado y sin esa lasitud que me acompañaba hace días.</p>\n<p>El aldeano <a class=\"squiffy-link link-passage\" data-passage=\"pide permiso\" role=\"link\" tabindex=\"0\">pide permiso</a> para hablar y el anciano se lo <a class=\"squiffy-link link-passage\" data-passage=\"concede\" role=\"link\" tabindex=\"0\">concede</a>.</p>\n<p>&quot;Eres diferente a nosotros, Viajero.&quot;, me comenta el aldeano, &quot;Pensamos que estabas ayunando para encontrar tu Memoria, pero tu debilidad era ya peligrosa y hemos comprendido que lo que en realidad ocurre es que el pasto que a nosotros nos basta no es suficiente para tu sustento.&quot;</p>\n<p>&quot;Sabemos que aquí cerca crecen otras cosas que podrían ser buenas para ti,&quot; añade tras una pausa,&quot;pero no estamos seguros pues nunca han sido del gusto o necesidad de La Gente.&quot;</p>\n<p>Habiendo dicho eso, extiende su brazo con la <a class=\"squiffy-link link-passage\" data-passage=\"palma hacia arriba\" role=\"link\" tabindex=\"0\">palma hacia arriba</a>.</p>\n<p>Podría <a class=\"squiffy-link link-section\" data-section=\"salir acompañado\" role=\"link\" tabindex=\"0\">aceptar su ayuda</a>... o dejar de ser una carga para esta buena gente y empezar a aprender a <a class=\"squiffy-link link-section\" data-section=\"salir solo\" role=\"link\" tabindex=\"0\">arreglármelas solo</a>.\n</i></p>",
		'passages': {
			'hipnopedia': {
				'text': "<p><i>Algunos temas técnicos los aprendí con hipnosis bajo sueño inducido... pero aquí no hubo computadoras, ni cámaras de aislación, ni nada de eso. Es inquietante...</i></p>",
			},
			'pide permiso': {
				'text': "<p><i>Es un sutil gesto con la mano, que reconozco... aunque nadie me lo haya explicado nunca.</i></p>",
			},
			'concede': {
				'text': "<p><i>Sus ojos se han movido a un lado por un momento. Hasta antes del canto, no había notado ni entendido ese detalle.</i></p>",
			},
			'palma hacia arriba': {
				'text': "<p><i>Me está ofreciendo su ayuda. No sé si sentirme conmovido por el gesto... o asustado porque ahora, de pronto, entiendo</i> mucho <i>del lenguaje corporal sin mayor explicación: como si lo conociera de siempre.\n</i></p>",
			},
		},
	},
	'salir acompañado': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>La verdad es que no las tengo todas conmigo y es un ofrecimiento muy generoso, por lo que me dispongo a agradecerle al aldeano...</p>\n<p>...y pasa algo más extraño que mi creciente comprensión de su lenguaje: mis manos se mueven solas, en <a class=\"squiffy-link link-passage\" data-passage=\"agradecer\" role=\"link\" tabindex=\"0\">un gesto</a> que no parece sorprender a nadie salvo a mí.</p>\n<p>Tras un breve silencio, el Anciano fija su vista en mi y en voz suave me dice &quot;Es prudente que salgas de la aldea con compañía. Pon atención a lo que diga tu guía y, sobre todo, cuídate de los Cazadores, Viajero.&quot;</p>\n<p></i><b>Cazadores.</b><i></p>\n<p>La palabra resuena en mi mente, evocando miedos y temores ancestrales de La Gente.</p>\n<p>{if visto_cazadores:He visto de lo que son capaces esos animales, así que no es malo recordarlo}{else:Aunque no los haya visto nunca, el consejo parece atinado}, aunque vaya a salir con un guía.</p>\n<p>Me levanto con cuidado y comienzo a seguir al aldeano, que, tras despedirse del anciano, recorre la aldea en dirección opuesta a la llanura.</p>\n<p>Por lo visto </i>no<i> vamos hacia los pastos; <a class=\"squiffy-link link-section\" data-section=\"camino al Lago Ardiente acompañado\" role=\"link\" tabindex=\"0\">vamos a un lugar que no conozco</a>{if tengo_pistola:... por lo que quizás sería conveniente pasar antes por mi tienda y <a class=\"squiffy-link link-section\" data-section=\"coger la pistola antes de salir\" role=\"link\" tabindex=\"0\">llevar la pistola de señales como protección</a>.}{else:.}\n</i></p>",
		'passages': {
			'agradecer': {
				'text': "<p><i>Con lentitud, llevo primero mi mano derecha a mi hombro izquierdo y luego la mano izquierda al hombro derecho.</i></p>",
			},
		},
	},
	'salir solo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>La verdad es que prefiero tratar de valérmelas solo, debilidad o no. Es, sin embargo, una oferta muy generosa y no quisiera ofender al aldeano, por lo que me dispongo a rechazar con cortesía su propuesta... </p>\n<p>...y pasa algo más extraño que mi creciente comprensión de su lenguaje: mis manos se mueven solas, en <a class=\"squiffy-link link-passage\" data-passage=\"agita las manos\" role=\"link\" tabindex=\"0\">un gesto</a> que no parece sorprender a nadie salvo a mí.</p>\n<p>Tras un breve silencio, el Anciano fija su vista en mi y en voz suave me dice &quot;No es recomendable que salgas de la aldea sin compañía, pero respetaremos tu voluntad, Viajero. Que la prudencia sea tu guía, el sigilo tu protección... y, sobre todo, cuídate de los Cazadores, Viajero.&quot;</p>\n<p></i><b>Cazadores.</b><i></p>\n<p>La palabra resuena en mi mente, evocando miedos y temores ancestrales de La Gente.</p>\n<p>{if visto_cazadores:He visto de lo que son capaces esos animales, así que no es malo recordarlo}{else:Aunque no los haya visto nunca, el consejo parece atinado}, máxime si quiero seguir adelante solo.</p>\n<p>Me levanto con cuidado y escucho al anciano, que me da indicaciones para que salga de la aldea en dirección opuesta a la llanura.</p>\n<p>&quot;¿Cómo sabré que he llegado al lugar correcto?&quot;, le pregunto.</p>\n<p>&quot;Bastará con que sigas el olor en el aire&quot;, me contesta.</p>\n<p>Vaya.</p>\n<p>Tras despedirme del anciano y del aldeano, camino por la aldea según se me indicó, cuando de pronto caigo en cuenta de que </i>no<i> voy hacia los pastos.</p>\n<p>Habrá que tener cuidado, entonces, pues {if seen salir acompañado:<a class=\"squiffy-link link-section\" data-section=\"camino al Lago Ardiente acompañado\" role=\"link\" tabindex=\"0\">voy a un lugar que no conozco</a>}{else:<a class=\"squiffy-link link-section\" data-section=\"camino al Lago Ardiente solo\" role=\"link\" tabindex=\"0\">voy a un lugar que no conozco</a>}{if tengo_pistola:... por lo que quizás sería conveniente pasar antes por mi tienda y <a class=\"squiffy-link link-section\" data-section=\"coger la pistola antes de salir\" role=\"link\" tabindex=\"0\">llevar la pistola de señales como protección</a>.}{else:.}\n</i></p>",
		'passages': {
			'agita las manos': {
				'text': "<p><i>Mis manos se agitan lentamente de un lado a otro.</i></p>",
			},
		},
	},
	'coger la pistola antes de salir': {
		'text': "<p><i>{if seen salir acompañado:Le pido al aldeano que me espere un momento y me}{else:Me} encamino a mi tienda para coger la pistola de señales: ya tengo de sobras sabido que fuera de la aldea abundan animales peligrosos y la pistola sería útil para auyentarlos.</p>\n<p>Con la pistola en mano {if seen salir acompañado:me reúno con el aldeano y <a class=\"squiffy-link link-section\" data-section=\"camino al Lago Ardiente acompañado\" role=\"link\" tabindex=\"0\">reanudamos la marcha</a>}{else:y sintiéndome un poco más tranquilo <a class=\"squiffy-link link-section\" data-section=\"camino al Lago Ardiente solo\" role=\"link\" tabindex=\"0\">sigo mi camino</a>}.\n</i></p>",
		'attributes': ["llevo_pistola"],
		'passages': {
		},
	},
	'camino al Lago Ardiente acompañado': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nNada más salir de la aldea y nos encontramos al poco andar nuevamente rodeados por una llanura de pastos.</p>\n<p>La verdad es que he estado a punto de preguntarle a mi acompañante por qué no se recolecta pasto en esta salida de la aldea, cuando de improviso me llega un {if visto_cazadores:<a class=\"squiffy-link link-passage\" data-passage=\"olor conocido\" role=\"link\" tabindex=\"0\">olor conocido</a>... y son malas noticias: hay un Cazador y no está lejos}{else:<a class=\"squiffy-link link-passage\" data-passage=\"olor inquietante\" role=\"link\" tabindex=\"0\">olor inquietante</a>}.</p>\n<p>El aldeano se ha quedado completamente inmóvil, por lo que también me detengo{if visto_cazadores:, lo que probablemente es lo mejor que puede hacerse en este momento, ya que los depredadores son atraídos por los ruidos}{else:, más que nada porque probablemente el aldeano sabe lo que hace... y yo no. Por lo visto, el Anciano sabía que esto iba a pasar}.</p>\n<p>{if visto_cazadores:La verdad, ya sé de lo que estas bestias son capaces y}{else:Hay algo hostil acercándose.</p>\n<p>Es un Cazador, seguro... y descubro que} tengo miedo{if llevo_pistola:, esté o no armado y }{else:: }sólo la actitud serena de mi acompañante mantiene el pánico a raya.</p>\n<p>Desde el frente llega un ruido de pasto quebrándose y mi acompañante pone su mano en mi hombro: agradezco el gesto y la serenidad que me transmite{if llevo_pistola: ...pero titubeo entre <a class=\"squiffy-link link-section\" data-section=\"esperar en silencio\" role=\"link\" tabindex=\"0\">seguir su ejemplo</a> o sencillamente usar mi <a class=\"squiffy-link link-section\" data-section=\"disparar a Cazador acompañado\" role=\"link\" tabindex=\"0\">pistola</a>.}{else:, por lo que sigo su ejemplo y nos mantenemos inmóviles y en silencio.</p>\n<p>Tan pronto como llegaron los sonidos se desvanecen. En seguida se escucha un siseo breve, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Mi acompañante me <a class=\"squiffy-link link-passage\" data-passage=\"muestra su aprecio\" role=\"link\" tabindex=\"0\">muestra su aprecio</a> y en silencio <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">seguimos andando</a>.}\n</i></p>",
		'passages': {
			'olor conocido': {
				'text': "<p><i>\nEs un almizcle entre dulzón y cálido: Cazadores, sin duda.\n</i></p>",
			},
			'olor inquietante': {
				'text': "<p><i>\nEs un almizcle entre dulzón y cálido, un olor que me inspira miedo.\n</i></p>",
			},
			'muestra su aprecio': {
				'text': "<p><i>\nMe da una rápida patada en el tobillo. No acabo de entender por qué el gesto me complace tanto.\n</i></p>",
			},
		},
	},
	'disparar a Cazador acompañado': {
		'text': "<p><i>\nLevanto el arma y disparo en dirección al ruido. El fogonazo se pierde entre la hierba y en seguida se escucha un breve siseo, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Mi acompañante me <a class=\"squiffy-link link-passage\" data-passage=\"muestra su aprecio\" role=\"link\" tabindex=\"0\">muestra su aprecio</a> y en silencio <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">seguimos andando</a>.\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
			'muestra su aprecio': {
				'text': "<p><i>\nMe da una rápida patada en el tobillo. No acabo de entender por qué el gesto me complace tanto.\n</i></p>",
			},
		},
	},
	'esperar en silencio': {
		'text': "<p><i>\nTras unos instantes los sonidos se desvanecen. En seguida se escucha un siseo breve, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Mi acompañante me <a class=\"squiffy-link link-passage\" data-passage=\"muestra su aprecio\" role=\"link\" tabindex=\"0\">muestra su aprecio</a> y en silencio <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">seguimos andando</a>.\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
			'muestra su aprecio': {
				'text': "<p><i>\nMe da una rápida patada en el tobillo. No acabo de entender por qué el gesto me complace tanto.\n</i></p>",
			},
		},
	},
	'camino al Lago Ardiente solo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nNada más salir de la aldea y me encuentro rodeado por una llanura de pastos.</p>\n<p>La verdad es que me he empezado a preguntar por qué no se recolecta pasto en esta salida de la aldea, cuando de improviso me llega un {if visto_cazadores:<a class=\"squiffy-link link-passage\" data-passage=\"olor conocido\" role=\"link\" tabindex=\"0\">olor conocido</a>... y son malas noticias: hay un Cazador y no está lejos}{else:<a class=\"squiffy-link link-passage\" data-passage=\"olor inquietante\" role=\"link\" tabindex=\"0\">olor inquietante</a>}.</p>\n<p>Me he quedado completamente inmóvil, {if visto_cazadores:lo que probablemente es lo mejor que puede hacerse en este momento, ya que los depredadores son atraídos por los ruidos}{else:más que nada porque no sé qué está pasando... pero el Anciano sí que lo sabía}.</p>\n<p>{if visto_cazadores:La verdad, ya sé de lo que estas bestias son capaces y}{else:Hay algo hostil acercándose.</p>\n<p>Es un Cazador, seguro... y descubro que} tengo miedo{if llevo_pistola:, esté o no armado}... y el estar solo no mejora mi sensación de desamparo.</p>\n<p>Desde el frente llega un ruido de pasto quebrándose y me quedan apenas unos segundos para decidirme a{if llevo_pistola: usar mi <a class=\"squiffy-link link-section\" data-section=\"disparar a Cazador solo\" role=\"link\" tabindex=\"0\">pistola</a>,} <a class=\"squiffy-link link-section\" data-section=\"esperar a pie firme\" role=\"link\" tabindex=\"0\">esperar a pie firme</a> o sencillamente <a class=\"squiffy-link link-section\" data-section=\"salir corriendo\" role=\"link\" tabindex=\"0\">salir corriendo</a>.\n</i></p>",
		'passages': {
			'olor conocido': {
				'text': "<p><i>\nEs un almizcle entre dulzón y cálido: Cazadores, sin duda.\n</i></p>",
			},
			'olor inquietante': {
				'text': "<p><i>\nEs un almizcle entre dulzón y cálido, un olor que me inspira miedo.\n</i></p>",
			},
		},
	},
	'esperar a pie firme': {
		'text': "<p><i>\nTras unos instantes los sonidos se desvanecen. En seguida se escucha un siseo breve, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Cuando el silencio vuelve a rodearme... y he dejado de temblar... me levanto en silencio y <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">sigo andando</a>.\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
		},
	},
	'disparar a Cazador solo': {
		'text': "<p><i>\nLevanto el arma y disparo en dirección al ruido. El fogonazo se pierde entre la hierba y en seguida se escucha un breve siseo, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Cuando el silencio vuelve a rodearme, doy un suspiro de alivio, me levanto en silencio y <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">sigo andando</a>.\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
		},
	},
	'salir corriendo': {
		'text': "<p><i>\nSalgo disparado en dirección a la aldea, pero no he alcanzado a dar dos pasos cuando algo pasa junto a mí y me da un violento empellón.</p>\n<p>Caigo al suelo, mas dolorido que dañado, mientras escucho un breve siseo, seguido por sonidos leves que se alejan rápidamente.</p>\n<p>Cuando el silencio vuelve a rodearme... y he dejado de temblar... me levanto en silencio y <a class=\"squiffy-link link-section\" data-section=\"Lago Ardiente\" role=\"link\" tabindex=\"0\">sigo andando</a>.\n</i></p>",
		'passages': {
		},
	},
	'Lago Ardiente': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nDespués de andar un buen rato, los pastos desaparecen del todo y {if seen salir acompañado:llegamos}{else:llego} a un vasto cenagal... del que emana un fuerte calor.</p>\n<p>En la <a class=\"squiffy-link link-passage\" data-passage=\"arena\" role=\"link\" tabindex=\"0\">orilla</a> se ve un denso cañaveral, formado de juncos morados, altos y fuertes, a los que el calor que surje del suelo parece no molestarles. Más allá de los juncos, el suelo fangoso se extiende hasta donde la vista alcanza... distancia que es difícil de estimar, pues el aire parece vibrar sobre el suelo a no más de unos metros de donde termina la vegetación.</p>\n<p>{if seen salir acompañado:El aldeano me cuenta que alguna vez, hace mucho tiempo, aquí había un vasto lago ardiente y sólo podía cruzarse a la otra orilla con la ayuda de ciertos animales que aquí ya no viven.}{else:Cuesta imaginar qué fue lo que pasó en este lugar para que el suelo se calentara tanto al punto de parecer que está ardiendo.}</p>\n<p>Estoy tan fascinado por el paisaje que casi he olvidado para qué vine hasta aquí.</p>\n<p>{if seen salir acompañado:Mi acompañante hace un gesto hacia los juncos. El <a class=\"squiffy-link link-passage\" data-passage=\"olor\" role=\"link\" tabindex=\"0\">olor</a> que me llega no parece malo, por lo que decido avanzar <a class=\"squiffy-link link-section\" data-section=\"los juncos\" role=\"link\" tabindex=\"0\">hacia las plantas</a>.}{else:En el suelo alrededor mío se ven unas semillas. Me agacho para examinarlas y su <a class=\"squiffy-link link-passage\" data-passage=\"olor\" role=\"link\" tabindex=\"0\">olor</a> no parece malo, por lo que decido hacerle caso a mi nariz y <a class=\"squiffy-link link-section\" data-section=\"los juncos\" role=\"link\" tabindex=\"0\">guiarme por mi olfato</a>.}\n</i></p>",
		'passages': {
			'olor': {
				'text': "<p><i>\nEs un aroma cálido que me recuerda al de las almendras tostadas.\n</i></p>",
			},
			'arena': {
				'text': "<p><i>\nLa orilla es de arena de color verde, fina y suave; brilla un poco a la luz. Cubre todo el lugar. Más allá de la vegetación, la arena parece estar sólida y semitransparente, de fuerte color amarillo.\n</i></p>",
			},
		},
	},
	'los juncos': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\n{if seen salir acompañado:{@puntaje+=1}}\n{if seen salir acompañado:{@puntaje_Viajero+=1}}</p>\n<p>Conforme me acerco a los juncos noto que el suelo se vuelve más caliente, aunque no al punto de impedir el avance.</p>\n<p>Al llegar al pie de las plantas veo que a lo largo de los tallos hay pequeñas hileras de semillas, más abundantes y grandes conforme las plantas son más altas...</p>\n<p>...y el olor es irresistible. Sin darme cuenta de lo que estoy haciendo, empiezo a coger semillas a dos manos, llevármelas a la boca y masticarlas. El sabor es semejante al de las avellanas y crujen satisfactoriamente, aunque no son especialmente duras.</p>\n<p>Tras unos minutos ya no tengo hambre y descubro que siento vigor y ganas de moverme, cosa que no me había pasado desde que llegué a este planeta.</p>\n<p>Mientras recojo tantas semillas como puedo llevar con las manos{if seen salir acompañado: el aldeano se acerca y me ayuda en la recolección, cosa que agradezco}{else: siento un enorme alivio}. En el fondo, no me importa cuántas {if seen salir acompañado: podamos}{else: pueda} recolectar ahora mismo, que ya habrá ocasión de volver por más: no {if seen salir acompañado:hemos}{else:he} hecho apenas mella en las semillas de una sola planta y el cañaveral es vasto.</p>\n<p>Con el paso ligero y la tranquilidad que da haber encontrado el sustento, {if seen salir acompañado:emprendemos}{else:emprendo} el <a class=\"squiffy-link link-section\" data-section=\"regreso a la aldea\" role=\"link\" tabindex=\"0\">regreso a la aldea</a>.\n</i></p>",
		'passages': {
		},
	},
	'regreso a la aldea': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nYa de vuelta en la aldea {if seen salir acompañado:llegamos hasta mi tienda y el aldeano se despide de mí}{else:llego hasta mi tienda} y me quedo solo por unos momentos, mientras la vida fluye a mi alrededor...</p>\n<p>...cosa que ahora, con más energía en el cuerpo, consigo apreciar plenamente, con una lucidez que no tenía desde mi aterrizaje aciago. Descubro que mi tienda está algo apartada de las demás y que los aldeanos se cuidan mucho de acercarse, manteniendo varios pasos de distancia mientras se dedican a sus quehaceres.</p>\n<p>Otra cosa que estoy notando son los olores a mi alrededor, como si de pronto me hubiera sacado de encima un resfriado y mi nariz estuviera volviendo a funcionar en condiciones. Siento el olor del <a class=\"squiffy-link link-passage\" data-passage=\"pasto\" role=\"link\" tabindex=\"0\">pasto</a> que los aldeanos llevan en sus brazos, el aroma del <a class=\"squiffy-link link-passage\" data-passage=\"tejido\" role=\"link\" tabindex=\"0\">tejido</a> de mi tienda... y un cierto <a class=\"squiffy-link link-passage\" data-passage=\"tufillo\" role=\"link\" tabindex=\"0\">tufillo</a> a mis pies.</p>\n<p>El olor viene de mi esterilla y de pronto siento algo cercano a las náuseas; porque si para mí huelen a <a class=\"squiffy-link link-passage\" data-passage=\"peste\" role=\"link\" tabindex=\"0\">peste</a>, vaya uno a saber lo que les pueda parecer a los aldeanos... lo que explica por fin esta distancia que tanto trabajo les crea.</p>\n<p>Algo asqueado, decido que es hora de hacer aseo y me dispongo a <a class=\"squiffy-link link-section\" data-section=\"sacudir la esterilla ahora mismo\" role=\"link\" tabindex=\"0\">sacudir la esterilla ahora mismo</a>.\n</i></p>",
		'passages': {
			'pasto': {
				'text': "<p><i>\nEs un olor fresco, húmedo y chispeante como el de la mañana después de una lluvia.\n</i></p>",
			},
			'tejido': {
				'text': "<p><i>\nEs un olor seco, tibio y reconfortante como el calor al amor de la fogata.\n</i></p>",
			},
			'tufillo': {
				'text': "<p><i>\nEs un olor agrio, pestilente y rancio, como algo podrido y olvidado en un rincón.\n</i></p>",
			},
			'peste': {
				'text': "<p><i>\nEs mi propio olor, pero multiplicado por días y días de abandono. La verdad es que no sé cómo lo toleran... ni cómo es que no lo noté antes.\n</i></p>",
			},
		},
	},
	'sacudir la esterilla ahora mismo': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nCon más energía que cuidado, sacudo sin más la esterilla frente a mi tienda...</p>\n<p>...y caigo en la cuenta de que acabo de esparcir trocitos de mi piel y mi olor </i>todo al rededor<i>. No es de extrañar que La Gente no quiera ni acercarse a mi tienda; el lugar debe resultar repugnante para ellos.</p>\n<p>Dejo la esterilla enrollada dentro de mi tienda y, sintiéndome algo avergonzado, empiezo a caminar a paso rápido hacia la llanura.</p>\n<p>De camino veo a varios aldeanos que están haciendo lo mismo y titubeo entre <a class=\"squiffy-link link-section\" data-section=\"Recorrer la llanura\" role=\"link\" tabindex=\"0\">seguir solo</a> o acercarme a uno de los aldeanos para <a class=\"squiffy-link link-section\" data-section=\"continuar en compañía\" role=\"link\" tabindex=\"0\">continuar en compañía</a>.\n</i></p>",
		'passages': {
		},
	},
	'continuar en compañía': {
		'text': "<p><i>\nLos aldeanos me acogen, haciendo un espacio en medio para que pueda avanzar entre ellos sin tropiezos... todo esto sin mediar una palabra y como si fuera la cosa más normal del mundo.</p>\n<p>Juntos, en completo silencio,  avanzamos <a class=\"squiffy-link link-section\" data-section=\"Recorrer la llanura\" role=\"link\" tabindex=\"0\">en pos de los pastos</a>\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
		},
	},
	'Recorrer la llanura': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nTodo alrededor {if seen continuar en compañia:nos}{else:me} rodea el Pastizal. Los tallos de <a class=\"squiffy-link link-passage\" data-passage=\"pasto\" role=\"link\" tabindex=\"0\">pasto</a> se elevan rectos y a mi alrededor veo a varios aldeanos que se afanan en su recolección.</p>\n<p>{if seen continuar en compañia:Los aldeanos que me acompañaron se unen a la cosecha y pese}{else:Pese} al evidente ajetreo, todo se hace en completo silencio. Procurando no molestar a nadie, me he apartado un poco de los aldeanos y contemplo todo, inmóvil y algo embobado por la calma, notando pequeños detalles como las <a class=\"squiffy-link link-passage\" data-passage=\"piedritas\" role=\"link\" tabindex=\"0\">piedritas</a> del suelo, mientras el viento mece suavemente todo...</p>\n<p>...hasta que consigo escuchar su <a class=\"squiffy-link link-passage\" data-passage=\"música\" role=\"link\" tabindex=\"0\">música</a> y suspiro ante tanta belleza que para mí era ajena y extraña.</p>\n<p>Como en un ensueño, noto que a mi derecha los pastos disminuyen en altura y parece vislumbrarse una <a class=\"squiffy-link link-section\" data-section=\"el borde de los paramos\" role=\"link\" tabindex=\"0\">zona más despejada</a>, mientras que a mi izquierda se ve, detrás de los elevados tallos, un <a class=\"squiffy-link link-section\" data-section=\"camino a las flores de fuego\" role=\"link\" tabindex=\"0\">macizo de plantas extrañas y coloridas</a>.\n</i></p>",
		'passages': {
			'pasto': {
				'text': "<p><i>\nSon de un color azul intenso. Me llega su aroma suave, un poco agrio y ácido... que me resulta curiosamente reconfortante.\n</i></p>",
			},
			'música': {
				'text': "<p><i>\nEl aire produce un sonido suave y arrullador al rozar los tallos y siento de pronto una melancolía punzante y del todo inexplicable. ¿Qué es, exactamente, lo que me trae a la memoria?\n</i></p>",
			},
			'piedritas': {
				'text': "<p><i>\nA pesar de que el pasto lo cubre todo hace ya evidentemente mucho tiempo, aquí y allá se ven algunas piedras sueltas. Son pequeñas, de extraños colores: gris, negro, marrón...\n</i></p>",
			},
		},
	},
	'el borde de los paramos': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nMe levanto y, caminando sin prisa, al rato he llegado a la frontera de la llanura con un vasto <a class=\"squiffy-link link-passage\" data-passage=\"páramo\" role=\"link\" tabindex=\"0\">páramo</a> de aridez y desolación. La contemplación de este desierto me produce una repentina <a class=\"squiffy-link link-passage\" data-passage=\"angustia\" role=\"link\" tabindex=\"0\">angustia</a> y me quedo largo rato mirando al horizonte.</p>\n<p>Según sé ahora, en un pasado que es casi leyenda, La Gente salió de esta zona del mundo, en busca de alimentos que en el páramo eran en verdad escasos y apenas les permitían sobrevivir.</p>\n<p>Nada bueno sale gratis, por lo visto, ya que a cambio de la riqueza del pasto obtuvieron la amenaza de los Cazadores, cuyas <a class=\"squiffy-link link-passage\" data-passage=\"huellas\" role=\"link\" tabindex=\"0\">huellas</a> veo claramente marcadas en el suelo a mi alrededor. No conviene, pues, demorarse aquí y será mejor volver y explorar ese <a class=\"squiffy-link link-section\" data-section=\"camino a las flores de fuego\" role=\"link\" tabindex=\"0\">macizo de plantas extrañas y coloridas</a> que se veían del otro lado de la llanura.\n</i></p>",
		'passages': {
			'páramo': {
				'text': "<p><i>\nUna vasta extensión de suelo desnudo se extiende hasta donde la vista alcanza, apenas interrumpido por algún grupo de <a class=\"squiffy-link link-passage\" data-passage=\"plantas sonrosadas\" role=\"link\" tabindex=\"0\">plantas sonrosadas</a>.\n</i></p>",
			},
			'plantas sonrosadas': {
				'text': "<p><i>\nMe acerco a examinarlas: son champas pequeñas, hechas de tallos leves y como paja, sin apenas sustancia que huelen a... nada. Me he puesto súbitamente nervioso y he vuelto al borde de los pastos.\n</i></p>",
			},
			'angustia': {
				'text': "<p><i>\nNo comprendo de dónde me vienen estas emociones, pero ahí están, punzantes como un recuerdo triste y antiguo.\n</i></p>",
			},
			'huellas': {
				'text': "<p><i>\nNadie me ha dicho nada de las marcas que estas bestias dejan en el suelo, pero las reconozco sin problema. Desde esta mañana todo es cada vez menos extraño para mí, de una manera a la vez inquietante y vagamente reconfortante.\n</i></p>",
			},
		},
	},
	'camino a las flores de fuego': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\n{if seen el borde de los paramos:Mis pasos me traen de vuelta a la llanura, donde la cosecha aún continúa y, procurando no molestar a los aldeanos, me}{else:Me} interno con cuidado entre los pastos, siguiendo la silueta de esas plantas que se elevan por encima del pasto.</p>\n<p>Estimo que estoy a medio camino cuando, de la nada, me llega un <a class=\"squiffy-link link-passage\" data-passage=\"olor conocido\" role=\"link\" tabindex=\"0\">olor conocido</a>... y son malas noticias: ha llegado un Cazador y no está lejos.</p>\n<p>La experiencia algo me ha enseñado y me he quedado completamente inmóvil, que siempre es casi lo único que debe hacerse, puesto que estos animales son atraídos por los ruidos: ya lo he visto antes.</p>\n<p>Descubro que tengo miedo{if llevo_pistola:, esté o no armado} y el cuerpo comienza a temblarme.</p>\n<p>Desde apenas unos pasos más adelante surge de improviso el ruido del pasto quebrándose en un suspiro y \n{if llevo_pistola:entiendo que o me decido a usar mi <a class=\"squiffy-link link-section\" data-section=\"disparar a Cazador camino a las flores\" role=\"link\" tabindex=\"0\">pistola</a> o bien domino mi pánico y me <a class=\"squiffy-link link-section\" data-section=\"inmovil\" role=\"link\" tabindex=\"0\">mantengo inmóvil</a>{if seen salir corriendo:; de sobra me consta que correr no es buena estrategia}{else: o intento <a class=\"squiffy-link link-section\" data-section=\"poner pies en polvorosa\" role=\"link\" tabindex=\"0\">poner pies en polvorosa</a>}}\n{else:{if seen salir corriendo:caigo en cuenta de una buena vez que debo dominar mi pánico y <a class=\"squiffy-link link-section\" data-section=\"inmovil\" role=\"link\" tabindex=\"0\">mantenerme inmóvil</a>; de sobra me consta que correr no es buena estrategia}\n{else: titubeo entre dominar mi pánico para <a class=\"squiffy-link link-section\" data-section=\"inmovil\" role=\"link\" tabindex=\"0\">mantenerme inmóvil</a> o intentar <a class=\"squiffy-link link-section\" data-section=\"poner pies en polvorosa\" role=\"link\" tabindex=\"0\">poner pies en polvorosa</a>}}.\n</i></p>",
		'passages': {
			'olor conocido': {
				'text': "<p><i>\nEs un almizcle entre dulzón y cálido: Cazadores, sin duda.\n</i></p>",
			},
		},
	},
	'inmovil': {
		'text': "<p><i>\nTras unos instantes los ruidos desaparecen... pero hay un fuerte olor dulzón justo fente a mí.</p>\n<p>El tiempo parece detenerse.</p>\n<p>Al cabo de unos instantes escucho un cloqueo seco, seguido del ruido de pasto resquebrajado alejándose de mí.\n</i>\n{seguir hacia las flores}</p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
		},
	},
	'disparar a Cazador camino a las flores': {
		'text': "<p><i>\nCon mano temblorosa disparo hacia adelante y pronto la luz se adentra entre los tallos.</p>\n<p>Casi en seguida escucho un cloqueo iracundo seguido del ruido de pasto resquebrajado alejándose de mí.</p>\n<p>{seguir hacia las flores}\n</i></p>",
		'attributes': ["puntaje+=1","puntaje_Viajero+=1"],
		'passages': {
		},
	},
	'poner pies en polvorosa': {
		'text': "<p>{if seen salir corriendo:\n}\n<i>\nSalgo disparado en dirección a la llanura, corriendo como un imbécil, pero algo borroso se me cruza y chocamos violentamente.</p>\n<p>Aturdido, quedo tendido en el pasto, mientras la bestia se aleja a zancadas dando unos graznidos que pronto se pierden en la distancia\n</i>\n{seguir hacia las flores}</p>",
		'attributes': ["puntaje-=1"],
		'passages': {
		},
	},
	'seguir hacia las flores': {
		'text': "<p><i>\nTras varios momentos de quietud me levanto {if seen poner pies en polvorosa:con un quejido de dolor} y <a class=\"squiffy-link link-section\" data-section=\"Flores de fuego\" role=\"link\" tabindex=\"0\">sigo andando</a>.\n</i></p>",
		'passages': {
		},
	},
	'Flores de fuego': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n<i>\nAl llegar me veo frente a un enorme macizo de plantas, con <a class=\"squiffy-link link-passage\" data-passage=\"capullos\" role=\"link\" tabindex=\"0\">capullos</a> alargados que salen prácticamente del <a class=\"squiffy-link link-passage\" data-passage=\"suelo\" role=\"link\" tabindex=\"0\">suelo</a>, sin ningún tallo visible. Los capullos tienen pétalos de color violeta con estrías anaranjadas.</p>\n<p>Sus pistilos son de un índigo brillante y creo ver unas pequeñas <a class=\"squiffy-link link-passage\" data-passage=\"llamas\" role=\"link\" tabindex=\"0\">llamas</a> verdes asomando de las flores más grandes.</p>\n<p>A los pies de las flores, apretadas, se asoman unas flores más pequeñas, idénticas a los ejemplares más grandes. Alguna que otra flor pequeña crece ligeramente separada del resto, a cierta distancia de los capullos grandes y de sus llamas.</p>\n<p>En el suelo alrededor de las flores no se ven huellas de pisadas de La Gente ni tampoco hay huellas de los Cazadores.</p>\n<p></i>Ni una sola huella de esos animales.<i></p>\n<p>El <a class=\"squiffy-link link-passage\" data-passage=\"olor\" role=\"link\" tabindex=\"0\">olor</a> del lugar es mareador... pero no me causa temor, porque no hay evidencia de que las bestias vengan por aquí nunca.</p>\n<p></i>¡Porque los animales temen al fuego!<i></p>\n<p>Con una sensación de urgencia, mientras en mi mente comienza a forjarse una idea, emprendo un cuidadoso <a class=\"squiffy-link link-section\" data-section=\"El cerco de fuego\" role=\"link\" tabindex=\"0\">regreso a la aldea</a>.\n</i></p>",
		'passages': {
			'capullos': {
				'text': "<p><i>\nLos pétalos son de color violeta con estrías anaranjadas y sus pistilos son de un índigo brillante. De los capullos emana un fuerte calor y pareciera que, al moverse con el aire, se sueltan unas pequeñas chispas luminosas de polen.\n</i></p>",
			},
			'suelo': {
				'text': "<p><i>\nEl suelo es una arenilla hecha de pequeños <a class=\"squiffy-link link-passage\" data-passage=\"granos\" role=\"link\" tabindex=\"0\">granos</a> blancos, muy finos y suaves\n</i></p>",
			},
			'granos': {
				'text': "<p><i>\nLos granos son redondos, secos y ligeramente brillantes.\n</i></p>",
			},
			'llamas': {
				'text': "<p><i>\nLas llamas son de un color verde pálido y entibian el aire al rededor de las flores.\n</i></p>",
			},
			'olor': {
				'text': "<p><i>\nLas flores despiden un aroma sulfuroso, casi ígneo, intenso y penetrante.\n</i></p>",
			},
		},
	},
	'El cerco de fuego': {
		'clear': true,
		'text': "<p>{if puntaje=2: {@puntaje_memoria-=1}}\n{if puntaje=1: {@puntaje_memoria-=1}}\n{if puntaje=0: {@puntaje_memoria-=1}}\n{PUNTAJE}\n<i>\nEncuentro al anciano en la misma posición y lugar: no se ha movido en todo el día, por lo visto.</p>\n<p>Espero en silencio hasta que abre un ojo y me hace un gesto, invitándome a hablar.</p>\n<p>&quot;Mayor, he visto que los Cazadores nunca se acercan a las flores de fuego ¿Es así?&quot;, le pregunto.</p>\n<p>&quot;Es verdad&quot;, responde con sencillez.</p>\n<p>&quot;¿Siempre ha sido así?&quot;, le insisto.</p>\n<p>&quot;El calor de las flores molesta a los Cazadores y el aroma de las flores confunde su olfato, Viajero. Los Cazadores siempre las han evitado&quot;, me contesta.</p>\n<p>Golpeo mi puño en mi palma abierta, lo que al anciano, por supuesto, no le dice nada en absoluto.</p>\n<p>Me agacho y con el <a class=\"squiffy-link link-passage\" data-passage=\"ceño completamente fruncido\" role=\"link\" tabindex=\"0\">ceño completamente fruncido</a>, comienzo a dibujar líneas en el suelo, mientras le explico al anciano que La Gente ya no necesitará temerle a los Cazadores nunca más, rodeados como pronto estarán por un </i><a class=\"squiffy-link link-section\" data-section=\"La Leyenda del Viajero Prosigue\" role=\"link\" tabindex=\"0\">cerco de fuego vivo</a>.</p>",
		'attributes': ["puntaje_memoria+=1"],
		'passages': {
			'ceño completamente fruncido': {
				'text': "<p><i>\nPara La Gente, el equivalente de una sonrisa de oreja a oreja.\n</i></p>\n<!-- Interludio La Leyenda del Viajero Prosigue -->",
			},
		},
	},
	'La Leyenda del Viajero Prosigue': {
		'clear': true,
		'text': "<font face=\"papyrus\" color=\"darkgreen\"><b><blockquote>\nEl Viajero estaba cansado<br>\npor su largo periplo<br>\npero al igual que El Protector<br>\ncuando hubo despertado<br>\npronto pudo ayudar a La Gente.<br>\n<br>\nEl Viajero nos enseñó<br>\na usar las flores de fuego<br>\npara que crecieran<br>\ncomo un cerco de fuego vivo<br>\nalrededor de la aldea y los pastos.<br>\n<br>\nEl cerco ahuyentó a los Cazadores<br>\ny la vida volvió a ser fácil gracias a El Viajero.<br>\n<br>\nEl Viajero nunca exigió nada<br>\npero La Gente le regaló su amistad<br>\ny El Viajero vivió con La Gente<br>\ny aprendió de La Gente.<br>\n<br>\nY El Viajero tuvo un tiempo de paz<br>\nun tiempo de alegría e inocencia<br>\nhasta que de la mano de un Mayor<br>\n<a class=\"squiffy-link link-section\" data-section=\"Parte IV\" role=\"link\" tabindex=\"0\">debió enfrentarse a su propia Memoria...</a>.\n</blockquote></b></font>\n\n\n\n<!-- Parte IV Memoria -->\n<!-- Max Puntaje Memoria: 1 -->",
		'passages': {
		},
	},
	'Parte IV': {
		'clear': true,
		'text': "<p><font color=\"white\"></p>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"34%\" style=\"background-color:black;text-align:center;font-family:courier;\"><b><br>\nParte IV<br>\n<br>\nMemoria<br>\n<br></b></td>\n<td width=\"33%\"></td>\n</tr></table>\n</font>\n<br><br>\n<table width=\"100%\"><tr>\n<td width=\"33%\"></td>\n<td width=\"33%\"></td>\n<td width=\"33%\" style=\"text-align:right;\"><a class=\"squiffy-link link-section\" data-section=\"La llamada del Mayor\" role=\"link\" tabindex=\"0\">Continuar</a></td>\n</tr></table>",
		'passages': {
		},
	},
	'La llamada del Mayor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nMe quedo contemplando el &quot;cerco de fuego vivo&quot;, como a La Gente le gusta llamarle a esta barrera, infranqueable a los Cazadores, que rodea la aldea y los terrenos de pastos donde se realiza la cocecha.</p>\n<p>Desde su creación, el trabajo de recolección se ha transformado en un ritual diario, pero sin prisas ni temores: se ha incorporado a los niños como parte de su aprendizaje temprano, cosa antes impensada y el horario del trabajo es según necesidad o preferencia; ya nadie está pendiente de los Cazadores ni de sus costumbres a la hora de salir a recolectar.</p>\n<p>Me quedo un rato al amor de las flores de fuego y, con un suspiro de satisfacción, <a class=\"squiffy-link link-section\" data-section=\"volver a la aldea\" role=\"link\" tabindex=\"0\">regreso a la aldea</a>.</p>",
		'passages': {
		},
	},
	'volver a la aldea': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nEstoy descansando al lado de la tienda, cuando, con algo de <a class=\"squiffy-link link-passage\" data-passage=\"reluctancia\" role=\"link\" tabindex=\"0\">reluctancia</a>, se me acerca una <a class=\"squiffy-link link-passage\" data-passage=\"aldeana\" role=\"link\" tabindex=\"0\">aldeana</a>.</p>\n<p>&quot;Te saludo, Viajero&quot;, me dice con una voz <a class=\"squiffy-link link-passage\" data-passage=\"grave\" role=\"link\" tabindex=\"0\">grave</a>.</p>\n<p>&quot;Mi saludo también para ti&quot;, le respondo como buenamente <a class=\"squiffy-link link-passage\" data-passage=\"puedo\" role=\"link\" tabindex=\"0\">puedo</a>.</p>\n<p>Me mira sin decir palabra por un rato, cosa que ya no me incomoda como antes: he aprendido de los aldeanos a apreciar el silencio como algo pleno de sentido... y por lo que intuyo, no ha venido meramente a saludarme.</p>\n<p>&quot;Habrás notado que uno de los Mayores está...&quot; titubea, como buscando las palabras. &quot;...muy cansado&quot;, finaliza en voz muy baja.</p>\n<p>&quot;Así me pareció verlo hoy por la mañana&quot;, respondo, pensando en el anciano del desayuno, &quot;pero la gente Mayor suele estarlo&quot;, agrego por cortesía.</p>\n<p>&quot;No es eso, Viajero&quot;, me dice con un gesto de las manos que no reconozco. &quot;Es que el Mayor va a <a class=\"squiffy-link link-section\" data-section=\"entrar en la Memoria de La Gente\" role=\"link\" tabindex=\"0\">entrar en la Memoria de La Gente</a>.&quot;</p>",
		'passages': {
			'reluctancia': {
				'text': "<p>Por mucho que me esmere, el olor de mi tienda sigue siendo algo que La Gente tolera pero no disfruta...</p>",
			},
			'aldeana': {
				'text': "<p>He llegado al punto de notarlo por como se mueven, ya que aun no he logrado notar si acaso existen diferencias físicas.</p>",
			},
			'grave': {
				'text': "<p>O eso me parece. La forma de hablar de La Gente sigue pareciéndome melodiosa y dulce, no importando las circunstancias.</p>",
			},
			'puedo': {
				'text': "<p>Dejando de lado las sutilezas del lenguaje de La Gente, tengo una voz horrible, de tarro gastado... y eso cuando estoy descansado.</p>",
			},
		},
	},
	'entrar en la Memoria de La Gente': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nSin poder evitarlo, me he quedado <a class=\"squiffy-link link-passage\" data-passage=\"boquiabierto\" role=\"link\" tabindex=\"0\">boquiabierto</a>. Me recupero, cierro la boca y <a class=\"squiffy-link link-passage\" data-passage=\"miro al cielo\" role=\"link\" tabindex=\"0\">miro al cielo</a> en señal de respeto: me acaban de anunciar la muerte del Mayor y no atino a encontrar palabras en la lengua de La Gente para entregar condolencias o expresar mi pena.</p>\n<p>&quot;¿Tan de pronto?&quot;, atino a preguntar. &quot;En la mañana no parecía que esto fuera a pasar así, de improviso&quot;, agrego en tono turbado.</p>\n<p>Con un <a class=\"squiffy-link link-passage\" data-passage=\"leve fruncimiento de su frente\" role=\"link\" tabindex=\"0\">leve fruncimiento de su frente</a>, la aldeana me informa que &quot;Para todos ha sido una sorpresa, salvo para el Mayor: se lo ve tranquilo, como si fuera un evento largamente esperado y añorado. Es la sabiduría de nuestros Ancianos, Viajero: lo que sólo traen los largos años de vida y experiencia.&quot;</p>\n<p>Luego de otro silencio con significado, la aldeana me invita a seguirla, diciendo &quot;El Mayor quisiera hablar contigo antes de que se agote su tiempo&quot;.</p>\n<p>Y descubro que de pronto tengo miedo. No sé si quiero <a class=\"squiffy-link link-section\" data-section=\"escuchar las últimas palabras del Mayor\" role=\"link\" tabindex=\"0\">escuchar las últimas palabras del Mayor</a> o si sería mejor para mí <a class=\"squiffy-link link-section\" data-section=\"no saber\" role=\"link\" tabindex=\"0\">no saber más del asunto</a>.</p>",
		'passages': {
			'boquiabierto': {
				'text': "<p>Cosa que es el peor de los modales, entre La Gente, que lo aceptan sólo a los niños... y muy a menudo seguido de algún correctivo contundente.</p>",
			},
			'miro al cielo': {
				'text': "<p>Si llego a inclinar la cabeza sería un gesto de burla para La Gente.</p>",
			},
			'leve fruncimiento de su frente': {
				'text': "<p>Una sonrisa compasiva, o así me parece.</p>",
			},
		},
	},
	'no saber': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\n&quot;Me tendrás que disculpar con el Mayor&quot;, le respondo con un hilo de voz, &quot;pero tengo miedo de lo que el Mayor tiene para decirme.&quot;</p>\n<p>La postura de la aldeana cambia ligeramente.</p>\n<p>No parece que le haya gustado mi respuesta.</p>\n<p>Tras unos instantes, me pregunta con voz fría &quot;¿Vendrás al menos al Círculo de su Recuerdo?&quot;</p>\n<p>Turbado por su actitud, atino a responder &quot;Claro que sí. ¿Será al caer la noche?&quot;</p>\n<p>Mientras se aleja <a class=\"squiffy-link link-passage\" data-passage=\"dándome la espalda\" role=\"link\" tabindex=\"0\">dándome la espalda</a>, me responde, siseando &quot;Bastará con que sigas a la Gente.&quot;</p>\n<p>Con el corazón en un puño, la veo alejarse, mientras me dispongo a esperar a la hora en que se realizará el <a class=\"squiffy-link link-section\" data-section=\"Circulo de Recuerdo del Mayor\" role=\"link\" tabindex=\"0\">Círculo del Recuerdo del Mayor</a>.</p>",
		'attributes': ["puntaje_memoria-=1"],
		'passages': {
			'dándome la espalda': {
				'text': "<p>El equivalente de decirme algo a gritos, desconocidos para La Gente.</p>",
			},
		},
	},
	'escuchar las últimas palabras del Mayor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nNada de lo que diga le daría mayor solemnidad a mi decisión, por lo que sencillamente me pongo de pie y, sin mediar palabra, sigo a la aldeana.</p>\n<p>Avanzamos en silencio, hasta que llegamos a la tienda del Mayor, a cuya entrada varios aldeanos y aldeanas esperan, silenciosamente sentados, su turno para entrar a hablar con el Mayor.</p>\n<p>Tras un momento de indecisión y viendo que nadie hace nada salvo seguir esperando, me decido a entrar a la tienda...</p>\n<p>...que está fresca y perfumada, como si la hubieran tejido hoy mismo; mirando el <a class=\"squiffy-link link-passage\" data-passage=\"entramado\" role=\"link\" tabindex=\"0\">entramado</a>, caigo en cuenta de que ese no es en absoluto el caso: el Mayor lleva su tiempo viviendo aquí.</p>\n<p>El Mayor se encuentra tendido en el suelo y al verme entrar ha exclamado, con voz muy baja &quot;¡Ah, Viajero, has venido!&quot;</p>\n<p>Me arrodillo a su lado y le digo, muy suavemente &quot;Aquí me tienes, Mayor ¿Qué quieres de mí?&quot;</p>\n<p>Se nota que hablar le cuesta: su respiración está <a class=\"squiffy-link link-passage\" data-passage=\"agitada\" role=\"link\" tabindex=\"0\">agitada</a> y se demora en responder. Su tiempo se va agotando frente a mis ojos.</p>\n<p>&quot;Quería darte las gracias, Viajero&quot;, resuella, &quot;porque has devuelto el bienestar a La Gente.&quot;</p>\n<p>Suspira.</p>\n<p>&quot;Sabes que los Cazadores siempre han sido una amenaza&quot;, dice apenas susurrando, &quot;pero gracias a ti ya no necesitamos temerles más.&quot;</p>\n<p>&quot;Mayor&quot;, le contesto en voz baja, &quot;sin la ayuda de La Gente habría muerto de hambre, y ahora...&quot;</p>\n<p>Viendo la fragilidad del Mayor me he quedado mudo, pues no quiero ofenderlo o decirle trivialidades en estos momentos.</p>\n<p>&quot;Ahora&quot;, susurra el anciano, &quot;ahora no pasas hambre pero tienes incertidumbre de lo que vendrá mañana&quot;. Su respiración está entrecortada y demora en reunir fuerzas antes de proseguir. &quot;No sabes si la vida entre La Gente es suficiente para <a class=\"squiffy-link link-section\" data-section=\"seguir adelante\" role=\"link\" tabindex=\"0\">seguir adelante</a>.&quot;</p>",
		'attributes': ["puntaje_memoria+=1"],
		'passages': {
			'entramado': {
				'text': "<p>Ningún nudo está repetido. <i>Ni uno solo.</i> Aún no conozco el lenguaje con que teje La Gente, pero esta tienda ha de tener muchos años de trabajos y vida hilvanados en ella.</p>",
			},
			'agitada': {
				'text': "<p>Algo totalmente insólito, ya que La Gente <i>jamás</i> cambia su ritmo respiratorio, dormidos o despiertos.</p>",
			},
		},
	},
	'seguir adelante': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\n&quot;Aún no lo sé, Mayor&quot;, le respondo, &quot;y mi mente no tiene descanso buscando respuestas.&quot;</p>\n<p>&quot;Viajero&quot;, suspira, &quot;hazte presente hoy en el Círculo del Recuerdo.&quot; Nuevamente hace una pausa antes de seguir. &quot;Puede que lo que escuches te sea de ayuda.&quot;</p>\n<p>Se queda callado un rato y luego, apenas le escucho decir &quot;Adiós, Viajero. Ya no volveremos a hablar... salvo en la Memoria.&quot;</p>\n<p>Miro al cielo de la tienda en un mudo homenaje al anciano y luego me retiro.</p>\n<p>No recuerdo haber llegado a mi tienda, pero me encuentro sentado frente a ella.</p>\n<p>Con el alma en vilo, me dispongo a esperar a la hora en que se realizará el <a class=\"squiffy-link link-section\" data-section=\"Circulo de Recuerdo del Mayor\" role=\"link\" tabindex=\"0\">Círculo del Recuerdo del Mayor</a>.</p>",
		'passages': {
		},
	},
	'Circulo de Recuerdo del Mayor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nCae la noche y ha corrido la voz por toda la aldea de que el Mayor ha muerto.</p>\n<p>La noticia{if seen no saber: me trae pena y cierta resignación}{else:, curiosamente, me quita un peso del corazón y siento una suerte de expectación gozosa} por lo que ahora va a ocurrir.</p>\n<p>Veo que los aldeanos, a solas o de a dos, se dirigen hacia el borde de los páramos, así que comienzo a caminar con ellos, {if seen no saber:manteniendo las distancias para no molestarlos}{else:mezclándome sin miedo entre La Gente}.</p>\n<p>Por lo que puedo ver, sólo los niños van con un semblante triste: los adultos van con expresiones abiertamente alegres{if seen no saber:. Curioso}{else:, lo que no me sorprende, porque es así como yo me siento}.</p>\n<p>Al rato de andar nos encontramos en el borde del pastizal, cerca de los páramos, ocultos ahora tras el cerco de flores de fuego. Hay un amplio espacio circular <a class=\"squiffy-link link-passage\" data-passage=\"despejado de pasto\" role=\"link\" tabindex=\"0\">despejado de pasto</a> y los aldeanos comienzan a ubicarse con calma en su perímetro.</p>\n<p>Una vez que todos han ocupado su lugar hay un momento de espera: un silencio largo, profundo, que ni siquiera el aire que circula tibio desde el cerco de fuego parece querer perturbar.</p>\n<p>Y con la voz solitaria de un anciano, que canta con una única nota larga y suave, comienza el <a class=\"squiffy-link link-section\" data-section=\"Recuerdo del Mayor\" role=\"link\" tabindex=\"0\">Recuerdo del Mayor</a>.</p>",
		'passages': {
			'despejado de pasto': {
				'text': "<p>Probablemente lo hayan despejado durante la tarde ¿Adónde habrá ido a parar tanto pasto?</p>",
			},
		},
	},
	'Recuerdo del Mayor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nAl principio se escucha la voz solitaria del anciano, cantando y contando cómo conoció al Mayor.</p>\n<p>En completa armonía se le unen, de una en una, las voces de los demás ancianos, cada uno con su propio relato de los hechos del Mayor a lo largo de sus vidas.</p>\n<p>Esto dura un largo rato y entonces, siempre en consonancia con el tema que llevan los ancianos, aparecen las voces de los adultos: sus cantos son más breves, pero están entretejidos con las voces de los Mayores, aportando con pequeñas viñetas de lo que fue e hizo el Mayor.</p>\n<p>Intentando no desentonar demasiado, con voz {if seen no saber:tímida y apagada}{else:fuerte y segura}, canto mi propia canción: la ayuda del Mayor cuando casi me moría de hambre, su {if seen no saber:amabilidad}{else:amabilidad y consejos} en los días en que lo conocí.</p>\n<p>Por último, aparecen las vocecitas de los niños, breves trinos de alegría sobre la sencillez y felicidad de la vida de La Gente, una dicha que la muerte del Mayor no {if seen no saber:parece empañar}{else:hace sino hacer más profunda}.</p>\n<p>La voz de toda La Gente se reúne por fin, formando un enorme coro de voces, ora lentas y majestuosas, ora más rápidas y gorjeantes, cantando un tema único hecho de tantas canciones y voces como vidas tocó la del Mayor.</p>\n<p>Sin dejar de cantar, los aldeanos van dejando el círculo y regresan a la aldea, de a uno o de a dos. Sus voces van apagándose según se acercan a sus tiendas, callando ya del todo una vez ha entrado cada cual en su hogar.</p>\n<p>La última voz en desaparecer es la del anciano que inició el canto, anunciando que ahora es el Mayor de La Gente y que el resto de su vida ha de ser al servicio de los aldeanos.</p>\n<p>Mientras, en el interior de mi tienda, mi mente se debate con <a class=\"squiffy-link link-section\" data-section=\"una decisión largamente postergada\" role=\"link\" tabindex=\"0\">una decisión largamente postergada</a>.</p>",
		'passages': {
		},
	},
	'una decisión largamente postergada': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nYa no es el cansancio.</p>\n<p>Ya no es el hambre.</p>\n<p>Es la duda sobre si seguir en este planeta o intentar volver\n{if puntaje_memoria=-1: a casa.}\n{if puntaje_memoria=0: a casa.}\n{if puntaje_memoria=1: a casa.}\n{if puntaje_memoria=2: a casa.}\n{if puntaje_memoria=3:...¿a casa?}\n{if puntaje_memoria=4:...¿a casa? ¿Dónde está eso, ahora?}\n{if puntaje_memoria=5:...¿a casa? ¿Dónde está eso, ahora, si no es con La Gente?}</p>\n<p>De cualquier manera, para resolverlo necesito volver a la cápsula de escape y ver {if derrame_minireactor:si después del lío con el <a class=\"squiffy-link link-passage\" data-passage=\"minirreactor\" role=\"link\" tabindex=\"0\">minirreactor</a> aún tengo opciones}{else:cuáles son mis <a class=\"squiffy-link link-passage\" data-passage=\"opciones\" role=\"link\" tabindex=\"0\">opciones</a>}.</p>\n<p>Y si al mal paso hay que darle prisa, entonces se impone <a class=\"squiffy-link link-section\" data-section=\"salir de noche\" role=\"link\" tabindex=\"0\">salir de noche</a>, ahora mismo... o evitar <a class=\"squiffy-link link-passage\" data-passage=\"riesgos\" role=\"link\" tabindex=\"0\">riesgos</a> con los Cazadores y <a class=\"squiffy-link link-section\" data-section=\"esperar a la mañana\" role=\"link\" tabindex=\"0\">esperar a la mañana</a>.</p>",
		'passages': {
			'minirreactor': {
				'text': "<p>Vaya uno a saber si, visto cómo salí de la cápsula, aún tiene combustible viable para algo.</p>",
			},
			'opciones': {
				'text': "<p>Fui cuidadoso al salir de la cápsula, así que aún debe tener combustible viable para operaciones básicas.</p>",
			},
			'riesgos': {
				'text': "<p>De día los Cazadores ya no se dejan ver cerca de la barrera de flores de fuego... pero hemos encontrado cadáveres asados por la mañana, así que de noche aún están intentando entrar.</p>",
			},
		},
	},
	'salir de noche': {
		'text': "<p>La verdad no creo poder dormir tranquilo esta noche, así que me pongo de pie y camino por entre las chozas, sigo a través de la llanura de pasto en dirección al cráter y llego por fin hasta el borde exterior de los pastos.</p>\n<p>Frente a mí está la única sección de esta barrera incandecente que podría cruzarse a pie, donde mantenemos abierta una brevísima brecha...</p>\n<p>...y caigo en cuenta de un <i>pequeño</i> detalle que he pasado por alto: para ensanchar esta rendija hay que usar unas gruesas mantas trenzadas, empujando las plantas en cada costado y poder así cruzar al otro lado; tarea esta de al menos cinco personas.</p>\n<p>Y yo estoy solo.</p>\n<p>{if seen no saber:Maldiciendo mi propia estupidez}{else:Riéndome de mi tontería, fruto quizá de las emociones del día}, emprendo el regreso a la aldea hasta llegar a mi tienda, donde me recuesto y, con algo de impaciencia, espero a que llegue el <a class=\"squiffy-link link-section\" data-section=\"amanecer\" role=\"link\" tabindex=\"0\">amanecer</a>.</p>",
		'passages': {
		},
	},
	'esperar a la mañana': {
		'text': "<p>Suspiro. Unas horas más o menos no afectarán los sistemas de la cápsula, estén en el estado que estén.</p>\n<p>Por otra parte, en el linde de las llanuras camino del cráter es necesario atravesar una brevísima brecha que mantenemos en la barrera; para ensanchar esa rendija hay que usar unas gruesas mantas trenzadas, empujando las plantas en cada costado y poder así cruzar al otro lado...</p>\n<p>...tarea esta de al menos cinco personas y a esta hora, especialmente en un día como hoy, no se me ocurriría molestar a los aldeanos.</p>\n<p>Resignado, entro a mi tienda, me recuesto y, buscando el sueño {if seen no saber:que seguro me será esquivo}{else: con el murmullo del aire que viene de la llanura}, espero a que llegue el <a class=\"squiffy-link link-section\" data-section=\"amanecer\" role=\"link\" tabindex=\"0\">amanecer</a>.</p>",
		'passages': {
		},
	},
	'amanecer': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nHace poco que amaneció y como ya escucho a La Gente yendo de allá para acá, me decido a buscar ayuda.</p>\n<p>Me dirijo con cierta prisa al lugar donde los aldeanos se reúnen a desayunar, avanzando <a class=\"squiffy-link link-passage\" data-passage=\"con tiento\" role=\"link\" tabindex=\"0\">con tiento</a> entre las tiendas: no me gustaría encontrarme conque no quede nadie y esperar a que termine la cosecha del día para contar con <a class=\"squiffy-link link-passage\" data-passage=\"manos desocupadas\" role=\"link\" tabindex=\"0\">manos desocupadas</a>.</p>\n<p>Al llegar al círculo del desayuno compruebo con alivio que todavía hay aldeanos comiendo y que algunos son <a class=\"squiffy-link link-passage\" data-passage=\"jóvenes\" role=\"link\" tabindex=\"0\">jóvenes</a>, lo que es tanto más <a class=\"squiffy-link link-passage\" data-passage=\"conveniente\" role=\"link\" tabindex=\"0\">conveniente</a>.</p>\n<p>De hecho, uno de los muchachos, al ver que no me he sentado a comer, se me acerca y me pregunta &quot;¿Es que no vas a comer esta mañana, Viajero?&quot; Su tono de voz es muy <a class=\"squiffy-link link-passage\" data-passage=\"respetuoso\" role=\"link\" tabindex=\"0\">respetuoso</a>, parecido al que se usa para dirigirse a los Mayores.</p>\n<p>&quot;No esta mañana&quot;, le contesto, &quot;ya que tengo asuntos que atender en el cráter y debo aprovechar el día si quiero volver antes de que oscurezca.&quot;</p>\n<p>Sin mediar más palabras, el muchacho vuelve la mirada a otros tres jóvenes que están desayunando. No alcanzo a ver qué gesto les ha hecho, pero se han levantado en el acto y se nos acercan decididos.</p>\n<p>&quot;Te ayudaremos, Viajero&quot;, dice resueltamente el joven que parece llevar la voz del grupo.</p>\n<p>La verdad, me {if seen no saber:sorprende}{else:conmueve} la amabilidad de estos muchachos y sería descortés {if seen no saber:(y hasta tonto)} no <a class=\"squiffy-link link-section\" data-section=\"salir al crater\" role=\"link\" tabindex=\"0\">aceptar su ofrecimiento</a>.</p>",
		'passages': {
			'con tiento': {
				'text': "<p>Aunque dudo que alguien esté durmiendo aún, no es cuestión de pasar a llevar el hogar de alguien por descuido.</p>",
			},
			'manos desocupadas': {
				'text': "<p>Casi todos los aldeanos suelen participar de la cosecha por la mañana. Aunque ya no hay preocupación por los Cazadores, algunas costumbres no pueden cambiar de un día para otro.</p>",
			},
			'jóvenes': {
				'text': "<p>He aprendido a reconocer esa piel a medio camino entre las arrugas de los niños y la piel lisa de los adultos.</p>",
			},
			'conveniente': {
				'text': "<p>La plantación y cuidado de la barrera fue tarea de los adultos y de los jóvenes, los que se han mostrado menos temerosos con su mantención. Eso viene bien si vamos a ensanchar la brecha.</p>",
			},
			'respetuoso': {
				'text': "<p>Si bien muchos aldeanos me han demostrado su agradecimiento, con pequeños gestos como traerme semillas para el desayuno, los jóvenes en general se han mostrado abiertamente interesados por mis actividades.</p>",
			},
		},
	},
	'salir al crater': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nDejamos, pues el círculo del desayuno y nos ponemos en camino, avanzando entre las chozas, cruzando luego la llanura de pasto en dirección al cráter para llegar por último hasta el borde exterior de los pastos, donde está la brecha que se mantiene en la barrera.</p>\n<p>He estado a punto de abrir la boca para preguntar dónde están las mantas trenzadas cuando, detrás de nosotros, aparece de pronto otro muchacho que porta cuatro gruesas mantas de pasto <a class=\"squiffy-link link-passage\" data-passage=\"trenzado\" role=\"link\" tabindex=\"0\">trenzado</a>.</p>\n<p>Nadie más que yo se muestra <a class=\"squiffy-link link-passage\" data-passage=\"sorprendido\" role=\"link\" tabindex=\"0\">sorprendido</a>.</p>\n<p>Dejando con cuidado las mantas en el suelo, el recién llegado echa una manta en el espacio de suelo desnudo de la brecha y se queda agachado para <a class=\"squiffy-link link-passage\" data-passage=\"sostenerla\" role=\"link\" tabindex=\"0\">sostenerla</a> en su sitio.</p>\n<p>Siempre en silencio, los otros cuatro jóvenes cogen una manta cada uno y con sumo cuidado, primero dos de un costado y luego dos del otro, avanzan sobre la manta recién colocada y empujan luego los costados de la brecha hasta ensancharla lo suficiente para que yo pueda pasar entre ellos.</p>\n<p>Mientras me muevo lentamente por la brecha, procurando no empujar a los muchachos, uno de ellos pregunta &quot;¿Venimos por ti al atardecer, Viajero?&quot;</p>\n<p>&quot;Al atardecer&quot;, confirmo con voz {if seen no saber:tensa}{else:queda}, mientras dejo atrás la barrera y avanzo en dirección al <a class=\"squiffy-link link-section\" data-section=\"regreso al borde del crater\" role=\"link\" tabindex=\"0\">borde del cráter</a>.</p>",
		'passages': {
			'trenzado': {
				'text': "<p>Por lo poco que entiendo, el nudo del trenzado, repetido en toda las mantas, dice algo así como &quot;Cuidado con quemarte las manos&quot;. La Gente, siempre práctica.</p>",
			},
			'sorprendido': {
				'text': "<p>Me estoy empezando a formar una idea más clara de hasta qué punto mis actividades interesan a los jóvenes aldeanos.</p>",
			},
			'sostenerla': {
				'text': "<p>El suelo bajo la manta ha de estar bastante caliente.</p>",
			},
		},
	},
	'regreso al borde del crater': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nEstoy en el borde exterior del cráter, mirando el <a class=\"squiffy-link link-passage\" data-passage=\"erial\" role=\"link\" tabindex=\"0\">erial</a> de desolación contenido por sus límites.</p>\n<p>El sol aún no está en alto, por suerte, por lo que no se distingue demasiado <a class=\"squiffy-link link-passage\" data-passage=\"detalle\" role=\"link\" tabindex=\"0\">detalle</a> en su superficie. La <a class=\"squiffy-link link-passage\" data-passage=\"baliza\" role=\"link\" tabindex=\"0\">baliza</a> de la cápsula, por el contrario, se ve claramente a un par de kilómetros dentro del cráter.</p>\n<p>Debo aprovechar que es temprano y seguir mi marcha antes de que empiece a hacer calor, así que busco una bajada lo menos accidentada posible y desciendo con cuidado.</p>\n<p>Una vez que he llegado al suelo nivelado, debo optar entre <a class=\"squiffy-link link-section\" data-section=\"avanzar rapidamente\" role=\"link\" tabindex=\"0\">avanzar rápidamente</a>, a riesgo de tropezar por la poca luz o bien <a class=\"squiffy-link link-section\" data-section=\"avanzar lentamente\" role=\"link\" tabindex=\"0\">ir con más cuidado</a> y evitarme algún accidente.</p>",
		'passages': {
			'erial': {
				'text': "<p>El suelo se ve resquebrajado y reseco, tal como estaba cuando llegué: hasta donde alcanza la vista, no se ve vegetación alguna dentro del cráter.</p>",
			},
			'detalle': {
				'text': "<p>Me parece ver {if visto_fragmentos: los extraños fragmentos que encontré la vez pasada, cuando salí del cráter.}{else:algunas rocas a lo lejos, pero a esta distancia no puedo estar seguro}.</p>",
			},
			'baliza': {
				'text': "<p>La luz automática de la baliza de la cápsula, parpadeando en rojo, amarillo y blanco, se distingue sin problemas, {if derrame_minireactor:pero titilando en forma más bien irregular: mala}{else:titilando con una frecuencia constante y regular: buena} señal, de momento.</p>",
			},
		},
	},
	'avanzar rapidamente': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nA la luz creciente del amanecer puedo ver con un poco más de detalle; {if visto_fragmentos: los fragmentos}{else:las rocas más bien parecen fragmentos <i>artificiales</i>}, que se hacen más frecuentes a medida que me alejo del borde del cráter.</p>\n<p>{if visto_fragmentos: Ya los he visto antes y no me detengo a examinarlos:}{else:De acercarme a ellos vería más detalles, pero} llevo prisa... lo que me ha costado un par de tropiezos: nada grave, pero me gano algunas heridas menores por el apuro.</p>\n<p>Caminando a paso vivo, sigo ganando terreno y pronto <a class=\"squiffy-link link-section\" data-section=\"capsula\" role=\"link\" tabindex=\"0\">llego a la cápsula</a>.</p>",
		'passages': {
		},
	},
	'avanzar lentamente': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nA la luz creciente del amanecer puedo ver con un poco más de detalle.</p>\n<p>Entre las <a class=\"squiffy-link link-passage\" data-passage=\"nubes\" role=\"link\" tabindex=\"0\">nubes</a> del cielo {if visto_flotadores: se ve un grupo de <a class=\"squiffy-link link-passage\" data-passage=\"globos\" role=\"link\" tabindex=\"0\">flotadores</a>}{else: hay... algo más, como formas <i>enormes</i>, parecidas a <a class=\"squiffy-link link-passage\" data-passage=\"globos\" role=\"link\" tabindex=\"0\">globos</a>}.</p>\n<p>{if visto_fragmentos:Los fragmentos no han cambiado en absoluto y se vuelven más frecuentes a medida que me alejo del borde del cráter}{else:Por otra parte, o que yo creía que eran rocas en realidad son <a class=\"squiffy-link link-passage\" data-passage=\"fragmentos\" role=\"link\" tabindex=\"0\">fragmentos</a>... que no parecen naturales. De hecho, se vuelven más frecuentes a medida que me alejo del borde del cráter... y no parecen ser de origen natural}.</p>\n<p>Sin querer me he distraído con el paisaje, así que apuro el paso y al cabo de una hora <a class=\"squiffy-link link-section\" data-section=\"capsula\" role=\"link\" tabindex=\"0\">llego a la cápsula</a>.</p>",
		'passages': {
			'nubes': {
				'text': "<p>De colores rojo y escarlata, flotan lentamente por el cielo, tomando una y otra vez formas curiosas.</p>",
			},
			'globos': {
				'text': "<p>{if visto_flotadores:Nadie, ni siquiera los Ancianos, sabe de dónde vienen. \n Los flotadores se mueven muy lentamente, a veces atravesando las nubes, otras veces rodeándolas y consumiéndolas de a poco. Dónde están cuando nadie les ve es un misterio.</p>\n<p>La Gente se puede pasar horas contemplándolos.}{else:Sean lo que sean esos globos, son grandes y redondos, translúcidos y de una apariencia etérea. No están quietos, pero se mueven en forma casi imperceptible, a veces atravesando las nubes, otras veces rodeándolas y consumiéndolas lentamente...</p>\n<p>La Gente se debe pasar horas contemplándolos.}</p>",
			},
			'fragmentos': {
				'text': "<p>Examinándolos de cerca, parecen estar incrustados en el suelo, el que se transparenta en su contacto y permite ver formas difusas bajo su superficie reseca.</p>\n<p>Algunos fragmentos son grandes, y se parecen a partes de un fuselaje de una astronave; otros, más pequeños, parecen afilados dientes, saliendo del suelo en ángulos extraños.</p>\n<p>{if visto_fragmentos:}{else:Por lo visto otros viajeros que se acercaron a este mundo también corrieron mi suerte, pero en estos despojos no se distingue ningún detalle que permita inferir de dónde venían.}</p>",
			},
		},
	},
	'capsula': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nLa cápsula quedó semienterrada en el suelo del cráter.</p>\n<p>{if derrame_minireactor:Estoy algo preocupado por la radioactividad que expulsó el reactor después del aterrizaje, pero miro mi <a class=\"squiffy-link link-passage\" data-passage=\"reloj\" role=\"link\" tabindex=\"0\">reloj</a> y no veo ninguna señal de alerta... lo que no sé si me tranquiliza, la verdad}{else:Todo está tal cual lo dejé: apenas hay algo de polvo posado en el fuselaje de la cápsula y, por lo que veo en mi <a class=\"squiffy-link link-passage\" data-passage=\"reloj\" role=\"link\" tabindex=\"0\">reloj</a>, no hay radioactividad, así que el reactor no ha tenido fallas de contención, lo que resulta esperanzador}.</p>\n<p>Mientras inspecciono la cápsula,{if visto_trozo_capsula: compruebo que no se ven partes del <a class=\"squiffy-link link-passage\" data-passage=\"fuselaje\" role=\"link\" tabindex=\"0\">fuselaje</a> por los alrededores}{else: descubro <a class=\"squiffy-link link-passage\" data-passage=\"escudo de reingreso\" role=\"link\" tabindex=\"0\">algo blanco</a> en el suelo aquí cerca}. \nEncima de la cápsula puedo ver la baliza brillando con {if derrame_minireactor:algo menos de}{else:la misma} \npotencia que recuerdo cuando aterricé{if derrame_minireactor:: puede que no esté todo en orden a bordo}{else:, titilando con una frecuencia constante y regular: todo en orden, de momento}.</p>\n<p>{if derrame_minireactor:No del todo satisfecho}{else:Satisfecho} con mi inspección, me dirijo a la esclusa {if puerta_volada:que encuentro abierta de par en par: tuve que volar la puerta externa para salir. Sin más obstáculos, atravieso la esclusa y <a class=\"squiffy-link link-section\" data-section=\"interior de la capsula\" role=\"link\" tabindex=\"0\">entro en la cápsula</a>}{else:para <a class=\"squiffy-link link-section\" data-section=\"entrar a la capsula\" role=\"link\" tabindex=\"0\">entrar a la cápsula</a>}.</p>",
		'passages': {
			'reloj': {
				'text': "<p>De haber {if derrame_minireactor:ocurrido una nueva}{else:alguna} fuga de material radioactivo, antes de un kilómetro mi reloj habría hecho vibrar mi muñeca como si tuviera calambres.</p>",
			},
			'fuselaje': {
				'text': "<p>Excepto por el escudo de reingreso, que se quemó durante el aterrizaje, todo parece estar en su sitio.</p>",
			},
			'escudo de reingreso': {
				'text': "<p>Me acerco y veo que es un trozo de la cápsula, doblado por el calor y chamuscado en los bordes; parte del escudo de reingreso, sin duda.</p>\n<p>Intento doblarlo un poco pero se deshace en mis manos.</p>\n<p>Miro los pequeños restos que caen al suelo y me asombra el haber salido vivo del aterrizaje...</p>",
			},
		},
	},
	'entrar a la capsula': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nLa luz de la puerta exterior sigue encendida y de {if derrame_minireactor:<a class=\"squiffy-link link-passage\" data-passage=\"color amarillo\" role=\"link\" tabindex=\"0\">color amarillo</a>, lo que no es buena señal}{else:<a class=\"squiffy-link link-passage\" data-passage=\"color verde\" role=\"link\" tabindex=\"0\">color verde</a>; buenas noticias}.</p>\n<p>La puerta en sí se ve entera, pero los bordes del sello estanco se han <a class=\"squiffy-link link-passage\" data-passage=\"desmenuzado\" role=\"link\" tabindex=\"0\">desmenuzado</a> por completo.</p>\n<p>Abro la puerta exterior, atravieso la esclusa y <a class=\"squiffy-link link-section\" data-section=\"interior de la capsula\" role=\"link\" tabindex=\"0\">entro en la cápsula</a>.</p>",
		'passages': {
			'color amarillo': {
				'text': "<p>Hay un cierto nivel de radioactividad residual en el ambiente. Si mi reloj no me ha avisado, no debe ser nada grave.</p>",
			},
			'color verde': {
				'text': "<p>No hay radioactividad residual en el ambiente. El reactor no ha tenido absolutamente ninguna pérdida: excelente.</p>",
			},
			'desmenuzado': {
				'text': "<p>Cumplió su función durante el ingreso a la atmósfera y sencillamente se ha degradado.</p>",
			},
		},
	},
	'interior de la capsula': {
		'clear': true,
		'text': "<p>{if puntaje_memoria=-1:{@decision_final=0}}\n{if puntaje_memoria=0:{@decision_final=1}}\n{if puntaje_memoria=1:{@decision_final=1}}\n{if puntaje_memoria=2:{@decision_final=2}}\n{if puntaje_memoria=3:{@decision_final=2}}\n{if puntaje_memoria=4:{@decision_final=3}}\n{if puntaje_memoria=5:{@decision_final=3}}\n{PUNTAJEMEMORIA}\nMiro a mi alrededor y el interior de la cápsula de escape sigue sin cambios desde que la abandoné, hace casi un año, aunque a mí me parezca que fue ayer.  {if decision_final=0:La verdad, pese a todo lo que ha pasado, cierto un cierto alivio al encontrarme de vuelta.}\n{if decision_final=1:Curiosamente y con todo lo que ha pasado, siento una cierta incomodidad al encontrarme de vuelta.}\n{if decision_final=2:Curiosamente y con todo lo que ha pasado, no estoy seguro de alegrarme de estar de vuelta.}\n{if decision_final=3:La verdad, siento un profundo desasosiego ahora que estoy de vuelta, como si ya el lugar no me perteneciera... ni yo a él.}</p>\n<p>La quietud de la cabina es total, como la de una tumba y las vainas de seguridad de mis infortunados compañeros siguen actuando como <a class=\"squiffy-link link-passage\" data-passage=\"cinerarios\" role=\"link\" tabindex=\"0\">cinerarios</a> de sus restos.</p>\n<p>Antes de continuar, guardo un minuto de silencio{if decision_final=2: y, sin darme apenas cuenta de lo que hago, <a class=\"squiffy-link link-passage\" data-passage=\"miro hacia el techo\" role=\"link\" tabindex=\"0\">miro hacia el techo</a>}{if decision_final=3: y, con un nudo en la garganta, <a class=\"squiffy-link link-passage\" data-passage=\"miro hacia el techo\" role=\"link\" tabindex=\"0\">miro hacia el techo</a>}, ya que ellos nunca lograron ver el cielo de este mundo{if decision_final=1:  ni su extraña belleza}{if decision_final=2: ni su maravillosa belleza}{if decision_final=3: ni su serena belleza, ni pudieron conocer la sencilla sabiduría de La Gente}.</p>\n<p>{if derrame_minireactor:{decision sin reactor}}{else:{decision con reactor}}</p>",
		'passages': {
			'cinerarios': {
				'text': "<p>Donde estaban sus cuerpos calcinados apenas quedan algunos restos de plástico y metal que sobresalen de sus cenizas, frías hace ya tiempo.</p>",
			},
			'miro hacia el techo': {
				'text': "<p>El gesto de respeto de La Gente es en verdad lo más apropiado para el lugar donde vinieron a morir.</p>",
			},
		},
	},
	'decision sin reactor': {
		'text': "<p>Mi mirada se posa en el panel de mandos, del que emana una luz roja\n{if decision_final=0: y me dispongo a poner <a class=\"squiffy-link link-section\" data-section=\"decision final sin reactor\" role=\"link\" tabindex=\"0\">manos a la obra</a>}\n{if decision_final=1: y, con cierta retisencia, pongo <a class=\"squiffy-link link-section\" data-section=\"decision final sin reactor\" role=\"link\" tabindex=\"0\">manos a la obra</a>}\n{if decision_final=2: y, no demasiado seguro de lo que quiero, reviso la <a class=\"squiffy-link link-section\" data-section=\"decision final sin reactor\" role=\"link\" tabindex=\"0\">lectura de la pantalla</a>}\n{if decision_final=3:... y no sé si quiero seguir adelante con esto. Ahora que estoy aquí, no estoy seguro de si venir fue una buena idea. Con todo, necesito saber cuáles son mis opciones, así que reviso la <a class=\"squiffy-link link-section\" data-section=\"decision final sin reactor\" role=\"link\" tabindex=\"0\">lectura de la pantalla</a>}.</p>",
		'passages': {
		},
	},
	'decision con reactor': {
		'text': "<p>Mi mirada se posa en el panel de mandos, del que emana una luz verde\n{if decision_final=0: y me dispongo a poner <a class=\"squiffy-link link-section\" data-section=\"decision final con reactor\" role=\"link\" tabindex=\"0\">manos a la obra</a>}\n{if decision_final=1: y, con cierta retisencia, pongo <a class=\"squiffy-link link-section\" data-section=\"decision final con reactor\" role=\"link\" tabindex=\"0\">manos a la obra</a>}\n{if decision_final=2: y, no demasiado seguro de lo que quiero, reviso la <a class=\"squiffy-link link-section\" data-section=\"decision final con reactor\" role=\"link\" tabindex=\"0\">lectura de la pantalla</a>}\n{if decision_final=3:... y no sé si quiero seguir adelante con esto. Ahora que estoy aquí, no estoy seguro de si venir fue una buena idea. Con todo, necesito saber cuáles son mis opciones, así que reviso la <a class=\"squiffy-link link-section\" data-section=\"decision final con reactor\" role=\"link\" tabindex=\"0\">lectura de la pantalla</a>}.</p>",
		'passages': {
		},
	},
	'decision final sin reactor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\n{if decision_final=0:La lectura de la pantalla del panel es demoledora:}\n{if decision_final=1:La lectura de la pantalla del panel es desmoralizante:}\n{if decision_final=2:La lectura de la pantalla del panel es preocupante:}\n{if decision_final=3:La lectura de la pantalla del panel es contundente:}</p>\n<p><table width=\"100%\" style=\"background-color:black;border:none;\"></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\"><br></td></p>\n<p><td width=\"15%\"></td>\n</tr></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\" style=\"background-color:red;color:yellow;text-align:center;font-family:consolas;\"><br><b>\n&nbsp;PÉRDIDA DE COMBUSTIBLE DURANTE ATERRIZAJE&nbsp;<br>\n&nbsp;SISTEMAS DE COMUNICACIÓN COMPROMETIDOS&nbsp;<br>\n</b><br></td></p>\n<p><td width=\"15%\"></td>\n</tr></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\" style=\"color:white;text-align:left;font-family:consolas;\"><br><b>\nFAVOR DE SELECCIONAR:<br>\n¿INICIAR RADIOFARO RESCATE?<br>\n¿APAGAR SISTEMAS?<br>\n</b><br></td></p>\n<p><td width=\"15%\"></td>\n</tr>\n</table>\n<br><br>\n{if decision_final=0:Mis opciones son malas y el resultado incierto.</p>\n<p>Un radiofaro defectuoso o poco permanente no es garantía alguna de rescate... y la alternativa de quedarme en este planeta extraño para siempre no me seduce especialmente.</p>\n<p>Tengo la posibilidad <i>remota</i> de volver a casa o la certeza <b>absoluta</b> de pasar el resto de mis días lejos de mi hogar, en un lugar demasiado tranquilo, que sé que me resultará, al cabo de un tiempo, intolerable por la monotonía.</p>\n<p>Ninguna alternativa es particularmente halagüeña.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">soñar con el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">quedarme como prisionero</a> de este mundo?\n}\n{if decision_final=1:Mis opciones son de resultado incierto.</p>\n<p>Un radiofaro defectuoso no es una garantía de rescate... y la alternativa es quedarme en este planeta extraño para siempre.</p>\n<p>Tengo una posibilidad <i>escaza</i> de volver a casa o la certeza <b>absoluta</b> de pasar el resto de mis días lejos de mi hogar: en un lugar tranquilo, es verdad, pero que no sé si me será tolerable por la monotonía.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">soñar con el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">resignarme a pasar mi vida</a> en este mundo?}\n{if decision_final=2:Mis opciones son de resultado incierto, pero no son tan malas.</p>\n<p>Un radiofaro defectuoso no es una garantía de rescate y la alternativa es quedarme en este hermoso planeta... lo que no me parece tan malo, la verdad.</p>\n<p>La posibilidad de volver a casa es muy baja y a cambio podría pasar el resto de mis días en un lugar tranquilo: lejos de mi hogar... aunque no sé si me iría mucho mejor, a mi regreso, si llegaran a rescatarme.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">apostar por el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">aprender a vivir</a> en este mundo?}\n{if decision_final=3:Mis opciones son de resultado incierto... y no sólo para mí.</p>\n<p>Un radiofaro defectuoso no es una garantía de rescate y la alternativa es quedarme en esta isla de paz... y aprender de La Gente a ser feliz con una vida sencilla.</p>\n<p>La posibilidad de volver a casa es muy baja, pero de ser rescatado es muy posible que se modifique el modo de vivir de La Gente.</p>\n<p>Y eso, para este pueblo, podría ser peor que la muerte.</p>\n<p>¿Vale la pena <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">arriesgar a La Gente con mi rescate</a> o es mejor <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">abrazar la vida</a> en este mundo?}</p>",
		'passages': {
		},
	},
	'decision final con reactor': {
		'clear': true,
		'text': "<p>{PUNTAJEMEMORIA}\nLa lectura del panel es tranquilizadora:</p>\n<p><table width=\"100%\" style=\"background-color:black;border:none;\"></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\"><br></td></p>\n<p><td width=\"15%\"></td>\n</tr></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\" style=\"background-color:green;color:black;text-align:center;font-family:consolas;\"><br><b>\n&nbsp;COMBUSTIBLE SIN PÉRDIDAS POSTATERRIZAJE&nbsp;<br>\n&nbsp;SISTEMAS DE COMUNICACIÓN DISPONIBLES&nbsp;<br>\n</b><br></td></p>\n<p><td width=\"15%\"></td>\n</tr></p>\n<p><tr></p>\n<p><td width=\"15%\"></td></p>\n<p><td width=\"70%\" style=\"color:white;text-align:left;font-family:consolas;\"><br><b>\nFAVOR DE SELECCIONAR:<br>\n¿INICIAR RADIOFARO RESCATE?<br>\n¿APAGAR SISTEMAS?<br>\n</b><br></td></p>\n<p><td width=\"15%\"></td>\n</tr>\n</table>\n<br><br>\n{if decision_final=0:Mis opciones no son malas, aunque el resultado no está garantizado.</p>\n<p>Un radiofaro permanente no es garantía alguna de rescate... y la alternativa de quedarme en este planeta extraño para siempre no me seduce especialmente.</p>\n<p>Tengo una <i>posibilidad</i> de volver a casa o la certeza <b>absoluta</b> de pasar el resto de mis días lejos de mi hogar, en un lugar demasiado tranquilo, que sé que me resultará, al cabo de un tiempo, intolerable por la monotonía.</p>\n<p>Ninguna alternativa es particularmente halagüeña.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">apostar por el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">quedarme como prisionero</a> de este mundo?\n}\n{if decision_final=1:Mis opciones son de resultado incierto.</p>\n<p>Un radiofaro funcional no es una garantía de rescate... y la alternativa es quedarme en este planeta extraño para siempre.</p>\n<p>Tengo una <i>posibilidad</i> de volver a casa o la certeza <b>absoluta</b> de pasar el resto de mis días lejos de mi hogar: en un lugar tranquilo, es verdad, pero que no sé si me será tolerable por la monotonía.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">soñar con el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">resignarme a pasar mi vida</a> en este mundo?}\n{if decision_final=2:Mis opciones son <i>técnicamente</i> buenas y de resultado incierto, pero no son tan malas.</p>\n<p>Un radiofaro en funciones no es una garantía de rescate y la alternativa es quedarme en este hermoso planeta... lo que no me parece tan malo, la verdad.</p>\n<p>La posibilidad de volver a casa es baja y a cambio podría pasar el resto de mis días en un lugar tranquilo: lejos de mi hogar... aunque no sé si me iría mucho mejor, a mi regreso, si llegaran a rescatarme.</p>\n<p>¿Puedo <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">apostar por el rescate</a> o debo <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">aprender a vivir</a> en este mundo?}\n{if decision_final=3:Mis opciones son <i>técnicamente</i> buenas, aunque de resultado incierto... y no sólo para mí.</p>\n<p>Un radiofaro en funciones no es una garantía de rescate y la alternativa es quedarme en esta isla de paz... y aprender de La Gente a ser feliz con una vida sencilla.</p>\n<p>La posibilidad de volver a casa es baja, pero de ser rescatado es muy posible que se modifique el modo de vivir de La Gente.</p>\n<p>Y eso, para este pueblo, podría ser peor que la muerte.</p>\n<p>¿Vale la pena <a class=\"squiffy-link link-section\" data-section=\"radiofaro\" role=\"link\" tabindex=\"0\">arriesgar a La Gente con mi rescate</a> o es mejor <a class=\"squiffy-link link-section\" data-section=\"quedarse\" role=\"link\" tabindex=\"0\">abrazar la vida</a> en este mundo?}</p>",
		'passages': {
		},
	},
	'radiofaro': {
		'clear': true,
		'text': "<p>{if decision_final=0:Sin saber si voy a conseguir algo, como lanzando un mensaje en una botella,}\n{if decision_final=1:A sabiendas de que no hay garantía de éxito,}\n{if decision_final=2:Con sentimientos encontrados,}\n{if decision_final=3:Sabiendo que estoy poniendo en riesgo la felicidad de La Gente... y la mía propia, en verdad,}\nactivo el radiofaro de rescate de la cápsula.</p>\n<p>Se escucha un zumbido y la pantalla del panel radiofaro se actualiza:</p>\n<p>{if derrame_minireactor:{radiofaro sin reactor}}{else:{radiofaro con reactor}}</p>\n<p>Bueno, ya está.</p>\n<p>Salgo al exterior y puedo comprobar que, junto a la baliza, del fuselaje de la cápsula ha surgido una robusta antena...</p>\n<p>...y la luz de la baliza ya no está encendida.</p>\n<p>Es igual.</p>\n<p>No voy a volver a este sitio nunca más: si alguna vez vienen a rescatarme me ubicarán por mi reloj{if decision_final=3:...y no sé si ese será un buen día para La Gente}.</p>\n<p>Con un suspiro {if decision_final=3:y algo de pena} emprendo <a class=\"squiffy-link link-section\" data-section=\"final neutro\" role=\"link\" tabindex=\"0\">el regreso a la aldea</a>.</p>",
		'passages': {
		},
	},
	'radiofaro sin reactor': {
		'text': "<table width=\"100%\" style=\"background-color:black;border:none;\">\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\"><br></td>\n<td width=\"15%\"></td>\n</tr>\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\" style=\"background-color:red;color:yellow;text-align:center;font-family:consolas;\"><br><b>\n&nbsp;RADIOFARO DE RESCATE ACTIVADO&nbsp;<br>\n&nbsp;DURACIÓN DE TRANSMISION: 10 AÑOS&nbsp;<br>\n</b><br></td>\n<td width=\"15%\"></td>\n</tr>\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\"><br></td>\n<td width=\"15%\"></td>\n</tr>\n</table>",
		'passages': {
		},
	},
	'radiofaro con reactor': {
		'text': "<table width=\"100%\" style=\"background-color:black;border:none;\">\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\"><br></td>\n<td width=\"15%\"></td>\n</tr>\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\" style=\"background-color:green;color:black;text-align:center;font-family:consolas;\"><br><b>\n&nbsp;RADIOFARO DE RESCATE ACTIVADO&nbsp;<br>\n&nbsp;DURACIÓN DE TRANSMISION: 60 AÑOS&nbsp;<br>\n</b><br></td>\n<td width=\"15%\"></td>\n</tr>\n<tr>\n<td width=\"15%\"></td>\n<td width=\"70%\"><br></td>\n<td width=\"15%\"></td>\n</tr>\n</table>",
		'passages': {
		},
	},
	'quedarse': {
		'clear': true,
		'text': "<p>{if decision_final=0:Con una sensación de profunda tristeza,}\n{if decision_final=1:Con resignación,}\n{if decision_final=2:Con una curiosa sensación de expectación,}\n{if decision_final=3:Sintiendo un profundo alivio,}\napago los sistemas de la cápsula.</p>\n<p>Se escucha un zumbido y la pantalla del panel se apaga.</p>\n<p>Bueno, ya está.</p>\n<p>Salgo al exterior y puedo comprobar que la luz de la baliza ya no está encendida.</p>\n<p>Es igual.</p>\n<p>No voy a volver a este sitio nunca más{if decision_final=2:... y empiezo a creer que esto va a ser bueno para mí}{if decision_final=3:... y creo sinceramente que esto es lo mejor para mí y para La Gente}.</p>\n<p>{if decision_final=0:Con pasos lentos y resignados, emprendo <a class=\"squiffy-link link-section\" data-section=\"final neutro\" role=\"link\" tabindex=\"0\">el regreso a la aldea</a>.}\n{if decision_final=1:Con algo de cansancio, emprendo <a class=\"squiffy-link link-section\" data-section=\"final neutro\" role=\"link\" tabindex=\"0\">el regreso a la aldea</a>.}\n{if decision_final=2:Con el ánimo ligero, emprendo <a class=\"squiffy-link link-section\" data-section=\"final feliz\" role=\"link\" tabindex=\"0\">el regreso a la aldea</a>.}\n{if decision_final=3:Con el corazón rebozante de alegría, emprendo <a class=\"squiffy-link link-section\" data-section=\"final feliz\" role=\"link\" tabindex=\"0\">el regreso a casa</a>.}</p>\n<!-- Final -->",
		'passages': {
		},
	},
	'final neutro': {
		'clear': true,
		'text': "<p><font face=\"papyrus\" color=\"darkblue\"><b><blockquote>\nEl Viajero vivió con La Gente<br>\ny aprendió de La Gente.<br>\nCompartió nuestros afanes,<br>\npero rara vez se le vió alegre.<br>\n<br>\nA menudo El Viajero miraba al cielo<br>\ny su pena fue creciendo con el tiempo.<br>\n<br>\nCuando al final de sus días<br>\nEl Viajero entró en la Memoria,<br>\nsu Recuerdo fue de corta duración<br>\ncon pocas voces que cantaran su vida.<br>\n<br>\nY la canción de El Viajero termina<br>\nsin que La Gente sepa<br>\nqué canciones se cantarán<br>\ndespués de la canción de El Viajero.<br>\n<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=\"squiffy-link link-section\" data-section=\"seccion final\" role=\"link\" tabindex=\"0\">F i n</a></b></font>\n</blockquote></p>",
		'passages': {
		},
	},
	'final feliz': {
		'clear': true,
		'text': "<p><font face=\"papyrus\" color=\"darkgreen\"><b><blockquote>\nEl Viajero vivió con La Gente<br>\ny aprendió de La Gente.<br>\nCompartió nuestros afanes,<br>\ny entre nosotros tuvo paz.<br>\n<br>\nDurante un breve tiempo<br>\nEl Viajero miró al cielo<br>\npero pronto dejó de hacerlo<br>\ny su dicha fue creciendo con el tiempo.<br>\n<br>\nCuando al final de sus días<br>\nEl Viajero entró en la Memoria,<br>\nsu Recuerdo fue largo y de mucha alegría<br>\ny toda la aldea cantó su vida con gozo.<br>\n<br>\nLa canción de El Viajero se cantará<br>\nmientras viva en la Memoria de La Gente<br>\nque reconoció en El Viajero<br>\na un Mayor largo tiempo extraviado<br>\nque tras su periplo por los cielos<br>\npudo por fin volver a casa.<br>\n<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class=\"squiffy-link link-section\" data-section=\"seccion final\" role=\"link\" tabindex=\"0\">F i n</a></b></font>\n</blockquote></p>",
		'passages': {
		},
	},
	'seccion final': {
		'clear': true,
		'text': "<p><font face=\"papyrus\" color=\"darkblue\" size=10>&nbsp;M&nbsp;e&nbsp;m&nbsp;o&nbsp;r&nbsp;i&nbsp;a</font>\n<br>\n<br>\nPuedes revisar tu <a class=\"squiffy-link link-passage\" data-passage=\"Puntuacion\" role=\"link\" tabindex=\"0\">puntuación</a>, leer los <a class=\"squiffy-link link-passage\" data-passage=\"Agradecimientos\" role=\"link\" tabindex=\"0\">agradecimientos</a>, mirar las <a class=\"squiffy-link link-passage\" data-passage=\"Curiosidades\" role=\"link\" tabindex=\"0\">curiosidades</a>, saber más <a class=\"squiffy-link link-passage\" data-passage=\"acerca de\" role=\"link\" tabindex=\"0\">acerca de</a> la creación de &quot;Memoria&quot; o <a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a> el relato.</p>",
		'passages': {
			'Puntuacion': {
				'text': "<p>Has conseguido {puntaje_memoria} punto{if puntaje_memoria=1: }{else:s }de 5 así que calificas como \n{if puntaje_memoria=-1: <b>náufrago</b>} \n{if puntaje_memoria=0: <b>superviviente</b>}\n{if puntaje_memoria=1: <b>viajero</b>}\n{if puntaje_memoria=2: <b>aldeano adoptado</b>}\n{if puntaje_memoria=3: <b>niño de La Gente</b>}\n{if puntaje_memoria=4: <b>adulto de La Gente</b>}\n{if puntaje_memoria=5: <b>Mayor de La Gente</b>}<br>\n<br>\n<b>Puntuación por secciones</b><br>\n<br>\n<b>Naufragio:</b> para ganar 1 punto de Memoria debes hacer 3 o más puntos en esta sección<br>\n{if seen panel de mandos: +1 por apagar el reactor con el panel de mandos<br>}\n{if seen manualmente: +1 por abrir la puerta de la cápsula manualmente y obtener la pistola de señales<br>}\n{if seen sendero: +1 por usar un sendero para entrar por la llanura<br>}\n{if seen sigilosamente: +1 por esquivar con sigilo a los Cazadores<br>}\n{if seen luchar: +1 por ahuyentar a los Cazadores con tu pistola<br>}\n<br>\nEn el Naufragio ganaste \n{if puntaje_Naufragio=4:1 punto}\n{if puntaje_Naufragio=3:1 punto}\n{if puntaje_Naufragio=2:0 puntos}\n{if puntaje_Naufragio=1:0 puntos}\n{if puntaje_Naufragio=0:0 puntos} de Memoria\n<br><br>\n<b>La Aldea:</b> para ganar 1 punto de Memoria debes hacer 3 o más puntos en esta sección<br>\n{if seen comer semillas: +1 por comer las semillas<br>}\n{if seen sacudir la esterilla: +1 por sacudir tus esterilla lejos de la aldea, sin molestar a La Gente<br>}\n{if seen asearse: +1 por cuidar tu aseo personal<br>}\n{if seen pasto largo: +1 por ayudar con la recoleción de pasto largo<br>}\n{if seen pasto corto: +1 por ayudar con la recoleción de pasto corto<br>}\n{if seen llevar pasto: +1 por llevar lo recolectado de vuelta a la aldea<br>}\n<br>\nEn la Aldea ganaste \n{if puntaje_Aldea=6:1 punto}\n{if puntaje_Aldea=5:1 punto}\n{if puntaje_Aldea=4:1 punto}\n{if puntaje_Aldea=3:1 punto}\n{if puntaje_Aldea=2:0 puntos}\n{if puntaje_Aldea=1:0 puntos}\n{if puntaje_Aldea=0:0 puntos} de Memoria\n{if seen Memoria:<br>Ganaste un punto extra de Memoria por educar a un niño y conocer más de las tradiciones de La Gente}\n<br><br>\n<b>El Viajero:</b> para ganar 1 punto de Memoria debes hacer 3 o más puntos en esta sección<br>\n{if seen disparar a Cazador acompañado: +1 por ahuyentar a los Cazadores con tu pistola camino al Lago Ardiente<br>}\n{if seen esperar en silencio: +1 por usar el sigilo para esquivar a los Cazadores camino al Lago Ardiente<br>}\n{if seen esperar a pie firme: +1 por usar el sigilo para esquivar a los Cazadores camino al Lago Ardiente<br>}\n{if seen disparar a Cazador solo: +1 por ahuyentar a los Cazadores con tu pistola camino al Lago Ardiente<br>}\n{if seen salir acompañado: +1 por llegar con ayuda al Lago Ardiente<br>}\n{if seen continuar en compañía: +1 por ir a la llanura en compañia de los aldeanos<br>}\n{if seen inmovil: +1 por usar el sigilo para esquivar a los Cazadores camino de las flores de fuego<br>}\n{if seen disparar a Cazador camino a las flores: +1 por ahuyentar a los Cazadores con tu pistola camino de las flores de fuego<br>}\n<br>\nEn el Viajero ganaste\n{if puntaje_Viajero=4:1 punto}\n{if puntaje_Viajero=3:1 punto}\n{if puntaje_Viajero=2:0 puntos}\n{if puntaje_Viajero=1:0 puntos}\n{if puntaje_Viajero=0:0 puntos} de Memoria\n<br><br>\n<b>Memoria:</b><br>\nEn el último capítulo {if seen no saber:perdiste 1 punto de Memoria por despreciar}{else:ganaste 1 punto de Memoria por escuchar} las últimas palabras del Mayor.</p>",
			},
			'Agradecimientos': {
				'text': "<p>El autor quiere agradecer a:</p>\n<ul>\n<li>Fernando Gregoire, por su testing alfa.</li>\n<li>jade, por su testing beta.</li>\n<li>Alex Warren, por crear Squiffy, con el que pude construir este hiperrelato.</li>\n<li>A los que luchan, día a día, por algo más que sólo sobrevivir.</li>\n</ul>",
			},
			'Curiosidades': {
				'text': "<p>Algunas curiosidades para encontrar en una nueva lectura de &quot;Memoria&quot;:</p>\n<ul>\n<li>Hay formas mejores y peores de salir de la cápsula... y las pequeñas decisiones suelen tener grandes consecuencias.</li>\n<li>No estamos en el planeta Tierra: mira el paisaje y lo que le da vida.</li>\n<li>La gastronomía cambia con los mundos: prueba y verás.</li>\n<li>Las costumbres y el lenguaje corporal de La Gente son <i>muy</i> diferentes a los nuestros: fíjate en lo que hace la gente.</li>\n<li>Ábrete a lo cotidiano e intenta seguir a los aldeanos e imitar cuanto hacen.</li>\n</ul>",
			},
			'acerca de': {
				'text': "<p><b>Sobre la creación de la obra</b></p>\n<p>Este trabajo se creó originalmente para participar en la competencia &quot;Más allá de la Comp&quot;, allá por Julio del 2016.</p>\n<p>Sin embargo, por consideraciones y requerimiento profesionales y personales, me ví imposiblitado de completarla y el relato quedó inconcluso para esa ocasión.</p>\n<p>Y así estuvo por varios años...</p>\n<p>A raíz de la pandemia de coronavirus del 2020, como tantos otros tuve que quedarme confinado en casa y trabajar en forma remota... lo que determinó que, de pronto, tuviera un poco más de tiempo libre para escribir.</p>\n<p>A fines de Mayo de ese año resucité primero las reseñas literarias en mi blog &quot;<a href=\"http://incanus-escritorio.blogspot.com/\" target=\"_blank\">El Escritorio de Incanus</a>&quot;, y mediante ese medio me atreví a acercarme de nuevo al mundillo de la ficción interactiva. Todo ello me llevó a retomar esta obra para completarla y darle forma publicable, actualizando de paso mi <a href=\"https://incanus.caad.club/index.html\" target=\"_blank\">página web</a> y los medios y canales mediante los cuales distribuyo mis trabajos de ficción interactiva.</p>\n<p>El resultado de este &quot;regreso&quot; es el relato que está ahora en sus manos.</p>\n<p><b>Sobre el tema de la obra</b></p>\n<p>&quot;<a href=\"https://incanus.caad.club/protector.html\" target=\"_blank\">El Protector</a>&quot; fue mi segundo trabajo interactivo publicado y probablemente el más personalmente involucrado de todos cuanto he escrito, especialmente por lo que motivó su creación.</p>\n<p>La idea era desarrollar el tema de la supervivencia y lo que esa necesidad puede motivarnos a hacer, especialmente cuando esas acciones van (a primera vista) en contra de nuestro interés personal.</p>\n<p>Siempre quedé con el interés de volver al mundo de &quot;La Gente&quot;, pero no para repetir el periplo del protagonista. El objetivo era continuar desarrollando el tema de la supervivencia; no ya de la mera subsistencia física, sino de la identidad personal y la del grupo que nos acoje, particularmente cuando el salvar la vida nos puede llevar a perder la identidad o arriesgar lo que hace de la existencia algo más que un día a día repetido una y otra vez.</p>\n<p>Así pues, en este relato el lector deberá tomar decisiones que afectan no solo la continuidad personal del protagonista; sus actos y decisiones, grandes y pequeñas, trascienden al personaje y gravitan sobre el devenir de un grupo &quot;humano&quot; con sus propias tradiciones y necesidades, algunas que van mucho más allá de lo meramente corporal.</p>\n<p>Quiera el lector reflexionar sobre si, después de sobrevivir a esta pandemia, no haya otras cosas que también merezca la pena salvar y que no dependen de un único individuo ni de la salud del cuerpo que sólo es, a fin de cuentas, un vehículo para otras cosas tanto más importantes que comer, reproducirse y dormir. </p>\n<p>Santiago de Chile, 24 de Julio, 2020</p>",
			},
		},
	},
	'Reiniciar': {
		'text': "",
		'js': function() {
			squiffy.story.restart();
		},
		'passages': {
		},
	},
}
})();