
#include "output.h"
#include "game.h"

//-----------------------------------------------------------------------------
// Putstring - Formats Text to Line and Outputs                               |
//-----------------------------------------------------------------------------
void putstring(const char *s)
{
static char tmpbuf[SCREENWIDTH];
NR size_t len;
  len = strlen(s);
  while (len >= SCREENWIDTH - 1)
  {
    NR const char *p;
    NR char *dest;
    NR const char *lastspace;
    NR size_t spaceleft;
    NR size_t width;
    p = s;
    dest = tmpbuf;
    spaceleft = SCREENWIDTH - 1;
    while (spaceleft && '\n' != *p)          // Loop through one line, locating 
    {                                        // the first newline or last space
      switch (*p)
      {
        case ' ': lastspace = p;
      }
      *dest = *p;
      ++ dest;
      ++ p;
      -- spaceleft;
    }
    if ('\n' != *p)
    {
      p = lastspace;                                 // Terminate at last space
      width = p - s - 1;
      tmpbuf[width + 1] = 0;
    }
    else
    {
      *dest = 0;                                  // Terminate at found newline
      width = p - s;
    }
    PUTS(tmpbuf);                                             // Print the text
    s = p + 1;                                               // Advance pointer
    len -= width;                                           // Decrease counter
  }
  PUTS(s);
}
