
#include "game.h"
#include "room.h"
#include "input.h"
#include "perform.h"
#include "output.h"

/* Global variables */
struct gamedata_s *gamedata = NULL;
char *input = NULL;
const char *object_string = NULL;
int screenwidth;

void initgame(void);
void intro(void);

int main(void)
{
NR unsigned char exit;
NR unsigned char oldroom;
NR const char *s;
        initgame();
        intro();
        oldroom = 0;
        do
        {
                NR unsigned char verb;

                if (oldroom != gamedata->room)
                {
                        printroom();
                        oldroom = gamedata->room;
                }

                verb = getinput();
                exit = perform(verb);
        } while (GAME_CONTINUES == exit);

        switch (exit)
        {
                case GAME_LOST:
                        s = "GAME OVER!";
                        break;

                case GAME_WON:
                        s = "Congratulations!";
                        break;
        }
        PUTS(s);
        free(gamedata);
        free(input);
return 0;
}

static const signed char defaultrooms[OBJECTS] =
{
        1, 2, 3, 7, 8, 9, 13, 14, 15, -1, 9,
        18, 16, -1, 24, 28, 19, 25, 26, 20, -1
};

static const unsigned char defaultmap[MAPSIZE] =
{
                     EXIT_SOUTH |             EXIT_EAST /*  1 */,
                                  EXIT_WEST | EXIT_EAST /*  2 */,
                     EXIT_SOUTH | EXIT_WEST             /*  3 */,
                     EXIT_SOUTH | EXIT_WEST             /*  4 */,
                     EXIT_SOUTH |             EXIT_EAST /*  5 */,
                                  EXIT_WEST             /*  6 */,
        EXIT_NORTH | EXIT_SOUTH                         /*  7 */,
                     EXIT_SOUTH                         /*  8 */,
        EXIT_NORTH | EXIT_SOUTH                         /*  9 */,
        EXIT_NORTH | EXIT_SOUTH                         /* 10 */,
        EXIT_NORTH | EXIT_SOUTH | EXIT_WEST | EXIT_EAST /* 11 */,
                     EXIT_SOUTH | EXIT_WEST             /* 12 */,
        EXIT_NORTH |                          EXIT_EAST /* 13 */,
        EXIT_NORTH |              EXIT_WEST             /* 14 */,
        EXIT_NORTH                                      /* 15 */,
        EXIT_NORTH |                          EXIT_EAST /* 16 */,
        EXIT_NORTH | EXIT_SOUTH | EXIT_WEST | EXIT_EAST /* 17 */,
        EXIT_NORTH | EXIT_SOUTH | EXIT_WEST             /* 18 */,
                     EXIT_SOUTH |             EXIT_EAST /* 19 */,
                     EXIT_SOUTH |             EXIT_EAST /* 20 */,
                     EXIT_SOUTH | EXIT_WEST | EXIT_EAST /* 21 */,
                                              EXIT_EAST /* 22 */,
        EXIT_NORTH | EXIT_SOUTH | EXIT_WEST | EXIT_EAST /* 23 */,
        EXIT_NORTH | EXIT_SOUTH | EXIT_WEST             /* 24 */,
        EXIT_NORTH                                      /* 25 */,
        EXIT_NORTH |                          EXIT_EAST /* 26 */,
        EXIT_NORTH |              EXIT_WEST             /* 27 */,
                                              EXIT_EAST /* 28 */,
        EXIT_NORTH |              EXIT_WEST | EXIT_EAST /* 29 */,
                                  EXIT_WEST             /* 30 */
};

void initgame(void)
{
NR unsigned char i;
        gamedata = malloc(sizeof (struct gamedata_s));
        input = malloc(1024);
        for (i = 0; i < INVENTORY; ++ i)
                gamedata->inventory[i] = -1;
        gamedata->room = 15;
        gamedata->pilleaten = 0;
        gamedata->seenscientist = 0;
        gamedata->roadvisit = 0;
        memcpy(gamedata->objects, defaultrooms, OBJECTS);
        memcpy(gamedata->map, defaultmap, MAPSIZE);
}

void intro(void)
{
  putstring("The Potion - a simple adventure\n"
     "==========\n\n"
     "Copyright 2002-2003 Peter Karlsson.\n"
     "A Softwolves Software Release.\n"
     "http://www.softwolves.pp.se/cbm/\n\n"
     "This program comes with ABSOLUTELY NO WARRANTY. This is free "
     "software, and you are welcome to redistribute it under "
     "certain conditions; type \"license\" for details.\n"
     );
}
