
#include "action.h"
#include "object.h"
#include "perform.h"
#include "input.h"
#include "game.h"
#include "output.h"

void cannotdothat(void)
{
  PUTS("You cannot do that!");
}

void nothing(void)
{
  PUTS("Nothing.");
}

unsigned char move(unsigned char verb)
{
unsigned char bitmap;
signed char offset;
        /* Seen scientist? */
        if (gamedata->seenscientist)
        {
                PUTS("The scientist captures you.");
                return GAME_LOST;
        }
        /* FIXME: Crossing autobahn? */
        /* Check which movement is requested */
        switch (verb)
        {
                case V_N: bitmap = EXIT_NORTH; offset = -6; break;
                case V_S: bitmap = EXIT_SOUTH; offset =  6; break;
                case V_E: bitmap = EXIT_EAST;  offset =  1; break;
                case V_W: bitmap = EXIT_WEST;  offset = -1; break;
        }
        /* Check if movement is allowed in that direction */
        if (gamedata->map[gamedata->room - 1] & bitmap)
        {
                gamedata->room += offset;
        }
        else
        {
                PUTS("You cannot go that way.");
                return GAME_CONTINUES;
        }
        /* Check if we are carrying both bottles */

        if ((O_ELIXIR == gamedata->inventory[0] && O_COKE == gamedata->inventory[1])
            ||
            (O_ELIXIR == gamedata->inventory[1] && O_COKE == gamedata->inventory[0]))
        {
                switch (++ gamedata->bothbottles)
                {
                case 1:
                        putstring("The potion is starting to heat up.");
                        break;
                case 5:
                        putstring("Some kind kind of reaction seems to be happening "
                                  "between the potion and what is left of the Coke.");
                        break;
                case 10:
                        putstring("You better get rid of one of the bottles before "
                                  "the potion explodes!");
                        break;
                case 12:
                        putstring("The potion explodes in your face!");
                        return GAME_LOST;
                }
        }
        else
        {
                /* Reset counter */
                gamedata->bothbottles = 0;
        }
return GAME_CONTINUES;
}

unsigned char inventory(void)
{
NR BOOL hasanything;
NR unsigned char i;
NR signed char *inventory;
        hasanything = FALSE;
        inventory = gamedata->inventory;
        PUTS("You are carrying:");
        for (i = INVENTORY; i; -- i, ++ inventory)
                if (*inventory != -1)
                {
                        printobject(*inventory);
                        hasanything = TRUE;
                }
        if (!hasanything)
                nothing();
return GAME_CONTINUES;
}

unsigned char take(unsigned char object)
{
        switch (object)
        {
                case O_PILL:
                        /* Something special happens when we take the pill */
                        gamedata->pilleaten = TRUE;
                        gamedata->objects[O_PILL] = -1;
                        PUTS("You understand.");
                        break;
                case O_STONE_PILL:
                        /* Finds pill, if it's not taken already */
                        if (!gamedata->pilleaten && -1 == gamedata->objects[O_PILL])
                        {
                                PUTS("You found a small pill beneath it.");
                                gamedata->objects[O_PILL] = gamedata->room;
                                break;
                        }
                        /* Else fall through */
                default:
                        if (movable(object))
                        {
                                if (addinventory(object))
                                        PUTS("Taken.");
                        }
                        else
                        {
                                cannotdothat();
                        }
                        break;
        }
        return GAME_CONTINUES;
}

unsigned char lift(unsigned char object)
{
        switch (object)
        {
                case O_STONE_PILL:
                        if (!gamedata->pilleaten)
                        {
                                take(object);
                                break;
                        }
                        /* else fall through */

                default:
                        nothing();
                        break;
        }

        return GAME_CONTINUES;
}

unsigned char read(unsigned char object)
{
        switch (object)
        {
                case O_STONE_MISSION:
                        putstring("It says:\n"
                                  "\"Save us from the evil scientist. "
                                  "Mix his evil drug with salt water. "
                                  "That is your mission.\"");
                        break;
                default:
                        nothing();
        }
return GAME_CONTINUES;
}

unsigned char talkto(unsigned char object)
{
        switch (object)
        {
                case O_SCIENTIST:
                        putstring("The scientist says:\n"
                                  "\"You will die with the rest!\" "
                                  "and laughs frantically.\n");
                        break;
                case O_SQUIRREL:
                        if (gamedata->pilleaten)
                        {
                                putstring("The squirrel says:\n"
                                          "\"You can now exit the forest\"");
                                gamedata->map[3 - 1] |= EXIT_EAST;
                                break;
                        }
                        /* else fall through */
                default:                        
                        cannotdothat();
        }
return GAME_CONTINUES;
}

unsigned char unlock(unsigned char object)
{
/* Check if we have the key */
NR BOOL havekey;
NR unsigned char i;
        havekey = FALSE;
        for (i = 0; i < INVENTORY; ++ i)
                if (O_KEY == gamedata->inventory[i])
                        havekey = TRUE;
        if (havekey)
        {
                switch (object)
                {
                        case O_COTTAGE:
                                PUTS("You find a switch inside.");
                                gamedata->objects[O_SWITCH] = gamedata->room;
                                return GAME_CONTINUES;
                        case O_DOOR:
                                PUTS("It opens revealing a laboratory.");
                                gamedata->map[20 - 1] |= EXIT_WEST;
                                return GAME_CONTINUES;
                }
        }
        cannotdothat();
return GAME_CONTINUES;
}

unsigned char turn(unsigned char object)
{
        switch (object)
        {
                case O_SWITCH:
                        PUTS("Thud.");
                        gamedata->map[22 - 1] |= EXIT_WEST;
                        break;
                default:
                        cannotdothat();
                        break;
        }
return GAME_CONTINUES;
}

unsigned char hit(unsigned char object)
{
        switch (object)
        {
                case O_SQUIRREL:
                        /* If we hit the squirrel, we kill it. */
                        PUTS("You kill the squirrel.");
                        return GAME_LOST;
                case O_SCIENTIST:
                        /* Clear the seen scientist flag */
                        gamedata->seenscientist = FALSE;
                        /* Remove scientist from game */
                        gamedata->objects[O_SCIENTIST] = -1;
                        PUTS("He will not bother you again.");
                        break;
                default:
                        cannotdothat();
                        break;
        }
return GAME_CONTINUES;
}

unsigned char kill(void)
{
        putstring("No strong violence please. This is a family game.");
        return GAME_CONTINUES;
}

unsigned char pour(unsigned char object)
{
        switch (object)
        {
                case O_ELIXIR:
                        /* The game object is to mix the potion with salt
                         * water. This can only be done by pouring it into
                         * the sea.
                         */
                         switch (gamedata->room)
                         {
                                case 6:
                                        PUTS("The potion has been neutralised.");
                                        return GAME_WON;
                                default:
                                        PUTS("The potion poisons the land.");
                                        return GAME_LOST;
                        }
                        break;
                case O_COKE:
                        PUTS("The bottle is empty.");
                        break;
                default:
                        cannotdothat();
                        break;
        }
return GAME_CONTINUES;
}

unsigned char drink(unsigned char object)
{
        switch (object)
        {
                case O_ELIXIR:
                        /* Can only drink the elixir, and we lose if we do it */
                        PUTS("You die instantly.");
                        return GAME_LOST;
                case O_COKE:
                        /* It's empty */
                        return pour(O_COKE);
                        break;
                default:
                        cannotdothat();
                        return GAME_CONTINUES;
        }
}

unsigned char throw(unsigned char object)
{
        if ((object <= O_LAST_STONE || O_COKE == object) &&
            9 == gamedata->room)
        {
                return hit(O_SQUIRREL);
        }
        else
        {
                return drop(object);
        }
}

unsigned char look(unsigned char object)
{
        switch (object)
        {
                case O_STONE_MISSION:
                        return read(object);

                case O_STONE_PILL:
                        if (!gamedata->pilleaten && -1 == gamedata->objects[O_PILL])
                                return take(object);
                        /* Else fall through */

                default:
                        nothing();
                        return GAME_CONTINUES;
        }
}

unsigned char drop(unsigned char object)
{
        switch (object)
        {
                case O_COKE:
                        /* Can only recycle the Cola bottle once we've taken it */
                        switch (gamedata->room)
                        {
                        case 12:
                                if (dropinventory(O_COKE))
                                {
                                        putstring("You recycle the bottle. Thank you for being "
                                                  "kind to the nature!");
                                        gamedata->objects[O_COKE] = -1; /* Remove from game */
                                        break;
                                }
                                /* else fall through */
                        case 28: case 29: /* Dump */
                                putstring("Throwing away a perfectly recyclable bottle? "
                                          "No way!");
                                break;
                                /* Fall through for small build */
                        case 1:  case 2:  case 3:
                        case 7:  case 8:  case 9:
                        case 13: case 14: case 15:
                        case 30: /* Forest */
                                PUTS("Someone might get hurt!");
                                break;
                                /* Fall through for small build */
                        default:
                                PUTS("Please recycle the bottle.");
                                break;
                        }
                        break;
                case O_ELIXIR:
                        if (gamedata->bothbottles)
                        {
                                putstring("You dare not drop the potion in its current "
                                          "state!");
                                break;
                        }
                        /* else fall through */
                default:
                        if (dropinventory(object))
                                PUTS("Dropped.");
        }
return GAME_CONTINUES;
}

unsigned char license(void)
{
        putstring("This program is free software; you can redistribute it "
              "and/or modify it under the terms of the GNU General Public "
              "License as published by the Free Software Foundation, "
              "version 2.\n\n"
              "This program is distributed in the hope that it will be "
              "useful, but WITHOUT ANY WARRANTY; without even the implied "
              "warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR "
              "PURPOSE.  See the GNU General Public License for more "
              "details."
              );
return GAME_CONTINUES;
}

unsigned char quit(void)
{
        putstring("You leave for your home country. In the distance, you "
                  "can hear the evil scientist laughing mercilessly as he "
                  "unleashes his horrible magical potion on the land.");
return GAME_LOST;
}
