// This is a solo paranoia game taken from the Jan/Feb
// issue (No 77) of "SpaceGamer/FantasyGamer" magazine.
// Article by Sam Shirley.
// Implemented in C on Vax 11/780 under UNIX by Tim Lister
// Ported to Cybiko by Athlor
// This is a public domain adventure and may not be sold for profit

#include <CyWin.h>
#define LED (*(char *)0xFFFF61) // Green LED register
#define MOXIE   13
#define AGILITY 15
#define MAXKILL 7  // The maximum number of UV's you can kill

char tmp[64]; // Temp string storage
int Cnum = 1;
int page = 1;
int computer_request = 0;
int ultra_violet = 0;
int action_doll = 0;
int hit_points = 10;
int read_letter = 0;
int plato_clone = 3;
int blast_door = 0;
int killer_count = 0;

void character(void);

struct MSequence mus; // Structures
struct Message* ptr_msg;
struct module_t main_module;

//-----------------------------------------------------------------------------
//                                                                            |
//-----------------------------------------------------------------------------
int puts(char *s)
{
  TGraph_scroll(main_module.m_gfx, 0, 0, 160, 100, 0, -9); // Scroll Up
  TGraph_set_color(main_module.m_gfx, CLR_WHITE);
  TGraph_fill_rect(main_module.m_gfx, 0, 91, 160, 9); // Erase bottom line
  TGraph_set_color(main_module.m_gfx, CLR_BLACK);
  Graphics_draw_text(main_module.m_gfx, s, 0, 90); // Print Text
  DisplayGraphics_show(main_module.m_gfx); // Update Display
}

void Wrap(char *s)
{
 char l[64]; int i; int lsp;
  while(DisplayGraphics_string_width(main_module.m_gfx,s)>155)
  {
    i=0; l[i]=0;
    do {
      if(*s==32)  lsp=i; // Remember last space
      l[i++] = *s++; l[i]=0;
    }while(DisplayGraphics_string_width(main_module.m_gfx,l)<155&&(l[i-1]!='\n'));
    if(*(s-1)!='\n') {s=s-(i-lsp)+1; i=lsp;  l[i++]='\n'; l[i]=0;}
    puts(l);
  }
  puts(s);
}

char get_char(void)
{
 int key;
 bool pressed = FALSE;
  do{
    ptr_msg = cWinApp_get_message(main_module.m_process, 0, 1, MSG_USER);
    switch(ptr_msg->msgid)
    {
      case MSG_KEYDOWN:
        key = Message_get_key_param(ptr_msg)->scancode; // Allows spec keys
        switch(key)
        {
          case KEY_ENTER: case KEY_BACKSPACE: case KEY_RIGHT: case KEY_SELECT:
          case KEY_UP: case KEY_DOWN: case KEY_LEFT: case KEY_DEL: case KEY_TAB:
            pressed = TRUE;
          case KEY_SHIFT: case KEY_CONTROL:
            break;
          default: // For remaning alpha-numeric keys
            pressed = TRUE;
            key = Message_get_key_param(ptr_msg)->ch; // Allows SHIFT key vals
            break;
        }
        break;
      default:
      cWinApp_defproc(main_module.m_process, ptr_msg); // Process Remaining
    }
    Message_delete(ptr_msg); // Delete processed message
  }while(!pressed); // Loop until key is pressed
 return key;
}

void more(void)
{
  LED |= 8; // Turn Green LED ON
  cprintf("Cnum: %d (Page %d)\n", Cnum, page);
  if (get_char() == 'p')
  {
    character();
    get_char();
  }
  LED &= 247; // Turn Green LED OFF 
}

int new_clone(int resume)
{
  beep(3);
  sprintf(tmp,"Clone %d just died.", Cnum);
  Wrap(tmp);
  Cnum++;
  cprintf("Cnum: %d \n", Cnum);
  if (Cnum > 7)
  {
    puts("YOU LOSE");
    Wrap("All your clones are dead. Your name has been stricken from the records.");
    puts("THE END");
    sleep(3000); // Wait 3 sec
    return 0;
  }
  sprintf(tmp,"Clone %d now activated.", Cnum);
  Wrap(tmp);
  ultra_violet = 0;
  action_doll = 0;
  hit_points = 10;
  killer_count = 0;
  more();
 return resume;
}

int dice_roll(int number,int faces)
{
 int i, total = 0;
  for (i = number; i > 0; i--)
    total += random(faces)+1;
 return total;
}

void instructions(void)
{
  puts("HOW TO PLAY:");
  Wrap("Just press <ENTER> until you are asked to make a choice. Select 'a'\
 or 'b' or whatever for your choice. You may select 'p' at any time to get a\
 display of your statistics. Always choose the least dangerous option. At times\
 you will use a skill or engage in combat and will be informed of the outcome.");
  more();
  puts("HOW TO DIE:");
  Wrap("As Philo-R-DMD you will die at times during the adventure. When this\
 happens you will be given an new clone at a particular location. The new\
 Philo-R will usually have to retrace some of the old Philo-R's path;\
 hopefully he won't make the same mistake as his predecessor.");
  more();
  puts("HOW TO WIN:");
  Wrap("Simply complete the mission before you expend all six clones.If you\
 make it, congratulations. If not, you can try again later.");
  more();
}

void character(void)
{
  sprintf(tmp,"The Character: Philo-R-DMD %d", Cnum);
  Wrap(tmp);
  puts("Primary Attributes");
  puts("==================");
  puts("Strength: 13");
  puts("Endurance: 13");
  puts("Agility: 15");
  puts("Manual Dexterity: 15");
  puts("Moxie: 13");
  puts("Chutzpah: 8");
  puts("Mechanical Aptitude: 14");
  puts("Power Index: 10");
  more();
  puts("Secondary Attributes");
  puts("==================");
  puts("Carrying Capacity: 30");
  puts("Damage Bonus: 0");
  puts("Macho Bonus: -1");
  puts("Melee Bonus: +5%%");
  puts("Aimed Weapon Bonus: +10%");
  puts("Comprehension Bonus: +4%");
  puts("Believability Bonus: +5%");
  puts("Repair Bonus: +5%");
  more();
  puts("Credits: 160");
  puts("Secret Society: Illuminati");
  puts("Secret Society Rank: 1");
  puts("Service Group: Power Services");
  puts("Mutant Power: Precognition");
  Wrap("Weapon: laser pistol; to hit, 40%%; type, L; Range, 50m; Reload, 6r; Malfnt, 00");
  more();
  Wrap("Skills: Basics 1(20%), Aimed Weapon Combat 2(35%), Laser 3(40%),\
 Personal Development 1(20%), Communications 2(29%), Intimidation 3(34%)\
 Equipment: Red Reflec Armour, Laser Pistol, Laser Barrel (red), Notebook\
 & Stylus, Knife, Com Unit 1, Jump suit, Secret Illuminati Eye-In-The-Pyramid(tm)\
 Decoder ring, Utility Belt & Pouches");
  more();
}

int choose(int a, char *aptr, int b, char *bptr)
{
  sprintf(tmp,"[A] %s.", aptr);
  Wrap(tmp);
  sprintf(tmp,"[B] %s.", bptr);
  Wrap(tmp);
  if (get_char() == 'a')
    return a;
  else
    return b;
}

int page1(void)
{
  Wrap("You wake up face down on the red and pink checked E-Z-Kleen linoleum floor.\
 You recognise the pattern, it's the type preferred in the internal security briefing\
 cells. When you finally look around you, you see that you are alone in a\
 large mission briefing room.");
  more();
 return 57;
}

int page2(void)
{
  Wrap("\"Greetings,\" says the kindly Internal Security self incrimination expert\
 who meets you at the door, \"How are we doing today?\" He offers you a doughnut\
 and coffee and asks what brings you here. This doesn't seem so bad, so you\
 tell him that you have come to confess some possible security lapses.");
  more();
  Wrap("He smiles knowingly, deftly catching your coffee as you slump to the floor.\
 \"Nothing to be alarmed about; it's just the truth serum\", he says,\
 dragging you back into a discussion room. The next five hours are a dim haze,\
 but you can recall snatches of conversation about your secret society,");
  more();
  Wrap("your mutant power, and your somewhat paranoid distrust of The Computer.\
 This should explain why you are hogtied and moving slowly down the conveyer belt\
 towards the meat processing unit in Food Services.");
  if (computer_request == 1)
    return new_clone(45);
  else
    return new_clone(32);
}

int page3(void)
{
  Wrap("You walk to the nearest Computer terminal and request more information about\
 Christmas. The Computer says, \"That is an A-1 ULTRAVIOLET ONLY IMMEDIATE\
 TERMINATION classified topic. What is your clearance please, Troubleshooter?\"");
 return choose(4, "You give your correct clearance",
               5, "You claim Ultraviolet clearance");
}

int page4(void)
{
  Wrap("\"That is classified information, Troubleshooter, thank you for your inquiry.\
 Please report to an Internal Security self incrimination station as soon as possible.\"");
  more();
 return 9;
}

int page5(void)
{
  Wrap("The computer says, \"Troubleshooter, you are not wearing the correct colour\
 uniform. You must put on an Ultraviolet uniform immediately. I have seen to\
 your needs and ordered one already; it will be here shortly. Please wait with\
 your back to the wall until it arrives.\" In less than a minute an infrared\
 arrives carrying a white bundle.");
  more();
  Wrap("He asks you to sign for it, then hands it to you and stands back, well\
 outside of a fragmentation grenade's blast radius.");
 return choose(6, "You open the package and put on the uniform",
               7, "You finally come to your senses and run for it");
}

int page6(void)
{
  Wrap("The uniform definitely makes you look snappy and pert. It even has the\
 new lopsided lapel fashion that you admire so much. What's more, citizens of\
 all ranks come to obsequious attention as you walk past. This isn't so bad\
 being an Ultraviolet. You could probably come to like it, given time."); beep(0);
  Wrap("The beeping computer terminal interrupts your musings.");
  ultra_violet = 1;
  more();
 return 8;
}

int page7(void)
{
  beep(3);
  Wrap("The corridor lights dim and are replaced by red battle lamps as the Security\
 Breach alarms howl all around you. You run headlong down the corridor and\
 desperately windmill around a corner, only to collide with a squad of 12 Blue\
 clearance Vulture squadron soldiers.");
  more();
  Wrap("\"Stop, Slime Face,\" shouts the commander, \"or there won't be enough of you\
 left for a tissue sample.\" \"All right, soldiers, stuff the greasy traitor into the\
 uniform,\" he orders, waving the business end of his blue laser scant inches from your\
 nose. With his other hand he shakes open a white bundle to reveal a pristine new\
 Ultraviolet citizen's uniform.");
  more();
  Wrap("One of the Vulture squadron Troubleshooters grabs you by the neck in the\
 exotic and very painful Vulture Clamp(tm) death grip (you saw a special about\
 it on the Teela O'Malley show), while the rest tear off your clothes and\
 force you into the Ultraviolet uniform. The moment you are dressed they step\
 clear and stand at attention.");
  more();
  Wrap("\"Thank you for your cooperation, sir,\" says the steely eyed leader of\
 the Vulture Squad. \"We will be going about our business now.\" With perfect\
 timing the Vultures wheel smartly and goosestep down the corridor.");
  more();
  beep(0);
  Wrap("Special Note: don't make the mistake of assuming that your skills have\
 improved any because of the uniform; you're only a Red Troubleshooter\
 traitorously posing as an Ultraviolet, and don't you forget it! Suddenly,\
 a computer terminal comes to life beside you.");
  ultra_violet = 1;
  more();
 return 8;
}

int page8(void)
{
  Wrap("\"Now, about your question, citizen. Christmas was an old world marketing ploy\
 to induce lower clearance citizens to purchase vast quantities of goods, thus\
 accumulation a large amount of credit under the control of a single class of\
 citizen known as Retailers. The strategy used is to imply that all good\
 citizens give gifts during Christmas,");
  more();
  Wrap("thus if one wishes to be a valuable member of society one must also give\
 gifts during Christmas.\" \"More valuable gifts make one a more valuable member,\
 and thus did the Retailers come to control a disproportionate amount of the currency.\
 In this way Christmas eventually caused the collapse of the old world.");
  more();
  Wrap("Understandably, Christmas has been declared a treasonable practice in Alpha\
 Complex. Thank you for your inquiry.\"\n You continue on your way to GDH7-beta.");
  more();
 return 10;
}

int page9(void)
{
 int choice;
  Wrap("As you walk toward the tubecar that will take you to GDH7-beta, you pass one\
 of the bright blue and orange Internal Security self incrimination stations.\
 Inside, you can see an IS agent cheerfully greet an infrared citizen and then\
 lead him at gunpoint into one of the rubber-lined discussion rooms.");
  choice = choose(2, "You decide to stop here and chat, as ordered by The Computer",
                 10, "You continue blithely on past");
  if (choice == 2)
    computer_request = 1;
  else
    computer_request = 0;
 return choice;
}

int page10(void)
{
 int choice;
  Wrap("You stroll briskly down the corridor, up a ladder, across an unrailed\
 catwalk, under a perilously swinging blast door in urgent need of repair, and\
 into tubecar grand central. This is the bustling hub of Alpha Complex tubecar\
 transportation. Before you spreads a spaghetti maze of magnalift tube tracks\
 and linear accelerators.");
  more();
  Wrap("You bravely study the specially enhanced 3-D tube route map; you wouldn't be the\
 first Troubleshooter to take a fast tube ride to nowhere.");
  if (ultra_violet == 0) {
    choice = choose(3, "You decide to ask The Computer about Christmas using a nearby terminal",
                   10, "You think you have the route worked out, so you'll board a tube train");
    if (choice == 3)  return choice;
  }
  Wrap("You nervously select a tubecar and step aboard.");
  if (dice_roll(2, 10) < MOXIE) {
    Wrap("You just caught a purple line tubecar.");
    more();
    return 13;
  } else {
    Wrap("You just caught a brown line tubecar.");
    more();
    return 48;
  }
}

int page11(void)
{
  Wrap("The printing on the folder says \"Experimental Self Briefing.\"\
 You open it and begin to read the following:");
  Wrap("STEP 1: Compel the briefing subject to attend the briefing.\
 Note: See Experimental Briefing Sub Form Indigo-WY-2, 'Experimental Self\
 Briefing Subject Acquisition Through The Use Of Neurotoxin Room Foggers.'");
  more();
  Wrap("STEP 2: Inform the briefing subject that the briefing has begun.\
 ATTENTION: THE BRIEFING HAS BEGUN.\nSTEP 3: Present the briefing material\
 to the briefing subject. GREETINGS TROUBLESHOOTER. YOU HAVE BEEN SPECIALLY\
 SELECTED TO SINGLEHANDEDLY WIPE OUT A DEN OF TRAITOROUS CHRISTMAS ACTIVITY.");
  more();
  Wrap("YOUR MISSION IS TO GO TO GOODS DISTRIBUTION HALL 7-BETA AND ASSESS ANY\
 CHRISTMAS ACTIVITY YOU FIND THERE. YOU ARE TO INFILTRATE THESE CHRISTMAS\
 CELEBRANTS, LOCATE THEIR RINGLEADER, AN UNKNOWN MASTER RETAILER, AND BRING\
 HIM BACK FOR EXECUTION AND TRIAL. THANK YOU. THE COMPUTER IS YOUR FRIEND.");
  more();
  Wrap("STEP 4: Sign the briefing subject's briefing release form to indicate\
 that the briefing subject has completed the briefing. ATTENTION: PLEASE SIGN\
 YOUR BRIEFING RELEASE FORM.\nSTEP 5: Terminate the briefing ATTENTION: THE\
 BRIEFING IS TERMINATED.");
  more();
  Wrap("You walk to the door and hold your signed briefing release form up to the\
 plexiglass window. A guard scrutinises it for a moment and then slides back\
 the megabolts holding the door shut. You are now free to continue the mission.");
 return choose(3, "You ask The Computer for more information about Christmas",
              10, "You have decided to go directly to Goods Distribution Hall 7-beta");
}

int page12(void)
{
  Wrap("You walk up to the door and push the button labelled \"push to exit.\"\
 Within seconds a surly looking guard shoves his face into the small plexiglass\
 window. You can see his mouth forming words but you can't hear any of them.\
 You just stare at him blankly for a few moments until he points down to a\
 speaker on your side of the door.");
  more();
  Wrap("When you put your ear to it you can barely hear him say, \"Let's see your\
 briefing release form, bud. You aren't getting out of here without it.\"");
 return choose(11, "You sit down at the table and read the Orange packet",
               57, "You stare around the room some more");
}

int page13(void)
{
  Wrap("You step into the shiny plasteel tubecar, wondering why the shape has always\
 reminded you of bullets. The car shoots forward the instant your feet touch\
 the slippery gray floor, pinning you immobile against the back wall as the\
 tubecar careens toward GDH7-beta. Your only solace is the knowledge that it\
 could be worse, much worse.");
  more();
  Wrap("Before too long the car comes to a stop. You can see signs for GDH7-beta\
 through the window. With a little practice you discover that you can crawl\
 to the door and pull open the latch.");
  more();
 return 14;
}

int page14(void)
{
  Wrap("You manage to pull yourself out of the tubecar and look around. Before\
 you is one of the most confusing things you have ever seen, a hallway that is\
 simultaneously both red and green clearance. If this is the result of\
 Christmas then it's easy to see the evils inherent in its practice.");
  more();
  Wrap("You are in the heart of a large goods distribution centre. You can see all\
 about you evidence of traitorous secret society Christmas celebration; rubber\
 faced robots whiz back and forth selling toys to holiday shoppers, simul-plast\
 wreaths hang from every light fixture, while ahead in the shadows is a citizen\
 wearing a huge red synthetic flower.");
  more();
 return 22;
}

int page15(void)
{
  Wrap("You are set upon by a runty robot with a queer looking face and two pointy\
 rubber ears poking from beneath a tattered cap. \"Hey mister,\" it says,\
 \"you done all your last minute Christmas shopping?  I got some real neat junk\
 here. You don't wanna miss the big day tommorrow, if you know what I mean.\"\
 The robot opens its bag to show you a pile of shoddy Troubleshooter dolls.");
  more();
 Wrap("It reaches in and pulls out one of them. \"Look, these Action\
 Troubleshooter(tm) dolls are the neatest thing. This one's got moveable arms\
 and when you squeeze him, his little rifle squirts realistic looking napalm.\
 It's only 50 credits. Oh yeah, Merry Christmas.\"");
  puts("[A] You decide to buy the doll.");
  puts("[B] You shoot the robot.");
  Wrap("[C] You ignore the robot and keep searching the hall.");
  switch (get_char())
  {
    case 'a': return 16;
    case 'b': return 17;
    case 'c':
    default:  return 22;
  }
}

int page16(void)
{
  Wrap("The doll is a good buy for fifty credits; it will make a fine Christmas\
 present for one of your friends. After the sale the robot rolls away. You can use\
 the doll later in combat. It works just like a cone rifle firing napalm,\
 except that occasionally it will explode and blow the user to smithereens.\
 But don't let that stop you.");
  action_doll = 1;
 return 22;
}

int page17(void)
{
 int i, robot_hp = 15;
  Wrap("You whip out your laser and shoot the robot, but not before it squeezes the\
 toy at you. The squeeze toy has the same effect as a cone rifle firing napalm,\
 and the elfbot's armour has no effect against your laser.");
  for (i = 0; i < 2; i++) {
    if (dice_roll(1, 100) <= 25) {
      puts("You have been hit!");
      hit_points -= dice_roll(1, 10);
      if (hit_points <= 0)
        return new_clone(45);
    } else
        puts("It missed you, but not by much!");
    if (dice_roll(1, 100) <= 40) {
      puts("You zapped the little bastard!");
      robot_hp -= dice_roll(2, 10);
      if (robot_hp <= 0) {
        puts("You wasted it! Good shooting!");
        Wrap("You will need more evidence, so you search GDH7-beta further");
        if (hit_points < 10) Wrap("after the GDH medbot has patched you up.");
        hit_points = 10;
        return 22;
      }
    } else
      puts("Damn! You missed!");
  }
  Wrap("It tried to fire again, but the toy exploded and demolished it.\
 You will need more evidence, so you search GDH7-beta further");
  if (hit_points < 10) Wrap("after the GDH medbot has patched you up.");
  hit_points = 10;
 return 22;
}

int page18(void)
{
  Wrap("You walk to the centre of the hall, ogling like an infrared fresh from the\
 clone vats. Towering before you is the most unearthly thing you have ever\
 seen, a green multi-armed mutant horror hulking 15 feet above your head.");
  more();
  Wrap("Its skeletal body is draped with hundreds of metallic strips (probably to\
 negate the effects of some insidious mutant power), and the entire hideous\
 creature is wrapped in a thousand blinking hazard lights.");
 more();
 Wrap("It's times like this when you wish you'd had some training for this job.\
 Luckily the creature doesn't take notice of you but stands unmoving, as though\
 waiting for a summons from its dark lord, the Master Retailer. \nWHAM, suddenly\
 you are struck from behind.");
  more();
  if (dice_roll(2, 10) < AGILITY)
    return 19;
  else
    return 20;
}

int page19(void)
{
  Wrap("Quickly you regain your balance, whirl and fire your laser into the Ultraviolet\
 citizen behind you. For a moment your heart leaps to your throat, then you realise\
 that he is indeed dead and you will be the only one filing a report on this incident.");
  more();
  Wrap("Besides, he was participating in this traitorous Christmas\
 shopping, as is evident from the rain of shoddy toys falling all around you.\
 Another valorous deed done in the service of The Computer!");
  if (++killer_count > (MAXKILL - Cnum))  return 21;
  if (read_letter == 1)  return 22;
 return choose(34, "You search the body, keeping an eye open for Internal Security",
               22, "You run away like the cowardly dog you are");
}

int page20(void)
{
  Wrap("Oh no! you can't keep your balance. You're falling, falling head first into\
 the Christmas beast's gaping maw. It's a valiant struggle; you think you are\
 gone when its poisonous needles dig into your flesh, but with a heroic effort\
 you jerk a string of lights free and jam the live wires into the creature's spine.");
  more();
  Wrap(" The Christmas beast topples to the ground and begins to burn, filling\
 the area with a thick acrid smoke. It takes only a moment to compose yourself,\
 and then you are ready to continue your search for the Master Retailer.");
  more();
 return 22;
}

int page21(void)
{
  Wrap("You have been wasting the leading citizens of Alpha Complex at a\
 prodigious rate. This has not gone unnoticed by the Internal Security\
 squad at GDH7-beta. Suddenly, a net of laser beams spear out of the gloomy\
 corners of the hall, chopping you into teeny, weeny bite size pieces.");
 return new_clone(45);
}

int page22(void)
{
  Wrap("You are searching Goods Distribution Hall 7-beta.");
  more();
  switch(dice_roll(1, 4))
  {
    case 1: return 18;
    case 2: return 15;
    case 3: return 18;
    case 4: return 29;
  }
}

int page23(void)
{
  Wrap("You go to the nearest computer terminal and declare yourself a mutant.\
 \"A mutant, he's a mutant,\" yells a previously unnoticed infrared who had\
 been looking over your shoulder. You easily gun him down, but not before a\
 dozen more citizens take notice and aim their weapons at you.");
 return choose(28, "You tell them that it was really only a bad joke",
               24, "You want to fight it out, one against twelve");
}

int page24(void)
{
  Wrap("Golly, I never expected someone to pick this. I haven't even designed\
 the 12 citizens who are going to make a sponge out of you. Tell you what,\
 I'll give you a second chance.");
 return choose(28, "You change your mind and say it was only a bad joke",
               25, "You REALLY want to shoot it out");
}

int page25(void)
{
  Wrap("Boy, you really can't take a hint! They're closing in. Their trigger fingers\
 are twitching, they're about to shoot. This is your last chance.");
 return choose(28, "You tell them it was all just a bad joke",
               26, "You are going to shoot");
}

int page26(void)
{
  Wrap("You can read the cold, sober hatred in their eyes (They really didn't think\
 it was funny), as they tighten the circle around you. One of them shoves a\
 blaster up your nose, but that doesn't hurt as much as the multi-gigawatt\
 carbonium tipped food drill in the small of your back.");
  more();
  Wrap("You spend the remaining micro-seconds of your life wondering what you did wrong.");
 return new_clone(32);
}

int page27(void)
{
  // Doesn't exist. Can't happen with computer
  // version. Designed to catch dice cheats.
}

int page28(void)
{
  puts("They don't think it's funny.");
 return 26;
}

int page29(void)
{
  Wrap("\"Psst, hey citizen, come here. Pssfft,\" you hear. When you peer around\
 you can see someone's dim outline in the shadows. \"I got some information\
 on the Master Retailer. It'll only cost you 30 psst credits.\"");
  Wrap("[A] You pay the 30 credits.");
  Wrap("[B] You would rather threaten him for the information.");
  Wrap("[C] You ignore him and walk away.");
  switch (get_char())
  {
    case 'a': return 30;
    case 'b': return 31;
    case 'c':
    default:  return 22;
  }
}

int page30(void)
{
  Wrap("You step into the shadows and offer the man a thirty credit bill. \"Just drop\
 it on the floor,\" he says. \"So you're looking for the Master Retailer, pssfft?\
 I've seen him, he's a fat man in a fuzzy red and white jump suit. They say\
 he's a high programmer with no respect for proper security.");
  more();
  Wrap("If you want to find him then pssfft step behind me and go through the door.\"\
 Behind the man is a reinforced plasteel blast door. The centre of it has been\
 buckled toward you in a manner you only saw once before when you were field\
 testing the rocket assist plasma slingshot (you found it easily portable but\
 prone to misfire).");
  more();
  Wrap("Luckily it isn't buckled too far for you to make out the warning sign.\
 WARNING!! Don't open this door or the same thing will happen to you. Opening\
 this door is a capital offense. This is not a joke.");
  Wrap("[A] You use your Precognition mutant power on opening the door.");
  Wrap("[B] You just go through the door anyway.");
  Wrap("[C] You decide it's too dangerous and walk away.");
  switch (get_char())
  {
    case 'a': return 56;
    case 'b': return 33;
    case 'c':
    default:  return 22;
  }
}

int page31(void)
{
  Wrap("Like any good troubleshooter you make the least expensive decision and threaten\
 him for information. With lightning like reflexes you whip out your laser and\
 stick it up his nose. \"Talk, you traitorous Christmas celebrator, or who nose\
 what will happen to you, yuk yuk,\" you pun menacingly, and then you notice\
 something is very wrong.");
  more();
  Wrap("He doesn't have a nose. As a matter of fact he's made of one eighth inch\
 cardboard and your laser is sticking through the other side of his head. \"Are you\
 going to pay?\" says his mouth speaker,\"or are you going to pssfft go away stupid?\"");
 return choose(30, "You pay the 30 credits",
               22, "You pssfft go away stupid");
}

int page32(void)
{
  Wrap("Finally it's your big chance to prove that you're as good a troubleshooter\
 as your previous clone. You walk briskly to mission briefing and pick up your\
 previous clone's personal effects and notepad. After reviewing the notes you\
 know what has to be done.");
  more();
  Wrap("You catch the purple line to Goods Distribution Hall 7-beta and begin\
 to search for the blast door.");
 return 22;
}

int page33(void)
{
  blast_door = 1;
  Wrap("You release the megabolts on the blast door, then strain against it with your\
 awesome strength. Slowly the door creaks open. You bravely leap through the\
 opening and smack your head into the barrel of a 300 mm 'ultra shock' class plasma\
 cannon.");
  more();
  Wrap("It's dark in the barrel now, but just before your head got stuck you can\
 remember seeing a group of technicians anxiously watch you leap into the room.");
  more();
  if (ultra_violet == 1)
    return 35;
  else
    return 36;
}

int page34(void)
{
  Wrap("You have found a sealed envelope on the body. You open it and read:\
 \"WARNING: Ultraviolet Clearance ONLY. DO NOT READ. Memo from Chico-U-MRX4 to\
 Harpo-U-MRX5. The planned takeover of the Troubleshooter Training Course goes well,\
 Comrade. Once we have trained the unwitting bourgeois troubleshooters to work as\
 communist dupes, the overthrow of Alpha Complex will be unstoppable.");
  more();
  Wrap("My survey of the complex has convinced me that no one suspects a thing;\
 soon it will be too late for them to oppose the revolution. The only thing that could\
 possibly impede the people's revolution would be someone alerting The Computer to our\
 plans (for instance, some enterprising Troubleshooter could tell The Computer");
  more();
  Wrap("that the communists have liberated the Troubleshooter Training Course and plan\
 to use it as a jumping off point from which to undermine the stability of all\
 Alpha Complex), but as we both know, the capitalistic Troubleshooters would\
 never serve the interests of the proletariat above their own bourgeois desires.");
  more();
  Wrap("P.S. I'm doing some Christmas shopping later today. Would you like me to pick\
 you up something?\" When you put down the memo you are overcome by that strange\
 deja'vu again. You see yourself talking privately with The Computer.");
  more();
  Wrap("You are telling it all about the communists' plan, and then the scene shifts\
 and you see yourself showered with awards for foiling the insidious communist plot to\
 take over the complex.");
  read_letter = 1;
 return choose(46, "You rush off to the nearest computer terminal to expose the commies",
               22, "You wander off to look for more evidence");
}

int page35(void)
{
  Wrap("\"Oh master,\" you hear through the gun barrel, \"where have you been? It is\
 time for the great Christmas gifting ceremony. You had better hurry and get\
 the costume on or the trainee may begin to suspect.\"  For the second time\
 today you are forced to wear attire not of your own choosing.");
  more();
  Wrap("They zip the suit to your chin just as you hear gunfire erupt behind you.\
 \"Oh no! Who left the door open?  The commies will get in. Quick, fire the\
 laser cannon or we're all doomed.\" \"Too late you capitalist swine, the people's\
 revolutionary strike force claims this cannon for the proletariat's valiant struggle\
 against oppression.");
  more();
  Wrap("Take that, you running dog imperialist lackey. ZAP, KAPOW\" Just when you\
 think that things couldn't get worse, \"Aha, look what we have here, the Master\
 Retailer himself with his head caught in his own cannon. His death will serve as a\
 symbol of freedom for all Alpha Complex. Fire the cannon.\"");
  more();
 return new_clone(32);
}

int page36(void)
{
  Wrap("\"Congratulations, troubleshooter, you have successfully found the lair of the\
 Master Retailer and completed the Troubleshooter Training Course test mission,\"\
 a muffled voice tells you through the barrel. \"Once we dislodge your head from the\
 barrel of the 'Ultra Shock' plasma cannon you can begin with the training seminars.");
  more();
  Wrap("The first of which will concern the 100% accurate identification and elimination\
 of unregistered mutants. If you have any objections please voice them now.\"");
  Wrap("[A] You appreciate his courtesy and voice an objection.");
  Wrap("[B] You register as a mutant.");
  Wrap("[C] You go to the unregistered mutant identification and elimination seminar.");
  switch (get_char())
  {
    case 'a': return new_clone(32);
    case 'b': return 23;
    case 'c':
    default:  return 37;
  }
}

int page37(void)
{
  Wrap("\"Come with me please, Troubleshooter,\" says the Green clearance technician\
 after he has dislodged your head from the cannon. \"You have been participating in\
 the Troubleshooter Training Course since you got off the tube car in GDH7-beta,\"\
 he explains as he leads you down a corridor.");
  more();
  Wrap("\"The entire Christmas assignment was a test mission to assess your current\
 level of training. You didn't do so well. We're going to start at the beginning with\
 the other student. Ah, here we are, the mutant identification and elimination lecture.\"\
 He shows you into a vast lecture hall filled with empty seats.");
  more();
  Wrap("There is only one other student here, a Troubleshooter near the front row playing\
 with his Action Troubleshooter(tm) figure. \"Find a seat and I will begin,\" says the instructor.");
 return 38;
}

int page38(void)
{
  sprintf(tmp,"\"I am Plato-B-PHI%d, head of mutant propaganda here at the training course.", plato_clone);
  Wrap(tmp);
  more();
  Wrap("If you have any questions about mutants please come to me. Today I will be talking\
 about mutant detection. Detecting mutants is very easy. One simply watches for certain\
 tell tale signs, such as the green scaly skin, the third arm growing from the forehead,\
 or other similar disfigurements so common with their kind.");
  more();
  Wrap("There are, however, a few rare specimens that show no outward sign of their\
 treason. This has been a significant problem, so our researchers have been working\
 on a solution. I would like a volunteer to test this device,\" he says, holding up\
 a ray gun looking thing. It is a mutant detection ray.");
  more();
  Wrap("\"This little button detects for mutants, and this big button stuns them once\
 they are discovered. Who would like to volunteer for a test?\" The Troubleshooter\
 down the front squirms deeper into his chair.");
 return choose(39, "You volunteer for the test",
               40, "You duck behind a chair and hope the instructor doesn't notice you");
}

int page39(void)
{
  Wrap("You bravely volunteer to test the mutant detection gun. You stand up and walk\
 down the steps to the podium, passing a very relieved Troubleshooter along the\
 way. When you reach the podium Plato-B-PHI hands you the mutant detection gun\
 and says, \"Here, aim the gun at that Troubleshooter and push the small button.\
 If you see a purple light, stun him.\"");
  more();
  Wrap("Grasping the opportunity to prove your worth to The Computer, you fire the\
 mutant detection ray at the Troubleshooter. A brilliant purple nimbus instantly\
 surrounds his body. You slip your finger to the large stun button and he falls\
 writhing to the floor. \"Good shot,\" says the instructor as you hand him the\
 mutant detection gun,");
  more();
  Wrap("\"I'll see that you get a commendation for this. It seems you have the hang\
 of mutant detection and elimination. You can go on to the secret society\
 infiltration class. I'll see that the little mutie gets packaged for tomorrow's\
 mutant dissection class.\"");
  more();
 return 41;
}

int page40(void)
{
  Wrap("You breathe a sigh of relief as Plato-B-PHI picks on the other Troubleshooter.\
 \"You down here in the front,\" says the instructor pointing at the other Troubleshooter,\
 \"you'll make a good volunteer. Please step forward.\" The Troubleshooter looks around\
 with a \`who me?' expression on his face, but since he is the only one visible in the\
 audience he figures his number is up.");
  more();
  Wrap("He walks down to the podium clutching his Action Troubleshooter(tm) doll before\
 him like a weapon. \"Here,\" says Plato-B-PHI, \"take the mutant detection ray and point\
 it at the audience. If there are any mutants out there we'll know soon enough.\" Suddenly\
 your skin prickles with static electricity as a bright purple nimbus surrounds your body.");
  more();
  Wrap("\"Ha Ha, got one,\" says the instructor. \"Stun him before he gets away.\"");
  while (1) {
    if (dice_roll(1, 100) <= 30) {
      beep(1);
      Wrap("His shot hits you. You feel numb all over.");
      return 49;
    } else
      puts("His shot just missed.");
    if (dice_roll(1, 100) <= 40) {
      beep(2);
      Wrap("You just blew his head off. His lifeless hand drops the mutant detector ray.");
      return 50;
    } else
      Wrap("You burnt a hole in the podium. He sights the mutant detector ray on you.");
  }
}

int page41(void)
{
  Wrap("You stumble down the hallway of the Troubleshooter Training Course looking for\
 your next class. Up ahead you see one of the instructors waving to you. When\
 you get there he shakes your hand and says, \"I am Jung-I-PSY. Welcome to the\
 secret society infiltration seminar. I hope you ...\"");
  more();
  Wrap("You don't catch the rest of his greeting because you're paying too much attention\
 to his handshake; it is the strangest thing that has ever been done to your hand, sort\
 of how it would feel if you put a neuro whip in a high energy palm massage unit.");
  more();
  Wrap("It doesn't take you long to learn what he is up to; you feel him briefly shake\
 your hand with the secret Illuminati handshake.");
 return choose(42, "You respond with the proper Illuminati code phrase, \"Ewige Blumenkraft\"",
               43, "You ignore this secret society contact");
}

int page42(void)
{
  Wrap("\"Aha, so you are a member of the elitist Illuminati secret society,\" he says\
 loudly, \"that is most interesting.\"  He turns to the large class already\
 seated in the auditorium and says, \"You see, class, by simply using the correct\
 hand shake you can identify the member of any secret society.");
  more();
  Wrap("Please keep your weapons trained on him while I call a guard.");
 return choose(51, "You run for it",
               52, "You wait for the guard");
}

int page43(void)
{
  Wrap("You sit through a long lecture on how to recognise and infiltrate secret\
 societies, with an emphasis on mimicking secret handshakes. The basic theory,\
 which you realise to be sound from your Iluminati training, is that with the\
 proper handshake you can pass unnoticed in any secret society gathering.");
  more();
  Wrap("What's more, the proper handshake will open doors faster than an 'ultra shock'\
 plasma cannon. You are certain that with the information you learn here you will\
 easily be promoted to the next level of your Illuminati secret society. The lecture\
 continues for three hours, during which you have the opportunity to practice many\
 different handshakes.");
  more();
  Wrap("Afterwards everyone is directed to attend the graduation ceremony. Before\
 you must go you have a little time to talk to The Computer about, you know, certain topics.");
 return choose(44, "You go looking for a computer terminal",
               55, "You go to the graduation ceremony immediately");
}

int page44(void)
{
  Wrap("You walk down to a semi-secluded part of the training course complex and\
 activate a computer terminal. \"AT YOUR SERVICE\" reads the computer screen.");
  if (read_letter == 0)
    return choose(23, "You register yourself as a mutant", 55, "You change your mind and go to the graduation ceremony");
  Wrap("[A] You register yourself as a mutant.");
  Wrap("[B] You want to chat about the commies.");
  Wrap("[C] You change your mind and go to the graduation ceremony.");
  switch (get_char())
  {
    case 'a': return 23;
    case 'b': return 46;
    case 'c':
    default:  return 55;
  }
}

int page45(void)
{
  beep(1);
  Wrap("\"Hrank Hrank,\" snorts the alarm in your living quarters. Something is up.\
 You look at the monitor above the bathroom mirror and see the message you have\
 been waiting for all these years. \"ATTENTION TROUBLESHOOTER, YOU ARE BEING\
 ACTIVATED. PLEASE REPORT IMMEDIATELY TO MISSION ASSIGNMENT ROOM A17/GAMMA/LB22.\
 THANK YOU. THE COMPUTER IS YOUR FRIEND.\"");
  more();
  Wrap("When you arrive at mission assignment room A17-gamma/LB22 you are given your\
 previous clone's remaining possessions and notebook. You puzzle through your\
 predecessor's cryptic notes, managing to decipher enough to lead you to the tube\
 station and the tube car to GDH7-beta.");
  more();
 return 10;
}

int page46(void)
{
  Wrap("\"Why do you ask about the communists, Troubleshooter? It is not in the interest\
 of your continued survival to be asking about such topics,\" says The Computer.");
 return choose(53, "You insist on talking about the communists",
               54, "You change the subject");
}

int page47(void)
{
  Wrap("The Computer orders the entire Vulture squadron to terminate the Troubleshooter\
 Training Course. Unfortunately you too are terminated for possessing classified\
 information. Don't act so innocent, we both know that you are an Illuminatus which \
 is in itself an act of treason.\nDon't look to me for sympathy.");
  puts("THE END");
 return 0;
}

int page48(void)
{
  Wrap("The tubecar shoots forward as you enter, slamming you back into a pile of\
 garbage. The front end rotates upward and you, the garbage and the garbage\
 disposal car shoot straight up out of Alpha Complex. One of the last things\
 you see is a small blue sphere slowly dwindling behind you. After you fail to\
 report in, you will be assumed dead.");
 return new_clone(45);
}

int page49(void)
{
  Wrap("The instructor drags your inert body into a specimen detainment cage.\
 \"He'll make a good subject for tomorrow's mutant dissection class,\" you hear.");
 return new_clone(32);
}

int page50(void)
{
  Wrap("You put down the other Troubleshooter, and then wisely decide to drill\
 a few holes in the instructor as well; the only good witness is a dead witness.\
 You continue with the training course.");
  plato_clone++;
 return 41;
}

int page51(void)
{
  Wrap("You run for it, but you don't run far. Three hundred strange and\
 exotic weapons turn you into a freeze dried cloud of soot.");
 return new_clone(32);
}

int page52(void)
{
  Wrap("You wisely wait until the instructor returns with a Blue Internal Security\
 guard. The guard leads you to an Internal Security self incrimination station.");
 return 2;
}

int page53(void)
{
  puts("You tell The Computer about:");
 return choose(47, "The commies who have infiltrated the Troubleshooter Training Course and the impending Peoples Revolution",
               54, "Something less dangerous");
}

int page54(void)
{
  Wrap("\"Do not try to change the subject, Troubleshooter,\" says The Computer.\
 \"It is a serious crime to ask about the communists. You will be terminated\
 immediately. Thank you for your inquiry. The Computer is your friend.\"\
 Steel bars drop to your left and right, trapping you here in the hallway.");
  more();
  beep(0);
  Wrap("A spotlight beams from the computer console to brilliantly iiluminate you while\
 the speaker above your head rapidly repeats \"Traitor, Traitor, Traitor.\" It\
 doesn't take long for a few guards to notice your predicament and come to finish you off.");
  if (blast_door == 0)
    return new_clone(45);
  else
    return new_clone(32);
}

int page55(void)
{
  MSequence_play_background(&mus);
  Wrap("You and 300 other excited graduates are marched from the lecture hall\
 and into a large auditorium for the graduation exercise. The auditorium is\
 extravagantly decorated in the colours of the graduating class. Great red and\
 green plasti-paper ribbons drape from the walls, while a huge sign reading");
  more();
  Wrap("\"Congratulations class of GDH7-beta-203.44/A\" hangs from the raised stage down\
 front. Once everyone finds a seat the ceremony begins. Jung-I-PSY is the\
 first to speak, \"Congratulations students, you have successfully survived the\
 Troubleshooter Training Course.");
  more();
  Wrap("It always brings me great pride to address the graduating class, for I know,\
 as I am sure you do too, that you are now qualified for the most perilous missions\
 The Computer may select for you. The thanks is not owed to us of the teaching staff,\
 but to all of you, who have persevered and graduated.");
  more();
  Wrap("Good luck and die trying.\" Then the instructor begins reading the names of\
 the students who one by one walk to the front of the auditorium and receive their\
 diplomas. Soon it is your turn, \"Philo-R-DMD, graduating a master of mutant\
 identification and secret society infiltration.\"");
  more();
  sprintf(tmp,"You walk up and receive your diploma from Plato-B-PHI %d, then", plato_clone);
  Wrap(tmp);
  Wrap("return to your seat. There is another speech after the diplomas are handed\
 out, but it is cut short by by rapid fire laser bursts from the high spirited\
 graduating class. You are free to return to your barracks to wait, trained\
 and fully qualified, for your next mission.");
  more();
  Wrap("You also get that cherished promotion from the Illuminati secret society.\
 In a week you receive a detailed Training Course bill totalling 1,523 credits.");
  more();
  puts("THE END");
 return 0;
}

int page56(void)
{
  Wrap("That familiar strange feeling of deja'vu envelops you again. It is hard to say,\
 but whatever is on the other side of the door does not seem to be intended for you.");
 return choose(33, "You open the door and step through",
               22, "You go looking for more information");
}

int page57(void)
{
  Wrap("In the centre of the room is a table and a single chair. There is an Orange\
 folder on the table top, but you can't make out the lettering on it.");
 return choose(11, "You sit down and read the folder",
               12, "You leave the room");
}

int next_page(int this_page)
{
  puts("");
  switch (this_page)
  {
    case 0: return 0;
    case 1: return page1();
    case 2: return page2();
    case 3: return page3();
    case 4: return page4();
    case 5: return page5();
    case 6: return page6();
    case 7: return page7();
    case 8: return page8();
    case 9: return page9();
    case 10: return page10();
    case 11: return page11();
    case 12: return page12();
    case 13: return page13();
    case 14: return page14();
    case 15: return page15();
    case 16: return page16();
    case 17: return page17();
    case 18: return page18();
    case 19: return page19();
    case 20: return page20();
    case 21: return page21();
    case 22: return page22();
    case 23: return page23();
    case 24: return page24();
    case 25: return page25();
    case 26: return page26();
    case 27: return page27();
    case 28: return page28();
    case 29: return page29();
    case 30: return page30();
    case 31: return page31();
    case 32: return page32();
    case 33: return page33();
    case 34: return page34();
    case 35: return page35();
    case 36: return page36();
    case 37: return page37();
    case 38: return page38();
    case 39: return page39();
    case 40: return page40();
    case 41: return page41();
    case 42: return page42();
    case 43: return page43();
    case 44: return page44();
    case 45: return page45();
    case 46: return page46();
    case 47: return page47();
    case 48: return page48();
    case 49: return page49();
    case 50: return page50();
    case 51: return page51();
    case 52: return page52();
    case 53: return page53();
    case 54: return page54();
    case 55: return page55();
    case 56: return page56();
    case 57: return page57();
    default: break;
  }
}

//-----------------------------------------------------------------------------
// Main - Program Entry Point                                                 |
//-----------------------------------------------------------------------------
long main(int argc, char* argv[], bool start)
{
  init_module(&main_module); // Initialize module
  MSequence_ctor(&mus,"txg.mus");
  MSequence_play_background(&mus);
  draw_lib(0,0,0,60,BM_NORMAL); // Display title bmp
  DisplayGraphics_show(main_module.m_gfx); // Update Display
  sleep(2000); // 2 sec pause
  Graphics_set_font(main_module.m_gfx, mini_normal_font); // Set mini font
  srand(clock());
  instructions();
  character();

  while((page=next_page(page)) != 0);

  MSequence_dtor(&mus,LEAVE_MEMORY);
 return 0L;	
}

