//-----------------------------------------------------------------------------
// "The Last City" - an adventure game  Copyright (c) 1983 by Roger M. Wilcox |
// Turbo C port copyright (c) 1989 by Roger M. Wilcox,  Cybiko port by Athlor |
//-----------------------------------------------------------------------------
#include <CyWin.h>
#include "lastcity.h"

place p[]={
 {"",{0,0,0,0,0,0}},
 {"wandering along the remains of an east/west freeway",{2,3,14,1,0,0}},
 {"in a seemingly endless desert",{2,1,2,2,0,0}},
 {"in a magically-contaminated wasteland. The sky above\
 you is a murky grey-black (which is strange for mid-day)",{1,4,3,3,0,0}},
 {"at the foot of an ancient-looking castle. A moat prevents\
 you from reaching its walls",{3,0,0,0,0,0}},
 {"in the foyer of the castle",{0,0,6,4,0,0}},
 {"in the main audience chamber of the castle. The light here\
 is by comparison rather subdued",{0,8,0,5,0,0}},
 {"in an unconceiled missile control room. The illusion of the\
 castle does not extend this far... ",{0,0,0,6,0,0}},
 {"in the master bedroom of the castle",{6,0,0,9,0,0}},
 {"in the master bathroom of the castle",{0,0,8,0,0,0}},
 {"in an underground storage chamber. Its walls are obviously\
 made of plastic; the illusion of the castle does not extend\
 this far down... ",{0,0,0,0,9,0}},
 {"in a deserted old pawn shop",{0,14,0,0,0,0}},
 {"at the edge of a gigantic domed city",{0,0,0,14,0,0}},
 {"inside the dome on the city's west side",{17,15,19,0,0,0}},
 {"wandering along the remains of an ancient boulevard",{11,0,12,1,0,0}},
 {"at the south edge of the city",{21,0,16,13,0,0}},
 {"at the east edge of the city",{17,15,0,20,0,0}},
 {"at the north edge of the city",{0,18,16,13,0,0}},
 {"at the bottom of the city's central tower. A monolith of\
 sandstone rises all the way up to the dome",{17,0,20,19,0,0}},
 {"in the midst of some buildings",{18,21,0,13,0,0}},
 {"in an unused part of the city",{18,21,16,0,0,0}},
 {"in the city's botanical section",{0,15,20,19,0,0}},
 {"on a metal ladder",{0,0,0,0,15,23}},
 {"in an advanced (but forgotten) sewer",{0,0,0,0,22,0}},
 {"right under the dome,on top of the tower",{0,0,0,0,0,18}},
 {"on top of the dome. The view is clear for kilometers around.\
 ...except for a dark cloud of magic (too strong for your senses)\
 obscuring your view to the southwest",{0,0,0,0,0,24}},
 {"in a secluded rock formation",{0,0,0,0,0,0}},
 {"in city hall",{0,0,19,0,0,0}}
};

char *sd[]={  // These small descriptions were
 "",          // added for Cybiko's display top
 "east/west freeway",
 "endless desert",
 "wasteland",
 "foot of castle",
 "castle foyer",
 "audience chamber",
 "control room",
 "master bedroom",
 "master bathroom",
 "storage chamber",
 "pawn shop",
 "outside city",
 "west side",
 "ancient boulevard",
 "south edge",
 "east edge",
 "north edge",
 "central tower",
 "midst of buildings",
 "unused part",
 "botanical section",
 "metal ladder",
 "advanced sewer",
 "top of tower",
 "top of dome",
 "rock formation",
 "city hall"
};

struct object ob[]={
 {"",0},
 {"Steel door",6},
 {"Toilet",9},
 {"Brass bed",8},
 {"Royal paraphernalia",6},
 {"Sign",5},
 {"Humongous control console",7},
 {"Raised drawbridge",4},
 {"Concrete rubble",1},
 {"Asphalt rubble",14},
 {"Horizontal pipes",23},
 {"Various magic items",20},
 {"Square metal ground cover",15},
 {"Light human traffic",0},
 {"City Hall",19},
 {"Levered-up concrete block",0},
 {"Hydroponics",21},
 {"Various potted flowers",21},
 {"Circular ceiling hatch",24},
 {"Small advanced device",11},
 {"Fulcrum",11},
 {"Plank",11},
 {"Lever",0},
 {"Parchment",0},
 {"Magic wand",0},
 {"Charged-up magic wand",0},
 {"Sand shovel",11},
 {"Dirt shovel",0},
 {"Magic stone",0},
 {"Half-donut",23},
 {"Key",0},
 {"Small plastic explosive",10},
 {"Laser cutter",25},
 {"Discharged laser cutter",0},
 {"Pick and pitons",11},
 {"Perpetual lamp",27}
};

int cp=1, tr=300, p5=FALSE, q=0; // q=Quit
char t[256]=""; // Temp string

//-----------------------------------------------------------------------------
// Cybiko Specific:  clrln, Scroll, puts, Wrap, _getch, gets, more & printf   |
//-----------------------------------------------------------------------------
struct MSequence mus; // Structures
struct FileInput f_in;
struct FileOutput f_out;
struct Message* ptr_msg;
struct module_t main_module;

void clrln(void)
{
  TGraph_set_color(main_module.m_gfx,CLR_WHITE);
  TGraph_fill_rect(main_module.m_gfx,0,91,160,9); // Erase bottom line
  TGraph_set_color(main_module.m_gfx,CLR_BLACK);
}

void Scroll(void)
{
  TGraph_scroll(main_module.m_gfx,0,19,160,82,0,-9); // WAS 18
  clrln();
}

int puts(char *s)
{
  Scroll();
  Graphics_draw_text(main_module.m_gfx,s,0,90); // Print Text
  DisplayGraphics_show(main_module.m_gfx); // Update Display
}

void Wrap(char *s)
{
 char l[64];int i;int lsp;
  while(DisplayGraphics_string_width(main_module.m_gfx,s)>155)
  {
    i=0;l[i]=0;
    do{
      if(*s==32) lsp=i; // Remember last space
      l[i++]= *s++; l[i]=0;
    }while(Graphics_string_width(main_module.m_gfx,l)<155&&(l[i-1]!='\n'));
    if(*(s-1)!='\n') {s=s-(i-lsp)+1;i=lsp;l[i++]='\n';l[i]=0;}
    puts(l);
  }
  puts(s);
}

int _getch(void)
{
 int key;bool pressed=FALSE;
  do{
    ptr_msg=cWinApp_get_message(main_module.m_process,0,1,MSG_USER);
    switch(ptr_msg->msgid)
    {
      case MSG_KEYDOWN:
        key=Message_get_key_param(ptr_msg)->scancode; // Allows spec keys
        switch(key)
        {
          case KEY_ENTER: case KEY_BACKSPACE: case KEY_RIGHT: case KEY_SELECT:
          case KEY_UP: case KEY_DOWN: case KEY_LEFT: case KEY_DEL: case KEY_TAB:
          case KEY_ESC: pressed=TRUE;
          case KEY_SHIFT: case KEY_CONTROL: break;
          default: pressed=TRUE; key=Message_get_key_param(ptr_msg)->ch; break;
        }
        break;
      default:
      cWinApp_defproc(main_module.m_process,ptr_msg); // Process Remaining
    }
    Message_delete(ptr_msg); // Delete processed message
  }while(!pressed);
 return key;
}

void gets(char *lbuf)
{
int key,i=0;bool done=FALSE;
  Scroll();
  lbuf[0]=0;
  do{
    key=_getch(); // Wait until a key is pressed
    if(key==KEY_LEFT)  {strcpy(lbuf,"w");break;} // Controller pad hack
    if(key==KEY_UP)    {strcpy(lbuf,"n");break;}
    if(key==KEY_RIGHT) {strcpy(lbuf,"e");break;}
    if(key==KEY_DOWN)  {strcpy(lbuf,"s");break;}
    if(key==KEY_ESC)   {strcpy(lbuf,"quit game");break;}
    switch(key)
    {
      case KEY_ENTER: lbuf[i]=0; done=TRUE; break;
      case KEY_BACKSPACE: if(i) lbuf[--i]=0; break;
      default: lbuf[i++]=(char)key; lbuf[i]=0; break;
    }
    clrln();
    Graphics_draw_text(main_module.m_gfx,lbuf,0,91);
    DisplayGraphics_show(main_module.m_gfx); // Update Display
  }while(!done);
}

int printf(char *tmp, ...)
{
 /*char tbuf[128]; char *t=tbuf;*/
  vsprintf(t, tmp, &tmp+1);
  Wrap(t);
}

void more(void)
{
  LED |= 8; // Turn Green LED ON
  _getch();
  LED &= 247; // Turn Green LED OFF 
}

void sndfx(void)
{
 int i;

  for(i=1365;i<6505;i++) play_raw(i); // Sweep down
  (*(char *)0x600000)=0x00;(*(char *)0x600001)=0x59|0x04; // Reverse Video
  for(i=0;i<4096;i++) play_tone(random(68)); // Explosion noise
  (*(char *)0x600000)=0x00;(*(char *)0x600001)=0x59 & ~0x04; // Normal Video
}

//-----------------------------------------------------------------------------
void dead(void)
{
  Wrap("\n\nThe adventure is now over.");
  q=1; // QUIT
}

int dark(void)
{
  if((cp==8 || cp==9 || cp==10 || cp==22 || cp==23) &&
    ob[35].room!=HELD && ob[35].room != cp) return TRUE;
  else return FALSE;
}

void show_room(void)
{
 int i,j;
 static const char dir[][6]={
 "North",
 "South",
 "East",
 "West",
 "Up",
 "Down"};
  cprintf("Area: %d\n",cp); // DEBUG
  TGraph_set_color(main_module.m_gfx,CLR_LTGRAY);
  TGraph_fill_rect(main_module.m_gfx,0,0,160,18); // Erase gfx area WAS 18
  TGraph_set_color(main_module.m_gfx,CLR_DKGRAY);
  TGraph_draw_hline(main_module.m_gfx,0,18,160); // Draw line 19
  Graphics_draw_text(main_module.m_gfx,"The Last City",80,0);
  TGraph_set_color(main_module.m_gfx,CLR_BLACK);
  if(dark())
  {
    puts("It's too dark to see!");
    return;
  }
  Graphics_draw_text(main_module.m_gfx,sd[cp],111-
     Graphics_string_width(main_module.m_gfx,sd[cp])/2,8); // Small desc
  if(cp==13 || cp>=15 && cp<=19 || cp==21) ob[13].room=cp;
  if(ob[19].room==HELD) // Draw display
  {
    TGraph_draw_rect(main_module.m_gfx,4,2,30,14);
    TGraph_set_color(main_module.m_gfx,CLR_LTGRAY);
    if(p[cp].link[NORTH]) TGraph_draw_hline(main_module.m_gfx,13,2,24);
    if(p[cp].link[SOUTH]) TGraph_draw_hline(main_module.m_gfx,13,15,24);
    if(p[cp].link[EAST]) TGraph_draw_vline(main_module.m_gfx,33,5,12);
    if(p[cp].link[WEST]) TGraph_draw_vline(main_module.m_gfx,4,5,12);
    TGraph_set_color(main_module.m_gfx,CLR_BLACK);
    if(p[cp].link[UP]) Graphics_draw_text(main_module.m_gfx,"U",10,5);
    if(p[cp].link[DOWN]) Graphics_draw_text(main_module.m_gfx,"D",23,5);
  }
  printf("\nYou are %s.",p[cp].name);
  j=0;
  for(i=1; i<=NUM_OBJECTS; ++i)
    if(ob[i].room==cp)
    {
      j++;
      if(j==1) strcpy(t,"Visible items: ");
      if(j>1) strcat(t,", ");
      strcat(t,ob[i].name);
    }
  if(j>0) Wrap(t);
  j=0;
  for(i=NORTH; i<=DOWN; ++i)
    if(p[cp].link[i]!=0)
    {
      j++;
      if(j==1) strcpy(t,"Obvious exits: ");
      if(j>1) strcat(t,", ");
      strcat(t,dir[i]);
    }
  if(j>0) Wrap(t);
  if(cp==3 && ob[28].room!=HELD)
  {
    beep(1);sleep(2000);
    Wrap("You couldn't defend against the strong magic alone! You're dead!!");
    dead();
  }
  if(tr<41) printf("Magical premonition: city will cease to exist in %d turns.",tr);
}

int input_command(int *verb,int *noun)
{
 static const char verb_table[][5]={
 "",
 "n", "s", "e", "w", "u", "d",
 "go", "ente",
 "clim",
 "get", "take", ".",
 "drop", "put", "p",
 "help",
 "quit",
 "save",
 "load",
 "inve", "i",
 "look", "exam", "read", "l",
 "push", "pres", "work",
 "form", "make",
 "unlo", "open",
 "with", "use",
 "dig",
 "slee",
 "kill",
 "move",
 "thro",
 "wave",
 "cast",
 "char", "rech",
 "ligh", "igni"
  };
 static const char noun_table[][5]={
 "",
 "nort", "sout", "east", "west", "up", "down",
 "door",
 "toil",
 "bed",
 "roya", "para",
 "sign",
 "cont", "cons",
 "draw", "brid",
 "conc", "rubb", "asph",
 "pipe",
 "magi", "item",
 "squa", "cove",
 "huma", "traf", "peop",
 "city", "hall",
 "bloc",
 "hydr",
 "flow",
 "hatc",
 "devi",
 "butt",
 "one", "two", "thre", "four", "five",
 "fulc",
 "plan",
 "leve",
 "parc",
 "wand",
 "shov", "sand", "dirt",
 "ston",
 "half", "donu",
 "key",
 "plas", "expl",
 "lase", "cutt",
 "pick", "pito",
 "lamp",
 "ladd",
 "towe",
 "inve",
 "game",
 "rock",
 "red",
 "blac"
};
 int i;
 char response[30], verb_str[30], *temp, *noun_str=0;
  memset(response,0,30);
  puts("-> What now?");
  gets(response);
  i=0;
  while(response[i]!='\0' && response[i]!=' ') ++i;
  strncpy(verb_str,response,i);
  cprintf("%s\n",verb_str); // DEBUG
  if(i<30)
  {
    temp=response+i;
    while(*++temp==' ' && *temp!='\0');
      if(*temp!='\0') noun_str=temp;
  }
  cprintf("%s\n",noun_str);
  i=1;
  while(i<=NUM_VERBS && strncmp(verb_str,verb_table[i],4)) ++i;
  if(i<=NUM_VERBS) *verb=i;
  else
  {
    printf("I don't know how to \"%s\" something.",verb_str);
    return 1;
  }
  if(noun_str==0) // Single words
  {
    *noun=0;
    return 0;
  }
  i=1;
  while(i<=NUM_NOUNS && strncmp(noun_str,noun_table[i],4)) ++i;
  if(i<=NUM_NOUNS)
  {
    *noun=i;
    return 0;
  }
  else
  {
    printf("I don't know what \"%s\" is.",noun_str);
    return 1;
  }
}

void boom(void)
{
  sndfx();
  draw_lib(0,1,0,0,BM_NORMAL); // Draw explosion
  MSequence_play_background(&mus);
  Wrap("The last city of humankind has been destroyed!\
 The human race is forever lost to the cosmos.");
  more();
}

void last_move(void)
{
  Wrap("In the vicinity of the castle, a silo cranks open\
 and launches a short-range thermonuclear missile!");
  if(ob[6].room!=cp)
  {
    int i;
    Wrap("You watch helplessly as the missile streaks toward the city.");
    boom();
  }
  else
  {
    int verb, noun;
    Wrap("You've got just one turn before the missile reaches the city!");
      loop:
    while(input_command(&verb, &noun));
    if(verb!=26 && verb!=27) boom();
    else if(noun==35)
    {
      puts("Say again, but specify a color.");
      goto loop;
    }
    else if(noun!=65) boom();
    else
    {
      MSequence_play_background(&mus);
      Wrap("In a flash of yellow, the missile destroys itself in mid-air!");
      sndfx();
      Wrap("The last city is saved!\nA cheering crowd from the city gallantly\
 marches through the five-centimeter steel walls of the control room and carries\
 you off into the sunset.");
      more();
      Wrap("Now humanity can live and prosper once again . . . thanks to you!!");
    }
  }
}

void ok(void)
{
  puts("Ok");
}

void move_dir(int direc)
{
  if(dark()) Wrap("It's dangerous to move in the dark!");
  if(p[cp].link[direc]==0)
  {
    if(dark())
    {
      Wrap("You ran into a wall and broke\
 every bone in your body! You're dead!");
      dead();
    }
    else Wrap("There is no way to go that direction.");
  }
  else
  {
    cp=p[cp].link[direc];
    ok();
  }
}

void beyond_your_power(void)
{
  puts("It's beyond your power to do that.");
}

void not_yet(void)
{
  puts("You can't do that... yet!");
}

void dont_see_it(void)
{
  puts("You don't see it here.");
}

void not_holding_it(void)
{
  puts("You're not holding it.");
}

void nothing_special(void)
{
  puts("You see nothing special.");
}

void found_something(void)
{
  puts("You found something.");
}

void being_weird(void)
{
  puts("Oh, stop being weird.");
}

void zzzzz(void)
{
  if(ob[3].room!=cp) puts("There's nothing here to sleep on.");
  else Wrap("No time for that now! You've got to save the city!");
}

void go(int noun)
{
  switch(noun) {
  case 0: Wrap("You need to specify a direction, too.");break;
  case 1: move_dir(NORTH);break;
  case 2: move_dir(SOUTH);break;
  case 3: move_dir(EAST);break;
  case 4: move_dir(WEST);break;
  case 5: move_dir(UP);break;
  case 6: move_dir(DOWN);break;
  case 8:
    if(ob[2].room!=cp) dont_see_it();
    else puts("Thanks. I needed that.");
    break;
  case 9: zzzzz();break;
  case 28: case 29:
    if(ob[14].room!=cp) dont_see_it();
    else
    {
      cp=27;
      ok();
    }
    break;
  case 61:
    if(cp==24) puts("You're on it.");
    else if(cp!=18) dont_see_it();
    else if(ob[34].room!=HELD) puts("Sorry. It's too steep and smooth.");
    else
    {
      ok();
      cp=24;
    }
    break;
  default: beyond_your_power();
  }
}

void climb(int noun)
{
  if(noun!=5 && noun!=6 && noun!=61) being_weird();
  else go(noun);
}

void inventory(void)
{
 int i,j=0;
  strcpy(t,"You are currently holding the following: ");
  for(i=19; i<=NUM_OBJECTS; ++i)
    if(ob[i].room==HELD)
    {
      j++;
      if(j>1) strcat(t,", ");
      strcat(t,ob[i].name);
    }
  if(j==0) strcat(t,"nothing at all");
  Wrap(t);
}

void td_do(int from, int to, int object)
{
  if(ob[object].room != from)
    if(from==HELD) not_holding_it();
    else dont_see_it();
  else
  {
    ok();
    ob[object].room=to;
  }
}

void take_drop(int noun, int from, int to)
{
  switch(noun) {
  case 34: td_do(from,to,19);break;
  case 41: case 42: case 43: case 44: td_do(from,to,noun-21);break;
  case 45:
    if(from==cp && ob[11].room==from && ob[24].room==0
        && ob[25].room==0)
    {
      ok();
      ob[24].room=to;
    }
    else if(ob[25].room==from)
    {
      ok();
      ob[25].room=to;
    }
    else td_do(from,to,24);break;
  case 46:
    if(ob[27].room==from)
    {
      ok();
      ob[27].room=to;
      break;
    }
  case 47: td_do(from,to,26);break;
  case 48: td_do(from,to,27);break;
  case 49: td_do(from,to,28);break;
  case 50: case 51: td_do(from,to,29);break;
  case 52: td_do(from,to,30);break;
  case 53: case 54:td_do(from,to,31);break;
  case 55: case 56:
    if(ob[33].room==from)
    {
      ok();
      ob[33].room=to;
    }
    else td_do(from, to, 32);
    break;
  case 57: case 58: td_do(from,to,34);break;
  case 59: td_do(from,to,35);
  }
}

void take(int noun)
{
 int from, to;
  if(noun==0) puts("Get what?");
  else if(noun<=5) puts("I don't get it.");
  else if(noun==6) puts(". . . and boogie!");
  else if(noun==62) inventory();
  else if(noun<=40 && noun!=34 || noun>=60)
    beyond_your_power();
  else
  {
    to=0;
    for(from=19; from<=NUM_OBJECTS; ++from)
      if(ob[from].room==HELD) ++to;
    if(to>=MAXINV) Wrap("You are currently holding too much. Try: TAKE INVENTORY");
    else
    {
      from=cp;
      to=HELD;
      take_drop(noun,from,to);
    }
  }
}

void drop(int noun)
{
 int from, to;
  if(noun==0) puts("Drop what?");
  else if(noun<=6) puts("Oh, just drop it.");
  else if(noun<=40 && noun!=34 || noun>=60) not_holding_it();
  else
  {
    from=HELD;
    to=cp;
    take_drop(noun,from,to);
  }
}

void help(void)
{
 static helped=FALSE;
  if(ob[20].room==cp || ob[20].room==HELD)
    if(!helped)
    {
      Wrap("Look up fulcrum in the dictionary.");
      helped=TRUE;
    }
    else puts("Try: MAKE object.");
  else Wrap("I can't help you! This is supposed to be a hard adventure!");
}

void save_game(int noun)
{
 int i;
 char fn[12];
  if(noun!=0 && noun!=63) puts("You can't save that!");
  else
  {
    FileOutput_ctor_Ex(&f_out,"tlc.sav",TRUE);
    for(i=1; i<=NUM_OBJECTS; ++i)
      FileOutput_write(&f_out,&ob[i].room,2);
    FileOutput_write(&f_out,&cp,2);
    FileOutput_write(&f_out,&tr,2);
    FileOutput_write(&f_out,&p5,2);
    FileOutput_write(&f_out,&p[4].link[EAST],2);
    FileOutput_write(&f_out,&p[24].link[UP],2);
    FileOutput_write(&f_out,&p[15].link[DOWN],2);
    FileOutput_write(&f_out,&p[6].link[EAST],2);
    FileOutput_write(&f_out,&p[9].link[DOWN],2);
    FileOutput_dtor(&f_out,LEAVE_MEMORY);
  }
}

void load_game(int noun)
{
 int i;
 char fn[12];
  if(noun != 0 && noun != 63) puts("You can't load that!");
  else
  {
    FileInput_ctor_Ex(&f_in,"tlc.sav");
    for(i=1; i<=NUM_OBJECTS; ++i)
      Input_read(&f_in,&ob[i].room,2);
    Input_read(&f_in,&cp,2);
    Input_read(&f_in,&tr,2);
    Input_read(&f_in,&p5,2);
    Input_read(&f_in,&p[4].link[EAST],2);
    Input_read(&f_in,&p[24].link[UP],2);
    Input_read(&f_in,&p[15].link[DOWN],2);
    Input_read(&f_in,&p[6].link[EAST],2);
    Input_read(&f_in,&p[9].link[DOWN],2);
    FileInput_dtor(&f_in,LEAVE_MEMORY);
  }
}

void look(int noun)
{
  switch (noun) {
  case 0:
    if(cp!=26) nothing_special();
    else Wrap("Magic emanates from somewhere in the rocks.");
    break;
  case 64:
    if(cp!=26) dont_see_it();
    else if(ob[28].room!=0) nothing_special();
    else
    {
      found_something();
      ob[28].room=cp;
    }
    break;
  case 12:
    if(ob[5].room!=cp) dont_see_it();
    else puts("\"GO NO FURTHER.\"");
    break;
  case 13: case 14:
    if(ob[6].room!=cp) dont_see_it();
    else
    {
      printf("It has a large unlabelled red button on it, a large\
 black button labelled \"SPEED LAUNCH,\" and a read-out: \"Countdown\
 at T minus %d turns, and counting.\"",tr);
    }
    break;
  case 8:
    if(ob[2].room!=cp) dont_see_it();
    else if(p[cp].link[DOWN]!=0) nothing_special();
    else
    {
      Wrap("There seems to be a passage behind it!");
      p[cp].link[DOWN]=10;
    }
    break;
  case 30:
    if(ob[15].room!=cp) dont_see_it();
    else puts("Underneath it's only dirt.");
    break;
  case 34:
    if(ob[19].room!=cp && ob[19].room!=HELD) dont_see_it();
    else Wrap("It has buttons numbered one through five and a small display.");
    break;
  case 15: case 16:
    if(ob[7].room!=cp) dont_see_it();
    else Wrap("It has a picture of a half-donut on it.");
    break;
  case 45:
    if(ob[24].room!=cp && ob[24].room!=HELD) nothing_special();
    else Wrap("It looks like it needs to be recharged.");
    break;
  case 17: case 18:
    if(cp==1) puts("The chunks are too big to lift.");
    else nothing_special();
    break;
  case 44:
    if(ob[23].room!=cp && ob[23].room!=HELD) dont_see_it();
    else
    {
      Wrap("\"As our world crumbles down, the future I\
 see: To go in is five-four, to go out is five-three!\"");
    }
    break;
  case 21: case 22:
    if(ob[11].room!=cp) dont_see_it();
    else
    {
      Wrap("Most of them appear useless or destroyed.");
      if(ob[24].room==0 && ob[25].room==0)
      {
        Wrap("However, your magical senses tell you\
 that one of the wands could be made operational.");
      }
    }
    break;
  case 49:
    if(ob[28].room!=HELD) not_holding_it();
    else Wrap("It radiates a strong aura of protection.");
    break;
  default: nothing_special();
  }
}

void press(int noun)
{
  switch (noun) {
  case 0: Wrap("You need to specify which object.");break;
  case 35:
    if(ob[6].room==cp) puts("Say again, but specify a color.");
    else if(ob[19].room!=cp && ob[19].room!=HELD) not_holding_it();
    else puts("Say again, but specify a number.");
    break;
  case 40:
    if(ob[19].room!=HELD) not_holding_it();
    else
    {
      ok();
      p5=TRUE;
    }
    break;
  case 43:
    if(ob[22].room==HELD) Wrap("Not while you're holding on to it!");
    else if(ob[22].room!=cp) dont_see_it();
    else
    {
      ok();
      if(cp==1)
        if(ob[15].room==cp) ob[15].room = 0;
        else ob[15].room=cp;
    }
    break;
  case 36: case 37: case 38: case 39:
    if(ob[19].room!=HELD) not_holding_it();
    else
    {
      ok();
      if(p5==TRUE)
      {
        p5=FALSE;
        if(noun==38)
          if(cp==13) cp=12;
          else if(cp==16) cp=26;
          else if(cp==17)
          {
            Wrap("You materialize on the wrong side of a 200 meter\
 cliff. You plummet to you doom, screaming in terror all the way down!");
            dead();
          }
          else if(cp==15)
          {
            Wrap("You materialize inside solid granite.\
 For a few nanoseconds, you realize the end has come.");
            dead();
          }
          else;
        else if(noun==39)
          if(cp==12) cp=13;
          else if(cp==26) cp=16;
      }
    }
    break;
  case 65: case 66:
    if(ob[6].room!=cp) dont_see_it();
    else if(noun==65)
    {
      Wrap("The nuclear missile in a nearby under ground hidden silo\
 self-destructs! Unfortunately, it self-destructs by detonating its own\
 warhead, which causes an 11.9 earthquake that takes you and the city with it! You're dead!");
      sndfx();
      draw_lib(0,1,0,0,BM_NORMAL); // Draw explosion
      MSequence_play_background(&mus);
      dead();
    }
    else
    {
      Wrap("The countdown suddenly advances to zero!");
      tr=0;
    }
    break;
  default: being_weird();
  }
}

void make(int noun)
{
  if(noun==0) Wrap("You have to tell me what you want to make.");
  else if(noun!=43) being_weird();
  else
  {
    if(ob[21].room!=cp && ob[21].room!=HELD ||
         ob[20].room!=cp && ob[20].room!=HELD)
      not_yet();
    else
    {
      ok();
      ob[20].room=0;
      ob[21].room=0;
      ob[22].room=cp;
    }
  }
}

void unlock(int noun)
{
  switch (noun) {
  case 0: Wrap("You have to tell me what you want to open.");break;
  case 33:
    if(ob[18].room!=cp) dont_see_it();
    else puts("It is sealed.");
    break;
  case 23: case 24:
    if(ob[12].room!=cp) dont_see_it();
    else if(ob[30].room!=HELD) puts("It's locked.");
    else
    {
      ok();
      ob[12].room=0;
      p[cp].link[DOWN]=22;
    }
    break;
  default: beyond_your_power();
  }
}

void wave(int noun)
{
  if(noun==0) Wrap("You have to tell me what to wave.");
  else if(noun!=45 || ob[24].room==HELD) puts("Nothing happens.");
  else if(ob[25].room!=HELD) not_holding_it();
  else
  {
    ok();
    Wrap("An electrical cloud forms over\
 your head, and a small lightning bolt arcs out.");
    ob[25].room=0;
    ob[24].room=HELD;
    if(ob[31].room==cp)
    {
      Wrap("\nThe bolt hit the plastic explosive!\nBOOM!");
      ob[31].room=0;
      if(ob[18].room==cp)
      {
        ob[18].room=0;
        p[cp].link[UP]=25;
      }
    }
  }
}

void cast(int noun)
{
  if(noun!=0 && noun!=21) being_weird();
  else
  {
    Wrap("Sorry. Your weak magic is\
 chiefly sensory, and hardly formidable.");
  }
}

void light(int noun)
{
  switch (noun) {
  case 0: Wrap("You have to tell me what you wish to light.");break;
  case 59:
    if(ob[35].room!=cp && ob[35].room!=HELD) dont_see_it();
    else puts("It already is.");
    break;
  case 53: case 54:
    if(ob[31].room!=cp && ob[31].room!=HELD) dont_see_it();
    else Wrap("How? You're going to need something\
 at least as hot as a spark to do that.");
    break;
  default: puts("Sorry. That won't light.");
  }
}

void use(int noun)
{
  switch(noun)
  {
    case 0: Wrap("You have to say what you want to use.");break;
    case 55: case 56:
      if(ob[33].room==HELD) puts("It's been discharged.");
      else if(ob[32].room != HELD) not_holding_it();
      else
      {
        ob[33].room=ob[32].room;
        ob[32].room=0;
        strcpy(t,"A searing beam of coherent, pulsating light cuts through the air and ");
        if(ob[1].room != cp) strcat(t,"heats it somewhat.");
        else
        {
          strcat(t,"cuts a hole through the door.");
          ob[1].room=0;
          p[6].link[EAST]=7;
        }
        Wrap(t);
      }
      break;
    case 45: wave(noun);break;
    case 21: cast(noun);break;
    case 43: press(noun);break;
    case 53: case 54: light(noun);break;
    default: puts("Huh?");
  }
}

void found_nothing(void)
{
  puts("You found nothing special.");
}

void dig()
{
  if(ob[27].room==HELD)
    if(ob[15].room==cp)
      if(ob[23].room==0)
      {
        found_something();
        ob[23].room=cp;
      }
      else found_nothing();
    else puts("How? No loose dirt here!");
  else if(ob[26].room!=HELD) puts("But you have no shovel!");
  else if(cp!=2) puts("How? No sand here!");
  else if(ob[27].room==0)
  {
    found_something();
    ob[27].room=cp;
  }
  else if(ob[30].room!=0) found_nothing();
  else
  {
    found_something();
    ob[30].room=cp;
  }
}

void kill(void)
{
  Wrap("Sorry. If you want to kill things, play \"HUtM,SIT,aPOttNR\"!");
}

void move(int noun)
{
  if(noun==0) Wrap("You need to say what you want to move, too.");
  else if(noun==43) press(noun);
  else puts("Try: TAKE or DROP.");
}

void throw(int noun)
{
  if(noun!=50 && noun!=51 || ob[7].room!=cp) drop(noun);
  else if(ob[29].room!=HELD) not_holding_it();
  else
  {
    ok();
    Wrap("The object hits the draw bridge, the two symbols\
 combine and vanish. Slowly, the massive wooden door lowers open.");
    ob[7].room=0;
    ob[29].room=0;
    p[cp].link[EAST]=5;
  }
}

void charge(int noun)
{
  if(noun==0) puts("Thanks. I feel much better now.");
  else if(noun!=45) being_weird();
  else if(ob[25].room==HELD) puts("It already is.");
  else if(ob[24].room != HELD) not_holding_it();
  else if(cp!=3) Wrap("Sorry. You'll need a stronger source of raw magical energy.");
  else
  {
    ok();
    Wrap("There's plenty of power here for that!");
    ob[25].room=HELD;
    ob[24].room=0;
  }
}

void do_command(int verb,int noun)
{
  switch(verb) {
  case 1: move_dir(NORTH);break;
  case 2: move_dir(SOUTH);break;
  case 3: move_dir(EAST);break;
  case 4: move_dir(WEST);break;
  case 5: move_dir(UP);break;
  case 6: move_dir(DOWN);break;
  case 7: case 8: go(noun);break;
  case 9: climb(noun);break;
  case 10: case 11: case 12: take(noun);break;
  case 13: case 14: case 15: drop(noun);break;
  case 16: help(); break;
  case 17: dead(); break;    /* not necessary, but pretty-looking */
  case 18: save_game(noun);break;
  case 19: load_game(noun);break;
  case 20: case 21: inventory();break;
  case 22: case 23: case 24: case 25: look(noun);break;
  case 28:
    if(noun==55||noun==56)
    {
      use(noun);
      break;
    }
  case 26: case 27: press(noun);break;
  case 29: case 30: make(noun);break;
  case 31: case 32: unlock(noun);break;
  case 34:
    if(noun==8)
    {
      go(noun);
      break;
    }
  case 33: use(noun);break;
  case 35: dig();break;
  case 36: zzzzz();break;
  case 37: kill();break;
  case 38: move(noun);break;
  case 39: throw(noun);break;
  case 40: wave(noun);break;
  case 41: cast(noun);break;
  case 42: case 43: charge(noun);break;
  case 44: case 45: light(noun);
  }
}

//-----------------------------------------------------------------------------
// MAIN: Program entry point                                                  |
//-----------------------------------------------------------------------------
long main(int argc,char* argv[],bool start)
{
// FILE *fp;
 int verb, noun;
  init_module(&main_module); // Initialize module
  cWinApp_clear_screen();    // Clear screen
  MSequence_ctor(&mus,"sds3.mus");
  sndfx();
  MSequence_play_background(&mus);
  draw_lib(0,0,0,0,BM_NORMAL); // Draw intro pic
  Graphics_set_font(main_module.m_gfx,mini_bold_font); // Set Font
  TGraph_set_color(main_module.m_gfx,CLR_DKGRAY);
  Graphics_draw_text(main_module.m_gfx,"The Last City",40,90); // Print title
  Graphics_set_font(main_module.m_gfx,mini_normal_font);
  Wrap("The future has come and gone. Human technology has reached goals that have\
 surmounted even the most impractical dreams of the past. We had strived and\
 succeeded, and at last had begun to tap into the awesome power of... MAGIC!");
  more();
  Wrap("\nIt was this which caused our civilization to crumble. Your magical senses\
 have drawn you to the vicinity of humanity's last city because of a warning. If\
 not rescued very soon, the last of human technology will be erased from the planet.");
  more();
  do{
    show_room();
    if(!input_command(&verb,&noun))
    {
      do_command(verb,noun);
      --tr;
    }
  }while(tr>0 && q==0);
  if(q==0) last_move();
  MSequence_dtor(&mus,LEAVE_MEMORY);
 return 0L;
}

