//-----------------------------------------------------------------------------
// Beyond The Tesseract  by David Lo                    Cybiko port by Athlor |
//-----------------------------------------------------------------------------
#include <CyWin.h>
#include "tess.h"
#include "tess-def.c"
#include "parser.c"

#define LED (*(char *)0xFFFF61) // Green LED register

int  // Adventure dependent stuff
 print_room,      /* flag for updating room after command */
 curr_loc,        /* current location */
 curr_lev,        /* current level */
 level_loc[4], /* current location for diff. levels */
 zap,             /* flag set when game over */
                  /*   1=quit   2=wrong password   3=right password */
 sleep_lev,       /* which level player was in when sleeping */
                  /* flags are 0=false/haven't done, 1=true/done */
                  /* unless otherwise noted */
 cc,              /* coil status: 0=normal  b1=cooled  b2=magnetized */
 wa,              /* water alien */
 ep,              /* eat pills */
 dr,              /* dice roll counter */
 af,              /* audio filter inserted */
 gp,              /* get password */
 mi,              /* message: bits 0,1,2,3 = parts found */
 ti,              /* think idea */
 kp,              /* kick projector */
 dc[3],        /* each dice roll, dc[i]<33 */
 sum;             /* sum = sigma(dc) < 100  */

struct Message* ptr_msg; // Structures
struct FileInput f_in;
struct FileOutput f_out;
struct module_t main_module;

//-----------------------------------------------------------------------------
// Cybiko Specific:  clrln, Scroll, puts, Wrap, _getch and gets               |
//-----------------------------------------------------------------------------
void clrln(void)
{
  TGraph_set_color(main_module.m_gfx,CLR_WHITE);
  TGraph_fill_rect(main_module.m_gfx,0,91,160,9); // Erase bottom line
  TGraph_set_color(main_module.m_gfx,CLR_BLACK);
}

void Scroll(void)
{
  TGraph_scroll(main_module.m_gfx,0,0,160,100,0,-9);
  clrln();
}

int puts(char *s)
{
  Scroll();
  Graphics_draw_text(main_module.m_gfx,s,0,90); // Print Text
  DisplayGraphics_show(main_module.m_gfx); // Update Display
}

void Wrap(char *s)
{
 char l[64]; int i; int lsp;
  while(DisplayGraphics_string_width(main_module.m_gfx,s)>155)
  {
    i=0; l[i]=0;
    do {
      if(*s==32)  lsp=i; // Remember last space
      l[i++] = *s++; l[i]=0;
    }while(DisplayGraphics_string_width(main_module.m_gfx,l)<155&&(l[i-1]!='\n'));
    if(*(s-1)!='\n') {s=s-(i-lsp)+1; i=lsp; l[i++]='\n'; l[i]=0;}
    puts(l);
  }
  puts(s);
}

int _getch(void)
{
 int key; bool pressed=FALSE;
  do{
    ptr_msg=cWinApp_get_message(main_module.m_process,0,1,MSG_USER);
    switch(ptr_msg->msgid)
    {
      case MSG_KEYDOWN:
        key=Message_get_key_param(ptr_msg)->scancode; // Allows spec keys
        switch(key)
        {
          case KEY_ENTER: case KEY_BACKSPACE: case KEY_RIGHT: case KEY_SELECT:
          case KEY_UP: case KEY_DOWN: case KEY_LEFT: case KEY_DEL: case KEY_TAB:
            pressed=TRUE;
          case KEY_SHIFT: case KEY_CONTROL: break;
          default: pressed=TRUE; key=Message_get_key_param(ptr_msg)->ch; break;
        }
        break;
      default: cWinApp_defproc(main_module.m_process,ptr_msg);
    }
    Message_delete(ptr_msg); // Delete processed message
  }while(!pressed);
 return key;
}

void gets(char *lbuf)
{
 int key,i=0;bool done=FALSE;
  Scroll();
  lbuf[0]=0;
  do{
    key=_getch(); // Wait until a key is pressed
    if(key==264) {lbuf[0]='w';lbuf[1]=0;break;} // Controller pad hack
    if(key==265) {lbuf[0]='n';lbuf[1]=0;break;}
    if(key==266) {lbuf[0]='e';lbuf[1]=0;break;}
    if(key==267) {lbuf[0]='s';lbuf[1]=0;break;}
    switch(key)
    {
      case KEY_ENTER: lbuf[i]=0;done=TRUE;break;
      case KEY_BACKSPACE: if(i) lbuf[--i]=0;break;
      default: lbuf[i++]=(char)key;lbuf[i]=0;break;
    }
    clrln();
    Graphics_draw_text(main_module.m_gfx,lbuf,0,91);
    DisplayGraphics_show(main_module.m_gfx); // Update Display
  }while(!done);
}

void more(void)
{
  LED |= 8; // Turn Green LED ON
  _getch();
  LED &= 247; // Turn Green LED OFF 
}

int printf(char *tmp, ...)
{
 char tbuf[99]; char *t=tbuf;
  vsprintf(tbuf, tmp, &tmp+1);
  Wrap(tbuf);
}

//-----------------------------------------------------------------------------
// MAIN: Program entry point                                                  |
//-----------------------------------------------------------------------------
long main(int argc, char* argv[], bool start)
{
 int i, keep_playing;
  init_module(&main_module); // Initialize module
  Graphics_set_font(main_module.m_gfx,mini_normal_font);

  intro();
  do{
    InitAdv();
    do{
      gp=InComplex(curr_loc)&&(mi==15);

      if(print_room)
      {
        PrintCurrRoom();
        print_room=0;
      }
      if(gp) Wrap("A voice echoes: audio link complete. Enter password.");
      if(InDreamWorld(curr_loc)) puts("(sleeping) ");
      else if(InBookWorld(curr_loc)) puts("(reading) ");
      puts("Enter command:");
      gets(cmd.cm);
      if(cmd.cm[0])
      {
        AnalyseCommand(&cmd);
        DoCommand();
      }
    }while(!zap);
    Ending(zap);
    puts("Play again (y/n)?");
//    gets(cmd.cm);
//    keep_playing=(cmd.cm[0]!='n' && cmd.cm[0] !='N');
//    i=_getch();
  }while(_getch()=='y');
//  intro1();
 return 0L;
}

void InitAdv(void)
{
 int i;
  for (i=1; i<MaxObjs; i++)
    obj[i].loc=obj[i].init_loc;
  level_loc[1]=2;
  level_loc[2]=25;
  level_loc[3]=29;
  curr_lev=1;
  curr_loc=level_loc[curr_lev];
  zap=cc=wa=ep=dr=af=gp=mi=ti=kp=0;
  for (sum=0, i=0; i<3; i++)
    {dc[i]=random(32);sum += dc[i];}
  print_room=1;
  puts(""); // Skip line
}

// Message routines
void PrintMsg(int i)
{
  switch (i)
  {
    case 1: puts("Nothing special happens.");break;
    case 2: puts("That isn't possible.");break;
    case 3: puts("Doesn't work.");break;
    case 4: puts("Can't do that yet.");break;
    case 5: puts("OK.");break;
    case 6: puts("How?");break;
    case 7: printf("You have nothing to %s with.", cmd.verb);break;
  }
}

void not_happen(void) { PrintMsg(1); }
void not_poss(void)   { PrintMsg(2); }
void not_work(void)   { PrintMsg(3); }
void not_yet(void)    { PrintMsg(4); }
void ok(void)         { PrintMsg(5); }
void how(void)        { PrintMsg(6); }

// Object routines
int CheckObjAttr(int nn,int mask)
{
 return (obj[nn].attr & mask);
}

#define CanGetObj(i) CheckObjAttr((i),1)
#define CanLookObj(i) CheckObjAttr((i),4)

void CarryObj(int nn)
{
  obj[nn].loc = -curr_lev;
}

int CarryingObj(int nn)
{
 return (obj[nn].loc == -curr_lev);
}

void WearObj(int nn)
{
  obj[nn].loc = -curr_lev - 3;
}
  
int WearingObj(int nn)
{
 return (obj[nn].loc == -curr_lev-3);
}

int ObjOnPlayer(int nn)
{
 return (CarryingObj(nn) || WearingObj(nn));
}

void DropObj(int nn)
{
  obj[nn].loc=curr_loc;
}

int ObjInRoom(int nn)
{
 return (obj[nn].loc == curr_loc);
}

void JunkObj(int nn)
{
  obj[nn].loc=0;
}

// Replace object nn with object new_nn
void ReplaceObj(int nn,int new_nn)
{
  obj[new_nn].loc=obj[nn].loc;
  obj[nn].loc=0;
}

/* See if an object is accessible.  This means the object is being
   carried/worn, is in the same room, is a concept noun (e.g. north),
   is part of the room (e.g. field), or is part of another object
   (e.g. button).
*/
int ObjIsPresent(int nn)
{
  if((nn>=o_north)&&(nn<=o_invent)) /* direction, "inventory" */
    return (1);               /* always available */
  else if((nn>=o_buttons) && (nn<=o_four))  /* buttons */
    return (ObjIsPresent(o_proj));           /* on projector */
  else if((nn==o_liquid) && (obj[nn].loc==-8))  /* contained fluid */
    return (ObjIsPresent(o_bottle));             /* in Klein bottle */
  else return (ObjInRoom(nn)||CarryingObj(nn)||WearingObj(nn));
}

/* Room routines
*/

/* predicates to return check whether the player in in a certain world
*/
int InComplex(int rn)
{
 return (rn==1 || rn==2 || rn==7 || rn==8);
}

int InMirrorWorld(int rn)
{
 return (rn==4 || (rn>=9 && rn<=13));
}

int InMathWorld(int rn)
{
 return (rn==3 || rn==5 || (rn>=14 && rn<=17));
}

int InSpectralWorld(int rn)
{
 return (rn==6 || (rn>=18 && rn<=22));
}

int InDreamWorld(int rn)
{
 return (curr_lev==2 || (rn>=23 && rn<=28) || rn==35);
}

int InBookWorld(int rn)
{
 return (curr_lev==3 || (rn>=29 && rn<=34));
}

void PrintCurrRoom(void)
{
  int i,flag, len,currx;
  char *s;
  printf("You are %s.", room[curr_loc].name);
  puts("You see around you:");
  flag=0;
  for (i=1; i<MaxObjs; i++)
    if(ObjInRoom(i))
    {
      Wrap(obj[i].name);
      flag=1;
    }
  if(!flag)  puts("Nothing special.");
  puts("Exits:");
  flag=0;
  for (i=0; i<MaxDirs; i++)
    if(room[curr_loc].link[i])
    {
      Wrap(obj[i+1].name);
      flag=1;
    }
  if(!flag) puts("None.");
}

void goto_new_lev(int lev)
{
  curr_lev=lev;
  curr_loc=level_loc[curr_lev];
}
  
void goto_new_loc(int rn)
{
  curr_loc = rn;
  level_loc[curr_lev]=curr_loc;
}

// Verb routines
void do_go(void)
{
 int direct, new_room;
  switch (cmd.nn)
  {
    case o_north:
    case o_east:
    case o_south:
    case o_west:
      direct=cmd.nn - 1;                       /* assumes NESW = 1234 */
      new_room=room[curr_loc].link[direct];
      if(new_room)
      {
        goto_new_loc(new_room);
        print_room=1;
      }
      else
        puts("Can't go in that direction");
      break;
    default:
/*
      if(isdigit(cmd.noun[0]))
      {
        new_room = xtoi(cmd.noun);
        if((new_room>=0) && (new_room<MaxLocs))
          goto_new_loc(new_room);
        else
          puts("Can't go there");
      }
      else
*/
        puts("Use a direction or the stack");
  }
}

void do_dir(void)
{
  cmd.nn=cmd.vn;
  cmd.vn=6;
  do_go();
}

void do_inv(void)
{
  int flag, i, len,currx;
  char s[80];
  puts("You are carrying:");
  flag=0;
  for (i=1; i<MaxObjs; i++)
    if(ObjOnPlayer(i))
    {
      strcpy(s, obj[i].name);
      if(WearingObj(i)) strcat(s, " (wearing)");
      Wrap(s);
      flag=1;
    }
  if(!flag)  puts("Nothing.");
}

void do_get(void)
{
 int where, attr, i, get_flag;
 char s[16], *p;
  if(ObjOnPlayer(cmd.nn)) puts("You already have it.");
  else if(cmd.nn==o_invent)      /* get everything in room */
  {
    for (i=o_invent+1; i<MaxObjs; i++)
      if(ObjInRoom(i) && CanGetObj(i))
      {
        cmd.nn=i;
        printf("--> get %s", obj[i].name);
        do_get();
      }
  }
  else if(!CanGetObj(cmd.nn))      /* un-gettable object? */
  {
    if(cmd.nn==o_plant) Wrap("The being is rooted in the 4th dimension."); /* alien */
    else if(cmd.nn==o_group)
      Wrap("The group has infinitely many reasons to stay where it is.");
    else if(cmd.nn==o_fluid) puts("It's too cold!");  /* fluid */
    else puts("Can't get that.");
  }
  else  /* gettable object */
  {
    get_flag=1;
    if(cmd.nn==o_liquid)   /* 4-D liquid */
    {
      how();
      get_flag=0;
    }
    else if(cmd.nn==o_plasma)   /* plasma */
    {
      if(!CarryingObj(o_coil) || (cc!=3))
      /* not have coil or not mag. bottle */
      {
        puts("Too hot to handle.");
        get_flag=0;
      }
      else Wrap("The magnetic field of the coil contained the plasma.");
    }
    else if(cmd.nn==o_improb)   /* improbability */
    {
      Wrap("What is the probability of getting this improbability?");
      gets(s);
      p=strchr(s, '.');  /* skip past decimal point */
      if(p) p++;
      i=xtoi(p);
      if(i!=sum && i*10!=sum)
      {
        puts("Wrong.");
        get_flag=0;
      }
    }
    if(get_flag)
    {
      CarryObj(cmd.nn);
      ok();
    }
  }
}
  
void do_drop(void)
{
 int where, i;
  if(ObjInRoom(cmd.nn)) puts("It's already here.");
  else if(cmd.nn==o_improb && curr_loc==16) do_throw();
  else if(cmd.nn==o_invent) // Drop everything
  {
    for (i=o_invent+1; i<MaxObjs; i++)
      if(ObjOnPlayer(i))
      {
        cmd.nn=i;
        printf("--> drop %s", obj[i].name);
        do_drop();
      }
  }
  else if(cmd.nn>o_invent)
  {
    if(cmd.nn==o_coil) // Drop coil, check for plasma as well
    {
      if(CarryingObj(o_coil) && CarryingObj(o_plasma))
        DropObj(o_plasma);
    }
    if(ObjOnPlayer(cmd.nn))
    {
      DropObj(cmd.nn);
      ok();
    }
  }
}

void do_throw(void)
{
 char *s;
  if(ObjInRoom(cmd.nn)) puts("It's already here.");
  else if(cmd.nn==o_improb && curr_loc==16)
  {
    Wrap("The improbability's presence warps the fabric of the field.");
    room[16].link[east]=17 - room[16].link[east];
    print_room=1;
    DropObj(cmd.nn);
  }
  else if(cmd.nn==o_cube) do_roll();
  else if(cmd.nn==o_disk)
  {
    Wrap("With great skill (i.e. luck) you threw the disk into the next room.");
    if(curr_loc==29) obj[cmd.nn].loc = -7;
    else obj[cmd.nn].loc=room[curr_loc].link[south];
  }
  else do_drop();
}

void do_break(void)
{
  if(cmd.nn==o_prism)
  {
    Wrap("The prism shatters along the lines and\
 mysteriously reorganizes itself into a tetrahedron.");
    ReplaceObj(cmd.nn, o_tetra);
  }
  else if(cmd.nn==o_tetra) Wrap("It shatters, but quickly reforms itself.");
  else if(cmd.nn==o_zeta) do_solve();
  else if(cmd.nn==o_proj)
  {
    if(!kp)
    {
      Wrap("With a few kicks and blows, both you and the projector felt better.");
      kp=1;
    }
    else Wrap("Better not try that again, or you'll really break it.");
  }
  else Wrap("Violence is not necessary, most of the time.");
}

void do_look(void)
{
  if(!cmd.nn) print_room=1;
  else if(!CanLookObj(cmd.nn))
  {
    printf("Looks like %s.", obj[cmd.nn].name);
  }
  else
  switch (cmd.nn)
  {
    case o_mirror: Wrap("You see the reflections of a mirror world.");break;
    case o_crt: Wrap("You see the images of a mathematical universe.");break;
    case o_group:
      Wrap("The group consists of converging parallel lines, alef-null,\
 the last prime number, 1/0, and uncountably many others.");
      break;
    case o_hole: Wrap("You see the lights of an electromagnetic continuum.");break;
    case o_proj:
      Wrap("You see a wide slot and 5 buttons.");
      if(obj[o_disk].loc==-7) puts("A disk is in the projector.");
    case o_buttons: Wrap("The buttons are labelled zero to four.");break;
    case o_chaos: Wrap("It bears a slight resemblence to the current universe.");break;
    case o_dust:Wrap("It look like the remains of an exploded Julia set.");break;
    case o_flake: Wrap("It doesn't look like the coastline of Britain.");break;
    case o_mount: Wrap("It looks the same at all scales.");break;
    case o_tomb: Wrap("The epitaph reads: The Eternal Soul");mi = mi | 1; break;
    case o_stack: Wrap("It's a Space-Time Activated Continuum Key.");break;
    case o_audio: Wrap("Looks like 2 speakers connected by a band.");
      if(!af) Wrap("There is a groove in the band.");
      break;
    case o_book: Wrap("The title is 'Interactive Adventures'.");break;
    case o_bottle:
      if(obj[o_liquid].loc==-8) Wrap("It is full of some strange liquid.");
      else Wrap("It is an empty bottle with no inside or outside.");
      break;
    case o_prism: Wrap("You see flashes along deeply etched lines");
      if(curr_loc==21) Wrap("And embedded, distorted shapes resembling letters");break;
    case o_appa: Wrap("Looks like a device used for increasing\
 the dimensions of geometric and topological objects.");break;
    case o_improb: Wrap("It looks like a heart of gold.");break;
    case o_zeta: Wrap("It's a very vicious-looking integral.");break;
    case o_cube: Wrap("There are changing numbers on the sides.");break;
    case o_coil: Wrap("The ends of the coil are connected to form a loop.");break;
    case o_sing: Wrap("It is shaped like a narrow band.");break;
    case o_disk:
      Wrap("The title is: The Science and Beauty of a Geometric Nature");
      break;
    case o_supp: Wrap("It's an almost obvious fact.\nIt is not proven.");break;
    case o_hypo: Wrap("It's a complicated statement. It is not proven.");break;
    case o_lemma: Wrap("It's a rather specialized fact.");break;
    case o_theorem:
      Wrap("It begins: The metaphysical existentialism of reality ...");
      Wrap("The rest is incomprehensible to you.");
      break;
    case o_axiom: Wrap("It's the basis of a complex system.");break;
    case o_post: puts("It's a basic fact.");break;
    case o_math: puts("He looks almost asleep.");break;
    case o_tetra:
      if(curr_loc==22)
      {
        Wrap("Sharp letters form the message: Seeks the Exact");
        mi = mi | 2;
      }
      else puts("You see colorless letters.");break;
    case o_func:
      Wrap("The function has many sharp points, all of which are at (1/2+bi).");
      break;
    case o_idea: Wrap("The idea is very vague and not fully developed.");break;
    case o_contra:
      Wrap("It is true and false, but neither is correct, and both are right.");
      break;
    case o_warr: puts("It has expired.");break;
    default: printf("Looks like %s.", obj[cmd.nn].name);
  }
}

void do_read(void)
{
  if(cmd.nn==o_book)
  {
    Wrap("You are now reading an adventure ...");
    goto_new_lev(3);
    print_room=1;
  }
  else do_look();
}

void do_use(void)
{
  switch (cmd.nn)
  {
    case o_proj: puts("Try the buttons.");break;
    case o_stack:
      Wrap("Try push or pop the stack, or scan something with it.");
      break;
    case o_prism: do_look();break;
    case o_appa: Wrap("Try to _y_ something with it");break;
    case o_improb: if(curr_loc==16) do_throw(); else how();break;
    default: how();break;
  }
}

void do_touch(void)
{
  printf("Feels just like a %s.", cmd.noun);
}

void do_swing(void)
{
  if(cmd.nn==o_coil) do_spin();
  else not_happen();
}

void do_rub(void)
{
  do_touch();
}

void do_push(void)
{
 int new_room;
  if(cmd.nn==o_stack)
  {
    if(curr_loc>3) not_happen();
    else if(gp) do_scan();
    else
    {
      puts("You are falling inwards ...");
      goto_new_loc(curr_loc+3);
      print_room=1;
    }
  }
  else if(obj[cmd.nn].loc==-7)
  {
    if(obj[o_disk].loc!=-7) not_happen();
    else if(!kp)
      Wrap("The projector begins to start, fizzes and grinds, then stops.");
    else
    {
      Wrap("The lights dimmed for a while.");
      new_room=cmd.nn + 17;
      goto_new_loc(new_room);
      room[29].link[north] = curr_loc;
      print_room = 1;
      DropObj(o_proj);
      if(new_room==30)
      {
        Wrap("The projector ejects the disk.");
        DropObj(o_disk);
      }
    }
  }
  else not_happen();
}

void do_pop(void)
{
 char *s;
  s = "You are falling outwards ...";
  if(gp) do_scan();
  else if(cmd.nn==o_pills) do_eat();
  else if(cmd.nn!=o_stack) not_poss();
  else if(InComplex(curr_loc)) Wrap("Can't transcend reality in this adventure.");
  else if(InMirrorWorld(curr_loc))
  {
    goto_new_loc(1);
    print_room = 1;
    Wrap(s);
  }
  else if(InMathWorld(curr_loc))
  {
    goto_new_loc(2);
    print_room = 1;
    Wrap(s);
  }
  else if(InSpectralWorld(curr_loc))
  {
    goto_new_loc(3);
    print_room = 1;
    Wrap(s);
  }
  else not_happen();
}

void do_spin(void)
{
  if(cmd.nn==o_coil)
  {
    if(curr_loc==18)
    {
      cc = cc | 2;
      ok();
    }
    else not_happen();
  }
  else not_happen();
}

void do_roll(void)
{
 int n;
  if(cmd.nn==o_cube)
  {
    n = dr % 4;
    puts("You rolled a ");
    if(n<3) printf("%d.", dc[n]);
    else puts("+nnn.");
    dr++;
  }
  else not_happen();
}

void do_wear(void)
{
  if(WearingObj(cmd.nn)) puts("You're already wearing it.");
  else if(cmd.nn==o_audio)
  {
    WearObj(cmd.nn);
    ok();
  }
  else not_poss();
}

void do_eat(void)
{
  if(cmd.nn==o_plant) puts("Don't consume higher lifeforms.");
  else if(cmd.nn==o_pills)
  {
    Wrap("Gulp! Suddenly you feel a little drowsy.");
    ep=1;
    JunkObj(cmd.nn);
  }
  else puts("Can't eat that.");
}

void do_taste(void)
{
  switch (cmd.nn)
  {
    case o_pills: puts("It tastes like a drug.");break;
    case o_solid:
    case o_liquid: Wrap("The taste is quite orthogonal.");break;
    default: puts("Can't taste that.");break;
  }
}

void do_drink(void)
{
  if(cmd.nn==o_fluid) puts("Too cold.");
  else if(cmd.nn==o_liquid)
    Wrap("You're too low dimensioned to drink it.");
  else puts("Can't drink that.");
}

void do_remove(void)
{
  if(!WearingObj(cmd.nn)) puts("You are not wearing it.");
  else
  {
    CarryObj(cmd.nn);
    ok();
  }
}

void do_water(void)
{
  if(!ObjIsPresent(o_liquid) &&
       (!CarryingObj(o_bottle) || obj[o_liquid].loc!=-8))
    puts("Nothing to water with.");
  else if(cmd.nn!=o_plant)
    puts("Can't water that.");
  else
  {
    Wrap("Dendrites appear from hyperspace and\
 absorbed the liquid. The being thanks you.");
    wa = 1;
    JunkObj(o_liquid);
  }
}

void do_fill(void)
{
  if(cmd.nn==o_bottle)
  {
    if(curr_loc==obj[o_liquid].loc)
    {
      obj[o_liquid].loc = -8;
      ok();
    }
    else if(curr_loc==obj[o_fluid].loc)
      Wrap("The fluid flows in and then flows out by itself");
  }
  else how();
}

void do_pour(void)
{
  if(cmd.nn==o_bottle || cmd.nn==o_liquid)
  {
    if(obj[o_liquid].loc!=-8) puts("Nothing to pour.");
    else if(curr_loc==obj[o_plant].loc)
    {
      cmd.nn=o_plant;
      do_water();
    }
    else
    {
      DropObj(o_liquid);
      ok();
    }
  }
  else not_work();
}

void do_freeze(void)
{
  if(curr_loc!=obj[o_fluid].loc) not_yet();
  else if(cmd.nn==o_coil)
  {
    cc = cc | 1;
    ok();
  }
  else puts("You might damage it.");
}

void do_melt(void)
{
  if(!ObjIsPresent(o_plasma)) not_yet();
  else if(cmd.nn==o_solid)
  {
    Wrap("The plasma dissipates as the solid melts into a puddle of liquid.");
    JunkObj(o_plasma);
    JunkObj(o_solid);
    DropObj(o_liquid);
    if(curr_loc==obj[o_plant].loc)
    {
      cmd.nn=o_plant;
      do_water();
    }
  }
  else if(cmd.nn==o_tetra) Wrap("It melts, but quickly recrystalizes.");
  else not_work();
}

void do_play(void)
{
  if(cmd.nn==o_cube) do_roll();
  else if(cmd.nn==o_disk) puts("You need something to play it.");
  else if(cmd.nn==o_proj) do_use();
  else not_happen();
}

void do_insert(void)
{
 v_word noun;
 int nn;
  if(cmd.nn==o_sing)
  {
    nn = InputNoun("Where? ", noun);
    if((!strcmp(noun,"groo") || !strcmp(noun,"band") || nn==o_audio)
         && ObjIsPresent(o_audio))
    {
      af = 1;
      JunkObj(cmd.nn);
      Wrap("The singularity slides in with a click.");
    }
    else not_work();
  }
  else if(cmd.nn==o_disk)
  {
    nn = InputNoun("Where? ", noun);
    if((!strcmp(noun,"slot") || nn==o_proj) && ObjIsPresent(o_proj))
    {
      obj[cmd.nn].loc = -7;
      ok();
    }
    else not_work();
  }
  else not_work();
}

void do_fix(void)
{
  if(cmd.nn==o_proj)
    Wrap("You don't know how to properly fix such a delicate instrument.");
  else puts("You don't know how.");
}

void do__y_(void)
{
  if(!ObjIsPresent(o_appa)) PrintMsg(7);
  else switch (cmd.nn)
  {
    case o_cube:
      if(dr<3) puts("You shouldn't do that yet.");
      else
      {
        Wrap("The hexahedron expands one dimension.");
        ReplaceObj(cmd.nn, o_solid);
      }
      break;
    case o_tetra:
      Wrap("It expands a dimension, but quickly collapses back.");
      break;
    case o_strip:
      Wrap("The moebius strip expands one dimension.");
      ReplaceObj(cmd.nn, o_bottle);
      break;
    case o_prism: puts("Object too unstable.");break;
    case o_bottle:
    case o_solid:
    case o_liquid: Wrap("Can't go any higher in this universe.");break;
    case o_appa: Wrap("Sorry, can't upgrade a product this way.");break;
    case o_plant: Wrap("The being is already high enough.");break;
    default: not_happen();
  }
}

void do_prove(void)
{
 v_word noun;
 char *msg1;
 int nn;
  msg1 = "Somehow a contradiction keeps coming into the proof.";
  switch (cmd.nn)
  {
    case o_lemma:
    case o_theorem:
    case o_axiom:
    case o_post: puts("It's already proven.");break;
    case o_supp:
      nn = InputNoun("With what? ", noun);
      if(nn==o_post && ObjIsPresent(o_post))
      {
        if(ObjIsPresent(o_contra)) Wrap(msg1);
        else
        {
          Wrap("The postulate is now a lemma.");
          ReplaceObj(cmd.nn, o_lemma);
        }
      }
      else not_work();
      break;
    case o_hypo:
      nn = InputNoun("With what? ", noun);
      if(nn==o_lemma && ObjIsPresent(o_lemma) && ObjIsPresent(o_axiom))
      {
        if(ObjIsPresent(o_contra)) Wrap(msg1);
        else
        {
          Wrap("The hypothesis is now a theorem.");
          ReplaceObj(cmd.nn, o_theorem);
          Wrap("Suddenly, a hyper-spatial cliff\
 passes by and the lemma leaps to its demise.");
          JunkObj(o_lemma);
        }
      }
      else
        Wrap("Hmmm, something seems to be missing from the proof.");
      break;
    case o_idea:
      Wrap("The idea developed into a contradiction.");
      ReplaceObj(cmd.nn, 52);
      break;

    case o_contra:
      Wrap("You proved that the contradiction can't be proven.");
      break;
    default: not_poss();
  }
}

void do_smell(void)
{
  puts("You smell nothing unusual.");
}

void do_close(void)
{
  not_poss();
}

void do_open(void)
{
  not_poss();
}

void do_stop(void)
{
  if(!strcmp(cmd.sh_noun,"slee")||!strcmp(cmd.sh_noun,"drea"))
    do_wake();
  else if(!strcmp(cmd.sh_noun,"read"))
  {
    if(InBookWorld(curr_loc))
    {
      goto_new_lev(1);
      print_room = 1;
      ok();
    }
    else Wrap("Reality is like a book that you can't stop reading.");
  }
  else not_work();
}

void do_say(void)
{
  printf("'%s'", cmd.noun);
  if(gp==0) not_happen();
  else
  {
    if(strcmp(cmd.noun,"tesseract")) zap = 2; // Wrong password
    else zap = 3; // right password
  }
}

void do_quit(void)
{
  do_score();
  zap = 1;
}

void do_help(void)
{
  if(cmd.nn>0) how();
  else if(curr_lev==2) Wrap("Use 'wake' to wake up from your dream.");
  else if(curr_lev==3)
    Wrap("Use 'stop reading' to stop reading the adventure.");
  else Wrap("Sorry, quasi-hyper-neo-mathematics is beyond me.");
}

void do_listen(void)
{
 char *msg;
  msg = "Of Countless Tesseracts";
  if(curr_loc==19) Wrap("Sounds like radio waves from the Creation.");
  else if(curr_loc!=obj[o_plant].loc) puts("You hear nothing special.");
  else if(wa==0) Wrap("The being is whispering too softly.");
  else if(!WearingObj(o_audio))
    Wrap("You hear a harmonic song in a strange language.");
  else if(!af)
  {
    printf("You hear an %d00-voiced fugue in a complex 1/f melody.", sum);
    Wrap("But you are unable to follow even a single voice.");
  }
  else
  {
    printf("You hear the words: %s.", msg);
    mi = mi | 8;
  }
}

void do_save(void)
{
 int i;
/* FILE *f;
  char s[80];
  puts("Filename to save game to: ");
  gets(s);
  if(!*s) return;

  f=fopen(s,"w");
  if(f)
  {
    for (i=1; i<MaxObjs; i++)
      fprintf(f, "%d ", obj[i].loc);
    fprintf(f, "%d %d %d %d %d %d ",
      curr_lev, curr_loc,
      level_loc[1], level_loc[2], level_loc[3], sleep_lev);
    fprintf(f, "%d %d %d %d %d %d %d %d %d %d %d %d ",
      cc, wa, ep, dr, af, gp, mi, ti, kp, dc[0], dc[1], dc[2]);
    putc('\n', f);
    fclose(f);
    puts("Game saved.");
  }
  else
  {
    printf("Unable to save game to %s", s);
  }*/
}

void do_load(void)
{
 int i;
/* FILE *f;
  char s[80];
  puts("Filename to load game from: ");
  gets(s);
  if(!*s) return;
  f=fopen(s,"r");
  if(f)
  {
    for (i=1; i<MaxObjs; i++)
      fscanf(f, "%d ", &obj[i].loc);
    fscanf(f, "%d %d %d %d %d %d ",
      &curr_lev, &curr_loc,
      &level_loc[1], &level_loc[2], &level_loc[3], &sleep_lev);
    fscanf(f, "%d %d %d %d %d %d %d %d %d %d %d %d ",
      &cc, &wa, &ep, &dr, &af, &gp, &mi, &ti, &kp, &dc[0], &dc[1], &dc[2]);
    for (sum=0, i=0; i<3; i++)
      sum += dc[i];
    fclose(f);
    puts("Game loaded.");
    print_room = 1;
  }
  else
  {
    printf("Unable to load game from %s", s);
  }*/
}

void do_score(void)
{
  printf("You scored %d out of 15.", mi);
}

void do_sleep(void)
{
  if(InDreamWorld(curr_loc))
  {
    Wrap("A dream within a dream would have been\
 quite poetic, but time did not allow for it.");
  }
  else if(ep==0) puts("You're not sleepy yet.");
  else
  {
    Wrap("As you sleep, you begin to have a strange dream ...");
    sleep_lev = curr_lev;
    goto_new_lev(2);
    print_room = 1;
  }
}

void do_wake(void)
{
  if(cmd.nn!=o_math && cmd.nn>0) not_work();
  else if(!InDreamWorld(curr_loc))
    Wrap("Reality is not a fragment of nightmares and dreams.");
  else if(cmd.nn!=o_math)
  {
    puts("Wow, that was some dream.");
    goto_new_lev(sleep_lev);
    print_room = 1;
  }
  else
  {
    if(!ObjInRoom(o_theorem))
      Wrap("He mumbles: bother me not, I'm contemplating the ultimate question");
    else
    {
      Wrap("He wakes up, looks at the theorem, an shouts:\
 Eureka!\nThis proves that the universe doesn't exis...");
      goto_new_loc(35);
      print_room = 1;
      mi = mi | 4;
    }
  }
}

void do_give(void)
{
 int nn;
  v_word noun;
  nn = InputNoun("To whom? ", noun);
  if(!nn) not_work();
  else if(!ObjIsPresent(nn)) not_yet();
  else if(nn==o_math)
  {
    if(cmd.nn==o_theorem)
    {
      DropObj(cmd.nn);
      cmd.nn=o_math;
      do_wake();
    }
    else Wrap("He mumbles: disturb me not with such unimportant things.");
  }
  else if(nn==o_plant)
  {
    if(cmd.nn==o_liquid) how();
    else if(cmd.nn==o_solid) Wrap("Plants don't eat solid nutrients.");
    else puts("The being doesn't need that.");
  }
  else not_work();
}

int stack_say(char *s)
{
  puts("Stack:");
  if(*s)  Wrap(s);
 return(1);
}

void do_scan(void)
{
 char *s;
 int flag;
  s = "stack potential non-zero, pushing allowed.";
  flag = 0;
  if(!ObjOnPlayer(o_stack)) PrintMsg(7);
  else if(gp)
  {
    Wrap("Something has rendered the stack inoperative.");
    return;
  }
  else if(cmd.nn==0)
  {
    if(InMirrorWorld(curr_loc)||InMathWorld(curr_loc)||
        InSpectralWorld(curr_loc))
      flag = stack_say("Stack level non-zero, popping allowed.");
    if(curr_loc<=3) flag = stack_say(s);
    if(curr_loc==18) flag = stack_say("Magnetic field present.");
    if(curr_loc==obj[o_plant].loc) flag = stack_say("Sonic harmony present.");
    if(!flag) stack_say("Nothing special to report.");
  }
  else
  {
    stack_say("");
    switch (cmd.nn)
    {
      case o_mirror:
      case o_crt:
      case o_hole: Wrap(s);break;
      case o_plant:
        if(!wa) Wrap("4-D. dehydrated. Weak audio output.");
        else Wrap("4-D. healthy. Strong audio output.");
        break;
      case o_stack: puts("Stack operational.");break;
      case o_audio:
        if(!af) puts("No filter.");
        else puts("Filter active.");
        break;
      case o_pills: puts("Edible. Barbiturate.");break;
      case o_fluid: Wrap("Extremely cold. Superconductive. Superfluid.");break;
      case o_prism: puts("Brittle. Light sensitive.");break;
      case o_coil: Wrap("Composition = yttrium, barium, copper, oxygen.");
        if(cc)
        {
          puts("Stack: properties = ");
          if(cc & 1) puts("superconductive.  ");
          if(cc & 2) puts("magnetic.  ");
          if((cc & 3)==3) puts("Strong magnetic field present.");
        }
        break;
      case o_plasma: puts("Extremely hot.");break;
      case o_solid: puts("4-D. Solid."); break;
      case o_liquid: puts("4-D. Liquid.");break;
      case o_tetra: puts("Color sensitive. Omni-stable.");break;
      default: puts("Nothing special to report.");break;
    } /* switch */
  } /* else */
}

void do_solve(void)
{
 int nn;
  v_word noun;
  if(cmd.nn==o_zeta)
  {
    nn = InputNoun("With what? ", noun);
    if(!nn) not_work();
    else if(!ObjIsPresent(nn)) not_yet();
    else if(nn!=o_func)
      Wrap("Not difficult, although for someone like you it's still too hard.");
    else
    {
      Wrap("The function and the integral cancel out\
 nicely and everything is reduced to a singularity.");
      ReplaceObj(cmd.nn, o_sing);
      JunkObj(o_func);
    }
  }
  else if(cmd.nn==o_func)
    Wrap("You are not really into great episodes of frustration.");
  else if(cmd.nn==o_improb)
    Wrap("It's improbable that you can solve it.");
  else not_work();
}

void do_think(void)
{
  if(!InDreamWorld(curr_loc)) puts("Therefore you are.");
  else if(curr_loc!=25)
    Wrap("This is not a good place to think.");
  else if(!ti)
  {
    puts("You thought of an idea.");
    CarryObj(o_idea);
    ti = 1;
  }
  else puts("You are out of ideas.");
}

void do_burn(void)
{
  if(!ObjIsPresent(o_plasma)) not_yet();
  else puts("Don't be a pyromaniac.");
}

void do_evap(void)
{
  if(!ObjIsPresent(o_plasma)) not_yet();
  else if(cmd.nn==o_fluid)
  {
    puts("The fluid evaporates.");
    JunkObj(cmd.nn);
  }
  else do_burn();
}

void do_climb(void)
{
  if(cmd.nn==o_plant)
    Wrap("That isn't very polite, and besides, it's not a beanstalk.");
  else if(cmd.nn==o_mount)
    Wrap("There are no rivers on the mountain.");
  else not_poss();
}

void do_cut(void)
{
  switch(cmd.nn)
  {
    case o_prism: puts("It's already pre-cut.");break;
    case o_tetra:
      Wrap("It is easily cut, but the cuts immediately reseal themselves.");
      break;
    case o_strip:
      Wrap("With some tricky cuts, you end up with a mobius strip again.");
      break;
    case o_bottle:
      Wrap("The bottle breaks into a mobius strip.");
      ReplaceObj(cmd.nn, o_strip);
      if(obj[o_liquid].loc==-8)
      {
        Wrap("The liquid in the bottle falls to the ground.");
        DropObj(o_liquid);
        if(curr_loc==obj[o_plant].loc)
        {
          cmd.nn=o_plant;
          do_water();
        }
      }
      break;
    case o_plant:
    case o_solid:
    case o_liquid: Wrap("Such low dimension cuts has no effect.");break;
    default: not_work();
  }
}

void do_join(void)
{
  if(cmd.nn==o_group) puts("You're too finite.");
  else not_poss();
}

void do_sing(void)
{
  if(curr_loc==obj[o_plant].loc)
    Wrap("Your singing can't possible compete with the hyper-melody.");
  else not_happen();
}

void DoCommand(void)
{
  if(cmd.vn<=6 || (cmd.vn>=39 && cmd.vn<=48) ||
     cmd.vn==50 || cmd.vn==52 || cmd.vn==58) goto branch; // Single verbs
  if(obj[cmd.nn].loc==-9)
  {
    Wrap("Be more specific in naming the object");
    return;
  }

  if(!ObjIsPresent(cmd.nn))
  {
    puts("That object is not here.");
    return;
  }

branch:
  switch (cmd.vn)
  {
    case 1:
    case 2:
    case 3:
    case 4: do_dir();break;
    case 5: do_inv();break;
    case 6: do_go();break;
    case 7: do_get();break;
    case 8: do_drop();break;
    case 9: do_throw();break;
    case 10: do_break();break;
    case 11: do_look();break;
    case 12: do_read();break;
    case 13: do_use();break;
    case 14: do_touch();break;
    case 15: do_swing();break;
    case 16: do_rub();break;
    case 17: do_push();break;
    case 18: do_pop();break;
    case 19: do_spin();break;
    case 20: do_roll();break;
    case 21: do_wear();break;
    case 22: do_eat();break;
    case 23: do_taste();break;
    case 24: do_drink();break;
    case 25: do_remove();break;
    case 26: do_water();break;
    case 27: do_fill();break;
    case 28: do_pour();break;
    case 29: do_freeze();break;
    case 30: do_melt();break;
    case 31: do_play();break;
    case 32: do_insert();break;
    case 33: do__y_();break;
    case 34: do_prove();break;
    case 35: do_fix();break;
    case 36: do_smell();break;
    case 37: do_close();break;
    case 38: do_open();break;
    case 39: do_stop();break;
    case 40: do_say();break;
    case 41: do_quit();break;
    case 42: do_help();break;
    case 43: do_listen();break;
    case 44: do_save();break;
    case 45: do_load();break;
    case 46: do_score();break;
    case 47: do_sleep();break;
    case 48: do_wake();break;
    case 49: do_give();break;
    case 50: do_scan();break;
    case 51: do_solve();break;
    case 52: do_think();break;
    case 53: do_burn();break;
    case 54: do_evap();break;
    case 55: do_climb();break;
    case 56: do_cut();break;
    case 57: do_join();break;
    case 58: do_sing();break;
    default: printf("I don't know how to %s.",cmd.verb);
  }
}

void Ending(int n)
{
  switch (n)
  {
    case 1: puts("Game Over");break;
    case 2: puts("Incorrect password.");beep(3);
      Wrap("Self-destruct aborted.  Resuming Doomsday\
 countdown.\n5-4-3-2-1...Earth destro...");
      break;
    case 3: puts("Correct password.");beep(3);
      Wrap("Self-destruct sequence completed. Overriding\
 Doomsday countdown.\n5-4-3-2-1...Kaboom...");
      if(!ObjIsPresent(24))
      {
        beep(0);
        Wrap("The Doomsday complex is destroyed. You\
 have given your life to save Earth. Thank you.");
      }
      else
      {
        beep(0);
        Wrap("As the complex disintegrates around you, the stack, sensing your\
 danger, overloads all it's circuits to regain a moment's control.\
 With a final burst of energy, the stack implodes, projecting a\
 stasis field around you that protects you from the destruction...");
        more();
        Wrap("From the smoldering debris of the Doomsday complex you pick\
 up the pieces of the stack and reflect on how as you risked your life to\
 save Earth, the stack has given its own to save yours.  As you walk away,\
 you solemnly swear to repair the stack, for the adventures that lie ahead.");
        more();
      }
      break;
  }
}

void intro1(void)
{
  puts("-----------------------------");
  puts("   Beyond The Tesseract   V2.0p");
  puts("-----------------------------");
  Wrap("An abstract text adventure by\nDavid Lo\n4516 Albert St.\nBurnaby, B.C.\
 V5C 2G5  Canada\nemail: viola@idacom.cs.ubc.ca\nThis is FreeShareAnythingWare.\
 If you like this program or hate it. I would be happy to hear from you.");
  more();

//  Wrap("               /*--------------/* ");
//  Wrap("             /  '            /  '");
//  Wrap("           /   '|          /   '|");
//  Wrap("        */----'---------*/    ' |");
//  Wrap("       '|    '  |      '|    '  |");
//  Wrap("      ' |   '   |     ' |   '   |");
//  Wrap("     '  |  '   /*----'--|--'---/*");
//  Wrap("    '   | '  /  '   '   | '  /  '");
//  Wrap("   '    |' /   '   '    |' /   '");
//  Wrap("  '    /*/----'---'----/*/    '");
//  Wrap(" '   /  '    '   '   /  '    '");
//  Wrap("'  /   '|   '   '  /   '|   '");
//  Wrap("*/----'----'----*/    ' |  '");
//  Wrap("|    '  | '     |    '  | '");
//  Wrap("|   '   |'      |   '   |'");
//  Wrap("|  '   /*-------|--'---/*");
//  Wrap("| '  /          | '  /");
//  Wrap("|' /            |' /");
//  Wrap("*/--------------*/");
}

void intro(void)
{
 int i,j,k;
  intro1();
  Wrap("Scenario:\nYou have reached the final part of your mission. You\
 have gained access to the complex, and all but the last procedure has\
 been performed. Now comes a time of waiting, in which you must search\
 for the hidden 12-word message that will aid you at the final step.\
 But what choice will you make when that time comes?");
  more();
  Wrap("Instructions:\nStandard commands for moving N,E,S,W, inventory I,\
 manipulating objects GET DROP LOOK and saving games SAVE LOAD are\
 recognized as well as many others. Use 2-word 'verb noun' commands, such as 'use\
 stack' or 'get all'. Only the first 4 letters of a word are significant.\
 The adventure recognizes about 200 words.");
  more();
  srand(clock());  // srand(i*i + j + k);
}


