/*
  Beyond The Tesseract
    - adventure world definition
*/

#define MaxLocs 36      /* # rooms */
#define MaxObjs 54      /* # objects */
#define MaxDirs 4       /* only 4 directions used (N E S W) */

/*----------------------------*/
/* Location
*/
#define north 0
#define east  1
#define south 2
#define west  3
#define up    4
#define down  5

typedef struct   /* room information */
{
 char *name;          /* description of the room */
 int link[MaxDirs]; /* room connections: north, east, south, west */
}room_type;


//room_type room [MaxLocs] = {
room_type room[] = {
 {"in the adventure storage room",{0,0,0,0}},
 {"in a green house",{0,0,2,7}},
 {"in a researcher's office",{1,0,0,8}},
 {"on the contradicting premises of a deduction",{5,0,0,0}},
 {"in a mirrored hall",{0,11,9,10}},
 {"at the origin",{14,16,3,15}},
 {"in a spectral vortex",{0,0,19,0}},   
 {"in a library",{0,1,8,0}},    
 {"in a cryogenic lab",{7,2,0,0}},    
 {"in a glass sphere",{4,0,0,0}},
 {"in a hall of mirrors",{12,4,0,0}},
 {"in a mirror hallway",{13,0,0,4}},
 {"in a chamber of crystal",{0,0,10,0}},
 {"in a transparent vault",{0,0,11,0}},
 {"at the infinite point",{0,0,5,0}},     
 {"in a set of all sets that's not a member of itself",{0,5,0,0}},
 {"by a field of absolute certainty",{0,0,0,5}},
 {"in n-dimensional space",{0,0,0,16}},   
 {"in an ocean of magnetic monopoles",{0,19,21,0}},
 {"in a sea of radio frequencies",{6,20,22,18}},
 {"in an ionic storm",{0,0,0,19}},
 {"in a scintillating shower of light",{18,22,0,0}},  
 {"in a chromatic whirlpool of infrared to ultraviolet",{19,0,0,21}},
 {"in inner space",{0,24,26,0}},  
 {"at the outer limits",{0,25,0,23}},
 {"in the twilight of thought",{0,0,28,24}},
 {"beyond the edge of forever",{23,27,0,0}},  
 {"at the brink of time",{0,28,0,26}},  
 {"in the shadow of tomorrow",{25,0,0,27}},  
 {"in an alien atheneum",{30,0,0,0}},    
 {"in the dimensia chamber",{0,0,29,0}},
 {"in point-land",{0,0,29,0}},   
 {"in line-land",{0,0,29,0}},   
 {"in plane-land",{0,0,29,0}},   
 {"in sphere-land",{0,0,29,0}},    
 {"in an abyss of non-existence. Shadows spellout 'Reasons and Answers'",{0,0,0,0}} };

/*----------------------------*/
/* objects
*/
typedef struct  /* object information */
{
 char *name;    /* name of object */
 int init_loc,  /* initial location */
         attr,  /* attribute:  b0=get  (b1=check in get)  b2=look  */
          loc;  /* current location */
}object_type;

object_type obj [MaxObjs] = {
 {"",0,0,0}, {"north",0,0,0}, {"east",0,0,0}, {"south",0,0,0}, {"west",0,0,0},
 {"inventory",0,0,0},
 {"a large circular reflector",1,4,0},
 {"a CRT",2,4,0},
 {"a hyper-plant-being",9,6,0},
 {"a group",14,6,0},
 {"a hole in the argument",3,4,0},
 {"a dimension projector",30,4,0},
 {"some buttons",-9,4,0},
 {"zero",-7, 0, 0},
 {"one",-7, 0, 0},
 {"two",-7, 0, 0},
 {"three",-7, 0, 0},
 {"four",-7, 0, 0},
 {"fractal",-9, 0, 0},
 {"chaos",31, 4, 0},
 {"some Fatou dust",32, 4, 0},
 {"a von Koch snowflake",33, 4, 0},
 {"Mount Mandelbrot",34, 4, 0},
 {"a tombstone",34, 4, 0},
 {"a stack",-1, 5, 0},
 {"an audio transmutator",11, 5, 0},
 {"a book",7, 5, 0},
 {"some Z-pills",8, 1, 0},
 {"a pool of bubbling fluid",8, 2, 0},
 {"a Klein bottle",0, 5, 0},
 {"a prism",12, 5, 0},
 {"a _y_ing apparatus",13, 5, 0},
 {"an infinite improbability",15, 7, 0},
 {"a mobius strip",5, 1, 0},
 {"a Riemann zeta integral",17, 5, 0},
 {"a hexahedron",18, 5, 0},
 {"a ceramic coil",19, 5, 0},
 {"plasma",20, 3, 0},
 {"a 4-D solid",0, 1, 0},
 {"some 4-D liquid",0, 3, 0},
 {"a singularity",0, 5, 0},
 {"an image disk",29, 5, 0},
 {"a supposition",24, 5, 0},
 {"an hypothesis",28, 5, 0},
 {"a lemma",0, 5, 0},
 {"a theorem",0, 5, 0},
 {"an axiom",27, 5, 0},
 {"a postulate",23, 5, 0},
 {"a meditating mathematician",26, 4, 0},
 {"a crystal tetrahedron", 0, 5, 0},
 {"a non-differentiable function", 14, 5, 0},
 {"an idea", 0, 5, 0},
 {"a contradiction",0, 5, 0},
 {"a warranty",29, 5, 0}
};

/* constants to refer to objects by
*/
#define o_nothing 0
#define o_north 1
#define o_east 2
#define o_south 3
#define o_west 4
#define o_invent 5
#define o_mirror 6
#define o_crt 7
#define o_plant 8
#define o_group 9
#define o_hole 10
#define o_proj 11
#define o_buttons 12
#define o_zero 13
#define o_one 14
#define o_two 15
#define o_three 16
#define o_four 17
#define o_fractal 18
#define o_chaos 19
#define o_dust 20
#define o_flake 21
#define o_mount 22
#define o_tomb 23
#define o_stack 24
#define o_audio 25
#define o_book 26
#define o_pills 27
#define o_fluid 28
#define o_bottle 29
#define o_prism 30
#define o_appa 31
#define o_improb 32
#define o_strip 33
#define o_zeta 34
#define o_cube 35
#define o_coil 36
#define o_plasma 37
#define o_solid 38
#define o_liquid 39
#define o_sing 40
#define o_disk 41
#define o_supp 42
#define o_hypo 43
#define o_lemma 44
#define o_theorem 45
#define o_axiom 46
#define o_post 47
#define o_math 48
#define o_tetra 49
#define o_func 50
#define o_idea 51
#define o_contra 52
#define o_warr 53

/*----------------------------*/
/* vocabulary
*/
typedef struct         /* vocabulary word */
{
 char *name;           /* word used */
 int num;              /* which object it corresponds to */
} vocab_type;

 /* start w/blank string, end w/null string */
vocab_type v_noun [] = {
 {"    ",0},
 {"n   ",1},{"nort",1},
 {"e   ",2},{"east",2},
 {"s   ",3},{"sout",3},
 {"w   ",4},{"west",4},
 {"i   ",5},{"inve",5},{"inv ",5},{"all ",5},
 {"refl",6},{"mirr",6},
 {"crt ",7},{"scre",7},{"tube",7},
 {"plan",8},{"bein",8},{"alie",8},
 {"grou",9},
 {"hole",10},
 {"proj",11},
 {"butt",12},
 {"zero",13},{"0   ",13},
 {"one ",14},{"1   ",14},
 {"two ",15},{"2   ",15},
 {"thre",16},{"3   ",16},
 {"four",17},{"4   ",17},
 {"frac",18},
 {"chao",19},
 {"dust",20},{"fato",20},
 {"snow",21},{"flak",21},{"koch",21},
 {"moun",22},{"mt  ",22},{"mand",22},
 {"tomb",23},{"epit",23},
 {"stac",24},{"key ",24},
 {"audi",25},{"tran",25},{"earp",25},
 {"book",26},{"adve",26},
 {"pill",27},{"z-pi",27},{"z   ",27},
 {"pool",28},{"flui",28},
 {"klei",29},{"bott",29},
 {"pris",30},
 {"_y_ ",31},{"appa",31},{"y   ",31},
 {"impr",32},{"hear",32},{"gold",32},
 {"mobi",33},{"stri",33},{"moeb",33},
 {"riem",34},{"zeta",34},{"inte",34},
 {"hexa",35},{"cube",35},{"die ",35},{"dice",35},
 {"coil",36},{"cera",36},{"loop",36},
 {"plas",37},
 {"soli",38},{"tess",38},
 {"liqu",39},
 {"sing",40},{"band",40},{"filt",40},
 {"disk",41},{"disc",41},
 {"supp",42},
 {"hypo",43},
 {"lemm",44},
 {"theo",45},
 {"axio",46},
 {"post",47},{"prof",47},
 {"math",48},
 {"crys",49},{"tetr",49},{"pyra",49},
 {"func",50},
 {"idea",51},
 {"cont",52},
 {"warr",53},{"guar",53},
 {"",0} };

vocab_type v_verb[] = {
 {"    ",0},
 {"nort",1},{"n   ",1},
 {"east",2},{"e   ",2},
 {"sout",3},{"s   ",3},
 {"west",4},{"w   ",4},
 {"inve",5},{"i   ",5},
 {"go  ",6},
 {"get ",7},{"take",7},{"grab",7},{"g   ",7},
 {"drop",8},{"leav",8},
 {"thro",9},{"toss",9},
 {"brea",10},{"hit ",10},{"kill",10},{"figh",10},{"kick",10},{"atta",10},
 {"look",11},{"exam",11},{"l   ",11},
 {"read",12},
 {"use ",13},{"util",13},{"appl",13},
 {"touc",14},{"feel",14},
 {"swin",15},{"wave",15},{"shak",15},
 {"rub ",16},{"pres",17},{"push",17},
 {"pop ",18},
 {"spin",19},{"turn",19},{"rota",19},{"twis",19},{"flip",19},
 {"roll",20},
 {"wear",21},
 {"eat ",22},{"swal",22},
 {"tast",23},
 {"drin",24},
 {"remo",25},
 {"wate",26},{"wet ",26},{"wash",26},{"hydr",26},
 {"fill",27},
 {"pour",28},{"empt",28},
 {"free",29},{"cool",29},
 {"melt",30},
 {"play",31},{"star",31},
 {"inse",32},{"put ",32},
 {"_y_ ",33},{"y   ",33},
 {"prov",34},{"veri",34},{"deve",34},
 {"fix ",35},{"repa",35},
 {"smel",36},
 {"clos",37},
 {"open",38},
 {"stop",39},
 {"say ",40},{"spea",40},
 {"quit",41},
 {"help",42},
 {"list",43},{"hear",43},
 {"save",44},
 {"load",45},
 {"scor",46},
 {"slee",47},{"drea",47},
 {"wake",48},
 {"give",49},
 {"scan",50},{"sc  ",50},
 {"eval",51},{"solv",51},{"diff",51},
 {"thin",52},{"pond",52},{"medi",52},
 {"burn",53},{"igni",53},{"heat",53},
 {"evap",54},{"vapo",54},
 {"clim",55},
 {"cut ",56},{"slic",56},{"stab",56},
 {"join",57},
 {"sing",58},
 {"",0}
};

int num_verbs=sizeof(v_verb)/sizeof(vocab_type),
    num_nouns=sizeof(v_noun)/sizeof(vocab_type);

