/* (c) Copyright 1987 Michael Goetz								*/
/*																			*/
/*				File:		  	keysort									*/
/*				Returns:	  												*/
/*				Parameters:												*/
/*																			*/
/*																			*/

#include <stdio.h>
#include <string.h>
#include <search.h>

#include "advm.h"

struct key {
	int key1,key2,rptr;
	unsigned char bptr;
	};
	
void ksort(char *);
int compare(struct key *, struct key *);
void keyrd(char *);
void keywr(char *);


struct key keys [2500];

int maxkey;

main()

{
	printf ("\nBegin Pass 3 (KEYSORT)\n\n");
	ksort("advi");
	ksort("advt");
	exit(0);
}

void ksort(file)
char *file;

{
	char infile[20], outfile[20];

	strcpy(infile,file);
	strcat(infile,".key");
	strcpy(outfile,file);
	strcat(outfile,".ptr");

	keyrd(infile);
	qsort((char *)keys, maxkey+1, sizeof(keys[0]), compare);
	keywr(outfile);
}

int compare(i1, i2)
struct key *i1, *i2;

{
	if (i1->key2 == i2->key2)
		return (i1->key1 - i2->key1);
	else
		return (i1->key2 - i2->key2);
}

void keyrd(file)
char *file;

{
	int key1[18],key2[18],rptr[18];
	unsigned char bptr[18];
	int i;
	FILE *f;

	maxkey = -1;
	f = fopen(file, "rb");
	while (TRUE)
		{
		int pad;

		fread((char *)key1, 1, sizeof(key1), f);
		fread((char *)key2, 1, sizeof(key2), f);
		fread((char *)rptr, 1, sizeof(rptr), f);
		fread(bptr, 1, sizeof(bptr), f);
		fread((char *)&pad, 1, 2, f);

		for (i=0; i<18; i++)
			{
			if (key1[i] == -1)
				{
				fclose(f);
				return;
				}
			if (maxkey+1 >= 2500)
				{
				printf("\nToo many keys in file %s\n\n Aborting\n",file);
				exit(1);
				}
			keys[++maxkey].key1 = key1[i];
			keys[maxkey].key2 = key2[i];
			keys[maxkey].rptr = rptr[i];
			keys[maxkey].bptr = bptr[i];
			}
		}
}

void keywr(file)
char *file;

{
	FILE *f;
	int i,ptr;
	int key1[18],key2[18],rptr[18];
	unsigned char bptr[18];
	int pad = 0;

	f = fopen(file, "wb");
	for (i=0, ptr=0; i<=maxkey; i++)
		{
		key1[ptr] = keys[i].key1;
		key2[ptr] = keys[i].key2;
		rptr[ptr] = keys[i].rptr;
		bptr[ptr] = keys[i].bptr;
		if (++ptr == 18)
			{
			ptr = 0;
			fwrite((char *)key1, 1, sizeof(key1), f);
			fwrite((char *)key2, 1, sizeof(key2), f);
			fwrite((char *)rptr, 1, sizeof(rptr), f);
			fwrite(bptr, 1, sizeof(bptr), f);
			fwrite((char *)&pad, 1, 2, f);
			}
		}
	key1[ptr] = key2[ptr] = -1;
	fwrite((char *)key1, 1, sizeof(key1), f);
	fwrite((char *)key2, 1, sizeof(key2), f);
	fwrite((char *)rptr, 1, sizeof(rptr), f);
	fwrite(bptr, 1, sizeof(bptr), f);
	fwrite((char *)&pad, 1, 2, f);
	fclose(f);
}


