/* (c) Copyright 1987 Michael Goetz								*/
/*																			*/
/*				File:		  	eval										*/
/*				Returns:	  	int										*/
/*				Parameters:	char *ztext								*/
/*																			*/
/*																			*/

#include <ctype.h>
#include <stdio.h>

#include "advm.h"
#include "string.h"
#include "values.h"
#include "find.h"
#include "snapit.h"


int eval (ztext)
char *ztext;

{
	int val = 0, start = 0, sign = 1, i, j;
	int bitphr = FALSE;
	int nxtsgn, term;
	int len = strlen(ztext);
	char temp [141];

	if (ztext[0] == '&')
		{
		bitphr = TRUE;
		start++;
		}
	while (start < len)
		{
		nxtsgn = 1;
		term = 0;
		i = start;
		if (ztext[i] != '-')
			{
			for (; i<len; i++)
				if (ztext[i] == '+' || ztext[i] == '-')
					break;
			strncpy(temp,ztext+start,i-start);
			temp[i-start] = 0;
			term = find(temp);
			if (term >= 0)
				{
				zunref[term] = ' ';
				term = (ztext[start] == '@') ? auxval[term] : keys[term];
				}
			else	/* 50 */
				{
				term = 0;
				if (isdigit(ztext[start]))
					{
					for (j=start; j<i; j++)
						{
						if (isspace(ztext[j]))
							break;
						if (isdigit(ztext[j]))
							{
							term = 10*term + ztext[j]-'0';
							continue;
							}
						snapit();
						printf("--Bad number: %.*s\n", i-start, ztext+start);
						troubl = TRUE;
						term = 0;
						}
					}
				else /* 100 */
					{
					snapit();
					printf("--Undefined symbol: %.*s\n",i-start, ztext+start);
					troubl = TRUE;
					}
				}
			}
		/* 200 */
		start = i+1;
		if (i <= len && ztext[i] == '-')
			nxtsgn = -1;
		if (bitphr)
			term = 1 << term;
		val += term*sign;
		sign = nxtsgn;
		}
	return (val);
}
