/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.msv.datatype.xsd.Base64BinaryType;
import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.ByteType;
import com.sun.msv.datatype.xsd.DateTimeType;
import com.sun.msv.datatype.xsd.DateType;
import com.sun.msv.datatype.xsd.DoubleType;
import com.sun.msv.datatype.xsd.FloatType;
import com.sun.msv.datatype.xsd.HexBinaryType;
import com.sun.msv.datatype.xsd.IntType;
import com.sun.msv.datatype.xsd.IntegerType;
import com.sun.msv.datatype.xsd.LongType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.ShortType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.TimeType;
import com.sun.msv.datatype.xsd.XmlNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();

    protected DatatypeConverterImpl() {
    }

    public String parseString(String lexicalXSDString) {
        return lexicalXSDString;
    }

    public BigInteger parseInteger(String lexicalXSDInteger) {
        return IntegerType.load(lexicalXSDInteger);
    }

    public int parseInt(String lexicalXSDInt) {
        return IntType.load(lexicalXSDInt);
    }

    public long parseLong(String lexicalXSLong) {
        return LongType.load(lexicalXSLong);
    }

    public short parseShort(String lexicalXSDShort) {
        return ShortType.load(lexicalXSDShort);
    }

    public BigDecimal parseDecimal(String lexicalXSDDecimal) {
        return NumberType.load(lexicalXSDDecimal);
    }

    public float parseFloat(String lexicalXSDFloat) {
        return FloatType.load(lexicalXSDFloat).floatValue();
    }

    public double parseDouble(String lexicalXSDDouble) {
        return DoubleType.load(lexicalXSDDouble);
    }

    public boolean parseBoolean(String lexicalXSDBoolean) {
        return BooleanType.load(lexicalXSDBoolean);
    }

    public byte parseByte(String lexicalXSDByte) {
        return ByteType.load(lexicalXSDByte);
    }

    public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        String uri = null;
        String localPart = null;
        int first = lexicalXSDQName.indexOf(58);
        if (first <= 0) {
            uri = this.resolveNamespacePrefix("", nsc);
            localPart = lexicalXSDQName;
        } else {
            String prefix = lexicalXSDQName.substring(0, first);
            localPart = lexicalXSDQName.substring(first + 1);
            uri = this.resolveNamespacePrefix(prefix, nsc);
        }
        if (uri == null) {
            return null;
        }
        if (!XmlNames.isUnqualifiedName(localPart)) {
            return null;
        }
        return new QName(uri, localPart);
    }

    private String resolveNamespacePrefix(String prefix, NamespaceContext nsc) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return nsc.getNamespaceURI(prefix);
    }

    public Calendar parseDateTime(String lexicalXSDDateTime) {
        return (Calendar)DateTimeType.theInstance.createJavaObject(lexicalXSDDateTime, null);
    }

    public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return Base64BinaryType.load(lexicalXSDBase64Binary);
    }

    public byte[] parseHexBinary(String lexicalXSDHexBinary) {
        return HexBinaryType.load(lexicalXSDHexBinary);
    }

    public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return LongType.load(lexicalXSDUnsignedInt);
    }

    public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return IntType.load(lexicalXSDUnsignedShort).shortValue();
    }

    public Calendar parseTime(String lexicalXSDTime) {
        return (Calendar)TimeType.theInstance.createJavaObject(lexicalXSDTime, null);
    }

    public Calendar parseDate(String lexicalXSDDate) {
        return (Calendar)DateType.theInstance.createJavaObject(lexicalXSDDate, null);
    }

    public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return lexicalXSDAnySimpleType;
    }

    public String printString(String val) {
        return val;
    }

    public String printInteger(BigInteger val) {
        return IntegerType.save(val);
    }

    public String printInt(int val) {
        return IntType.save(new Integer(val));
    }

    public String printLong(long val) {
        return LongType.save(new Long(val));
    }

    public String printShort(short val) {
        return ShortType.save(new Short(val));
    }

    public String printDecimal(BigDecimal val) {
        return NumberType.save(val);
    }

    public String printFloat(float val) {
        return FloatType.save(new Float(val));
    }

    public String printDouble(double val) {
        return DoubleType.save(new Double(val));
    }

    public String printBoolean(boolean val) {
        return BooleanType.save(new Boolean(val));
    }

    public String printByte(byte val) {
        return ByteType.save(new Byte(val));
    }

    public String printQName(QName val, NamespaceContext nsc) {
        String qname2 = null;
        String prefix = nsc.getPrefix(val.getNamespaceURI());
        String localPart = val.getLocalPart();
        qname2 = prefix == null ? localPart : prefix + ":" + localPart;
        return qname2;
    }

    public String printDateTime(Calendar val) {
        return DateTimeType.theInstance.serializeJavaObject(val, null);
    }

    public String printBase64Binary(byte[] val) {
        return Base64BinaryType.save(val);
    }

    public String printHexBinary(byte[] val) {
        return HexBinaryType.save(val);
    }

    public String printUnsignedInt(long val) {
        return LongType.save(new Long(val));
    }

    public String printUnsignedShort(int val) {
        return IntType.save(new Integer(val));
    }

    public String printTime(Calendar val) {
        return TimeType.theInstance.serializeJavaObject(val, null);
    }

    public String printDate(Calendar val) {
        return DateType.theInstance.serializeJavaObject(val, null);
    }

    public String printAnySimpleType(String val) {
        return SimpleURType.theInstance.convertToLexicalValue(val, null);
    }

    public static String installHook(String s) {
        DatatypeConverter.setDatatypeConverter(theInstance);
        return s;
    }
}

